/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.Koordinate2D;
import de.geocalc.ggout.Data;
import de.geocalc.ggout.objects.BLATT;
import de.geocalc.ggout.objects.DataElement;
import de.geocalc.ggout.objects.GGElement;
import de.geocalc.ggout.objects.HashElement;
import de.geocalc.ggout.objects.LI;
import de.geocalc.ggout.objects.OList;
import de.geocalc.ggout.objects.PA;
import de.geocalc.ggout.objects.PK;
import de.geocalc.ggout.objects.TE;
import de.geocalc.ggout.objects.TF;
import de.geocalc.ggout.objects.TR;
import de.geocalc.ggout.objects.TX;
import de.geocalc.kafplot.Buchungsstelle;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.GebaeudeKennzeichen;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.Grundbuchblatt;
import de.geocalc.kafplot.KatAmt;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.Name;
import de.geocalc.kafplot.Nutzung;
import de.geocalc.kafplot.NutzungsArt;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktArt;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.Symbol;
import de.geocalc.kafplot.VermarkungsArt;
import de.geocalc.kafplot.io.FortfuehrungIOProperties;
import de.geocalc.kafplot.io.GgOutWriter;
import de.geocalc.kafplot.io.IOProperties;
import de.geocalc.kafplot.io.gg.GGIOProperties;
import de.geocalc.text.IFormat;
import de.geocalc.util.BooleanFilter;
import de.geocalc.util.LongFilter;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;

public class GgRissWriter
extends GgOutWriter {
    public static boolean DIFFER_PNR = false;
    public static boolean DIFFER_LEN = false;
    public static boolean DIFFER_GRE = true;
    private static final int EBENE_GRENZEN = 1;
    private static final int EBENE_RISS = 50;
    private static final int EBENE_OFFSET_NOT_CONTENT = 9000;
    private static final int ART_TEXT_FLUR = 101;
    private static final int ART_TEXT_PNR = 5000;
    private static final int ART_TEXT_PNR_SO = 5060;
    private static final int ART_TEXT_PNR_GP = 5061;
    private static final int ART_TEXT_PNR_BG = 5062;
    private static final int ART_TEXT_PNR_BB = 5063;
    private static final int ART_TEXT_ABM = 5001;
    private static final int ART_TEXT_LENGTH = 5002;
    private static final int ART_TEXT_LEN_SO = 5070;
    private static final int ART_TEXT_LEN_GP = 5071;
    private static final int ART_TEXT_LEN_BG = 5072;
    private static final int ART_TEXT_LEN_BB = 5073;
    private static final int ART_KENN_INS = 5051;
    private static final int ART_KENN_DEL = 5052;
    private static final int ART_EINR_BIG = 5005;
    private static final int ART_EINR_SMALL = 5006;
    private static final int ART_NBZ = 5050;
    private static final int OBJECT_CONTAINER_ART_P = 9001;
    private static final int OBJECT_CONTAINER_ART_L = 9002;
    private static final int OBJECT_CONTAINER_ART_A = 9003;
    private static final int OBJECT_CONTAINER_EBENE = 9000;
    private static final double PNR_SIZE = 0.003;
    private static final double TEXT_Y_REL = 1.0E-4;
    private static final double TEXT_X_REL = 5.0E-4;
    private static final double TEXT_Y_REL_L = 0.001;
    private static final double TEXT_Y_REL_NB = 0.005;
    private static final double TEXT_SIZE_FLUR = 0.005;
    private static final double KENN_INS_ANGLE = 350.0;
    private static final Integer SIZE_SMALL = new Integer(0);
    private static final Integer SIZE_BIG = new Integer(1);
    private static boolean differPnr = DIFFER_PNR;
    private static boolean differLen = DIFFER_LEN;
    private static boolean differGre = DIFFER_GRE;
    private LongFilter pnrFilter;
    private BooleanFilter onFilter;
    Hashtable lineHash;
    Hashtable lineArtHash;
    Hashtable pointSizeHash;
    Hashtable lineSymHash;
    private double xmin = Double.MAX_VALUE;
    private double ymin = Double.MAX_VALUE;
    private double xmax = -1.7976931348623157E308;
    private double ymax = -1.7976931348623157E308;

    public static void setDefaultdifferPnr(boolean bl) {
        DIFFER_PNR = bl;
    }

    public static void setDefaultdifferLen(boolean bl) {
        DIFFER_LEN = bl;
    }

    public static void setDefaultdifferGre(boolean bl) {
        DIFFER_GRE = bl;
    }

    public static void differPnr(boolean bl) {
        differPnr = bl;
    }

    public static void differLen(boolean bl) {
        differLen = bl;
    }

    public static void differGre(boolean bl) {
        differGre = bl;
    }

    public static void setDiffers(KatAmt katAmt) {
        if (katAmt != null) {
            System.out.println("Amt:" + String.valueOf(katAmt) + " > " + katAmt.differPnr + " > " + katAmt.differLen + " > " + katAmt.differGre);
            differPnr = katAmt.differPnr;
            differLen = katAmt.differLen;
            differGre = katAmt.differGre;
        }
    }

    private static int getPnrArt(Punkt punkt) {
        if (differPnr) {
            switch (punkt.getParameter().getModPa()) {
                case 20: 
                case 29: {
                    return 5061;
                }
                case 30: 
                case 39: {
                    return 5062;
                }
                case 40: 
                case 49: {
                    return 5063;
                }
            }
            return 5060;
        }
        return 5000;
    }

    private static int getLenArt(Punkt punkt) {
        if (differLen) {
            switch (punkt.getParameter().getModPa()) {
                case 20: 
                case 29: {
                    return 5071;
                }
                case 30: 
                case 39: {
                    return 5072;
                }
                case 40: 
                case 49: {
                    return 5073;
                }
            }
            return 5070;
        }
        return 5002;
    }

    public GgRissWriter(File file, DataBase dataBase) {
        super(file, dataBase);
        this.lineHash = new Hashtable();
        this.lineArtHash = new Hashtable();
        this.pointSizeHash = new Hashtable();
        this.lineSymHash = new Hashtable();
        try {
            BLATT bLATT = new BLATT();
            bLATT.setContent("RISS", "Riss.art", "Riss.sym", "Riss.pen", "geograf.mde", 500, 0, "", "", "Riss.col");
            this.data.put(bLATT);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void setParameter() {
        super.setParameter();
        this.pnrFilter = (LongFilter)this.punktFilter.getFilter(101);
        this.onFilter = (BooleanFilter)this.punktFilter.getFilter(901);
        differPnr = DIFFER_PNR;
        differLen = DIFFER_LEN;
        differGre = DIFFER_GRE;
        GgRissWriter.setDiffers(KatAmt.getKatAmt(DataBase.katasterAmt));
    }

    @Override
    protected boolean use(Punkt punkt) {
        return this.pnrFilter.isValidValue(punkt.nr) && this.onFilter.isValidValue(punkt.isFortfuehrung());
    }

    @Override
    protected boolean use(Linie linie) {
        return linie.pa != null && linie.pe != null && (this.use(linie.pa) || this.use(linie.pe));
    }

    private int createPunktArt(VermarkungsArt vermarkungsArt, int n) {
        return this.createPunktArt(vermarkungsArt, n, false);
    }

    private int createPunktArt(VermarkungsArt vermarkungsArt, int n, boolean bl) {
        Symbol symbol = vermarkungsArt.getSymbol();
        int n2 = 0;
        if (symbol != null) {
            if (bl) {
                n2 = symbol == Symbol.UV ? 20 : (symbol == Symbol.ST ? 91 : (symbol == Symbol.R ? 92 : (symbol == Symbol.GH ? 24 : (symbol == Symbol.KR ? 25 : (symbol == Symbol.NB ? 26 : (symbol == Symbol.LB ? 27 : (symbol == Symbol.ST_ ? 91 : (symbol == Symbol.R_ ? 92 : 0))))))));
            } else {
                boolean bl2;
                boolean bl3 = bl2 = n < 0;
                n2 = symbol == Symbol.UV ? 20 : (symbol == Symbol.ST ? (bl2 ? 31 : 21) : (symbol == Symbol.R ? (bl2 ? 32 : 22) : (symbol == Symbol.GH ? 24 : (symbol == Symbol.KR ? 25 : (symbol == Symbol.NB ? 26 : (symbol == Symbol.LB ? 27 : (symbol == Symbol.ST_ ? 31 : (symbol == Symbol.R_ ? 32 : 0))))))));
            }
        }
        return n2;
    }

    @Override
    protected void storePunkt(Data data, Punkt punkt) throws Exception {
        int n;
        PK pK = new PK(punkt.buildAlkisNr(true), punkt.y, punkt.x, punkt.h, 0, 0);
        Object object = null;
        String string = null;
        if (IOProperties.isHoeheModus() && punkt.h != 0.0f) {
            pK.setZ(punkt.h);
            pK.setHoeheStatus(3);
        }
        if (punkt.getPs() == 1 || punkt.getPs() == 2 || punkt.isOn()) {
            pK.setHoeheStatus(3);
        }
        pK.setAngle(punkt.getSymbolWinkel() * 63.66197723675813);
        PunktParameter punktParameter = punkt.getParameter();
        int n2 = punktParameter.getKafPa();
        int n3 = punktParameter.getKafLg();
        int n4 = 0;
        int n5 = 0;
        VermarkungsArt vermarkungsArt = VermarkungsArt.getVermarkungsArt(punktParameter.getVa());
        VermarkungsArt vermarkungsArt2 = VermarkungsArt.getVermarkungsArt(punktParameter.getVva());
        if (n2 == 1) {
            if (punkt.isFortfuehrung()) {
                n4 = this.createPunktArt(vermarkungsArt, VermarkungsArt.isVermarkt(punktParameter.getKafVva()) ? 0 : punktParameter.getVvt());
                n4 = punktParameter.getKafEb() == 48 ? (n4 += 4800) : (punkt.isVermarkungGeaendert() ? (n4 += 4800) : (n4 += 100));
                object = vermarkungsArt.getKuerzel();
            } else {
                n4 = 0;
            }
            n5 = punktParameter.getKafEb();
        } else if (n2 == 2) {
            n4 = punktParameter.getKafEb() == 42 ? (punkt.isOn() ? 4220 : 4200) : (punkt.isOn() || punkt.getPst() == 13 ? 220 : 200);
            n5 = punktParameter.getKafEb();
        } else if (n2 == 7) {
            n4 = 1903;
            n5 = 19;
            if (punkt.isFortfuehrung()) {
                object = vermarkungsArt.getKuerzel();
            }
        } else if (n2 == 8) {
            n4 = 1901;
            n5 = 19;
            if (punkt.isFortfuehrung()) {
                object = vermarkungsArt.getKuerzel();
            }
        } else if (n2 != 9) {
            if (n2 == 3) {
                n4 = this.createPunktArt(vermarkungsArt, punktParameter.getVvt()) + (punkt.getInternalPs() == 2 ? 5600 : 5500);
                int n6 = n5 = punkt.getInternalPs() == 2 ? 56 : 55;
                if (punkt.isFortfuehrung()) {
                    object = vermarkungsArt.getKuerzel();
                }
            } else if (n2 == 0) {
                n = punktParameter.getModPa();
                if (n == 91) {
                    n4 = punkt.isOn() ? 4720 : 4700;
                    n5 = 47;
                } else if (n == 92) {
                    n4 = punkt.isOn() ? 320 : 300;
                    n5 = 3;
                } else if (n == 93) {
                    n4 = punkt.isOn() ? 420 : 400;
                    n5 = 4;
                } else if (n == 95) {
                    n4 = this.createPunktArt(vermarkungsArt, punktParameter.getVvt()) + 5500;
                    n5 = 55;
                    if (punkt.isFortfuehrung()) {
                        object = vermarkungsArt.getKuerzel();
                    }
                } else {
                    n4 = punkt.isOn() ? 5520 : 5500;
                    n5 = 55;
                }
            } else {
                n4 = punkt.isOn() ? 5520 : 5500;
                n5 = 55;
            }
        }
        pK.setArt(n4);
        pK.setEbene(n5);
        this.pointSizeHash.put(new Long(punkt.nr), n4 % 10 == 0 ? SIZE_SMALL : SIZE_BIG);
        if (object != null && !VermarkungsArt.isVermarkt(vermarkungsArt2.getKafArt())) {
            if (punktParameter.getVvt() > 0) {
                object = IFormat.f_1.format((double)punktParameter.getVvt() / 10.0) + "\u02fd" + (String)object;
            } else if (punkt.isTiefVermarkt()) {
                object = (String)object + "\u02fd" + IFormat.f_1.format((double)Math.abs(punktParameter.getVvt()) / 10.0);
            }
        }
        if (!punkt.isFortfuehrung()) {
            pK.setEbene(pK.getEbene() + 9000);
        } else if (n2 == 1) {
            if (punktParameter.getKafEb() == 48) {
                pK.addElement(new PA(50, 5051, 350.0));
            } else if (punktParameter.getKafEb() == 1 && punktParameter.getKafVva() > 0) {
                if (punktParameter.getKafVva() == 19) {
                    object = vermarkungsArt2.getKuerzel();
                } else if (punkt.isGezogen()) {
                    pK.setArt(this.createPunktArt(vermarkungsArt2, punktParameter.getVvt()) + 100);
                    pK.addElement(new PA(50, 5052, pK.getAngle()));
                    object = vermarkungsArt2.getKuerzel() + " " + this.formatVvt(punktParameter.getVvt()) + " gezogen";
                    this.pointSizeHash.put(new Long(punkt.nr), SIZE_BIG);
                } else if (punkt.isVermarkungGeaendert()) {
                    pK.addElement(new PA(pK.getEbene(), this.createPunktArt(vermarkungsArt2, 0, true) + 100, pK.getAngle()));
                    if (VermarkungsArt.isVermarkt(vermarkungsArt2.getKafArt())) {
                        string = vermarkungsArt2.getKuerzel() + " " + this.formatVvt(punktParameter.getVvt()) + " aufgef.";
                    }
                    this.pointSizeHash.put(new Long(punkt.nr), SIZE_BIG);
                    pK.addElement(new PA(50, 5051, 350.0));
                } else if (VermarkungsArt.isVermarkt(vermarkungsArt2.getKafArt())) {
                    n = VermarkungsArt.isVermarkt(vermarkungsArt.getKafArt()) ? 1 : 0;
                    pK.addElement(new PA(pK.getEbene(), this.createPunktArt(vermarkungsArt2, 0, n != 0) + 100, pK.getAngle()));
                    string = vermarkungsArt2.getKuerzel() + " " + this.formatVvt(punktParameter.getVvt()) + " aufgef.";
                    this.pointSizeHash.put(new Long(punkt.nr), SIZE_BIG);
                }
            }
        } else if ((n2 == 3 || n2 == 7 || n2 == 8) && punkt.isKatasterNeupunkt()) {
            pK.addElement(new PA(50, 5051, 350.0));
        }
        data.put(pK);
        if (punkt.isFortfuehrung()) {
            Object object2 = punkt.buildAlkisNr(false);
            if (punkt.isMasterPoint() || punkt.isSlavePoint()) {
                object2 = PunktArt.toIdString(punktParameter.getModPa()) + " " + (String)object2;
            }
            TE tE = new TE(null, punkt.y, punkt.x, 100.0, 50, GgRissWriter.getPnrArt(punkt));
            if (punkt.getPst() == 13) {
                tE.setCrossout(true);
            }
            tE.setRelFlags(11);
            tE.setYRel(1.0E-4);
            tE.setXRel(5.0E-4);
            tE.setPosition(object == null && string == null ? 3 : 0);
            if (punkt.isMasterPoint()) {
                tE.setPosition(0);
            } else if (punkt.isSlavePoint()) {
                tE.setPosition(6);
                tE.setYRel(-1.0E-4);
            }
            if (n2 == 7 || n2 == 8) {
                tE.setRahmen(3);
            }
            if (punkt.createKooNb() != punkt.createNb()) {
                tE.addElement(new TX("3" + Punkt.createNbAsString(punkt.createNb())));
            }
            if (punkt.getPst() == 13) {
                tE.setCrossout(true);
            }
            tE.addElement(new TX((String)object2));
            tE.addElement(new TR(pK.getKey()));
            data.put(tE);
            if (object != null) {
                object2 = new TE(null, punkt.y, punkt.x, 100.0, 50, 5001);
                ((TE)object2).setRelFlags(11);
                ((TE)object2).setYRel(-1.0E-4);
                ((TE)object2).setXRel(5.0E-4);
                ((TE)object2).setPosition(6);
                ((OList)object2).addElement(new TX((String)object));
                ((OList)object2).addElement(new TR(pK.getKey()));
                data.put((GGElement)object2);
            }
            if (string != null) {
                object2 = new TE(null, punkt.y, punkt.x, 100.0, 50, 5001);
                ((TE)object2).setRelFlags(11);
                ((TE)object2).setYRel(-0.0031);
                ((TE)object2).setXRel(5.0E-4);
                ((TE)object2).setPosition(6);
                ((OList)object2).addElement(new TX(string));
                ((OList)object2).addElement(new TR(pK.getKey()));
                data.put((GGElement)object2);
            }
        }
        this.setExtends(punkt);
    }

    @Override
    protected void storeLinie(Data data, Linie linie) throws Exception {
        Object object;
        int n;
        Object object2 = linie.getHashKey();
        Object object3 = linie.getArtHashKey();
        if (this.lineArtHash.get(object3) != null) {
            return;
        }
        LI lI = new LI(linie.pa.buildAlkisNr(true), linie.pe.buildAlkisNr(true));
        lI.setRadius1(Math.abs(linie.getKooRadius()));
        if (linie.isBogen()) {
            lI.setRadius2(linie.getRadius() < 0.0 ? -1.0 : 1.0);
        }
        LinieParameter linieParameter = linie.getParameter();
        int n2 = linieParameter.getLa();
        int n3 = Math.max(linieParameter.getEb(), 0);
        int n4 = linieParameter.getSig2();
        if (n2 == 2) {
            n = 0;
            if (n4 == 1104) {
                n = 1;
            } else if (n4 == 1105) {
                n = 2;
            } else if (n4 == 1101) {
                n = 4;
            } else if (n4 == 1107) {
                n = 5;
            } else if (n4 == 1103) {
                n = 6;
            } else if (n4 == 1102) {
                n = 7;
            }
            if (!differGre || linie.isGrundstuecksgrenze()) {
                n += 10;
            }
            lI.setArt(n += n3 == 48 ? 4800 : 100);
        } else if (n2 == 3) {
            lI.setArt(n3 == 42 ? 4200 : 200);
        } else if (n2 == 5) {
            if (this.lineHash.get(object2) != null) {
                return;
            }
            lI.setArt(4700);
        } else if (n2 == 4) {
            lI.setArt(400);
        }
        lI.setEbene(n3);
        n = linie.pa.isFortfuehrung() ? 1 : 0;
        int n5 = linie.pe.isFortfuehrung();
        if (n3 == 48) {
            object = (LI)lI.clone();
            ((LI)object).setArt(5051);
            ((DataElement)object).setEbene(50);
            data.put((GGElement)object);
        }
        if (linie.isUntergang()) {
            object = (LI)lI.clone();
            ((LI)object).setArt(5052);
            ((DataElement)object).setEbene(50);
            data.put(lI);
            data.put((GGElement)object);
        } else if (n == n5) {
            if (n == 0) {
                lI.setEbene(lI.getEbene() + 9000);
            }
            data.put(lI);
            if (linie.pa.getKafLg() <= 3 && linie.pe.getKafLg() <= 3) {
                object = linie.getHashPoint();
                double d = linie.getRichtung() * 63.66197723675813;
                TE tE = new TE(null, ((DPoint)object).y, ((DPoint)object).x, 100.0, 50, GgRissWriter.getLenArt(linie.pa));
                if (n == 0) {
                    tE.setEbene(tE.getEbene() + 9000);
                }
                tE.setPosition(1);
                tE.setAngle(d);
                tE.setRelFlags(283);
                tE.setYRel(0.001);
                if (linie.isBogen()) {
                    if (GGIOProperties.lengthAsFormula()) {
                        tE.addElement(new TF("L=&LL2D()"));
                    }
                    tE.addElement(new TX("L=" + IFormat.f1_2.format(linie.getBogenLaenge())));
                    if (GGIOProperties.lengthAsFormula()) {
                        tE.addElement(new TF("R=&LrR()"));
                    }
                    tE.addElement(new TX("R=" + IFormat.f1_2.format(linie.getRadius())));
                    tE.setPosition(4);
                } else {
                    tE.addElement(new TX(IFormat.f1_2.format(linie.getLaenge())));
                }
                tE.addElement(new TR(lI.getKey(), 4));
                data.put(tE);
            }
        } else {
            int n6;
            object = linie.getHashPoint();
            this.setExtends((DPoint)object);
            String string = this.createKooName((DPoint)object);
            LI lI2 = (LI)lI.clone();
            lI.setName2(string);
            lI2.setName1(string);
            if (n5 != 0) {
                Object object4 = lI.getName1();
                lI.setName1(lI2.getName2());
                lI2.setName2(object4);
            }
            lI2.setEbene(lI.getEbene() + 9000);
            if (this.use(n != 0 ? linie.pa : linie.pe)) {
                data.put(lI);
            }
            if (this.use(n != 0 ? linie.pe : linie.pa)) {
                data.put(lI2);
            }
            if (n4 != 0 && (n6 = lI.getKey()) != 0) {
                this.lineSymHash.put(object3, n6);
            }
        }
        this.lineHash.put(object2, object2);
        this.lineArtHash.put(object3, object3);
    }

    @Override
    protected void storeObjectData(Data data, GObject gObject) throws Exception {
        block18: {
            block17: {
                DataContainer dataContainer;
                Object object;
                boolean bl;
                boolean bl2 = bl = gObject.yt != 0.0 && gObject.xt != 0.0;
                if (!(gObject instanceof Flurstueck)) break block17;
                Flurstueck flurstueck = (Flurstueck)gObject;
                TE tE = new TE(null, bl ? gObject.yt : gObject.y, bl ? gObject.xt : gObject.x, 100.0, flurstueck.isFlagFortfuehrung() ? 1 : 9001, 100);
                tE.setYBez(gObject.x);
                tE.setXBez(gObject.y);
                tE.setPosition(1);
                Object object2 = null;
                if (flurstueck.isTeilstueck()) {
                    object2 = flurstueck.getVorgabeNummer() != null ? flurstueck.getVorgabeNummerAsString() : flurstueck.getTeilAsString();
                    tE.setArt(4800);
                    tE.setEbene(48);
                } else {
                    object2 = flurstueck.getZaehlerAsString();
                    if (flurstueck.getNenner() > 0) {
                        object2 = (String)object2 + "\u02fd" + flurstueck.getNennerAsString();
                    }
                    if (flurstueck.hasTeile()) {
                        tE.setCrossout(true);
                    }
                }
                tE.addElement(new TX((String)object2));
                data.put(tE);
                if (flurstueck.isFlagFortfuehrung()) {
                    TE tE2 = null;
                    if (flurstueck.isTeilstueck()) {
                        tE2 = new TE(null, bl ? gObject.yt : gObject.y, bl ? gObject.xt : gObject.x, 100.0, 48, 4810);
                        tE2.addElement(new TX("Erwerber:"));
                    } else {
                        Enumeration enumeration = flurstueck.buchungen();
                        while (enumeration.hasMoreElements()) {
                            object = (Buchungsstelle)enumeration.nextElement();
                            dataContainer = (Grundbuchblatt)DataBase.BUCH.get(((Buchungsstelle)object).getGrundbuchblattName());
                            if (dataContainer == null) continue;
                            tE2 = new TE(null, bl ? gObject.yt : gObject.y, bl ? gObject.xt : gObject.x, 100.0, 1, 110);
                            Enumeration enumeration2 = dataContainer.elements();
                            while (enumeration2.hasMoreElements()) {
                                Name name = (Name)enumeration2.nextElement();
                                StringBuffer stringBuffer = new StringBuffer(name.getNameAsString());
                                if (name.hasGeburtName()) {
                                    stringBuffer.append(" geb. ");
                                    stringBuffer.append(name.getGeburtName());
                                }
                                tE2.addElement(new TX(stringBuffer.toString()));
                            }
                        }
                    }
                    if (tE2 != null) {
                        tE2.setYBez(gObject.x);
                        tE2.setXBez(gObject.y);
                        tE2.setPosition(7);
                        data.put(tE2);
                    }
                }
                if (!flurstueck.isFortfuehrung() || (!flurstueck.isFlurstueck() || flurstueck.hasTeile()) && !flurstueck.isTeilstueck()) break block18;
                double d = flurstueck.getGeoFlaeche();
                object = flurstueck.intersectObjects(DataBase.NUTZ.elements()).elements();
                while (object.hasMoreElements()) {
                    NutzungsArt nutzungsArt;
                    dataContainer = (Nutzung)object.nextElement();
                    double d2 = ((GObject)dataContainer).getPolygonFlaeche() * DataBase.getFlaecheMasstab(((Nutzung)dataContainer).y);
                    if (!(d2 > FortfuehrungIOProperties.INTERSECT_MIN_ABS) && !(d2 * 100.0 / d > FortfuehrungIOProperties.INTERSECT_MIN_PERC)) continue;
                    int n = ((Nutzung)dataContainer).getArt();
                    DPoint dPoint = ((GObject)dataContainer).getMitte();
                    TE tE3 = new TE(null, dPoint.y, dPoint.x, 100.0, 47, 4700);
                    tE3.setPosition(7);
                    String string = Integer.toString(n);
                    if (GGIOProperties.nutzungAsText() && (nutzungsArt = NutzungsArt.getNutzungsArt(n)) != null) {
                        string = nutzungsArt.getAbkuerzung();
                    }
                    tE3.addElement(new TX("(" + string + ")"));
                    data.put(tE3);
                }
                break block18;
            }
            if (gObject instanceof Gebaeude) {
                Koordinate2D koordinate2D;
                Object object;
                Gebaeude gebaeude = (Gebaeude)gObject;
                if (gebaeude.hasLeitzeichen() && ((GebaeudeKennzeichen)(object = gebaeude.getLeitzeichen())).getLfdNummer() == 0) {
                    koordinate2D = new TE(null, ((GebaeudeKennzeichen)object).y, ((GebaeudeKennzeichen)object).x, 100.0, gebaeude.isFortfuehrung() ? 2 : 9002, 200);
                    ((TE)koordinate2D).setAngle((double)((GebaeudeKennzeichen)object).getAngle() * 63.66197723675813);
                    ((TE)koordinate2D).setPosition(7);
                    ((OList)((Object)koordinate2D)).addElement(new TX(((GebaeudeKennzeichen)object).getInscription()));
                    data.put((GGElement)((Object)koordinate2D));
                }
                if (gebaeude.hasKennzeichen()) {
                    object = gebaeude.kennzeichen();
                    while (object.hasMoreElements()) {
                        koordinate2D = (GebaeudeKennzeichen)object.nextElement();
                        TE tE = new TE(null, ((GebaeudeKennzeichen)koordinate2D).y, ((GebaeudeKennzeichen)koordinate2D).x, 100.0, gebaeude.isFortfuehrung() ? 2 : 9002, 200);
                        tE.setAngle((double)((GebaeudeKennzeichen)koordinate2D).getAngle() * 63.66197723675813);
                        tE.setPosition(7);
                        tE.addElement(new TX(((GebaeudeKennzeichen)koordinate2D).getInscription()));
                        data.put(tE);
                    }
                }
            }
        }
    }

    @Override
    protected void storeSpecial(Data data, DataBase dataBase) throws Exception {
        double d;
        Object object;
        Object object2;
        Comparable<Long> comparable;
        Object object3;
        Cloneable cloneable;
        Object object4 = new Hashtable();
        double d2 = 0.0;
        Enumeration enumeration = dataBase.einrechenMessungen();
        while (enumeration.hasMoreElements()) {
            cloneable = (Messung)enumeration.nextElement();
            int n = ((Messung)cloneable).getMessungsArt();
            if (n == 210) {
                d2 = DLine.getAngle(((Messung)cloneable).ps, ((Messung)cloneable).getReferenz().ps) * 63.66197723675813 + 100.0;
                continue;
            }
            if (n != 200 || (object3 = (PK)data.getObject(((Messung)cloneable).ps.buildAlkisNr(true))) == null) continue;
            comparable = new Long(((Messung)cloneable).ps.nr);
            object2 = (Integer)this.pointSizeHash.get(comparable);
            Integer n2 = (Integer)((Hashtable)object4).get(comparable);
            PA pA = new PA(50, object2 == SIZE_BIG ? 5005 : 5006, d2);
            if (n2 != null) {
                pA.setArt(n2 == SIZE_BIG ? 5006 : 5005);
            } else {
                ((Hashtable)object4).put(comparable, object2 != null ? object2 : SIZE_SMALL);
            }
            ((OList)object3).addElement(pA);
        }
        object4 = new Hashtable();
        Object object5 = DataBase.FLST.elements();
        while (object5.hasMoreElements()) {
            object = (Flurstueck)object5.nextElement();
            enumeration = ((DataContainer)object).elements();
            while (enumeration.hasMoreElements()) {
                Object object6;
                cloneable = (Linie)enumeration.nextElement();
                if (((Linie)cloneable).pe == null || ((Linie)cloneable).getParameter().getSig2() == 0 || (object3 = (Integer)this.lineSymHash.get(object6 = ((Linie)cloneable).getArtHashKey())) == null) continue;
                comparable = (Flurstueck)((Hashtable)object4).get(object6);
                if (comparable == null) {
                    ((Hashtable)object4).put(object6, object);
                    continue;
                }
                if (((Flurstueck)object).getFlur() == ((Flurstueck)comparable).getFlur() && ((Flurstueck)object).getGemarkung() == ((Flurstueck)comparable).getGemarkung()) continue;
                object2 = ((Linie)cloneable).getHashPoint();
                boolean bl = ((GObject)object).getAreaType() == 2;
                cloneable = (Linie)((Linie)cloneable).clone();
                if (!((Linie)cloneable).pa.isFortfuehrung()) {
                    ((Linie)cloneable).skip();
                    bl = !bl;
                }
                boolean bl2 = false;
                double d3 = ((Linie)cloneable).getRichtung() * 63.66197723675813;
                if (d3 < 0.0) {
                    d3 += 200.0;
                    bl2 = true;
                } else if (d3 > 200.0) {
                    d3 -= 200.0;
                    bl2 = true;
                }
                TE tE = new TE(null, ((DPoint)object2).y, ((DPoint)object2).x, 100.0, 1, 101);
                tE.setPosition(bl == bl2 ? 7 : 1);
                tE.setAngle(d3);
                tE.setRelFlags(91);
                tE.setYRel(bl ? -0.001 : 0.001);
                tE.addElement(new TX("Flur " + ((Flurstueck)object).getFlur()));
                tE.addElement(new TR((Integer)object3, 4));
                data.put(tE);
                tE = new TE(null, ((DPoint)object2).y, ((DPoint)object2).x, 100.0, 1, 101);
                tE.setPosition(bl == bl2 ? 1 : 7);
                tE.setAngle(d3);
                tE.setRelFlags(91);
                tE.setYRel(bl ? 0.001 : -0.001);
                tE.addElement(new TX("Flur " + ((Flurstueck)comparable).getFlur()));
                tE.addElement(new TR((Integer)object3, 4));
                data.put(tE);
                if (((Flurstueck)object).getGemarkung() != ((Flurstueck)comparable).getGemarkung()) {
                    Gemarkung gemarkung = Gemarkung.getGemarkung(((Flurstueck)object).getGemarkung());
                    String string = "Gemarkung " + (gemarkung != null ? gemarkung.getName() : IFormat.i06.format(((Flurstueck)object).getGemarkung()));
                    tE = new TE(null, ((DPoint)object2).y, ((DPoint)object2).x, 100.0, 1, 101);
                    tE.setPosition(bl == bl2 ? 7 : 1);
                    tE.setAngle(d3);
                    tE.setRelFlags(91);
                    tE.setYRel(bl ? -0.008 : 0.008);
                    tE.addElement(new TX(string));
                    tE.addElement(new TR((Integer)object3, 4));
                    data.put(tE);
                    gemarkung = Gemarkung.getGemarkung(((Flurstueck)comparable).getGemarkung());
                    string = "Gemarkung " + (gemarkung != null ? gemarkung.getName() : IFormat.i06.format(((Flurstueck)comparable).getGemarkung()));
                    tE = new TE(null, ((DPoint)object2).y, ((DPoint)object2).x, 100.0, 1, 101);
                    tE.setPosition(bl == bl2 ? 1 : 7);
                    tE.setAngle(d3);
                    tE.setRelFlags(91);
                    tE.setYRel(bl ? 0.008 : -0.008);
                    tE.addElement(new TX(string));
                    tE.addElement(new TR((Integer)object3, 4));
                    data.put(tE);
                }
                ((Hashtable)object4).remove(object6);
                this.lineSymHash.remove(object6);
            }
        }
        object4 = DataBase.FLST.elements();
        while (object4.hasMoreElements()) {
            object5 = (Flurstueck)object4.nextElement();
            object = ((Flurstueck)object5).getLageBezeichnungAsString();
            if (!((Flurstueck)object5).isFlagFortfuehrung() || !((Flurstueck)object5).isFlurstueck() || ((String)object).length() <= 0) continue;
            double d4 = ((Flurstueck)object5).getGeoFlaeche();
            double d5 = 0.0;
            Enumeration enumeration2 = ((GObject)object5).intersectObjects(DataBase.NUTZ.elements()).elements();
            while (enumeration2.hasMoreElements()) {
                object2 = (Nutzung)enumeration2.nextElement();
                if (((DataContainer)object2).getOska() < 42001 || ((DataContainer)object2).getOska() > 42016) continue;
                d5 += Math.abs(((GObject)object2).getPolygonFlaeche() * DataBase.getFlaecheMasstab(((Nutzung)object2).y));
            }
            if (!(d4 * 0.5 < d5)) continue;
            boolean bl = ((Flurstueck)object5).yt != 0.0 && ((Flurstueck)object5).xt != 0.0;
            object2 = new TE(null, bl ? ((Flurstueck)object5).yt : ((Flurstueck)object5).y, bl ? ((Flurstueck)object5).xt : ((Flurstueck)object5).x, 100.0, 4, 400);
            ((TE)object2).setYBez(((Flurstueck)object5).x);
            ((TE)object2).setXBez(((Flurstueck)object5).y);
            ((TE)object2).setPosition(4);
            ((OList)object2).addElement(new TX((String)object));
            data.put((GGElement)object2);
        }
        this.xmin -= 500.0;
        this.ymin -= 500.0;
        this.xmax += 500.0;
        this.ymax += 500.0;
        for (d = this.xmin + 1000.0; d < this.xmax; d += 1000.0) {
            double d6 = (int)d / 1000 * 1000;
            for (double d7 = this.ymin; d7 < this.ymax; d7 += 1000.0) {
                double d8 = (int)d7 / 1000 * 1000;
                object2 = new LI(this.createKooName(new DPoint(Math.max(d8, this.ymin), d6)), this.createKooName(new DPoint(Math.min(d8 + 1000.0, this.ymax), d6)), 50, 5050);
                data.put((GGElement)object2);
                DPoint dPoint = new DPoint((Math.max(d8, this.ymin) + Math.min(d8 + 1000.0, this.ymax)) / 2.0, d6);
                TE tE = new TE(null, dPoint.y, dPoint.x, 100.0, 50, 5050);
                tE.setRahmen(1);
                tE.setPosition(7);
                tE.setRelFlags(11);
                tE.setYRel(-0.005);
                tE.addElement(new TX(this.createNb(dPoint.y, dPoint.x - 1.0)));
                tE.addElement(new TR(((HashElement)object2).getKey(), 4));
                data.put(tE);
                TE tE2 = new TE(null, dPoint.y, dPoint.x, 100.0, 50, 5050);
                tE2.setRahmen(1);
                tE2.setPosition(1);
                tE2.setRelFlags(11);
                tE2.setYRel(0.005);
                tE2.addElement(new TX(this.createNb(dPoint.y, dPoint.x + 1.0)));
                tE2.addElement(new TR(((HashElement)object2).getKey(), 4));
                data.put(tE2);
            }
        }
        for (d = this.ymin + 1000.0; d < this.ymax; d += 1000.0) {
            double d9 = (int)d / 1000 * 1000;
            for (double d10 = this.xmin; d10 < this.xmax; d10 += 1000.0) {
                double d11 = (int)d10 / 1000 * 1000;
                object2 = new LI(this.createKooName(new DPoint(d9, Math.max(d11, this.xmin))), this.createKooName(new DPoint(d9, Math.min(d11 + 1000.0, this.xmax))), 50, 5050);
                data.put((GGElement)object2);
                DPoint dPoint = new DPoint(d9, (Math.max(d11, this.xmin) + Math.min(d11 + 1000.0, this.xmax)) / 2.0);
                TE tE = new TE(null, dPoint.y, dPoint.x, 100.0, 50, 5050);
                tE.setRahmen(1);
                tE.setPosition(5);
                tE.setRelFlags(11);
                tE.setYRel(0.005);
                tE.setAngleRel(100.0);
                tE.addElement(new TX(this.createNb(dPoint.y - 1.0, dPoint.x)));
                tE.addElement(new TR(((HashElement)object2).getKey(), 4));
                data.put(tE);
                TE tE3 = new TE(null, dPoint.y, dPoint.x, 100.0, 50, 5050);
                tE3.setRahmen(1);
                tE3.setPosition(3);
                tE3.setRelFlags(11);
                tE3.setYRel(-0.005);
                tE.setAngleRel(100.0);
                tE3.addElement(new TX(this.createNb(dPoint.y + 1.0, dPoint.x)));
                tE3.addElement(new TR(((HashElement)object2).getKey(), 4));
                data.put(tE3);
            }
        }
    }

    private String formatVvt(int n) {
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(5);
        if (n > 0) {
            stringBuffer.append('+');
        }
        stringBuffer.append(IFormat.f_1k.format((float)n / 10.0f));
        return stringBuffer.toString();
    }

    private void setExtends(DPoint dPoint) {
        this.xmin = Math.min(this.xmin, dPoint.x);
        this.ymin = Math.min(this.ymin, dPoint.y);
        this.xmax = Math.max(this.xmax, dPoint.x);
        this.ymax = Math.max(this.ymax, dPoint.y);
    }

    public String createNb(double d, double d2) {
        return " 3" + (int)d / 1000 + " | " + (int)d2 / 1000 + " ";
    }
}

