/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.kafplot.MessungGewicht;
import de.geocalc.kafplot.io.IMessung;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.text.IFormat;

public class GpsMessung
extends IMessung {
    public long pns;
    public long pnz;
    public double y;
    public double x;
    public double z;
    public double py;
    public double px;
    public double pz;

    public GpsMessung() {
        this(0L, 0L, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public GpsMessung(long l, long l2, double d, double d2, double d3, double d4) {
        this(l, l2, d, d2, 0.0, d3, d4, 1.0);
    }

    public GpsMessung(long l, long l2, double d, double d2, double d3, double d4, double d5, double d6) {
        this.pns = l;
        this.pnz = l2;
        this.y = d;
        this.x = d2;
        this.z = d3;
        this.py = d4;
        this.px = d5;
        this.pz = d6;
    }

    public String toDatLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("7");
        stringBuffer.append(" ");
        if (KafkaIOProperties.datVersion >= 2) {
            stringBuffer.append(" ");
            if (this.pns != 0L) {
                stringBuffer.append(IFormat.i14.format(this.pns));
            } else {
                stringBuffer.append("              ");
            }
            stringBuffer.append(" ");
            if (this.pnz != 0L) {
                stringBuffer.append(IFormat.i14.format(this.pnz));
            } else {
                stringBuffer.append("              ");
            }
            stringBuffer.append(IFormat.f6_3.format(this.y));
            stringBuffer.append(" ");
            stringBuffer.append(IFormat.f6_3.format(this.x));
            stringBuffer.append(" ");
            stringBuffer.append(new MessungGewicht((float)this.py, (float)this.px, 0.0f, 0.0f).toDatString());
        } else {
            if (this.pns > 0L) {
                stringBuffer.append(IFormat.i13.format(this.pns).toString());
            } else {
                stringBuffer.append("             ");
            }
            stringBuffer.append(" ");
            stringBuffer.append(IFormat.i13.format(this.pnz).toString());
            stringBuffer.append("  ");
            stringBuffer.append(IFormat.f6_3.format(this.y).toString());
            stringBuffer.append(IFormat.f6_3.format(this.x).toString());
            stringBuffer.append(this.getPString(this.py));
            stringBuffer.append(this.getPString(this.px));
        }
        return stringBuffer.toString();
    }

    public String toDatHoeheLine() {
        StringBuffer stringBuffer = new StringBuffer();
        if (KafkaIOProperties.datVersion < 2) {
            return "C H\u00f6hen werden erst ab DAT_VERSION 1.4 unterst\u00fctzt";
        }
        stringBuffer.append("1");
        stringBuffer.append(" ");
        stringBuffer.append(" ");
        if (this.pns != 0L) {
            stringBuffer.append(IFormat.i14.format(this.pns));
        } else {
            stringBuffer.append("              ");
        }
        stringBuffer.append(" ");
        if (this.pnz != 0L) {
            stringBuffer.append(IFormat.i14.format(this.pnz));
        } else {
            stringBuffer.append("              ");
        }
        stringBuffer.append(IFormat.f6_3.format(this.z));
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f6_1.format(1.0));
        stringBuffer.append("   ");
        stringBuffer.append(IFormat.f3_2.format(0.02));
        return stringBuffer.toString();
    }

    private String getPString(double d) {
        if (d < 1.0E-4) {
            return IFormat.f0_5.format(d).toString();
        }
        if (d < 1.0) {
            return " " + IFormat.f0_4.format(d).toString();
        }
        if (d < 10.0) {
            return " " + IFormat.f1_3.format(d).toString();
        }
        if (d < 100.0) {
            return " " + IFormat.f2_2.format(d).toString();
        }
        if (d < 1000.0) {
            return " " + IFormat.f3_1.format(d).toString();
        }
        if (d < 10000.0) {
            return " " + IFormat.f4_0.format(d).toString();
        }
        return IFormat.f5_0.format(d).toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(IFormat.i.format(this.pns).toString());
        stringBuffer.append("-");
        stringBuffer.append(IFormat.i.format(this.pnz).toString());
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f_3.format(this.y).toString());
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f_3.format(this.x).toString());
        return stringBuffer.toString();
    }
}

