/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.io.IFreePunktReader;
import de.geocalc.util.LongHashList;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;

public class GsiKooReader
extends IFreePunktReader {
    public GsiKooReader(File file, LongHashList longHashList) {
        super(file, longHashList, null);
    }

    public GsiKooReader(File file, LongHashList longHashList, IProgressViewer iProgressViewer) {
        super(file, longHashList, iProgressViewer);
    }

    public GsiKooReader(File file, Vector vector) {
        super(file, vector, null);
    }

    public GsiKooReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
    }

    @Override
    protected Punkt lineToPunkt(String string) {
        Punkt punkt = new Punkt();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = Integer.parseInt(string2.substring(0, 2));
                char c = string2.charAt(5);
                char c2 = string2.charAt(6);
                long l = Long.parseLong(string2.substring(7));
                if (c2 == '-') {
                    l = -l;
                }
                switch (n) {
                    case 11: {
                        punkt.nr = l;
                        break;
                    }
                    case 81: 
                    case 84: {
                        punkt.y = this.toDouble(l, c);
                        break;
                    }
                    case 82: 
                    case 85: {
                        punkt.x = this.toDouble(l, c);
                        break;
                    }
                    case 83: {
                        punkt.h = (float)this.toDouble(l, c);
                    }
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        return punkt;
    }

    private double toDouble(long l, char c) {
        if (c == '0') {
            return (double)l * 0.001;
        }
        if (c == '6') {
            return (double)l * 1.0E-4;
        }
        if (c == '8') {
            return (double)l * 1.0E-5;
        }
        return l;
    }
}

