/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.io.IPolarReader;
import de.geocalc.kafplot.io.NivMessung;
import de.geocalc.kafplot.io.PolarMessung;
import de.geocalc.text.IFormat;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class GsiPolarReader
extends IPolarReader {
    private static final String DA_ERROR = "ung\u00fcltige Datenkennung in Spalte 1-2";
    private static final double NIV_GEN = 0.002;
    private static int stpktCode = 0;
    private static int stpktIndex = 0;
    int anzZpk = 0;
    int stpktDa = 0;
    long pns = 0L;
    double lastIh = 0.0;

    public static void setStpktCode(int n) {
        stpktCode = n;
    }

    public static void setStandpunktIdent(int n) {
        stpktIndex = n;
    }

    public GsiPolarReader(File file, Vector vector) {
        super(file, vector, null);
    }

    public GsiPolarReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
    }

    @Override
    protected PolarMessung lineToPolarMessung(String string) throws IFileInputException, IOException {
        if (string.length() < 3 || !IFormat.isNumber(string.substring(1, 3))) {
            return null;
        }
        PolarMessung polarMessung = new PolarMessung();
        boolean bl = false;
        int n = 0;
        try {
            n = Integer.parseInt(string.substring(1, 3));
        }
        catch (Exception exception) {
            throw new IFileInputException(DA_ERROR);
        }
        if (n == 0) {
            return new PolarMessung(string.substring(4).trim());
        }
        if (n == 11) {
            boolean bl2 = false;
            int n2 = -23;
            while (n2 + 24 < string.length()) {
                if (string.charAt(n2 += 24) == ' ') continue;
                switch (Integer.parseInt(string.substring(n2, n2 + 2))) {
                    case 11: {
                        polarMessung.pnz = this.readPunktNummer(string, n2, n2 + 23);
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 18: 
                    case 19: {
                        break;
                    }
                    case 21: {
                        polarMessung.r = this.readBlockValue(string, n2, n2 + 23);
                        break;
                    }
                    case 22: {
                        polarMessung.z = this.readBlockValue(string, n2, n2 + 23);
                        break;
                    }
                    case 25: 
                    case 79: {
                        this.anzZpk = 0;
                        this.pns = polarMessung.pnz;
                        return null;
                    }
                    case 31: {
                        polarMessung.s = this.readBlockValue(string, n2, n2 + 23);
                        bl = false;
                        break;
                    }
                    case 32: {
                        if (polarMessung.s != 0.0) break;
                        polarMessung.s = this.readBlockValue(string, n2, n2 + 23);
                        bl = true;
                        break;
                    }
                    case 33: {
                        polarMessung.dh = this.readBlockValue(string, n2, n2 + 23);
                        polarMessung.nivCode = Integer.parseInt(string.substring(n2 + 2, n2 + 3));
                        break;
                    }
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: {
                        break;
                    }
                    case 51: 
                    case 81: 
                    case 82: {
                        break;
                    }
                    case 83: {
                        if (polarMessung.r != 0.0 || polarMessung.z != 100.0 || polarMessung.s != 0.0 || polarMessung.dh != 0.0) break;
                        return null;
                    }
                    case 84: 
                    case 85: 
                    case 86: {
                        bl2 = true;
                        break;
                    }
                    case 87: {
                        polarMessung.rh = this.readBlockValue(string, n2, n2 + 23);
                        break;
                    }
                    case 88: {
                        polarMessung.ih = this.readBlockValue(string, n2, n2 + 23);
                    }
                }
            }
            if (this.anzZpk == 0) {
                polarMessung.pns = this.pns;
            }
            ++this.anzZpk;
            if (bl2) {
                this.pns = polarMessung.pnz;
                this.anzZpk = 0;
                this.lastIh = polarMessung.ih;
                return null;
            }
            if (polarMessung.ih == 0.0) {
                polarMessung.ih = this.lastIh;
            }
        } else {
            if (n == 41) {
                try {
                    int n3 = (int)Long.parseLong(string.substring(7, 24));
                    if (n3 > 0 && n3 == stpktCode) {
                        int n4 = -23;
                        while (n4 + 24 < string.length()) {
                            int n5;
                            if (string.charAt(n4 += 24) == ' ' || (n5 = Integer.parseInt(string.substring(n4, n4 + 2))) != stpktIndex) continue;
                            this.pns = this.readPunktNummer(string, n4, n4 + 24);
                            this.anzZpk = 0;
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return null;
            }
            if (n == 50 || n == 51) {
                return null;
            }
            throw new IFileInputException(DA_ERROR);
        }
        if (polarMessung.z > 200.0) {
            polarMessung.z = 400.0 - polarMessung.z;
            polarMessung.r = polarMessung.r + (polarMessung.r > 200.0 ? -200.0 : 200.0);
        }
        if (bl) {
            polarMessung.z = 100.0;
        }
        return polarMessung;
    }

    private int readCodeNummer(String string, int n, int n2) {
        return Integer.parseInt(string.substring(n + 7, n + 15));
    }

    private long readPunktNummer(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n + 7; i < n2; ++i) {
            if (!Character.isDigit(string.charAt(i))) continue;
            stringBuffer.append(string.charAt(i));
        }
        return Long.parseLong(stringBuffer.toString());
    }

    private double readBlockValue(String string, int n, int n2) throws IFileInputException {
        double d = new Double(string.substring(n + 6, n + 23));
        switch (string.charAt(n + 5)) {
            case '.': 
            case '0': {
                d /= 1000.0;
                break;
            }
            case '6': {
                d /= 10000.0;
                break;
            }
            case '2': 
            case '8': {
                d /= 100000.0;
                break;
            }
            case '1': 
            case '3': 
            case '4': 
            case '5': 
            case '7': {
                throw new IFileInputException("ung\u00fcltige Ma\u00dfeinheit im Datensatz Spalte " + n + "-" + n2);
            }
        }
        return d;
    }

    @Override
    protected void syncronisierePolarMessungen() {
        Vector<NivMessung> vector = new Vector<NivMessung>();
        long l = 0L;
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        Enumeration enumeration = this.M.elements();
        while (enumeration.hasMoreElements()) {
            PolarMessung polarMessung = (PolarMessung)enumeration.nextElement();
            if (polarMessung.ma != 1 || polarMessung.nivCode == 0) continue;
            if (polarMessung.nivCode == 1) {
                if (polarMessung.pnz == 0L) {
                    d += polarMessung.dh;
                    d2 += polarMessung.s;
                } else {
                    l = polarMessung.pnz;
                    d = polarMessung.dh;
                    d2 = polarMessung.s;
                    n = 0;
                }
            } else if (polarMessung.nivCode == 3 || polarMessung.nivCode == 4) {
                var11_8 = new NivMessung(n == 0 ? l : 0L, polarMessung.pnz, d - polarMessung.dh, d2 + polarMessung.s, 0.002, 0.002);
                vector.addElement(var11_8);
                ++n;
            } else if (polarMessung.nivCode == 2) {
                if (polarMessung.pnz == 0L) {
                    d -= polarMessung.dh;
                    d2 += polarMessung.s;
                } else {
                    var11_8 = new NivMessung(n == 0 ? l : 0L, polarMessung.pnz, d - polarMessung.dh, d2 + polarMessung.s, 0.002, 0.002);
                    vector.addElement(var11_8);
                    ++n;
                }
            }
            if (polarMessung.z != 100.0 || polarMessung.r != 0.0) continue;
            polarMessung.ma = -1;
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.M.addElement(enumeration.nextElement());
        }
    }
}

