/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.io.IFileWriter;
import de.geocalc.text.IFormat;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class HomWriter
extends IFileWriter {
    public static final String TITLE = "HomWriter";
    public static final String VERSION = "1.0";
    protected DataBase db;

    public HomWriter(File file, DataBase dataBase) {
        super(file);
        this.db = dataBase;
        this.setParameter();
    }

    protected void setParameter() {
    }

    @Override
    public void write() throws IFileOutputException {
        PrintWriter printWriter = null;
        try {
            printWriter = this.createWriter();
            super.setLabelText("Sortiere...");
            super.setLabelValue(-1L);
            super.setProgress(0);
            Enumeration enumeration = DataBase.T.elements();
            while (enumeration.hasMoreElements()) {
                TrafoSystem trafoSystem = (TrafoSystem)enumeration.nextElement();
                printWriter.println("# " + trafoSystem.getName());
                Enumeration enumeration2 = trafoSystem.elements();
                while (enumeration2.hasMoreElements()) {
                    TrafoPunkt trafoPunkt = (TrafoPunkt)enumeration2.nextElement();
                    Punkt punkt = trafoPunkt.getPunkt();
                    printWriter.println(IFormat.i14.format(punkt.nr) + " " + IFormat.f7_3.format(punkt.y) + " " + IFormat.f7_3.format(punkt.x) + " " + IFormat.f7_3.format(trafoPunkt.y) + " " + IFormat.f7_3.format(trafoPunkt.x));
                }
            }
            super.setProgress(100);
            printWriter.close();
            super.setProgress(100);
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
    }
}

