/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IException;
import de.geocalc.awt.IExceptionReceiver;
import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.ExtendedPunktFilter;
import de.geocalc.kafplot.KafPlot;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.util.LongHashList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

public abstract class IFileReader
implements IExceptionReceiver {
    private static long NEW_NUMBER = 1L;
    public static final int NEW_POINT = 1;
    public static final int OLD_POINT = 2;
    public static final int KOO_RECT = 4;
    public static final int OLD_IGNORE = 8;
    public static final int OLD_REPLACE = 16;
    public static final int OLD_APPEND = 32;
    public static final int OLD_NEW_NR = 64;
    public static final int KOO_REPLACE = 128;
    public static final int DYDX_REPLACE = 512;
    public static final int ATT_IGNORE = 1024;
    public static final int ATT_REPLACE = 2048;
    public static final int ATT_APPEND = 4096;
    public static final int NEW_MENGE = 8192;
    public static final int OLD_MENGE = 16384;
    public static final int UPD_MENGE = 32768;
    protected static int defaultModus = 11;
    protected static int defaultPnrModus = 5;
    protected static int defaultPunktStatus = 0;
    protected static boolean defaultKooBereich = false;
    protected static Hashtable lstatusTable = null;
    protected static Hashtable hstatusTable = null;
    private Thread parentThread = null;
    protected int readMode = 1043;
    protected int pnrModus;
    protected int punktStatus;
    protected int katasterModel = 0;
    protected boolean newPoints = true;
    protected boolean oldPoints = true;
    protected boolean kooBereich = defaultKooBereich;
    protected ExtendedPunktFilter punktFilter = null;
    protected long newNumber = NEW_NUMBER;
    protected Vector PPL;
    protected File inFile = null;
    protected IProgressViewer progressBar = null;
    private ExceptionList exceptionList = null;
    private int progress = 0;
    private long inFileLength = 1L;
    private String encode = null;

    public void setParentThread(Thread thread) {
        this.parentThread = thread;
    }

    public Thread getParentThread() {
        return this.parentThread;
    }

    public static void setDefaultReadModus(int n) {
        defaultModus = n;
    }

    public static int getDefaultReadModus() {
        return defaultModus;
    }

    public static void setDefaultPnrModus(int n) {
        defaultPnrModus = n;
    }

    public static int getDefaultPnrModus() {
        return defaultPnrModus;
    }

    public static void setDefaultPunktStatus(int n) {
        defaultPunktStatus = n;
    }

    public static int getDefaultPunktStatus() {
        return defaultPunktStatus;
    }

    public static void setLagestatusTable(Hashtable hashtable) {
        lstatusTable = hashtable;
    }

    public static void setHoehestatusTable(Hashtable hashtable) {
        hstatusTable = hashtable;
    }

    public static void setNewNumber(long l) {
        NEW_NUMBER = l;
    }

    public static long getNewNumber() {
        return NEW_NUMBER;
    }

    public IFileReader(File file) {
        this(file, null);
    }

    public IFileReader(File file, IProgressViewer iProgressViewer) {
        this.inFile = file;
        if (file != null) {
            this.inFileLength = file.length();
        }
        this.progressBar = iProgressViewer;
        this.readMode = defaultModus;
        this.pnrModus = defaultPnrModus;
        this.punktStatus = defaultPunktStatus;
        lstatusTable = null;
        hstatusTable = null;
        this.setParameter();
    }

    public File getInFile() {
        return this.inFile;
    }

    public void setEncoding(String string) {
        this.encode = string;
    }

    public String getEncoding() {
        return this.encode;
    }

    protected LineNumberReader createReader() throws IOException {
        String string;
        String string2 = string = this.encode != null ? this.encode : this.getDefaultEncoding();
        if (KafPlot.debug()) {
            System.out.println("Erzeuge " + this.getClass().getName() + "(" + string + ") " + this.inFile.getName());
        }
        return new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(this.inFile), string));
    }

    protected LineNumberReader createReader(File file) throws IOException {
        String string;
        String string2 = string = this.encode != null ? this.encode : this.getDefaultEncoding();
        if (KafPlot.debug()) {
            System.out.println("Erzeuge " + this.getClass().getName() + "(" + string + ") " + file.getName());
        }
        return new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
    }

    protected LineNumberReader createReader(URL uRL) throws IOException {
        String string;
        String string2 = string = this.encode != null ? this.encode : this.getDefaultEncoding();
        if (KafPlot.debug()) {
            System.out.println("Erzeuge " + this.getClass().getName() + "(" + string + ") " + String.valueOf(uRL));
        }
        return new LineNumberReader(new InputStreamReader(uRL.openStream(), string));
    }

    public static LineNumberReader createFileReader(File file) throws IOException {
        return new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), "Cp1252"));
    }

    public static LineNumberReader createFileReader(File file, String string) throws IOException {
        return new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
    }

    public static LineNumberReader createStreamReader(InputStream inputStream) throws IOException {
        return new LineNumberReader(new InputStreamReader(inputStream, "Cp1252"));
    }

    public static LineNumberReader createStreamReader(InputStream inputStream, String string) throws IOException {
        return new LineNumberReader(new InputStreamReader(inputStream, string));
    }

    protected String getDefaultEncoding() {
        return "Cp1252";
    }

    public void setExceptionList(ExceptionList exceptionList) {
        this.exceptionList = exceptionList;
    }

    public ExceptionList getExceptionList() {
        return this.exceptionList;
    }

    protected void clearExceptionList() {
        this.exceptionList.clear();
    }

    public void setProgressViewer(IProgressViewer iProgressViewer) {
        this.progressBar = iProgressViewer;
    }

    public IProgressViewer getProgressViewer() {
        return this.progressBar;
    }

    public File getFile() {
        return this.inFile;
    }

    protected void setFile(File file) {
        this.inFile = file;
        this.progress = 0;
        this.setFileLength(0L);
        if (this.progressBar != null) {
            this.progressBar.setValue(0);
        }
        if (file != null) {
            this.setFileLength(file.length());
        }
    }

    protected void setFileLength(long l) {
        this.inFileLength = Math.max(1L, l);
    }

    public void setMode(int n) {
        this.readMode = n;
    }

    public void setMode(int n, boolean bl) {
        this.readMode = bl ? (this.readMode |= n) : (this.readMode &= ~n);
    }

    public boolean isMode(int n) {
        return (this.readMode & n) != 0;
    }

    public static boolean isMode(int n, int n2) {
        return (n & n2) != 0;
    }

    public void setPnrModus(int n) {
        this.pnrModus = n;
    }

    public int getPnrModus() {
        return this.pnrModus;
    }

    public int getModel() {
        return this.katasterModel;
    }

    public void setPunktStatus(int n) {
        this.punktStatus = n;
    }

    public int getPunktStatus() {
        return this.punktStatus;
    }

    public long getFreeStartNumber() {
        return this.newNumber;
    }

    public void setFreeStartNumber(long l) {
        this.newNumber = l;
    }

    public ExtendedPunktFilter getPunktFilter() {
        return this.punktFilter;
    }

    public void setPunktFilter(ExtendedPunktFilter extendedPunktFilter) {
        this.punktFilter = extendedPunktFilter;
    }

    public void setParameterList(Vector vector) {
        this.PPL = vector;
    }

    public Vector getParameterList() {
        return this.PPL;
    }

    protected void setParameter() {
        this.setFreeStartNumber(NEW_NUMBER);
    }

    public abstract boolean isMutableNumberReader();

    public abstract boolean isMutableStatusReader();

    public abstract boolean isFreeNumberReader();

    public abstract boolean isSelectableReader();

    public abstract boolean isAttributeReader();

    public abstract boolean isMengeReader();

    public abstract boolean isUpdateReader();

    public abstract void read() throws IException;

    public void prepareMultiReading() {
    }

    public void readMulti(File file) throws IException {
        this.setFile(file);
        this.read();
    }

    public void finishMultiReading() {
    }

    public abstract void userAbort() throws IFileInputException;

    public boolean isAborted() {
        return false;
    }

    public int getKooSystem() {
        return -1;
    }

    @Override
    public void addException(Exception exception) {
        if (KafPlot.debug()) {
            exception.printStackTrace();
        }
        if (this.exceptionList != null) {
            this.exceptionList.addException(exception);
        }
    }

    public void addExceptions(ExceptionList exceptionList) {
        if (this.exceptionList != null) {
            this.exceptionList.addAll(exceptionList);
        }
    }

    public String getFinalMessage() {
        return null;
    }

    protected void setFileProgress(long l) {
        this.setProgress((int)(l * 100L / this.inFileLength));
    }

    protected void setProgress(int n) {
        if (Math.abs(n - this.progress) >= 5) {
            if (this.progressBar != null) {
                this.progressBar.setValue(n);
            }
            this.progress = n;
        }
    }

    protected void setProgressState(int n) {
        if (this.progressBar != null) {
            this.progressBar.setState(n);
        }
    }

    protected String deleteLetters(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (!Character.isDigit(c)) continue;
            stringBuffer.setCharAt(n++, c);
        }
        stringBuffer.setLength(n);
        return stringBuffer.toString();
    }

    protected Punkt savePunkt(Punkt punkt, LongHashList longHashList) {
        Punkt punkt2;
        if (this.isMode(4) && !DataBase.isInArea(punkt.y, punkt.x)) {
            return null;
        }
        if (this.punktFilter != null && !this.punktFilter.isPunktEnabled(punkt)) {
            return null;
        }
        if (this.punktStatus != -9) {
            punkt.setPs(punkt.buildPunktStatus(this.punktStatus));
        }
        if ((punkt2 = (Punkt)longHashList.get(punkt.nr)) == null) {
            if (this.isMode(1)) {
                longHashList.put(punkt);
                if (this.isMode(8192)) {
                    DataBase.buildMenge(punkt);
                }
            }
        } else if (this.isMode(2)) {
            if (this.isMode(8)) {
                this.addException(new IFileInputException(this.getErrorKey() + "Punkt " + punkt2.nr + " ist vorhanden, Punkt wird ignoriert."));
            } else if (this.isMode(16)) {
                this.addException(new IFileInputException(this.getErrorKey() + "Punkt " + punkt2.nr + " ist vorhanden, Punkt wird neu \u00fcbernommen."));
                punkt2.getValues(punkt);
            } else if (this.isMode(64)) {
                punkt.nr = this.getFreeNumber(longHashList);
                this.addException(new IFileInputException(this.getErrorKey() + "Punkt " + punkt2.nr + " ist vorhanden, Punkt wird neu nummeriert: " + punkt.nr));
                longHashList.put(punkt);
            } else if (this.isMode(32)) {
                if (this.isMode(512)) {
                    if (this.isMode(128)) {
                        punkt2.dy = (float)(punkt2.y - punkt.y);
                        punkt2.dx = (float)(punkt2.x - punkt.x);
                        if (punkt2.h != 0.0f && punkt.h != 0.0f) {
                            punkt2.dh = punkt2.h - punkt.h;
                        }
                    } else {
                        punkt2.dy = (float)(punkt.y - punkt2.y);
                        punkt2.dx = (float)(punkt.x - punkt2.x);
                        if (punkt2.h != 0.0f && punkt.h != 0.0f) {
                            punkt2.dh = punkt.h - punkt2.h;
                        }
                    }
                }
                if (this.isMode(128)) {
                    if (punkt.y != 0.0 && punkt.x != 0.0) {
                        punkt2.y = punkt.y;
                        punkt2.x = punkt.x;
                    }
                    if (punkt.h != 0.0f) {
                        punkt2.h = punkt.h;
                    }
                }
                if (this.isMode(2048)) {
                    if (this.PPL != null) {
                        for (int i = 0; i < this.PPL.size(); ++i) {
                            punkt2.updateParameter(punkt, (Integer)this.PPL.elementAt(i));
                        }
                    } else {
                        punkt2.initParameter(punkt.getParameter());
                        punkt2.setPs(punkt.getPs());
                    }
                } else if (this.isMode(4096)) {
                    if (this.PPL != null) {
                        for (int i = 0; i < this.PPL.size(); ++i) {
                            punkt2.addParameter(punkt, (Integer)this.PPL.elementAt(i));
                        }
                    } else {
                        PunktParameter punktParameter = punkt2.getParameter();
                        punktParameter.addParameter(punkt.getParameter());
                        punkt2.initParameter(punktParameter);
                        if (punkt2.getPs() <= 0) {
                            punkt2.setPs(punkt.getPs());
                        }
                    }
                }
            }
            if (this.isMode(16384)) {
                DataBase.buildMenge(punkt2);
            }
        }
        return punkt2;
    }

    protected final long getFreeNumber(LongHashList longHashList) {
        if (longHashList == null) {
            return this.newNumber++;
        }
        while (longHashList.get(this.newNumber) != null) {
            ++this.newNumber;
        }
        return this.newNumber;
    }

    protected String getErrorKey() {
        return "";
    }
}

