/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IException;
import de.geocalc.awt.IProgressElement;
import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.KafPlot;
import de.geocalc.kafplot.PunktFilter;
import de.geocalc.kafplot.io.IOProperties;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public abstract class IFileWriter
extends IProgressElement {
    protected File outFile = null;
    protected PunktFilter punktFilter = new PunktFilter();
    private ExceptionList exceptionList = null;
    private boolean isUmnum = false;
    private int nummerModus = 0;
    private long pnrZuschlag = 0L;
    private long zuschlagBorder = 0L;
    private int gemarkung = 0;
    private int amt = 0;
    private String antrag = null;
    private String encode = null;

    public IFileWriter() {
        this((File)null);
    }

    public IFileWriter(File file) {
        this.outFile = file;
    }

    protected PrintWriter createWriter() throws IOException {
        String string;
        String string2 = string = this.encode != null ? this.encode : this.getDefaultEncoding();
        if (KafPlot.debug()) {
            System.out.println("Erzeuge " + this.getClass().getName() + "(" + string + ") " + this.outFile.getName());
        }
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outFile), string)));
    }

    protected PrintWriter createWriter(File file) throws IOException {
        String string;
        String string2 = string = this.encode != null ? this.encode : this.getDefaultEncoding();
        if (KafPlot.debug()) {
            System.out.println("Erzeuge " + this.getClass().getName() + "(" + string + ") " + file.getName());
        }
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string)));
    }

    public static PrintWriter createFileWriter(File file) throws IOException {
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "Cp1252")));
    }

    public static PrintWriter createFileWriter(File file, String string) throws IOException {
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string)));
    }

    public File getOutFile() {
        return this.outFile;
    }

    protected String getDefaultEncoding() {
        return "Cp1252";
    }

    public void setEncoding(String string) {
        this.encode = string;
    }

    public String getEncoding() {
        return this.encode;
    }

    public static boolean is3DWriter() {
        return false;
    }

    public void setGemarkung(int n) {
        this.gemarkung = n;
    }

    public int getGemarkung() {
        return this.gemarkung;
    }

    public void setAmt(int n) {
        this.amt = n;
    }

    public int getAmt() {
        return this.amt;
    }

    public void setAntrag(String string) {
        this.antrag = string;
    }

    public String getAntrag() {
        return this.antrag;
    }

    public void setPunktFilter(PunktFilter punktFilter) {
        this.punktFilter = punktFilter;
    }

    public PunktFilter getPunktFilter() {
        return this.punktFilter;
    }

    public void setExceptionList(ExceptionList exceptionList) {
        this.exceptionList = exceptionList;
    }

    public ExceptionList getExceptionList() {
        return this.exceptionList;
    }

    public void setPunktNummerZuschlag(long l) {
        this.pnrZuschlag = l;
    }

    public long getPunktNummerZuschlag() {
        return this.pnrZuschlag;
    }

    public void setPunktNummerZuschlagBorder(long l) {
        this.zuschlagBorder = l;
    }

    public long getPunktNummerZuschlagBorder() {
        return this.zuschlagBorder;
    }

    public void setUmnum(boolean bl) {
        this.isUmnum = bl;
        IOProperties.setUmnum(bl);
    }

    public boolean isUmnum() {
        return this.isUmnum;
    }

    public void setNummerModus(int n) {
        this.nummerModus = n;
    }

    public int getNummerModus() {
        return this.nummerModus;
    }

    public void setProgress(int n) {
        this.showProgress(n);
    }

    protected void addException(Exception exception) {
        if (KafPlot.debug()) {
            exception.printStackTrace();
        }
        if (this.exceptionList != null) {
            this.exceptionList.addElement(exception);
        }
    }

    protected void parseZuschlag(String string) throws IException {
        try {
            string = string.trim();
            int n = string.indexOf("#");
            if (n == -1) {
                throw new IException("Fehler im Format des Punktnummerzuschlages", "es m\u00fcssen Platzhalter (#) definiert sein");
            }
            this.zuschlagBorder = (long)Math.rint(Math.pow(10.0, string.length() - n));
            this.pnrZuschlag = Long.parseLong(string.substring(0, n)) * this.zuschlagBorder;
        }
        catch (NumberFormatException numberFormatException) {
            this.zuschlagBorder = 0L;
            this.pnrZuschlag = 0L;
            throw new IException("Fehler im Format des Punktnummerzuschlages", "Zuschlag mu\u00df numerisch sein");
        }
    }

    public abstract void write() throws IFileOutputException;
}

