/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.io.GpsMessung;
import de.geocalc.kafplot.io.IDataReader;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Vector;

public abstract class IGpsReader
extends IDataReader {
    private static double sa = 0.01;
    private LineNumberReader reader = null;
    protected Vector M = null;

    public IGpsReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.M = vector;
    }

    public static void setSA(double d) {
        sa = d;
    }

    public static double getSA() {
        return sa;
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read() throws IFileInputException {
        String string = null;
        try {
            this.reader = this.createReader();
            long l = 0L;
            while ((string = this.reader.readLine()) != null) {
                GpsMessung gpsMessung = this.lineToGpsMessung(string);
                if (gpsMessung != null) {
                    this.M.addElement(gpsMessung);
                }
                super.setFileProgress(l += (long)(string.length() + 1));
            }
        }
        catch (IFileInputException iFileInputException) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber(), iFileInputException.getMessage()));
        }
        catch (IOException iOException) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber(), iOException.getMessage()));
        }
        catch (Exception exception) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber(), exception.getMessage()));
        }
        finally {
            try {
                this.reader.close();
                super.setProgress(100);
            }
            catch (Exception exception) {}
        }
        try {
            this.parseMessungen();
        }
        catch (Exception exception) {
            this.addException(exception);
        }
    }

    protected abstract void parseMessungen();

    protected abstract GpsMessung lineToGpsMessung(String var1) throws IFileInputException, IOException;
}

