/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.SurveyException;
import de.geocalc.kafplot.io.IDataReader;
import de.geocalc.kafplot.io.IOProperties;
import de.geocalc.kafplot.io.PolarMessung;
import de.geocalc.text.GeoNumberFormat;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Vector;

public abstract class IPolarReader
extends IDataReader {
    protected static final long FREE_STATION = Long.MAX_VALUE;
    protected static final double IGNORE_3D = -1.7976931348623157E308;
    protected static double rDiffZul = 0.05;
    protected static double zDiffZul = 0.05;
    protected static double sDiffZul = 0.05;
    protected static boolean isMitteln = true;
    protected static boolean isReduzieren = true;
    protected static boolean trigDist = true;
    protected static boolean zTrigSteuerdaten = true;
    protected static boolean ignoreR0 = false;
    private static double ignoreR = -1.7976931348623157E308;
    protected Vector M = null;
    private LineNumberReader reader = null;

    public IPolarReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.M = vector;
    }

    public static void setMitteln(boolean bl) {
        isMitteln = bl;
    }

    public static boolean isMitteln() {
        return isMitteln;
    }

    public static void setReduzieren(boolean bl) {
        isReduzieren = bl;
    }

    public static boolean isReduzieren() {
        return isReduzieren;
    }

    public static void setRichtungDiff(double d) {
        rDiffZul = d;
    }

    public static double getRichtungDiff() {
        return rDiffZul;
    }

    public static void setZenitDiff(double d) {
        zDiffZul = d;
    }

    public static double getZenitDiff() {
        return zDiffZul;
    }

    public static void setStreckeDiff(double d) {
        sDiffZul = d;
    }

    public static double getStreckeDiff() {
        return sDiffZul;
    }

    public static void setTrigDist(boolean bl) {
        trigDist = bl;
    }

    public static boolean isTrigDist() {
        return trigDist;
    }

    public static void setTrigSteuerdaten(boolean bl) {
        zTrigSteuerdaten = bl;
    }

    public static boolean isTrigSteuerdaten() {
        return zTrigSteuerdaten;
    }

    public static void setIgnoreR0(boolean bl) {
        ignoreR0 = bl;
    }

    public static boolean ignoreR0() {
        return ignoreR0;
    }

    public static void setIgnoreR(double d) {
        ignoreR = d;
    }

    public static double getIgnoreR() {
        return ignoreR;
    }

    public static boolean isIgnoreR(double d) {
        if (d == -1.7976931348623157E308) {
            return true;
        }
        if (d == 0.0 && ignoreR0) {
            return true;
        }
        return d == ignoreR;
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
        }
    }

    @Override
    public void read() throws IFileInputException {
        String string = null;
        try {
            this.reader = this.createReader();
            long l = 0L;
            while ((string = this.reader.readLine()) != null) {
                PolarMessung polarMessung = null;
                try {
                    polarMessung = this.lineToPolarMessung(string);
                }
                catch (IFileInputException iFileInputException) {
                    this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber(), iFileInputException.getMessage()));
                    iFileInputException.printStackTrace();
                }
                catch (Exception exception) {
                    this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber(), exception.getMessage()));
                    exception.printStackTrace();
                }
                if (polarMessung != null) {
                    this.M.addElement(polarMessung);
                }
                super.setFileProgress(l += (long)(string.length() + 1));
            }
            this.reader.close();
            super.setProgress(100);
        }
        catch (IOException iOException) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber(), iOException.getMessage()));
        }
        try {
            this.syncronisierePolarMessungen();
            this.horizontierePolarMessungen();
            if (IPolarReader.isMitteln()) {
                this.mittlePolarMessungen();
            }
            if (IPolarReader.isReduzieren()) {
                this.reduzierePolarMessungen();
            }
        }
        catch (Exception exception) {
            this.addException(exception);
        }
    }

    protected void syncronisierePolarMessungen() {
    }

    protected void horizontierePolarMessungen() {
        Enumeration enumeration = this.M.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof PolarMessung)) continue;
            PolarMessung polarMessung = (PolarMessung)e;
            if (polarMessung.ma != 1) continue;
            if (polarMessung.s != 0.0) {
                if (polarMessung.ppm != 0.0) {
                    polarMessung.s += polarMessung.ppm * polarMessung.s / 1000000.0;
                }
                if (polarMessung.pK != 0.0) {
                    polarMessung.s += polarMessung.pK;
                }
            }
            polarMessung.ss = polarMessung.s;
            if (polarMessung.z < 200.0) {
                polarMessung.s *= Math.sin(polarMessung.z * Math.PI / 200.0);
            } else {
                polarMessung.r -= 200.0;
                if (polarMessung.r < 0.0) {
                    polarMessung.r += 400.0;
                }
                polarMessung.s *= Math.sin((polarMessung.z - 200.0) * Math.PI / 200.0);
            }
            if (polarMessung.dl == 0.0 && polarMessung.dq == 0.0) continue;
            double d = Math.cos(polarMessung.z * Math.PI / 200.0) * polarMessung.ss;
            if (polarMessung.dl != 0.0) {
                polarMessung.s += polarMessung.dl;
            }
            if (polarMessung.dq != 0.0 && polarMessung.s != 0.0) {
                polarMessung.r += Math.atan2(polarMessung.dq, polarMessung.s) * 200.0 / Math.PI;
                if (polarMessung.r < 0.0) {
                    polarMessung.r += 400.0;
                }
                if (polarMessung.r > 400.0) {
                    polarMessung.r -= 400.0;
                }
                polarMessung.s = Math.sqrt(polarMessung.s * polarMessung.s + polarMessung.dq * polarMessung.dq);
            }
            polarMessung.ss = Math.sqrt(polarMessung.s * polarMessung.s + d * d);
            polarMessung.z = 100.0 - Math.asin(d / polarMessung.ss) * 200.0 / Math.PI;
        }
    }

    protected void mittlePolarMessungen() {
        int n = 0;
        long l = 0L;
        block0: for (int i = 0; i < this.M.size(); ++i) {
            Object e = this.M.elementAt(i);
            if (!(e instanceof PolarMessung)) continue;
            PolarMessung polarMessung = (PolarMessung)e;
            if (polarMessung.ma != 1) continue;
            if (polarMessung.pns != 0L) {
                n = i;
                l = polarMessung.pns;
                continue;
            }
            for (int j = i - 1; j >= n; --j) {
                e = this.M.elementAt(j);
                if (!(e instanceof PolarMessung)) continue;
                PolarMessung polarMessung2 = (PolarMessung)e;
                if (polarMessung2.ma != 1 || polarMessung.pnz != polarMessung2.pnz) continue;
                double d = Math.abs(polarMessung2.getRichtungDiff(polarMessung));
                double d2 = Math.abs(polarMessung2.getStreckeDiff(polarMessung));
                double d3 = 0.0;
                if (IOProperties.getHoeheModus() == IOProperties.MODUS_3D && polarMessung.ih == polarMessung2.ih && polarMessung.rh == polarMessung2.rh) {
                    d3 = Math.abs(polarMessung2.getZenitDiff(polarMessung));
                }
                if (d > rDiffZul) {
                    this.addException(new SurveyException("Zul\u00e4ssige Differenz der doppelten Richtungsmessung \u00fcberschritten", "Standpunkt: " + l + " > Zielpunkt: " + polarMessung.pnz + " = " + GeoNumberFormat.m34.format(d)));
                    polarMessung.ma = 0;
                    continue;
                }
                if (d2 > sDiffZul) {
                    this.addException(new SurveyException("Zul\u00e4ssige Differenz der doppelten Streckenmessung \u00fcberschritten", "Standpunkt: " + l + " > Zielpunkt: " + polarMessung.pnz + " = " + GeoNumberFormat.m43.format(d2)));
                    polarMessung.ma = 0;
                    continue;
                }
                if (d3 > zDiffZul) {
                    this.addException(new SurveyException("Zul\u00e4ssige Differenz der doppelten Zenitmessung \u00fcberschritten", "Standpunkt: " + l + " > Zielpunkt: " + polarMessung.pnz + " = " + GeoNumberFormat.m43.format(d3)));
                    polarMessung.ma = 0;
                    continue;
                }
                polarMessung2.setRichtungMittel(polarMessung);
                polarMessung2.setStreckeMittel(polarMessung);
                if (IOProperties.getHoeheModus() == IOProperties.MODUS_3D) {
                    if (polarMessung.ih == polarMessung2.ih && polarMessung.rh == polarMessung2.rh) {
                        polarMessung2.setZenitMittel(polarMessung);
                        polarMessung.ma = -1;
                        continue block0;
                    }
                    polarMessung.ma = 3;
                    continue block0;
                }
                polarMessung.ma = -1;
                continue block0;
            }
        }
    }

    protected void reduzierePolarMessungen() {
        double d = 0.0;
        for (int i = 0; i < this.M.size(); ++i) {
            Object e = this.M.elementAt(i);
            if (!(e instanceof PolarMessung)) continue;
            PolarMessung polarMessung = (PolarMessung)e;
            if (polarMessung.ma != 1) continue;
            if (polarMessung.pns != 0L) {
                d = polarMessung.r;
                polarMessung.setRichtung(0.0);
                continue;
            }
            polarMessung.setRichtung(polarMessung.r - d);
        }
    }

    protected abstract PolarMessung lineToPolarMessung(String var1) throws IFileInputException, IOException;
}

