/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.io.IFileReader;
import de.geocalc.util.LongHashList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.NoSuchElementException;
import java.util.Vector;

public abstract class IPunktReader
extends IFileReader {
    static boolean reduceY = false;
    static boolean reducePnr = false;
    protected LongHashList HP = null;
    protected Vector VP = null;
    private int lineNumber = 0;
    private int changePoints = 0;
    private LineNumberReader reader = null;

    public static void reduceY(boolean bl) {
        reduceY = bl;
    }

    public static void reducePnr(boolean bl) {
        reducePnr = bl;
    }

    public IPunktReader(File file, LongHashList longHashList) {
        this(file, longHashList, null);
    }

    public IPunktReader(File file, LongHashList longHashList, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.HP = longHashList;
    }

    public IPunktReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.VP = vector;
    }

    protected int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public boolean isUpdateReader() {
        return false;
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
        }
    }

    @Override
    public void read() throws IFileInputException {
        String string = new String();
        try {
            Punkt punkt;
            this.reader = this.createReader();
            long l = 0L;
            while ((string = this.reader.readLine()) != null) {
                this.lineNumber = this.reader.getLineNumber();
                try {
                    punkt = this.lineToPunkt(string);
                    if (punkt == null) continue;
                    this.savePunkt(punkt);
                }
                catch (NumberFormatException numberFormatException) {
                    this.addException(new IFileInputException(this.getErrorKey() + "Lesefehler in Zeile: " + this.reader.getLineNumber() + ", ung\u00fcltige Zeichen vorgefunden oder Wertebereich \u00fcberschritten."));
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    this.addException(new IFileInputException(this.getErrorKey() + "Lesefehler in Zeile: " + this.reader.getLineNumber() + ", vorzeitig Zeilenende erreicht."));
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.addException(new IFileInputException(this.getErrorKey() + "Lesefehler in Zeile: " + this.reader.getLineNumber() + ", vorzeitig Zeilenende erreicht."));
                }
                catch (Exception exception) {
                    this.addException(new IFileInputException(this.getErrorKey() + "Lesefehler in Zeile: " + this.reader.getLineNumber() + ", Zeile kann nicht interpretiert werden."));
                }
                super.setFileProgress(l += (long)(string.length() + 1));
            }
            punkt = this.getLastElement();
            if (punkt != null && this.savePunkt(punkt) != null) {
                ++this.changePoints;
            }
            super.setProgress(100);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IFileInputException(this.getErrorKey() + "Datei " + this.inFile.getName() + " nicht gefunden");
        }
        catch (IOException iOException) {
            throw new IFileInputException(this.getErrorKey() + "Lesefehler in Zeile: " + this.reader.getLineNumber());
        }
        finally {
            try {
                this.reader.close();
            }
            catch (Exception exception) {
                throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
            }
        }
        this.checkErrors();
    }

    protected void checkErrors() {
        int n = 0;
        if (this.HP != null) {
            n = this.HP.size();
        } else if (this.VP != null) {
            n = this.VP.size();
        }
    }

    protected Punkt savePunkt(Punkt punkt) {
        if (reduceY && punkt.y > 1.0E7) {
            punkt.y %= 1.0E7;
        }
        if (reducePnr && punkt.nr > 100000000000000L) {
            punkt.nr %= 100000000000000L;
        }
        if (this.HP != null) {
            return this.savePunkt(punkt, this.HP);
        }
        if (this.VP != null) {
            if (this.isMode(4) && !DataBase.isInArea(punkt.y, punkt.x)) {
                return null;
            }
            if (this.punktFilter != null && !this.punktFilter.isPunktEnabled(punkt)) {
                return null;
            }
            if (this.punktStatus != -9) {
                punkt.setPs(punkt.buildPunktStatus(this.punktStatus));
            }
            this.VP.addElement(punkt);
            return null;
        }
        return null;
    }

    protected abstract Punkt lineToPunkt(String var1) throws Exception;

    protected Punkt getLastElement() {
        return null;
    }
}

