/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktSorter;
import de.geocalc.kafplot.io.IFileWriter;
import de.geocalc.util.LongHashList;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public abstract class IPunktWriter
extends IFileWriter {
    protected LongHashList HP = null;
    protected Vector VP = null;
    protected int sortModus = 1;

    public IPunktWriter(File file, LongHashList longHashList) {
        super(file);
        super.setEndValue(longHashList.size());
        super.setProgressBreak();
        this.HP = longHashList;
    }

    public IPunktWriter(File file, Vector vector) {
        super(file);
        super.setEndValue(vector.size());
        super.setProgressBreak();
        this.VP = vector;
    }

    protected abstract void setParameter();

    public void setSortModus(int n) {
        this.sortModus = n;
    }

    public int getSortModus() {
        return this.sortModus;
    }

    @Override
    public void write() throws IFileOutputException {
        PrintWriter printWriter = null;
        try {
            printWriter = this.createWriter();
            super.setLabelText("Sortiere...");
            super.setLabelValue(-1L);
            super.showProgress();
            PunktSorter punktSorter = this.HP != null ? new PunktSorter(this.HP, this.sortModus) : new PunktSorter(this.VP, this.sortModus);
            punktSorter.setProgressBar(super.getProgressBar());
            this.initValues();
            super.setEndValue(punktSorter.size());
            super.setValue(0L);
            super.setLabelText("ausgegebene Punkte: ");
            super.setLabelValue(0L);
            super.setProgress(0);
            int n = 0;
            int n2 = 0;
            if (this.getHeader() != null) {
                printWriter.println(this.getHeader());
            }
            Vector vector = punktSorter.getSortedVector();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Punkt punkt = (Punkt)enumeration.nextElement();
                if (this.punktFilter.isPunktEnabled(punkt)) {
                    String string = this.punktToLine(punkt);
                    if (string != null) {
                        printWriter.println(string);
                    }
                    ++n2;
                }
                if ((long)n % super.getProgressBreak() == 0L) {
                    super.setLabelValue(n2);
                    super.setProgress(n);
                }
                ++n;
            }
            if (this.getEndOfFile() != null) {
                printWriter.println(this.getEndOfFile());
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim erzeugen der Datei: " + this.outFile.getName());
        }
    }

    protected abstract void initValues();

    protected abstract String getHeader();

    protected abstract String punktToLine(Punkt var1);

    protected abstract String getEndOfFile();
}

