/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.io.IPolarReader;
import de.geocalc.kafplot.io.PolarMessung;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class ItrPolarReader
extends IPolarReader {
    int anzZpk = 0;
    long pns = 0L;
    double ih = 0.0;

    public ItrPolarReader(File file, Vector vector) {
        super(file, vector, null);
    }

    public ItrPolarReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
    }

    @Override
    protected PolarMessung lineToPolarMessung(String string) throws IOException, IFileInputException {
        if (string.length() < 55) {
            return null;
        }
        PolarMessung polarMessung = new PolarMessung();
        int n = Integer.parseInt(string.substring(53, 54));
        if (n == 1) {
            this.pns = Long.parseLong(string.substring(0, 15).trim());
            this.ih = new Double(string.substring(18, 26));
            this.anzZpk = 0;
            return null;
        }
        polarMessung.pns = this.anzZpk == 0 ? this.pns : 0L;
        polarMessung.pnz = Long.parseLong(string.substring(0, 15).trim());
        polarMessung.s = new Double(string.substring(18, 26).trim());
        polarMessung.r = new Double(string.substring(27, 35).trim());
        polarMessung.z = new Double(string.substring(36, 44).trim());
        polarMessung.rh = new Double(string.substring(80, 86).trim());
        polarMessung.ih = this.ih;
        polarMessung.dl = new Double(string.substring(88, 95).trim());
        polarMessung.dq = new Double(string.substring(95, Math.min(string.length(), 102)).trim());
        if (polarMessung.r == 0.0 && this.anzZpk > 0) {
            throw new IFileInputException("Null-Richtung im Richtungssatz");
        }
        if (polarMessung.pns == 0L && this.anzZpk == 0) {
            throw new IFileInputException("Fehlender Standpunkt");
        }
        ++this.anzZpk;
        return polarMessung;
    }
}

