/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.geom.DArc;
import de.geocalc.geom.DCollection;
import de.geocalc.geom.DDimension;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPolygon;
import de.geocalc.geom.DRectangle;
import de.geocalc.geom.GeomElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;

public class KafPlotIOConstants {
    public static final String KPV_HEADER = "#KafPlotViewer";
    public static final int KPV_HEADER_LENGTH = 14;
    public static final byte NO_VALUE = 0;
    public static final byte VALUE = 1;
    public static final byte BOOLEAN_VALUE = 1;
    public static final byte BYTE_VALUE = 2;
    public static final byte SHORT_VALUE = 3;
    public static final byte CHAR_VALUE = 4;
    public static final byte INT_VALUE = 5;
    public static final byte LONG_VALUE = 6;
    public static final byte FLOAT_VALUE = 7;
    public static final byte DOUBLE_VALUE = 8;
    public static final byte STRING_VALUE = 9;
    public static final byte PUNKT_VALUE = 11;
    public static final byte MESSUNG_VALUE = 12;
    public static final byte HOEHE_VALUE = 13;
    public static final byte LINIE_VALUE = 15;
    public static final byte BEDINGUNG_VALUE = 16;
    public static final byte BEMERKUNG_VALUE = 17;
    public static final byte GPS_RISS_VALUE = 21;
    public static final byte POLAR_RISS_VALUE = 22;
    public static final byte MESSBAND_RISS_VALUE = 23;
    public static final byte KATASTER_RISS_VALUE = 24;
    public static final byte EINRECHNUNG_RISS_VALUE = 25;
    public static final byte VORGABE_RISS_VALUE = 26;
    public static final byte HOMOGENISIERUNG_RISS_VALUE = 27;
    public static final byte BEDINGUNG_RISS_VALUE = 28;
    public static final byte TRAFO_SYSTEM_VALUE = 31;
    public static final byte TRAFO_PUNKT_VALUE = 32;
    public static final byte FLST_VALUE = 52;
    public static final byte GEB_VALUE = 53;
    public static final byte GKZ_VALUE = 54;
    public static final byte NUTZ_VALUE = 55;
    public static final byte TOPOBJ_VALUE = 56;
    public static final byte GBBL_VALUE = 57;
    public static final byte NAME_VALUE = 58;
    public static final byte BODEN_VALUE = 59;
    public static final byte TEXT_DECOR_VALUE = 61;
    public static final byte SYMBOL_DECOR_VALUE = 62;
    public static final byte LINE_DECOR_VALUE = 63;
    public static final byte GEMEINDE_VALUE = 71;
    public static final byte GEMARKUNG_VALUE = 72;
    public static final byte STRASSE_VALUE = 73;
    public static final byte AMT_VALUE = 74;
    public static final byte NUTZUNG_VALUE = 75;
    public static final byte VERMARKUNG_VALUE = 76;
    public static final byte LGA_VALUE = 77;
    public static final byte LAGE_VALUE = 81;
    public static final byte LAGE_ENTRY_VALUE = 82;
    public static final byte PUNKT_PARAM_VALUE = 91;
    public static final byte ERROBJECT_VALUE = 92;
    public static final byte LINE_PARAM_VALUE = 93;
    public static final byte MESS_GEW_VALUE = 94;
    public static final byte TRAFO_GEW_VALUE = 95;
    public static final byte DPOINT_VALUE = 101;
    public static final byte DLINE_VALUE = 102;
    public static final byte DARC_VALUE = 103;
    public static final byte DDIMENSION_VALUE = 104;
    public static final byte DRECTANGLE_VALUE = 105;
    public static final byte DPOLYGON_VALUE = 106;
    public static final byte DCOLLECTION_VALUE = 109;
    public static final byte ATTRIBUTE_VALUE = 110;
    public static final byte PROPERTIES_VALUE = 111;
    public static final byte PARAM_VOID = 120;
    public static final byte PARAM_ALK = 121;
    public static final byte PARAM_ALKIS = 122;

    public static void writeString(DataOutput dataOutput, String string) throws IOException {
        if (string != null) {
            dataOutput.writeByte(9);
            dataOutput.writeUTF(string);
        } else {
            dataOutput.writeByte(0);
        }
    }

    public static final String readString(DataInput dataInput) throws IOException {
        if (dataInput.readByte() == 9) {
            return dataInput.readUTF();
        }
        return null;
    }

    public static void writeGeomElement(DataOutput dataOutput, GeomElement geomElement) throws IOException {
        if (geomElement == null) {
            dataOutput.writeByte(0);
        } else if (geomElement instanceof DPoint) {
            DPoint dPoint = (DPoint)geomElement;
            dataOutput.writeByte(101);
            dataOutput.writeDouble(dPoint.y);
            dataOutput.writeDouble(dPoint.x);
        } else if (geomElement instanceof DLine) {
            DLine dLine = (DLine)geomElement;
            dataOutput.writeByte(102);
            dataOutput.writeDouble(dLine.ya);
            dataOutput.writeDouble(dLine.xa);
            dataOutput.writeDouble(dLine.ye);
            dataOutput.writeDouble(dLine.xe);
        } else if (geomElement instanceof DArc) {
            DArc dArc = (DArc)geomElement;
            dataOutput.writeByte(103);
            dataOutput.writeDouble(dArc.ya);
            dataOutput.writeDouble(dArc.xa);
            dataOutput.writeDouble(dArc.ye);
            dataOutput.writeDouble(dArc.xe);
            dataOutput.writeDouble(dArc.r);
        } else if (geomElement instanceof DDimension) {
            DDimension dDimension = (DDimension)geomElement;
            dataOutput.writeByte(104);
            dataOutput.writeDouble(dDimension.width);
            dataOutput.writeDouble(dDimension.height);
        } else if (geomElement instanceof DRectangle) {
            DRectangle dRectangle = (DRectangle)geomElement;
            dataOutput.writeByte(105);
            dataOutput.writeDouble(dRectangle.y);
            dataOutput.writeDouble(dRectangle.x);
            dataOutput.writeDouble(dRectangle.width);
            dataOutput.writeDouble(dRectangle.height);
        } else if (geomElement instanceof DPolygon) {
            DPolygon dPolygon = (DPolygon)geomElement;
            dataOutput.writeByte(106);
            dataOutput.writeInt(dPolygon.npoints);
            for (int i = 0; i < dPolygon.npoints; ++i) {
                dataOutput.writeDouble(dPolygon.ypoints[i]);
                dataOutput.writeDouble(dPolygon.xpoints[i]);
            }
        } else if (geomElement instanceof DCollection) {
            DCollection dCollection = (DCollection)geomElement;
            dataOutput.writeByte(109);
            Enumeration enumeration = dCollection.elements();
            while (enumeration.hasMoreElements()) {
                KafPlotIOConstants.writeGeomElement(dataOutput, (GeomElement)enumeration.nextElement());
            }
            dataOutput.writeByte(0);
        } else {
            throw new IOException("Aufrufer enth\u00e4lt ung\u00fcltiges Geometrieelement: " + String.valueOf(geomElement));
        }
    }

    public static GeomElement readGeomElement(DataInput dataInput) throws IOException {
        byte by = dataInput.readByte();
        if (by == 101) {
            return new DPoint(dataInput.readDouble(), dataInput.readDouble());
        }
        if (by == 102) {
            return new DLine(dataInput.readDouble(), dataInput.readDouble(), dataInput.readDouble(), dataInput.readDouble());
        }
        if (by == 103) {
            return new DArc(dataInput.readDouble(), dataInput.readDouble(), dataInput.readDouble(), dataInput.readDouble(), dataInput.readDouble());
        }
        if (by == 104) {
            return new DDimension(dataInput.readDouble(), dataInput.readDouble());
        }
        if (by == 105) {
            return new DRectangle(dataInput.readDouble(), dataInput.readDouble(), dataInput.readDouble(), dataInput.readDouble());
        }
        if (by == 106) {
            DPolygon dPolygon = new DPolygon(dataInput.readInt());
            for (int i = 0; i < dPolygon.npoints; ++i) {
                dPolygon.addPoint(dataInput.readDouble(), dataInput.readDouble());
            }
            return dPolygon;
        }
        if (by == 109) {
            DCollection dCollection = new DCollection();
            GeomElement geomElement = null;
            while ((geomElement = KafPlotIOConstants.readGeomElement(dataInput)) != null) {
                dCollection.addElement(geomElement);
            }
            return dCollection;
        }
        return null;
    }
}

