/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IException;
import de.geocalc.geom.DPoint;
import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.KatasterParameter;
import de.geocalc.kafplot.Lagegenauigkeit;
import de.geocalc.kafplot.Lagezuverlaessigkeit;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.OrthoLinie;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktIdentitaet;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.PunktSorter;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.SurveyException;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.ValueDataContainer;
import de.geocalc.kafplot.VermarkungsArt;
import de.geocalc.kafplot.io.KatasternachweisIOProperties;
import de.geocalc.kafplot.io.KatasternachweisWriter;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.util.SortableVector;
import de.geocalc.util.sml.Tag;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class KatasternachweisBrbAlkisWriter
extends KatasternachweisWriter {
    private static final int RISS_BEM_MAX_LEN = 40;
    private int rissPage = 1;
    private int identPage = 0;
    private Hashtable writtenPointNrHash = new Hashtable();
    private Hashtable identicPointNrHash = new Hashtable();
    private Hashtable entstehungHash = new Hashtable();
    private static final String KOO_FEHLER = "Koordinaten-Fehler";
    private static final String NEU_KOO = "neue Koo eingef\u00fchrt";
    private static final String NOT_ALKIS = "in ALKIS nicht nachgewiesen";
    private static final String EOL = "\n";
    private static final String RTF_HEADER = "{\\rtf1\\ansi\\deff1\\adeflang1025\n{\\fonttbl{\\f0\\fswiss\\fprq2\\fcharset0 Arial;}}\n{\\colortbl;\\red0\\green0\\blue0;\\red128\\green128\\blue128;\\red255\\green0\\blue0;\\red0\\green128\\blue0;}\n{\\stylesheet{\\s1\\cf0\\ql\\rtlch\\af0\\afs24\\lang1081\\ltrch\\dbch\\af0\\langfe2052\\hich\\f0\\fs24\\lang1031\\loch\\f0\\fs24\\lang1031\\snext1 Normal;}}";
    private static final String CONTENT_HEADER = "{\\*\\Start SeitenInhalt}\n\\ftnbj\\ftnstart1\\ftnrstcont\\ftnnar\\aenddoc\\aftnrstcont\\aftnstart1\\aftnnar";
    private static final String DATA_HEADER = "{\\*\\Start Daten}";
    private static final String RISS_TABLE_HEADER = "{\\*\\Erste Zeile Tabellenkopf Ueberschriften}\\trowd\\trql\\trhdr\\trkeep\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\cellx624\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\cellx1644\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\cellx2268\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\cellx4308\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\cellx6804\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrr\\brdrs\\brdrw10\\brdrcf1\\cellx10205\\trwd\\pard\\plain \\widctlpar\\intbl\\adjustright\\fs16\\qc\\b {OA\\cell PNR\\cell ABM\\cell Vermessungsergebnis\\cell Qualit\\'e4t\\cell Bemerkungen und Hinweise\\cell}\\row{\\*\\Zweite Zeile Tabellenkopf Namen}\\trowd\\trql\\trhdr\\trkeep\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx624\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx1644\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx2268\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx3288\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx4308\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx4932\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx5556\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx6180\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx6804\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clbrdrr\\brdrs\\brdrw10\\brdrcf1\\cellx10205\\trwd\\pard\\plain \\widctlpar\\intbl\\adjustright\\fs16\\qc\\b {\\cell\\cell VMA\\cell y\\cell x\\cell s{\\fs10\\dn4 L}\\cell d{\\fs10\\dn4 K}/d{\\fs10\\dn4 S}\\cell GST\\cell LZK\\cell{\\fs12 \\'fcber \\'c4nderungen an Punktdaten bestehender Objektpunkte und Hinweise zu neuen Objektpunkten}\\cell}\\row{\\*\\Dritte Zeile Tabellenkopf Spaltennummern}\\trowd\\trql\\trhdr\\trkeep\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx624\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx1644\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx2268\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx3288\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx4308\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx4932\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx5556\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx6180\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx6804\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clbrdrr\\brdrs\\brdrw10\\brdrcf1\\cellx10205\\trwd\\pard\\plain \\widctlpar\\intbl\\adjustright\\fs12\\qc {1\\cell 2\\cell 3\\cell 4\\cell 5\\cell 6\\cell 7\\cell 8\\cell 9\\cell 10\\cell}\\row";
    private static final String RISS_TABLE_DATA_LINE_DEF = "\\trowd\\trql\\trkeep\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx624\\clvertalc\\cellx1644\\clvertalc\\cellx2268\\clvertalc\\cellx3288\\clvertalc\\cellx4308\\clvertalc\\cellx4932\\clvertalc\\cellx5556\\clvertalc\\cellx6180\\clvertalc\\cellx6804\\clvertalc\\cellx10205";
    private static final String RISS_TABLE_TEXT_LINE_DEF = "\\trowd\\trql\\trkeep\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx10205";
    private static final String RISS_TABLE_LENGTH_HEADLINE = "\\trwd\\pard\\plain \\widctlpar\\intbl\\adjustright\\f0\\fs16\\ql\\b {\\cell\\qc von PNR\\cell\\ql\\cell\\qc nach PNR\\cell\\cell\\cell\\cell\\cell\\cell\\ql \\cell}\\row";
    private static final String IDENT_TABLE_HEADER = "{\\*\\Erste Kopfzeile Ueberschriften}\n\\trowd\\trql\\trhdr\\trkeep\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\cellx565\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\cellx1359\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\cellx3287\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\cellx5215\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\cellx6689\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\cellx7425\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\cellx8559\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrr\\brdrs\\brdrw10\\brdrcf1\\cellx10205\n\\trwd\\pard\\plain \\widctlpar\\intbl\\adjustright\\fs16\\qc\\b {OA\\cell PNR\\cell Katasternachweis\\line (Soll)\\cell Vermessungsergebnis\\line (Ist)\\cell Soll - Ist\\cell Abw.\\cell Riss / Jahr\\cell Bemerkungen\\cell}\\row\n{\\*\\Zweite Kopfzeile Namen}\n\\trowd\\trql\\trhdr\\trkeep\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx565\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx1359\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx2323\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx3287\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx4251\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx5215\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx5952\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx6689\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx7425\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx8559\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clbrdrr\\brdrs\\brdrw10\\brdrcf1\\cellx10205\n\\trwd\\pard\\plain \\widctlpar\\intbl\\adjustright\\fs16\\qc\\b {\\cell\\cell y\\cell x\\cell y\\cell x\\cell d{\\fs10\\dn4 y}\\cell d{\\fs10\\dn4 x}\\cell d{\\fs10\\dn4 K}/d{\\fs10\\dn4 S}\\cell\\cell\\cell}\\row\n{\\*\\Dritte Kopfzeile Spaltennummern}\n\\trowd\\trql\\trhdr\\trkeep\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx565\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx1359\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx2323\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx3287\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx4251\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx5215\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx5952\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx6689\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx7425\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\cellx8559\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clbrdrr\\brdrs\\brdrw10\\brdrcf1\\cellx10205\n\\trwd\\pard\\plain \\widctlpar\\intbl\\adjustright\\fs12\\qc {1\\cell 2\\cell 3\\cell 4\\cell 5\\cell 6\\cell 7\\cell 8\\cell 9\\cell 10\\cell 11\\cell}\\row";
    private static final String IDENT_TABLE_DATA_LINE_DEF = "\\trowd\\trql\\trkeep\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx565\\clvertalc\\cellx1359\\clvertalc\\cellx2323\\clvertalc\\cellx3287\\clvertalc\\cellx4251\\clvertalc\\cellx5215\\clvertalc\\cellx5952\\clvertalc\\cellx6689\\clvertalc\\cellx7425\\clvertalc\\cellx8559\\clvertalc\\cellx10205";
    private static final String IDENT_TABLE_TEXT_LINE_DEF = "\\trowd\\trql\\trkeep\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\cellx8559\\clvertalc\\cellx10205";
    private static final String ROW_START = "\\trwd\\pard\\plain \\widctlpar\\intbl\\adjustright\\f0\\fs20\\ql";
    private static final String ROW_END = "\\cell\\row";
    private static final String CELL = "\\cell ";
    private static final String END_OF_FILE = "\\pard\\plain\\n{\\*\\bkmkstart LETZTE_SEITE}{\\*\\bkmkend LETZTE_SEITE}\\n\\par }";

    public KatasternachweisBrbAlkisWriter(File file, File file2, DataBase dataBase, int n, int n2) {
        super(file, dataBase);
        this.rissFile = file;
        this.identFile = file2;
        this.db = dataBase;
        this.P = DataBase.P;
        this.P_IDENT = DataBase.P_IDENT;
        this.rissPage = n;
        this.identPage = n2;
    }

    @Override
    public void write() throws IFileOutputException {
        PrintWriter printWriter = null;
        try {
            Object object;
            Object object2;
            Cloneable cloneable;
            Object object3;
            Object object4;
            Object object5;
            Cloneable cloneable2;
            PunktParameter punktParameter;
            Punkt punkt;
            this.checkDatVars();
            StringBuffer stringBuffer = new StringBuffer();
            if (DataBase.gemarkung != null) {
                Gemarkung gemarkung = Gemarkung.getGemarkung(DataBase.gemeinde, DataBase.gemarkung);
                if (gemarkung != null) {
                    stringBuffer.append(gemarkung.getName());
                    stringBuffer.append(" (");
                    stringBuffer.append(GeoNumberFormat.nr06n.format(gemarkung.getNummer()).toString());
                    stringBuffer.append(")");
                } else {
                    stringBuffer.append(DataBase.gemarkung);
                    this.addException(new IException("Keine Gemarkungsnummer f\u00fcr die Gemarkung: " + DataBase.gemarkung + " gefunden.", "\u00dcberpr\u00fcfen Sie die Einstellungen in der Konfigurationsdatei \"gemarkungen.properties\""));
                }
                this.gemarkung = stringBuffer.toString();
            }
            super.setLabelText("Sortiere...");
            super.showProgress();
            this.outFile = this.rissFile;
            printWriter = this.createWriter(this.rissFile);
            int n = 0;
            super.setEndValue(this.P.size());
            super.setProgressBreak();
            super.setValue(0L);
            super.setLabelText("Koordinatenliste erstellen...");
            printWriter.println(RTF_HEADER);
            this.writeDocInfo(printWriter, "VermessungsrissListe");
            this.writePageDef(printWriter, this.rissPage + 1);
            this.writePageHeader(printWriter, "Vermessungsriss - Liste");
            printWriter.println(CONTENT_HEADER);
            printWriter.println(RISS_TABLE_HEADER);
            printWriter.println(DATA_HEADER);
            int n2 = Integer.MIN_VALUE;
            PunktSorter punktSorter = new PunktSorter(this.P, 23);
            punktSorter.setProgressBar(super.getProgressBar());
            Vector vector = punktSorter.getSortedVector();
            Object object6 = vector.elements();
            while (object6.hasMoreElements()) {
                punkt = (Punkt)object6.nextElement();
                punktParameter = punkt.getOldParameter();
                cloneable2 = punkt.getParameter();
                if (this.writeRissPunkt(punkt)) {
                    Object object7;
                    if (punkt.createKooNb() > n2) {
                        n2 = punkt.createKooNb();
                        int n3 = 0;
                        object7 = vector.elements();
                        while (object7.hasMoreElements()) {
                            object5 = (Punkt)object7.nextElement();
                            if (((Punkt)object5).createKooNb() != n2 || !((Punkt)object5).isKatasterNeupunkt() || !this.writeRissPunkt((Punkt)object5)) continue;
                            ++n3;
                        }
                        printWriter.println(RISS_TABLE_TEXT_LINE_DEF);
                        this.writeRissTextLine(printWriter, "", false);
                        this.writeRissTextLine(printWriter, "Nummerierungsbezirk: 3" + Punkt.createNbAsString(punkt.createKooNb()) + " ( " + n3 + " neue PNR)", true);
                        printWriter.println(RISS_TABLE_DATA_LINE_DEF);
                    }
                    stringBuffer = new StringBuffer();
                    if (((PunktParameter)cloneable2).getKafPa() == 0) {
                        String string;
                        stringBuffer.append(punkt.createKatasterPunktString());
                        if (KatasternachweisIOProperties.writeRissBestimmung() && (string = punkt.createBestimmungString()).length() > 0) {
                            stringBuffer.append(" (");
                            stringBuffer.append(string);
                            stringBuffer.append(")");
                        }
                    } else if (punkt.isKatasterPunkt()) {
                        int n4;
                        boolean bl;
                        Object object8;
                        stringBuffer.append(punkt.createKatasterPunktString());
                        String string = punkt.createKoordinateString(KatasternachweisIOProperties.writeRissBestimmung());
                        if (string.length() > 0) {
                            if (stringBuffer.length() > 0) {
                                stringBuffer.append(" ");
                            }
                            stringBuffer.append(string);
                            if (KatasternachweisIOProperties.writeRissBestimmung()) {
                                object7 = punkt.createBestimmungString();
                                if (punkt.isSlavePoint()) {
                                    if (((String)object7).length() > 0) {
                                        if (punkt.getPs() != 1 && punkt.getPs() != 2) {
                                            this.addException(new IException("Rissliste:", "referenzierender Punkt " + punkt.nr + " hat eigene Bestimmung: " + (String)object7));
                                            object5 = DataBase.P.getMaster(punkt);
                                            if (object5 != null && ((String)(object4 = ((Punkt)object5).createBestimmungString())).length() > 0) {
                                                object7 = object4;
                                            }
                                        }
                                    } else {
                                        object5 = DataBase.P.getMaster(punkt);
                                        if (object5 != null) {
                                            object7 = ((Punkt)object5).createBestimmungString();
                                        }
                                    }
                                }
                                if (((String)object7).length() > 0) {
                                    stringBuffer.append(" (");
                                    stringBuffer.append((String)object7);
                                    stringBuffer.append(")");
                                }
                            }
                        }
                        int n5 = stringBuffer.length();
                        object5 = punkt.createKoordinateZusatzString().replace(" ", "\\~");
                        if (((String)object5).length() > 0) {
                            if (n5 + ((String)object5).length() + 2 > 40) {
                                stringBuffer.append("\\par ");
                                n5 = ((String)object5).length();
                            } else if (n5 > 0) {
                                stringBuffer.append(", ");
                                n5 += ((String)object5).length() + 2;
                            } else {
                                n5 = ((String)object5).length();
                            }
                            stringBuffer.append((String)object5);
                        }
                        if (((String)(object4 = punkt.createAttStatusString())).length() > 0) {
                            if (n5 + ((String)object4).length() + 2 > 40) {
                                stringBuffer.append("\\par ");
                                n5 = ((String)object4).length();
                            } else if (n5 > 0) {
                                stringBuffer.append(", ");
                                n5 += ((String)object4).length() + 2;
                            } else {
                                n5 = ((String)object4).length();
                            }
                            stringBuffer.append((String)object4);
                        }
                        if (punkt.isKatasterNeupunktBestand()) {
                            stringBuffer.append("\\par in ALKIS nicht nachgewiesen");
                            object8 = this.createHerkunftBestandString(punkt);
                            if (object8 != null) {
                                stringBuffer.append("\\par ");
                                stringBuffer.append("aus " + (String)object8);
                            }
                        }
                        if (punkt.isIndirektPoint()) {
                            KatasternachweisBrbAlkisWriter katasternachweisBrbAlkisWriter = this;
                            object8 = katasternachweisBrbAlkisWriter.db.punkte();
                            while (object8.hasMoreElements()) {
                                Punkt punkt2 = (Punkt)object8.nextElement();
                                if (!punkt2.hasTag("IND") || Long.parseLong(punkt2.getTag("IND").getValue()) != punkt.nr) continue;
                                stringBuffer.append("\\par indirekt durch " + KatasternachweisBrbAlkisWriter.getPaString(punkt2) + " " + KatasternachweisBrbAlkisWriter.getPnrString(punkt2) + " abgemarkt");
                                break;
                            }
                        } else if (punkt.hasTag("IND")) {
                            object8 = (Punkt)DataBase.P.get(Long.parseLong(punkt.getTag("IND").getValue()));
                            if (object8 != null) {
                                stringBuffer.append("\\par indirekte Abmarkung f\u00fcr " + KatasternachweisBrbAlkisWriter.getPaString((Punkt)object8) + " " + KatasternachweisBrbAlkisWriter.getPnrString((Punkt)object8));
                            }
                        }
                        if (punkt.isSlavePoint()) {
                            object8 = DataBase.P.getMaster(punkt);
                            if (object8 != null) {
                                stringBuffer.append("\\par " + KatasternachweisBrbAlkisWriter.getPaString(punkt) + " = " + KatasternachweisBrbAlkisWriter.getPaString((Punkt)object8) + " " + KatasternachweisBrbAlkisWriter.getPnrString((Punkt)object8));
                                if (punkt.getPst() == 13) {
                                    stringBuffer.append(", " + KatasternachweisBrbAlkisWriter.getPaString(punkt) + "\\~untergegangen");
                                } else if (((Punkt)object8).getPst() == 13) {
                                    stringBuffer.append(", " + KatasternachweisBrbAlkisWriter.getPaString((Punkt)object8) + "\\~untergegangen");
                                }
                            }
                        } else if (punkt.isMasterPoint()) {
                            object8 = DataBase.P.getSlave(punkt);
                            if (object8 != null) {
                                stringBuffer.append("\\par " + KatasternachweisBrbAlkisWriter.getPaString(punkt) + " = " + KatasternachweisBrbAlkisWriter.getPaString((Punkt)object8) + " " + KatasternachweisBrbAlkisWriter.getPnrString((Punkt)object8));
                                if (punkt.getPst() == 13) {
                                    stringBuffer.append(", " + KatasternachweisBrbAlkisWriter.getPaString(punkt) + "\\~untergegangen");
                                } else if (((Punkt)object8).getPst() == 13) {
                                    stringBuffer.append(", " + KatasternachweisBrbAlkisWriter.getPaString((Punkt)object8) + "\\~untergegangen");
                                }
                            }
                        } else if (punkt.getPst() == 13) {
                            if (stringBuffer.length() > 0) {
                                stringBuffer.append(", ");
                            }
                            stringBuffer.append("Punkt\\~untergegangen");
                        }
                        boolean bl2 = bl = ((PunktParameter)cloneable2).getPst() != 13 && ((PunktParameter)cloneable2).getKafVva() != 19;
                        if (!bl) {
                            try {
                                ((PunktParameter)cloneable2).checkConsistency();
                            }
                            catch (Exception exception) {
                                if (stringBuffer.length() != 0) {
                                    stringBuffer.append("\\par ");
                                }
                                stringBuffer.append(this.createHiddenString(exception.getMessage()));
                                this.addException(new IException("Rissliste:", "Punkt " + punkt.nr + " " + exception.getMessage()));
                            }
                        } else {
                            int n6;
                            int n7;
                            int n8;
                            int n9;
                            if (KatasternachweisIOProperties.testLGA() && !Lagegenauigkeit.isValidFortfuehrung(n9 = ((PunktParameter)cloneable2).getModLg(), 2)) {
                                if (KatasternachweisIOProperties.writeRissBemerkung()) {
                                    if (stringBuffer.length() != 0) {
                                        stringBuffer.append("\\par ");
                                    }
                                    stringBuffer.append(this.createHiddenString("unzul\u00e4ssige GST"));
                                }
                                this.addException(new IException("Rissliste:", "Der Punkt " + punkt.nr + " hat die unzul. GST=" + ((PunktParameter)cloneable2).getOutLg()));
                            }
                            if (KatasternachweisIOProperties.testLZK() && ((PunktParameter)cloneable2).getKafPa() == 1 && !Lagezuverlaessigkeit.isValidFortfuehrung(n8 = ((PunktParameter)cloneable2).getModLz(), 2)) {
                                if (KatasternachweisIOProperties.writeRissBemerkung()) {
                                    if (stringBuffer.length() != 0) {
                                        stringBuffer.append("\\par ");
                                    }
                                    stringBuffer.append(this.createHiddenString("unzul\u00e4ssige LZK"));
                                }
                                this.addException(new IException("Rissliste:", "Der Punkt " + punkt.nr + " hat die unzul. LZK=" + ((PunktParameter)cloneable2).getOutLz()));
                            }
                            if (KatasternachweisIOProperties.testEA() && (n7 = ((PunktParameter)cloneable2).getModEa()) != 1) {
                                if (KatasternachweisIOProperties.writeRissBemerkung()) {
                                    if (stringBuffer.length() != 0) {
                                        stringBuffer.append("\\par ");
                                    }
                                    stringBuffer.append(this.createHiddenString("unzul\u00e4ssige DES1"));
                                }
                                this.addException(new IException("Rissliste:", "Der Punkt " + punkt.nr + " hat die unzul. DES1=" + ((PunktParameter)cloneable2).getOutEa()));
                            }
                            if (KatasternachweisIOProperties.testEQ() && (n6 = ((PunktParameter)cloneable2).getModEq()) != 1000) {
                                if (KatasternachweisIOProperties.writeRissBemerkung()) {
                                    if (stringBuffer.length() != 0) {
                                        stringBuffer.append("\\par ");
                                    }
                                    stringBuffer.append(this.createHiddenString("unzul\u00e4ssige DES2"));
                                }
                                this.addException(new IException("Rissliste:", "Der Punkt " + punkt.nr + " hat die unzul. DES2=" + ((PunktParameter)cloneable2).getOutEq()));
                            }
                            switch (punkt.getPs()) {
                                case 1: {
                                    break;
                                }
                                default: {
                                    if (KatasternachweisIOProperties.testSP() && punkt.getSP() == 0.0f) {
                                        if (KatasternachweisIOProperties.writeRissBemerkung()) {
                                            if (stringBuffer.length() != 0) {
                                                stringBuffer.append("\\par ");
                                            }
                                            stringBuffer.append(this.createHiddenString("unkontrollierte Bestimmung"));
                                        }
                                        this.addException(new IException("Rissliste:", "Der Punkt " + punkt.nr + " wurde unkontrolliert bestimmt"));
                                    }
                                    if (!punkt.isLageFestgelegt() || !KatasternachweisIOProperties.testSP()) break;
                                    if (!((double)punkt.getRissSP() > DataBase.KPG)) break;
                                    if (KatasternachweisIOProperties.writeRissBemerkung()) {
                                        if (stringBuffer.length() != 0) {
                                            stringBuffer.append("\\par ");
                                        }
                                        stringBuffer.append(this.createHiddenString("unzul\u00e4ssige Lagegenauigkeit"));
                                    }
                                    this.addException(new IException("Rissliste:", "Der Punkt " + punkt.nr + " wurde mit unzul. Lagegenauigkeit bestimmt"));
                                }
                            }
                        }
                        if (KatasternachweisIOProperties.testABM()) {
                            int n10 = ((PunktParameter)cloneable2).getModVa();
                            if (((PunktParameter)cloneable2).getKafPa() == 1) {
                                switch (n10) {
                                    case 1230: 
                                    case 1620: {
                                        if (!bl) break;
                                        this.addException(new IException("Rissliste:", "Der Punkt " + punkt.nr + " hat eine typische Untervermarkung als ABM"));
                                        break;
                                    }
                                    case 1000: 
                                    case 1100: 
                                    case 1111: 
                                    case 1120: 
                                    case 1140: 
                                    case 1200: 
                                    case 1300: 
                                    case 1400: 
                                    case 1500: 
                                    case 1630: 
                                    case 1640: 
                                    case 1711: 
                                    case 1712: 
                                    case 1713: 
                                    case 1714: 
                                    case 1800: 
                                    case 2230: 
                                    case 9500: 
                                    case 9600: {
                                        break;
                                    }
                                    case 9998: {
                                        if (!bl) break;
                                    }
                                    default: {
                                        if (KatasternachweisIOProperties.writeRissBemerkung()) {
                                            if (stringBuffer.length() != 0) {
                                                stringBuffer.append("\\par ");
                                            }
                                            stringBuffer.append(this.createHiddenString("unzul\u00e4ssige ABM"));
                                        }
                                        this.addException(new IException("Rissliste:", "Der Punkt " + punkt.nr + " hat die unzul. ABM=" + n10));
                                        break;
                                    }
                                }
                            } else if (((PunktParameter)cloneable2).getKafPa() == 7 || ((PunktParameter)cloneable2).getModPa() == 60) {
                                switch (n10) {
                                    case 1000: 
                                    case 1100: 
                                    case 1111: 
                                    case 1120: 
                                    case 1140: 
                                    case 1200: 
                                    case 1230: 
                                    case 1300: 
                                    case 1400: 
                                    case 1500: 
                                    case 1620: 
                                    case 1630: 
                                    case 1640: 
                                    case 1800: 
                                    case 9500: {
                                        break;
                                    }
                                    case 9998: {
                                        if (!bl) break;
                                    }
                                    default: {
                                        if (KatasternachweisIOProperties.writeRissBemerkung()) {
                                            if (stringBuffer.length() != 0) {
                                                stringBuffer.append("\\par ");
                                            }
                                            stringBuffer.append(this.createHiddenString("unzul\u00e4ssige VMA"));
                                        }
                                        this.addException(new IException("Rissliste:", "Der Punkt " + punkt.nr + " hat die unzul. VMA=" + n10));
                                        break;
                                    }
                                }
                            } else if (n10 != 0) {
                                this.addException(new IException("Rissliste:", "Der Punkt " + punkt.nr + " hat unzul. ABM/VMA=" + n10));
                            }
                            int n11 = ((PunktParameter)cloneable2).getModVb();
                            if (((PunktParameter)cloneable2).getKafPa() == 1) {
                                if ((punkt.isKatasterNeupunkt() || punkt.isVermarkungGeaendert() || ((PunktParameter)cloneable2).getKafVa() == 4) && ((PunktParameter)cloneable2).getPst() != 13 && n11 != 1000 && n11 != 4000) {
                                    if (KatasternachweisIOProperties.writeRissBemerkung()) {
                                        if (stringBuffer.length() != 0) {
                                            stringBuffer.append("\\par ");
                                        }
                                        stringBuffer.append(this.createHiddenString("unzul\u00e4ssige BZA"));
                                    }
                                    this.addException(new IException("Rissliste:", "Der Punkt " + punkt.nr + " hat die unzul. BZA=" + n11));
                                }
                            } else if (n11 != 0) {
                                if (KatasternachweisIOProperties.writeRissBemerkung()) {
                                    if (stringBuffer.length() != 0) {
                                        stringBuffer.append("\\par ");
                                    }
                                    stringBuffer.append(this.createHiddenString("unzul\u00e4ssige BZA"));
                                }
                                this.addException(new IException("Rissliste:", "Der Punkt " + punkt.nr + " hat die unzul. BZA=" + n11));
                            }
                        }
                        if (((PunktParameter)cloneable2).getPst() != 13 && KatasternachweisIOProperties.testLS() && (n4 = ((PunktParameter)cloneable2).getModLs()) != 1000) {
                            if (KatasternachweisIOProperties.writeRissBemerkung()) {
                                if (stringBuffer.length() != 0) {
                                    stringBuffer.append("\\par ");
                                }
                                stringBuffer.append(this.createHiddenString("unzul\u00e4ssige KST"));
                            }
                            this.addException(new IException("Rissliste:", "Der Punkt " + punkt.nr + " hat die unzul. KST=" + ((PunktParameter)cloneable2).getOutLs()));
                        }
                    }
                    if (punkt.hasTag("rissliste.bem")) {
                        Tag tag = Tag.parseTag(punkt.getBemerkung(), "rissliste.bem");
                        switch (tag.getControl()) {
                            case '#': {
                                stringBuffer = new StringBuffer(tag.getValue() + " " + stringBuffer.toString());
                                break;
                            }
                            case '!': {
                                stringBuffer = new StringBuffer(tag.getValue());
                                break;
                            }
                            default: {
                                stringBuffer.append(" ");
                                stringBuffer.append(tag.getValue());
                            }
                        }
                    }
                    this.writeRissPointLine(printWriter, punkt, stringBuffer.toString());
                    object3 = this.writtenPointNrHash.put(KatasternachweisBrbAlkisWriter.getPaString(punkt) + "_" + KatasternachweisBrbAlkisWriter.getPnrString(punkt), punkt);
                    if (object3 != null) {
                        this.identicPointNrHash.put(new Long(((Punkt)object3).nr), punkt);
                        this.identicPointNrHash.put(new Long(punkt.nr), punkt);
                    }
                    if ((long)n % super.getProgressBreak() == 0L) {
                        super.setProgress(n);
                    }
                }
                ++n;
            }
            object6 = new Vector();
            punktParameter = null;
            cloneable2 = null;
            if (KatasternachweisIOProperties.writeWithGrenzen()) {
                printWriter.println(RISS_TABLE_TEXT_LINE_DEF);
                this.writeRissTextLine(printWriter, "", true);
                this.writeRissTextLine(printWriter, "\u00d6rtliche Grenzl\u00e4ngen", true);
                printWriter.println(RISS_TABLE_DATA_LINE_DEF);
                if (KatasternachweisIOProperties.writeShortLines()) {
                    printWriter.println(RISS_TABLE_LENGTH_HEADLINE);
                }
                super.setEndValue(DataBase.FLST.size());
                super.setProgressBreak();
                super.setValue(0L);
                super.setLabelText("Grenzl\u00e4ngenliste erstellen...");
                object3 = new SortableVector();
                int n12 = 0;
                while (true) {
                    if (n12 >= DataBase.FLST.size()) break;
                    object5 = (Flurstueck)DataBase.FLST.elementAt(n12);
                    object4 = ((Flurstueck)object5).getKatasterNachweisLinien(this.getExceptionList()).elements();
                    while (object4.hasMoreElements()) {
                        Linie linie = (Linie)object4.nextElement();
                        if (!linie.pa.isFortfuehrung() || !linie.pe.isFortfuehrung()) continue;
                        KatasternachweisBrbAlkisWriter katasternachweisBrbAlkisWriter = this;
                        if (katasternachweisBrbAlkisWriter.db.hasMenge()) {
                            if (!DataBase.MENGE.contains(linie.pa)) continue;
                            if (!DataBase.MENGE.contains(linie.pe)) continue;
                        }
                        if (this.lineIsWritten(linie, (Vector)object6)) continue;
                        Linie linie2 = (Linie)linie.clone();
                        if (linie.pa.getNr() > linie.pe.getNr()) {
                            linie2.skip();
                        }
                        ((Vector)object3).addElement(linie2);
                    }
                    ++n12;
                }
                ((SortableVector)object3).sort(new KatasternachweisWriter.LineComparator(this));
                for (n12 = 0; n12 < ((Vector)object3).size(); ++n12) {
                    object5 = (Linie)((Vector)object3).elementAt(n12);
                    if (KatasternachweisIOProperties.writeShortLines()) {
                        this.writeRissLengthShortLine(printWriter, (Linie)object5);
                    } else {
                        this.writeRissLengthLongLines(printWriter, (Linie)object5, cloneable2 == null || !((Punkt)cloneable2).equals(((Linie)object5).pa));
                    }
                    cloneable2 = ((Linie)object5).pe;
                    if ((long)n12 % super.getProgressBreak() != 0L) continue;
                    super.setProgress(n);
                }
            }
            if (KatasternachweisIOProperties.writeWithGebaeude()) {
                printWriter.println(RISS_TABLE_TEXT_LINE_DEF);
                this.writeRissTextLine(printWriter, "", true);
                this.writeRissTextLine(printWriter, "\u00d6rtliche Geb\u00e4udel\u00e4ngen", true);
                printWriter.println(RISS_TABLE_DATA_LINE_DEF);
                if (KatasternachweisIOProperties.writeShortLines()) {
                    printWriter.println(RISS_TABLE_LENGTH_HEADLINE);
                }
                super.setEndValue(DataBase.GEB.size());
                super.setProgressBreak();
                super.setValue(0L);
                super.setLabelText("Geb\u00e4udel\u00e4ngenliste erstellen...");
                punkt = null;
                punktParameter = null;
                cloneable2 = null;
                object3 = new SortableVector();
                int n13 = 0;
                while (true) {
                    if (n13 >= DataBase.GEB.size()) break;
                    object5 = (Gebaeude)DataBase.GEB.elementAt(n13);
                    object4 = ((Gebaeude)object5).getKatasterNachweisLinien(this.getExceptionList()).elements();
                    while (object4.hasMoreElements()) {
                        Linie linie = (Linie)object4.nextElement();
                        if (linie.getLa() != 3 || !linie.pa.isFortfuehrung() || !linie.pe.isFortfuehrung()) continue;
                        KatasternachweisBrbAlkisWriter katasternachweisBrbAlkisWriter = this;
                        if (katasternachweisBrbAlkisWriter.db.hasMenge()) {
                            if (!DataBase.MENGE.contains(linie.pa)) continue;
                            if (!DataBase.MENGE.contains(linie.pe)) continue;
                        }
                        if (this.lineIsWritten(linie, (Vector)object6)) continue;
                        Linie linie3 = (Linie)linie.clone();
                        if (linie.pa.getNr() > linie.pe.getNr()) {
                            linie3.skip();
                        }
                        ((Vector)object3).addElement(linie3);
                    }
                    ++n13;
                }
                ((SortableVector)object3).sort(new KatasternachweisWriter.LineComparator(this));
                for (n13 = 0; n13 < ((Vector)object3).size(); ++n13) {
                    object5 = (Linie)((Vector)object3).elementAt(n13);
                    if (KatasternachweisIOProperties.writeShortLines()) {
                        this.writeRissLengthShortLine(printWriter, (Linie)object5);
                    } else {
                        this.writeRissLengthLongLines(printWriter, (Linie)object5, cloneable2 == null || !((Punkt)cloneable2).equals(((Linie)object5).pa));
                    }
                    cloneable2 = ((Linie)object5).pe;
                    if ((long)n13 % super.getProgressBreak() != 0L) continue;
                    super.setProgress(n);
                }
            }
            printWriter.println(END_OF_FILE);
            printWriter.close();
            n = 0;
            super.setEndValue(DataBase.MK.size());
            super.setProgressBreak();
            super.setValue(n);
            super.setLabelText("Punktidentit\u00e4tsliste erstellen...");
            KatasterParameter.USE_GEWICHTE = KatasternachweisIOProperties.useGewichte();
            this.outFile = this.identFile;
            printWriter = this.createWriter(this.identFile);
            object3 = DataBase.MK.elements();
            while (object3.hasMoreElements()) {
                Riss riss = (Riss)object3.nextElement();
                if (riss.hasEntstehung()) {
                    this.entstehungHash.put(riss.getEntstehung(), riss.getName());
                }
                ++n;
            }
            printWriter.println(RTF_HEADER);
            this.writeDocInfo(printWriter, "PINListe");
            this.writePageDef(printWriter, this.identPage + 1);
            this.writePageHeader(printWriter, "Nachweis der Punktidentit\u00e4t");
            printWriter.println(CONTENT_HEADER);
            printWriter.println(IDENT_TABLE_HEADER);
            printWriter.println(DATA_HEADER);
            object3 = null;
            int n14 = 0;
            int n15 = 0;
            object4 = null;
            Object var15_31 = null;
            OrthoLinie orthoLinie = null;
            String string = null;
            String string2 = null;
            String string3 = null;
            Enumeration enumeration = DataBase.MK.elements();
            while (enumeration.hasMoreElements()) {
                cloneable = (Riss)enumeration.nextElement();
                object3 = ((ValueDataContainer)cloneable).getName();
                block48: for (int i = 0; i < ((DataContainer)cloneable).size(); ++i) {
                    object2 = (Messung)((DataContainer)cloneable).elementAt(i);
                    if (!((Messung)object2).isOn()) continue;
                    switch (((Messung)object2).getMessungsArt(true)) {
                        case 240: {
                            if (((Messung)object2).hasTag("NO") || ((Messung)object2).hasTag("NO2")) continue block48;
                            double d = ((Messung)object2).l2;
                            object2 = (Messung)((Messung)object2).clone();
                            ((Messung)object2).l1 = d;
                            ((Messung)object2).l2 = 0.0;
                        }
                        case 220: 
                        case 260: {
                            if (((Messung)object2).hasTag("NO")) continue block48;
                            string2 = this.createIdentVermarkungString(((Messung)object2).ps);
                            string3 = this.createIdentVermarkungString(((Messung)object2).pz);
                            PunktIdentitaet punktIdentitaet = (PunktIdentitaet)this.P_IDENT.get(new Long(((Messung)object2).ps.nr));
                            if (punktIdentitaet != null) {
                                if (!this.writeMessPunkt(punktIdentitaet.soll) || !this.writeMessPunkt(((Messung)object2).pz)) continue block48;
                                this.writeStreckeAsIdentLine(printWriter, (Messung)object2, new Messung(((Messung)object2).ma, ((Messung)object2).ps, ((Messung)object2).pz, DataBase.getStrecke(punktIdentitaet.ist, ((Messung)object2).pz), 0.0), (String)object3, punktIdentitaet.bemIst, string3, ((Messung)object2).getText());
                                this.writeStreckeAsIdentLine(printWriter, (Messung)object2, new Messung(((Messung)object2).ma, ((Messung)object2).ps, ((Messung)object2).pz, DataBase.getStrecke(((Messung)object2).ps, ((Messung)object2).pz), 0.0), (String)object3, punktIdentitaet.bemSoll, string3, ((Messung)object2).getText());
                                continue block48;
                            }
                            punktIdentitaet = (PunktIdentitaet)this.P_IDENT.get(new Long(((Messung)object2).pz.nr));
                            if (punktIdentitaet != null) {
                                if (!this.writeMessPunkt(punktIdentitaet.soll) || !this.writeMessPunkt(((Messung)object2).ps)) continue block48;
                                this.writeStreckeAsIdentLine(printWriter, (Messung)object2, new Messung(((Messung)object2).ma, ((Messung)object2).ps, ((Messung)object2).pz, DataBase.getStrecke(((Messung)object2).ps, punktIdentitaet.ist), 0.0), (String)object3, string2, punktIdentitaet.bemIst, ((Messung)object2).getText());
                                this.writeStreckeAsIdentLine(printWriter, (Messung)object2, new Messung(((Messung)object2).ma, ((Messung)object2).ps, ((Messung)object2).pz, DataBase.getStrecke(((Messung)object2).ps, ((Messung)object2).pz), 0.0), (String)object3, string2, punktIdentitaet.bemSoll, ((Messung)object2).getText());
                                continue block48;
                            }
                            if (!this.writeMessPunkt(((Messung)object2).ps) || !this.writeMessPunkt(((Messung)object2).pz)) continue block48;
                            object = new Messung(((Messung)object2).ma, ((Messung)object2).ps, ((Messung)object2).pz, DataBase.getStrecke(((Messung)object2).ps, ((Messung)object2).pz), 0.0);
                            if (Math.abs(((Messung)object).l1 - ((Messung)object2).l1) > this.db.getKatasterStreckenGenauigkeit(((Messung)object2).l1, ((Messung)object2).getGewichte().getG1())) {
                                if (((Messung)object2).isFehler()) {
                                    string = "fehlerhaftes Ma\u00df";
                                } else {
                                    string = "unzul. Abweichung";
                                    this.addException(new SurveyException("Identit\u00e4tliste:\n     unzul\u00e4ssige Strecken-Abweichung zwischen den Punkten " + ((Messung)object2).ps.getNr() + " und " + ((Messung)object2).pz.getNr()));
                                }
                            } else {
                                string = null;
                            }
                            this.writeStreckeAsIdentLine(printWriter, (Messung)object2, (Messung)object, (String)object3, string2, string3, ((Messung)object2).hasText() ? ((Messung)object2).getText() : string);
                            continue block48;
                        }
                        case 210: {
                            n14 = -1;
                            n15 = -1;
                        }
                        case 200: {
                            if (!this.writeMessPunkt(((Messung)object2).ps) && !this.writeMessPunkt(((Messung)object2).pz) || !((Messung)object2).isOn() || ((Messung)object2).hasTag("NO")) continue block48;
                            if (n14 < 0) {
                                orthoLinie = new OrthoLinie();
                                orthoLinie.setAnfangsPunkt(((Messung)object2).pz != null && ((Messung)object2).pz.nr != 0L ? ((Messung)object2).pz : ((Messung)object2).ps);
                                orthoLinie.setAnfangsMasse(((Messung)object2).l1, ((Messung)object2).pz != null && ((Messung)object2).pz.nr != 0L ? 0.0 : ((Messung)object2).l2);
                                n14 = i;
                            }
                            orthoLinie.setEndPunkt(((Messung)object2).pz != null && ((Messung)object2).pz.nr != 0L ? ((Messung)object2).pz : ((Messung)object2).ps);
                            orthoLinie.setEndOrdinate(((Messung)object2).pz != null && ((Messung)object2).pz.nr != 0L ? 0.0 : ((Messung)object2).l2);
                            n15 = i;
                            continue block48;
                        }
                        case 290: {
                            PunktIdentitaet punktIdentitaet;
                            if ((this.writeMessPunkt(((Messung)object2).ps) || this.writeMessPunkt(((Messung)object2).pz)) && ((Messung)object2).isOn() && !((Messung)object2).hasTag("NO") && n14 >= 0) {
                                orthoLinie.setEndPunkt(((Messung)object2).pz != null && ((Messung)object2).pz.nr != 0L ? ((Messung)object2).pz : ((Messung)object2).ps);
                                orthoLinie.setEndOrdinate(((Messung)object2).pz != null && ((Messung)object2).pz.nr != 0L ? 0.0 : ((Messung)object2).l2);
                                n15 = i;
                            }
                            boolean bl = false;
                            if (n14 < 0 || n14 >= n15) continue block48;
                            block49: for (int j = n14; j <= n15; ++j) {
                                Messung messung = (Messung)((DataContainer)cloneable).elementAt(j);
                                Messung messung2 = null;
                                if (!messung.isOn() || messung.hasTag("NO")) continue;
                                switch (messung.getMessungsArt(true)) {
                                    case 240: {
                                        if (messung.hasTag("NO1")) continue block49;
                                        string2 = this.createIdentVermarkungString(messung.ps);
                                        punktIdentitaet = (PunktIdentitaet)this.P_IDENT.get(new Long(messung.ps.nr));
                                        if (punktIdentitaet != null) {
                                            if (!this.writeMessPunkt(punktIdentitaet.soll) || !this.writeMessPunkt(messung.pz)) continue block49;
                                            messung2 = orthoLinie.getMessungOf(punktIdentitaet.ist);
                                            this.writeOrthoAsIdentLine(printWriter, new Messung(messung.ma, punktIdentitaet.soll, punktIdentitaet.soll, messung.l1, 0.0), new Messung(messung.ma, punktIdentitaet.soll, punktIdentitaet.soll, messung2.l1, messung2.l2), (String)object3, punktIdentitaet.bemIst);
                                            bl = true;
                                        }
                                        if (!this.writeMessPunkt(messung.ps) || !this.writeMessPunkt(messung.pz)) continue block49;
                                        messung2 = orthoLinie.getMessungOf(messung.ps);
                                        if (Math.abs(messung2.l1 - messung.l1) > this.db.getKatasterStreckenGenauigkeit(messung.l1 - orthoLinie.getAnfangsMass(), messung.getGewichte().getG1()) || Math.abs(messung2.l2) > this.db.getKatasterStreckenGenauigkeit(0.0, messung.getGewichte().getG2())) {
                                            if (messung.isFehler()) {
                                                string = messung.hasText() ? messung.getText() : "fehlerhaftes Ma\u00df";
                                            } else {
                                                string = messung.hasText() ? messung.getText() : "unzul. Abweichung";
                                                this.addException(new SurveyException("Identit\u00e4tliste:\n     unzul\u00e4ssige Linien-Abweichung in Punkt " + messung.ps.getNr()));
                                            }
                                        } else {
                                            string = messung.getText();
                                        }
                                        this.writeOrthoAsIdentLine(printWriter, new Messung(messung.ma, messung.ps, messung.pz, messung.l1, 0.0), new Messung(messung.ma, messung.ps, messung.ps, messung2.l1, messung2.l2), (String)object3, punktIdentitaet != null ? punktIdentitaet.bemSoll : string2);
                                        bl = true;
                                        continue block49;
                                    }
                                    case 200: 
                                    case 210: 
                                    case 290: {
                                        if (!messung.hasTag("NO2") && messung.pz != null && messung.pz.nr != 0L) {
                                            string3 = this.createIdentVermarkungString(messung.pz);
                                            punktIdentitaet = (PunktIdentitaet)this.P_IDENT.get(new Long(messung.pz.nr));
                                            if (punktIdentitaet != null && this.writeMessPunkt(punktIdentitaet.soll)) {
                                                messung2 = orthoLinie.getMessungOf(punktIdentitaet.ist);
                                                this.writeOrthoAsIdentLine(printWriter, new Messung(messung.ma, punktIdentitaet.soll, punktIdentitaet.soll, messung.l1, 0.0), new Messung(messung.ma, punktIdentitaet.soll, punktIdentitaet.soll, messung2.l1, messung2.l2), (String)object3, punktIdentitaet.bemIst);
                                                bl = true;
                                            }
                                            if (this.writeMessPunkt(messung.pz)) {
                                                messung2 = orthoLinie.getMessungOf(messung.pz);
                                                if (messung.getWerteBelegung() > 0 && (Math.abs(messung2.l1 - messung.l1) > this.db.getKatasterStreckenGenauigkeit(messung.l1 - orthoLinie.getAnfangsMass(), messung.getGewichte().getG1()) || Math.abs(messung2.l2) > this.db.getKatasterStreckenGenauigkeit(0.0, messung.getGewichte().getG2()))) {
                                                    if (messung.isFehler()) {
                                                        string = messung.hasText() ? messung.getText() : "fehlerhaftes Ma\u00df";
                                                    } else {
                                                        string = messung.hasText() ? messung.getText() : "unzul. Abweichung";
                                                        this.addException(new SurveyException("Identit\u00e4tliste:\n     unzul\u00e4ssige Linien-Abweichung in Punkt " + messung.ps.getNr()));
                                                    }
                                                } else {
                                                    string = messung.hasText() ? messung.getText() : string3;
                                                }
                                                this.writeOrthoAsIdentLine(printWriter, new Messung(messung.ma, messung.ps, messung.pz, messung.l1, 0.0, messung.getWerteBelegung()), new Messung(messung.ma, messung.pz, messung.pz, messung2.l1, messung2.l2, messung.getWerteBelegung()), (String)object3, punktIdentitaet != null ? punktIdentitaet.bemSoll : string);
                                                bl = true;
                                            }
                                        }
                                        if (messung.hasTag("NO1")) continue block49;
                                        string2 = this.createIdentVermarkungString(messung.ps);
                                        punktIdentitaet = (PunktIdentitaet)this.P_IDENT.get(new Long(messung.ps.nr));
                                        if (punktIdentitaet != null && this.writeMessPunkt(punktIdentitaet.soll)) {
                                            messung2 = orthoLinie.getMessungOf(punktIdentitaet.ist);
                                            this.writeOrthoAsIdentLine(printWriter, messung, new Messung(messung.ma, punktIdentitaet.soll, punktIdentitaet.soll, messung2.l1, messung2.l2), (String)object3, punktIdentitaet.bemIst);
                                            bl = true;
                                        }
                                        if (!this.writeMessPunkt(messung.ps)) continue block49;
                                        messung2 = orthoLinie.getMessungOf(messung.ps);
                                        if (messung.getWerteBelegung() > 0 && (Math.abs(messung2.l1 - messung.l1) > this.db.getKatasterStreckenGenauigkeit(messung.l1 - orthoLinie.getAnfangsMass(), messung.getGewichte().getG1()) || Math.abs(messung2.l2 - messung.l2) > this.db.getKatasterStreckenGenauigkeit(messung.l2, messung.getGewichte().getG1()))) {
                                            if (messung.isFehler()) {
                                                string = messung.hasText() ? messung.getText() : "fehlerhaftes Ma\u00df";
                                            } else {
                                                string = messung.hasText() ? messung.getText() : "unzul. Abweichung";
                                                this.addException(new SurveyException("Identit\u00e4tliste:\n     unzul\u00e4ssige Linien-Abweichung in Punkt " + messung.ps.getNr()));
                                            }
                                        } else {
                                            string = messung.hasText() ? messung.getText() : string2;
                                        }
                                        this.writeOrthoAsIdentLine(printWriter, messung, new Messung(messung.ma, messung.ps, messung.ps, messung2.l1, messung2.l2), (String)object3, punktIdentitaet != null ? punktIdentitaet.bemSoll : string);
                                        bl = true;
                                    }
                                }
                            }
                            this.block = 0;
                        }
                    }
                }
                if ((long)n % super.getProgressBreak() == 0L) {
                    super.setProgress(n);
                }
                ++n;
            }
            this.block = 4;
            enumeration = DataBase.T.elements();
            while (enumeration.hasMoreElements()) {
                cloneable = (TrafoSystem)enumeration.nextElement();
                if (((TrafoSystem)cloneable).isKatasterNachweisElement()) {
                    String string4 = ((ValueDataContainer)cloneable).getName();
                    if (KatasternachweisIOProperties.writeIdentTitel()) {
                        this.block = 4;
                        this.writeIdentBlockTitle(printWriter, 4, " " + ((TrafoSystem)cloneable).getParameter() + "-Parameter aus Riss: " + string4);
                        string4 = null;
                    } else {
                        this.writeIdentTextLine(printWriter, "", true, "");
                    }
                    object2 = ((DataContainer)cloneable).elements();
                    while (object2.hasMoreElements()) {
                        TrafoPunkt trafoPunkt = (TrafoPunkt)object2.nextElement();
                        if (!this.writeMessPunkt(trafoPunkt.getPunkt())) continue;
                        PunktIdentitaet punktIdentitaet = (PunktIdentitaet)this.P_IDENT.get(new Long(trafoPunkt.getPunkt().nr));
                        if (punktIdentitaet != null) {
                            var26_66 = ((TrafoSystem)cloneable).getInversePoint(punktIdentitaet.ist);
                            object = ((TrafoSystem)cloneable).getInversePoint(punktIdentitaet.soll);
                            TrafoPunkt trafoPunkt2 = new TrafoPunkt(punktIdentitaet.soll, trafoPunkt.y, trafoPunkt.x);
                            trafoPunkt2.setVy((float)((double)trafoPunkt.getVy() + (var26_66.y - ((DPoint)object).y)));
                            trafoPunkt2.setVx((float)((double)trafoPunkt.getVx() + (var26_66.x - ((DPoint)object).x)));
                            this.writeTrafoPunktAsIdentLine(printWriter, trafoPunkt2, string4, punktIdentitaet.bemIst);
                        } else if (!trafoPunkt.isOn()) {
                            var26_66 = ((TrafoSystem)cloneable).getInversePoint(trafoPunkt.getPunkt());
                            object = new TrafoPunkt(trafoPunkt.getPunkt(), trafoPunkt.y, trafoPunkt.x);
                            ((TrafoPunkt)object).setVy((float)(var26_66.y - trafoPunkt.y));
                            ((TrafoPunkt)object).setVx((float)(var26_66.x - trafoPunkt.x));
                            this.writeTrafoPunktAsIdentLine(printWriter, (TrafoPunkt)object, string4, trafoPunkt.getBemerkung() != null ? trafoPunkt.getBemerkung() : KOO_FEHLER);
                            continue;
                        }
                        this.writeTrafoPunktAsIdentLine(printWriter, trafoPunkt, string4, punktIdentitaet != null ? punktIdentitaet.bemSoll : trafoPunkt.getBemerkung());
                    }
                }
                this.block = 0;
            }
            n = 0;
            super.setEndValue(DataBase.P.size());
            super.setProgressBreak();
            super.setValue(n);
            super.setLabelText("Koordinatenidentit\u00e4tsliste erstellen...");
            this.block = 5;
            this.writeIdentBlockTitle(printWriter, 5);
            n2 = 0;
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                cloneable = (Punkt)enumeration.nextElement();
                if (this.writeKooPunkt((Punkt)cloneable)) {
                    PunktIdentitaet punktIdentitaet = (PunktIdentitaet)this.P_IDENT.get(new Long(((Punkt)cloneable).nr));
                    if (((Punkt)cloneable).createKooNb() > n2) {
                        if (n2 != 0) {
                            printWriter.println(IDENT_TABLE_TEXT_LINE_DEF);
                        }
                        this.writeIdentTextLine(printWriter, "Nummerierungsbezirk: 3" + Punkt.createNbAsString(((Punkt)cloneable).createKooNb()), true, "");
                        n2 = ((Punkt)cloneable).createKooNb();
                        printWriter.println(IDENT_TABLE_DATA_LINE_DEF);
                    }
                    if (punktIdentitaet != null) {
                        this.writePunktAsIdentPointLine(printWriter, punktIdentitaet.soll, punktIdentitaet.ist, punktIdentitaet.bemIst);
                    }
                    switch (((Punkt)cloneable).getPs()) {
                        case 5: {
                            Punkt punkt3;
                            if (((Punkt)cloneable).isErrHoldKoo()) {
                                punkt3 = new Punkt(((Punkt)cloneable).getNr(), ((Punkt)cloneable).getParameter().getPa(), ((Punkt)cloneable).getParameter().getVa(), ((Punkt)cloneable).y + (double)((Punkt)cloneable).dy, ((Punkt)cloneable).x + (double)((Punkt)cloneable).dx);
                                punkt3.getParameter((Punkt)cloneable);
                                this.writePunktAsIdentPointLine(printWriter, (Punkt)cloneable, punkt3, punktIdentitaet != null ? punktIdentitaet.bemSoll : null);
                                break;
                            }
                        }
                        case 0: {
                            Punkt punkt3 = (Punkt)((Punkt)cloneable).clone();
                            punkt3.y = ((Punkt)cloneable).y - (double)((Punkt)cloneable).dy;
                            punkt3.x = ((Punkt)cloneable).x - (double)((Punkt)cloneable).dx;
                            this.writePunktAsIdentPointLine(printWriter, punkt3, (Punkt)cloneable, punktIdentitaet != null ? punktIdentitaet.bemSoll : null);
                            break;
                        }
                        case 2: {
                            object2 = new Punkt(((Punkt)cloneable).getNr(), ((Punkt)cloneable).getParameter().getPa(), ((Punkt)cloneable).getParameter().getVa(), ((Punkt)cloneable).y + (double)((Punkt)cloneable).dy, ((Punkt)cloneable).x + (double)((Punkt)cloneable).dx);
                            ((Punkt)object2).getParameter((Punkt)cloneable);
                            this.writePunktAsIdentPointLine(printWriter, (Punkt)cloneable, (Punkt)object2, punktIdentitaet != null ? punktIdentitaet.bemSoll : null);
                            break;
                        }
                        case 1: {
                            this.writePunktAsIdentPointLine(printWriter, (Punkt)cloneable, punktIdentitaet != null ? punktIdentitaet.bemSoll : null);
                        }
                    }
                    if ((long)n % super.getProgressBreak() == 0L) {
                        super.setProgress(n);
                    }
                }
                ++n;
            }
            printWriter.println(END_OF_FILE);
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
    }

    private boolean writeRissPunkt(Punkt punkt) {
        KatasternachweisBrbAlkisWriter katasternachweisBrbAlkisWriter = this;
        if (katasternachweisBrbAlkisWriter.db.hasMenge()) {
            if (!DataBase.MENGE.contains(punkt)) {
                return false;
            }
        }
        if (!punkt.isFortfuehrung()) {
            return false;
        }
        return punkt.isKatasterElement();
    }

    private boolean writeMessPunkt(Punkt punkt) {
        if (punkt == null) {
            return false;
        }
        KatasternachweisBrbAlkisWriter katasternachweisBrbAlkisWriter = this;
        if (katasternachweisBrbAlkisWriter.db.hasMenge()) {
            if (!DataBase.MENGE.contains(punkt)) {
                return false;
            }
        }
        if (KatasternachweisIOProperties.writeIdentAllMessung()) {
            return true;
        }
        if (!punkt.isFortfuehrung()) {
            return false;
        }
        return KatasternachweisIOProperties.writeLokalPunkt() || !punkt.isLokalPunkt() || this.P_IDENT.get(new Long(punkt.nr)) != null;
    }

    private boolean writeKooPunkt(Punkt punkt) {
        if (!punkt.isKatasterElement()) {
            return false;
        }
        if (punkt.getPs() == -2) {
            return false;
        }
        if (punkt.getInternalPs() == 2) {
            return punkt.isKatasterNeupunktBestand() && (punkt.getPs() == 1 || punkt.getPs() == 2);
        }
        if (!punkt.isFortfuehrung() && !KatasternachweisIOProperties.writeIdentAllMessung()) {
            return false;
        }
        if (!punkt.isOn()) {
            return false;
        }
        KatasternachweisBrbAlkisWriter katasternachweisBrbAlkisWriter = this;
        if (katasternachweisBrbAlkisWriter.db.hasMenge()) {
            if (!DataBase.MENGE.contains(punkt)) {
                return false;
            }
        }
        return punkt.isKatasterNeupunktBestand() || KatasternachweisIOProperties.writeIdentMapPoints() || punkt.getOldParameter().getEq() != 2000 && punkt.getOldParameter().getEq() != 4200 && punkt.getOldParameter().getEq() != 4300;
    }

    private boolean lineIsWritten(Linie linie, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Linie linie2 = (Linie)vector.elementAt(i);
            if (!linie.equalsIgnoreArt(linie2)) continue;
            return true;
        }
        vector.addElement(linie);
        return false;
    }

    private void writePageDef(PrintWriter printWriter, int n) {
        printWriter.println("{\\*\\SeitenDefinition OpenOffice}");
        printWriter.println("{\\*\\pgdsctbl {\\pgdsc0\\pgdscuse195\\pgwsxn11906\\pghsxn16838\\marglsxn1134\\margrsxn567\\margtsxn566\\margbsxn566\\headery0 \\pgdscnxt0 Standard;}}");
        printWriter.println("{\\*\\SeitenDefinition MSWord}");
        printWriter.println("\\paperh16838\\paperw11906\\margl1134\\margr567\\margt566\\margb566\\sectd\\sbknone" + (String)(n > 1 ? "\\pgnrestart\\pgnstarts" + n : "") + "\\pgwsxn11906\\pghsxn16838\\marglsxn1134\\margrsxn567\\margtsxn2876\\margbsxn566\\headery566");
    }

    private void writePageHeader(PrintWriter printWriter, String string) {
        printWriter.println("{\\*\\Start SeitenKopf}");
        printWriter.println("{\\header");
        printWriter.println("{\\*\\Titelzeile}");
        printWriter.println("\\pard\\plain \\sb113\\sa113\\s1\\margtsxn2480\\margbsxn170 {\\rtlch \\ltrch\\loch\\f0\\fs28\\b " + string + " ( {\\field{\\*\\fldinst PAGE }{\\fldrslt 1}} / {\\field{\\*\\fldinst PAGEREF LETZTE_SEITE }{\\fldrslt 1}} )}\\par");
        printWriter.println("{\\*\\Erste KopfZeile}");
        printWriter.println("\\trowd\\trql\\trkeep\\trrh454\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clvertalc\\cellx1020\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clvertalc\\cellx3288\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clvertalt\\cellx5457\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clvertalt\\cellx7426\\clbrdrt\\brdrs\\brdrw10\\brdrcf1\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clbrdrr\\brdrs\\brdrw10\\brdrcf1\\clvertalt\\cellx10205");
        printWriter.println("\\trwd\\pard\\plain \\widctlpar\\intbl\\adjustright");
        printWriter.println("\\ql\\fs16 Gemeinde\\cell");
        printWriter.println("\\ql\\fs20\\b " + (DataBase.gemeinde != null ? KatasternachweisBrbAlkisWriter.getRtfString(DataBase.gemeinde) : "") + "\\cell");
        printWriter.println("\\qc\\b0 " + KatasternachweisBrbAlkisWriter.getRtfString(KatasternachweisIOProperties.getVermTitle()) + "\\cell");
        printWriter.println("\\qc\\b0 " + KatasternachweisBrbAlkisWriter.getRtfString(KatasternachweisIOProperties.getAmtTitle()) + "\\cell");
        printWriter.println("\\ql\\fs16\\b0 Archivblatt*:\\cell");
        printWriter.println("\\row");
        printWriter.println("{\\*\\Zweite KopfZeile}");
        printWriter.println("\\trowd\\trql\\trkeep\\trrh454\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clvertalc\\cellx1020\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clvertalc\\cellx3288\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clvertalt\\cellx5457\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clvertalt\\cellx7426\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clbrdrr\\brdrs\\brdrw10\\brdrcf1\\clvertalt\\cellx10205");
        printWriter.println("\\trwd\\pard\\plain \\widctlpar\\intbl\\adjustright");
        printWriter.println("\\ql\\fs16 Gemarkung\\cell");
        printWriter.println("\\ql\\fs20\\b " + (this.gemarkung != null ? KatasternachweisBrbAlkisWriter.getRtfString(this.gemarkung) : "") + "\\cell");
        printWriter.println("\\qc\\fs16\\b " + (DataBase.vermStelle != null ? KatasternachweisBrbAlkisWriter.getRtfString(KatasternachweisIOProperties.getVermPrefix() + DataBase.vermStelle) : "") + "\\cell");
        printWriter.println("\\qc\\fs16\\b " + (DataBase.katasterAmt != null ? KatasternachweisBrbAlkisWriter.getRtfString(KatasternachweisIOProperties.getAmtPrefix() + DataBase.katasterAmt) : "") + "\\cell");
        printWriter.println("\\ql\\fs16\\b0 Antrags-Nr.*:\\cell");
        printWriter.println("\\row");
        printWriter.println("{\\*\\Dritte KopfZeile}");
        printWriter.println("\\trowd\\trql\\trkeep\\trrh454\\trpaddft3\\trpaddt57\\trpaddfl3\\trpaddl57\\trpaddfb3\\trpaddb57\\trpaddfr3\\trpaddr57\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clvertalc\\cellx1020\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clvertalc\\cellx3288\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clbrdrb\\brdrs\\brdrw10\\brdrcf1\\clvertalc\\cellx5457\\clbrdrl\\brdrs\\brdrw10\\brdrcf1\\clvertalt\\cellx7426\\clvertalt\\cellx10205");
        printWriter.println("\\trwd\\pard\\plain \\widctlpar\\intbl\\adjustright");
        printWriter.println("{\\fs16 Flur }{\\fs20\\b " + (DataBase.flur != null ? KatasternachweisBrbAlkisWriter.getRtfString(DataBase.flur) : "") + "}\\cell");
        printWriter.println("{\\fs16 Flurst\\'fcck }{\\fs20\\b " + (DataBase.flurstueck != null ? KatasternachweisBrbAlkisWriter.getRtfString(DataBase.flurstueck) : "") + "}\\cell");
        KatasternachweisBrbAlkisWriter katasternachweisBrbAlkisWriter = this;
        printWriter.println("{\\fs16 Mittlere ellips. H\\'f6he }{\\fs20\\b " + (int)Math.rint(katasternachweisBrbAlkisWriter.db.getGelHoehe()) + " m}\\cell");
        printWriter.println("\\cell");
        printWriter.println("{\\rtlch \\ltrch\\loch\\f0\\fs12\\lang1031\\i0\\b0 * wird von der Katasterbeh\\'f6rde ausgef\\'fcllt}\\cell");
        printWriter.println("\\row");
        printWriter.println("\\pard\\plain");
        printWriter.println("\\par");
        printWriter.println("}");
        printWriter.println("{\\*\\Ende SeitenKopf}");
    }

    private void writeRissPointLine(PrintWriter printWriter, Punkt punkt, String string) {
        PunktParameter punktParameter = punkt.getParameter();
        boolean bl = punktParameter.getKafPa() == 0;
        printWriter.print(ROW_START);
        printWriter.print(" {\\qc ");
        printWriter.print(KatasternachweisBrbAlkisWriter.getPaString(punkt));
        printWriter.print(CELL);
        printWriter.print(KatasternachweisBrbAlkisWriter.getPnrString(punkt));
        printWriter.print(CELL);
        printWriter.print(KatasternachweisBrbAlkisWriter.getVaString(punktParameter.getModVa()));
        printWriter.print(CELL);
        printWriter.print(koo33.format(punkt.y));
        printWriter.print(CELL);
        printWriter.print(koo33.format(punkt.x));
        printWriter.print(CELL);
        if (punkt.getPa() == 95) {
            printWriter.print(d13.format(punkt.getSP()));
        } else if (!bl && (punkt.getInternalPs() != 0 || punkt.getPs() != 1 && punkt.getPs() != 2 || punkt.getOldParameter().getLg() != punkt.getParameter().getLg())) {
            printWriter.print(d13.format(punkt.getSP()));
        }
        printWriter.print(CELL);
        if (!bl && punktParameter.getLl() != 0.0f) {
            printWriter.print(d13.format(punktParameter.getModLl()));
        }
        printWriter.print(CELL);
        if (bl) {
            printWriter.print(punktParameter.getKafLg() != 0 ? punktParameter.getOutLg() : "2100");
        } else {
            printWriter.print(punktParameter.getOutLg());
        }
        printWriter.print(CELL);
        if (bl) {
            printWriter.print(punktParameter.getKafLz() != 0 ? KatasternachweisBrbAlkisWriter.getLzString(punktParameter.getModLz()) : "J");
        } else {
            printWriter.print(KatasternachweisBrbAlkisWriter.getLzString(punktParameter.getModLz()));
        }
        printWriter.print("\\cell\\fs16\\ql ");
        printWriter.print(KatasternachweisBrbAlkisWriter.getRtfString(string));
        printWriter.println("\\cell}\\row");
    }

    private void writeRissTextLine(PrintWriter printWriter, String string, boolean bl) {
        printWriter.print(ROW_START);
        if (bl) {
            printWriter.print("\\b");
        }
        printWriter.print(" ");
        printWriter.print(KatasternachweisBrbAlkisWriter.getRtfString(string));
        printWriter.println(ROW_END);
    }

    private void writeRissLengthShortLine(PrintWriter printWriter, Linie linie) {
        this.writeRissLengthLine(printWriter, KatasternachweisBrbAlkisWriter.getPaString(linie.pa), KatasternachweisBrbAlkisWriter.getPnrString(linie.pa), KatasternachweisBrbAlkisWriter.getPaString(linie.pe), KatasternachweisBrbAlkisWriter.getPnrString(linie.pe), d03.format(DataBase.getStrecke(linie.pa, linie.pe)), (String)(linie.isBogen() ? "R = " + d03.format(Math.abs(linie.l2)) + " B = " + d03.format(linie.getBogenLaenge() * DataBase.getStreckeMasstab(linie.pa.y)) : ""));
    }

    private void writeRissLengthLongLines(PrintWriter printWriter, Linie linie, boolean bl) {
        if (bl) {
            this.writeRissLengthLine(printWriter, "", "", "", "", "", "");
            this.writeRissLengthLine(printWriter, KatasternachweisBrbAlkisWriter.getPaString(linie.pa), KatasternachweisBrbAlkisWriter.getPnrString(linie.pa), "", "", "", "");
        }
        this.writeRissLengthLine(printWriter, "", "", "", "", d03.format(DataBase.getStrecke(linie.pa, linie.pe)), (String)(linie.isBogen() ? "R = " + d03.format(Math.abs(linie.l2)) + " B = " + d03.format(linie.getBogenLaenge() * DataBase.getStreckeMasstab(linie.pa.y)) : ""));
        this.writeRissLengthLine(printWriter, KatasternachweisBrbAlkisWriter.getPaString(linie.pe), KatasternachweisBrbAlkisWriter.getPnrString(linie.pe), "", "", "", "");
    }

    private void writeRissLengthLine(PrintWriter printWriter, String string, String string2, String string3, String string4, String string5, String string6) {
        printWriter.print(ROW_START);
        printWriter.print(" {\\qc ");
        printWriter.print(string);
        printWriter.print(CELL);
        printWriter.print(string2);
        printWriter.print(CELL);
        printWriter.print(string3);
        printWriter.print(CELL);
        printWriter.print(string4);
        printWriter.print(CELL);
        printWriter.print(string5);
        printWriter.print(CELL);
        printWriter.print("\\cell\\cell\\cell\\cell\\fs16\\ql ");
        printWriter.print(string6);
        printWriter.println("\\cell}\\row");
    }

    private void writeIdentTextLine(PrintWriter printWriter, String string, boolean bl, String string2) {
        printWriter.print(ROW_START);
        if (bl) {
            printWriter.print("{\\b ");
        }
        printWriter.print(KatasternachweisBrbAlkisWriter.getRtfString(string));
        if (bl) {
            printWriter.print("}");
        }
        printWriter.print("\\cell\\fs16 ");
        printWriter.print(string2);
        printWriter.println(ROW_END);
    }

    private void writeIdentBlockTitle(PrintWriter printWriter, int n) {
        this.writeIdentBlockTitle(printWriter, n, null);
    }

    private void writeIdentBlockTitle(PrintWriter printWriter, int n, String string) {
        Object object = "";
        switch (n) {
            case 1: {
                object = "Polare Messung";
                break;
            }
            case 2: {
                object = "Orthogonale Linie";
                break;
            }
            case 3: {
                object = "Streckenvergleich";
                break;
            }
            case 4: {
                object = "Transformation";
                break;
            }
            case 5: {
                object = "Koordinatenvergleich";
            }
        }
        printWriter.println(IDENT_TABLE_TEXT_LINE_DEF);
        object = string != null ? "{\\b " + (String)object + "}\\fs16 " + string : "{\\b " + (String)object + "}";
        if (n == 5) {
            this.writeIdentTextLine(printWriter, "", true, "");
            this.writeIdentTextLine(printWriter, (String)object, true, "");
        } else {
            this.writeIdentTextLine(printWriter, (String)object, false, "");
            printWriter.println(IDENT_TABLE_DATA_LINE_DEF);
        }
    }

    private String getIdentUniqueString(Punkt punkt) {
        if (this.identicPointNrHash.get(new Long(punkt.nr)) != null) {
            return "{\\fs12 3" + Punkt.createNbAsString(punkt.createNb()) + "\\line}";
        }
        return "";
    }

    private void writeIdentMessPointLine(PrintWriter printWriter, Punkt punkt, String string) {
        printWriter.print(ROW_START);
        printWriter.print("\\qc ");
        Punkt punkt2 = null;
        if (punkt.isMasterPoint()) {
            punkt2 = DataBase.P.getSlave(punkt);
        }
        printWriter.print(KatasternachweisBrbAlkisWriter.getPaString(punkt));
        if (punkt2 != null) {
            printWriter.print("\\line " + KatasternachweisBrbAlkisWriter.getPaString(punkt2));
        }
        printWriter.print(CELL);
        printWriter.print(this.getIdentUniqueString(punkt));
        printWriter.print(KatasternachweisBrbAlkisWriter.getPnrString(punkt));
        if (punkt2 != null) {
            printWriter.print("\\line " + this.getIdentUniqueString(punkt2));
            printWriter.print(KatasternachweisBrbAlkisWriter.getPnrString(punkt2));
        }
        printWriter.print("\\cell\\cell\\cell\\cell\\cell\\cell\\cell\\cell\\fs16\\ql\\cell");
        if (string != null) {
            printWriter.print(" " + KatasternachweisBrbAlkisWriter.getRtfString(string));
        }
        printWriter.println(ROW_END);
    }

    private void writeStreckeAsIdentLine(PrintWriter printWriter, Messung messung, Messung messung2, String string, String string2, String string3, String string4) {
        if (KatasternachweisIOProperties.writeIdentTitel() && this.block != 3) {
            this.block = 3;
            this.writeIdentBlockTitle(printWriter, 3);
        }
        this.writeIdentMessPointLine(printWriter, messung2.ps, string2);
        printWriter.print(ROW_START);
        printWriter.print("\\cell\\qc\\cell ");
        printWriter.print(d02.format(messung.l1));
        printWriter.print("\\cell\\cell ");
        printWriter.print(d02.format(messung2.l1));
        printWriter.print("\\cell\\cell ");
        printWriter.print(d02.format(messung.l1 - messung2.l1));
        printWriter.print("\\cell\\cell ");
        printWriter.print(d02.format(Math.abs(messung.l1 - messung2.l1)));
        printWriter.print("\\cell\\fs16\\ql ");
        printWriter.print(KatasternachweisBrbAlkisWriter.getRtfString(string));
        printWriter.print("\\cell");
        if (string4 != null) {
            printWriter.print(" " + KatasternachweisBrbAlkisWriter.getRtfString(string4));
        }
        printWriter.println(ROW_END);
        this.writeIdentMessPointLine(printWriter, messung2.pz, string3);
    }

    private void writeOrthoAsIdentLine(PrintWriter printWriter, Messung messung, Messung messung2, String string, String string2) {
        if (KatasternachweisIOProperties.writeIdentTitel() && this.block != 2) {
            this.block = 2;
            this.writeIdentBlockTitle(printWriter, 2);
        }
        boolean bl = messung.getWerteBelegung() == 0;
        double d = messung.l1 - messung2.l1;
        double d2 = messung.l2 - messung2.l2;
        double d3 = Math.sqrt(d2 * d2 + d * d);
        if (bl) {
            d3 = Math.abs(d2);
        }
        printWriter.print(ROW_START);
        printWriter.print("\\qc ");
        Punkt punkt = null;
        if (messung2.ps.isMasterPoint()) {
            punkt = DataBase.P.getSlave(messung2.ps);
        }
        printWriter.print(KatasternachweisBrbAlkisWriter.getPaString(messung2.ps));
        if (punkt != null) {
            printWriter.print("\\line " + KatasternachweisBrbAlkisWriter.getPaString(punkt));
        }
        printWriter.print(CELL);
        printWriter.print(this.getIdentUniqueString(messung2.ps));
        printWriter.print(KatasternachweisBrbAlkisWriter.getPnrString(messung2.ps));
        if (punkt != null) {
            printWriter.print("\\line " + this.getIdentUniqueString(punkt));
            printWriter.print(KatasternachweisBrbAlkisWriter.getPnrString(punkt));
        }
        printWriter.print(CELL);
        printWriter.print(d02.format(messung.l2));
        printWriter.print(CELL);
        if (!bl) {
            printWriter.print(d02.format(messung.l1).toString());
        }
        printWriter.print(CELL);
        printWriter.print(d02.format(messung2.l2));
        printWriter.print(CELL);
        printWriter.print(d02.format(messung2.l1));
        printWriter.print(CELL);
        printWriter.print(d02.format(d2));
        printWriter.print(CELL);
        if (!bl) {
            printWriter.print(d02.format(d));
        }
        printWriter.print(CELL);
        printWriter.print(d02.format(d3));
        printWriter.print("\\cell\\fs16\\ql ");
        printWriter.print(KatasternachweisBrbAlkisWriter.getRtfString(string));
        printWriter.print(CELL);
        if (string2 != null) {
            printWriter.print(KatasternachweisBrbAlkisWriter.getRtfString(string2));
        }
        printWriter.println(ROW_END);
    }

    private void writeTrafoPunktAsIdentLine(PrintWriter printWriter, TrafoPunkt trafoPunkt, String string, String string2) {
        printWriter.print(ROW_START);
        printWriter.print("\\qc ");
        Punkt punkt = null;
        if (trafoPunkt.getPunkt().isMasterPoint()) {
            punkt = DataBase.P.getSlave(trafoPunkt.getPunkt());
        }
        printWriter.print(KatasternachweisBrbAlkisWriter.getPaString(trafoPunkt.getPunkt()));
        if (punkt != null) {
            printWriter.print("\\line " + KatasternachweisBrbAlkisWriter.getPaString(punkt));
        }
        printWriter.print(CELL);
        printWriter.print(this.getIdentUniqueString(trafoPunkt.getPunkt()));
        printWriter.print(KatasternachweisBrbAlkisWriter.getPnrString(trafoPunkt.getPunkt()));
        if (punkt != null) {
            printWriter.print("\\line " + this.getIdentUniqueString(punkt));
            printWriter.print(KatasternachweisBrbAlkisWriter.getPnrString(punkt));
        }
        printWriter.print(CELL);
        printWriter.print(d33.format(trafoPunkt.y - (double)((int)trafoPunkt.y / 1000 * 1000)));
        printWriter.print(CELL);
        printWriter.print(d33.format(trafoPunkt.x - (double)((int)trafoPunkt.x / 1000 * 1000)));
        printWriter.print(CELL);
        printWriter.print(d33.format(trafoPunkt.y - (double)((int)trafoPunkt.y / 1000 * 1000) + (double)trafoPunkt.getVy()));
        printWriter.print(CELL);
        printWriter.print(d33.format(trafoPunkt.x - (double)((int)trafoPunkt.x / 1000 * 1000) + (double)trafoPunkt.getVx()));
        printWriter.print(CELL);
        printWriter.print(d03.format(-trafoPunkt.getVy()));
        printWriter.print(CELL);
        printWriter.print(d03.format(-trafoPunkt.getVx()));
        printWriter.print(CELL);
        printWriter.print(d03.format(trafoPunkt.getVs()));
        printWriter.print("\\cell\\fs16\\ql ");
        if (string != null) {
            printWriter.print(KatasternachweisBrbAlkisWriter.getRtfString(string));
        }
        printWriter.print(CELL);
        if (string2 == null) {
            if (!trafoPunkt.isOn()) {
                string2 = KOO_FEHLER;
            } else if ((double)trafoPunkt.getVs() > IDENT_DK_ZUL) {
                string2 = KOO_FEHLER;
                this.addException(new SurveyException("Identit\u00e4tsliste\n     Transformationsfehler in Punkt " + trafoPunkt.getPunkt().getKatNr()));
            }
        }
        if (string2 == null) {
            string2 = this.createIdentVermarkungString(trafoPunkt.getPunkt());
        }
        if (string2 != null) {
            printWriter.print(KatasternachweisBrbAlkisWriter.getRtfString(string2));
        }
        printWriter.println(ROW_END);
    }

    private void writePunktAsIdentPointLine(PrintWriter printWriter, Punkt punkt, String object) {
        if (object != null && !punkt.isVermarkungVorgefunden()) {
            object = this.createIdentVermarkungString(punkt);
        }
        printWriter.print(ROW_START);
        printWriter.print("\\qc ");
        printWriter.print(KatasternachweisBrbAlkisWriter.getPaString(punkt));
        printWriter.print(CELL);
        printWriter.print(KatasternachweisBrbAlkisWriter.getPnrString(punkt));
        printWriter.print(CELL);
        printWriter.print(d33.format(punkt.y - (double)((int)punkt.y / 1000 * 1000)));
        printWriter.print(CELL);
        printWriter.print(d33.format(punkt.x - (double)((int)punkt.x / 1000 * 1000)));
        printWriter.print(CELL);
        printWriter.print("\\cell\\cell\\cell\\cell\\cell\\fs16\\ql ");
        printWriter.print(KatasternachweisBrbAlkisWriter.getRtfString(this.createHerkunftString(punkt)));
        printWriter.print(CELL);
        if (punkt.isKatasterNeupunktBestand()) {
            Object object2 = object = object != null ? "in ALKIS nicht nachgewiesen\\par " + (String)object : NOT_ALKIS;
        }
        if (object != null) {
            printWriter.print(KatasternachweisBrbAlkisWriter.getRtfString((String)object));
        }
        printWriter.println(ROW_END);
    }

    private void writePunktAsIdentPointLine(PrintWriter printWriter, Punkt punkt, Punkt punkt2, String string) {
        double d = punkt.y - punkt2.y;
        double d2 = punkt.x - punkt2.x;
        double d3 = Math.sqrt(d * d + d2 * d2);
        printWriter.print(ROW_START);
        printWriter.print("\\qc ");
        printWriter.print(KatasternachweisBrbAlkisWriter.getPaString(punkt));
        printWriter.print(CELL);
        printWriter.print(this.getIdentUniqueString(punkt));
        printWriter.print(KatasternachweisBrbAlkisWriter.getPnrString(punkt));
        printWriter.print(CELL);
        printWriter.print(d33.format(punkt.y - (double)((int)punkt.y / 1000 * 1000)));
        printWriter.print(CELL);
        printWriter.print(d33.format(punkt.x - (double)((int)punkt.x / 1000 * 1000)));
        printWriter.print(CELL);
        printWriter.print(d33.format(punkt2.y - (double)((int)punkt2.y / 1000 * 1000)));
        printWriter.print(CELL);
        printWriter.print(d33.format(punkt2.x - (double)((int)punkt2.x / 1000 * 1000)));
        printWriter.print(CELL);
        printWriter.print(d03.format(d));
        printWriter.print(CELL);
        printWriter.print(d03.format(d2));
        printWriter.print(CELL);
        printWriter.print(d03.format(d3));
        printWriter.print("\\cell\\fs16\\ql ");
        printWriter.print(KatasternachweisBrbAlkisWriter.getRtfString(this.createHerkunftString(punkt)));
        printWriter.print(CELL);
        StringBuffer stringBuffer = new StringBuffer();
        if (punkt.isKatasterNeupunktBestand()) {
            stringBuffer.append(NOT_ALKIS);
        }
        if (string != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\\par ");
            }
            stringBuffer.append(string);
        } else {
            string = this.createIdentVermarkungString(punkt);
            if (punkt.getPs() == 0) {
                stringBuffer.append(this.createNeuKooString(punkt));
            } else if (punkt.getPs() == 5) {
                if (!punkt.isErrHoldKoo()) {
                    stringBuffer.append(this.createNeuKooString(punkt));
                }
            } else if (punkt.getPs() == 2 && d3 > IDENT_DK_ZUL) {
                stringBuffer.append(KOO_FEHLER);
                this.addException(new SurveyException("Identit\u00e4tsliste\n     Koordinatenfehler in Punkt " + punkt.getKatNr()));
            }
        }
        if (punkt.hasBemerkung() && punkt.hasTag("npi.bem")) {
            Tag tag = Tag.parseTag(punkt.getBemerkung(), "npi.bem");
            switch (tag.getControl()) {
                case '#': {
                    stringBuffer.insert(0, tag.getValue() + " ");
                    break;
                }
                case '!': {
                    stringBuffer = new StringBuffer(tag.getValue());
                    break;
                }
                default: {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(tag.getValue());
                }
            }
        }
        if (stringBuffer.length() > 0) {
            printWriter.print(KatasternachweisBrbAlkisWriter.getRtfString(stringBuffer.toString()));
        }
        printWriter.println(ROW_END);
    }

    public final String createHerkunftString(Punkt punkt) {
        if (punkt.getModel() == 2) {
            if (punkt.isKatasterNeupunktBestand()) {
                String string = this.createHerkunftBestandString(punkt);
                return string != null ? string : this.createHiddenString("unbekannt");
            }
            int n = punkt.getOldParameter().getEq();
            if (punkt.hasNewBemerkung() && Tag.hasTag(punkt.getNewBemerkung(), "ENT")) {
                String string = Tag.parseTag(punkt.getNewBemerkung(), "ENT").getValue();
                String string2 = (String)this.entstehungHash.get(string);
                return string2 != null ? string2 : string;
            }
            if (punkt.hasBemerkung() && punkt.hasTag("ENT")) {
                String string = Tag.parseTag(punkt.getBemerkung(), "ENT").getValue();
                if (!this.entstehungHash.isEmpty()) {
                    String string3 = (String)this.entstehungHash.get(string);
                    return string3 != null ? string3 : this.createHiddenString(string);
                }
                return string;
            }
            if (n == 2000) {
                return "Luftbild";
            }
            if (n == 4200) {
                return "Katasterkarte";
            }
            return this.createHiddenString("unbekannt");
        }
        return punkt.getRiss();
    }

    private String createHerkunftBestandString(Punkt punkt) {
        if (punkt.hasBemerkung() && punkt.hasTag("ENT")) {
            return Tag.parseTag(punkt.getBemerkung(), "ENT").getValue();
        }
        if (punkt.getRiss() != null) {
            return punkt.getRiss();
        }
        return null;
    }

    private String createNeuKooString(Punkt punkt) {
        PunktParameter punktParameter = punkt.getOldParameter();
        PunktParameter punktParameter2 = punkt.getParameter();
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(NEU_KOO);
        if (punktParameter.getLg() != 0) {
            stringBuffer.append("\\line GST: ");
            stringBuffer.append(punktParameter.getOutLg());
            stringBuffer.append(" > ");
            stringBuffer.append(punktParameter2.getOutLg());
        } else if (punktParameter.getLl() != 0.0f) {
            stringBuffer.append("\\line GWT: ");
            stringBuffer.append(punktParameter.getOutLl());
            stringBuffer.append(" > ");
            stringBuffer.append(punktParameter2.getOutLl());
        } else if (punktParameter.getEq() != 0) {
            stringBuffer.append("\\line DES: ");
            stringBuffer.append(punktParameter.getOutEq());
            stringBuffer.append(" > ");
            stringBuffer.append(punktParameter2.getOutEq());
        }
        return stringBuffer.toString();
    }

    private String createHiddenString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        if (KatasternachweisIOProperties.hideErrorMessages()) {
            stringBuffer.append("\\v");
        }
        stringBuffer.append("\\cf3 ");
        stringBuffer.append(string);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private String createIdentVermarkungString(Punkt punkt) {
        if (punkt.getKafVb() == 1000) {
            return null;
        }
        switch (punkt.getKafVa()) {
            case 1: 
            case 10: 
            case 19: 
            case 99: {
                if (punkt.getVa() == punkt.getParameter().getModVa()) break;
                return VermarkungsArt.toKuerzel(punkt.getVa());
            }
        }
        switch (punkt.getKafVva()) {
            case 1: 
            case 10: 
            case 19: 
            case 99: {
                if (punkt.getVva() == punkt.getParameter().getModVva()) break;
                return VermarkungsArt.toKuerzel(punkt.getVva());
            }
        }
        return null;
    }
}

