/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IException;
import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.KatasterParameter;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.OrthoLinie;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktIdentitaet;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.PunktParameterALK;
import de.geocalc.kafplot.PunktSorter;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.SurveyException;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.VermarkungsArt;
import de.geocalc.kafplot.io.KatasternachweisIOProperties;
import de.geocalc.kafplot.io.KatasternachweisWriter;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparator;
import de.geocalc.util.LongHashObject;
import de.geocalc.util.SortableVector;
import de.geocalc.util.sml.Tag;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class KatasternachweisBrbWriter
extends KatasternachweisWriter {
    private static final String EOL = "\n";
    private static final String RTF_HEADER = "{\\rtf1\\ansi\\ansicpg1252\\uc1 \\deff0\\deflang1033\\deflangfe1031\n{\\fonttbl{\\f0\\froman\\fcharset0\\fprq2{\\*\\panose 02020603050405020304}Times New Roman;}}\n\\paperw11907\\paperh16840\\margl1588\\margr567\\margt851\\margb1021\n\\deftab708\\widowctrl\\ftnbj\\aenddoc\\hyphhotz425\\hyphcaps0\\formshade\\viewkind1\\pgbrdrhead\\pgbrdrfoot \\fet0\\sectd \\psz9\\linex0\\headery709\\footery709\\colsx709\\endnhere\\sectdefaultcl";
    private static final String RISS_HEADER = "{\\header \\pard\\plain \\widctlpar\\adjustright\\fs20\\lang1031\\cgrid {\\b\\fs28 Vermessungsriss - Liste (   /   )}{\\par }";
    private static final String IDENT_HEADER = "{\\header \\pard\\plain \\widctlpar\\adjustright\\fs20\\lang1031\\cgrid {\\b\\fs28 Nachweis der Punktidentit\\'e4t (}\n{\\field{\\*\\fldinst {\\cs17\\b\\fs28  PAGE }}{\\fldrslt {\\cs17\\b\\fs28\\lang1024 1}}}{\\cs17\\b\\fs28 /}{\\field{\\*\\fldinst {\\cs17\\b\\fs28  NUMPAGES }}{\\fldrslt {\\cs17\\b\\fs28\\lang1024 1}}}{\\b\\fs28 )\\par }";
    private static final String RISS_TABLE = "\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrr\n\\brdrs\\brdrw10 \\cltxlrtb \\cellx1276\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx4395\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6096\\clvertalt\\clbrdrt\n\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6946\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923\n{\\trwd}\n\\pard \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright {\\b\\fs16 PAT/\\line PNR\\cell Aufmessungsergebnis\\cell Qualit\\'e4t\\cell }\n\\pard\\plain \\s2\\qc\\sb60\\sa60\\keepn\\widctlpar\\intbl\\outlinelevel1\\adjustright \\b\\fs16\\lang1031\\cgrid {LZK\\cell }\n\\pard\\plain \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {\\b\\fs16 Bemerkung\\cell}\n\\pard \\widctlpar\\intbl\\adjustright\n{\\row }\n\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10\n\\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx1276\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx2835\\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10\n\\cltxlrtb \\cellx4395\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6096\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6946\\clvertalt\\clbrdrl\\brdrs\\brdrw10\n\\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923\n{\\trwd}\n\\pard \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright {\\b\\fs16 \\cell }\n\\pard\\plain \\s2\\qc\\sb60\\sa60\\keepn\\widctlpar\\intbl\\outlinelevel1\\adjustright \\b\\fs16\\lang1031\\cgrid {y\\cell }\n\\pard\\plain \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {\\b\\fs16 x\\cell }\n\\pard\\plain \\s2\\qc\\sb60\\sa60\\keepn\\widctlpar\\intbl\\outlinelevel1\\adjustright \\b\\fs16\\lang1031\\cgrid {S}{\\sub L}{ }{\\b0 oder/und}{ d}{\\sub k}{/d}{\\sub s}{\\cell }\n\\pard\\plain \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {\\b\\fs16 \\cell \\cell }\n{\\row }\n\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10\n\\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx1276\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10\n\\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx2835\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx4395\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10\n\\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx5245\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6096\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10\n\\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6946\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923\n{\\trwd}\n\\pard \\qc\\sb20\\sa20\\widctlpar\\intbl\\adjustright {\\fs12 1\\cell 2\\cell 3\\cell 4\\cell 5\\cell 6\\cell 7\\cell }\n\\pard \\widctlpar\\intbl\\adjustright\n{\\row }\n\\pard\\plain \\s15\\widctlpar\\tqc\\tx4536\\tqr\\tx9072\\adjustright \\fs20\\lang1031\\cgrid {\\par }}{\\*\\pnseclvl1\\pnucrm\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}{\\*\\pnseclvl2\\pnucltr\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}\n{\\*\\pnseclvl3\\pndec\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}{\\*\\pnseclvl4\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxta )}}\n{\\*\\pnseclvl5\\pndec\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}{\\*\\pnseclvl6\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}{\\*\\pnseclvl7\\pnlcrm\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}{\\*\\pnseclvl8\n\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}{\\*\\pnseclvl9\\pnlcrm\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}";
    private static final String IDENT_TABLE = "\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrr\n\\brdrs\\brdrw10 \\cltxlrtb \\cellx851\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx2897\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx4943\\clvertalt\\clbrdrt\n\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6361\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx7070\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\n\\brdrs\\brdrw10 \\cltxlrtb \\cellx8180\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923\n{\\trwd}\n\\pard \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright {\\b\\fs16 PAT/\\line PNR\\cell amtliche Koordinaten\\line (Soll)\\cell Vermessungsergebnis\\line (Ist)\\cell Soll-Ist\\cell Abwei-\\line chung\\cell Riss/\\line Jahr\\cell Bemerkung\\cell }\n{\\row }\n\\trowd \\trgaph70\\trleft-70\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\n\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx851\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx1874\\clvertalt\n\\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx2897\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx3920\\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\n\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx4943\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx5652\\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10\n\\cltxlrtb \\cellx6361\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx7070\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx8180\\clvertalt\\clbrdrl\\brdrs\\brdrw10\n\\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923\n{\\trwd}\n\\pard \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright {\\b\\fs16 \\cell }\n\\pard\\plain \\s2\\qc\\sb60\\sa60\\keepn\\widctlpar\\intbl\\outlinelevel1\\adjustright \\b\\fs16\\lang1031\\cgrid {Y\\cell }\n\\pard\\plain \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {\\b\\fs16 X\\cell y\\cell }\n\\pard\\plain \\s2\\qc\\sb60\\sa60\\keepn\\widctlpar\\intbl\\outlinelevel1\\adjustright \\b\\fs16\\lang1031\\cgrid {x\\cell }\n\\pard\\plain \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright\\fs20\\lang1031\\cgrid {\\b\\fs16 dy\\cell dx\\cell d}{\\b\\fs16\\sub k}{\\b\\fs16 /d}{\\b\\fs16\\sub s}{\\b\\fs16 \\cell \\cell \\cell }\n{\\row }\n\\trowd \\trgaph70\\trleft-70\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10\n\\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx851\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10\n\\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx1874\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx2897\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10\n\\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx3920\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx4943\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10\n\\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx5652\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6361\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10\n\\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx7070\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx8180\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\n\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923\n{\\trwd}\n\\pard \\qc\\sb20\\sa20\\widctlpar\\intbl\\adjustright {\\fs12 1\\cell 2\\cell 3\\cell 4\\cell 5\\cell 6\\cell 7\\cell 8\\cell 9\\cell 10\\cell }\n\\pard \\widctlpar\\intbl\\adjustright\n{\\row }\n\\pard\\plain \\s15\\widctlpar\\tqc\\tx4536\\tqr\\tx9072\\adjustright \\fs20\\lang1031\\cgrid {\\par}}{\\footer\n\\pard\\plain \\s16\\widctlpar\\tqc\\tx4536\\tqr\\tx9072\\adjustright \\fs20\\lang1031\\cgrid {\\par }}\n{\\*\\pnseclvl1\\pnucrm\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}{\\*\\pnseclvl2\\pnucltr\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}{\\*\\pnseclvl3\\pndec\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}{\\*\\pnseclvl4\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxta )}}\n{\\*\\pnseclvl5\\pndec\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}{\\*\\pnseclvl6\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}{\\*\\pnseclvl7\\pnlcrm\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}\n{\\*\\pnseclvl8\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}{\\*\\pnseclvl9\\pnlcrm\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}";
    private static final String GRENZ_LAENGE_TABLE_HEADER = "\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\cltxlrtb\\cellx9923\n{\\trwd}\n\\pard\\plain \\s3\\keepn\\widctlpar\\intbl\\outlinelevel2\\adjustright \\b\\fs20\\ul\\lang1031\\cgrid \\ \\cell\n\\pard\\plain \\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid\n{\\row }\n{\\trwd}\n\\pard\\plain \\s3\\keepn\\widctlpar\\intbl\\outlinelevel2\\adjustright \\b\\fs20\\ul\\lang1031\\cgrid \\'d6rtliche Grenzl\\'e4ngen\\cell\n\\pard\\plain \\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid\n{\\row }\n\\trowd \\trgaph70\\trleft-70\\trbrdrt\\brdrs\\brdrw10\\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx1276\\clvertalt\\cltxlrtb\n\\cellx2835\\clvertalt\\cltxlrtb \\cellx4395\\clvertalt\\cltxlrtb\\cellx5245\\clvertalt\\cltxlrtb \\cellx6096\\clvertalt\\cltxlrtb \\cellx6946\\clvertalt\\cltxlrtb \\cellx9923";
    private static final String GRENZ_LAENGE_TABLE = "{\\trwd}\\pard \\qc\\widctlpar\\intbl\\adjustright{\\b von PNR\\cell\\b nach PNR\\cell\\b Grenzl\\'e4nge\\cell\\cell \\cell \\cell } \\pard \\widctlpar\\intbl\\adjustright {\\cell }{\\row }";
    private static final String GEBAEUDE_LAENGE_TABLE = "{\\trwd}\\pard \\qc\\widctlpar\\intbl\\adjustright{\\b von PNR\\cell\\b nach PNR\\cell\\b Geb\\'e4udel\\'e4nge\\cell\\cell \\cell \\cell } \\pard \\widctlpar\\intbl\\adjustright {\\cell }{\\row }";
    private static final String GEBAEUDE_LAENGE_TABLE_HEADER = "\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\cltxlrtb\\cellx9923\n{\\trwd}\n\\pard\\plain \\s3\\keepn\\widctlpar\\intbl\\outlinelevel2\\adjustright \\b\\fs20\\ul\\lang1031\\cgrid \\ \\cell\n\\pard\\plain \\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid\n{\\row }\n{\\trwd}\n\\pard\\plain \\s3\\keepn\\widctlpar\\intbl\\outlinelevel2\\adjustright \\b\\fs20\\ul\\lang1031\\cgrid \\'d6rtliche Geb\\'e4udel\\'e4ngen\\cell\n\\pard\\plain \\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid\n{\\row }\n\\trowd \\trgaph70\\trleft-70\\trbrdrt\\brdrs\\brdrw10\\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx1276\\clvertalt\\cltxlrtb\n\\cellx2835\\clvertalt\\cltxlrtb \\cellx4395\\clvertalt\\cltxlrtb\\cellx5245\\clvertalt\\cltxlrtb \\cellx6096\\clvertalt\\cltxlrtb \\cellx6946\\clvertalt\\cltxlrtb \\cellx9923";
    private static final String IDENT_TABLE_HEADER = "\\trowd \\trgaph70\\trleft-70\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10\\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalc\\clbrdrl\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx851\\clvertalc\\cltxlrtb\n\\cellx1874\\clvertalc\\cltxlrtb \\cellx2897\\clvertalc\\cltxlrtb \\cellx3920\\clvertalc\\cltxlrtb \\cellx4943\\clvertalc\\cltxlrtb \\cellx5652\n\\clvertalc\\cltxlrtb \\cellx6361\\clvertalc\\cltxlrtb \\cellx7070\\clvertalc\\cltxlrtb \\cellx8180\\clvertalc\\cltxlrtb \\cellx9923";
    private static final String CELL = "\\cell";
    private static final String END_OF_HEADER = "{\\par}}";
    private static final String END_OF_FILE = "}";
    private static final String SPACE = " ";
    private static final String KOO_FEHLER = "Koordinaten-Fehler";
    private static final String NEU_KOO = "neue Koo eingef\u00fchrt";

    public KatasternachweisBrbWriter(File file, File file2, DataBase dataBase) {
        super(file, dataBase);
        this.rissFile = file;
        this.identFile = file2;
        this.P = DataBase.P;
        this.P_IDENT = DataBase.P_IDENT;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void write() throws IFileOutputException {
        var1_1 = null;
        try {
            var2_2 = new StringBuffer();
            if (DataBase.gemarkung != null) {
                var3_4 = Gemarkung.getGemarkung(DataBase.gemeinde, DataBase.gemarkung);
                if (var3_4 != null) {
                    var2_2.append(var3_4.getName());
                    var2_2.append(" (");
                    var2_2.append(GeoNumberFormat.nr06n.format(var3_4.getNummer()).toString());
                    var2_2.append(")");
                } else {
                    var2_2.append(DataBase.gemarkung);
                    this.addException(new IException("Keine Gemarkungsnummer f\u00fcr die Gemarkung: " + DataBase.gemarkung + " gefunden.", "\u00dcberpr\u00fcfen Sie die Einstellungen in der Konfigurationsdatei \"gemarkungen.properties\""));
                }
                this.gemarkung = var2_2.toString();
            } else {
                this.addException(new IException("Die Gemarkung wurde nicht angegeben", "Der Tabellenkopf kann nicht vollst\u00e4ndig ausgef\u00fcllt werden"));
            }
            super.setLabelText("Sortiere...");
            super.showProgress();
            this.outFile = this.rissFile;
            var1_1 = this.createWriter(this.rissFile);
            var3_5 = 0;
            super.setEndValue(this.P.size());
            super.setProgressBreak();
            super.setValue(0L);
            super.setLabelText("Koordinatenliste erstellen...");
            var1_1.println("{\\rtf1\\ansi\\ansicpg1252\\uc1 \\deff0\\deflang1033\\deflangfe1031\n{\\fonttbl{\\f0\\froman\\fcharset0\\fprq2{\\*\\panose 02020603050405020304}Times New Roman;}}\n\\paperw11907\\paperh16840\\margl1588\\margr567\\margt851\\margb1021\n\\deftab708\\widowctrl\\ftnbj\\aenddoc\\hyphhotz425\\hyphcaps0\\formshade\\viewkind1\\pgbrdrhead\\pgbrdrfoot \\fet0\\sectd \\psz9\\linex0\\headery709\\footery709\\colsx709\\endnhere\\sectdefaultcl");
            var1_1.println("{\\header \\pard\\plain \\widctlpar\\adjustright\\fs20\\lang1031\\cgrid {\\b\\fs28 Vermessungsriss - Liste (   /   )}{\\par }");
            this.writeKopfTable(var1_1);
            var1_1.println("\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrr\n\\brdrs\\brdrw10 \\cltxlrtb \\cellx1276\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx4395\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6096\\clvertalt\\clbrdrt\n\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6946\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923\n{\\trwd}\n\\pard \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright {\\b\\fs16 PAT/\\line PNR\\cell Aufmessungsergebnis\\cell Qualit\\'e4t\\cell }\n\\pard\\plain \\s2\\qc\\sb60\\sa60\\keepn\\widctlpar\\intbl\\outlinelevel1\\adjustright \\b\\fs16\\lang1031\\cgrid {LZK\\cell }\n\\pard\\plain \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {\\b\\fs16 Bemerkung\\cell}\n\\pard \\widctlpar\\intbl\\adjustright\n{\\row }\n\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10\n\\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx1276\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx2835\\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10\n\\cltxlrtb \\cellx4395\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6096\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6946\\clvertalt\\clbrdrl\\brdrs\\brdrw10\n\\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923\n{\\trwd}\n\\pard \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright {\\b\\fs16 \\cell }\n\\pard\\plain \\s2\\qc\\sb60\\sa60\\keepn\\widctlpar\\intbl\\outlinelevel1\\adjustright \\b\\fs16\\lang1031\\cgrid {y\\cell }\n\\pard\\plain \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {\\b\\fs16 x\\cell }\n\\pard\\plain \\s2\\qc\\sb60\\sa60\\keepn\\widctlpar\\intbl\\outlinelevel1\\adjustright \\b\\fs16\\lang1031\\cgrid {S}{\\sub L}{ }{\\b0 oder/und}{ d}{\\sub k}{/d}{\\sub s}{\\cell }\n\\pard\\plain \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {\\b\\fs16 \\cell \\cell }\n{\\row }\n\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10\n\\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx1276\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10\n\\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx2835\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx4395\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10\n\\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx5245\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6096\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10\n\\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6946\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923\n{\\trwd}\n\\pard \\qc\\sb20\\sa20\\widctlpar\\intbl\\adjustright {\\fs12 1\\cell 2\\cell 3\\cell 4\\cell 5\\cell 6\\cell 7\\cell }\n\\pard \\widctlpar\\intbl\\adjustright\n{\\row }\n\\pard\\plain \\s15\\widctlpar\\tqc\\tx4536\\tqr\\tx9072\\adjustright \\fs20\\lang1031\\cgrid {\\par }}{\\*\\pnseclvl1\\pnucrm\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}{\\*\\pnseclvl2\\pnucltr\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}\n{\\*\\pnseclvl3\\pndec\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}{\\*\\pnseclvl4\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxta )}}\n{\\*\\pnseclvl5\\pndec\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}{\\*\\pnseclvl6\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}{\\*\\pnseclvl7\\pnlcrm\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}{\\*\\pnseclvl8\n\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}{\\*\\pnseclvl9\\pnlcrm\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}");
            var1_1.println("{\\par}}");
            var4_6 = -2147483648;
            var5_7 = new PunktSorter(this.P, 23);
            var5_7.setProgressBar(super.getProgressBar());
            var6_8 = var5_7.getSortedVector();
            var7_9 = var6_8.elements();
            while (var7_9.hasMoreElements()) {
                block180: {
                    block181: {
                        var8_10 = (Punkt)var7_9.nextElement();
                        var9_11 = var8_10.getParameter();
                        if (!var8_10.isFortfuehrung()) break block180;
                        v0 = this;
                        if (!v0.db.hasMenge()) break block181;
                        if (!DataBase.MENGE.contains(var8_10)) break block180;
                    }
                    if (var8_10.getLongNb() > var4_6) {
                        this.writeNbAsRissLine(var1_1, Punkt.createNbAsString(var8_10.createNb()));
                        var4_6 = var8_10.getLongNb();
                    }
                    var2_2 = new StringBuffer();
                    if (var8_10.isKatasterPunkt()) {
                        block1 : switch (var8_10.getInternalPs()) {
                            case 0: {
                                switch (var8_10.getPs()) {
                                    case 1: 
                                    case 2: {
                                        if (var8_10.isKatasterNeupunkt() || KatasternachweisIOProperties.getAltpunktKennung() == null) break;
                                        var2_2.append(KatasternachweisIOProperties.getAltpunktKennung());
                                        break;
                                    }
                                    case 0: 
                                    case 5: {
                                        if (!var8_10.isKatasterNeupunkt() && KatasternachweisIOProperties.getAltpunktKennung() != null) {
                                            var2_2.append(KatasternachweisIOProperties.getAltpunktKennung() + " ");
                                        }
                                        if (var8_10.isErrHoldKoo()) break;
                                        var2_2.append("Koordinaten ge\u00e4ndert");
                                        if (var9_11.getLz() == 2) break;
                                        break;
                                    }
                                    default: {
                                        if (var8_10.isKatasterNeupunkt()) {
                                            var2_2.append("Neupunkt");
                                            break;
                                        }
                                        if (KatasternachweisIOProperties.getAltpunktKennung() != null) {
                                            var2_2.append(KatasternachweisIOProperties.getAltpunktKennung() + " ");
                                        }
                                        var2_2.append("erstmalig koordiniert");
                                        break;
                                    }
                                }
                                break;
                            }
                            case 2: {
                                if (var8_10.isKatasterNeupunkt()) {
                                    var2_2.append("Neupunkt");
                                    break;
                                }
                                if (KatasternachweisIOProperties.getAltpunktKennung() != null) {
                                    var2_2.append(KatasternachweisIOProperties.getAltpunktKennung() + " ");
                                }
                                var2_2.append("erstmalig koordiniert");
                                break;
                            }
                            case 1: {
                                switch (var8_10.getPs()) {
                                    case 1: 
                                    case 2: {
                                        break block1;
                                    }
                                    case 0: 
                                    case 5: {
                                        var2_2.append("Koordinaten ge\u00e4ndert");
                                        if (var9_11.getLz() != 2) {
                                            // empty if block
                                        } else {
                                            ** GOTO lbl109
                                        }
                                    }
                                }
                            }
                        }
lbl109:
                        // 9 sources

                        if (var8_10.isInLinie()) {
                            if (var2_2.length() > 0) {
                                var2_2.append(", ");
                            }
                            var2_2.append("eingerechnet");
                            var2_2.append("\\~(");
                            var2_2.append(GeoNumberFormat.m03.format(var8_10.dl).toString());
                            var2_2.append(")");
                            if ((double)var8_10.dl > DataBase.maxEinrechenDistance) {
                                this.addException(new IException("Rissliste:", "Der Punkt " + var8_10.nr + " wurde mit unzul. Abweichung eingerechnet"));
                            }
                        }
                        if (KatasternachweisIOProperties.writeRissBemerkung()) {
                            switch (var8_10.getPs()) {
                                case 1: 
                                case 2: {
                                    if (var8_10.getInternalPs() != 2) break;
                                }
                                default: {
                                    var10_12 = new StringBuffer();
                                    if (this.db.isGpsPunkt(var8_10)) {
                                        var10_12.append("GPS bestimmt");
                                    } else if (!this.db.isAufnahmePunkt(var8_10)) {
                                        if (this.db.isNachweisPunkt(var8_10)) {
                                            var10_12.append("lt.\\~Katasternachweis berechnet");
                                        } else if (DataBase.isSchnittPunkt(var8_10)) {
                                            var10_12.append("Schnittpunkt");
                                        } else if (DataBase.isTrafoPunkt(var8_10)) {
                                            var10_12.append("transformiert");
                                            if (DataBase.isHomogenisierungPunkt(var8_10)) {
                                                var10_12.append(" und homogenisiert");
                                            }
                                        } else if (DataBase.isDigitPunkt(var8_10)) {
                                            var10_12.append("digitalisiert");
                                            if (DataBase.isHomogenisierungPunkt(var8_10)) {
                                                var10_12.append(" und homogenisiert");
                                            }
                                        } else {
                                            var10_12.append("unzul. Punktbestimmung");
                                            this.addException(new IException("Rissliste:", "Der Punkt " + var8_10.nr + " wurde ohne Messwerte erzeugt"));
                                        }
                                    }
                                    if (var10_12.length() <= 0) break;
                                    if (var2_2.length() > 0) {
                                        var2_2.append(", ");
                                    }
                                    var2_2.append(var10_12.toString());
                                }
                            }
                        }
                        if (var8_10.getInternalPs() == 0) {
                            switch (var8_10.getPs()) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 5: {
                                    var10_12 = var8_10.getOldParameter();
                                    var11_16 = var8_10.getParameter();
                                    var12_18 = new StringBuffer();
                                    if (!var10_12.getOutPa().equals(var11_16.getOutPa())) {
                                        var12_18.append("PAT");
                                    }
                                    if (!var10_12.getOutVa().equals(var11_16.getOutVa())) {
                                        if (var12_18.length() > 0) {
                                            var12_18.append(", ");
                                        }
                                        var12_18.append("VAT");
                                    }
                                    if (!var10_12.getOutLs().equals(var11_16.getOutLs())) {
                                        if (var12_18.length() > 0) {
                                            var12_18.append(", ");
                                        }
                                        var12_18.append("LST");
                                    }
                                    if (!var10_12.getOutLg().equals(var11_16.getOutLg())) {
                                        if (var12_18.length() > 0) {
                                            var12_18.append(", ");
                                        }
                                        var12_18.append("LGA");
                                    }
                                    if (!var10_12.getOutLz().equals(var11_16.getOutLz()) && var8_10.getPs() != 5) {
                                        if (var12_18.length() > 0) {
                                            var12_18.append(", ");
                                        }
                                        var12_18.append("LZK");
                                    }
                                    if (!var10_12.getOutPst().equals(var11_16.getOutPst())) {
                                        if (var12_18.length() > 0) {
                                            var12_18.append(", ");
                                        }
                                        var12_18.append("PST");
                                    }
                                    if (var12_18.length() <= 0) break;
                                    if (var2_2.length() > 0) {
                                        var2_2.append(", ");
                                    }
                                    var2_2.append("\u00c4nderung der ");
                                    var2_2.append(var12_18.toString());
                                }
                            }
                            if (var8_10.getPs() == 5 && !var8_10.isErrHoldKoo() && var8_10.getModel() == 1) {
                                var10_13 = ((PunktParameterALK)var8_10.getOldParameter()).getModLz();
                                var11_17 = ((PunktParameterALK)var8_10.getParameter()).getModLz();
                                if (var2_2.length() > 0) {
                                    var2_2.append(", ");
                                }
                                if (var10_13 < var11_17) {
                                    var2_2.append("LZK erzeugt");
                                } else if (var10_13 > var11_17) {
                                    var2_2.append("LZK zur\u00fcckgesetzt");
                                } else {
                                    var2_2.append("LZK best\u00e4tigt");
                                }
                            }
                        }
                    }
                    if (KatasternachweisIOProperties.testLGA()) {
                        // empty if block
                    }
                    if (KatasternachweisIOProperties.testLZK()) {
                        // empty if block
                    }
                    if (var8_10.getOldParameter().getModPst() != var9_11.getModPst()) {
                        if (var2_2.length() != 0) {
                            var2_2.append("\\par ");
                        }
                        switch (var9_11.getModPst()) {
                            case 0: {
                                var2_2.append("in den amtl. Nachweis eingef\u00fchrt");
                                break;
                            }
                            case 1: {
                                var2_2.append("Punkt untergegangen");
                                break;
                            }
                            case 2: {
                                var2_2.append("Punkt untergegangen ohne Nachweis");
                                break;
                            }
                            case 6: {
                                var2_2.append("Festpunkt der Landesvermessung");
                                break;
                            }
                            case 7: {
                                var2_2.append("untergeg. Festpunkt der Landesvermessung");
                                break;
                            }
                            case 8: {
                                var2_2.append("Punktnummer reserviert");
                                break;
                            }
                            case 9: {
                                var2_2.append("kein Punkt der Landesvermessung");
                                break;
                            }
                            default: {
                                var2_2.append("ung\u00fcltiger Punktstatus");
                                this.addException(new IException("Rissliste:", "Der Punkt " + var8_10.nr + " besitzt einen ung\u00fcltigen Punktstatus"));
                            }
                        }
                    }
                    switch (var8_10.getPs()) {
                        case 1: {
                            break;
                        }
                        default: {
                            if (!var8_10.isLageFestgelegt() || !KatasternachweisIOProperties.testSP()) break;
                            if (!((double)var8_10.getRissSP() > DataBase.KPG)) break;
                            if (KatasternachweisIOProperties.writeRissBemerkung()) {
                                if (var2_2.length() != 0) {
                                    var2_2.append("\\par ");
                                }
                                var2_2.append("unzul\u00e4ssige Lagegenauigkeit");
                            }
                            this.addException(new IException("Rissliste:", "Der Punkt " + var8_10.nr + " wurde mit unzul. Lagegenauigkeit bestimmt"));
                        }
                    }
                    if (var8_10.hasBemerkung() && var8_10.hasTag("rissliste.bem")) {
                        var10_14 = Tag.parseTag(var8_10.getBemerkung(), "rissliste.bem");
                        switch (var10_14.getControl()) {
                            case '#': {
                                var2_2 = new StringBuffer(var10_14.getValue() + " " + var2_2.toString());
                                break;
                            }
                            case '!': {
                                var2_2 = new StringBuffer(var10_14.getValue());
                                break;
                            }
                            default: {
                                var2_2.append(" ");
                                var2_2.append(var10_14.getValue());
                            }
                        }
                    }
                    this.writePunktAsRissPointLine(var1_1, var8_10, var2_2.length() != 0 ? var2_2.toString() : null);
                    if ((long)var3_5 % super.getProgressBreak() == 0L) {
                        super.setProgress(var3_5);
                    }
                }
                ++var3_5;
            }
            var7_9 = new Vector<E>();
            var9_11 = null;
            var10_15 = null;
            if (KatasternachweisIOProperties.writeWithGrenzen()) {
                var1_1.println("\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\cltxlrtb\\cellx9923\n{\\trwd}\n\\pard\\plain \\s3\\keepn\\widctlpar\\intbl\\outlinelevel2\\adjustright \\b\\fs20\\ul\\lang1031\\cgrid \\ \\cell\n\\pard\\plain \\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid\n{\\row }\n{\\trwd}\n\\pard\\plain \\s3\\keepn\\widctlpar\\intbl\\outlinelevel2\\adjustright \\b\\fs20\\ul\\lang1031\\cgrid \\'d6rtliche Grenzl\\'e4ngen\\cell\n\\pard\\plain \\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid\n{\\row }\n\\trowd \\trgaph70\\trleft-70\\trbrdrt\\brdrs\\brdrw10\\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx1276\\clvertalt\\cltxlrtb\n\\cellx2835\\clvertalt\\cltxlrtb \\cellx4395\\clvertalt\\cltxlrtb\\cellx5245\\clvertalt\\cltxlrtb \\cellx6096\\clvertalt\\cltxlrtb \\cellx6946\\clvertalt\\cltxlrtb \\cellx9923");
                if (KatasternachweisIOProperties.writeShortLines()) {
                    var1_1.println("{\\trwd}\\pard \\qc\\widctlpar\\intbl\\adjustright{\\b von PNR\\cell\\b nach PNR\\cell\\b Grenzl\\'e4nge\\cell\\cell \\cell \\cell } \\pard \\widctlpar\\intbl\\adjustright {\\cell }{\\row }");
                }
                super.setEndValue(DataBase.FLST.size());
                super.setProgressBreak();
                super.setValue(0L);
                super.setLabelText("Grenzl\u00e4ngenliste erstellen...");
                var11_16 = new SortableVector();
                var12_19 = 0;
                while (true) {
                    if (var12_19 >= DataBase.FLST.size()) break;
                    var13_22 = (Flurstueck)DataBase.FLST.elementAt(var12_19);
                    var14_24 = var13_22.getKatasterNachweisLinien(this.getExceptionList()).elements();
                    while (var14_24.hasMoreElements()) {
                        var15_25 = (Linie)var14_24.nextElement();
                        if (!var15_25.pa.isFortfuehrung() || !var15_25.pe.isFortfuehrung()) continue;
                        v1 = this;
                        if (v1.db.hasMenge()) {
                            if (!DataBase.MENGE.contains(var15_25.pa)) continue;
                            if (!DataBase.MENGE.contains(var15_25.pe)) continue;
                        }
                        if (this.lineIsWritten(var15_25, (Vector)var7_9)) continue;
                        var16_26 /* !! */  = (Linie)var15_25.clone();
                        if (var15_25.pa.getNr() > var15_25.pe.getNr()) {
                            var16_26 /* !! */ .skip();
                        }
                        var11_16.addElement(var16_26 /* !! */ );
                    }
                    ++var12_19;
                }
                var11_16.sort(new LineComparator(this));
                for (var12_19 = 0; var12_19 < var11_16.size(); ++var12_19) {
                    var13_22 = (Linie)var11_16.elementAt(var12_19);
                    if (KatasternachweisIOProperties.writeShortLines()) {
                        this.writeLinieAsShortRissLengthLine(var1_1, (Linie)var13_22);
                    } else {
                        if (var10_15 == null || !var10_15.equals(var13_22.pa)) {
                            this.writeVoidAsRissLengthLine(var1_1);
                            this.writePunktAsRissLengthLine(var1_1, var13_22.pa);
                        }
                        this.writeLinieAsRissLengthLine(var1_1, (Linie)var13_22);
                        this.writePunktAsRissLengthLine(var1_1, var13_22.pe);
                    }
                    var10_15 = var13_22.pe;
                    if ((long)var12_19 % super.getProgressBreak() != 0L) continue;
                    super.setProgress(var3_5);
                }
            }
            if (KatasternachweisIOProperties.writeWithGebaeude()) {
                var1_1.println("\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\cltxlrtb\\cellx9923\n{\\trwd}\n\\pard\\plain \\s3\\keepn\\widctlpar\\intbl\\outlinelevel2\\adjustright \\b\\fs20\\ul\\lang1031\\cgrid \\ \\cell\n\\pard\\plain \\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid\n{\\row }\n{\\trwd}\n\\pard\\plain \\s3\\keepn\\widctlpar\\intbl\\outlinelevel2\\adjustright \\b\\fs20\\ul\\lang1031\\cgrid \\'d6rtliche Geb\\'e4udel\\'e4ngen\\cell\n\\pard\\plain \\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid\n{\\row }\n\\trowd \\trgaph70\\trleft-70\\trbrdrt\\brdrs\\brdrw10\\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx1276\\clvertalt\\cltxlrtb\n\\cellx2835\\clvertalt\\cltxlrtb \\cellx4395\\clvertalt\\cltxlrtb\\cellx5245\\clvertalt\\cltxlrtb \\cellx6096\\clvertalt\\cltxlrtb \\cellx6946\\clvertalt\\cltxlrtb \\cellx9923");
                if (KatasternachweisIOProperties.writeShortLines()) {
                    var1_1.println("{\\trwd}\\pard \\qc\\widctlpar\\intbl\\adjustright{\\b von PNR\\cell\\b nach PNR\\cell\\b Geb\\'e4udel\\'e4nge\\cell\\cell \\cell \\cell } \\pard \\widctlpar\\intbl\\adjustright {\\cell }{\\row }");
                }
                super.setEndValue(DataBase.GEB.size());
                super.setProgressBreak();
                super.setValue(0L);
                super.setLabelText("Geb\u00e4udel\u00e4ngenliste erstellen...");
                var8_10 = null;
                var9_11 = null;
                var10_15 = null;
                var11_16 = new SortableVector();
                var12_20 = 0;
                while (true) {
                    if (var12_20 >= DataBase.GEB.size()) break;
                    var13_22 = (Gebaeude)DataBase.GEB.elementAt(var12_20);
                    var14_24 = var13_22.getKatasterNachweisLinien(this.getExceptionList()).elements();
                    while (var14_24.hasMoreElements()) {
                        var15_25 = (Linie)var14_24.nextElement();
                        if (var15_25.getLa() != 3 || !var15_25.pa.isFortfuehrung() || !var15_25.pe.isFortfuehrung()) continue;
                        v2 = this;
                        if (v2.db.hasMenge()) {
                            if (!DataBase.MENGE.contains(var15_25.pa)) continue;
                            if (!DataBase.MENGE.contains(var15_25.pe)) continue;
                        }
                        if (this.lineIsWritten(var15_25, (Vector)var7_9)) continue;
                        var16_26 /* !! */  = (Linie)var15_25.clone();
                        if (var15_25.pa.getNr() > var15_25.pe.getNr()) {
                            var16_26 /* !! */ .skip();
                        }
                        var11_16.addElement(var16_26 /* !! */ );
                    }
                    ++var12_20;
                }
                var11_16.sort(new LineComparator(this));
                for (var12_20 = 0; var12_20 < var11_16.size(); ++var12_20) {
                    var13_22 = (Linie)var11_16.elementAt(var12_20);
                    if (KatasternachweisIOProperties.writeShortLines()) {
                        this.writeLinieAsShortRissLengthLine(var1_1, (Linie)var13_22);
                    } else {
                        if (var10_15 == null || !var10_15.equals(var13_22.pa)) {
                            this.writeVoidAsRissLengthLine(var1_1);
                            this.writePunktAsRissLengthLine(var1_1, var13_22.pa);
                        }
                        this.writeLinieAsRissLengthLine(var1_1, (Linie)var13_22);
                        this.writePunktAsRissLengthLine(var1_1, var13_22.pe);
                    }
                    var10_15 = var13_22.pe;
                    if ((long)var12_20 % super.getProgressBreak() != 0L) continue;
                    super.setProgress(var3_5);
                }
            }
            var1_1.println("}");
            var1_1.close();
            var3_5 = 0;
            super.setEndValue(DataBase.MK.size());
            super.setProgressBreak();
            super.setValue(var3_5);
            super.setLabelText("Punktidentit\u00e4tsliste erstellen...");
            KatasterParameter.USE_GEWICHTE = KatasternachweisIOProperties.useGewichte();
            this.outFile = this.identFile;
            var1_1 = this.createWriter(this.identFile);
            var1_1.println("{\\rtf1\\ansi\\ansicpg1252\\uc1 \\deff0\\deflang1033\\deflangfe1031\n{\\fonttbl{\\f0\\froman\\fcharset0\\fprq2{\\*\\panose 02020603050405020304}Times New Roman;}}\n\\paperw11907\\paperh16840\\margl1588\\margr567\\margt851\\margb1021\n\\deftab708\\widowctrl\\ftnbj\\aenddoc\\hyphhotz425\\hyphcaps0\\formshade\\viewkind1\\pgbrdrhead\\pgbrdrfoot \\fet0\\sectd \\psz9\\linex0\\headery709\\footery709\\colsx709\\endnhere\\sectdefaultcl");
            var1_1.println("{\\header \\pard\\plain \\widctlpar\\adjustright\\fs20\\lang1031\\cgrid {\\b\\fs28 Nachweis der Punktidentit\\'e4t (}\n{\\field{\\*\\fldinst {\\cs17\\b\\fs28  PAGE }}{\\fldrslt {\\cs17\\b\\fs28\\lang1024 1}}}{\\cs17\\b\\fs28 /}{\\field{\\*\\fldinst {\\cs17\\b\\fs28  NUMPAGES }}{\\fldrslt {\\cs17\\b\\fs28\\lang1024 1}}}{\\b\\fs28 )\\par }");
            this.writeKopfTable(var1_1);
            var1_1.println("\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrr\n\\brdrs\\brdrw10 \\cltxlrtb \\cellx851\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx2897\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx4943\\clvertalt\\clbrdrt\n\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6361\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx7070\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\n\\brdrs\\brdrw10 \\cltxlrtb \\cellx8180\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923\n{\\trwd}\n\\pard \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright {\\b\\fs16 PAT/\\line PNR\\cell amtliche Koordinaten\\line (Soll)\\cell Vermessungsergebnis\\line (Ist)\\cell Soll-Ist\\cell Abwei-\\line chung\\cell Riss/\\line Jahr\\cell Bemerkung\\cell }\n{\\row }\n\\trowd \\trgaph70\\trleft-70\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\n\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx851\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx1874\\clvertalt\n\\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx2897\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx3920\\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\n\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx4943\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx5652\\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10\n\\cltxlrtb \\cellx6361\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx7070\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx8180\\clvertalt\\clbrdrl\\brdrs\\brdrw10\n\\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923\n{\\trwd}\n\\pard \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright {\\b\\fs16 \\cell }\n\\pard\\plain \\s2\\qc\\sb60\\sa60\\keepn\\widctlpar\\intbl\\outlinelevel1\\adjustright \\b\\fs16\\lang1031\\cgrid {Y\\cell }\n\\pard\\plain \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {\\b\\fs16 X\\cell y\\cell }\n\\pard\\plain \\s2\\qc\\sb60\\sa60\\keepn\\widctlpar\\intbl\\outlinelevel1\\adjustright \\b\\fs16\\lang1031\\cgrid {x\\cell }\n\\pard\\plain \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright\\fs20\\lang1031\\cgrid {\\b\\fs16 dy\\cell dx\\cell d}{\\b\\fs16\\sub k}{\\b\\fs16 /d}{\\b\\fs16\\sub s}{\\b\\fs16 \\cell \\cell \\cell }\n{\\row }\n\\trowd \\trgaph70\\trleft-70\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10\n\\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx851\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10\n\\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx1874\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx2897\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10\n\\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx3920\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx4943\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10\n\\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx5652\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6361\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10\n\\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx7070\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx8180\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\n\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923\n{\\trwd}\n\\pard \\qc\\sb20\\sa20\\widctlpar\\intbl\\adjustright {\\fs12 1\\cell 2\\cell 3\\cell 4\\cell 5\\cell 6\\cell 7\\cell 8\\cell 9\\cell 10\\cell }\n\\pard \\widctlpar\\intbl\\adjustright\n{\\row }\n\\pard\\plain \\s15\\widctlpar\\tqc\\tx4536\\tqr\\tx9072\\adjustright \\fs20\\lang1031\\cgrid {\\par}}{\\footer\n\\pard\\plain \\s16\\widctlpar\\tqc\\tx4536\\tqr\\tx9072\\adjustright \\fs20\\lang1031\\cgrid {\\par }}\n{\\*\\pnseclvl1\\pnucrm\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}{\\*\\pnseclvl2\\pnucltr\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}{\\*\\pnseclvl3\\pndec\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}{\\*\\pnseclvl4\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxta )}}\n{\\*\\pnseclvl5\\pndec\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}{\\*\\pnseclvl6\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}{\\*\\pnseclvl7\\pnlcrm\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}\n{\\*\\pnseclvl8\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}{\\*\\pnseclvl9\\pnlcrm\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}");
            var1_1.println("{\\par}}");
            var1_1.println("\\trowd \\trgaph70\\trleft-70\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10\\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalc\\clbrdrl\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx851\\clvertalc\\cltxlrtb\n\\cellx1874\\clvertalc\\cltxlrtb \\cellx2897\\clvertalc\\cltxlrtb \\cellx3920\\clvertalc\\cltxlrtb \\cellx4943\\clvertalc\\cltxlrtb \\cellx5652\n\\clvertalc\\cltxlrtb \\cellx6361\\clvertalc\\cltxlrtb \\cellx7070\\clvertalc\\cltxlrtb \\cellx8180\\clvertalc\\cltxlrtb \\cellx9923");
            var11_16 = null;
            var12_21 = 0;
            var13_23 = 0;
            var14_24 = null;
            var15_25 = null;
            var17_27 = null;
            var18_28 = null;
            var19_29 = null;
            var20_30 = null;
            var21_31 = DataBase.MK.elements();
            while (var21_31.hasMoreElements()) {
                var22_32 = (Riss)var21_31.nextElement();
                var11_16 = var22_32.getName();
                block61: for (var23_33 = 0; var23_33 < var22_32.size(); ++var23_33) {
                    var24_37 = (Messung)var22_32.elementAt(var23_33);
                    if (!var24_37.isOn()) continue;
                    switch (var24_37.getMessungsArt(true)) {
                        case 240: {
                            if (var24_37.hasTag("NO") || var24_37.hasTag("NO2")) continue block61;
                            var25_38 = var24_37.l2;
                            var24_37 = (Messung)var24_37.clone();
                            var24_37.l1 = var25_38;
                            var24_37.l2 = 0.0;
                        }
                        case 220: 
                        case 260: {
                            if (var24_37.hasTag("NO")) continue block61;
                            var19_29 = var24_37.ps.isVermarkungVorgefunden() != false ? null : VermarkungsArt.toString(var24_37.ps.getVaVorgefunden());
                            var20_30 = var24_37.pz.isVermarkungVorgefunden() != false ? null : VermarkungsArt.toString(var24_37.pz.getVaVorgefunden());
                            var16_26 /* !! */  = (PunktIdentitaet)this.P_IDENT.get(new Long(var24_37.ps.nr));
                            if (var16_26 /* !! */  != null) {
                                if (!this.writeMessPunkt(var16_26 /* !! */ .soll) || !this.writeMessPunkt(var24_37.pz)) continue block61;
                                this.writeStreckeAsIdentLine(var1_1, (Messung)var24_37, new Messung(var24_37.ma, var24_37.ps, var24_37.pz, DataBase.getStrecke(var16_26 /* !! */ .ist, var24_37.pz), 0.0), (String)var11_16, var16_26 /* !! */ .bemIst, var20_30, var24_37.getText());
                                this.writeStreckeAsIdentLine(var1_1, (Messung)var24_37, new Messung(var24_37.ma, var24_37.ps, var24_37.pz, DataBase.getStrecke(var24_37.ps, var24_37.pz), 0.0), (String)var11_16, var16_26 /* !! */ .bemSoll, var20_30, var24_37.getText());
                            } else {
                                var16_26 /* !! */  = (PunktIdentitaet)this.P_IDENT.get(new Long(var24_37.pz.nr));
                                if (var16_26 /* !! */  != null) {
                                    if (!this.writeMessPunkt(var16_26 /* !! */ .soll) || !this.writeMessPunkt(var24_37.ps)) continue block61;
                                    this.writeStreckeAsIdentLine(var1_1, (Messung)var24_37, new Messung(var24_37.ma, var24_37.ps, var24_37.pz, DataBase.getStrecke(var24_37.ps, var16_26 /* !! */ .ist), 0.0), (String)var11_16, var19_29, var16_26 /* !! */ .bemIst, var24_37.getText());
                                    this.writeStreckeAsIdentLine(var1_1, (Messung)var24_37, new Messung(var24_37.ma, var24_37.ps, var24_37.pz, DataBase.getStrecke(var24_37.ps, var24_37.pz), 0.0), (String)var11_16, var19_29, var16_26 /* !! */ .bemSoll, var24_37.getText());
                                } else {
                                    if (!this.writeMessPunkt(var24_37.ps) && !this.writeMessPunkt(var24_37.pz)) continue block61;
                                    var27_40 = new Messung(var24_37.ma, var24_37.ps, var24_37.pz, DataBase.getStrecke(var24_37.ps, var24_37.pz), 0.0);
                                    if (Math.abs(var27_40.l1 - var24_37.l1) > this.db.getKatasterStreckenGenauigkeit(var24_37.l1, var24_37.getGewichte().getG1())) {
                                        if (var24_37.isFehler()) {
                                            var18_28 = "fehlerhaftes Ma\u00df";
                                        } else {
                                            var18_28 = "unzul. Abweichung";
                                            this.addException(new SurveyException("Identit\u00e4tliste:\n     unzul\u00e4ssige Strecken-Abweichung zwischen den Punkten " + var24_37.ps.getNr() + " und " + var24_37.pz.getNr()));
                                        }
                                    } else {
                                        var18_28 = null;
                                    }
                                    this.writeStreckeAsIdentLine(var1_1, (Messung)var24_37, (Messung)var27_40, (String)var11_16, var19_29, var20_30, var24_37.hasText() != false ? var24_37.getText() : var18_28);
                                }
                            }
                            if (KatasternachweisIOProperties.writeIdentTitel()) continue block61;
                            this.writeVoidLineAsIdentLine(var1_1);
                            continue block61;
                        }
                        case 210: {
                            var17_27 = new OrthoLinie();
                            var17_27.setAnfangsPunkt(var24_37.pz != null && var24_37.pz.nr != 0L ? var24_37.pz : var24_37.ps);
                            var17_27.setAnfangsMasse(var24_37.l1, var24_37.pz != null && var24_37.pz.nr != 0L ? 0.0 : var24_37.l2);
                            var12_21 = var23_33;
                            continue block61;
                        }
                        case 290: {
                            var17_27.setEndPunkt(var24_37.pz != null && var24_37.pz.nr != 0L ? var24_37.pz : var24_37.ps);
                            var17_27.setEndOrdinate(var24_37.pz != null && var24_37.pz.nr != 0L ? 0.0 : var24_37.l2);
                            var13_23 = var23_33;
                            var27_41 = false;
                            block62: for (var28_42 = var12_21; var28_42 <= var13_23; ++var28_42) {
                                var29_45 = (Messung)var22_32.elementAt(var28_42);
                                var30_46 = null;
                                if (!var29_45.isOn() || var29_45.hasTag("NO")) continue;
                                switch (var29_45.getMessungsArt(true)) {
                                    case 240: {
                                        if (var29_45.hasTag("NO1")) continue block62;
                                        var19_29 = var29_45.ps.isVermarkungVorgefunden() != false ? null : VermarkungsArt.toString(var29_45.ps.getVaVorgefunden());
                                        var16_26 /* !! */  = (PunktIdentitaet)this.P_IDENT.get(new Long(var29_45.ps.nr));
                                        if (var16_26 /* !! */  != null) {
                                            if (!this.writeMessPunkt(var16_26 /* !! */ .soll) || !this.writeMessPunkt(var29_45.pz)) continue block62;
                                            var30_46 = var17_27.getMessungOf(var16_26 /* !! */ .ist);
                                            this.writeOrthoAsIdentLine(var1_1, new Messung(var29_45.ma, var16_26 /* !! */ .soll, var16_26 /* !! */ .soll, var29_45.l1, 0.0), new Messung(var29_45.ma, var16_26 /* !! */ .soll, var16_26 /* !! */ .soll, var30_46.l1, var30_46.l2), (String)var11_16, var16_26 /* !! */ .bemIst);
                                            var27_41 = true;
                                        }
                                        if (!this.writeMessPunkt(var29_45.ps) || !this.writeMessPunkt(var29_45.pz)) continue block62;
                                        var30_46 = var17_27.getMessungOf(var29_45.ps);
                                        if (Math.abs(var30_46.l1 - var29_45.l1) > this.db.getKatasterStreckenGenauigkeit(var29_45.l1 - var17_27.getAnfangsMass(), var29_45.getGewichte().getG1()) || Math.abs(var30_46.l2) > this.db.getKatasterStreckenGenauigkeit(0.0, var29_45.getGewichte().getG2())) {
                                            if (var29_45.isFehler()) {
                                                var18_28 = var29_45.hasText() != false ? var29_45.getText() : "fehlerhaftes Ma\u00df";
                                            } else {
                                                var18_28 = var29_45.hasText() != false ? var29_45.getText() : "unzul. Abweichung";
                                                this.addException(new SurveyException("Identit\u00e4tliste:\n     unzul\u00e4ssige Linien-Abweichung in Punkt " + var29_45.ps.getNr()));
                                            }
                                        } else {
                                            var18_28 = var29_45.getText();
                                        }
                                        this.writeOrthoAsIdentLine(var1_1, new Messung(var29_45.ma, var29_45.ps, var29_45.pz, var29_45.l1, 0.0), new Messung(var29_45.ma, var29_45.ps, var29_45.ps, var30_46.l1, var30_46.l2), (String)var11_16, var16_26 /* !! */  != null ? var16_26 /* !! */ .bemSoll : var19_29);
                                        var27_41 = true;
                                        continue block62;
                                    }
                                    case 200: 
                                    case 210: 
                                    case 290: {
                                        if (!var29_45.hasTag("NO2") && var29_45.pz != null && var29_45.pz.nr != 0L) {
                                            var20_30 = var29_45.pz.isVermarkungVorgefunden() != false ? null : VermarkungsArt.toString(var29_45.pz.getVaVorgefunden());
                                            var16_26 /* !! */  = (PunktIdentitaet)this.P_IDENT.get(new Long(var29_45.pz.nr));
                                            if (var16_26 /* !! */  != null && this.writeMessPunkt(var16_26 /* !! */ .soll)) {
                                                var30_46 = var17_27.getMessungOf(var16_26 /* !! */ .ist);
                                                this.writeOrthoAsIdentLine(var1_1, new Messung(var29_45.ma, var16_26 /* !! */ .soll, var16_26 /* !! */ .soll, var29_45.l1, 0.0), new Messung(var29_45.ma, var16_26 /* !! */ .soll, var16_26 /* !! */ .soll, var30_46.l1, var30_46.l2), (String)var11_16, var16_26 /* !! */ .bemIst);
                                                var27_41 = true;
                                            }
                                            if (this.writeMessPunkt(var29_45.pz)) {
                                                var30_46 = var17_27.getMessungOf(var29_45.pz);
                                                if (var29_45.getWerteBelegung() > 0 && (Math.abs(var30_46.l1 - var29_45.l1) > this.db.getKatasterStreckenGenauigkeit(var29_45.l1 - var17_27.getAnfangsMass(), var29_45.getGewichte().getG1()) || Math.abs(var30_46.l2) > this.db.getKatasterStreckenGenauigkeit(0.0, var29_45.getGewichte().getG2()))) {
                                                    if (var29_45.isFehler()) {
                                                        var18_28 = var29_45.hasText() != false ? var29_45.getText() : "fehlerhaftes Ma\u00df";
                                                    } else {
                                                        var18_28 = var29_45.hasText() != false ? var29_45.getText() : "unzul. Abweichung";
                                                        this.addException(new SurveyException("Identit\u00e4tliste:\n     unzul\u00e4ssige Linien-Abweichung in Punkt " + var29_45.ps.getNr()));
                                                    }
                                                } else {
                                                    var18_28 = var29_45.hasText() != false ? var29_45.getText() : var20_30;
                                                }
                                                this.writeOrthoAsIdentLine(var1_1, new Messung(var29_45.ma, var29_45.ps, var29_45.pz, var29_45.l1, 0.0), new Messung(var29_45.ma, var29_45.pz, var29_45.pz, var30_46.l1, var30_46.l2), (String)var11_16, var16_26 /* !! */  != null ? var16_26 /* !! */ .bemSoll : var18_28);
                                                var27_41 = true;
                                            }
                                        }
                                        if (var29_45.hasTag("NO1")) continue block62;
                                        var19_29 = var29_45.ps.isVermarkungVorgefunden() != false ? null : VermarkungsArt.toString(var29_45.ps.getVaVorgefunden());
                                        var16_26 /* !! */  = (PunktIdentitaet)this.P_IDENT.get(new Long(var29_45.ps.nr));
                                        if (var16_26 /* !! */  != null && this.writeMessPunkt(var16_26 /* !! */ .soll)) {
                                            var30_46 = var17_27.getMessungOf(var16_26 /* !! */ .ist);
                                            this.writeOrthoAsIdentLine(var1_1, var29_45, new Messung(var29_45.ma, var16_26 /* !! */ .soll, var16_26 /* !! */ .soll, var30_46.l1, var30_46.l2), (String)var11_16, var16_26 /* !! */ .bemIst);
                                            var27_41 = true;
                                        }
                                        if (!this.writeMessPunkt(var29_45.ps)) continue block62;
                                        var30_46 = var17_27.getMessungOf(var29_45.ps);
                                        if (var29_45.getWerteBelegung() > 0 && (Math.abs(var30_46.l1 - var29_45.l1) > this.db.getKatasterStreckenGenauigkeit(var29_45.l1 - var17_27.getAnfangsMass(), var29_45.getGewichte().getG1()) || Math.abs(var30_46.l2 - var29_45.l2) > this.db.getKatasterStreckenGenauigkeit(var29_45.l2, var29_45.getGewichte().getG1()))) {
                                            if (var29_45.isFehler()) {
                                                var18_28 = var29_45.hasText() != false ? var29_45.getText() : "fehlerhaftes Ma\u00df";
                                            } else {
                                                var18_28 = var29_45.hasText() != false ? var29_45.getText() : "unzul. Abweichung";
                                                this.addException(new SurveyException("Identit\u00e4tliste:\n     unzul\u00e4ssige Linien-Abweichung in Punkt " + var29_45.ps.getNr()));
                                            }
                                        } else {
                                            var18_28 = var29_45.hasText() != false ? var29_45.getText() : var19_29;
                                        }
                                        this.writeOrthoAsIdentLine(var1_1, var29_45, new Messung(var29_45.ma, var29_45.ps, var29_45.ps, var30_46.l1, var30_46.l2), (String)var11_16, var16_26 /* !! */  != null ? var16_26 /* !! */ .bemSoll : var18_28);
                                        var27_41 = true;
                                    }
                                }
                            }
                            if (var27_41 && !KatasternachweisIOProperties.writeIdentTitel()) {
                                this.writeVoidLineAsIdentLine(var1_1);
                            }
                            this.block = 0;
                        }
                    }
                }
                if ((long)var3_5 % super.getProgressBreak() == 0L) {
                    super.setProgress(var3_5);
                }
                ++var3_5;
            }
            var21_31 = DataBase.T.elements();
            while (var21_31.hasMoreElements()) {
                var22_32 = (TrafoSystem)var21_31.nextElement();
                if (var22_32.isKatasterNachweisElement()) {
                    if (!KatasternachweisIOProperties.writeIdentTitel()) {
                        this.writeVoidLineAsIdentLine(var1_1);
                    }
                    var23_35 = var22_32.getName();
                    var24_37 = var22_32.elements();
                    while (var24_37.hasMoreElements()) {
                        var25_39 = (TrafoPunkt)var24_37.nextElement();
                        if (!this.writeMessPunkt(var25_39.getPunkt())) continue;
                        var16_26 /* !! */  = (PunktIdentitaet)this.P_IDENT.get(new Long(var25_39.getPunkt().nr));
                        if (var16_26 /* !! */  != null) {
                            var26_47 = var22_32.getInversePoint(var16_26 /* !! */ .ist);
                            var27_40 = var22_32.getInversePoint(var16_26 /* !! */ .soll);
                            var28_44 = new TrafoPunkt(var16_26 /* !! */ .soll, var25_39.y, var25_39.x);
                            var28_44.setVy((float)((double)var25_39.getVy() + (var26_47.y - var27_40.y)));
                            var28_44.setVx((float)((double)var25_39.getVx() + (var26_47.x - var27_40.x)));
                            this.writeTrafoPunktAsIdentLine(var1_1, var28_44, var23_35, var16_26 /* !! */ .bemIst);
                        } else if (!var25_39.isOn()) {
                            var26_47 = var22_32.getInversePoint(var25_39.getPunkt());
                            var27_40 = new TrafoPunkt(var25_39.getPunkt(), var25_39.y, var25_39.x);
                            var27_40.setVy((float)(var26_47.y - var25_39.y));
                            var27_40.setVx((float)(var26_47.x - var25_39.x));
                            this.writeTrafoPunktAsIdentLine(var1_1, (TrafoPunkt)var27_40, var23_35, var25_39.getBemerkung() != null ? var25_39.getBemerkung() : "Koordinaten-Fehler");
                            continue;
                        }
                        this.writeTrafoPunktAsIdentLine(var1_1, var25_39, var23_35, var16_26 /* !! */  != null ? var16_26 /* !! */ .bemSoll : var25_39.getBemerkung());
                    }
                }
                this.block = 0;
            }
            var3_5 = 0;
            super.setEndValue(DataBase.P.size());
            super.setProgressBreak();
            super.setValue(var3_5);
            super.setLabelText("Koordinatenidentit\u00e4tsliste erstellen...");
            this.block = 5;
            this.writeBlockTableHeader(var1_1, 5);
            var4_6 = 0;
            var21_31 = var6_8.elements();
            while (var21_31.hasMoreElements()) {
                block182: {
                    block183: {
                        var22_32 = (Punkt)var21_31.nextElement();
                        var16_26 /* !! */  = (PunktIdentitaet)this.P_IDENT.get(new Long(var22_32.nr));
                        if (var22_32.getPs() == -2 || var22_32.getInternalPs() == 2 || !var22_32.isFortfuehrung()) break block182;
                        v3 = this;
                        if (!v3.db.hasMenge()) break block183;
                        if (!DataBase.MENGE.contains((LongHashObject)var22_32)) break block182;
                    }
                    if (var22_32.getLongNb() > var4_6) {
                        this.writeNbAsIdentLine(var1_1, Punkt.createNbAsString(var22_32.createNb()));
                        var4_6 = var22_32.getLongNb();
                    }
                    if (var16_26 /* !! */  != null) {
                        this.writePunktAsIdentPointLine(var1_1, var16_26 /* !! */ .soll, var16_26 /* !! */ .ist, var16_26 /* !! */ .bemIst);
                    }
                    switch (var22_32.getPs()) {
                        case 5: {
                            if (var22_32.isErrHoldKoo()) {
                                var23_36 = new Punkt(var22_32.getNr(), var22_32.getParameter().getPa(), var22_32.getParameter().getVa(), var22_32.y + (double)var22_32.dy, var22_32.x + (double)var22_32.dx);
                                var23_36.getParameter((Punkt)var22_32);
                                this.writePunktAsIdentPointLine(var1_1, (Punkt)var22_32, var23_36, var16_26 /* !! */  != null ? var16_26 /* !! */ .bemSoll : null);
                                break;
                            }
                        }
                        case 0: {
                            var23_36 = (Punkt)var22_32.clone();
                            var23_36.y = var22_32.y - (double)var22_32.dy;
                            var23_36.x = var22_32.x - (double)var22_32.dx;
                            this.writePunktAsIdentPointLine(var1_1, var23_36, (Punkt)var22_32, var16_26 /* !! */  != null ? var16_26 /* !! */ .bemSoll : null);
                            break;
                        }
                        case 2: {
                            var24_37 = new Punkt(var22_32.getNr(), var22_32.getParameter().getPa(), var22_32.getParameter().getVa(), var22_32.y + (double)var22_32.dy, var22_32.x + (double)var22_32.dx);
                            var24_37.getParameter((Punkt)var22_32);
                            this.writePunktAsIdentPointLine(var1_1, (Punkt)var22_32, (Punkt)var24_37, var16_26 /* !! */  != null ? var16_26 /* !! */ .bemSoll : null);
                            break;
                        }
                        case 1: {
                            this.writePunktAsIdentPointLine(var1_1, (Punkt)var22_32, var16_26 /* !! */  != null ? var16_26 /* !! */ .bemSoll : null);
                        }
                    }
                    if ((long)var3_5 % super.getProgressBreak() == 0L) {
                        super.setProgress(var3_5);
                    }
                }
                ++var3_5;
            }
            var1_1.println("}");
            var1_1.close();
        }
        catch (IOException var2_3) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
    }

    private boolean writeMessPunkt(Punkt punkt) {
        KatasternachweisBrbWriter katasternachweisBrbWriter = this;
        if (katasternachweisBrbWriter.db.hasMenge()) {
            if (!DataBase.MENGE.contains(punkt)) {
                return false;
            }
        }
        return KatasternachweisIOProperties.writeLokalPunkt() || !punkt.isLokalPunkt() || this.P_IDENT.get(new Long(punkt.nr)) != null;
    }

    private boolean lineIsWritten(Linie linie, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Linie linie2 = (Linie)vector.elementAt(i);
            if (!linie.equalsIgnoreArt(linie2)) continue;
            return true;
        }
        vector.addElement(linie);
        return false;
    }

    private void writeKopfTable(PrintWriter printWriter) {
        printWriter.println("\\trowd \\trgaph70\\trrh400\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb");
        printWriter.println("\\brdrs\\brdrw10 \\cltxlrtb \\cellx1134\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx3402\\clvmgf\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb");
        printWriter.println("\\cellx5954\\clvmgf\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx7797\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923");
        printWriter.println("{\\trwd}");
        printWriter.println("\\pard \\widctlpar\\intbl\\adjustright {\\fs16 Gemeinde }{\\cell }");
        printWriter.print("\\pard\\plain \\s1\\keepn\\widctlpar\\intbl\\outlinelevel0\\adjustright \\b\\fs20\\lang1031\\cgrid {");
        if (DataBase.gemeinde != null) {
            printWriter.print(KatasternachweisBrbWriter.getRtfString(DataBase.gemeinde));
        }
        printWriter.println("\\cell }");
        printWriter.println("\\pard\\plain \\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {" + KatasternachweisBrbWriter.getRtfString(KatasternachweisIOProperties.getVermTitle()) + "\\par }");
        printWriter.print("\\pard \\qc\\widctlpar\\intbl\\adjustright {\\b\\fs16 ");
        if (DataBase.vermStelle != null) {
            printWriter.print(KatasternachweisBrbWriter.getRtfString(KatasternachweisIOProperties.getVermPrefix() + DataBase.vermStelle));
        }
        printWriter.println("}{\\fs16 \\cell }");
        printWriter.println("\\pard \\widctlpar\\intbl\\adjustright {" + KatasternachweisBrbWriter.getRtfString(KatasternachweisIOProperties.getAmtTitle()) + "\\par }");
        printWriter.print("\\pard \\qc\\widctlpar\\intbl\\adjustright {");
        if (DataBase.katasterAmt != null) {
            printWriter.print(KatasternachweisBrbWriter.getRtfString(KatasternachweisIOProperties.getAmtPrefix() + DataBase.katasterAmt));
        }
        printWriter.println("\\cell }");
        printWriter.println("\\pard \\widctlpar\\intbl\\adjustright {\\fs16 Archivblatt*:\\cell }");
        printWriter.println("{\\row }");
        printWriter.println("\\trowd \\trgaph70\\trrh400\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr");
        printWriter.println("\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\cltxlrtb \\cellx1134\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb");
        printWriter.println("\\cellx3402\\clvmrg\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx5954\\clvmrg\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10");
        printWriter.println("\\cltxlrtb \\cellx7797\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923");
        printWriter.println("{\\trwd}");
        printWriter.println("\\pard \\widctlpar\\intbl\\adjustright {\\fs16 Gemarkung\\cell }");
        printWriter.print("\\pard\\plain \\s1\\keepn\\widctlpar\\intbl\\outlinelevel0\\adjustright\\b\\fs20\\lang1031\\cgrid {");
        if (this.gemarkung != null) {
            printWriter.print(KatasternachweisBrbWriter.getRtfString(this.gemarkung));
        }
        printWriter.println("\\cell }");
        printWriter.println("\\pard\\plain \\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {\\cell \\cell }{\\fs16 Antrags-Nr.*:\\cell }");
        printWriter.println("{\\row }");
        printWriter.println("\\trowd \\trgaph70\\trrh400\\trleft-70\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl");
        printWriter.println("\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx1134\\clvertalt\\clbrdrt");
        printWriter.println("\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx3402\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\cltxlrtb \\cellx5954\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\cltxlrtb \\cellx7797\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\cltxlrtb");
        printWriter.println("\\cellx9923");
        printWriter.println("{\\trwd}");
        printWriter.print("\\pard \\widctlpar\\intbl\\adjustright {\\fs16 Flur}{ }{\\b ");
        if (DataBase.flur != null) {
            printWriter.print(KatasternachweisBrbWriter.getRtfString(DataBase.flur));
        }
        printWriter.println("}{\\cell }");
        printWriter.print("{\\fs16 Flurst\\'fcck }{\\b ");
        if (DataBase.flurstueck != null) {
            printWriter.print(KatasternachweisBrbWriter.getRtfString(DataBase.flurstueck));
        }
        printWriter.println("}{\\fs16 \\cell }");
        printWriter.println("{\\cell \\cell }{\\fs12 * wird vom Katasteramt ausgef\\'fcllt\\cell }");
        printWriter.println("{\\row }");
        printWriter.println("\\pard \\widctlpar\\adjustright");
        printWriter.println("{\\par\\par}");
    }

    private void writeBlockTableHeader(PrintWriter printWriter, int n) {
        String string = "";
        if (KatasternachweisIOProperties.writeIdentTitel()) {
            switch (n) {
                case 1: {
                    string = "Polare Messung";
                    break;
                }
                case 2: {
                    string = "Orthogonale Linie";
                    break;
                }
                case 3: {
                    string = "Streckenvergleich";
                    break;
                }
                case 4: {
                    string = "Transformation";
                    break;
                }
                case 5: {
                    string = "Koordinatenvergleich";
                }
            }
        }
        printWriter.println("\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10");
        printWriter.println("\\clvertalc\\clbrdrl\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx8180\\clvertalc\\cltxlrtb \\cellx9001\\clvertalc\\cltxlrtb \\cellx9923");
        printWriter.print("\\pard\\widctlpar\\intbl\\adjustright {\\fs20\\b " + string + "\\cell }{\\fs16 ");
        if (n == 5) {
            KatasternachweisBrbWriter katasternachweisBrbWriter = this;
            printWriter.print("LST: " + katasternachweisBrbWriter.db.getKooSystem());
        }
        printWriter.print("\\cell }{\\fs16 ");
        if (n == 5) {
            KatasternachweisBrbWriter katasternachweisBrbWriter = this;
            printWriter.print("h{\\sub m}: " + i0.format((int)katasternachweisBrbWriter.db.getGelHoehe()));
        }
        printWriter.println("\\cell }\\pard \\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println(IDENT_TABLE_HEADER);
    }

    private void writeNbAsRissLine(PrintWriter printWriter, String string) {
        printWriter.println("\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10\\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx9923");
        printWriter.println("{\\trwd}");
        printWriter.print("\\pard\\plain \\s1\\keepn\\widctlpar\\intbl\\outlinelevel0\\adjustright\\b\\fs20\\lang1031\\cgrid {Nummerierungsbezirk: ");
        printWriter.print(string);
        printWriter.println("\\cell }");
        printWriter.println("\\pard\\plain \\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid");
        printWriter.println("{\\row }");
        printWriter.println("\\trowd \\trgaph70\\trleft-70\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10\\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx1276\\clvertalt\\cltxlrtb");
        printWriter.println("\\cellx2835\\clvertalt\\cltxlrtb \\cellx4395\\clvertalt\\cltxlrtb \\cellx5245\\clvertalt\\cltxlrtb \\cellx6096\\clvertalt\\cltxlrtb \\cellx6946\\clvertalt\\cltxlrtb \\cellx9923");
    }

    private void writeNbAsIdentLine(PrintWriter printWriter, String string) {
        printWriter.println("\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx9923");
        printWriter.println("\\pard \\widctlpar\\intbl\\adjustright {\\fs20\\b Nummerierungsbezirk: " + string + "}{\\cell }\\pard \\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\trowd \\trgaph70\\trleft-70\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10");
        printWriter.println("\\cltxlrtb \\cellx851\\clvertalt\\cltxlrtb \\cellx1874\\clvertalt\\cltxlrtb \\cellx2897\\clvertalt\\cltxlrtb \\cellx3920\\clvertalt\\cltxlrtb \\cellx4943\\clvertalt\\cltxlrtb \\cellx5652\\clvertalt\\cltxlrtb \\cellx6361\\clvertalt\\cltxlrtb \\cellx7070\\clvertalc\\cltxlrtb");
        printWriter.println("\\cellx8180\\clvertalc\\cltxlrtb \\cellx9923");
    }

    private void writePunktAsRissPointLine(PrintWriter printWriter, Punkt punkt, String string) {
        PunktParameter punktParameter = punkt.getParameter();
        printWriter.println("{\\trwd}");
        printWriter.print("\\pard \\qc\\widctlpar\\intbl\\adjustright {");
        if (punkt.getKafPa() != -1) {
            printWriter.print(punkt.getParameter().getOutPa() + SPACE);
            if (punkt.getKatNr() > 99999L) {
                printWriter.print(punkt.getKatNr() + CELL);
            } else {
                printWriter.print(IFormat.i05.format(punkt.getKatNr()).toString() + CELL);
            }
        } else {
            printWriter.print(punkt.getKatNr() + CELL);
        }
        printWriter.print(SPACE + d33.format(punkt.y - (double)((int)punkt.y / 1000 * 1000)).toString() + CELL);
        printWriter.print(SPACE + d33.format(punkt.x - (double)((int)punkt.x / 1000 * 1000)).toString() + CELL);
        printWriter.print(SPACE);
        boolean bl = true;
        switch (punkt.getInternalPs()) {
            case 0: {
                bl = punkt.getPs() != 1 && punkt.getPs() != 2;
                break;
            }
            case 1: {
                boolean bl2 = KatasternachweisIOProperties.writeSapLsp() ? true : (bl = punkt.getPs() != 1 && punkt.getPs() != 2);
            }
        }
        if (bl) {
            printWriter.print(d13.format(punkt.getRissSP()).toString());
        }
        printWriter.print("\\cell \\cell ");
        if (punktParameter.getLz() > 0) {
            printWriter.print(punktParameter.getOutLz());
        }
        printWriter.println("\\cell}\\pard\\widctlpar\\intbl\\adjustright{");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("\\cell}");
        printWriter.println("{\\row }");
    }

    private void writeTrafoPunktAsIdentLine(PrintWriter printWriter, TrafoPunkt trafoPunkt, String string, String string2) {
        if (KatasternachweisIOProperties.writeIdentTitel() && this.block != 4) {
            this.writeBlockTableHeader(printWriter, 4);
        }
        this.block = 4;
        printWriter.println("{\\trwd}");
        printWriter.print("\\pard \\qc\\widctlpar\\intbl\\adjustright {\\fs20 ");
        if (trafoPunkt.getPunkt().getKafPa() != -1) {
            printWriter.print(trafoPunkt.getPunkt().getParameter().getOutPa() + SPACE);
            if (trafoPunkt.getPunkt().getKatNr() > 99999L) {
                printWriter.print(trafoPunkt.getPunkt().getKatNr() + CELL);
            } else {
                printWriter.print(IFormat.i05.format(trafoPunkt.getPunkt().getKatNr()).toString() + CELL);
            }
        } else {
            printWriter.print(trafoPunkt.getPunkt().getKatNr() + CELL);
        }
        printWriter.print(SPACE + d33.format(trafoPunkt.y - (double)((int)trafoPunkt.y / 1000 * 1000)).toString() + CELL);
        printWriter.print(SPACE + d33.format(trafoPunkt.x - (double)((int)trafoPunkt.x / 1000 * 1000)).toString() + CELL);
        printWriter.print(SPACE + d33.format(trafoPunkt.y - (double)((int)trafoPunkt.y / 1000 * 1000) + (double)trafoPunkt.getVy()).toString() + CELL);
        printWriter.print(SPACE + d33.format(trafoPunkt.x - (double)((int)trafoPunkt.x / 1000 * 1000) + (double)trafoPunkt.getVx()).toString() + CELL);
        printWriter.print(SPACE + d03.format(-trafoPunkt.getVy()).toString() + CELL);
        printWriter.print(SPACE + d03.format(-trafoPunkt.getVx()).toString() + CELL);
        printWriter.print(SPACE + d03.format(trafoPunkt.getVs()).toString() + CELL);
        printWriter.println(" }");
        printWriter.print("{\\fs16 ");
        printWriter.print(string != null ? string : SPACE);
        printWriter.print("\\cell }\\pard \\widctlpar\\intbl\\adjustright {\\fs16 ");
        if (string2 == null) {
            if (!trafoPunkt.isOn()) {
                string2 = KOO_FEHLER;
            } else if ((double)trafoPunkt.getVs() > IDENT_DK_ZUL) {
                string2 = KOO_FEHLER;
                this.addException(new SurveyException("Identit\u00e4tsliste\n     Transformationsfehler in Punkt " + trafoPunkt.getPunkt().getKatNr()));
            }
        }
        if (string2 == null && !trafoPunkt.getPunkt().isVermarkungVorgefunden()) {
            string2 = VermarkungsArt.toString(trafoPunkt.getPunkt().getVaVorgefunden());
        }
        if (string2 != null) {
            printWriter.print(string2);
        }
        printWriter.println("\\cell }\\pard \\widctlpar\\intbl\\adjustright {\\row }");
    }

    private void writePunktAsIdentPointLine(PrintWriter printWriter, Punkt punkt, Punkt punkt2, String string) {
        double d = punkt.y - punkt2.y;
        double d2 = punkt.x - punkt2.x;
        double d3 = Math.sqrt(d * d + d2 * d2);
        printWriter.println("{\\trwd}");
        printWriter.print("\\pard \\qc\\widctlpar\\intbl\\adjustright {\\fs20 ");
        if (punkt.getKafPa() != -1) {
            printWriter.print(punkt.getParameter().getOutPa() + SPACE);
            if (punkt.getKatNr() > 99999L) {
                printWriter.print(punkt.getKatNr() + CELL);
            } else {
                printWriter.print(IFormat.i05.format(punkt.getKatNr()).toString() + CELL);
            }
        } else {
            printWriter.print(punkt.getKatNr() + CELL);
        }
        printWriter.print(SPACE + d33.format(punkt.y - (double)((int)punkt.y / 1000 * 1000)).toString() + CELL);
        printWriter.print(SPACE + d33.format(punkt.x - (double)((int)punkt.x / 1000 * 1000)).toString() + CELL);
        printWriter.print(SPACE + d33.format(punkt2.y - (double)((int)punkt2.y / 1000 * 1000)).toString() + CELL);
        printWriter.print(SPACE + d33.format(punkt2.x - (double)((int)punkt2.x / 1000 * 1000)).toString() + CELL);
        printWriter.print(SPACE + d03.format(d).toString() + CELL);
        printWriter.print(SPACE + d03.format(d2).toString() + CELL);
        printWriter.println(SPACE + d03.format(d3).toString() + "\\cell }");
        printWriter.print("{\\fs16 ");
        String string2 = punkt.getRiss() != null ? punkt.getRiss() : DataBase.antrag;
        printWriter.print(string2 != null ? string2 : SPACE);
        printWriter.print("\\cell }\\pard \\widctlpar\\intbl\\adjustright {\\fs16 ");
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
        } else {
            if (!punkt.isVermarkungVorgefunden()) {
                string = VermarkungsArt.toString(punkt.getVaVorgefunden());
            }
            if (punkt.getPs() == 0) {
                stringBuffer.append(NEU_KOO);
            } else if (punkt.getPs() == 5) {
                if (!punkt.isErrHoldKoo()) {
                    stringBuffer.append(NEU_KOO);
                }
            } else if (punkt.getPs() == 2 && d3 > IDENT_DK_ZUL) {
                stringBuffer.append(KOO_FEHLER);
                this.addException(new SurveyException("Identit\u00e4tsliste\n     Koordinatenfehler in Punkt " + punkt.getKatNr()));
            }
        }
        if (punkt.hasBemerkung() && punkt.hasTag("npi.bem")) {
            Tag tag = Tag.parseTag(punkt.getBemerkung(), "npi.bem");
            switch (tag.getControl()) {
                case '#': {
                    stringBuffer.insert(0, tag.getValue() + SPACE);
                    break;
                }
                case '!': {
                    stringBuffer = new StringBuffer(tag.getValue());
                    break;
                }
                default: {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(SPACE);
                    }
                    stringBuffer.append(tag.getValue());
                }
            }
        }
        if (stringBuffer.length() > 0) {
            printWriter.print(stringBuffer.toString());
        }
        printWriter.println("\\cell }\\pard \\widctlpar\\intbl\\adjustright {\\row }");
    }

    private void writePunktAsIdentPointLine(PrintWriter printWriter, Punkt punkt, String string) {
        if (string != null && !punkt.isVermarkungVorgefunden()) {
            string = VermarkungsArt.toString(punkt.getVaVorgefunden());
        }
        printWriter.println("{\\trwd}");
        printWriter.print("\\pard \\qc\\widctlpar\\intbl\\adjustright {\\fs20 ");
        if (punkt.getKafPa() != -1) {
            printWriter.print(punkt.getParameter().getOutPa() + SPACE);
            printWriter.print(GeoNumberFormat.nr05n.format(punkt.getKatNr()).toString() + CELL);
        } else {
            printWriter.print(punkt.getKatNr() + CELL);
        }
        printWriter.print(SPACE + d33.format(punkt.y - (double)((int)punkt.y / 1000 * 1000)).toString() + CELL);
        printWriter.print(SPACE + d33.format(punkt.x - (double)((int)punkt.x / 1000 * 1000)).toString() + CELL);
        printWriter.print(" \\cell \\cell \\cell \\cell \\cell }");
        printWriter.print("{\\fs16 ");
        String string2 = punkt.getRiss() != null ? punkt.getRiss() : DataBase.antrag;
        printWriter.print(string2 != null ? string2 : SPACE);
        printWriter.print("\\cell }\\pard \\widctlpar\\intbl\\adjustright {\\fs16 ");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("\\cell }\\pard \\widctlpar\\intbl\\adjustright {\\row }");
    }

    private void writeLinieAsShortRissLengthLine(PrintWriter printWriter, Linie linie) {
        if (!linie.pa.isKatasterPunkt()) {
            this.addException(new IException("Rissliste:", "Linienpunkt " + linie.pa.getNr() + " ist kein Katasterpunkt"));
        }
        if (!linie.pe.isKatasterPunkt()) {
            this.addException(new IException("Rissliste:", "Linienpunkt " + linie.pe.getNr() + " ist kein Katasterpunkt"));
        }
        printWriter.print("{\\trwd}\\pard \\qc\\widctlpar\\intbl\\adjustright {");
        if (linie.pa.isKatasterPunkt()) {
            printWriter.print(linie.pa.getParameter().getOutPa() + SPACE);
            printWriter.print(GeoNumberFormat.nr05n.format(linie.pa.getKatNr()).toString() + CELL);
        } else {
            printWriter.print(linie.pa.getKatNr() + CELL);
        }
        if (linie.pe.isKatasterPunkt()) {
            printWriter.print(SPACE);
            printWriter.print(linie.pe.getParameter().getOutPa() + SPACE);
            printWriter.print(GeoNumberFormat.nr05n.format(linie.pe.getKatNr()).toString() + CELL);
        } else {
            printWriter.print(linie.pe.getKatNr() + CELL);
        }
        printWriter.print(SPACE + d03.format(DataBase.getStrecke(linie.pa, linie.pe)).toString());
        printWriter.print("\\cell \\cell \\cell \\cell } \\pard \\widctlpar\\intbl\\adjustright {");
        if (linie.isBogen()) {
            printWriter.print("R = " + d03.format(Math.abs(linie.l2)) + "    B = " + d03.format(linie.getBogenLaenge() * DataBase.getStreckeMasstab(linie.pa.y)));
        }
        printWriter.println(" \\cell }{\\row }");
    }

    private void writeLinieAsRissLengthLine(PrintWriter printWriter, Linie linie) {
        printWriter.print("{\\trwd}\\pard \\qc\\widctlpar\\intbl\\adjustright {\\cell");
        printWriter.print(SPACE + d03.format(DataBase.getStrecke(linie.pa, linie.pe)).toString());
        printWriter.print("\\cell \\cell \\cell \\cell \\cell } \\pard \\widctlpar\\intbl\\adjustright {");
        if (linie.isBogen()) {
            printWriter.print("R = " + d03.format(Math.abs(linie.l2)) + "    B = " + d03.format(linie.getBogenLaenge() * DataBase.getStreckeMasstab(linie.pa.y)));
        }
        printWriter.println(" \\cell }{\\row }");
    }

    private void writePunktAsRissLengthLine(PrintWriter printWriter, Punkt punkt) {
        if (!punkt.isKatasterPunkt()) {
            this.addException(new IException("Rissliste:", "Linienpunkt " + punkt.getNr() + " ist kein Katasterpunkt"));
        }
        printWriter.print("{\\trwd}\\pard \\qc\\widctlpar\\intbl\\adjustright {");
        if (punkt.isKatasterPunkt()) {
            printWriter.print(punkt.getParameter().getOutPa() + SPACE);
            printWriter.print(GeoNumberFormat.nr05n.format(punkt.getKatNr()).toString());
        } else {
            printWriter.print(punkt.getKatNr());
        }
        printWriter.println("\\cell \\cell \\cell \\cell \\cell \\cell \\cell }{\\row }");
    }

    private void writeVoidAsRissLengthLine(PrintWriter printWriter) {
        printWriter.println("{\\trwd}\\pard \\qc\\widctlpar\\intbl\\adjustright {\\cell\\cell \\cell \\cell \\cell \\cell \\cell }{\\row }");
    }

    private void writeVoidLineAsIdentLine(PrintWriter printWriter) {
        printWriter.println("{\\trwd}\\pard\\plain \\qc\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {\\cell \\cell \\cell \\cell \\cell \\cell \\cell \\cell}{\\fs16 \\cell}\\pard\\widctlpar\\intbl\\adjustright{\\fs16 \\cell}{\\row }");
    }

    private void writeStreckeAsIdentLine(PrintWriter printWriter, Messung messung, Messung messung2, String string, String string2, String string3, String string4) {
        if (KatasternachweisIOProperties.writeIdentTitel() && this.block != 3) {
            this.writeBlockTableHeader(printWriter, 3);
        }
        this.block = 3;
        printWriter.println("{\\trwd}");
        printWriter.print("\\pard\\plain \\qc\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {");
        if (messung.ps.getKafPa() != -1) {
            printWriter.print(messung.ps.getParameter().getOutPa() + SPACE);
            printWriter.print(GeoNumberFormat.nr05n.format(messung.ps.getKatNr()).toString());
        } else {
            printWriter.print(messung.ps.getKatNr());
        }
        printWriter.print("\\cell \\cell \\cell \\cell \\cell \\cell \\cell \\cell}{\\fs16 \\cell }\\pard \\widctlpar\\intbl\\adjustright {\\fs16 ");
        if (string2 != null) {
            printWriter.print(string2);
        }
        printWriter.println("\\cell}");
        printWriter.println("{\\row }{\\trwd}");
        printWriter.print("\\pard\\plain \\qc\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {\\cell " + d02.format(messung.l1).toString() + "\\cell\\cell " + d02.format(messung2.l1).toString() + "\\cell\\cell " + d02.format(messung.l1 - messung2.l1).toString() + "\\cell\\cell " + d02.format(Math.abs(messung.l1 - messung2.l1)).toString() + "\\cell}{\\fs16 " + string + "\\cell}\\pard\\widctlpar\\intbl\\adjustright{\\fs16 ");
        if (string4 != null) {
            printWriter.print(string4);
        }
        printWriter.println("\\cell}");
        printWriter.println("{\\row }{\\trwd}");
        printWriter.print("\\pard\\plain \\qc\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {");
        if (messung.pz.getKafPa() != -1) {
            printWriter.print(messung.pz.getParameter().getOutPa() + SPACE);
            printWriter.print(GeoNumberFormat.nr05n.format(messung.pz.getKatNr()).toString());
        } else {
            printWriter.print(messung.pz.getKatNr());
        }
        printWriter.print("\\cell \\cell \\cell \\cell \\cell \\cell \\cell \\cell}{\\fs16 \\cell }\\pard \\widctlpar\\intbl\\adjustright {\\fs16 ");
        if (string3 != null) {
            printWriter.print(string3);
        }
        printWriter.println("\\cell}");
        printWriter.println("{\\row }");
    }

    private void writeOrthoAsIdentLine(PrintWriter printWriter, Messung messung, Messung messung2, String string, String string2) {
        if (KatasternachweisIOProperties.writeIdentTitel() && this.block != 2) {
            this.writeBlockTableHeader(printWriter, 2);
        }
        this.block = 2;
        boolean bl = messung.getWerteBelegung() == 0;
        double d = messung.l1 - messung2.l1;
        double d2 = messung.l2 - messung2.l2;
        double d3 = Math.sqrt(d2 * d2 + d * d);
        if (bl) {
            d3 = Math.abs(d2);
        }
        printWriter.println("{\\trwd}");
        printWriter.print("\\pard\\plain \\qc\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {");
        if (messung2.ps.getKafPa() != -1) {
            printWriter.print(messung2.ps.getParameter().getOutPa() + SPACE);
            printWriter.print(GeoNumberFormat.nr05n.format(messung2.ps.getKatNr()).toString());
        } else {
            printWriter.print(messung2.ps.getKatNr());
        }
        printWriter.print("\\cell " + d02.format(messung.l2).toString() + "\\cell ");
        if (!bl) {
            printWriter.print(d02.format(messung.l1).toString());
        }
        printWriter.print("\\cell " + d02.format(messung2.l2).toString() + "\\cell " + d02.format(messung2.l1).toString() + "\\cell " + d02.format(d2).toString() + "\\cell ");
        if (!bl) {
            printWriter.print(d02.format(d).toString());
        }
        printWriter.print("\\cell " + d02.format(d3).toString() + "\\cell}{\\fs16 " + string + "\\cell}\\pard\\widctlpar\\intbl\\adjustright{\\fs16 ");
        if (string2 != null) {
            printWriter.print(string2);
        }
        printWriter.println("\\cell}");
        printWriter.println("{\\row }");
    }

    private class LineComparator
    implements Comparator {
        private LineComparator(KatasternachweisBrbWriter katasternachweisBrbWriter) {
        }

        @Override
        public int compare(Object object, Object object2) {
            Linie linie = (Linie)object;
            Linie linie2 = (Linie)object2;
            long l = Math.min(linie.pa.getNr(), linie.pe.getNr());
            long l2 = Math.max(linie.pa.getNr(), linie.pe.getNr());
            long l3 = Math.min(linie2.pa.getNr(), linie2.pe.getNr());
            long l4 = Math.max(linie2.pa.getNr(), linie2.pe.getNr());
            if (l < l3) {
                return -1;
            }
            if (l > l3) {
                return 1;
            }
            if (l2 < l4) {
                return -1;
            }
            if (l2 > l4) {
                return 1;
            }
            return 0;
        }
    }
}

