/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.geom.DPoint;
import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.KatasterParameter;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.OrthoLinie;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktIdentitaet;
import de.geocalc.kafplot.PunktNummer;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.PunktSorter;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.SurveyException;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.ValueDataContainer;
import de.geocalc.kafplot.VermarkungsArt;
import de.geocalc.kafplot.io.KatasternachweisIOProperties;
import de.geocalc.kafplot.io.KatasternachweisWriter;
import de.geocalc.text.DecimalFormat;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;
import de.geocalc.util.Sortable;
import de.geocalc.util.SortedList;
import java.io.File;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class KatasternachweisNrwWriter
extends KatasternachweisWriter {
    private File rissFile;
    private File identFile;
    private DataBase db;
    private String gemarkung;
    private static final double LAGEABWEICHUNG_AP = 0.06;
    private static final double LAGEABWEICHUNG_NEU = 0.06;
    private static final double LAGEABWEICHUNG_OP_NV = 0.08;
    private static final double LAGEABWEICHUNG_OP_AV = 0.12;
    private static final double LAGEABWEICHUNG_SPANNMASS = 0.04;
    private static final String EOL = "\n";
    private static final String RTF_HEADER = "{\\rtf1\\ansi\\deff0\\adeflang1025\n{\\fonttbl{\\f0\\froman\\fprq2\\fcharset0 Times New Roman{\\*\\falt Thorndale};}{\\f1\\froman\\fprq2\\fcharset0 Times New Roman{\\*\\falt Thorndale};}{\\froman\\fprq2\\fcharset0 Times New Roman;}{\\f3\\fswiss\\fprq2\\fcharset0 Arial{\\*\\falt Albany};}{\\f4\\fswiss\\fprq2\\fcharset0 Arial;}{\\f5\\froman\\fprq2\\fcharset2 Symbol;}{\\f6\\froman\\fprq0\\fcharset0 TimesNewRomanPS-BoldMT;}{\\f7\\fnil\\fprq2\\fcharset0 HG Mincho Light J;}{\\f8\\fnil\\fprq2\\fcharset0 Arial Unicode MS;}}\n{\\colortbl;\\red0\\green0\\blue0;\\red128\\green128\\blue128;}\n{\\stylesheet{\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20\\snext1 Standard;}\n{\\s2\\sb240\\sa120\\keepn\\cf0\\rtlch\\afs28\\ltrch\\dbch\\af7\\afs28\\f3\\fs28\\sbasedon1\\snext3 \\'dcberschrift;}\n{\\s3\\sa120\\cf0\\rtlch\\ltrch\\dbch\\fs20\\sbasedon1\\snext3 Textk\\'f6rper;}\n{\\s4\\ls0\\ilvl0\\outlinelevel0\\li717\\ri0\\fi-360\\sb120\\keepn\\cf0\\rtlch\\ltrch\\dbch\\ab\\f4\\b\\sbasedon1\\snext1{\\*\\soutlvl0} \\'dcberschrift 1;}\n{\\s5\\cf0\\tqc\\tx4536\\tqr\\tx9072\\rtlch\\ltrch\\dbch\\fs20\\sbasedon1\\snext5 Fu\\'dfzeile;}\n{\\s6\\cf0\\tqc\\tx4536\\tqr\\tx9072\\rtlch\\ltrch\\dbch\\fs20\\sbasedon1\\snext6 Kopfzeile;}\n{\\s7\\sb120\\sa120\\cf0\\rtlch\\ai\\ltrch\\dbch\\ai\\fs20\\i\\sbasedon1\\snext7 Beschriftung;}\n{\\s8\\sb60\\sa60\\cf0\\rtlch\\ltrch\\dbch\\afs22\\fs22\\sbasedon1\\snext8 Tabelle;}\n{\\s9\\cf0\\rtlch\\ltrch\\dbch\\fs20\\sbasedon1\\snext9 Fu\\'dfnote;}\n{\\s10\\cf0\\rtlch\\ltrch\\dbch\\fs20\\sbasedon1\\snext10 Endnote;}\n{\\s11\\sa120\\cf0\\rtlch\\ltrch\\dbch\\fs20\\sbasedon3\\snext11 Tabellen Inhalt;}\n{\\s12\\sa120\\cf0\\qc\\rtlch\\ai\\ab\\ltrch\\dbch\\ai\\ab\\fs20\\i\\b\\sbasedon11\\snext12 Tabellen \\'dcberschrift;}\n{\\*\\cs14\\rtlch\\ltrch\\dbch\\af7\\langfe255\\f0\\fs24 WW-Absatz-Standardschriftart;}\n{\\*\\cs15\\rtlch\\ltrch\\dbch\\af7\\langfe255\\f0\\fs24\\sbasedon14 Seitenzahl;}\n{\\*\\cs16\\up5\\rtlch\\ltrch\\dbch\\af7\\langfe255\\f0\\fs10\\sbasedon14 Fu\\'dfnotenzeichen;}\n{\\*\\cs17\\up5\\rtlch\\ltrch\\dbch\\af7\\langfe255\\f0\\fs10\\sbasedon14 Endnotenzeichen;}\n{\\*\\cs18\\rtlch\\ltrch\\dbch\\af7\\langfe255\\f5\\fs24 WW8Num1z0;}\n{\\*\\cs19\\up10\\rtlch\\ltrch\\dbch\\af7\\langfe255\\f0\\fs24 Fu\\'dfnotenanker;}\n}{\\*\\listtable{\\list\\listtemplateid1\n{\\listlevel\\levelnfc0\\leveljc0\\levelstartat1\\levelfollow2{\\leveltext \\'02\\'00.;}{\\levelnumbers\\'01;}\\fi-360\\li360}\\listid1}\n}{\\listoverridetable{\\listoverride\\listid1\\listoverridecount0\\ls0}}";
    private static final String DOK_TITLE = "{\\info{\\title VP-Liste}{\\author GeoCalc-KafPlot}{\\creatim\\yr2003\\mo1\\dy25\\hr22\\min4}{\\operator GeoCalc-KafPlot}{\\revtim\\yr2003\\mo1\\dy25\\hr22\\min13}{\\printim\\yr1601\\mo1\\dy1\\hr0\\min0}{\\comment GeoCalc-KafPlot}{\\vern6410}}\\deftab709";
    private static final String TABLE_HEADER = "{\\*\\pgdsctbl\n{\\pgdsc0\\pgdscuse195\\pgwsxn11905\\pghsxn16837\\marglsxn1418\\margrsxn567\\margtsxn1418\\margbsxn1134\\pgdscnxt0 Standard;}}\n\\paperh16837\\paperw11905\\margl1418\\margr567\\margt1418\\margb1134\\sectd\\sbknone\\pgwsxn11905\\pghsxn16837\\marglsxn1418\\margrsxn567\\margtsxn1418\\margbsxn1134\\ftnbj\\ftnstart1\\ftnrstcont\\ftnnar\\aenddoc\\aftnrstcont\\aftnstart1\\aftnnrlc\n\\trowd\\trqr\\clvertalt\\cellx4572\\clvertalt\\cellx9920\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20 {\\ltrch Vermessungsstelle}\n\\cell\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20 {\\ltrch Datum}\n\\cell\\row\\pard \\trowd\\trqr\\clvertalt\\cellx4572\\clvertalt\\cellx9920\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20 {\\ltrch Katasteramt}\n\\cell\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20 {\\ltrch Gemarkung, Flur}\n\\cell\\row\\pard \\trowd\\trqr\\clvertalt\\cellx4572\\clvertalt\\cellx9920\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20 {\\ltrch Lagestatus (2. u 3. Stelle)}\n\\cell\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20 {\\ltrch Ordungssystem der Vermessungsrisse}\n\\cell\\row\\pard \\pard\\plain \\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20\\sb360\\sa120\\qc\\ltrch\\dbch\\afs32\\ab\\f6\\fs32\\b {\\ltrch\\f6 V P \\endash  Liste}\n\\par \\pard\\plain \\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20\\sa360\\qc\\tldot\\tx3402\\tldot\\tx5102 {\\ltrch zum Fortf\\'fchrungsriss vom \\tab Blatt\\tab }\n\\par \\trowd\\trqr\\trhdr\\trkeep\\trrh-400\\clvmgf\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clvertalb\\cellx1054\\clvmgf\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clvertalb\\cellx1616\\clvmgf\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clvertalb\\cellx2459\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clvertalc\\cellx5552\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clvertalc\\cellx7379\\clvmgf\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clvertalb\\cellx8223\\clvmgf\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clvertalb\\cellx9066\\clvmgf\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clvertalb\\cellx9910\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20\\qc\\ltrch\\dbch\\afs16\\fs16 {\\ltrch NBZ}\n\\cell\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20\\qc\\ltrch\\dbch\\afs16\\fs16 {\\ltrch PAT}\n\\cell\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20\\qc\\ltrch\\dbch\\afs16\\fs16 {\\ltrch PNR}\n\\cell\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20\\qc\\ltrch\\dbch\\afs16\\fs16 {\\ltrch Festgesetzte/SOLL-/endg\\'fcltige\\line Koordinaten}\n\\cell\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20\\qc\\ltrch\\dbch\\afs16\\fs16 {\\ltrch IST-Koordinaten}\n\\cell\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20\\qc{\\ltrch{\\fs16 Kennung\\line K{*{\\*\\footnote *\\pard\\plain {\\b\\fs16 Erl\\'e4uterungen:}\n\\par {\\ltrch{\\fs16 D{\\dn7 k}\\tab \\tab Gr\\'f6\\'dfte zul\\'e4ssige Lageabweichung bei Koordinatenvergleichen innerhalb derselben Vermessung}}\n\\par {\\ltrch{\\fs16 D{\\dn7 Sp}\\tab \\tab Gr\\'f6\\'dfte zul\\'e4ssige Lageabweichung bei Spannma\\'dfkontrollen innerhalb derselben Vermessung}}\n\\par \\pard\\plain \\s9\\cf0\\rtlch\\ltrch\\dbch\\fs20\\ltrch\\dbch\\afs16\\fs16 {\\ltrch d\\tab \\tab Gr\\'f6\\'dfte zul\\'e4ssige Lageabweichung gegen\\'fcber fr\\'fcheren Vermessungen}\n\\par {\\ltrch K\\tab \\tab Kontrollwert}\n\\par {\\ltrch M\\tab \\tab Wert, der zur Mittelbildung verwendet wird}}}}\n{\\*\\cs16\\up5\\rtlch\\ltrch\\dbch\\af7\\langfe255\\f0\\fs24\\fs16\\fs10 }{\\fs16 \\line M}{\\*\\cs16\\up5\\fs10 *}}\n\\cell\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20\\qc\\ltrch\\dbch\\afs16\\fs16 {\\ltrch Lineare\\line Abwei-\\line chung/\\line Differenz}\n\\cell\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20\\qc{\\ltrch{\\fs16 Grenz-\\line wert\\line D{\\dn2\\fs10 k}, D{\\dn2\\fs10 Sp}{\\up5\\fs10 *\\line }d}{\\*\\cs16\\up5\\fs10 *}}\n\\cell\\row\\pard \\trowd\\trqr\\trhdr\\trkeep\\trrh-369\\clvmrg\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clvertalb\\cellx1054\\clvmrg\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clvertalb\\cellx1616\\clvmrg\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clvertalb\\cellx2459\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clvertalb\\cellx4005\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clvertalb\\cellx5552\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clvertalb\\cellx6395\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clvertalb\\cellx7379\\clvmrg\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clvertalb\\cellx8223\\clvmrg\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clvertalb\\cellx9066\\clvmrg\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\brsp0\\clvertalb\\cellx9910\n\\pard\\intbl\\cell\\cell\\cell\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20\\qc\\ltrch\\dbch\\afs16\\fs16 {\\ltrch R}\n\\cell\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20\\qc\\ltrch\\dbch\\afs16\\fs16 {\\ltrch H}\n\\cell\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20\\qc\\ltrch\\dbch\\afs16\\fs16 {\\ltrch R}\n\\cell\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20\\qc\\ltrch\\dbch\\afs16\\fs16 {\\ltrch Spannma\\'df,\\line H}\n\\cell\\cell\\cell\\cell\\row\\pard \\trowd\\trqr\\trhdr\\clvertalt\\cellx9910\n\\pard\\intbl\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20\\ltrch\\dbch\\ab\\b";
    private static final String CELL_DEF = "\\cell\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20\\qc";
    private static final String TABLE_END = "\\cell\\row\\pard \\pard\\plain \\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20\\qc\\par }";
    private static final String IDENT_HEADER = "{\\header \\pard\\plain \\widctlpar\\adjustright\\fs20\\lang1031\\cgrid {\\b\\fs28 Nachweis der Punktidentit\\'e4t (}\n{\\field{\\*\\fldinst {\\cs17\\b\\fs28  PAGE }}{\\fldrslt {\\cs17\\b\\fs28\\lang1024 1}}}{\\cs17\\b\\fs28 /}{\\field{\\*\\fldinst {\\cs17\\b\\fs28  NUMPAGES }}{\\fldrslt {\\cs17\\b\\fs28\\lang1024 1}}}{\\b\\fs28 )\\par }";
    private static final String IDENT_TABLE = "\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrr\n\\brdrs\\brdrw10 \\cltxlrtb \\cellx851\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx2897\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx4943\\clvertalt\\clbrdrt\n\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6361\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx7070\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\n\\brdrs\\brdrw10 \\cltxlrtb \\cellx8080\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923\n{\\trwd}\n\\pard \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright {\\b\\fs16 PAT/\\line PNR\\cell amtliche Koordinaten\\line (Soll)\\cell Vermessungsergebnis\\line (Ist)\\cell Soll-Ist\\cell Abwei-\\line chung\\cell Riss/\\line Jahr\\cell Bemerkung\\cell }\n{\\row }\n\\trowd \\trgaph70\\trleft-70\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\n\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx851\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx1874\\clvertalt\n\\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx2897\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx3920\\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\n\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx4943\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx5652\\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10\n\\cltxlrtb \\cellx6361\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx7070\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx8080\\clvertalt\\clbrdrl\\brdrs\\brdrw10\n\\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923\n{\\trwd}\n\\pard \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright {\\b\\fs16 \\cell }\n\\pard\\plain \\s2\\qc\\sb60\\sa60\\keepn\\widctlpar\\intbl\\outlinelevel1\\adjustright \\b\\fs16\\lang1031\\cgrid {Y\\cell }\n\\pard\\plain \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {\\b\\fs16 X\\cell y\\cell }\n\\pard\\plain \\s2\\qc\\sb60\\sa60\\keepn\\widctlpar\\intbl\\outlinelevel1\\adjustright \\b\\fs16\\lang1031\\cgrid {x\\cell }\n\\pard\\plain \\qc\\sb60\\sa60\\widctlpar\\intbl\\adjustright\\fs20\\lang1031\\cgrid {\\b\\fs16 dy\\cell dx\\cell d}{\\b\\fs16\\sub k}{\\b\\fs16 /d}{\\b\\fs16\\sub s}{\\b\\fs16 \\cell \\cell \\cell }\n{\\row }\n\\trowd \\trgaph70\\trleft-70\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10\n\\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx851\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10\n\\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx1874\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx2897\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10\n\\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx3920\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx4943\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10\n\\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx5652\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx6361\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10\n\\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx7070\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx8080\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\n\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923\n{\\trwd}\n\\pard \\qc\\sb20\\sa20\\widctlpar\\intbl\\adjustright {\\fs12 1\\cell 2\\cell 3\\cell 4\\cell 5\\cell 6\\cell 7\\cell 8\\cell 9\\cell 10\\cell }\n\\pard \\widctlpar\\intbl\\adjustright\n{\\row }\n\\pard\\plain \\s15\\widctlpar\\tqc\\tx4536\\tqr\\tx9072\\adjustright \\fs20\\lang1031\\cgrid {\\par}}{\\footer\n\\pard\\plain \\s16\\widctlpar\\tqc\\tx4536\\tqr\\tx9072\\adjustright \\fs20\\lang1031\\cgrid {\\par }}\n{\\*\\pnseclvl1\\pnucrm\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}{\\*\\pnseclvl2\\pnucltr\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}{\\*\\pnseclvl3\\pndec\\pnstart1\\pnindent720\\pnhang{\\pntxta .}}{\\*\\pnseclvl4\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxta )}}\n{\\*\\pnseclvl5\\pndec\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}{\\*\\pnseclvl6\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}{\\*\\pnseclvl7\\pnlcrm\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}\n{\\*\\pnseclvl8\\pnlcltr\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}}{\\*\\pnseclvl9\\pnlcrm\\pnstart1\\pnindent720\\pnhang{\\pntxtb (}{\\pntxta )}";
    private static final String IDENT_TABLE_HEADER = "\\trowd \\trgaph70\\trleft-70\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10\\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalc\\clbrdrl\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx851\\clvertalc\\cltxlrtb\n\\cellx1874\\clvertalc\\cltxlrtb \\cellx2897\\clvertalc\\cltxlrtb \\cellx3920\\clvertalc\\cltxlrtb \\cellx4943\\clvertalc\\cltxlrtb \\cellx5652\n\\clvertalc\\cltxlrtb \\cellx6361\\clvertalc\\cltxlrtb \\cellx7070\\clvertalc\\cltxlrtb \\cellx8080\\clvertalc\\cltxlrtb \\cellx9923";
    private static final String CELL = "\\cell";
    private static final String END_OF_HEADER = "{\\par}}";
    private static final String END_OF_FILE = "}";
    private static final String SPACE = " ";
    private static final String KOO_FEHLER = "Koordinaten-Fehler";
    private static final String NEU_KOO = "neue Koo eingef\u00fchrt";

    public KatasternachweisNrwWriter(File file, File file2, DataBase dataBase) {
        super(file, dataBase);
        this.rissFile = file;
        this.identFile = file2;
        this.P = DataBase.P;
        this.P_IDENT = DataBase.P_IDENT;
    }

    @Override
    public void write() throws IFileOutputException {
        DecimalFormat decimalFormat = KatasternachweisIOProperties.formatMM() ? IFormat.f7_3 : IFormat.f7_2;
        DecimalFormat decimalFormat2 = KatasternachweisIOProperties.formatMM() ? IFormat.f03_3 : IFormat.f03_2;
        DecimalFormat decimalFormat3 = KatasternachweisIOProperties.formatMM() ? IFormat.f_3 : IFormat.f_2;
        PrintWriter printWriter = null;
        try {
            Cloneable cloneable;
            Object object;
            Cloneable cloneable2;
            PunktIdentitaet punktIdentitaet;
            Object object2;
            Object object3;
            Punkt punkt;
            Enumeration enumeration;
            Object object4;
            double d;
            double d2;
            double d3;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Messung messung;
            Object object9;
            super.setLabelText("Sortiere...");
            super.showProgress();
            PunktSorter punktSorter = new PunktSorter(DataBase.P, 23);
            punktSorter.setProgressBar(super.getProgressBar());
            Vector vector = punktSorter.getSortedVector();
            printWriter = this.createWriter(this.rissFile);
            Vector vector2 = new Vector();
            SortedList sortedList = new SortedList();
            Enumeration enumeration2 = DataBase.MP.elements();
            while (enumeration2.hasMoreElements()) {
                object9 = (Riss)enumeration2.nextElement();
                int n = 0;
                for (int i = 0; i < ((DataContainer)object9).size(); ++i) {
                    messung = (Messung)((DataContainer)object9).elementAt(i);
                    if (messung.ps == null || i <= 0) continue;
                    int n2 = n;
                    n = i;
                    this.fillData(vector2, sortedList, (DataContainer)object9, n2, n);
                }
                this.fillData(vector2, sortedList, (DataContainer)object9, n, ((DataContainer)object9).size());
            }
            int n = 0;
            super.setEndValue(vector.size() + vector2.size() + sortedList.size() + DataBase.MM.size());
            super.setProgressBreak();
            super.setValue(0L);
            super.setLabelText("Koordinatenliste erstellen...");
            printWriter.println(RTF_HEADER);
            printWriter.println(DOK_TITLE);
            printWriter.println(TABLE_HEADER);
            this.writeLongLine(printWriter, "Standpunkte", null);
            object9 = vector.elements();
            while (object9.hasMoreElements()) {
                Punkt punkt2 = (Punkt)object9.nextElement();
                if (!punkt2.isOn()) continue;
                if (punkt2.isStandPunkt() && punkt2.getKafPa() != 8 && punkt2.getKafPa() != 7 && punkt2.getPs() != 1) {
                    Object var12_19 = null;
                    messung = null;
                    Object object10 = object8 = KatasternachweisIOProperties.parsePointNumber() ? PunktNummer.createNbString(punkt2.nr) : Integer.toString(punkt2.getNb8());
                    String string = KatasternachweisIOProperties.parsePointNumber() ? PunktNummer.createPaString(punkt2.nr) : (object7 = punkt2.getPa() >= 0 ? Integer.toString(punkt2.getPa()) : null);
                    if (punkt2.getPs() == 2) {
                        this.writeCellLine(printWriter, (String)object8, (String)object7, IFormat.i5.format(punkt2.getNr()), decimalFormat.format(punkt2.y), decimalFormat.format(punkt2.x), decimalFormat2.format(punkt2.y + (double)punkt2.dy), decimalFormat2.format(punkt2.x + (double)punkt2.dx), "K", decimalFormat3.format(punkt2.getDS()), IFormat.f_2.format(this.getLageAbweichung(punkt2)));
                    } else {
                        if (punkt2.getPs() == 3) continue;
                        this.writeCellLine(printWriter, (String)object8, (String)object7, IFormat.i5.format(punkt2.getNr()), decimalFormat.format(punkt2.y), decimalFormat.format(punkt2.x), null, null, null, null, IFormat.f_2.format(this.getLageAbweichung(punkt2)));
                    }
                }
                if ((long)n++ % super.getProgressBreak() != 0L) continue;
                super.setProgress(n);
            }
            this.writeLongLine(printWriter, null, null);
            this.writeLongLine(printWriter, "Anschlusspunkte", null);
            double d4 = 0.0;
            boolean bl = false;
            boolean bl2 = false;
            object8 = vector2.elements();
            while (object8.hasMoreElements()) {
                object7 = object8.nextElement();
                if (object7 instanceof Double) {
                    d4 = (Double)object7;
                    bl = true;
                    bl2 = true;
                } else if (object7 instanceof Integer) {
                    this.writeLongLine(printWriter, null, null);
                    bl = false;
                } else if (bl) {
                    object6 = (Messung)object7;
                    Object object11 = object5 = ((Messung)object6).ps != null ? ((Messung)object6).ps : ((Messung)object6).getReferenz().ps;
                    if (bl2) {
                        this.writeCellLine(printWriter, KatasternachweisIOProperties.parsePointNumber() ? PunktNummer.createNbString(((Punkt)object5).nr) : Integer.toString(((Punkt)object5).getNb8()), KatasternachweisIOProperties.parsePointNumber() ? PunktNummer.createPaString(((Punkt)object5).nr) : (((Punkt)object5).getPa() >= 0 ? Integer.toString(((Punkt)object5).getPa()) : null), IFormat.i5.format(((Punkt)object5).getNr()), null, null, null, null, null, null, null);
                        bl2 = false;
                    }
                    double d5 = d4 + ((Messung)object6).l1 * Math.PI / 200.0;
                    d3 = ((Messung)object6).l2 / DataBase.getStreckeMasstab(DPoint.getMiddle((DPoint)object5, ((Messung)object6).pz));
                    d2 = ((Punkt)object5).x + Math.cos(d5) * d3;
                    d = ((Punkt)object5).y + Math.sin(d5) * d3;
                    this.writeCellLine(printWriter, KatasternachweisIOProperties.parsePointNumber() ? PunktNummer.createNbString(((Messung)object6).pz.nr) : Integer.toString(((Messung)object6).pz.getNb8()), KatasternachweisIOProperties.parsePointNumber() ? PunktNummer.createPaString(((Messung)object6).pz.nr) : (((Messung)object6).pz.getPa() >= 0 ? Integer.toString(((Messung)object6).pz.getPa()) : null), IFormat.i5.format(((Messung)object6).pz.getNr()), decimalFormat.format(((Messung)object6).pz.y), decimalFormat.format(((Messung)object6).pz.x), decimalFormat2.format(d), decimalFormat2.format(d2), null, decimalFormat3.format(((Messung)object6).pz.getDistance(new DPoint(d, d2))), IFormat.f_2.format(this.getLageAbweichung(((Messung)object6).pz)));
                }
                if ((long)n++ % super.getProgressBreak() != 0L) continue;
                super.setProgress(n);
            }
            this.writeLongLine(printWriter, null, null);
            this.writeLongLine(printWriter, "Objektpunkte", null);
            long l = -1L;
            object6 = sortedList.elements();
            while (object6.hasMoreElements()) {
                object5 = (ListEntry)object6.nextElement();
                d4 = ((ListEntry)object5).getOrientation();
                Messung messung2 = ((ListEntry)object5).getMessung();
                object4 = messung2.ps != null ? messung2.ps : messung2.getReferenz().ps;
                d3 = d4 + messung2.l1 * Math.PI / 200.0;
                d2 = messung2.l2 / DataBase.getStreckeMasstab(DPoint.getMiddle((DPoint)object4, messung2.pz));
                d = ((Punkt)object4).x + Math.cos(d3) * d2;
                double d6 = ((Punkt)object4).y + Math.sin(d3) * d2;
                enumeration = null;
                switch (messung2.pz.getInternalPs()) {
                    case 0: {
                        if (messung2.pz.getPs() == 1 || messung2.pz.getPs() == 2) {
                            enumeration = "K";
                            break;
                        }
                        if (!messung2.pz.isKontrolliert()) break;
                        enumeration = "M";
                        break;
                    }
                    case 1: {
                        enumeration = "K";
                        break;
                    }
                    case 2: {
                        if (!messung2.pz.isKontrolliert()) break;
                        enumeration = "M";
                    }
                }
                if (messung2.pz.nr > l) {
                    this.writeCellLine(printWriter, null, KatasternachweisIOProperties.parsePointNumber() ? PunktNummer.createPaString(messung2.pz.nr) : (messung2.pz.getPa() >= 0 ? Integer.toString(messung2.pz.getPa()) : null), IFormat.i5.format(messung2.pz.getNr()), decimalFormat.format(messung2.pz.y), decimalFormat.format(messung2.pz.x), decimalFormat2.format(d6), decimalFormat2.format(d), (String)((Object)enumeration), decimalFormat3.format(messung2.pz.getDistance(new DPoint(d6, d))), IFormat.f_2.format(this.getLageAbweichung(messung2.pz)));
                } else {
                    this.writeCellLine(printWriter, null, null, null, null, null, decimalFormat2.format(d6), decimalFormat2.format(d), (String)((Object)enumeration), decimalFormat3.format(messung2.pz.getDistance(new DPoint(d6, d))), IFormat.f_2.format(this.getLageAbweichung(messung2.pz)));
                }
                l = messung2.pz.nr;
                if ((long)n++ % super.getProgressBreak() != 0L) continue;
                super.setProgress(n);
            }
            this.writeLongLine(printWriter, null, null);
            this.writeLongLine(printWriter, "Spannma\u00dfkontrollen", null);
            object6 = null;
            object5 = DataBase.MM.elements();
            while (object5.hasMoreElements()) {
                Riss riss = (Riss)object5.nextElement();
                object4 = riss.elements();
                while (object4.hasMoreElements()) {
                    Messung messung3 = (Messung)object4.nextElement();
                    switch (messung3.getMessungsArt()) {
                        case 220: 
                        case 260: {
                            this.writeCellLine(printWriter, null, KatasternachweisIOProperties.parsePointNumber() ? PunktNummer.createPaString(messung3.ps.nr) : (messung3.ps.getPa() >= 0 ? Integer.toString(messung3.ps.getPa()) : null), IFormat.i5.format(messung3.ps.getNr()), decimalFormat.format(messung3.ps.y), decimalFormat.format(messung3.ps.x), null, decimalFormat3.format(messung3.l1), "K", decimalFormat3.format(Math.abs(messung3.l1 - messung3.ps.getDistance(messung3.pz))), IFormat.f_2.format(0.04));
                            this.writeCellLine(printWriter, null, KatasternachweisIOProperties.parsePointNumber() ? PunktNummer.createPaString(messung3.pz.nr) : (messung3.pz.getPa() >= 0 ? Integer.toString(messung3.pz.getPa()) : null), IFormat.i5.format(messung3.pz.getNr()), decimalFormat.format(messung3.pz.y), decimalFormat.format(messung3.pz.x), null, null, null, null, null);
                            this.writeLongLine(printWriter, null, null);
                            break;
                        }
                        case 200: 
                        case 240: 
                        case 290: {
                            punkt = ((Messung)object6).getFussPunkt();
                            Punkt punkt3 = messung3.getFussPunkt();
                            if (messung3.getWerteBelegung() >= 1 && punkt != null && punkt3 != null && ((Messung)object6).l1 != messung3.l1) {
                                this.writeCellLine(printWriter, null, KatasternachweisIOProperties.parsePointNumber() ? PunktNummer.createPaString(punkt.nr) : (punkt.getPa() >= 0 ? Integer.toString(punkt.getPa()) : null), IFormat.i5.format(punkt.getNr()), decimalFormat.format(punkt.y), decimalFormat.format(punkt.x), null, decimalFormat3.format(Math.abs(messung3.l1 - ((Messung)object6).l1)), "K", decimalFormat3.format(Math.abs(Math.abs(messung3.l1 - ((Messung)object6).l1) - punkt.getDistance(punkt3))), IFormat.f_2.format(0.04));
                                this.writeCellLine(printWriter, null, KatasternachweisIOProperties.parsePointNumber() ? PunktNummer.createPaString(punkt3.nr) : (punkt3.getPa() >= 0 ? Integer.toString(punkt3.getPa()) : null), IFormat.i5.format(punkt3.getNr()), decimalFormat.format(punkt3.y), decimalFormat.format(punkt3.x), null, null, null, null, null);
                                this.writeLongLine(printWriter, null, null);
                            }
                        }
                        case 210: {
                            if (messung3.pz == null || messung3.pz.nr == 0L) break;
                            this.writeCellLine(printWriter, null, KatasternachweisIOProperties.parsePointNumber() ? PunktNummer.createPaString(messung3.ps.nr) : (messung3.ps.getPa() >= 0 ? Integer.toString(messung3.ps.getPa()) : null), IFormat.i5.format(messung3.ps.getNr()), decimalFormat.format(messung3.ps.y), decimalFormat.format(messung3.ps.x), null, decimalFormat3.format(Math.abs(messung3.l2)), "K", decimalFormat3.format(Math.abs(Math.abs(messung3.l2) - messung3.ps.getDistance(messung3.pz))), IFormat.f_2.format(0.04));
                            this.writeCellLine(printWriter, null, KatasternachweisIOProperties.parsePointNumber() ? PunktNummer.createPaString(messung3.pz.nr) : (messung3.pz.getPa() >= 0 ? Integer.toString(messung3.pz.getPa()) : null), IFormat.i5.format(messung3.pz.getNr()), decimalFormat.format(messung3.pz.y), decimalFormat.format(messung3.pz.x), null, null, null, null, null);
                            this.writeLongLine(printWriter, null, null);
                        }
                    }
                    object6 = messung3;
                }
                if ((long)n++ % super.getProgressBreak() != 0L) continue;
                super.setProgress(n);
            }
            printWriter.println(TABLE_END);
            printWriter.close();
            n = 0;
            super.setEndValue(DataBase.MK.size());
            super.setProgressBreak();
            super.setValue(n);
            super.setLabelText("Punktidentit\u00e4tsliste erstellen...");
            KatasterParameter.USE_GEWICHTE = KatasternachweisIOProperties.useGewichte();
            this.outFile = this.identFile;
            object5 = this.createWriter(this.outFile);
            ((PrintWriter)object5).println(RTF_HEADER);
            ((PrintWriter)object5).println(IDENT_HEADER);
            this.writeKopfTable((PrintWriter)object5);
            ((PrintWriter)object5).println(IDENT_TABLE);
            ((PrintWriter)object5).println(END_OF_HEADER);
            ((PrintWriter)object5).println(IDENT_TABLE_HEADER);
            String string = null;
            int n3 = 0;
            int n4 = 0;
            punkt = null;
            Object var22_37 = null;
            OrthoLinie orthoLinie = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            enumeration = DataBase.MK.elements();
            while (enumeration.hasMoreElements()) {
                object3 = (Riss)enumeration.nextElement();
                string = ((ValueDataContainer)object3).getName();
                block35: for (int i = 0; i < ((DataContainer)object3).size(); ++i) {
                    object2 = (Messung)((DataContainer)object3).elementAt(i);
                    if (!((Messung)object2).isOn()) continue;
                    switch (((Messung)object2).getMessungsArt(true)) {
                        case 240: {
                            if (((Messung)object2).hasTag("NO") || ((Messung)object2).hasTag("NO2")) continue block35;
                            object2 = new Messung(220, ((Messung)object2).ps, ((Messung)object2).pz, ((Messung)object2).l2, 0.0);
                        }
                        case 220: 
                        case 260: {
                            if (((Messung)object2).hasTag("NO")) continue block35;
                            string3 = ((Messung)object2).ps.isVermarkungVorgefunden() ? null : VermarkungsArt.toString(((Messung)object2).ps.getVaVorgefunden());
                            string4 = ((Messung)object2).pz.isVermarkungVorgefunden() ? null : VermarkungsArt.toString(((Messung)object2).pz.getVaVorgefunden());
                            punktIdentitaet = (PunktIdentitaet)this.P_IDENT.get(new Long(((Messung)object2).ps.nr));
                            if (punktIdentitaet != null) {
                                if (!this.writeMessPunkt(punktIdentitaet.soll) || !this.writeMessPunkt(((Messung)object2).pz)) continue block35;
                                this.writeStreckeAsIdentLine((PrintWriter)object5, (Messung)object2, new Messung(((Messung)object2).ma, ((Messung)object2).ps, ((Messung)object2).pz, DataBase.getStrecke(punktIdentitaet.ist, ((Messung)object2).pz), 0.0), string, punktIdentitaet.bemIst, string4, ((Messung)object2).getText());
                                this.writeStreckeAsIdentLine((PrintWriter)object5, (Messung)object2, new Messung(((Messung)object2).ma, ((Messung)object2).ps, ((Messung)object2).pz, DataBase.getStrecke(((Messung)object2).ps, ((Messung)object2).pz), 0.0), string, punktIdentitaet.bemSoll, string4, ((Messung)object2).getText());
                            } else {
                                punktIdentitaet = (PunktIdentitaet)this.P_IDENT.get(new Long(((Messung)object2).pz.nr));
                                if (punktIdentitaet != null) {
                                    if (!this.writeMessPunkt(punktIdentitaet.soll) || !this.writeMessPunkt(((Messung)object2).ps)) continue block35;
                                    this.writeStreckeAsIdentLine((PrintWriter)object5, (Messung)object2, new Messung(((Messung)object2).ma, ((Messung)object2).ps, ((Messung)object2).pz, DataBase.getStrecke(((Messung)object2).ps, punktIdentitaet.ist), 0.0), string, string3, punktIdentitaet.bemIst, ((Messung)object2).getText());
                                    this.writeStreckeAsIdentLine((PrintWriter)object5, (Messung)object2, new Messung(((Messung)object2).ma, ((Messung)object2).ps, ((Messung)object2).pz, DataBase.getStrecke(((Messung)object2).ps, ((Messung)object2).pz), 0.0), string, string3, punktIdentitaet.bemSoll, ((Messung)object2).getText());
                                } else {
                                    if (!this.writeMessPunkt(((Messung)object2).ps) && !this.writeMessPunkt(((Messung)object2).pz)) continue block35;
                                    cloneable2 = new Messung(((Messung)object2).ma, ((Messung)object2).ps, ((Messung)object2).pz, DataBase.getStrecke(((Messung)object2).ps, ((Messung)object2).pz), 0.0);
                                    if (Math.abs(((Messung)cloneable2).l1 - ((Messung)object2).l1) > this.db.getKatasterStreckenGenauigkeit(((Messung)object2).l1, ((Messung)object2).getGewichte().getG1())) {
                                        if (((Messung)object2).isFehler()) {
                                            string2 = "fehlerhaftes Ma\u00df";
                                        } else {
                                            string2 = "unzul. Abweichung";
                                            this.addException(new SurveyException("Identit\u00e4tliste:\n     unzul\u00e4ssige Strecken-Abweichung zwischen den Punkten " + ((Messung)object2).ps.getNr() + " und " + ((Messung)object2).pz.getNr()));
                                        }
                                    } else {
                                        string2 = null;
                                    }
                                    this.writeStreckeAsIdentLine((PrintWriter)object5, (Messung)object2, (Messung)cloneable2, string, string3, string4, ((Messung)object2).hasText() ? ((Messung)object2).getText() : string2);
                                }
                            }
                            this.writeVoidLineAsIdentLine((PrintWriter)object5);
                            continue block35;
                        }
                        case 210: {
                            orthoLinie = new OrthoLinie();
                            orthoLinie.setAnfangsPunkt(((Messung)object2).pz != null && ((Messung)object2).pz.nr != 0L ? ((Messung)object2).pz : ((Messung)object2).ps);
                            orthoLinie.setAnfangsMasse(((Messung)object2).l1, ((Messung)object2).pz != null && ((Messung)object2).pz.nr != 0L ? 0.0 : ((Messung)object2).l2);
                            n3 = i;
                            continue block35;
                        }
                        case 290: {
                            orthoLinie.setEndPunkt(((Messung)object2).pz != null && ((Messung)object2).pz.nr != 0L ? ((Messung)object2).pz : ((Messung)object2).ps);
                            orthoLinie.setEndOrdinate(((Messung)object2).pz != null && ((Messung)object2).pz.nr != 0L ? 0.0 : ((Messung)object2).l2);
                            n4 = i;
                            boolean bl3 = false;
                            block36: for (int j = n3; j <= n4; ++j) {
                                object = (Messung)((DataContainer)object3).elementAt(j);
                                cloneable = null;
                                if (!((Messung)object).isOn() || ((Messung)object).hasTag("NO")) continue;
                                switch (((Messung)object).getMessungsArt(true)) {
                                    case 240: {
                                        if (((Messung)object).hasTag("NO1")) continue block36;
                                        string3 = ((Messung)object).ps.isVermarkungVorgefunden() ? null : VermarkungsArt.toString(((Messung)object).ps.getVaVorgefunden());
                                        punktIdentitaet = (PunktIdentitaet)this.P_IDENT.get(new Long(((Messung)object).ps.nr));
                                        if (punktIdentitaet != null) {
                                            if (!this.writeMessPunkt(punktIdentitaet.soll) || !this.writeMessPunkt(((Messung)object).pz)) continue block36;
                                            cloneable = orthoLinie.getMessungOf(punktIdentitaet.ist);
                                            this.writeOrthoAsIdentLine((PrintWriter)object5, new Messung(((Messung)object).ma, punktIdentitaet.soll, punktIdentitaet.soll, ((Messung)object).l1, 0.0), new Messung(((Messung)object).ma, punktIdentitaet.soll, punktIdentitaet.soll, ((Messung)cloneable).l1, ((Messung)cloneable).l2), string, punktIdentitaet.bemIst);
                                            bl3 = true;
                                        }
                                        if (!this.writeMessPunkt(((Messung)object).ps) || !this.writeMessPunkt(((Messung)object).pz)) continue block36;
                                        cloneable = orthoLinie.getMessungOf(((Messung)object).ps);
                                        if (Math.abs(((Messung)cloneable).l1 - ((Messung)object).l1) > this.db.getKatasterStreckenGenauigkeit(((Messung)object).l1 - orthoLinie.getAnfangsMass(), ((Messung)object).getGewichte().getG1()) || Math.abs(((Messung)cloneable).l2) > this.db.getKatasterStreckenGenauigkeit(0.0, ((Messung)object).getGewichte().getG2())) {
                                            if (((Messung)object).isFehler()) {
                                                string2 = ((Messung)object).hasText() ? ((Messung)object).getText() : "fehlerhaftes Ma\u00df";
                                            } else {
                                                string2 = ((Messung)object).hasText() ? ((Messung)object).getText() : "unzul. Abweichung";
                                                this.addException(new SurveyException("Identit\u00e4tliste:\n     unzul\u00e4ssige Linien-Abweichung in Punkt " + ((Messung)object).ps.getNr()));
                                            }
                                        } else {
                                            string2 = ((Messung)object).getText();
                                        }
                                        this.writeOrthoAsIdentLine((PrintWriter)object5, new Messung(((Messung)object).ma, ((Messung)object).ps, ((Messung)object).pz, ((Messung)object).l1, 0.0), new Messung(((Messung)object).ma, ((Messung)object).ps, ((Messung)object).ps, ((Messung)cloneable).l1, ((Messung)cloneable).l2), string, punktIdentitaet != null ? punktIdentitaet.bemSoll : string3);
                                        bl3 = true;
                                        continue block36;
                                    }
                                    case 200: 
                                    case 210: 
                                    case 290: {
                                        if (!((Messung)object).hasTag("NO2") && ((Messung)object).pz != null && ((Messung)object).pz.nr != 0L) {
                                            string4 = ((Messung)object).pz.isVermarkungVorgefunden() ? null : VermarkungsArt.toString(((Messung)object).pz.getVaVorgefunden());
                                            punktIdentitaet = (PunktIdentitaet)this.P_IDENT.get(new Long(((Messung)object).pz.nr));
                                            if (punktIdentitaet != null && this.writeMessPunkt(punktIdentitaet.soll)) {
                                                cloneable = orthoLinie.getMessungOf(punktIdentitaet.ist);
                                                this.writeOrthoAsIdentLine((PrintWriter)object5, new Messung(((Messung)object).ma, punktIdentitaet.soll, punktIdentitaet.soll, ((Messung)object).l1, 0.0), new Messung(((Messung)object).ma, punktIdentitaet.soll, punktIdentitaet.soll, ((Messung)cloneable).l1, ((Messung)cloneable).l2), string, punktIdentitaet.bemIst);
                                                bl3 = true;
                                            }
                                            if (this.writeMessPunkt(((Messung)object).pz)) {
                                                cloneable = orthoLinie.getMessungOf(((Messung)object).pz);
                                                if (((Messung)object).getWerteBelegung() > 0 && (Math.abs(((Messung)cloneable).l1 - ((Messung)object).l1) > this.db.getKatasterStreckenGenauigkeit(((Messung)object).l1 - orthoLinie.getAnfangsMass(), ((Messung)object).getGewichte().getG1()) || Math.abs(((Messung)cloneable).l2) > this.db.getKatasterStreckenGenauigkeit(0.0, ((Messung)object).getGewichte().getG2()))) {
                                                    if (((Messung)object).isFehler()) {
                                                        string2 = ((Messung)object).hasText() ? ((Messung)object).getText() : "fehlerhaftes Ma\u00df";
                                                    } else {
                                                        string2 = ((Messung)object).hasText() ? ((Messung)object).getText() : "unzul. Abweichung";
                                                        this.addException(new SurveyException("Identit\u00e4tliste:\n     unzul\u00e4ssige Linien-Abweichung in Punkt " + ((Messung)object).ps.getNr()));
                                                    }
                                                } else {
                                                    string2 = ((Messung)object).hasText() ? ((Messung)object).getText() : string4;
                                                }
                                                this.writeOrthoAsIdentLine((PrintWriter)object5, new Messung(((Messung)object).ma, ((Messung)object).ps, ((Messung)object).pz, ((Messung)object).l1, 0.0), new Messung(((Messung)object).ma, ((Messung)object).pz, ((Messung)object).pz, ((Messung)cloneable).l1, ((Messung)cloneable).l2), string, punktIdentitaet != null ? punktIdentitaet.bemSoll : string2);
                                                bl3 = true;
                                            }
                                        }
                                        if (((Messung)object).hasTag("NO1")) continue block36;
                                        string3 = ((Messung)object).ps.isVermarkungVorgefunden() ? null : VermarkungsArt.toString(((Messung)object).ps.getVaVorgefunden());
                                        punktIdentitaet = (PunktIdentitaet)this.P_IDENT.get(new Long(((Messung)object).ps.nr));
                                        if (punktIdentitaet != null && this.writeMessPunkt(punktIdentitaet.soll)) {
                                            cloneable = orthoLinie.getMessungOf(punktIdentitaet.ist);
                                            this.writeOrthoAsIdentLine((PrintWriter)object5, (Messung)object, new Messung(((Messung)object).ma, punktIdentitaet.soll, punktIdentitaet.soll, ((Messung)cloneable).l1, ((Messung)cloneable).l2), string, punktIdentitaet.bemIst);
                                            bl3 = true;
                                        }
                                        if (!this.writeMessPunkt(((Messung)object).ps)) continue block36;
                                        cloneable = orthoLinie.getMessungOf(((Messung)object).ps);
                                        if (((Messung)object).getWerteBelegung() > 0 && (Math.abs(((Messung)cloneable).l1 - ((Messung)object).l1) > this.db.getKatasterStreckenGenauigkeit(((Messung)object).l1 - orthoLinie.getAnfangsMass(), ((Messung)object).getGewichte().getG1()) || Math.abs(((Messung)cloneable).l2 - ((Messung)object).l2) > this.db.getKatasterStreckenGenauigkeit(((Messung)object).l2, ((Messung)object).getGewichte().getG1()))) {
                                            if (((Messung)object).isFehler()) {
                                                string2 = ((Messung)object).hasText() ? ((Messung)object).getText() : "fehlerhaftes Ma\u00df";
                                            } else {
                                                string2 = ((Messung)object).hasText() ? ((Messung)object).getText() : "unzul. Abweichung";
                                                this.addException(new SurveyException("Identit\u00e4tliste:\n     unzul\u00e4ssige Linien-Abweichung in Punkt " + ((Messung)object).ps.getNr()));
                                            }
                                        } else {
                                            string2 = ((Messung)object).hasText() ? ((Messung)object).getText() : string3;
                                        }
                                        this.writeOrthoAsIdentLine((PrintWriter)object5, (Messung)object, new Messung(((Messung)object).ma, ((Messung)object).ps, ((Messung)object).ps, ((Messung)cloneable).l1, ((Messung)cloneable).l2), string, punktIdentitaet != null ? punktIdentitaet.bemSoll : string2);
                                        bl3 = true;
                                    }
                                }
                            }
                            if (!bl3) continue block35;
                            this.writeVoidLineAsIdentLine((PrintWriter)object5);
                        }
                    }
                }
                if ((long)n % super.getProgressBreak() == 0L) {
                    super.setProgress(n);
                }
                ++n;
            }
            enumeration = DataBase.T.elements();
            while (enumeration.hasMoreElements()) {
                object3 = (TrafoSystem)enumeration.nextElement();
                if (!((TrafoSystem)object3).isKatasterNachweisElement()) continue;
                this.writeVoidLineAsIdentLine((PrintWriter)object5);
                String string5 = ((ValueDataContainer)object3).getName();
                object2 = ((DataContainer)object3).elements();
                while (object2.hasMoreElements()) {
                    cloneable2 = (TrafoPunkt)object2.nextElement();
                    if (!this.writeMessPunkt(((TrafoPunkt)cloneable2).getPunkt())) continue;
                    punktIdentitaet = (PunktIdentitaet)this.P_IDENT.get(new Long(((TrafoPunkt)cloneable2).getPunkt().nr));
                    if (punktIdentitaet != null) {
                        DPoint dPoint = ((TrafoSystem)object3).getInversePoint(punktIdentitaet.ist);
                        object = ((TrafoSystem)object3).getInversePoint(punktIdentitaet.soll);
                        cloneable = new TrafoPunkt(punktIdentitaet.soll, ((TrafoPunkt)cloneable2).y, ((TrafoPunkt)cloneable2).x);
                        cloneable.setVy((float)((double)((TrafoPunkt)cloneable2).getVy() + (dPoint.y - ((DPoint)object).y)));
                        cloneable.setVx((float)((double)((TrafoPunkt)cloneable2).getVx() + (dPoint.x - ((DPoint)object).x)));
                        this.writeTrafoPunktAsIdentLine((PrintWriter)object5, (TrafoPunkt)cloneable, string5, punktIdentitaet.bemIst);
                    }
                    this.writeTrafoPunktAsIdentLine((PrintWriter)object5, (TrafoPunkt)cloneable2, string5, punktIdentitaet != null ? punktIdentitaet.bemSoll : ((TrafoPunkt)cloneable2).getBemerkung());
                }
            }
            n = 0;
            super.setEndValue(DataBase.P.size());
            super.setProgressBreak();
            super.setValue(n);
            super.setLabelText("Koordinatenidentit\u00e4tsliste erstellen...");
            this.writeKooAsIdentTableHeader((PrintWriter)object5);
            ((PrintWriter)object5).println(IDENT_TABLE_HEADER);
            int n5 = 0;
            object3 = vector.elements();
            while (object3.hasMoreElements()) {
                Punkt punkt4 = (Punkt)object3.nextElement();
                punktIdentitaet = (PunktIdentitaet)this.P_IDENT.get(new Long(punkt4.nr));
                if (punkt4.getPs() != -2 && punkt4.getInternalPs() != 2 && punkt4.isOn()) {
                    if (punkt4.getLongNb() > n5) {
                        this.writeNbAsIdentLine((PrintWriter)object5, Punkt.createNbAsString(punkt4.createNb()));
                        n5 = punkt4.getLongNb();
                    }
                    if (punktIdentitaet != null) {
                        this.writePunktAsIdentPointLine((PrintWriter)object5, punktIdentitaet.soll, punktIdentitaet.ist, punktIdentitaet.bemIst);
                    }
                    switch (punkt4.getPs()) {
                        case 0: 
                        case 5: {
                            object2 = new Punkt(punkt4.getNr(), punkt4.getParameter().getPa(), punkt4.getParameter().getVa(), punkt4.y - (double)punkt4.dy, punkt4.x - (double)punkt4.dx);
                            ((Punkt)object2).getParameter(punkt4);
                            ((Punkt)object2).setRiss(punkt4.getRiss());
                            this.writePunktAsIdentPointLine((PrintWriter)object5, (Punkt)object2, punkt4, punktIdentitaet != null ? punktIdentitaet.bemSoll : null);
                            break;
                        }
                        case 2: {
                            cloneable2 = new Punkt(punkt4.getNr(), punkt4.getParameter().getPa(), punkt4.getParameter().getVa(), punkt4.y + (double)punkt4.dy, punkt4.x + (double)punkt4.dx);
                            ((Punkt)cloneable2).getParameter(punkt4);
                            this.writePunktAsIdentPointLine((PrintWriter)object5, punkt4, (Punkt)cloneable2, punktIdentitaet != null ? punktIdentitaet.bemSoll : null);
                            break;
                        }
                        case 1: {
                            this.writePunktAsIdentPointLine((PrintWriter)object5, punkt4, punktIdentitaet != null ? punktIdentitaet.bemSoll : null);
                        }
                    }
                    if ((long)n % super.getProgressBreak() == 0L) {
                        super.setProgress(n);
                    }
                }
                ++n;
            }
            ((PrintWriter)object5).println(END_OF_FILE);
            ((PrintWriter)object5).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
    }

    private void fillData(Vector vector, SortedList sortedList, DataContainer dataContainer, int n, int n2) {
        int n3;
        Vector<Messung> vector2 = new Vector<Messung>();
        Double d = null;
        for (int i = 1; i <= Math.min(KatasternachweisIOProperties.getMaxAnschlussStatus(), 5); ++i) {
            int n4;
            n3 = 1;
            block8: for (n4 = n; n4 < n2; ++n4) {
                Messung messung = (Messung)dataContainer.elementAt(n4);
                PunktParameter punktParameter = messung.ps.getParameter();
                PunktParameter punktParameter2 = messung.pz.getParameter();
                switch (i) {
                    case 1: {
                        if (!(messung.pz.getPs() != 1 && messung.pz.getPs() != 2 || punktParameter2.getKafPa() != 8 && punktParameter2.getKafPa() != 7)) {
                            vector2.addElement(messung);
                        }
                        n3 = 1;
                        continue block8;
                    }
                    case 2: {
                        if ((punktParameter2.getKafPa() == 8 || punktParameter2.getKafPa() == 7) && punktParameter2.getKafLg() == 1) {
                            vector2.addElement(messung);
                        }
                        n3 = 1;
                        continue block8;
                    }
                    case 3: {
                        if ((punktParameter2.getKafPa() == 8 || punktParameter2.getKafPa() == 7) && punktParameter2.getKafLg() == 1 || messung.pz.isStandPunkt()) {
                            vector2.addElement(messung);
                        }
                        n3 = 1;
                        continue block8;
                    }
                    case 4: {
                        if (punktParameter2.getKafPa() == 8 || punktParameter2.getKafPa() == 7 || messung.pz.getPs() == 1 || messung.pz.getPs() == 2 || messung.pz.isStandPunkt()) {
                            vector2.addElement(messung);
                        }
                        n3 = 1;
                        continue block8;
                    }
                    case 5: {
                        vector2.addElement(messung);
                        n3 = 1;
                    }
                }
            }
            if (vector2.size() >= n3) {
                d = new Double(this.getOrientierung(vector2));
                vector.addElement(d);
                for (n4 = 0; n4 < vector2.size(); ++n4) {
                    vector.addElement(vector2.elementAt(n4));
                }
                break;
            }
            vector2.removeAllElements();
        }
        if (d == null) {
            for (n3 = n; n3 < n2; ++n3) {
                Messung messung = (Messung)dataContainer.elementAt(n3);
                if (n3 == n) {
                    this.addException(new SurveyException("Identit\u00e4tliste:\n     Stanpunkt " + messung.ps.getNr() + " besitzt keine Anschlusspunkte, Orientierung wird aus allen Messwerten erzeugt."));
                }
                vector2.addElement(messung);
            }
            d = new Double(this.getOrientierung(vector2));
            vector2.removeAllElements();
        }
        for (n3 = n; n3 < n2; ++n3) {
            boolean bl;
            Messung messung = (Messung)dataContainer.elementAt(n3);
            boolean bl2 = KatasternachweisIOProperties.parsePointNumber() ? PunktNummer.createPaString(messung.pz.nr) != null : (bl = messung.pz.getKafPa() != -1);
            if (vector2.contains(messung) || !bl) continue;
            sortedList.add(new ListEntry(this, d, messung));
        }
    }

    private double getOrientierung(Vector vector) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Messung messung = (Messung)enumeration.nextElement();
            Punkt punkt = messung.ps != null ? messung.ps : messung.getReferenz().ps;
            Punkt punkt2 = messung.pz;
            double d3 = Math.atan2(punkt2.y - punkt.y, punkt2.x - punkt.x);
            double d4 = messung.pz.getDistance2(punkt);
            if ((d3 -= messung.l1 * Math.PI / 200.0) < 0.0) {
                d3 += Math.PI * 2;
            } else if (d3 > Math.PI * 2) {
                d3 -= Math.PI * 2;
            }
            if (d3 < 0.0) {
                d3 += Math.PI * 2;
            }
            d += d3 * d4;
            d2 += d4;
            ++n;
        }
        if (n > 0) {
            return d / d2;
        }
        return 0.0;
    }

    private double getLageAbweichung(Punkt punkt) {
        PunktParameter punktParameter = punkt.getParameter();
        int n = punkt.getPs();
        if (n < 1 || n == 5 || n == 3) {
            return 0.06;
        }
        if (punktParameter.getKafPa() == 7 && punktParameter.getKafLg() == 1) {
            return 0.06;
        }
        if (punktParameter.getKafLg() == 1 || punktParameter.getKafLg() == 2) {
            return 0.08;
        }
        return 0.12;
    }

    private void writeLongLine(PrintWriter printWriter, String string, String string2) {
        printWriter.println("\\cell\\row\\pard \\trowd\\trqr\\clvertalt\\cellx9910");
        printWriter.print("\\pard\\intbl\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20");
        if (string != null || string2 != null) {
            printWriter.print("{\\ltrch");
            if (string != null) {
                printWriter.print("\\b ");
                printWriter.print(KatasternachweisNrwWriter.getRtfString(string));
                printWriter.print(END_OF_FILE);
            }
            if (string2 != null) {
                printWriter.print(KatasternachweisNrwWriter.getRtfString(string2));
            }
        }
    }

    private void writeCellLine(PrintWriter printWriter, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        printWriter.println("\\cell\\row\\pard \\trowd\\trqr\\clvertalt\\cellx1054\\clvertalt\\cellx1616\\clvertalt\\cellx2459\\clvertalt\\cellx4005\\clvertalt\\cellx5552\\clvertalt\\cellx6465\\clvertalt\\cellx7379\\clvertalt\\cellx8223\\clvertalt\\cellx9066\\clvertalt\\cellx9910");
        printWriter.print("\\pard\\intbl\\pard\\plain \\intbl\\s1\\cf0\\rtlch\\ltrch\\dbch\\fs20\\qc");
        this.writeCellString(printWriter, string);
        printWriter.print(CELL_DEF);
        this.writeCellString(printWriter, string2);
        printWriter.print(CELL_DEF);
        this.writeCellString(printWriter, string3);
        printWriter.print(CELL_DEF);
        this.writeCellString(printWriter, string4);
        printWriter.print(CELL_DEF);
        this.writeCellString(printWriter, string5);
        printWriter.print(CELL_DEF);
        this.writeCellString(printWriter, string6);
        printWriter.print(CELL_DEF);
        this.writeCellString(printWriter, string7);
        printWriter.print(CELL_DEF);
        this.writeCellString(printWriter, string8);
        printWriter.print(CELL_DEF);
        this.writeCellString(printWriter, string9);
        printWriter.print(CELL_DEF);
        this.writeCellString(printWriter, string10);
    }

    private void writeCellString(PrintWriter printWriter, String string) {
        if (string != null) {
            printWriter.print(" {\\ltrch ");
            printWriter.print(KatasternachweisNrwWriter.getRtfString(string));
            printWriter.println(END_OF_FILE);
        } else {
            printWriter.println("");
        }
    }

    private boolean writeMessPunkt(Punkt punkt) {
        return KatasternachweisIOProperties.writeLokalPunkt() || !punkt.isLokalPunkt() || this.P_IDENT.get(new Long(punkt.nr)) != null;
    }

    private void writeKopfTable(PrintWriter printWriter) {
        printWriter.println("\\trowd \\trgaph70\\trrh400\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb");
        printWriter.println("\\brdrs\\brdrw10 \\cltxlrtb \\cellx1134\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx3402\\clvmgf\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb");
        printWriter.println("\\cellx5954\\clvmgf\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx7797\\clvertalt\\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923");
        printWriter.println("{\\trwd}");
        printWriter.println("\\pard \\widctlpar\\intbl\\adjustright {\\fs16 Gemeinde }{\\cell }");
        printWriter.print("\\pard\\plain \\s1\\keepn\\widctlpar\\intbl\\outlinelevel0\\adjustright \\b\\fs20\\lang1031\\cgrid {");
        if (DataBase.gemeinde != null) {
            printWriter.print(KatasternachweisNrwWriter.getRtfString(DataBase.gemeinde));
        }
        printWriter.println("\\cell }");
        printWriter.println("\\pard\\plain \\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {\\fs16 Vermessungsstelle\\par }");
        printWriter.print("\\pard \\qc\\widctlpar\\intbl\\adjustright {\\b\\fs16 ");
        if (DataBase.vermStelle != null) {
            printWriter.print(KatasternachweisNrwWriter.getRtfString(DataBase.vermStelle));
        }
        printWriter.println("}{\\fs16 \\cell }");
        printWriter.println("\\pard \\widctlpar\\intbl\\adjustright {\\fs16 Katasteramt\\par }");
        printWriter.print("\\pard \\qc\\widctlpar\\intbl\\adjustright {");
        if (DataBase.katasterAmt != null) {
            printWriter.print(KatasternachweisNrwWriter.getRtfString(DataBase.katasterAmt));
        }
        printWriter.println("\\cell }");
        printWriter.println("\\pard \\widctlpar\\intbl\\adjustright {\\fs16 Archivblatt*:\\cell }");
        printWriter.println("{\\row }");
        printWriter.println("\\trowd \\trgaph70\\trrh400\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr");
        printWriter.println("\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\cltxlrtb \\cellx1134\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb");
        printWriter.println("\\cellx3402\\clvmrg\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx5954\\clvmrg\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10");
        printWriter.println("\\cltxlrtb \\cellx7797\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\cltxlrtb \\cellx9923");
        printWriter.println("{\\trwd}");
        printWriter.println("\\pard \\widctlpar\\intbl\\adjustright {\\fs16 Gemarkung\\cell }");
        printWriter.print("\\pard\\plain \\s1\\keepn\\widctlpar\\intbl\\outlinelevel0\\adjustright\\b\\fs20\\lang1031\\cgrid {");
        if (this.gemarkung != null) {
            printWriter.print(KatasternachweisNrwWriter.getRtfString(this.gemarkung));
        }
        printWriter.println("\\cell }");
        printWriter.println("\\pard\\plain \\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {\\cell \\cell }{\\fs16 Antrags-Nr.*:\\cell }");
        printWriter.println("{\\row }");
        printWriter.println("\\trowd \\trgaph70\\trrh400\\trleft-70\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl");
        printWriter.println("\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrdashsm\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx1134\\clvertalt\\clbrdrt");
        printWriter.println("\\brdrs\\brdrw10 \\clbrdrb\\brdrs\\brdrw10 \\clbrdrr\\brdrs\\brdrw10 \\cltxlrtb \\cellx3402\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\clbrdrl\\brdrs\\brdrw10 \\cltxlrtb \\cellx5954\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\cltxlrtb \\cellx7797\\clvertalt\\clbrdrt\\brdrs\\brdrw10 \\cltxlrtb");
        printWriter.println("\\cellx9923");
        printWriter.println("{\\trwd}");
        printWriter.print("\\pard \\widctlpar\\intbl\\adjustright {\\fs16 Flur}{ }{\\b ");
        if (DataBase.flur != null) {
            printWriter.print(KatasternachweisNrwWriter.getRtfString(DataBase.flur));
        }
        printWriter.println("}{\\cell }");
        printWriter.print("{\\fs16 Flurst\\'fcck }{\\b ");
        if (DataBase.flurstueck != null) {
            printWriter.print(KatasternachweisNrwWriter.getRtfString(DataBase.flurstueck));
        }
        printWriter.println("}{\\fs16 \\cell }");
        printWriter.println("{\\cell \\cell }{\\fs12 * wird vom Katasteramt ausgef\\'fcllt\\cell }");
        printWriter.println("{\\row }");
        printWriter.println("\\pard \\widctlpar\\adjustright");
        printWriter.println("{\\par\\par}");
    }

    private void writeKooAsIdentTableHeader(PrintWriter printWriter) {
        printWriter.println("\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10");
        printWriter.println("\\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx8080\\clvertalt\\cltxlrtb \\cellx9001\\clvertalt\\cltxlrtb \\cellx9923");
        KatasternachweisNrwWriter katasternachweisNrwWriter = this;
        KatasternachweisNrwWriter katasternachweisNrwWriter2 = this;
        printWriter.println("\\pard\\widctlpar\\intbl\\adjustright {\\b \\cell }{\\fs20 LST: " + katasternachweisNrwWriter.db.getKooSystem() + "\\cell }{\\fs20 h{\\sub m}: " + i0.format((int)katasternachweisNrwWriter2.db.getGelHoehe()).toString() + "\\cell }\\pard \\widctlpar\\intbl\\adjustright {\\row }");
    }

    private void writeNbAsIdentLine(PrintWriter printWriter, String string) {
        printWriter.println("\\trowd \\trgaph70\\trleft-70\\trkeep\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10 \\cltxlrtb \\cellx9923");
        printWriter.println("\\pard \\widctlpar\\intbl\\adjustright {\\fs20\\b Nummerierungsbezirk: " + string + "}{\\cell }\\pard \\widctlpar\\intbl\\adjustright {\\row }");
        printWriter.println("\\trowd \\trgaph70\\trleft-70\\trbrdrt\\brdrs\\brdrw10 \\trbrdrl\\brdrs\\brdrw10 \\trbrdrb\\brdrs\\brdrw10 \\trbrdrr\\brdrs\\brdrw10 \\trbrdrh\\brdrs\\brdrw10 \\trbrdrv\\brdrs\\brdrw10 \\clvertalt\\clbrdrl\\brdrdashsm\\brdrw10");
        printWriter.println("\\cltxlrtb \\cellx851\\clvertalt\\cltxlrtb \\cellx1874\\clvertalt\\cltxlrtb \\cellx2897\\clvertalt\\cltxlrtb \\cellx3920\\clvertalt\\cltxlrtb \\cellx4943\\clvertalt\\cltxlrtb \\cellx5652\\clvertalt\\cltxlrtb \\cellx6361\\clvertalt\\cltxlrtb \\cellx7070\\clvertalc\\cltxlrtb");
        printWriter.println("\\cellx8080\\clvertalc\\cltxlrtb \\cellx9923");
    }

    private void writeTrafoPunktAsIdentLine(PrintWriter printWriter, TrafoPunkt trafoPunkt, String string, String string2) {
        printWriter.println("{\\trwd}");
        printWriter.print("\\pard \\qc\\widctlpar\\intbl\\adjustright {\\fs20 ");
        if (trafoPunkt.getPunkt().getKafPa() != -1) {
            printWriter.print(trafoPunkt.getPunkt().getNumPa() + SPACE);
            if (trafoPunkt.getPunkt().getKatNr() > 99999L) {
                printWriter.print(trafoPunkt.getPunkt().getKatNr() + CELL);
            } else {
                printWriter.print(IFormat.i05.format(trafoPunkt.getPunkt().getKatNr()).toString() + CELL);
            }
        } else {
            printWriter.print(trafoPunkt.getPunkt().getKatNr() + CELL);
        }
        printWriter.print(SPACE + d33.format(trafoPunkt.y - (double)((int)trafoPunkt.y / 1000 * 1000)).toString() + CELL);
        printWriter.print(SPACE + d33.format(trafoPunkt.x - (double)((int)trafoPunkt.x / 1000 * 1000)).toString() + CELL);
        printWriter.print(SPACE + d33.format(trafoPunkt.y - (double)((int)trafoPunkt.y / 1000 * 1000) + (double)trafoPunkt.getVy()).toString() + CELL);
        printWriter.print(SPACE + d33.format(trafoPunkt.x - (double)((int)trafoPunkt.x / 1000 * 1000) + (double)trafoPunkt.getVx()).toString() + CELL);
        printWriter.print(SPACE + d03.format(-trafoPunkt.getVy()).toString() + CELL);
        printWriter.print(SPACE + d03.format(-trafoPunkt.getVx()).toString() + CELL);
        printWriter.print(SPACE + d03.format(trafoPunkt.getVs()).toString() + CELL);
        printWriter.println(" }");
        printWriter.print("{\\fs16 ");
        printWriter.print(string != null ? string : SPACE);
        printWriter.print("\\cell }\\pard \\widctlpar\\intbl\\adjustright {\\fs16 ");
        if (string2 == null && (double)trafoPunkt.getVs() > IDENT_DK_ZUL) {
            string2 = KOO_FEHLER;
            this.addException(new SurveyException("Identit\u00e4tsliste\n     Transformationsfehler in Punkt " + trafoPunkt.getPunkt().getKatNr()));
        }
        if (string2 == null && !trafoPunkt.getPunkt().isVermarkungVorgefunden()) {
            string2 = VermarkungsArt.toString(trafoPunkt.getPunkt().getVaVorgefunden());
        }
        if (string2 != null) {
            printWriter.print(string2);
        }
        printWriter.println("\\cell }\\pard \\widctlpar\\intbl\\adjustright {\\row }");
    }

    private void writePunktAsIdentPointLine(PrintWriter printWriter, Punkt punkt, Punkt punkt2, String object) {
        double d = punkt.y - punkt2.y;
        double d2 = punkt.x - punkt2.x;
        double d3 = Math.sqrt(d * d + d2 * d2);
        printWriter.println("{\\trwd}");
        printWriter.print("\\pard \\qc\\widctlpar\\intbl\\adjustright {\\fs20 ");
        if (punkt.getKafPa() != -1) {
            printWriter.print(punkt.getNumPa() + SPACE);
            if (punkt.getKatNr() > 99999L) {
                printWriter.print(punkt.getKatNr() + CELL);
            } else {
                printWriter.print(IFormat.i05.format(punkt.getKatNr()).toString() + CELL);
            }
        } else {
            printWriter.print(punkt.getKatNr() + CELL);
        }
        printWriter.print(SPACE + d33.format(punkt.y - (double)((int)punkt.y / 1000 * 1000)).toString() + CELL);
        printWriter.print(SPACE + d33.format(punkt.x - (double)((int)punkt.x / 1000 * 1000)).toString() + CELL);
        printWriter.print(SPACE + d33.format(punkt2.y - (double)((int)punkt2.y / 1000 * 1000)).toString() + CELL);
        printWriter.print(SPACE + d33.format(punkt2.x - (double)((int)punkt2.x / 1000 * 1000)).toString() + CELL);
        printWriter.print(SPACE + d03.format(d).toString() + CELL);
        printWriter.print(SPACE + d03.format(d2).toString() + CELL);
        printWriter.println(SPACE + d03.format(d3).toString() + "\\cell }");
        printWriter.print("{\\fs16 ");
        String string = punkt.getRiss() != null ? punkt.getRiss() : DataBase.antrag;
        printWriter.print(string != null ? string : SPACE);
        printWriter.print("\\cell }\\pard \\widctlpar\\intbl\\adjustright {\\fs16 ");
        if (object == null) {
            if (!punkt.isVermarkungVorgefunden()) {
                object = VermarkungsArt.toString(punkt.getVaVorgefunden());
            }
            if (punkt.getPs() == 0 || punkt.getPs() == 5) {
                object = object != null ? (String)object + ", neue Koo eingef\u00fchrt" : NEU_KOO;
            } else if (punkt.getPs() == 2 && d3 > IDENT_DK_ZUL) {
                object = object != null ? (String)object + ", Koordinaten-Fehler" : KOO_FEHLER;
                this.addException(new SurveyException("Identit\u00e4tsliste\n     Koordinatenfehler in Punkt " + punkt.getKatNr()));
            }
        }
        if (object != null) {
            printWriter.print((String)object);
        }
        printWriter.println("\\cell }\\pard \\widctlpar\\intbl\\adjustright {\\row }");
    }

    private void writePunktAsIdentPointLine(PrintWriter printWriter, Punkt punkt, String string) {
        if (string != null && !punkt.isVermarkungVorgefunden()) {
            string = VermarkungsArt.toString(punkt.getVaVorgefunden());
        }
        printWriter.println("{\\trwd}");
        printWriter.print("\\pard \\qc\\widctlpar\\intbl\\adjustright {\\fs20 ");
        if (punkt.getKafPa() != -1) {
            printWriter.print(punkt.getNumPa() + SPACE);
            printWriter.print(GeoNumberFormat.nr05n.format(punkt.getKatNr()).toString() + CELL);
        } else {
            printWriter.print(punkt.getKatNr() + CELL);
        }
        printWriter.print(SPACE + d33.format(punkt.y - (double)((int)punkt.y / 1000 * 1000)).toString() + CELL);
        printWriter.print(SPACE + d33.format(punkt.x - (double)((int)punkt.x / 1000 * 1000)).toString() + CELL);
        printWriter.print(" \\cell \\cell \\cell \\cell \\cell }");
        printWriter.print("{\\fs16 ");
        String string2 = punkt.getRiss() != null ? punkt.getRiss() : DataBase.antrag;
        printWriter.print(string2 != null ? string2 : SPACE);
        printWriter.print("\\cell }\\pard \\widctlpar\\intbl\\adjustright {\\fs16 ");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("\\cell }\\pard \\widctlpar\\intbl\\adjustright {\\row }");
    }

    private void writeVoidLineAsIdentLine(PrintWriter printWriter) {
        printWriter.println("{\\trwd}\\pard\\plain \\qc\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {\\cell \\cell \\cell \\cell \\cell \\cell \\cell \\cell}{\\fs16 \\cell}\\pard\\widctlpar\\intbl\\adjustright{\\fs16 \\cell}{\\row }");
    }

    private void writeStreckeAsIdentLine(PrintWriter printWriter, Messung messung, Messung messung2, String string, String string2, String string3, String string4) {
        printWriter.println("{\\trwd}");
        printWriter.print("\\pard\\plain \\qc\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {");
        if (messung.ps.getKafPa() != -1) {
            printWriter.print(messung.ps.getNumPa() + SPACE);
            printWriter.print(GeoNumberFormat.nr05n.format(messung.ps.getKatNr()).toString());
        } else {
            printWriter.print(messung.ps.getKatNr());
        }
        printWriter.print("\\cell \\cell \\cell \\cell \\cell \\cell \\cell \\cell}{\\fs16 \\cell }\\pard \\widctlpar\\intbl\\adjustright {\\fs16 ");
        if (string2 != null) {
            printWriter.print(string2);
        }
        printWriter.println("\\cell}");
        printWriter.println("{\\row }{\\trwd}");
        printWriter.print("\\pard\\plain \\qc\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {\\cell " + d02.format(messung.l1).toString() + "\\cell\\cell " + d02.format(messung2.l1).toString() + "\\cell\\cell " + d02.format(messung.l1 - messung2.l1).toString() + "\\cell\\cell " + d02.format(Math.abs(messung.l1 - messung2.l1)).toString() + "\\cell}{\\fs16 " + string + "\\cell}\\pard\\widctlpar\\intbl\\adjustright{\\fs16 ");
        if (string4 != null) {
            printWriter.print(string4);
        }
        printWriter.println("\\cell}");
        printWriter.println("{\\row }{\\trwd}");
        printWriter.print("\\pard\\plain \\qc\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {");
        if (messung.pz.getKafPa() != -1) {
            printWriter.print(messung.pz.getNumPa() + SPACE);
            printWriter.print(GeoNumberFormat.nr05n.format(messung.pz.getKatNr()).toString());
        } else {
            printWriter.print(messung.pz.getKatNr());
        }
        printWriter.print("\\cell \\cell \\cell \\cell \\cell \\cell \\cell \\cell}{\\fs16 \\cell }\\pard \\widctlpar\\intbl\\adjustright {\\fs16 ");
        if (string3 != null) {
            printWriter.print(string3);
        }
        printWriter.println("\\cell}");
        printWriter.println("{\\row }");
    }

    private void writeOrthoAsIdentLine(PrintWriter printWriter, Messung messung, Messung messung2, String string, String string2) {
        boolean bl = messung.getWerteBelegung() == 0;
        double d = messung.l1 - messung2.l1;
        double d2 = messung.l2 - messung2.l2;
        double d3 = Math.sqrt(d2 * d2 + d * d);
        if (bl) {
            d3 = Math.abs(d2);
        }
        printWriter.println("{\\trwd}");
        printWriter.print("\\pard\\plain \\qc\\widctlpar\\intbl\\adjustright \\fs20\\lang1031\\cgrid {");
        if (messung2.ps.getKafPa() != -1) {
            printWriter.print(messung2.ps.getNumPa() + SPACE);
            printWriter.print(GeoNumberFormat.nr05n.format(messung2.ps.getKatNr()).toString());
        } else {
            printWriter.print(messung2.ps.getKatNr());
        }
        printWriter.print("\\cell " + d02.format(messung.l2).toString() + "\\cell ");
        if (!bl) {
            printWriter.print(d02.format(messung.l1).toString());
        }
        printWriter.print("\\cell " + d02.format(messung2.l2).toString() + "\\cell " + d02.format(messung2.l1).toString() + "\\cell " + d02.format(d2).toString() + "\\cell ");
        if (!bl) {
            printWriter.print(d02.format(d).toString());
        }
        printWriter.print("\\cell " + d02.format(d3).toString() + "\\cell}{\\fs16 " + string + "\\cell}\\pard\\widctlpar\\intbl\\adjustright{\\fs16 ");
        if (string2 != null) {
            printWriter.print(string2);
        }
        printWriter.println("\\cell}");
        printWriter.println("{\\row }");
    }

    private class ListEntry
    implements Sortable {
        Double o;
        Messung m;

        ListEntry(KatasternachweisNrwWriter katasternachweisNrwWriter, Double d, Messung messung) {
            this.o = d;
            this.m = messung;
        }

        public Messung getMessung() {
            return this.m;
        }

        public Double getOrientation() {
            return this.o;
        }

        @Override
        public boolean isLt(Sortable sortable) {
            if (sortable instanceof ListEntry) {
                Messung messung = ((ListEntry)sortable).getMessung();
                return this.m.pz.nr < messung.pz.nr;
            }
            throw new NullPointerException("KatasternachweisNRWWriter.ListEntry");
        }

        public String toString() {
            return this.m.toString();
        }
    }
}

