/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.VermarkungsArt;
import de.geocalc.kafplot.io.KatasternachweisIOProperties;
import de.geocalc.kafplot.io.RtfWriter;
import de.geocalc.text.DecimalFormat;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparator;
import de.geocalc.util.LongHashList;
import java.io.File;
import java.util.Hashtable;

public abstract class KatasternachweisWriter
extends RtfWriter {
    protected static final int NONE = 0;
    protected static final int POLAR = 1;
    protected static final int ORTHO = 2;
    protected static final int MESSB = 3;
    protected static final int TRAFO = 4;
    protected static final int KOORD = 5;
    protected int block = 0;
    protected File rissFile;
    protected File identFile;
    protected DataBase db;
    protected String gemarkung;
    protected LongHashList P;
    protected Hashtable P_IDENT;
    protected static final DecimalFormat d13 = new DecimalFormat("0.000");
    protected static final DecimalFormat d33 = new DecimalFormat("000.000");
    protected static final DecimalFormat d02 = new DecimalFormat("#0.00");
    protected static final DecimalFormat d03 = new DecimalFormat("#0.000");
    protected static final DecimalFormat i0 = new DecimalFormat("#");
    protected static final DecimalFormat koo33 = new DecimalFormat("000.000");
    protected static final DecimalFormat dif33 = new DecimalFormat("0.000");
    protected static double IDENT_DK_ZUL;

    public KatasternachweisWriter(File file, DataBase dataBase) {
        super(file, dataBase);
    }

    @Override
    public abstract void write() throws IFileOutputException;

    protected static String getPnrString(Punkt punkt) {
        StringBuffer stringBuffer = new StringBuffer(20);
        if (punkt.getKafPa() == 0) {
            if (KatasternachweisIOProperties.writeWithVPraefix()) {
                stringBuffer.append("v");
            }
            stringBuffer.append(punkt.getNr());
        } else {
            if (punkt.createKooNb() != punkt.createNb()) {
                stringBuffer.append("{\\fs12 3" + Punkt.createNbAsString(punkt.createNb()) + "\\line}");
            }
            stringBuffer.append(punkt.getNr6());
        }
        return stringBuffer.toString();
    }

    protected static String getPaString(Punkt punkt) {
        switch (punkt.getParameter().getPa()) {
            case 10: {
                return "AP";
            }
            case 11: {
                return "SP";
            }
            case 20: 
            case 29: {
                return "GP";
            }
            case 30: 
            case 39: {
                return "BG";
            }
            case 40: 
            case 49: {
                return "BB";
            }
            case 50: {
                return "BT";
            }
            case 60: {
                return "SV";
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                return "NP";
            }
        }
        return "";
    }

    protected static String getVaString(int n) {
        if (n == 0) {
            return "";
        }
        return KatasternachweisIOProperties.abmAsText() ? VermarkungsArt.toKuerzel(n) : IFormat.i04.format(n);
    }

    protected static String getLzString(int n) {
        if (n == 2) {
            return "J";
        }
        if (n == 1) {
            return "N";
        }
        return "";
    }

    static {
        koo33.setFormatWidth(7);
        koo33.setMaximumIntegerDigits(3);
        dif33.setFormatWidth(7);
        dif33.setMaximumIntegerDigits(3);
        IDENT_DK_ZUL = 0.08;
    }

    protected class LineComparator
    implements Comparator {
        protected LineComparator(KatasternachweisWriter katasternachweisWriter) {
        }

        @Override
        public int compare(Object object, Object object2) {
            Linie linie = (Linie)object;
            Linie linie2 = (Linie)object2;
            long l = Math.min(linie.pa.getNr(), linie.pe.getNr());
            long l2 = Math.max(linie.pa.getNr(), linie.pe.getNr());
            long l3 = Math.min(linie2.pa.getNr(), linie2.pe.getNr());
            long l4 = Math.max(linie2.pa.getNr(), linie2.pe.getNr());
            if (l < l3) {
                return -1;
            }
            if (l > l3) {
                return 1;
            }
            if (l2 < l4) {
                return -1;
            }
            if (l2 > l4) {
                return 1;
            }
            return 0;
        }
    }
}

