/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.Bedingung;
import de.geocalc.kafplot.Bemerkung;
import de.geocalc.kafplot.BodenSchaetzung;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.DataContainerTable;
import de.geocalc.kafplot.ErrorObject;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.Grundbuchblatt;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KafPlotVersion;
import de.geocalc.kafplot.KatAmt;
import de.geocalc.kafplot.KoordinatenSystem;
import de.geocalc.kafplot.Lagegenauigkeit;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.MessungGewicht;
import de.geocalc.kafplot.Nutzung;
import de.geocalc.kafplot.NutzungsArt;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktContainer;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.TopObject;
import de.geocalc.kafplot.TrafoGewicht;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.VermarkungsArt;
import de.geocalc.kafplot.io.IDataReader;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.MessungParser;
import de.geocalc.kafplot.io.kpv.KpvIOProperties;
import de.geocalc.kataster.model.Alk;
import de.geocalc.kataster.model.Alkis;
import de.geocalc.util.LongHashObject;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;

public class KpvReader
extends IDataReader {
    private static final String MEMORY_ERROR = "Zu wenig Speicher zum Laden der Daten,\n erh\u00f6hen Sie mit den Startoptionen '-Xms=256Mb -Xmx=256Mb' den Speicher";
    protected DataBase db;
    protected DataInputStream in;
    protected long fileLength = 0L;

    public KpvReader(File file, DataBase dataBase) throws IFileInputException {
        this(file, dataBase, null);
    }

    public KpvReader(File file, DataBase dataBase, IProgressViewer iProgressViewer) throws IFileInputException {
        super(file, iProgressViewer);
        this.db = dataBase;
        try {
            this.in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IFileInputException("Datei " + file.getName() + " nicht gefunden");
        }
        if (file != null) {
            this.fileLength = file.length();
        }
    }

    public KpvReader(URL uRL, DataBase dataBase) throws IFileInputException {
        this(uRL, dataBase, null);
    }

    public KpvReader(URL uRL, DataBase dataBase, IProgressViewer iProgressViewer) throws IFileInputException {
        super(null, iProgressViewer);
        this.db = dataBase;
        try {
            this.in = new DataInputStream(new BufferedInputStream(uRL.openStream()));
        }
        catch (IOException iOException) {
            throw new IFileInputException("Datei " + uRL.getFile() + " nicht gefunden");
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            this.fileLength = uRLConnection.getContentLength();
            if (this.fileLength < 0L) {
                this.fileLength = 0L;
            }
        }
        catch (IOException iOException) {
            throw new IFileInputException("Datei " + uRL.getFile() + " konnte nicht ge\u00f6ffnet werden");
        }
    }

    public KpvReader(InputStream inputStream, DataBase dataBase, IProgressViewer iProgressViewer) throws IFileInputException {
        super(null, iProgressViewer);
        this.db = dataBase;
        try {
            this.in = new DataInputStream(inputStream);
        }
        catch (Exception exception) {
            throw new IFileInputException("Daten nicht gefunden");
        }
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen des KpvReaders");
        }
    }

    @Override
    public void read() throws IFileInputException {
        PunktContainer punktContainer;
        long l = 0L;
        byte by = 0;
        try {
            this.in.skipBytes(14);
            int n = this.in.readInt();
            if (n < 105) {
                throw new IFileInputException("Veraltete Dateiversion " + n);
            }
            if (n > 204) {
                throw new IFileInputException("Dateiversion ist " + n + ", ReaderVersion unterst\u00fctzt bis Version 204");
            }
            DataBase.model = n < 200 ? Alk.getInstance() : Alkis.getInstance();
            KpvIOProperties.RVER = n;
            KafPlotVersion.setDataLizenzNummer(this.in.readLong());
            if (KpvIOProperties.RVER >= 106) {
                KafPlotVersion.LIZENZ_NM = KafPlotIOConstants.readString(this.in);
            }
            DataBase.projekt = KafPlotIOConstants.readString(this.in);
            DataBase.kafDatVersion = KafPlotIOConstants.readString(this.in);
            DataBase.vermStelle = KafPlotIOConstants.readString(this.in);
            DataBase.adresse_1 = KafPlotIOConstants.readString(this.in);
            DataBase.adresse_2 = KafPlotIOConstants.readString(this.in);
            DataBase.adresse_3 = KafPlotIOConstants.readString(this.in);
            DataBase.bearbeiter = KafPlotIOConstants.readString(this.in);
            DataBase.gemeinde = KafPlotIOConstants.readString(this.in);
            DataBase.gemarkung = KafPlotIOConstants.readString(this.in);
            DataBase.flur = KafPlotIOConstants.readString(this.in);
            DataBase.flurstueck = KafPlotIOConstants.readString(this.in);
            DataBase.katasterAmt = KafPlotIOConstants.readString(this.in);
            DataBase.antrag = KafPlotIOConstants.readString(this.in);
            DataBase.xmin = this.in.readDouble();
            DataBase.ymin = this.in.readDouble();
            DataBase.xmax = this.in.readDouble();
            DataBase.ymax = this.in.readDouble();
            DataBase.setGelHoehe(this.in.readDouble());
            if (KpvIOProperties.RVER >= 113) {
                DataBase.emax = this.in.readDouble();
                DataBase.vmax = this.in.readDouble();
                DataBase.zmax = this.in.readDouble();
                DataBase.amax = this.in.readDouble();
                DataBase.smax = this.in.readDouble();
                DataBase.tvmax = this.in.readDouble();
                DataBase.trmax = this.in.readDouble();
                DataBase.maxAreaProportion = this.in.readDouble();
                DataBase.maxAreaDifference = this.in.readDouble();
            }
            KoordinatenSystem.setArea(150, this.in.readDouble(), this.in.readDouble());
            KoordinatenSystem.setArea(489, this.in.readDouble(), this.in.readDouble());
            if (KpvIOProperties.RVER < 113) {
                KafPlotProperties.readThemes(this.in);
                KafPlotProperties.readObject(this.in);
            }
            while ((by = this.in.readByte()) != -1) {
                switch (by) {
                    case 91: {
                        super.setProgress(10);
                        PunktParameter.readObjects(this.in);
                        break;
                    }
                    case 93: {
                        LinieParameter.readObjects(this.in);
                        break;
                    }
                    case 94: {
                        MessungGewicht.readObjects(this.in);
                        break;
                    }
                    case 95: {
                        TrafoGewicht.readObjects(this.in);
                        break;
                    }
                    case 11: {
                        punktContainer = Punkt.readObject(this.in);
                        DataBase.P.put((LongHashObject)((Object)punktContainer));
                        break;
                    }
                    case 21: {
                        super.setProgress(15);
                        DataBase.MG.addElement(Riss.readObject(this.in));
                        break;
                    }
                    case 22: {
                        super.setProgress(20);
                        DataBase.MP.addElement(Riss.readObject(this.in));
                        break;
                    }
                    case 23: {
                        super.setProgress(25);
                        DataBase.MM.addElement(Riss.readObject(this.in));
                        break;
                    }
                    case 24: {
                        super.setProgress(30);
                        DataBase.MK.addElement(Riss.readObject(this.in));
                        break;
                    }
                    case 25: {
                        DataBase.ME.addElement(Riss.readObject(this.in));
                        break;
                    }
                    case 26: {
                        DataBase.MV.addElement(Riss.readObject(this.in));
                        break;
                    }
                    case 27: {
                        DataBase.BH.addElement(Riss.readObject(this.in));
                        break;
                    }
                    case 28: {
                        super.setProgress(35);
                        DataBase.BB.addElement(Riss.readObject(this.in));
                        break;
                    }
                    case 31: {
                        super.setProgress(40);
                        DataBase.T.addElement(TrafoSystem.readObject(this.in));
                        break;
                    }
                    case 17: {
                        DataBase.BEM.addElement(Bemerkung.readObject(this.in));
                        break;
                    }
                    case 52: {
                        super.setProgress(50);
                        DataBase.FLST.put(Flurstueck.readObject(this.in));
                        break;
                    }
                    case 57: {
                        super.setProgress(60);
                        try {
                            DataBase.BUCH.put(Grundbuchblatt.readObject(this.in));
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 55: {
                        super.setProgress(65);
                        DataBase.NUTZ.put(Nutzung.readObject(this.in));
                        break;
                    }
                    case 59: {
                        super.setProgress(70);
                        DataBase.BODEN.put(BodenSchaetzung.readObject(this.in));
                        break;
                    }
                    case 53: {
                        super.setProgress(75);
                        DataBase.GEB.put(Gebaeude.readObject(this.in));
                        break;
                    }
                    case 56: {
                        super.setProgress(80);
                        DataBase.TOP.put(TopObject.readObject(this.in));
                        break;
                    }
                    case 75: {
                        super.setProgress(90);
                        NutzungsArt.saveObject(NutzungsArt.readObject(this.in));
                        break;
                    }
                    case 71: {
                        Gemeinde.saveObject(Gemeinde.readObject(this.in));
                        break;
                    }
                    case 74: {
                        KatAmt.saveObject(KatAmt.readObject(this.in));
                        break;
                    }
                    case 76: {
                        VermarkungsArt.saveObject(VermarkungsArt.readObject(this.in));
                        break;
                    }
                    case 92: {
                        DataBase.ERR.addElement(ErrorObject.readObject(this.in), false);
                        break;
                    }
                    case 77: {
                        Lagegenauigkeit.put(Lagegenauigkeit.readObject(this.in));
                        break;
                    }
                    case 111: {
                        KafPlotProperties.readThemes(this.in);
                        KafPlotProperties.readObject(this.in);
                    }
                }
            }
            this.in.close();
            KpvIOProperties.flushTables();
            super.setProgress(80);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IFileInputException("Lesefehler beim Lesen der Datei: " + this.inFile.getName());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.err.println(MEMORY_ERROR);
            System.gc();
            throw new IFileInputException(MEMORY_ERROR);
        }
        this.parseMessungen(DataBase.MG);
        this.parseMessungen(DataBase.MP);
        this.parseMessungen(DataBase.MM);
        this.parseMessungen(DataBase.MK);
        this.parseMessungen(DataBase.ME);
        this.parseMessungen(DataBase.MV);
        this.parseBedingungen(DataBase.BH);
        this.parseBedingungen(DataBase.BB);
        this.parseLinien(DataBase.FLST);
        this.parseLinien(DataBase.NUTZ);
        this.parseLinien(DataBase.BODEN);
        this.parseLinien(DataBase.GEB);
        this.parseLinien(DataBase.TOP);
        super.setProgress(90);
        Object object = DataBase.T.elements();
        while (object.hasMoreElements()) {
            punktContainer = (TrafoSystem)object.nextElement();
            for (int i = 0; i < ((DataContainer)punktContainer).size(); ++i) {
                TrafoPunkt trafoPunkt = (TrafoPunkt)((DataContainer)punktContainer).elementAt(i);
                trafoPunkt.setPunkt((Punkt)DataBase.P.get(trafoPunkt.getPunkt().nr));
            }
        }
        object = DataBase.BEM.elements();
        while (object.hasMoreElements()) {
            punktContainer = (Bemerkung)object.nextElement();
            ((Bemerkung)punktContainer).p1 = ((Bemerkung)punktContainer).p1 != null && ((Bemerkung)punktContainer).p1.nr != 0L ? (Punkt)DataBase.P.get(((Bemerkung)punktContainer).p1.nr) : null;
            if (((Bemerkung)punktContainer).p2 != null && ((Bemerkung)punktContainer).p2.nr != 0L) {
                ((Bemerkung)punktContainer).p2 = (Punkt)DataBase.P.get(((Bemerkung)punktContainer).p2.nr);
                continue;
            }
            ((Bemerkung)punktContainer).p2 = null;
        }
        super.setProgress(95);
        this.db.setArea(-1);
        object = new MessungParser(this.db);
        ((MessungParser)object).referMessungen();
        ((MessungParser)object).referBedingungen();
        ((MessungParser)object).computeInternPunkte();
        ((MessungParser)object).initGeom();
        ((MessungParser)object).computeFlstAreaExtends();
        super.setProgress(100);
    }

    private void parseMessungen(DataContainerTable dataContainerTable) {
        Enumeration enumeration = dataContainerTable.dataObjects();
        while (enumeration.hasMoreElements()) {
            Messung messung = (Messung)enumeration.nextElement();
            messung.ps = messung.ps != null && messung.ps.nr > 0L ? (Punkt)DataBase.P.get(messung.ps.nr) : null;
            if (messung.pz != null && messung.pz.nr > 0L) {
                messung.pz = (Punkt)DataBase.P.get(messung.pz.nr);
                continue;
            }
            messung.pz = null;
        }
    }

    private void parseLinien(DataContainerTable dataContainerTable) {
        Enumeration enumeration = dataContainerTable.dataObjects();
        while (enumeration.hasMoreElements()) {
            Linie linie = (Linie)enumeration.nextElement();
            linie.pa = linie.pa != null && linie.pa.nr > 0L ? (Punkt)DataBase.P.get(linie.pa.nr) : null;
            if (linie.pe != null && linie.pe.nr > 0L) {
                linie.pe = (Punkt)DataBase.P.get(linie.pe.nr);
                continue;
            }
            linie.pe = null;
        }
    }

    private void parseBedingungen(DataContainerTable dataContainerTable) {
        Enumeration enumeration = dataContainerTable.dataObjects();
        while (enumeration.hasMoreElements()) {
            Bedingung bedingung = (Bedingung)enumeration.nextElement();
            bedingung.p1 = bedingung.p1 != null && bedingung.p1.nr != 0L ? (Punkt)DataBase.P.get(bedingung.p1.nr) : null;
            bedingung.p2 = bedingung.p2 != null && bedingung.p2.nr != 0L ? (Punkt)DataBase.P.get(bedingung.p2.nr) : null;
            if (bedingung.p3 != null && bedingung.p3.nr != 0L) {
                bedingung.p3 = (Punkt)DataBase.P.get(bedingung.p3.nr);
                continue;
            }
            bedingung.p3 = null;
        }
    }
}

