/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.geom.DPolygon;
import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.Bedingung;
import de.geocalc.kafplot.Bemerkung;
import de.geocalc.kafplot.BodenSchaetzung;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.ErrorObject;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.FlurstueckArt;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.GebaeudeKennzeichen;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.Grundbuchblatt;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KafPlotVersion;
import de.geocalc.kafplot.KatAmt;
import de.geocalc.kafplot.KoordinatenSystem;
import de.geocalc.kafplot.Lagegenauigkeit;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.MessungGewicht;
import de.geocalc.kafplot.Nutzung;
import de.geocalc.kafplot.NutzungsArt;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.TopObject;
import de.geocalc.kafplot.TrafoGewicht;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.VermarkungsArt;
import de.geocalc.kafplot.io.IFileWriter;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.kpv.KpvIOProperties;
import de.geocalc.util.IntegerHashList;
import de.geocalc.util.LongHashList;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

public class KpvWriter
extends IFileWriter {
    public static final String TITLE = "KpvWriter";
    public static final String VERSION = "1.0";
    protected DataBase db;
    private IntegerHashList usedGemeinden = new IntegerHashList();
    DataOutputStream f;
    private boolean doClose = true;

    public KpvWriter(File file, DataBase dataBase) {
        super(file);
        if (file.exists()) {
            file.delete();
        }
        this.db = dataBase;
        this.setParameter();
        try {
            this.f = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public KpvWriter(OutputStream outputStream, DataBase dataBase, boolean bl) {
        super((File)null);
        this.doClose = bl;
        this.db = dataBase;
        this.setParameter();
        try {
            this.f = new DataOutputStream(outputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setParameter() {
    }

    private boolean intersectFlags(Enumeration enumeration, GObject gObject) {
        while (enumeration.hasMoreElements()) {
            GObject gObject2 = (GObject)enumeration.nextElement();
            if (!gObject2.isTempFlag1() || !gObject2.contains(gObject.y, gObject.x)) continue;
            return true;
        }
        return false;
    }

    private void setObjectPunktFlag(GObject gObject, boolean bl) {
        Enumeration enumeration = gObject.elements();
        while (enumeration.hasMoreElements()) {
            Linie linie = (Linie)enumeration.nextElement();
            if (linie.pa != null) {
                linie.pa.setTempFlag1(bl);
            }
            if (linie.pe == null) continue;
            linie.pa.setTempFlag1(bl);
        }
    }

    @Override
    public void write() throws IFileOutputException {
        Object object;
        boolean bl;
        boolean bl2 = bl = KpvIOProperties.getAreaSwitch() == 0;
        if (bl) {
            KpvWriter kpvWriter = this;
            if (kpvWriter.db.hasMenge()) {
                bl = false;
            }
        }
        if (!bl) {
            Object object2;
            block84: {
                int n;
                super.setProgress(0);
                Enumeration enumeration = DataBase.P.elements();
                while (enumeration.hasMoreElements()) {
                    ((Punkt)enumeration.nextElement()).setTempFlag1(false);
                }
                super.setProgress(5);
                if (KpvIOProperties.getAreaSwitch() == 1) {
                    n = 0;
                    int n2 = 0;
                    while (true) {
                        Flurstueck flurstueck;
                        block85: {
                            int n3;
                            int n4;
                            if (n2 >= DataBase.FLST.size()) break block84;
                            flurstueck = (Flurstueck)DataBase.FLST.elementAt(n2);
                            int n5 = flurstueck.getArt();
                            flurstueck.setTempFlag1(false);
                            if (FlurstueckArt.isGemarkung(n5)) {
                                n4 = n2 + 1;
                                while (true) {
                                    if (n4 >= DataBase.FLST.size()) break block85;
                                    object2 = (Flurstueck)DataBase.FLST.elementAt(n4);
                                    n3 = ((Flurstueck)object2).getArt();
                                    if (((Flurstueck)object2).getGemarkung() > flurstueck.getGemarkung()) break block85;
                                    if (FlurstueckArt.isFlurstueck(n3) && FlurstueckArt.getFortf(n3) != 0) {
                                        flurstueck.setTempFlag1(true);
                                        break block85;
                                    }
                                    ++n4;
                                }
                            }
                            if (FlurstueckArt.isFlur(n5)) {
                                n4 = n2 + 1;
                                while (true) {
                                    if (n4 >= DataBase.FLST.size()) break block85;
                                    object2 = (Flurstueck)DataBase.FLST.elementAt(n4);
                                    n3 = ((Flurstueck)object2).getArt();
                                    if (((Flurstueck)object2).getGemarkung() > flurstueck.getGemarkung() || ((Flurstueck)object2).getFlur() != flurstueck.getFlur()) break block85;
                                    if (FlurstueckArt.isFlurstueck(n3) && FlurstueckArt.getFortf(n3) != 0) {
                                        flurstueck.setTempFlag1(true);
                                        break block85;
                                    }
                                    ++n4;
                                }
                            }
                            if (FlurstueckArt.isVereinigungstueck(n5)) {
                                flurstueck.setTempFlag1(true);
                            } else if (FlurstueckArt.isFlurstueck(n5)) {
                                if (FlurstueckArt.getFortf(n5) != 0) {
                                    flurstueck.setTempFlag1(true);
                                    n = 1;
                                } else {
                                    n = 0;
                                }
                            } else if (FlurstueckArt.isTeilstueck(n5)) {
                                flurstueck.setTempFlag1(n != 0);
                            } else if (FlurstueckArt.isNutzung(n5)) {
                                flurstueck.setTempFlag1(n != 0);
                            }
                        }
                        if (flurstueck.isTempFlag1()) {
                            this.setObjectPunktFlag(flurstueck, true);
                        }
                        ++n2;
                    }
                }
                if (KpvIOProperties.getAreaSwitch() == 2) {
                    n = 0;
                    while (true) {
                        if (n < DataBase.FLST.size()) {
                            Flurstueck flurstueck = (Flurstueck)DataBase.FLST.elementAt(n);
                            boolean bl3 = KpvIOProperties.hasGemarkung(flurstueck.getGemarkung());
                            flurstueck.setTempFlag1(bl3);
                            if (bl3) {
                                this.setObjectPunktFlag(flurstueck, bl3);
                            }
                            n += 1;
                            continue;
                        }
                        break;
                    }
                } else {
                    KpvWriter kpvWriter = this;
                    if (kpvWriter.db.hasMenge()) {
                        enumeration = DataBase.MENGE.elements();
                        while (enumeration.hasMoreElements()) {
                            ((Punkt)enumeration.nextElement()).setTempFlag1(true);
                        }
                        n = 0;
                        while (true) {
                            if (n < DataBase.FLST.size()) {
                                Flurstueck flurstueck = (Flurstueck)DataBase.FLST.elementAt(n);
                                int n6 = flurstueck.getArt();
                                if (!FlurstueckArt.isGemarkung(n6) && !FlurstueckArt.isFlur(n6)) {
                                    PunktTable punktTable = flurstueck.getPunkte();
                                    if (punktTable.intersect(DataBase.MENGE)) {
                                        flurstueck.setTempFlag1(true);
                                        this.setObjectPunktFlag(flurstueck, true);
                                    }
                                }
                                n += 1;
                                continue;
                            }
                            break;
                        }
                    } else {
                        n = 0;
                        while (true) {
                            if (n >= DataBase.FLST.size()) break;
                            Flurstueck flurstueck = (Flurstueck)DataBase.FLST.elementAt(n);
                            int n7 = flurstueck.getArt();
                            flurstueck.setTempFlag1(true);
                            this.setObjectPunktFlag(flurstueck, true);
                            n += 1;
                        }
                    }
                }
            }
            super.setProgress(20);
            KpvWriter kpvWriter = this;
            object = kpvWriter.db.gebaeude();
            while (object.hasMoreElements()) {
                GObject gObject = (GObject)object.nextElement();
                KpvWriter kpvWriter2 = this;
                boolean bl4 = this.intersectFlags(kpvWriter2.db.flurstuecke(), gObject);
                gObject.setTempFlag1(bl4);
                if (!bl4) continue;
                this.setObjectPunktFlag(gObject, bl4);
            }
            super.setProgress(30);
            KpvWriter kpvWriter3 = this;
            object = kpvWriter3.db.topObjekte();
            while (object.hasMoreElements()) {
                GObject gObject = (GObject)object.nextElement();
                KpvWriter kpvWriter4 = this;
                boolean bl5 = this.intersectFlags(kpvWriter4.db.flurstuecke(), gObject);
                gObject.setTempFlag1(bl5);
                if (!bl5) continue;
                this.setObjectPunktFlag(gObject, bl5);
            }
            super.setProgress(35);
            KpvWriter kpvWriter5 = this;
            object = kpvWriter5.db.messungen();
            while (object.hasMoreElements()) {
                Messung messung = (Messung)object.nextElement();
                if (messung.ps != null) {
                    messung.ps.setTempFlag1(true);
                }
                if (messung.pz == null) continue;
                messung.pz.setTempFlag1(true);
            }
            super.setProgress(40);
            KpvWriter kpvWriter6 = this;
            object = kpvWriter6.db.allBedingungen();
            while (object.hasMoreElements()) {
                Bedingung bedingung = (Bedingung)object.nextElement();
                if (bedingung.p1 != null) {
                    bedingung.p1.setTempFlag1(true);
                }
                if (bedingung.p2 != null) {
                    bedingung.p2.setTempFlag1(true);
                }
                if (bedingung.p3 == null) continue;
                bedingung.p3.setTempFlag1(true);
            }
            super.setProgress(45);
            object = DataBase.T.elements();
            while (object.hasMoreElements()) {
                TrafoSystem trafoSystem = (TrafoSystem)object.nextElement();
                Enumeration enumeration = trafoSystem.elements();
                while (enumeration.hasMoreElements()) {
                    TrafoPunkt trafoPunkt = (TrafoPunkt)enumeration.nextElement();
                    trafoPunkt.getPunkt().setTempFlag1(true);
                }
            }
            super.setProgress(50);
            object = new PunktTable();
            Enumeration enumeration = DataBase.P.elements();
            while (enumeration.hasMoreElements()) {
                Punkt punkt = (Punkt)enumeration.nextElement();
                if (punkt.isTempFlag1()) continue;
                ((LongHashList)object).put(punkt);
            }
            int n = Math.max(DataBase.FLST.size() / 10, 1);
            int n8 = 50;
            int n9 = 0;
            while (true) {
                if (n9 >= DataBase.FLST.size()) break;
                Flurstueck flurstueck = (Flurstueck)DataBase.FLST.elementAt(n9);
                if (flurstueck.isTempFlag1() && (object2 = flurstueck.getPolygon()) != null) {
                    Enumeration enumeration2 = ((LongHashList)object).elements();
                    while (enumeration2.hasMoreElements()) {
                        Punkt punkt = (Punkt)enumeration2.nextElement();
                        if (!((DPolygon)object2).contains(punkt)) continue;
                        punkt.setTempFlag1(true);
                        ((LongHashList)object).remove(punkt);
                    }
                }
                if (n9 % n == 0) {
                    super.setProgress(n8 += 5);
                }
                ++n9;
            }
            if (KpvIOProperties.getAreaSwitch() != 1 && KpvIOProperties.getAreaSwitch() != 2) {
                KpvWriter kpvWriter7 = this;
                if (kpvWriter7.db.hasMenge()) {
                    n9 = 0;
                    while (true) {
                        if (n9 >= DataBase.FLST.size()) break;
                        Flurstueck flurstueck = (Flurstueck)DataBase.FLST.elementAt(n9);
                        int n10 = flurstueck.getArt();
                        if (FlurstueckArt.isGemarkung(n10) || FlurstueckArt.isFlur(n10)) {
                            PunktTable punktTable = flurstueck.getPunkte();
                            if (punktTable.intersect(DataBase.MENGE)) {
                                flurstueck.setTempFlag1(true);
                                this.setObjectPunktFlag(flurstueck, true);
                            }
                        }
                        ++n9;
                    }
                }
            }
        }
        try {
            super.setProgress(0);
            this.f.writeBytes("#KafPlotViewer");
            this.f.writeInt(204);
            this.f.writeLong(KafPlotVersion.getDataLizenzNummer());
            KafPlotIOConstants.writeString(this.f, KafPlotVersion.LIZENZ_NM);
            KafPlotIOConstants.writeString(this.f, DataBase.projekt);
            KafPlotIOConstants.writeString(this.f, DataBase.kafDatVersion);
            KafPlotIOConstants.writeString(this.f, DataBase.vermStelle);
            KafPlotIOConstants.writeString(this.f, DataBase.adresse_1);
            KafPlotIOConstants.writeString(this.f, DataBase.adresse_2);
            KafPlotIOConstants.writeString(this.f, DataBase.adresse_3);
            KafPlotIOConstants.writeString(this.f, DataBase.bearbeiter);
            KafPlotIOConstants.writeString(this.f, DataBase.gemeinde);
            KafPlotIOConstants.writeString(this.f, DataBase.gemarkung);
            KafPlotIOConstants.writeString(this.f, DataBase.flur);
            KafPlotIOConstants.writeString(this.f, DataBase.flurstueck);
            KafPlotIOConstants.writeString(this.f, DataBase.katasterAmt);
            KafPlotIOConstants.writeString(this.f, DataBase.antrag);
            this.f.writeDouble(DataBase.xmin);
            this.f.writeDouble(DataBase.ymin);
            this.f.writeDouble(DataBase.xmax);
            this.f.writeDouble(DataBase.ymax);
            KpvWriter kpvWriter = this;
            this.f.writeDouble(kpvWriter.db.getGelHoehe());
            this.f.writeDouble(DataBase.emax);
            this.f.writeDouble(DataBase.vmax);
            this.f.writeDouble(DataBase.zmax);
            this.f.writeDouble(DataBase.amax);
            this.f.writeDouble(DataBase.smax);
            this.f.writeDouble(DataBase.tvmax);
            this.f.writeDouble(DataBase.trmax);
            this.f.writeDouble(DataBase.maxAreaProportion);
            this.f.writeDouble(DataBase.maxAreaDifference);
            this.f.writeDouble(KoordinatenSystem.getMinimumArea(150));
            this.f.writeDouble(KoordinatenSystem.getMaximumArea(150));
            this.f.writeDouble(KoordinatenSystem.getMinimumArea(489));
            this.f.writeDouble(KoordinatenSystem.getMaximumArea(489));
            super.setProgress(5);
            PunktParameter.writeObjects(this.f);
            LinieParameter.writeObjects(this.f);
            MessungGewicht.writeObjects(this.f);
            TrafoGewicht.writeObjects(this.f);
            object = DataBase.P.elements();
            while (object.hasMoreElements()) {
                Punkt punkt = (Punkt)object.nextElement();
                if (!bl && !punkt.isTempFlag1()) continue;
                punkt.writeObject(this.f);
            }
            super.setProgress(10);
            object = DataBase.MG.elements();
            while (object.hasMoreElements()) {
                this.f.writeByte(21);
                ((Riss)object.nextElement()).writeObject(this.f);
            }
            object = DataBase.MP.elements();
            while (object.hasMoreElements()) {
                this.f.writeByte(22);
                ((Riss)object.nextElement()).writeObject(this.f);
            }
            object = DataBase.MM.elements();
            while (object.hasMoreElements()) {
                this.f.writeByte(23);
                ((Riss)object.nextElement()).writeObject(this.f);
            }
            super.setProgress(15);
            object = DataBase.MK.elements();
            while (object.hasMoreElements()) {
                this.f.writeByte(24);
                ((Riss)object.nextElement()).writeObject(this.f);
            }
            object = DataBase.ME.elements();
            while (object.hasMoreElements()) {
                this.f.writeByte(25);
                ((Riss)object.nextElement()).writeObject(this.f);
            }
            object = DataBase.MV.elements();
            while (object.hasMoreElements()) {
                this.f.writeByte(26);
                ((Riss)object.nextElement()).writeObject(this.f);
            }
            super.setProgress(20);
            object = DataBase.T.elements();
            while (object.hasMoreElements()) {
                TrafoSystem trafoSystem = (TrafoSystem)object.nextElement();
                trafoSystem.writeObject(this.f);
            }
            super.setProgress(25);
            object = DataBase.BB.elements();
            while (object.hasMoreElements()) {
                this.f.writeByte(28);
                ((Riss)object.nextElement()).writeObject(this.f);
            }
            object = DataBase.BH.elements();
            while (object.hasMoreElements()) {
                this.f.writeByte(27);
                ((Riss)object.nextElement()).writeObject(this.f);
            }
            super.setProgress(30);
            object = DataBase.FLST.elements();
            while (object.hasMoreElements()) {
                Flurstueck flurstueck = (Flurstueck)object.nextElement();
                if (!bl && !flurstueck.isTempFlag1()) continue;
                this.f.writeByte(52);
                flurstueck.writeObject(this.f);
                Gemarkung gemarkung = Gemarkung.getGemarkung(flurstueck.getGemarkung());
                if (gemarkung == null) continue;
                this.usedGemeinden.put(gemarkung.getGemeinde());
            }
            super.setProgress(40);
            object = DataBase.BUCH.elements();
            while (object.hasMoreElements()) {
                this.f.writeByte(57);
                ((Grundbuchblatt)object.nextElement()).writeObject(this.f);
            }
            super.setProgress(50);
            object = DataBase.NUTZ.elements();
            while (object.hasMoreElements()) {
                this.f.writeByte(55);
                ((Nutzung)object.nextElement()).writeObject(this.f);
            }
            super.setProgress(60);
            object = DataBase.BODEN.elements();
            while (object.hasMoreElements()) {
                this.f.writeByte(59);
                ((BodenSchaetzung)object.nextElement()).writeObject(this.f);
            }
            super.setProgress(70);
            object = DataBase.GEB.elements();
            while (object.hasMoreElements()) {
                Gemeinde gemeinde;
                Gebaeude gebaeude = (Gebaeude)object.nextElement();
                if (!bl && !gebaeude.isTempFlag1()) continue;
                this.f.writeByte(53);
                gebaeude.writeObject(this.f);
                GebaeudeKennzeichen gebaeudeKennzeichen = gebaeude.getLeitzeichen();
                if (gebaeudeKennzeichen == null || (gemeinde = Gemeinde.getGemeinde(gebaeudeKennzeichen.getGemeinde())) == null) continue;
                this.usedGemeinden.put(gemeinde);
            }
            super.setProgress(80);
            object = DataBase.TOP.elements();
            while (object.hasMoreElements()) {
                TopObject topObject = (TopObject)object.nextElement();
                if (!bl && !topObject.isTempFlag1()) continue;
                this.f.writeByte(56);
                topObject.writeObject(this.f);
            }
            object = DataBase.BEM.elements();
            while (object.hasMoreElements()) {
                Bemerkung bemerkung = (Bemerkung)object.nextElement();
                if (!bl && (bemerkung.p1 == null || !bemerkung.p1.isTempFlag1()) || !bl && bemerkung.p2 != null && !bemerkung.p2.isTempFlag1()) continue;
                this.f.writeByte(17);
                bemerkung.writeObject(this.f);
            }
            if (KpvIOProperties.writeErrors()) {
                object = DataBase.ERR.elements();
                while (object.hasMoreElements()) {
                    ErrorObject errorObject = (ErrorObject)object.nextElement();
                    this.f.writeByte(92);
                    errorObject.writeObject(this.f);
                }
            }
            super.setProgress(85);
            object = VermarkungsArt.elements();
            while (object.hasMoreElements()) {
                this.f.writeByte(76);
                ((VermarkungsArt)object.nextElement()).writeObject(this.f);
            }
            object = NutzungsArt.elements();
            while (object.hasMoreElements()) {
                this.f.writeByte(75);
                ((NutzungsArt)object.nextElement()).writeObject(this.f);
            }
            object = this.usedGemeinden.elements();
            while (object.hasMoreElements()) {
                this.f.writeByte(71);
                ((Gemeinde)object.nextElement()).writeObject(this.f);
            }
            if (DataBase.katasterAmt != null) {
                object = KatAmt.getKatAmt(DataBase.katasterAmt);
                if (object != null) {
                    this.f.writeByte(74);
                    ((KatAmt)object).writeObject(this.f);
                }
            }
            object = Lagegenauigkeit.elements();
            while (object.hasMoreElements()) {
                this.f.writeByte(77);
                ((Lagegenauigkeit)object.nextElement()).writeObject(this.f);
            }
            super.setProgress(95);
            this.f.writeByte(111);
            KafPlotProperties.writeThemes(this.f);
            KafPlotProperties.writeObject(this.f);
            this.f.writeByte(-1);
            if (this.doClose) {
                this.f.close();
            }
            KpvIOProperties.flushTables();
            super.setProgress(100);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IFileOutputException(exception.getMessage());
        }
        catch (Error error) {
            error.printStackTrace();
        }
    }
}

