/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.io.KpvReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class KpzReader
extends KpvReader {
    private ZipInputStream zip;

    public KpzReader(File file, DataBase dataBase) throws IFileInputException {
        this(file, dataBase, null);
    }

    public KpzReader(File file, DataBase dataBase, IProgressViewer iProgressViewer) throws IFileInputException {
        super(file, dataBase, iProgressViewer);
        try {
            this.zip = new ZipInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IFileInputException("Datei " + file.getName() + " nicht gefunden");
        }
        if (file != null) {
            this.fileLength = file.length();
        }
    }

    public KpzReader(URL uRL, DataBase dataBase, IProgressViewer iProgressViewer) throws IFileInputException {
        super(uRL, dataBase, iProgressViewer);
        try {
            this.zip = new ZipInputStream(uRL.openStream());
        }
        catch (IOException iOException) {
            throw new IFileInputException("Datei " + uRL.getFile() + " nicht gefunden");
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            this.fileLength = uRLConnection.getContentLength();
            if (this.fileLength < 0L) {
                this.fileLength = 0L;
            }
        }
        catch (IOException iOException) {
            throw new IFileInputException("Datei " + uRL.getFile() + " konnte nicht ge\u00f6ffnet werden");
        }
    }

    @Override
    public void read() throws IFileInputException {
        try {
            ZipEntry zipEntry = this.zip.getNextEntry();
            if (zipEntry != null) {
                this.in = new DataInputStream(this.zip);
                super.read();
            }
        }
        catch (IFileInputException iFileInputException) {
            throw iFileInputException;
        }
        catch (Exception exception) {
            throw new IFileInputException(exception.getMessage());
        }
    }
}

