/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DatContainer;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainerTable;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.io.IFileWriter;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class KpzusWriter
extends IFileWriter {
    private static final String VERSION = "1.4";
    private static String fileVersionDelim = "-";
    protected DataBase db;
    protected PunktTable P;
    protected boolean isCorrectSaved = false;

    public KpzusWriter(File file, DataBase dataBase) {
        super(file);
        this.db = dataBase;
    }

    @Override
    public void write() throws IFileOutputException {
        this.isCorrectSaved = false;
        PrintWriter printWriter = null;
        KafkaIOProperties.init();
        KafkaIOProperties.datVersion = 2;
        KafkaIOProperties.writeFullParameter = false;
        this.P = this.createPunktTable();
        KafkaIOProperties.setMenge(this.P);
        if (!KafkaIOProperties.writeMenge && !KafkaIOProperties.writeOffline || KafkaIOProperties.writeMenge) {
            // empty if block
        }
        try {
            printWriter = this.createWriter();
            printWriter.println("#KafPlot Zusatzdaten");
            printWriter.println("C!KafDatVersion: 1.4");
            this.setProgress(10);
            printWriter.println("#Flurstuecke");
            DataBase.FLST.writeDatContainer(printWriter);
            this.setProgress(30);
            printWriter.println("#Gebaeude");
            DataBase.GEB.writeDatContainer(printWriter);
            this.setProgress(50);
            printWriter.println("#Topographie");
            DataBase.TOP.writeDatContainer(printWriter);
            this.setProgress(60);
            printWriter.println("#Bemerkungen");
            DataBase.BEM.writeDatContainer(printWriter);
            this.setProgress(70);
            printWriter.println("#Nummerierungsbezirke");
            DataBase.NB.writeDatContainer(printWriter);
            this.setProgress(75);
            printWriter.println("#Punktidentit\u00e4ten");
            DataBase.P_IDENT.writeDatContainer(printWriter);
            this.setProgress(80);
            printWriter.println("#Umnummerierungsliste");
            Vector vector = new Vector();
            Enumeration enumeration = this.P.elements();
            while (enumeration.hasMoreElements()) {
                Punkt punkt = (Punkt)enumeration.nextElement();
                if (!this.punktFilter.isPunktEnabled(punkt)) continue;
                this.insert(vector, punkt);
            }
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                printWriter.println(((Punkt)enumeration.nextElement()).toUmnumLine());
            }
            this.setProgress(100);
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
        finally {
            try {
                printWriter.close();
                this.isCorrectSaved = true;
            }
            catch (Exception exception) {}
        }
    }

    public boolean isCorrectSaved() {
        return this.isCorrectSaved;
    }

    private void writeDatContainer(PrintWriter printWriter, DataContainerTable dataContainerTable) throws IOException {
        Enumeration enumeration = dataContainerTable.elements();
        while (enumeration.hasMoreElements()) {
            ((DatContainer)enumeration.nextElement()).writeDatContainer(printWriter);
        }
    }

    private void insert(Vector vector, Punkt punkt) {
        if (vector.size() > 0) {
            Punkt punkt2 = (Punkt)vector.lastElement();
            if (punkt.nr > punkt2.nr) {
                vector.addElement(punkt);
            } else {
                vector.addElement(punkt2);
                for (int i = vector.size() - 2; i >= 0; --i) {
                    punkt2 = (Punkt)vector.elementAt(i);
                    if (punkt.nr > punkt2.nr) {
                        vector.setElementAt(punkt, i + 1);
                        return;
                    }
                    vector.setElementAt(punkt2, i + 1);
                }
                vector.setElementAt(punkt, 0);
            }
        } else {
            vector.addElement(punkt);
        }
    }

    protected PunktTable createPunktTable() {
        Enumeration enumeration;
        PunktTable punktTable = new PunktTable();
        Enumeration enumeration2 = KafkaIOProperties.writeMenge ? DataBase.MENGE.elements() : (enumeration = DataBase.P.elements());
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (!KafkaIOProperties.writeOffline && !punkt.isOn()) continue;
            punktTable.put(punkt);
        }
        return punktTable;
    }
}

