/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.io.IPolarReader;
import de.geocalc.kafplot.io.NivMessung;
import de.geocalc.kafplot.io.PolarMessung;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class LeicaPolarReader
extends IPolarReader {
    private static final String DA_ERROR = "ung\u00fcltige Datenkennung in Spalte 1-2";
    private static String stationKennung = "FS000000";
    private static int stpktCode = -1;
    private static int stpktWordIdent = -1;
    private static int ignore3DCode = 205;
    private boolean ignore3D = false;
    private static final double NIV_GEN = 0.002;
    int anzZpk = 0;
    long pns = 0L;

    public LeicaPolarReader(File file, Vector vector) {
        super(file, vector, null);
    }

    public LeicaPolarReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
    }

    public static void setStationKennung(String string) {
        stationKennung = string;
    }

    public static String getStationKennung() {
        return stationKennung;
    }

    public static void setStandpunktCodeIdent(int n, int n2) {
        stpktCode = n;
        stpktWordIdent = n2;
    }

    public static void setStandpunktCode(int n) {
        stpktCode = n;
    }

    public static void setStandpunktIdent(int n) {
        stpktWordIdent = n;
    }

    @Override
    protected PolarMessung lineToPolarMessung(String string) throws IFileInputException, IOException {
        if (string.length() < 15) {
            return null;
        }
        PolarMessung polarMessung = new PolarMessung();
        int n = 0;
        try {
            n = Integer.parseInt(string.substring(0, 2));
        }
        catch (Exception exception) {
            throw new IFileInputException(DA_ERROR);
        }
        if (n == 11) {
            int n2 = -16;
            while (n2 + 18 < string.length()) {
                if (string.charAt(n2 += 16) == ' ') continue;
                switch (Integer.parseInt(string.substring(n2, n2 + 2))) {
                    case 11: {
                        polarMessung.pnz = this.readPunktNummer(string, n2, n2 + 15);
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 18: 
                    case 19: {
                        break;
                    }
                    case 21: {
                        polarMessung.r = this.readBlockValue(string, n2, n2 + 15);
                        break;
                    }
                    case 22: {
                        polarMessung.z = this.readBlockValue(string, n2, n2 + 15);
                        break;
                    }
                    case 25: {
                        this.anzZpk = 0;
                        this.pns = polarMessung.pnz;
                        return null;
                    }
                    case 31: {
                        polarMessung.s = this.readBlockValue(string, n2, n2 + 15);
                        break;
                    }
                    case 32: {
                        if (polarMessung.s != 0.0) break;
                        polarMessung.s = this.readBlockValue(string, n2, n2 + 15);
                        break;
                    }
                    case 33: {
                        polarMessung.dh = this.readBlockValue(string, n2, n2 + 23);
                        polarMessung.nivCode = Integer.parseInt(string.substring(n2 + 2, n2 + 3));
                        break;
                    }
                    case 41: {
                        break;
                    }
                    case 83: {
                        if (polarMessung.r != 0.0 || polarMessung.z != 100.0 || polarMessung.s != 0.0 || polarMessung.dh != 0.0) break;
                        return null;
                    }
                }
            }
            if (this.anzZpk == 0) {
                polarMessung.pns = this.pns;
            }
            ++this.anzZpk;
        } else {
            if (n == 41) {
                if (string.length() >= 31) {
                    if (stpktCode >= 0 && stpktWordIdent >= 0) {
                        int n3 = 0;
                        try {
                            n3 = Integer.parseInt(string.substring(7, 15));
                        }
                        catch (Exception exception) {
                            return null;
                        }
                        if (n3 == stpktCode) {
                            int n4 = -16;
                            while (n4 + 18 < string.length()) {
                                int n5;
                                if (string.charAt(n4 += 16) == ' ' || (n5 = Integer.parseInt(string.substring(n4, n4 + 2))) != stpktWordIdent) continue;
                                this.pns = this.readPunktNummer(string, n4, n4 + 15);
                                this.anzZpk = 0;
                            }
                            return null;
                        }
                    }
                    if (stationKennung != null && string.substring(23, 31).startsWith(stationKennung)) {
                        this.anzZpk = 0;
                        this.pns = Long.MAX_VALUE;
                        return null;
                    }
                } else {
                    return new PolarMessung("NivellementsLinie");
                }
                return null;
            }
            if (n == 50 || n == 51) {
                return null;
            }
            throw new IFileInputException(DA_ERROR);
        }
        return polarMessung;
    }

    private int readCodeNummer(String string, int n, int n2) {
        return Integer.parseInt(string.substring(n + 7, n + 15));
    }

    private long readPunktNummer(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n + 7; i < n2; ++i) {
            if (!Character.isDigit(string.charAt(i))) continue;
            stringBuffer.append(string.charAt(i));
        }
        return Long.parseLong(stringBuffer.toString());
    }

    private double readBlockValue(String string, int n, int n2) throws IFileInputException {
        double d = new Double(string.substring(n + 6, n + 15));
        switch (Integer.parseInt(string.substring(n + 5, n + 6))) {
            case 0: {
                d /= 1000.0;
                break;
            }
            case 6: {
                d /= 10000.0;
                break;
            }
            case 2: 
            case 8: {
                d /= 100000.0;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                throw new IFileInputException("ung\u00fcltige Ma\u00dfeinheit im Datensatz Spalte " + n + "-" + n2);
            }
        }
        return d;
    }

    @Override
    protected void syncronisierePolarMessungen() {
        int n = -1;
        Vector<Object> vector = new Vector<Object>();
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = 0;
        for (int i = 0; i < this.M.size(); ++i) {
            PolarMessung polarMessung = (PolarMessung)this.M.elementAt(i);
            if (polarMessung.ma == 5) {
                vector.addElement(new NivMessung(polarMessung.kommentar));
                continue;
            }
            if (polarMessung.ma != 1) continue;
            if (polarMessung.nivCode == 0) {
                if (polarMessung.pns != 0L) {
                    if (polarMessung.pns == Long.MAX_VALUE) {
                        n = i;
                    } else if (n != -1) {
                        var20_14 = (PolarMessung)this.M.elementAt(n);
                        ((PolarMessung)var20_14).pns = polarMessung.pns;
                    }
                }
            } else if (polarMessung.nivCode == 1) {
                if (polarMessung.pnz == 0L) {
                    d += polarMessung.dh;
                    d2 += polarMessung.s;
                } else {
                    l = polarMessung.pnz;
                    d = polarMessung.dh;
                    d2 = polarMessung.s;
                    n2 = 0;
                }
            } else if (polarMessung.nivCode == 6) {
                d3 -= polarMessung.dh;
                d4 += polarMessung.s;
                l3 = polarMessung.pnz;
            } else if (polarMessung.nivCode == 3 || polarMessung.nivCode == 4) {
                var20_14 = new NivMessung(n2 == 0 ? l : 0L, polarMessung.pnz, d - polarMessung.dh, d2 + polarMessung.s, 0.002, 0.002);
                vector.addElement(var20_14);
                ++n2;
            } else if (polarMessung.nivCode == 2) {
                if (polarMessung.pnz == 0L) {
                    d -= polarMessung.dh;
                    d2 += polarMessung.s;
                } else {
                    var20_14 = new NivMessung(n2 == 0 ? l : 0L, polarMessung.pnz, d - polarMessung.dh, d2 + polarMessung.s, 0.002, 0.002);
                    vector.addElement(var20_14);
                    ++n2;
                }
            } else if (polarMessung.nivCode == 5) {
                d3 += polarMessung.dh;
                d4 += polarMessung.s;
                if (polarMessung.pnz != 0L) {
                    l2 = polarMessung.pnz;
                }
                if (l3 != 0L) {
                    var20_14 = new NivMessung(l2, l3, d3, d4, 0.002, 0.002);
                    vector.addElement(var20_14);
                    d3 = 0.0;
                    d4 = 0.0;
                }
            }
            if (polarMessung.z != 100.0 || polarMessung.r != 0.0) continue;
            polarMessung.ma = -1;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.M.addElement(enumeration.nextElement());
        }
    }
}

