/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.io.GpsMessung;
import de.geocalc.kafplot.io.IGpsReader;
import de.geocalc.text.IFormat;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class LqpReader
extends IGpsReader {
    Vector P = null;
    Hashtable pHash = new Hashtable();
    private boolean waitForRover = false;
    private Punkt p = null;

    public LqpReader(File file, Vector vector, Vector vector2) {
        super(file, vector2, null);
        this.P = vector;
    }

    public LqpReader(File file, Vector vector, Vector vector2, IProgressViewer iProgressViewer) {
        super(file, vector2, iProgressViewer);
        this.P = vector;
    }

    private long parsePnr(String string) {
        try {
            return Long.parseLong(string);
        }
        catch (Exception exception) {
            String string2 = IFormat.getNumbers(string);
            this.addException(new Exception("Ung\u00fcltige Punktnummer: " + string + ", wandle in: " + string2));
            return Long.parseLong(string2);
        }
    }

    @Override
    protected GpsMessung lineToGpsMessung(String string) throws IFileInputException, IOException {
        string = string.trim();
        if (!this.waitForRover && (string.startsWith("RTCM-Ref ") || string.startsWith("TCM-Ref "))) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            try {
                this.p = new Punkt();
                stringTokenizer.nextToken();
                this.p.nr = this.parsePnr(stringTokenizer.nextToken());
                this.p.y = Double.parseDouble(stringTokenizer.nextToken());
                this.p.x = Double.parseDouble(stringTokenizer.nextToken());
                this.p.h = Float.parseFloat(stringTokenizer.nextToken());
                Punkt punkt = this.pHash.put(new Long(this.p.nr), this.p);
                if (punkt == null) {
                    this.P.addElement(this.p);
                } else if (punkt.y != this.p.y || punkt.x != this.p.x || punkt.h != this.p.h) {
                    this.addException(new Exception("Punkt " + this.p.nr + " mit unterschiedlichen Koordinaten enthalten"));
                    this.P.addElement(this.p);
                }
            }
            catch (Exception exception) {
                throw new IFileInputException("Ung\u00fcltige Werte f\u00fcr Referenzpunkt");
            }
            this.waitForRover = true;
            return null;
        }
        if (this.waitForRover && this.p != null) {
            GpsMessung gpsMessung = new GpsMessung();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            try {
                gpsMessung.pns = this.p.nr;
                gpsMessung.pnz = this.parsePnr(stringTokenizer.nextToken());
                gpsMessung.y = Double.parseDouble(stringTokenizer.nextToken()) - this.p.y;
                gpsMessung.x = Double.parseDouble(stringTokenizer.nextToken()) - this.p.x;
                gpsMessung.z = Double.parseDouble(stringTokenizer.nextToken()) - (double)this.p.h;
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                double d = Double.parseDouble(stringTokenizer.nextToken());
                if (d == -1.0) {
                    gpsMessung.z = 0.0;
                }
            }
            catch (Exception exception) {
                throw new IFileInputException("Ung\u00fcltige Werte f\u00fcr Messpunkt");
            }
            this.waitForRover = false;
            return gpsMessung;
        }
        this.waitForRover = false;
        this.p = null;
        return null;
    }

    @Override
    protected void parseMessungen() {
        Object object;
        Object object2 = null;
        Enumeration enumeration = this.M.elements();
        while (enumeration.hasMoreElements()) {
            object = (GpsMessung)enumeration.nextElement();
            double d = Math.sqrt(((GpsMessung)object).y * ((GpsMessung)object).y + ((GpsMessung)object).x * ((GpsMessung)object).x);
            double d2 = d / LqpReader.getSA() / 100000.0;
            if ((d2 *= d2) < 1.0E-5) {
                this.addException(new Exception("Die Basisl\u00e4nge " + ((GpsMessung)object).toString() + " ist zu kurz.\n    Die Gewichte werden auf das m\u00f6gliche Minimum gesetzt"));
                d2 = 1.0E-5;
            } else if (d2 > 99999.0) {
                this.addException(new Exception("Die Basisl\u00e4nge " + ((GpsMessung)object).toString() + " ist zu lang.\n    Die Gewichte werden auf das m\u00f6gliche Maximum gesetzt"));
                d2 = 99999.0;
            }
            ((GpsMessung)object).py = d2;
            ((GpsMessung)object).px = d2;
            if (object2 != null) {
                if (((GpsMessung)object2).pns == ((GpsMessung)object).pns) {
                    ((GpsMessung)object).pns = 0L;
                    continue;
                }
                object2 = object;
                continue;
            }
            object2 = object;
        }
        enumeration = this.P.elements();
        while (enumeration.hasMoreElements()) {
            object = (Punkt)enumeration.nextElement();
            if (!(((Punkt)object).y < 3000000.0)) continue;
            ((Punkt)object).y += 3000000.0;
        }
    }
}

