/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.Bedingung;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.Stat;
import de.geocalc.kafplot.Stat2;
import de.geocalc.kafplot.Stat4;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.io.IDataReader;
import de.geocalc.text.IFormat;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Hashtable;

public class Lt2Reader
extends IDataReader {
    private static final boolean debug = false;
    private static final double ARC = 0.015707963267948967;
    private static final int HEADER = -1;
    private static final int KOORDINATENAEND = 1;
    private static final int ORTHOLINIE = 2;
    private static final int ORTHOPUNKT = 3;
    private static final int SPANNMASSE = 4;
    private static final int POLARSTECKEN = 5;
    private static final int RICHTUNGSMESSUNG = 6;
    private static final int KOODIFFERENZEN = 7;
    private static final int TRANSFORMATION = 8;
    private static final int BED_GERADEN = 10;
    private static final int BED_RWINKEL = 11;
    private static final int BED_PARALLEL = 12;
    private static final int BED_A_PUNKT_PUNKT = 13;
    private static final int BED_A_PUNKT_LINIE = 14;
    private static final int BED_KREIS = 15;
    private static final int BEWEGL_PUNKTE = 20;
    private static final int STATISTIK = 97;
    private static final int KVZ = 98;
    private static final int VOID = 99;
    private static final int HAS_VALUE = 0;
    private static final int NOT_CONTROL = 1;
    private static final int NET_DEFEKT = 2;
    private static final long LP = 1000000000000000L;
    private static final long SP = -1000000000000000L;
    private static final char NEW_PAGE = '\f';
    private int PB0 = 0;
    private int PB1 = 18;
    private int PB2 = 24;
    private int PB3 = 30;
    private int PB4 = 36;
    private int PB5 = 42;
    private int PB6 = 47;
    private int PB7 = 52;
    private int PB8 = 58;
    private int PB9 = 64;
    private int PB10 = 71;
    private int PB11 = 78;
    private int TP0 = 0;
    private int TP1 = 9;
    private int TP2 = 11;
    private int TP3 = 26;
    private int TP4 = 33;
    private int TP5 = 40;
    private int TP6 = 48;
    private int TP7 = 53;
    private int TP8 = 61;
    private int TP9 = 69;
    private int TP10 = 78;
    private int MLK = 10;
    private int MLKS = 22;
    private int ML0 = 15;
    private int ML1 = 19;
    private int ML2 = 25;
    private int ML3 = 39;
    private int ML4 = 45;
    private int ML5 = 59;
    private int ML6 = 71;
    private int ML7 = 79;
    private int ML20 = 32;
    private int ML21 = 40;
    private int ML22 = 52;
    private int ML23 = 57;
    private int MO0 = 0;
    private int MO1 = 18;
    private int MO2 = 20;
    private int MO3 = 30;
    private int MO4 = 38;
    private int MO5 = 40;
    private int MO6 = 47;
    private int MO7 = 51;
    private int MO8 = 55;
    private int MO9 = 60;
    private int MO10 = 65;
    private int MO11 = 72;
    private int MS0 = 14;
    private int MS1 = 29;
    private int MS2 = 42;
    private int MS3 = 48;
    private int MP0 = 0;
    private int MP1 = 15;
    private int MP2 = 24;
    private int MP3 = 33;
    private int MP4 = 40;
    private int MP5 = 45;
    private int MP6 = 50;
    private int MP7 = 54;
    private int MP8 = 59;
    private int MP9 = 62;
    private int MP10 = 67;
    private int MP11 = 72;
    private int MP12 = 78;
    private int MM0 = 0;
    private int MM1 = 6;
    private int MM2 = 21;
    private int MM3 = 36;
    private int MM4 = 45;
    private int MM5 = 51;
    private int MM6 = 55;
    private int MM7 = 59;
    private int MM8 = 62;
    private int MM9 = 66;
    private int MM10 = 71;
    private int MM11 = 78;
    private int MD0 = 0;
    private int MD1 = 6;
    private int MD2 = 21;
    private int MD3 = 36;
    private int MD4 = 45;
    private int MD5 = 51;
    private int MD6 = 55;
    private int MD7 = 59;
    private int MD8 = 62;
    private int MD9 = 66;
    private int MD10 = 71;
    private int MD11 = 78;
    private int BG0 = 0;
    private int BG1 = 11;
    private int BG2 = 26;
    private int BG3 = 35;
    private int BG4 = 44;
    private int BG5 = 49;
    private int BG6 = 54;
    private int BG7 = 61;
    private int BG8 = 68;
    private int BG9 = 75;
    private int BA0 = 0;
    private int BA1 = 6;
    private int BA2 = 21;
    private int BA3 = 36;
    private int BA4 = 44;
    private int BA5 = 50;
    private int BA6 = 54;
    private int BA7 = 58;
    private int BA8 = 64;
    private int BA9 = 71;
    private int BA10 = 78;
    private int BL0 = 0;
    private int BL1 = 6;
    private int BL2 = 21;
    private int BL3 = 36;
    private int BL4 = 44;
    private int BL5 = 50;
    private int BL6 = 54;
    private int BL7 = 58;
    private int BL8 = 64;
    private int BL9 = 71;
    private int BL10 = 78;
    private int BP0 = 0;
    private int BP1 = 6;
    private int BP2 = 21;
    private int BP3 = 36;
    private int BP4 = 37;
    private int BP5 = 46;
    private int BP6 = 52;
    private int BP7 = 56;
    private int BP8 = 60;
    private int BP9 = 65;
    private int BP10 = 71;
    private int BP11 = 78;
    private int BK0 = 0;
    private int BK1 = 6;
    private int BK2 = 21;
    private int BK3 = 36;
    private int BK4 = 44;
    private int BK5 = 50;
    private int BK6 = 54;
    private int BK7 = 60;
    private int BK8 = 69;
    private int BK9 = 78;
    public static String S_NK = "N.K.";
    public static String S_ND = "NETZDEFEKT";
    private DataBase db = null;
    private Hashtable stats = new Hashtable();
    private Hashtable keys = new Hashtable();
    private Hashtable rStats = new Hashtable();
    private Hashtable rKeys = new Hashtable();
    private Hashtable bStats = new Hashtable();
    private Hashtable bKeys = new Hashtable();
    private static int C_HEADER = 4;
    private static int C_ORTHO_HEADER = 3;
    private int version = 0;
    private int readErrCount = 0;
    private int ordErrCount = 0;
    private LineNumberReader reader = null;

    private void adjustVersion(int n) {
        if (n >= 7500) {
            this.PB0 = 0;
            this.PB1 = 20;
            this.PB2 = 26;
            this.PB3 = 32;
            this.PB4 = 38;
            this.PB5 = 44;
            this.PB6 = 49;
            this.PB7 = 54;
            this.PB8 = 60;
            this.PB9 = 66;
            this.PB10 = 73;
            this.PB11 = 80;
            this.TP0 = 0;
            this.TP1 = 9;
            this.TP2 = 11;
            this.TP3 = 28;
            this.TP4 = 35;
            this.TP5 = 42;
            this.TP6 = 50;
            this.TP7 = 55;
            this.TP8 = 63;
            this.TP9 = 71;
            this.TP10 = 80;
            this.MLK = 10;
            this.MLKS = 22;
            this.ML0 = 15;
            this.ML1 = 19;
            this.ML2 = 25;
            this.ML3 = 41;
            this.ML4 = 47;
            this.ML5 = 63;
            this.ML6 = 75;
            this.ML7 = 83;
            this.ML20 = 32;
            this.ML21 = 40;
            this.ML22 = 52;
            this.ML23 = 57;
            this.MO0 = 0;
            this.MO1 = 18;
            this.MO2 = 20;
            this.MO3 = 30;
            this.MO4 = 38;
            this.MO5 = 40;
            this.MO6 = 47;
            this.MO7 = 51;
            this.MO8 = 55;
            this.MO9 = 60;
            this.MO10 = 65;
            this.MO11 = 72;
            this.MS0 = 14;
            this.MS1 = 31;
            this.MS2 = 44;
            this.MS3 = 50;
            this.MP0 = 0;
            this.MP1 = 17;
            this.MP2 = 26;
            this.MP3 = 35;
            this.MP4 = 42;
            this.MP5 = 47;
            this.MP6 = 52;
            this.MP7 = 56;
            this.MP8 = 61;
            this.MP9 = 64;
            this.MP10 = 69;
            this.MP11 = 74;
            this.MP12 = 80;
            this.MM0 = 0;
            this.MM1 = 6;
            this.MM2 = 23;
            this.MM3 = 40;
            this.MM4 = 49;
            this.MM5 = 55;
            this.MM6 = 59;
            this.MM7 = 63;
            this.MM8 = 66;
            this.MM9 = 70;
            this.MM10 = 75;
            this.MM11 = 82;
            this.MD0 = 0;
            this.MD1 = 6;
            this.MD2 = 23;
            this.MD3 = 40;
            this.MD4 = 50;
            this.MD5 = 55;
            this.MD6 = 60;
            this.MD7 = 64;
            this.MD8 = 66;
            this.MD9 = 70;
            this.MD10 = 75;
            this.MD11 = 82;
            this.BG0 = 0;
            this.BG1 = 11;
            this.BG2 = 28;
            this.BG3 = 37;
            this.BG4 = 46;
            this.BG5 = 51;
            this.BG6 = 56;
            this.BG7 = 63;
            this.BG8 = 70;
            this.BG9 = 77;
            this.BA0 = 0;
            this.BA1 = 6;
            this.BA2 = 23;
            this.BA3 = 40;
            this.BA4 = 48;
            this.BA5 = 54;
            this.BA6 = 58;
            this.BA7 = 62;
            this.BA8 = 68;
            this.BA9 = 75;
            this.BA10 = 82;
            this.BL0 = 0;
            this.BL1 = 6;
            this.BL2 = 21;
            this.BL3 = 38;
            this.BL4 = 46;
            this.BL5 = 52;
            this.BL6 = 56;
            this.BL7 = 60;
            this.BL8 = 66;
            this.BL9 = 73;
            this.BL10 = 80;
            this.BP0 = 0;
            this.BP1 = 6;
            this.BP2 = 23;
            this.BP3 = 40;
            this.BP4 = 41;
            this.BP5 = 50;
            this.BP6 = 56;
            this.BP7 = 60;
            this.BP8 = 64;
            this.BP9 = 69;
            this.BP10 = 75;
            this.BP11 = 82;
            this.BK0 = 0;
            this.BK1 = 6;
            this.BK2 = 23;
            this.BK3 = 40;
            this.BK4 = 48;
            this.BK5 = 54;
            this.BK6 = 58;
            this.BK7 = 64;
            this.BK8 = 73;
            this.BK9 = 82;
        }
    }

    public Lt2Reader(File file, DataBase dataBase, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.db = dataBase;
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
        }
    }

    @Override
    public void read() throws IFileInputException {
        int n = 99;
        String string = null;
        try {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            boolean bl = false;
            boolean bl2 = false;
            this.reader = this.createReader();
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            double d = 0.0;
            double d2 = 0.0;
            int n6 = 0;
            long l6 = 0L;
            Stat stat = null;
            Stat stat2 = null;
            while ((string = this.reader.readLine()) != null) {
                int n7;
                int n8 = string.length();
                if (n8 > 0 && string.charAt(0) == '\f') {
                    n = 99;
                    n2 = 0;
                    ++n3;
                    n4 += C_HEADER;
                    continue;
                }
                ++n2;
                if (n4 > 0) {
                    --n4;
                    continue;
                }
                if (n == 99) {
                    if (n8 == 0) continue;
                    String string2 = string.trim();
                    if (string2.startsWith("KAFKA-G") && this.version == 0) {
                        int n9 = string2.indexOf("VERSION");
                        if (n9 < 0) continue;
                        n7 = n9 + 8;
                        int n10 = Math.min(string2.length(), string2.indexOf(" ", n7));
                        if (n10 <= n7) continue;
                        this.version = (int)(new Double(string2.substring(n7, n10).trim()) * 1000.0);
                        this.adjustVersion(this.version);
                    } else if (n3 == 0) {
                        if (string2.startsWith("AUSWERTUNG HYBRIDER LAGEVERMESSUNGEN (ROBUSTE SCHAETZUNG)")) {
                            return;
                        }
                    } else if (string2.startsWith("KOORDINATENAENDERUNGEN")) {
                        n = 1;
                    } else if (string2.startsWith("SPANNMASSE UND STRECKEN")) {
                        n = 4;
                    } else if (string2.startsWith("POLARE STRECKEN")) {
                        n = 5;
                    } else if (string2.startsWith("ERGEBNISSE RICHTUNGSMESSUNG")) {
                        n = 6;
                        n4 = 5;
                    } else if (string2.startsWith("KOORDINATENDIFFERENZEN")) {
                        n = 7;
                        n4 = 7;
                    } else if (string2.startsWith("2-PARAMETER TRANSFORMATION")) {
                        n = 8;
                    } else if (string2.startsWith("3-PARAMETER TRANSFORMATION")) {
                        n = 8;
                    } else if (string2.startsWith("4-PARAMETER TRANSFORMATION")) {
                        n = 8;
                    } else if (string2.startsWith("5-PARAMETER TRANSFORMATION")) {
                        n = 8;
                    } else if (string2.startsWith("6-PARAMETER TRANSFORMATION")) {
                        n = 8;
                    } else if (string2.startsWith("DIREKTE KOORDINATENBEOBACHT")) {
                        n = 8;
                    } else if (string2.startsWith("GERADEN")) {
                        n = 10;
                        n4 = 6;
                    } else if (string2.startsWith("RECHTE WINKEL")) {
                        n = 11;
                        n4 = 6;
                    } else if (string2.startsWith("PARALLELITAETEN")) {
                        n = 12;
                        n4 = 6;
                    } else if (string2.startsWith("ABSTAENDE (PUNKT-PUNKT)")) {
                        n = 13;
                        n4 = 5;
                    } else if (string2.startsWith("ABSTAENDE (PUNKT-LINIE)")) {
                        n = 14;
                        n4 = 5;
                    } else if (string2.startsWith("KREISKONTINUITAETEN")) {
                        n = 15;
                        n4 = 5;
                    } else if (string2.startsWith("KOORDINATENVERZEICHNIS")) {
                        n = 98;
                    } else if (string2.startsWith("BEWEGLICHE ANSCHLUSSPUNKTE")) {
                        n = 20;
                    } else if (!string2.startsWith("AUFFELDERUNGSPUNKTE")) {
                        if (string2.startsWith("STATISTI")) {
                            n = 97;
                        } else if (string2.startsWith("LINIENPUNKT")) {
                            n = 3;
                        } else if (string2.startsWith("===")) {
                            n = 99;
                        } else if (string2.startsWith("---")) {
                            n = 99;
                        } else if (n8 > this.MLK && string.startsWith("LINIE ", this.MLK)) {
                            l6 = this.s(string, this.ML0, this.ML1);
                            l2 = this.l(string, this.ML2, this.ML3);
                            l4 = this.l(string, this.ML4, this.ML5);
                            try {
                                d = this.d(string, this.ML6, this.ML7);
                            }
                            catch (Exception exception) {
                                d = 0.0;
                            }
                            stat2 = new Stat2();
                            Long l7 = new Long(1000000000000000L * l6 + l2);
                            this.stats.put(l7, stat2);
                            this.keys.put(l7, new Match(this, l2, 0L));
                            n = 2;
                        }
                    }
                    bl = false;
                    bl2 = false;
                    stat = null;
                    continue;
                }
                try {
                    if (bl2) continue;
                    if (n == 20) {
                        if (n8 < this.PB5 || !Character.isDigit(string.charAt(this.PB1 - 1))) continue;
                        l2 = this.l(string, this.PB0, this.PB1);
                        Punkt punkt = (Punkt)DataBase.P.get(l2);
                        if (punkt == null) {
                            ++this.ordErrCount;
                            continue;
                        }
                        Stat2 stat22 = new Stat2();
                        stat22.setV(1, this.s(string, this.PB1, this.PB2));
                        stat22.setV(2, this.s(string, this.PB2, this.PB3));
                        stat22.setSaV(1, (short)(punkt.g * 1000.0f));
                        stat22.setSaV(2, (short)(punkt.g * 1000.0f));
                        stat22.setSaN(1, this.s(string, this.PB4, this.PB5));
                        stat22.setSaN(2, this.s(string, this.PB4, this.PB5));
                        stat22.setEv(1, this.s(string, this.PB5, this.PB6));
                        stat22.setEv(2, this.s(string, this.PB6, this.PB7));
                        n7 = this.getState(string, this.PB7);
                        if (n7 == 0) {
                            stat22.setNv(1, this.s(string, this.PB7, this.PB8, 10.0));
                            stat22.setNv(2, this.s(string, this.PB8, this.PB9, 10.0));
                            stat22.setGf(1, this.s(string, this.PB9, this.PB10, 1000.0));
                            stat22.setGf(2, this.s(string, this.PB10, this.PB11, 1000.0));
                        } else if (n7 == 2) {
                            stat22.setNv(1, (short)Short.MAX_VALUE);
                            stat22.setGf(1, (short)Short.MAX_VALUE);
                            stat22.setNv(2, (short)Short.MAX_VALUE);
                            stat22.setGf(2, (short)Short.MAX_VALUE);
                        }
                        punkt.setStatistik(stat22);
                    } else if (n == 4 || n == 5) {
                        if (n8 < this.MM4) continue;
                        if (!Character.isDigit(string.charAt(this.MM1 - 1))) {
                            bl2 = bl;
                            continue;
                        }
                        Integer n11 = new Integer(this.s(string, this.MM0, this.MM1));
                        if (string.charAt(this.MM2 - 1) != ' ') {
                            l2 = this.l(string, this.MM1, this.MM2);
                        }
                        l3 = this.l(string, this.MM2, this.MM3);
                        bl = true;
                        Stat stat3 = new Stat();
                        this.stats.put(n11, stat3);
                        this.keys.put(n11, new Match(this, l2, l3));
                        stat3.setV(1, this.s(string, this.MM4, this.MM5));
                        stat3.setSaV(1, this.s(string, this.MM5, this.MM6));
                        stat3.setSaN(1, this.s(string, this.MM6, this.MM7));
                        stat3.setEv(1, this.s(string, this.MM7, this.MM8));
                        stat3.setEp(1, this.s(string, this.MM8, this.MM9));
                        n7 = this.getState(string, this.MM9);
                        if (n7 == 0) {
                            stat3.setNv(1, this.s(string, this.MM9, this.MM10, 10.0));
                            stat3.setGf(1, this.s(string, this.MM10, this.MM11, 1000.0));
                        } else if (n7 == 2) {
                            stat3.setNv(1, (short)Short.MAX_VALUE);
                            stat3.setGf(1, (short)Short.MAX_VALUE);
                        }
                    } else if (n == 6) {
                        if (n8 < this.MM4 || n8 < this.MS3) continue;
                        if (string.charAt(this.MS0 - 1) == ':' && string.charAt(this.MS2 - 1) == ':') {
                            l2 = this.l(string, this.MS0, this.MS1);
                            n6 = (int)this.l(string, this.MS2, this.MS3) - 1;
                            n4 = 1;
                            continue;
                        }
                        if (!Character.isDigit(string.charAt(this.MP1 - 1))) {
                            bl2 = bl;
                            continue;
                        }
                        bl = true;
                        l3 = this.l(string, this.MP0, this.MP1);
                        Stat stat4 = new Stat();
                        Integer n12 = new Integer(++n6);
                        this.rStats.put(n12, stat4);
                        this.rKeys.put(n12, new Match(this, l2, l3));
                        double d3 = 1.0;
                        d3 = (double)this.s(string, this.MP7, this.MP8) * 1000.0;
                        stat4.setSaV(1, this.s(string, this.MP4, this.MP5, d3, true));
                        stat4.setSaN(1, this.s(string, this.MP5, this.MP6, d3, true));
                        stat4.setV(1, this.s(string, this.MP6, this.MP7));
                        stat4.setEv(1, this.s(string, this.MP8, this.MP9));
                        stat4.setEp(1, this.s(string, this.MP9, this.MP10));
                        var33_60 = this.getState(string, this.MP10);
                        if (var33_60 == 0) {
                            stat4.setNv(1, this.s(string, this.MP10, this.MP11, 10.0));
                            stat4.setGf(1, this.s(string, this.MP11, this.MP12, d3, true));
                        } else if (var33_60 == 2) {
                            stat4.setNv(1, (short)Short.MAX_VALUE);
                            stat4.setGf(1, (short)Short.MAX_VALUE);
                        }
                    } else if (n == 7) {
                        if (n8 < this.MD4 || bl2) {
                            if (!bl) continue;
                            bl2 = true;
                            continue;
                        }
                        Stat stat5 = null;
                        int n13 = 0;
                        if (Character.isDigit(string.charAt(this.MD1 - 1)) && Character.isDigit(string.charAt(this.MD2 - 1)) && Character.isDigit(string.charAt(this.MD3 - 1))) {
                            bl = true;
                            stat5 = new Stat2();
                            Integer n14 = new Integer(this.s(string, this.MD0, this.MD1));
                            l2 = this.l(string, this.MD1, this.MD2);
                            l3 = this.l(string, this.MD2, this.MD3);
                            this.stats.put(n14, stat5);
                            this.keys.put(n14, new Match(this, l2, l3));
                            n13 = 1;
                            stat = stat5;
                        } else {
                            stat5 = stat;
                            n13 = 2;
                        }
                        stat5.setV(n13, this.s(string, this.MD4, this.MD5));
                        stat5.setSaV(n13, this.s(string, this.MD5, this.MD6));
                        stat5.setSaN(n13, this.s(string, this.MD6, this.MD7));
                        stat5.setEv(n13, this.s(string, this.MD7, this.MD8));
                        stat5.setEp(n13, this.s(string, this.MD8, this.MD9));
                        int n15 = this.getState(string, this.MD9);
                        if (n15 == 0) {
                            stat5.setNv(n13, this.s(string, this.MD9, this.MD10, 10.0));
                            stat5.setGf(n13, this.s(string, this.MD10, this.MD11, 1000.0));
                        } else if (n15 == 2) {
                            stat5.setNv(n13, (short)Short.MAX_VALUE);
                            stat5.setGf(n13, (short)Short.MAX_VALUE);
                        }
                    } else if (n == 2) {
                        if (n8 < this.ML1) {
                            n = 99;
                            continue;
                        }
                        if (string.startsWith("MASSST", this.MLK)) {
                            stat2.setV(1, this.s(string, this.ML20, this.ML21, 1000.0));
                            stat2.setEv(1, this.s(string, this.ML22, this.ML23, 1.0));
                        } else if (string.startsWith("SA", this.MLKS)) {
                            stat2.setSaV(1, this.s(string, this.ML20, this.ML21, 1000.0));
                            stat2.setNv(1, this.s(string, this.ML22, this.ML23, 10.0));
                            stat2.setEp(1, (short)0);
                        }
                    } else if (n == 3) {
                        if (n8 <= this.MO5) continue;
                        if (string.indexOf("----") >= 0) {
                            n = 99;
                            continue;
                        }
                        boolean bl3 = false;
                        boolean bl4 = false;
                        if (Character.isDigit(string.charAt(this.MO1 - 1))) {
                            bl3 = true;
                            bl4 = true;
                        } else if (Character.isDigit(string.charAt(this.MO3 - 1))) {
                            bl3 = true;
                            bl4 = false;
                        } else if (string.charAt(this.MO5 - 1) == 'G' || string.charAt(this.MO5 - 1) == 'R') {
                            bl3 = false;
                            bl4 = true;
                        }
                        if (!bl3 && !bl4) continue;
                        n7 = 0;
                        Stat stat6 = null;
                        if (bl3) {
                            Long l8;
                            if (bl4) {
                                l2 = this.l(string, this.MO0, this.MO1);
                                l8 = new Long(1000000000000000L * l6 + l2);
                            } else {
                                l3 = this.l(string, this.MO2, this.MO3);
                                l8 = new Long(-1000000000000000L * l6 + l3);
                            }
                            stat6 = new Stat2();
                            this.stats.put(l8, stat6);
                            this.keys.put(l8, new Match(this, l2, 0L));
                            stat = stat6;
                            n7 = 1;
                        } else {
                            stat6 = stat;
                            n7 = 2;
                        }
                        stat6.setV(n7, this.s(string, this.MO5, this.MO6));
                        stat6.setSaV(n7, this.s(string, this.MO6, this.MO7));
                        stat6.setEv(n7, this.s(string, this.MO7, this.MO8));
                        stat6.setEp(n7, this.s(string, this.MO8, this.MO9));
                        var33_60 = this.getState(string, this.MO9);
                        if (var33_60 == 0) {
                            stat6.setNv(n7, this.s(string, this.MO9, this.MO10, 10.0));
                            stat6.setGf(n7, this.s(string, this.MO10, this.MO11, 1000.0));
                        } else if (var33_60 == 2) {
                            stat6.setNv(n7, (short)Short.MAX_VALUE);
                            stat6.setGf(n7, (short)Short.MAX_VALUE);
                        }
                        if (bl3 && bl4 && l2 == l4) {
                            double d4 = 0.0;
                            try {
                                d4 = this.d(string, this.MO3, this.MO4) - d;
                                stat2.setV(1, (short)((double)stat2.getV(1) * (d4 / 100.0)));
                                stat2.setSaV(1, (short)((double)stat2.getSaV(1) * (d4 / 100.0)));
                            }
                            catch (Exception exception) {}
                        }
                    } else if (n == 8) {
                        if (string.length() < this.TP3) {
                            if (bl) {
                                n = 99;
                            }
                            bl2 = bl;
                            bl = false;
                            continue;
                        }
                        if (!bl && n8 > this.TP2 && Character.isDigit(string.charAt(this.TP1 - 1)) && string.charAt(this.TP2 - 1) == 'R') {
                            bl = true;
                        }
                        if (bl) {
                            Stat stat7 = null;
                            int n16 = 0;
                            if (Character.isDigit(string.charAt(this.TP1 - 1))) {
                                Integer n17 = new Integer(this.i(string, this.TP0, this.TP1));
                                stat7 = new Stat2();
                                n16 = 1;
                                l2 = this.l(string, this.TP2, this.TP3);
                                this.stats.put(n17, stat7);
                                this.keys.put(n17, new Match(this, l2, 0L));
                                stat7.setSaV(n16, this.s(string, this.TP4, this.TP5));
                                stat = stat7;
                            } else {
                                stat7 = stat;
                                n16 = 2;
                                stat7.setSaV(n16, stat7.getSaV(n16 - 1));
                            }
                            stat7.setV(n16, this.s(string, this.TP5, this.TP6));
                            stat7.setEv(n16, this.s(string, this.TP6, this.TP7));
                            stat7.setEp(n16, this.s(string, this.TP7, this.TP8));
                            int n18 = this.getState(string, this.TP8);
                            if (n18 == 0) {
                                stat7.setNv(n16, this.s(string, this.TP8, this.TP9, 10.0));
                                stat7.setGf(n16, this.s(string, this.TP9, this.TP10, 1000.0));
                            } else if (n18 == 2) {
                                stat7.setNv(n16, (short)Short.MAX_VALUE);
                                stat7.setGf(n16, (short)Short.MAX_VALUE);
                            }
                        }
                    } else if (n == 10 || n == 11) {
                        if (n8 <= this.BG1) {
                            if (n5 >= 1) {
                                n = 99;
                                n5 = 0;
                                continue;
                            }
                            ++n5;
                            continue;
                        }
                        n5 = 0;
                        if (n8 > this.BG2 && Character.isDigit(string.charAt(this.BG1 - 1)) && Character.isDigit(string.charAt(this.BG2 - 1))) {
                            Integer n19 = new Integer(this.i(string, this.BG0, this.BG1));
                            Stat stat8 = new Stat();
                            l3 = this.l(string, this.BG1, this.BG2);
                            this.bStats.put(n19, stat8);
                            this.bKeys.put(n19, new Match(this, 0L, l3));
                            stat8.setV(1, this.s(string, this.BG3, this.BG4));
                            stat8.setSaV(1, this.s(string, this.BG4, this.BG5));
                            stat8.setEv(1, this.s(string, this.BG5, this.BG6));
                            stat8.setEp(1, this.s(string, this.BG6, this.BG7));
                            n7 = this.getState(string, this.BG7);
                            if (n7 == 0) {
                                stat8.setNv(1, this.s(string, this.BG7, this.BG8, 10.0));
                                stat8.setGf(1, this.s(string, this.BG8, this.BG9, 1000.0));
                            } else if (n7 == 2) {
                                stat8.setNv(1, (short)Short.MAX_VALUE);
                                stat8.setGf(1, (short)Short.MAX_VALUE);
                            }
                        }
                    } else if (n == 13) {
                        if (n8 <= this.BA1) {
                            if (n5 >= 1) {
                                n = 99;
                                n5 = 0;
                                continue;
                            }
                            ++n5;
                            continue;
                        }
                        n5 = 0;
                        if (n8 > this.BA3 && Character.isDigit(string.charAt(this.BA1 - 1)) && Character.isDigit(string.charAt(this.BA3 - 1))) {
                            Integer n20 = new Integer(this.i(string, this.BA0, this.BA1));
                            Stat stat9 = new Stat();
                            l3 = this.l(string, this.BA2, this.BA3);
                            this.bStats.put(n20, stat9);
                            this.bKeys.put(n20, new Match(this, 0L, l3));
                            stat9.setV(1, this.s(string, this.BA4, this.BA5));
                            stat9.setSaV(1, this.s(string, this.BA5, this.BA6));
                            stat9.setEv(1, this.s(string, this.BA6, this.BA7));
                            stat9.setEp(1, this.s(string, this.BA7, this.BA8));
                            n7 = this.getState(string, this.BA8);
                            if (n7 == 0) {
                                stat9.setNv(1, this.s(string, this.BA8, this.BA9, 10.0));
                                stat9.setGf(1, this.s(string, this.BA9, this.BA10, 1000.0));
                            } else if (n7 == 2) {
                                stat9.setNv(1, (short)Short.MAX_VALUE);
                                stat9.setGf(1, (short)Short.MAX_VALUE);
                            }
                        }
                    } else if (n == 14) {
                        if (n8 <= this.BL1) {
                            if (n5 >= 1) {
                                n = 99;
                                n5 = 0;
                                continue;
                            }
                            ++n5;
                            continue;
                        }
                        n5 = 0;
                        if (n8 > this.BL3 && Character.isDigit(string.charAt(this.BL1 - 1)) && Character.isDigit(string.charAt(this.BL3 - 1))) {
                            Integer n21 = new Integer(this.i(string, this.BL0, this.BL1));
                            Stat stat10 = new Stat();
                            l3 = this.l(string, this.BL2, this.BL3);
                            this.bStats.put(n21, stat10);
                            this.bKeys.put(n21, new Match(this, 0L, 0L, l3));
                            stat10.setV(1, this.s(string, this.BL4, this.BL5));
                            stat10.setSaV(1, this.s(string, this.BL5, this.BL6));
                            stat10.setEv(1, this.s(string, this.BL6, this.BL7));
                            stat10.setEp(1, this.s(string, this.BL7, this.BL8));
                            n7 = this.getState(string, this.BL8);
                            if (n7 == 0) {
                                stat10.setNv(1, this.s(string, this.BL8, this.BL9, 10.0));
                                stat10.setGf(1, this.s(string, this.BL9, this.BL10, 1000.0));
                            } else if (n7 == 2) {
                                stat10.setNv(1, (short)Short.MAX_VALUE);
                                stat10.setGf(1, (short)Short.MAX_VALUE);
                            }
                        }
                    } else if (n == 12) {
                        if (n8 <= this.BP1) {
                            if (n5 >= 1) {
                                n = 99;
                                n5 = 0;
                                continue;
                            }
                            ++n5;
                            continue;
                        }
                        n5 = 0;
                        if (n8 <= this.BP4) continue;
                        Stat stat11 = null;
                        int n22 = 0;
                        if (Character.isDigit(string.charAt(this.BP1 - 1)) && Character.isDigit(string.charAt(this.BP2 - 1)) && Character.isDigit(string.charAt(this.BP3 - 1)) && string.charAt(this.BP4 - 1) == 'P') {
                            Integer n23 = new Integer(this.i(string, this.BP0, this.BP1));
                            l2 = this.l(string, this.BP1, this.BA2);
                            l3 = this.l(string, this.BP2, this.BA3);
                            stat11 = new Stat2();
                            this.bStats.put(n23, stat11);
                            this.bKeys.put(n23, new Match(this, l2, l3));
                            n22 = 1;
                            stat = stat11;
                        } else {
                            if (!Character.isDigit(string.charAt(this.BP1 - 1)) || string.charAt(this.BP4 - 1) != 'A') continue;
                            stat11 = stat;
                            n22 = 2;
                        }
                        stat11.setV(n22, this.s(string, this.BP5, this.BP6));
                        stat11.setSaV(n22, this.s(string, this.BP6, this.BP7));
                        stat11.setEv(n22, this.s(string, this.BP7, this.BP8));
                        stat11.setEp(n22, this.s(string, this.BP8, this.BP9));
                        int n24 = this.getState(string, this.BP9);
                        if (n24 == 0) {
                            stat11.setNv(n22, this.s(string, this.BP9, this.BP10, 10.0));
                            stat11.setGf(n22, this.s(string, this.BP10, this.BP11, 1000.0));
                        } else if (n24 == 2) {
                            stat11.setNv(n22, (short)Short.MAX_VALUE);
                            stat11.setGf(n22, (short)Short.MAX_VALUE);
                        }
                    } else if (n == 15) {
                        if (n8 <= this.BK1) {
                            if (n5 >= 1) {
                                n = 99;
                                n5 = 0;
                                continue;
                            }
                            ++n5;
                            continue;
                        }
                        n5 = 0;
                        if (n8 <= this.BK3) continue;
                        if (Character.isDigit(string.charAt(this.BK1 - 1)) && Character.isDigit(string.charAt(this.BK3 - 1))) {
                            Stat stat12 = new Stat();
                            Integer n25 = new Integer(this.i(string, this.BK0, this.BK1));
                            l2 = this.l(string, this.BK2, this.BK3);
                            this.bStats.put(n25, stat12);
                            this.bKeys.put(n25, new Match(this, l2, 0L));
                            stat12.setV(1, this.s(string, this.BK3, this.BK4));
                            stat12.setSaV(1, this.s(string, this.BK4, this.BK5));
                            stat12.setEv(1, this.s(string, this.BK5, this.BK6));
                            stat12.setEp(1, this.s(string, this.BK6, this.BK7));
                            n7 = this.getState(string, this.BK7);
                            if (n7 == 0) {
                                stat12.setNv(1, this.s(string, this.BK7, this.BK8, 10.0));
                                stat12.setGf(1, this.s(string, this.BK8, this.BK9, 1000.0));
                            } else if (n7 == 2) {
                                stat12.setNv(1, (short)Short.MAX_VALUE);
                                stat12.setGf(1, (short)Short.MAX_VALUE);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    this.ex("Lesefehler in Zeile: " + this.reader.getLineNumber());
                    ++this.readErrCount;
                }
                super.setFileProgress(l += (long)(string.length() + 1));
            }
            this.reader.close();
        }
        catch (IOException iOException) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber(), iOException.getMessage()));
        }
        catch (Exception exception) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber(), exception.getMessage()));
            exception.printStackTrace();
        }
        this.match();
        if (this.readErrCount > 0 || this.ordErrCount > 0) {
            this.ex("\nFehler beim Laden der Datei: " + this.inFile.getName() + "\nKAFKA-Dateiversion: " + IFormat.f_3.format((double)this.version / 1000.0) + "\nes wird die KAFKA-Version ab 6.000 unterst\u00fctzt\nes sind " + this.readErrCount + " Lesefehler und " + this.ordErrCount + " Zuordnungsfehler aufgetreten\nBitte senden sie die Daten an kafplot@geocalc.de");
        }
    }

    private long l(String string, int n, int n2) {
        n2 = Math.min(string.length(), n2);
        try {
            return Long.parseLong(string.substring(n, n2).trim());
        }
        catch (Exception exception) {
            ++this.readErrCount;
            return 0L;
        }
    }

    private double d(String string, int n, int n2) {
        n2 = Math.min(string.length(), n2);
        return new Double(string.substring(n, n2).trim());
    }

    private int i(String string, int n, int n2) {
        return Integer.parseInt(string.substring(n, n2).trim());
    }

    private short s(String string, int n, int n2) {
        n2 = Math.min(string.length(), n2);
        if (n >= n2) {
            return Short.MIN_VALUE;
        }
        if (n2 < n) {
            return Short.MAX_VALUE;
        }
        String string2 = null;
        try {
            string2 = string.substring(n, n2).trim();
            if (string2.length() == 0) {
                return Short.MIN_VALUE;
            }
            int n3 = Integer.parseInt(string2);
            if (n3 < -32766) {
                return -32767;
            }
            if (n3 > 32765) {
                return 32766;
            }
            return (short)n3;
        }
        catch (Exception exception) {
            if (this.isOverflow(string2)) {
                return 32766;
            }
            ++this.readErrCount;
            return Short.MAX_VALUE;
        }
    }

    private short s(String string, int n, int n2, double d) {
        return this.s(string, n, n2, d, false);
    }

    private short s(String string, int n, int n2, double d, boolean bl) {
        n2 = Math.min(string.length(), n2);
        if (n >= n2) {
            return Short.MIN_VALUE;
        }
        if (n2 < n) {
            return Short.MAX_VALUE;
        }
        String string2 = null;
        try {
            int n3;
            string2 = string.substring(n, n2).trim();
            if (string2.length() == 0) {
                return Short.MIN_VALUE;
            }
            double d2 = new Double(string2);
            if (bl) {
                d2 = Math.tan(d2 * 0.001 * 0.015707963267948967);
            }
            if ((n3 = (int)Math.rint(d2 * d)) < -32766) {
                return -32767;
            }
            if (n3 > 32765) {
                return 32766;
            }
            return (short)n3;
        }
        catch (Exception exception) {
            if (this.isOverflow(string2)) {
                return 32766;
            }
            ++this.readErrCount;
            return Short.MAX_VALUE;
        }
    }

    private boolean isNk(String string, int n) {
        return string.indexOf(S_NK, n) >= 0;
    }

    private int getState(String string, int n) {
        if (string.indexOf(S_NK, n) >= 0) {
            return 1;
        }
        if (string.indexOf(S_ND, n) >= 0) {
            return 2;
        }
        return 0;
    }

    private boolean isOverflow(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == '*') continue;
            return false;
        }
        return true;
    }

    private void match() {
        Object object;
        Cloneable cloneable;
        int n = 0;
        int n2 = 0;
        long l = 0L;
        boolean bl = false;
        Lt2Reader lt2Reader = this;
        Enumeration enumeration = lt2Reader.db.messungen();
        while (enumeration.hasMoreElements()) {
            try {
                Object object2;
                Stat stat;
                Object object3;
                Object object4;
                cloneable = (Messung)enumeration.nextElement();
                if (((Messung)cloneable).isFehler() || !((Messung)cloneable).isOn()) continue;
                n = ((Messung)cloneable).ma == 200 ? (n += 2) : ++n;
                int n3 = ((Messung)cloneable).getMessungsArt(true);
                int n4 = ((Messung)cloneable).getWerteBelegung();
                if (n3 == 210 || n3 == 200 || n3 == 290 || n3 == 240) {
                    Number number;
                    if (n3 == 210) {
                        ++l;
                        n2 = n;
                    } else {
                        ++n2;
                    }
                    object = new Long(1000000000000000L * l + (((Messung)cloneable).pz != null ? ((Messung)cloneable).pz.nr : ((Messung)cloneable).ps.nr));
                    if (n3 == 240) {
                        Integer n5 = new Integer(++n);
                        number = n5;
                    } else {
                        number = new Long(-1000000000000000L * l + ((Messung)cloneable).ps.nr);
                    }
                    object4 = number;
                    object3 = (Stat)this.stats.get(object);
                    stat = (Stat)this.stats.get(object4);
                    if (object3 == null && ((Messung)cloneable).pz != null) {
                        object3 = (Stat)this.stats.get(new Long(1000000000000000L * l + ((Messung)cloneable).ps.nr));
                    }
                    if (n4 == 0 && (object2 = (Stat)this.rStats.get(new Integer(n2))) != null) {
                        object3 = new Stat2(null, (Stat)object2);
                    }
                    object2 = stat == null ? object3 : new Stat4((Stat)object3, stat);
                    ((Messung)cloneable).setStatistik((Stat)object2);
                    continue;
                }
                if (n3 == 230) {
                    if (((Messung)cloneable).ps != null) {
                        n2 = n;
                    }
                    object = new Integer(n);
                    object4 = new Integer(n2);
                    object3 = (Stat)this.stats.get(object);
                    stat = (Stat)this.rStats.get(object4);
                    object2 = (Match)this.keys.get(object);
                    Match match = (Match)this.rKeys.get(object4);
                    if (((Messung)cloneable).pz.getPs() != 1 && ((Messung)cloneable).pz.a == 0 && ((Messung)cloneable).pz.b == 0 && ((Messung)cloneable).pz.t == 0) {
                        if (((Messung)cloneable).ps == null) continue;
                        ++n2;
                        continue;
                    }
                    if (n4 == 1 || ((Messung)cloneable).l2 == 0.0) {
                        if (stat == null && match == null) continue;
                        if (stat == null || match == null) {
                            this.ex(((Messung)cloneable).getExceptionableName() + ", Statistik fehlt");
                            ++this.ordErrCount;
                            continue;
                        }
                        if (((Messung)cloneable).pz.nr != match.n2) {
                            this.ex(((Messung)cloneable).getExceptionableName() + ", Zuordnung falsch");
                            ++this.ordErrCount;
                            continue;
                        }
                        ((Messung)cloneable).setStatistik(stat);
                        ++n2;
                        continue;
                    }
                    if (n4 == 2) {
                        if (object3 == null || object2 == null) {
                            this.ex(((Messung)cloneable).getExceptionableName() + ", Statistik fehlt");
                            ++this.ordErrCount;
                            continue;
                        }
                        if (((Messung)cloneable).pz.nr != ((Match)object2).n2) {
                            this.ex(((Messung)cloneable).getExceptionableName() + ", Zuordnung falsch");
                            ++this.ordErrCount;
                            continue;
                        }
                        ((Messung)cloneable).setStatistik(new Stat2(null, (Stat)object3));
                        continue;
                    }
                    if (stat == null && match == null) {
                        ((Messung)cloneable).setStatistik(new Stat2(stat, (Stat)object3));
                        continue;
                    }
                    if (stat == null || match == null) {
                        this.ex(((Messung)cloneable).getExceptionableName() + ", Statistik fehlt");
                        ++this.ordErrCount;
                        continue;
                    }
                    if (object3 == null || object2 == null) {
                        this.ex(((Messung)cloneable).getExceptionableName() + ", Statistik fehlt");
                        ++this.ordErrCount;
                        continue;
                    }
                    if (((Messung)cloneable).pz.nr != match.n2) {
                        this.ex(((Messung)cloneable).getExceptionableName() + ", Zuordnung falsch");
                        ++this.ordErrCount;
                        continue;
                    }
                    if (((Messung)cloneable).pz.nr != ((Match)object2).n2) {
                        this.ex(((Messung)cloneable).getExceptionableName() + ", Zuordnung falsch");
                        ++this.ordErrCount;
                        continue;
                    }
                    ((Messung)cloneable).setStatistik(new Stat2(stat, (Stat)object3));
                    ++n2;
                    continue;
                }
                object = new Integer(n);
                object4 = (Stat)this.stats.get(object);
                if (object4 != null) {
                    object3 = (Match)this.keys.get(object);
                    if (object3 != null) {
                        if (!(((Messung)cloneable).ps != null && ((Messung)cloneable).ps.nr != ((Match)object3).n1 || ((Messung)cloneable).pz != null && ((Messung)cloneable).pz.nr != ((Match)object3).n2)) {
                            ((Messung)cloneable).setStatistik((Stat)object4);
                            continue;
                        }
                        this.ex(((Messung)cloneable).getExceptionableName() + ", Zuordnung falsch");
                        ++this.ordErrCount;
                        continue;
                    }
                    this.ex(((Messung)cloneable).getExceptionableName() + ", Zuordnung fehlt");
                    ++this.ordErrCount;
                    continue;
                }
                this.ex(((Messung)cloneable).getExceptionableName() + ", Statistik fehlt");
                ++this.ordErrCount;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Lt2Reader lt2Reader2 = this;
        enumeration = lt2Reader2.db.trafoPunkte();
        while (enumeration.hasMoreElements()) {
            Integer n6;
            Stat stat;
            cloneable = (TrafoPunkt)enumeration.nextElement();
            if (!((TrafoPunkt)cloneable).isOn()) continue;
            if ((stat = (Stat)this.stats.get(n6 = new Integer(++n))) != null) {
                object = (Match)this.keys.get(n6);
                if (object != null) {
                    if (((TrafoPunkt)cloneable).getPunkt().nr == ((Match)object).n1) {
                        ((TrafoPunkt)cloneable).setStatistik(stat);
                        continue;
                    }
                    this.ex(((TrafoPunkt)cloneable).getExceptionableName() + ", Zuordnung falsch");
                    ++this.ordErrCount;
                    continue;
                }
                this.ex(((TrafoPunkt)cloneable).getExceptionableName() + ", Zuordnung fehlt");
                ++this.ordErrCount;
                continue;
            }
            this.ex(((TrafoPunkt)cloneable).getExceptionableName() + ", Statistik fehlt");
            ++this.ordErrCount;
        }
        n = 0;
        Lt2Reader lt2Reader3 = this;
        enumeration = lt2Reader3.db.allBedingungen();
        while (enumeration.hasMoreElements()) {
            cloneable = (Bedingung)enumeration.nextElement();
            if (!((Bedingung)cloneable).isOn() || ((Bedingung)cloneable).ba == 3) continue;
            Integer n7 = new Integer(++n);
            Stat stat = (Stat)this.bStats.get(n7);
            if (((Bedingung)cloneable).ba == 6) {
                ++n;
            }
            if (stat != null) {
                object = (Match)this.bKeys.get(n7);
                if (object != null) {
                    if (((Bedingung)cloneable).ba == 6 && ((Bedingung)cloneable).p2 != null && ((Match)object).n1 == ((Bedingung)cloneable).p2.nr) {
                        ((Bedingung)cloneable).setStatistik(new Stat2(stat, (Stat)this.bStats.get(new Integer(n))));
                        continue;
                    }
                    if ((((Match)object).n1 == 0L || ((Bedingung)cloneable).p1 != null && ((Bedingung)cloneable).p1.nr == ((Match)object).n1) && (((Match)object).n2 == 0L || ((Bedingung)cloneable).p2 != null && ((Bedingung)cloneable).p2.nr == ((Match)object).n2) && (((Match)object).n3 == 0L || ((Bedingung)cloneable).p3 != null && ((Bedingung)cloneable).p3.nr == ((Match)object).n3)) {
                        ((Bedingung)cloneable).setStatistik(stat);
                        continue;
                    }
                    this.ex(((Bedingung)cloneable).getExceptionableName() + ", Zuordnung falsch");
                    ++this.ordErrCount;
                    continue;
                }
                this.ex(((Bedingung)cloneable).getExceptionableName() + ", Zuordnung fehlt");
                ++this.ordErrCount;
                continue;
            }
            this.ex(((Bedingung)cloneable).getExceptionableName() + ", Statistik fehlt");
            ++this.ordErrCount;
        }
    }

    private void ex(String string) {
        this.addException(new IFileInputException("LT2: " + string));
    }

    private class Match {
        long n1;
        long n2;
        long n3;

        public Match(Lt2Reader lt2Reader, long l, long l2) {
            this.n1 = l;
            this.n2 = l2;
        }

        public Match(Lt2Reader lt2Reader, long l, long l2, long l3) {
            this.n1 = l;
            this.n2 = l2;
            this.n3 = l3;
        }

        public String toString() {
            return this.n1 + "-" + this.n2 + "-" + this.n3;
        }
    }
}

