/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.DatLineFormat;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.io.IFreePunktReader;
import de.geocalc.util.LongHashList;
import java.io.File;
import java.util.Vector;

public class Lt3Reader
extends IFreePunktReader {
    DatLineFormat format;
    int lp = 0;
    int maxLines = 0;
    private static int version = 0;

    public Lt3Reader(File file, LongHashList longHashList) {
        this(file, longHashList, null);
        this.punktStatus = -2;
    }

    public Lt3Reader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
        this.punktStatus = -2;
    }

    public Lt3Reader(File file, LongHashList longHashList, IProgressViewer iProgressViewer) {
        super(file, longHashList, iProgressViewer);
        this.punktStatus = -2;
    }

    @Override
    public Punkt lineToPunkt(String string) throws Exception {
        int n = this.getLineNumber();
        if (n == 1) {
            int n2 = string.indexOf("(");
            this.maxLines = Integer.parseInt(string.substring(0, n2).trim()) + 2;
            if (string.length() > 6 && n2 >= 0 && n2 <= 10) {
                this.format = new DatLineFormat(string.substring(string.indexOf("("), string.lastIndexOf(")") + 1), "N,4F,4I,1F");
                this.lp = this.format.getEndAt(0) - 1;
            }
            return null;
        }
        if (n == 2 || n > this.maxLines) {
            return null;
        }
        Punkt punkt = new Punkt();
        punkt.setPs(-2);
        punkt.setInternalPs(2);
        punkt.nr = Long.parseLong(this.format.parseValueAt(string, 0));
        punkt.y = Double.valueOf(this.format.parseValueAt(string, 1));
        punkt.x = Double.valueOf(this.format.parseValueAt(string, 2));
        if (string.length() > this.format.getStartAt(3) && string.charAt(this.format.getStartAt(3)) != '*' && string.charAt(this.format.getStartAt(4)) != '*') {
            punkt.dy = Float.valueOf(this.format.parseValueAt(string, 3)).floatValue();
            punkt.dx = Float.valueOf(this.format.parseValueAt(string, 4)).floatValue();
        }
        if (string.length() > this.format.getStartAt(7)) {
            punkt.a = Integer.parseInt(this.format.parseValueAt(string, 7));
            punkt.b = Integer.parseInt(this.format.parseValueAt(string, 8));
            punkt.t = (short)Math.round(Float.valueOf(this.format.parseValueAt(string, 9)).floatValue());
        }
        return punkt;
    }

    @Override
    protected String getErrorKey() {
        return "LT3: ";
    }
}

