/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.KafPlot;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.io.IDataReader;
import de.geocalc.text.IFormat;
import java.io.File;
import java.io.LineNumberReader;

public class Lt5Reader
extends IDataReader {
    private static final boolean debug = KafPlot.debug();
    private static final double ARC = 0.015707963267948967;
    private static final int HEADER = -1;
    private static final int ANSCHLUSSPUNKTE = 1;
    private static final int MESSUNGSDATEN = 2;
    private static final int OHNEANSCHLUSS = 3;
    private static final int ERGBEOBACHTUNGEN = 4;
    private static final int STATISTIK = 5;
    private static final int FESTE_HOEHEN = 6;
    private static final int BEOB_HOEHEN = 7;
    private static final int GROESSTE_SP = 8;
    private static final int VOID = 99;
    private static final int HAS_VALUE = 0;
    private static final int NOT_CONTROL = 1;
    private static final int NET_DEFEKT = 2;
    private static final int C_HEADER = 5;
    private static final char NEW_PAGE = '\f';
    private int PA0 = 0;
    private int PA1 = 6;
    private int PA2 = 22;
    private int PA3 = 36;
    private int FH0 = 0;
    private int FH1 = 20;
    private int FH2 = 30;
    private int FH3 = 57;
    private int FH4 = 67;
    private int AH0 = 0;
    private int AH1 = 20;
    private int AH2 = 30;
    private int AH3 = 36;
    private int AH4 = 42;
    private int AH5 = 57;
    private int AH6 = 67;
    private int AH7 = 73;
    private int AH8 = 79;
    public static String S_NK = "N.K.";
    public static String S_ND = "NETZDEFEKT";
    private DataBase db = null;
    private int version = 0;
    private int readErrCount = 0;
    private int ordErrCount = 0;
    private LineNumberReader reader = null;

    public Lt5Reader(File file, DataBase dataBase, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.db = dataBase;
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
        }
    }

    @Override
    public void read() throws IFileInputException {
        int n = 99;
        String string = null;
        try {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            this.reader = this.createReader();
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            boolean bl4 = false;
            while ((string = this.reader.readLine()) != null) {
                int n5 = string.length();
                if (n5 > 0 && string.charAt(0) == '\f') {
                    n = 99;
                    n2 = 0;
                    ++n3;
                    n4 += 5;
                    continue;
                }
                ++n2;
                if (n4 > 0) {
                    --n4;
                    continue;
                }
                if (n == 99) {
                    if (n5 == 0) continue;
                    String string2 = string.trim();
                    if (!string2.startsWith("KAFKA-H") || this.version != 0) {
                        if (string2.startsWith("ANSCHLUSS-PUNKTE:")) {
                            n = 1;
                            n4 = 5;
                        } else if (string2.startsWith("MESSUNGSDATEN:")) {
                            n = 2;
                            n4 = 5;
                        } else if (string2.startsWith("AN DER AUSGLEICHUNG NICHT TEILNEHMENDE PUNKTE")) {
                            n = 3;
                            n4 = 2;
                        } else if (string2.startsWith("ERGEBNISSE NACH DER  AUSGLEICHUNG:")) {
                            n = 4;
                            n4 = 5;
                        } else if (string2.startsWith("SUMME DER  STATISTISCHEN  ANGABEN:")) {
                            n = 5;
                        } else if (string2.startsWith("FESTE ANSCHLUSS - HOEHEN:")) {
                            n = 6;
                            n4 = 4;
                            bl4 = true;
                        } else if (string2.startsWith("AUSGEGLICHENE HOEHEN")) {
                            n = 7;
                            n4 = 5;
                            bl4 = true;
                        } else if (string2.startsWith("PUNKTE MIT DEN GROESSTEN STANDARDABWEICHUNGEN:")) {
                            n = 8;
                            n4 = 4;
                        } else if (string2.startsWith("===")) {
                            n = 99;
                        } else if (string2.startsWith("---")) {
                            n = 99;
                        }
                    }
                    bl2 = false;
                    bl3 = false;
                    continue;
                }
                try {
                    if (bl3) continue;
                    if (n == 6) {
                        if (bl4) {
                            boolean bl5 = false;
                            for (var18_21 = this.FH1 - 1; var18_21 < string.length(); ++var18_21) {
                                if (string.charAt(var18_21) == ' ') {
                                    if (!bl5) continue;
                                    var19_22 = var18_21 - this.FH1;
                                    if (var19_22 <= 0) break;
                                    this.FH1 += var19_22;
                                    this.FH2 += var19_22;
                                    this.FH3 += var19_22 * 2;
                                    this.FH4 += var19_22 * 2;
                                    break;
                                }
                                bl5 = true;
                            }
                            bl4 = false;
                        }
                        if (n5 < this.FH2 || !Character.isDigit(string.charAt(this.FH1 - 1))) continue;
                        l = this.l(string, this.FH0, this.FH1);
                        Punkt punkt = (Punkt)DataBase.P.get(l);
                        if (punkt == null) {
                            ++this.ordErrCount;
                            continue;
                        }
                        punkt.h = (float)this.d(string, this.FH1, this.FH2);
                        punkt.hsp = 1.0E-6f;
                        if (n5 < this.FH4 || !Character.isDigit(string.charAt(this.FH3 - 1))) continue;
                        l2 = this.l(string, this.FH2, this.FH3);
                        punkt = (Punkt)DataBase.P.get(l2);
                        if (punkt == null) {
                            ++this.ordErrCount;
                            continue;
                        }
                        punkt.h = (float)this.d(string, this.FH3, this.FH4);
                        punkt.hsp = 1.0E-6f;
                    } else if (n == 7) {
                        if (bl4) {
                            boolean bl6 = false;
                            for (var18_21 = this.AH1 - 1; var18_21 < string.length(); ++var18_21) {
                                if (string.charAt(var18_21) == ' ') {
                                    if (!bl6) continue;
                                    var19_22 = var18_21 - this.AH1;
                                    if (var19_22 <= 0) break;
                                    this.AH1 += var19_22;
                                    this.AH2 += var19_22;
                                    this.AH3 += var19_22;
                                    this.AH4 += var19_22;
                                    this.AH5 += var19_22 * 2;
                                    this.AH6 += var19_22 * 2;
                                    this.AH7 += var19_22 * 2;
                                    this.AH8 += var19_22 * 2;
                                    break;
                                }
                                bl6 = true;
                            }
                            bl4 = false;
                        }
                        if (n5 < this.AH2 || !Character.isDigit(string.charAt(this.AH1 - 1))) continue;
                        l = this.l(string, this.AH0, this.AH1);
                        Punkt punkt = (Punkt)DataBase.P.get(l);
                        if (punkt == null) {
                            ++this.ordErrCount;
                            continue;
                        }
                        punkt.h = (float)this.d(string, this.AH1, this.AH2);
                        if (n5 < this.AH3) continue;
                        punkt.hsp = (float)(this.d(string, this.AH2, this.AH3) * 1.0E-4);
                        punkt.lhsp = (float)(this.d(string, this.AH3, this.AH4) * 1.0E-4);
                        if (n5 < this.AH6 || !Character.isDigit(string.charAt(this.AH5 - 1))) continue;
                        l2 = this.l(string, this.AH4, this.AH5);
                        punkt = (Punkt)DataBase.P.get(l2);
                        if (punkt == null) {
                            ++this.ordErrCount;
                            continue;
                        }
                        punkt.h = (float)this.d(string, this.AH5, this.AH6);
                        if (n5 < this.AH7) continue;
                        punkt.hsp = (float)(this.d(string, this.AH6, this.AH7) * 1.0E-4);
                        punkt.lhsp = (float)(this.d(string, this.AH7, this.AH8) * 1.0E-4);
                    }
                }
                catch (Exception exception) {
                    if (debug) {
                        System.out.println("LT5 Zeile:" + this.reader.getLineNumber());
                        exception.printStackTrace();
                    }
                    this.ex("Lesefehler in Zeile: " + this.reader.getLineNumber());
                    ++this.readErrCount;
                }
                super.setFileProgress(l3 += (long)(string.length() + 1));
            }
            this.reader.close();
        }
        catch (Exception exception) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber(), exception.getMessage()));
            exception.printStackTrace();
        }
        if (this.readErrCount > 0 || this.ordErrCount > 0) {
            this.ex("\nFehler beim Laden der Datei: " + this.inFile.getName() + "\nKAFKA-Dateiversion: " + IFormat.f_3.format((double)this.version / 1000.0) + "\nes wird die KAFKA-Version ab 4.100 unterst\u00fctzt\nes sind " + this.readErrCount + " Lesefehler und " + this.ordErrCount + " Zuordnungsfehler aufgetreten\nBitte senden sie die Daten an kafplot@geocalc.de");
        }
    }

    private long l(String string, int n, int n2) {
        n2 = Math.min(string.length(), n2);
        try {
            return Long.parseLong(string.substring(n, n2).trim());
        }
        catch (Exception exception) {
            ++this.readErrCount;
            if (debug) {
                System.out.println("LT5 Zeile:" + this.reader.getLineNumber());
                exception.printStackTrace();
            }
            return 0L;
        }
    }

    private double d(String string, int n, int n2) {
        n2 = Math.min(string.length(), n2);
        String string2 = string.substring(n, n2).trim();
        if (string2.length() == 0) {
            return 0.0;
        }
        return new Double(string2);
    }

    private int i(String string, int n, int n2) {
        return Integer.parseInt(string.substring(n, n2).trim());
    }

    private short s(String string, int n, int n2) {
        n2 = Math.min(string.length(), n2);
        if (n >= n2) {
            return Short.MIN_VALUE;
        }
        if (n2 < n) {
            return Short.MAX_VALUE;
        }
        String string2 = null;
        try {
            string2 = string.substring(n, n2).trim();
            if (string2.length() == 0) {
                return Short.MIN_VALUE;
            }
            int n3 = Integer.parseInt(string2);
            if (n3 < -32766) {
                return -32767;
            }
            if (n3 > 32765) {
                return 32766;
            }
            return (short)n3;
        }
        catch (Exception exception) {
            if (this.isOverflow(string2)) {
                return 32766;
            }
            ++this.readErrCount;
            if (debug) {
                System.out.println("LT5 Zeile:" + this.reader.getLineNumber());
                exception.printStackTrace();
            }
            return Short.MAX_VALUE;
        }
    }

    private short s(String string, int n, int n2, double d) {
        return this.s(string, n, n2, d, false);
    }

    private short s(String string, int n, int n2, double d, boolean bl) {
        n2 = Math.min(string.length(), n2);
        if (n >= n2) {
            return Short.MIN_VALUE;
        }
        if (n2 < n) {
            return Short.MAX_VALUE;
        }
        String string2 = null;
        try {
            int n3;
            string2 = string.substring(n, n2).trim();
            if (string2.length() == 0) {
                return Short.MIN_VALUE;
            }
            double d2 = new Double(string2);
            if (bl) {
                d2 = Math.tan(d2 * 0.001 * 0.015707963267948967);
            }
            if ((n3 = (int)Math.rint(d2 * d)) < -32766) {
                return -32767;
            }
            if (n3 > 32765) {
                return 32766;
            }
            return (short)n3;
        }
        catch (Exception exception) {
            if (this.isOverflow(string2)) {
                return 32766;
            }
            ++this.readErrCount;
            if (debug) {
                System.out.println("LT5 Zeile:" + this.reader.getLineNumber());
                exception.printStackTrace();
            }
            return Short.MAX_VALUE;
        }
    }

    private boolean isNk(String string, int n) {
        return string.indexOf(S_NK, n) >= 0;
    }

    private int getState(String string, int n) {
        if (string.indexOf(S_NK, n) >= 0) {
            return 1;
        }
        if (string.indexOf(S_ND, n) >= 0) {
            return 2;
        }
        return 0;
    }

    private boolean isOverflow(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == '*') continue;
            return false;
        }
        return true;
    }

    private void ex(String string) {
        this.addException(new IFileInputException("LT5: " + string));
    }
}

