/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.BemerkungTable;
import de.geocalc.kafplot.ErrorObject;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.TextBox;
import de.geocalc.kafplot.io.IDataReader;
import de.geocalc.util.LongHashList;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.StringTokenizer;

public class Lt6Reader
extends IDataReader {
    protected BemerkungTable ERR = null;
    protected LongHashList P = null;
    private LineNumberReader reader = null;

    public Lt6Reader(File file, BemerkungTable bemerkungTable, LongHashList longHashList) {
        this(file, bemerkungTable, longHashList, null);
    }

    public Lt6Reader(File file, BemerkungTable bemerkungTable, LongHashList longHashList, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.ERR = bemerkungTable;
        this.P = longHashList;
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read() throws IFileInputException {
        String string = null;
        TextBox textBox = null;
        StringBuffer stringBuffer = null;
        try {
            this.reader = this.createReader();
            long l = 0L;
            Punkt[] punktArray = new Punkt[4];
            while ((string = this.reader.readLine()) != null) {
                if (string.startsWith(" *")) {
                    if (textBox != null) {
                        if (stringBuffer != null) {
                            textBox.setText(stringBuffer.toString());
                        }
                        this.ERR.addElement(textBox);
                    }
                    textBox = new ErrorObject("LT6");
                    stringBuffer = new StringBuffer();
                } else if (string.startsWith("  ")) {
                    if (((ErrorObject)textBox).getPoint() == null) {
                        punktArray = new Punkt[4];
                        var7_11 = new StringTokenizer(string);
                        var8_12 = 0;
                        while (((StringTokenizer)var7_11).hasMoreTokens()) {
                            long l2 = Long.parseLong(((StringTokenizer)var7_11).nextToken());
                            if (l2 != -1L) {
                                punktArray[var8_12] = (Punkt)this.P.get(l2);
                            }
                            ++var8_12;
                        }
                        if (punktArray[3] != null) {
                            ((ErrorObject)textBox).setPoint(DPoint.getMiddle(punktArray[3], punktArray[2]));
                            ((ErrorObject)textBox).addGeom(new DLine(punktArray[2], punktArray[3]));
                            ((ErrorObject)textBox).addGeom(new DLine(punktArray[0], punktArray[2]));
                        } else if (punktArray[2] != null) {
                            ((ErrorObject)textBox).setPoint(punktArray[2]);
                            ((ErrorObject)textBox).addGeom(new DLine(punktArray[1], punktArray[0]));
                            ((ErrorObject)textBox).addGeom(punktArray[2]);
                        } else if (punktArray[1] != null) {
                            ((ErrorObject)textBox).setPoint(DPoint.getMiddle(punktArray[1], punktArray[0]));
                            ((ErrorObject)textBox).addGeom(new DLine(punktArray[1], punktArray[0]));
                        } else if (punktArray[0] != null) {
                            ((ErrorObject)textBox).setPoint(punktArray[0]);
                            ((ErrorObject)textBox).addGeom(punktArray[0]);
                        } else {
                            ((ErrorObject)textBox).setPoint(new DPoint());
                        }
                    } else {
                        var7_11 = string.trim();
                        var8_12 = ((String)var7_11).indexOf(58);
                        if (((String)var7_11).startsWith("RECHTER WINKEL IM")) {
                            if (punktArray[1] != null) {
                                ((ErrorObject)textBox).setPoint(punktArray[1]);
                            }
                            Lt6Reader.parseString((String)var7_11, stringBuffer);
                        } else if (((String)var7_11).startsWith("MIT MESS")) {
                            stringBuffer.append("\nMesswert: ");
                            stringBuffer.append(Lt6Reader.parseValue(((String)var7_11).substring(var8_12)));
                        } else if (((String)var7_11).startsWith("VERB")) {
                            stringBuffer.append("\nVerb.: ");
                            stringBuffer.append(Lt6Reader.parseValue(((String)var7_11).substring(var8_12)));
                        } else if (((String)var7_11).startsWith("FEHL")) {
                            stringBuffer.append(" bei m0: ");
                            stringBuffer.append(Lt6Reader.parseValue(((String)var7_11).substring(var8_12)));
                        } else if (!((String)var7_11).startsWith("KONT")) {
                            if (((String)var7_11).startsWith("NORM")) {
                                stringBuffer.append("\nNV: ");
                                stringBuffer.append(Lt6Reader.parseValue(((String)var7_11).substring(var8_12)));
                            } else if (((String)var7_11).startsWith("GESC")) {
                                stringBuffer.append(" GF: ");
                                stringBuffer.append(Lt6Reader.parseValue(((String)var7_11).substring(var8_12)));
                            } else if (!((String)var7_11).startsWith("BEOB") && !((String)var7_11).startsWith("AUSG")) {
                                Lt6Reader.parseString((String)var7_11, stringBuffer);
                            }
                        }
                    }
                }
                super.setFileProgress(l += (long)(string.length() + 1));
            }
        }
        catch (IOException iOException) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber(), iOException.getMessage()));
        }
        catch (Exception exception) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.reader.getLineNumber(), exception.getMessage()));
            exception.printStackTrace();
        }
        finally {
            if (textBox != null) {
                if (stringBuffer != null) {
                    textBox.setText(stringBuffer.toString());
                }
                this.ERR.addElement(textBox);
            }
            try {
                this.reader.close();
                super.setProgress(100);
            }
            catch (Exception exception) {}
        }
    }

    private static final void parseString(String string, StringBuffer stringBuffer) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(":")) continue;
            if (!(string2.equals("M") || string2.equals("GON") || Character.isDigit(string2.charAt(0)) || Lt6Reader.tokenLength(stringBuffer) <= 20)) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(string2);
            stringBuffer.append(" ");
        }
    }

    private static final int tokenLength(StringBuffer stringBuffer) {
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            if (stringBuffer.charAt(i) != '\n') continue;
            return stringBuffer.length() - 1 - i;
        }
        return stringBuffer.length();
    }

    private static final boolean isNumber(String string) {
        try {
            Long.parseLong(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static final String parseValue(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (Character.isDigit(string2.charAt(string2.length() - 1))) {
                if (string2.charAt(string2.length() - 1) == '0') {
                    StringBuffer stringBuffer2 = new StringBuffer(string2);
                    for (int i = stringBuffer2.length() - 1; i > 0; --i) {
                        if (stringBuffer2.charAt(i) == '0') continue;
                        stringBuffer2.setLength(i + 1);
                        break;
                    }
                    string2 = stringBuffer2.toString();
                }
            } else {
                string2 = string2.toLowerCase();
            }
            stringBuffer.append(string2);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

