/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.io.IFreePunktReader;
import de.geocalc.util.LongHashList;
import java.io.File;
import java.util.Vector;

public class Lt7Reader
extends IFreePunktReader {
    private boolean doDetect = true;
    private int n = 0;

    public Lt7Reader(File file, LongHashList longHashList) {
        super(file, longHashList, null);
    }

    public Lt7Reader(File file, LongHashList longHashList, IProgressViewer iProgressViewer) {
        super(file, longHashList, iProgressViewer);
    }

    public Lt7Reader(File file, Vector vector) {
        super(file, vector, null);
    }

    public Lt7Reader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
    }

    @Override
    protected Punkt lineToPunkt(String string) {
        int n = string.length();
        Punkt punkt = null;
        if (n > 20) {
            int n2;
            if (this.doDetect) {
                n2 = 0;
                for (int i = 15; i < string.length(); ++i) {
                    if (string.charAt(i) == ' ') {
                        if (n2 == 0) continue;
                        this.n = i - 16;
                        break;
                    }
                    n2 = 1;
                }
                this.doDetect = false;
            }
            if (string.startsWith("1")) {
                punkt = new Punkt();
                n2 = Integer.parseInt(string.substring(1, 2));
                switch (n2) {
                    case 1: {
                        punkt.setPs(1);
                        break;
                    }
                    case 2: {
                        punkt.setPs(2);
                        break;
                    }
                    case 3: 
                    case 4: {
                        punkt.setPs(-2);
                        break;
                    }
                    default: {
                        punkt.setPs(-2);
                    }
                }
                punkt.nr = Long.parseLong(string.substring(2, this.n + 16).trim());
                punkt.y = new Double(string.substring(this.n + 19, this.n + 32).trim());
                punkt.x = new Double(string.substring(this.n + 35, this.n + 48).trim());
                try {
                    punkt.h = new Float(string.substring(this.n + 49, this.n + 58).trim()).floatValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    punkt.lsp = new Float(string.substring(this.n + 59, this.n + 67).trim()).floatValue();
                    if (punkt.lsp == 0.0f) {
                        punkt.lsp = 1.0E-5f;
                    }
                }
                catch (Exception exception) {
                    punkt.lsp = 0.0f;
                }
            } else if (string.startsWith("2")) {
                punkt = new Punkt();
                punkt.setPs(3);
                punkt.nr = Long.parseLong(string.substring(this.n + 2, this.n + 16).trim());
                punkt.h = new Float(string.substring(this.n + 19, this.n + 32).trim()).floatValue();
                if (string.length() > this.n + 33) {
                    punkt.hsp = new Float(string.substring(this.n + 32).trim()).floatValue();
                }
            }
        }
        return punkt;
    }

    @Override
    protected String getErrorKey() {
        return "LT7: ";
    }
}

