/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.TrafoSystemTable;
import de.geocalc.kafplot.io.IDataReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class Lt8Reader
extends IDataReader {
    protected static final long SYS_FAK = 1000000000000000L;
    protected TrafoSystemTable T;
    protected Hashtable HP = new Hashtable();
    private LineNumberReader reader = null;
    private static Punkt p = new Punkt();

    public Lt8Reader(File file, TrafoSystemTable trafoSystemTable, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.T = trafoSystemTable;
    }

    protected void createHash() {
        Enumeration enumeration = this.T.elements();
        while (enumeration.hasMoreElements()) {
            TrafoSystem trafoSystem = (TrafoSystem)enumeration.nextElement();
            Enumeration enumeration2 = trafoSystem.elements();
            while (enumeration2.hasMoreElements()) {
                TrafoPunkt trafoPunkt = (TrafoPunkt)enumeration2.nextElement();
                this.HP.put(new Long((long)trafoSystem.getNummer() * 1000000000000000L + trafoPunkt.getPunkt().nr), trafoPunkt);
            }
        }
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
        }
    }

    @Override
    public void read() throws IFileInputException {
        this.createHash();
        String string = null;
        try {
            this.reader = this.createReader();
            long l = 0L;
            while ((string = this.reader.readLine()) != null) {
                try {
                    Punkt punkt = this.lineToPunkt(string);
                    if (punkt != null && this.savePunkt(punkt) == null) {
                        this.addException(new IFileInputException(this.getErrorKey() + "Lesefehler in Zeile: " + this.reader.getLineNumber() + ", Punkt " + punkt.nr + " wurde nicht gefunden"));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.addException(new IFileInputException(this.getErrorKey() + "Lesefehler in Zeile: " + this.reader.getLineNumber() + ", ung\u00fcltige Zeichen vorgefunden.", "Zeile wurde ignoriert"));
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    this.addException(new IFileInputException(this.getErrorKey() + "Lesefehler in Zeile: " + this.reader.getLineNumber() + ", vorzeitig Zeilenende erreicht.", "Zeile wurde ignoriert"));
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.addException(new IFileInputException(this.getErrorKey() + "Lesefehler in Zeile: " + this.reader.getLineNumber() + ", vorzeitig Zeilenende erreicht.", "Zeile wurde ignoriert"));
                }
                super.setFileProgress(l += (long)(string.length() + 1));
            }
            super.setProgress(100);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IFileInputException(this.getErrorKey() + "Datei " + this.inFile.getName() + " nicht gefunden");
        }
        catch (IOException iOException) {
            throw new IFileInputException(this.getErrorKey() + "Lesefehler in Zeile: " + this.reader.getLineNumber());
        }
        finally {
            try {
                this.reader.close();
            }
            catch (Exception exception) {
                throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
            }
        }
    }

    protected TrafoPunkt savePunkt(Punkt punkt) {
        TrafoPunkt trafoPunkt = (TrafoPunkt)this.HP.get(new Long((long)punkt.getPs() * 1000000000000000L + punkt.nr));
        if (trafoPunkt != null) {
            trafoPunkt.setVx(punkt.dx);
            trafoPunkt.setVy(punkt.dy);
            DataBase.tvmax = Math.max(DataBase.tvmax, Math.sqrt(punkt.dx * punkt.dx + punkt.dy * punkt.dy));
        }
        return trafoPunkt;
    }

    public Punkt lineToPunkt(String string) {
        if (string.length() == 0 || string.charAt(0) != 'T' && string.charAt(0) != 'P') {
            return null;
        }
        Lt8Reader.p.nr = Long.parseLong(string.substring(1, 18).trim());
        Lt8Reader.p.dy = Float.valueOf(string.substring(43, 55).trim()).floatValue();
        Lt8Reader.p.dx = Float.valueOf(string.substring(55, 67).trim()).floatValue();
        p.setPs(Integer.parseInt(string.substring(80).trim()));
        return p;
    }

    @Override
    protected String getErrorKey() {
        return "LT8: ";
    }
}

