/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.io.IPolarReader;
import de.geocalc.kafplot.io.PolarMessung;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class MesReader
extends IPolarReader {
    int anzZpk = 0;
    private PolarMessung s = new PolarMessung();

    public MesReader(File file, Vector vector) {
        super(file, vector, null);
    }

    public MesReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
    }

    @Override
    protected PolarMessung lineToPolarMessung(String string) throws IFileInputException, IOException {
        PolarMessung polarMessung = new PolarMessung();
        if (string.startsWith("*")) {
            return null;
        }
        int n = 0;
        try {
            Integer n2 = new Integer(string.substring(0, 2).trim());
            n = n2;
        }
        catch (Exception exception) {
            return null;
        }
        switch (n) {
            case 10: {
                this.s = this.readStandpunkt(this.s, string);
                this.anzZpk = 0;
                return null;
            }
            case 13: 
            case 20: 
            case 25: {
                polarMessung = this.readMessung(polarMessung, string);
                polarMessung.pns = this.anzZpk == 0 ? this.s.pns : 0L;
                polarMessung.ih = this.s.ih;
                if (n == 25) {
                    polarMessung.rh = -1.7976931348623157E308;
                }
                if (polarMessung.r == 0.0 && this.anzZpk > 0) {
                    throw new IFileInputException("Null-Richtung im Richtungssatz");
                }
                if (polarMessung.pns == 0L && this.anzZpk == 0) {
                    throw new IFileInputException("Fehlender Standpunkt");
                }
                ++this.anzZpk;
                break;
            }
            default: {
                return null;
            }
        }
        return polarMessung;
    }

    private PolarMessung readStandpunkt(PolarMessung polarMessung, String string) throws IFileInputException {
        try {
            polarMessung.pns = Long.parseLong(string.substring(3, 17).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Punktnummer");
        }
        try {
            polarMessung.ih = new Double(string.substring(18, Math.min(string.length(), 28)).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Instrumentenh\u00f6he");
        }
        return polarMessung;
    }

    private PolarMessung readMessung(PolarMessung polarMessung, String string) throws IFileInputException {
        try {
            polarMessung.pnz = Long.parseLong(string.substring(3, 17).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Punktnummer");
        }
        try {
            polarMessung.rh = new Double(string.substring(18, Math.min(string.length(), 28)).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Reflektorh\u00f6he");
        }
        try {
            polarMessung.dl = new Double(string.substring(28, 36).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element L\u00e4ngsexzentrum");
        }
        try {
            polarMessung.dq = new Double(string.substring(36, 44).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Querexzentrum");
        }
        try {
            polarMessung.s = new Double(string.substring(46, 54).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Strecke");
        }
        try {
            polarMessung.r = new Double(string.substring(54, 63).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Richtung");
        }
        try {
            polarMessung.z = new Double(string.substring(63, 72).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Zenit");
        }
        return polarMessung;
    }
}

