/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.geom.DPoint;
import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.Bemerkung;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.ErrorObject;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.TextBox;
import de.geocalc.kafplot.io.IFileWriter;
import de.geocalc.text.IFormat;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class MessageListWriter
extends IFileWriter {
    protected DataBase db;
    private boolean isCorrectSaved = true;
    public static boolean writePunktMsg = true;
    public static boolean writeMessungMsg = true;
    public static boolean writeBemerkungMsg = true;
    public static boolean writeFehlerMsg = true;

    public MessageListWriter(File file, DataBase dataBase) {
        super(file);
        this.db = dataBase;
    }

    @Override
    public void write() throws IFileOutputException {
        PrintWriter printWriter = null;
        try {
            Messager messager;
            Enumeration enumeration;
            this.showProgress(false);
            printWriter = this.createWriter();
            if (writePunktMsg) {
                enumeration = DataBase.P.elements();
                while (enumeration.hasMoreElements()) {
                    messager = (Punkt)enumeration.nextElement();
                    if (!((Punkt)messager).hasBemerkung()) continue;
                    printWriter.println(this.createLine(new Bemerkung((Punkt)messager, null, ((Punkt)messager).getBemerkungText())));
                }
            }
            this.setProgress(25);
            if (writeMessungMsg) {
                MessageListWriter messageListWriter = this;
                enumeration = messageListWriter.db.messungen();
                while (enumeration.hasMoreElements()) {
                    messager = (Messung)enumeration.nextElement();
                    if (!((Messung)messager).hasText()) continue;
                    printWriter.println(this.createLine(new Bemerkung(((Messung)messager).ps, ((Messung)messager).pz, ((Messung)messager).getText())));
                }
            }
            this.setProgress(50);
            if (writeBemerkungMsg) {
                enumeration = DataBase.BEM.elements();
                while (enumeration.hasMoreElements()) {
                    printWriter.println(this.createLine((Bemerkung)enumeration.nextElement()));
                }
            }
            this.setProgress(75);
            if (writeBemerkungMsg) {
                enumeration = DataBase.ERR.elements();
                while (enumeration.hasMoreElements()) {
                    messager = (ErrorObject)enumeration.nextElement();
                    printWriter.println(this.createLine(new Bemerkung(new Punkt(((ErrorObject)messager).getCatchPoint()), null, ((TextBox)((Object)messager)).getText())));
                }
            }
            this.setProgress(100);
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
        finally {
            try {
                printWriter.close();
                this.isCorrectSaved = true;
            }
            catch (Exception exception) {}
        }
    }

    private String createLine(Bemerkung bemerkung) {
        DPoint dPoint = bemerkung.getCatchPoint();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CMD \"DotSearch\" RET ESC \"");
        stringBuffer.append(IFormat.f_3.format(dPoint.y));
        stringBuffer.append("\" RET \"");
        stringBuffer.append(IFormat.f_3.format(dPoint.x));
        stringBuffer.append("\" RET CMD \"ShowTxt\" RET \"");
        stringBuffer.append(MessageListWriter.toStapelString(bemerkung.getText()));
        stringBuffer.append("\" RET");
        return stringBuffer.toString();
    }

    private static String toStapelString(String string) {
        if (string == null || string.length() == 0) {
            return "ohne Meldung";
        }
        int n = (string = string.replace('\n', ' ')).indexOf("\\");
        if (n >= 0 && string.length() > n + 1) {
            if (string.charAt(n + 1) == '\"') {
                StringBuffer stringBuffer = new StringBuffer(string);
                for (int i = 0; i < stringBuffer.length() - 1; ++i) {
                    if (stringBuffer.charAt(i) != '\\' || stringBuffer.charAt(i + 1) != '\"') continue;
                    stringBuffer.setCharAt(i, "'".charAt(0));
                    stringBuffer.setCharAt(i + 1, "'".charAt(0));
                }
                return stringBuffer.toString();
            }
            return string;
        }
        return string;
    }

    public boolean isCorrectSaved() {
        return this.isCorrectSaved;
    }
}

