/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IException;
import de.geocalc.awt.IProgressViewer;
import de.geocalc.geodata.AbstractLage;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPolygon;
import de.geocalc.geom.DRectangle;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.Bedingung;
import de.geocalc.kafplot.BodenSchaetzung;
import de.geocalc.kafplot.BodenSchaetzungTable;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.DataContainerTable;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.FlurstueckArt;
import de.geocalc.kafplot.FlurstueckTable;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.GObjectManipulator;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.GebaeudeKennzeichen;
import de.geocalc.kafplot.GebaeudeTable;
import de.geocalc.kafplot.GeradenSchnitt;
import de.geocalc.kafplot.Hoehe;
import de.geocalc.kafplot.KafPlot;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Lage;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.MessElementTable;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.NummerierungsBezirkException;
import de.geocalc.kafplot.Nutzung;
import de.geocalc.kafplot.NutzungTable;
import de.geocalc.kafplot.NutzungsArt;
import de.geocalc.kafplot.ObjectLine;
import de.geocalc.kafplot.OrthoLinie;
import de.geocalc.kafplot.Oska;
import de.geocalc.kafplot.PolarAufnahme;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.PunktParameterALK;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.RissInfo;
import de.geocalc.kafplot.Stat;
import de.geocalc.kafplot.SurveyException;
import de.geocalc.kafplot.TopObject;
import de.geocalc.kafplot.TopObjectTable;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.TrafoSystemTable;
import de.geocalc.kafplot.ValueDataContainer;
import de.geocalc.kafplot.io.IDataReader;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.kataster.model.Alkis;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;
import de.geocalc.util.HashClearStack;
import de.geocalc.util.KeyedHashtable;
import de.geocalc.util.sml.Tag;
import java.lang.invoke.CallSite;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MessungParser
extends IDataReader {
    public static boolean progressiveGeomSearchMode = false;
    DataBase db;
    private static final double FLUCHT_MAX = 0.04;

    public MessungParser(DataBase dataBase) {
        this(dataBase, null);
    }

    public MessungParser(DataBase dataBase, IProgressViewer iProgressViewer) {
        super(null, iProgressViewer);
        this.db = dataBase;
    }

    @Override
    public void read() throws IException {
        this.parse();
    }

    @Override
    public void userAbort() throws IFileInputException {
    }

    public void parse() throws IException {
        this.setProgress(0);
        this.computePunktEinrechnung();
        this.computePunktRefs();
        if (KafkaIOProperties.isPPOExec()) {
            this.createPunktOska();
        }
        this.setProgress(5);
        if (KafkaIOProperties.isPPKExec()) {
            this.computePunktPST();
        }
        this.computePunktENT();
        this.parseNumbers();
        this.referMessungen();
        this.referBedingungen();
        this.parseMessungen();
        this.setProgress(10);
        this.computeInternPunkte();
        this.setProgress(15);
        if (KafkaIOProperties.isLT2Read() && KafkaIOProperties.isPPGExec()) {
            this.computePunktAG();
        }
        this.parseEinbindeMasze(DataBase.MM);
        this.parseEinbindeMasze(DataBase.MK);
        this.parseEinbindeMasze(DataBase.ME);
        this.parseEinbindeMasze(DataBase.MV);
        this.parseFluchtungen(DataBase.ME);
        this.setProgress(20);
        this.parseTrafoSysteme(DataBase.T);
        this.setProgress(30);
        this.computePunktLZ();
        this.initImages();
        this.setProgress(40);
        this.initGeom();
        if (KafkaIOProperties.isZFExec()) {
            this.computeFlstVereinigung();
            this.setProgress(50);
            this.testFlstArt();
            this.setProgress(55);
            this.computeFlstFlaeche();
            this.setProgress(60);
            this.createFlstGeom();
            this.setProgress(65);
            this.computeRestFlaeche();
            this.setProgress(70);
            this.computeRoundedFlaeche();
            this.setProgress(75);
            this.computeFlstAreaExtends();
            this.setProgress(80);
        }
        if (DataBase.model.getModel() == 1) {
            if (KafkaIOProperties.isLExec()) {
                this.parseAlkLinien();
            }
            this.createLinieOska();
            this.setProgress(90);
            this.testGebaeudeArt(DataBase.GEB);
        } else if (DataBase.model.getModel() == 2) {
            this.computeAlkisLinien();
            this.setProgress(85);
            MessungParser.computeAlkisFlurstuecke(DataBase.FLST);
            this.setProgress(90);
            MessungParser.computeAlkisGebaeude(DataBase.GEB);
            this.setProgress(95);
            MessungParser.computeAlkisNutzungen(DataBase.NUTZ);
            MessungParser.computeAlkisTopografie(DataBase.TOP);
            MessungParser.computeAlkisBodenschaetzung(DataBase.BODEN);
            MessungParser.computeAlkisGebaeudeSignatur(DataBase.GEB);
            this.testAlkisFlurstuecke(DataBase.FLST);
            this.testAlkisGebaeude(DataBase.GEB);
            MessungParser.createSymbolWinkel(DataBase.FLST);
        }
        KafPlotProperties.init(this.db);
        this.setProgress(100);
    }

    public void initGeom() {
        MessungParser.initGeom(DataBase.MG);
        MessungParser.initGeom(DataBase.MP);
        MessungParser.initGeom(DataBase.MM);
        MessungParser.initGeom(DataBase.MK);
        MessungParser.initGeom(DataBase.ME);
        MessungParser.initGeom(DataBase.MV);
        MessungParser.initGeom(DataBase.HN);
        MessungParser.initGeom(DataBase.HP);
        MessungParser.initGeom(DataBase.T);
        MessungParser.initGeom(DataBase.FLST);
        MessungParser.initGeom(DataBase.NUTZ);
        MessungParser.initGeom(DataBase.BODEN);
        MessungParser.initGeom(DataBase.GEB);
        MessungParser.initGeom(DataBase.TOP);
        MessungParser.initGeom(DataBase.BB);
        MessungParser.initGeom(DataBase.BH);
    }

    public static void initGeom(DataContainerTable dataContainerTable) {
        Enumeration enumeration = dataContainerTable.elements();
        while (enumeration.hasMoreElements()) {
            ((DataContainer)enumeration.nextElement()).initGeom();
        }
    }

    public void initImages() {
        DataBase.IMG.initGeom();
    }

    public void referMessungen() {
        this.referMessungen(DataBase.MG);
        this.referMessungen(DataBase.MP);
        this.referMessungen(DataBase.MM);
        this.referMessungen(DataBase.MK);
        this.referMessungen(DataBase.ME);
        this.referMessungen(DataBase.MV);
        this.referHoehe(DataBase.HN);
        this.referHoehe(DataBase.HP);
    }

    private void referHoehe(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Riss riss = (Riss)enumeration.nextElement();
            Hoehe hoehe = null;
            Enumeration enumeration2 = riss.elements();
            while (enumeration2.hasMoreElements()) {
                try {
                    Hoehe hoehe2 = (Hoehe)enumeration2.nextElement();
                    if (hoehe2.getPs() != null) {
                        hoehe = hoehe2;
                        continue;
                    }
                    hoehe2.setReferenz(hoehe);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void referMessungen(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Riss riss = (Riss)enumeration.nextElement();
            Messung messung = null;
            Messung messung2 = null;
            Messung messung3 = null;
            Messung messung4 = null;
            Messung messung5 = null;
            boolean bl = false;
            Enumeration enumeration2 = riss.elements();
            while (enumeration2.hasMoreElements()) {
                try {
                    Messung messung6 = (Messung)enumeration2.nextElement();
                    if (messung6.hasStatistik()) {
                        riss.updateStatistik(messung6.getStatistik());
                        this.db.updateStatistik(messung6.getStatistik());
                    }
                    switch (messung6.getMessungsArt(true)) {
                        case 230: 
                        case 280: {
                            if (messung6.ps != null) {
                                messung5 = messung6;
                                break;
                            }
                            messung6.setReferenz(messung5);
                            break;
                        }
                        case 270: {
                            if (messung6.ps != null) {
                                messung4 = messung6;
                                break;
                            }
                            messung6.setReferenz(messung4);
                            break;
                        }
                        case 260: {
                            if (!messung6.isOn() || messung6.isFehler()) break;
                            if (messung3 == null) {
                                messung3 = messung6;
                                break;
                            }
                            messung3.setReferenz(messung6);
                            messung6.setReferenz(messung3);
                            messung3 = null;
                            break;
                        }
                        case 210: {
                            messung = messung6;
                            bl = true;
                            break;
                        }
                        case 200: {
                            if (messung6.isFehler()) {
                                if (messung6.getMessungsArt(false) == 210) {
                                    if (messung == null) {
                                        messung = messung6;
                                        break;
                                    }
                                    messung2 = messung6;
                                    break;
                                }
                                if (!bl && messung6.getMessungsArt(false) == 290) {
                                    messung6.setReferenz(messung);
                                    messung.setReferenz(messung6);
                                    messung = null;
                                    break;
                                }
                            }
                        }
                        case 240: {
                            messung6.setReferenz(messung);
                            break;
                        }
                        case 290: {
                            messung6.setReferenz(messung);
                            messung.setReferenz(messung6);
                            messung = null;
                            if (messung2 != null) {
                                messung2.setReferenz(messung6);
                                messung2 = null;
                            }
                            bl = false;
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void referBedingungen() {
        this.referBedingungen(DataBase.BH);
        this.referBedingungen(DataBase.BB);
    }

    private void referBedingungen(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Riss riss = (Riss)enumeration.nextElement();
            Bedingung bedingung = null;
            Bedingung bedingung2 = null;
            Enumeration enumeration2 = riss.elements();
            while (enumeration2.hasMoreElements()) {
                Bedingung bedingung3 = (Bedingung)enumeration2.nextElement();
                if (bedingung3.hasStatistik()) {
                    riss.updateStatistik(bedingung3.getStatistik());
                    this.db.updateStatistik(bedingung3.getStatistik());
                }
                switch (bedingung3.ba) {
                    case 3: {
                        bedingung = bedingung3;
                        break;
                    }
                    case 0: {
                        bedingung3.setReferenz(bedingung);
                        break;
                    }
                    case 6: {
                        bedingung2 = bedingung3;
                        break;
                    }
                    case 9: {
                        bedingung3.setReferenz(bedingung2);
                    }
                }
            }
        }
    }

    private static void setSymbolWinkelOfPunkt(Punkt punkt, Vector vector) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Linie linie = null;
        Linie linie2 = null;
        boolean bl = false;
        for (n = 0; n < vector.size(); ++n) {
            Linie linie3 = (Linie)vector.elementAt(n);
            for (int i = 0; i < vector.size(); ++i) {
                Linie linie4 = (Linie)vector.elementAt(i);
                Punkt punkt2 = linie3.pa == punkt ? linie3.pe : linie3.pa;
                Punkt punkt3 = linie4.pa == punkt ? linie4.pe : linie4.pa;
                if (!(Math.abs(DLine.getDistance(punkt2, punkt3, punkt)) < 0.04)) continue;
                d = (linie3.getRichtungVonPunkt(punkt) + linie4.getRichtungVonPunkt(punkt)) / 2.0;
                bl = true;
                if (linie3.getEb() != 1 && linie3.getEb() != 41 && linie3.getEb() != 49 || linie4.getEb() != 1 && linie4.getEb() != 41 && linie4.getEb() != 49) continue;
                punkt.setSymbolWinkel(d);
                return;
            }
            double d4 = DLine.getDist(linie3.pa.y, linie3.pa.x, linie3.pe.y, linie3.pe.x);
            if (d4 > d3) {
                if (d4 > d2) {
                    d3 = d2;
                    linie2 = linie;
                } else if (d4 < d2) {
                    d3 = d4;
                    linie2 = linie3;
                }
            }
            if (!(d4 > d2)) continue;
            d2 = d4;
            linie = linie3;
        }
        if (bl) {
            punkt.setSymbolWinkel(d);
        } else {
            n = 0;
            if (linie2 != null && d3 / d2 > 0.75) {
                double d5;
                double d6 = linie.getRichtungVonPunkt(punkt);
                double d7 = linie2.getRichtungVonPunkt(punkt);
                if (d6 < 0.0) {
                    d6 += Math.PI * 2;
                }
                if (d7 < 0.0) {
                    d7 += Math.PI * 2;
                }
                if ((d5 = Math.abs(d6 - d7)) > 2.0 && d5 < 4.2) {
                    punkt.setSymbolWinkel((d6 + d7) / 2.0);
                    n = 1;
                }
            }
            if (n == 0) {
                punkt.setSymbolWinkel(linie.getRichtungVonPunkt(punkt) + 1.5707963267948966);
            }
        }
    }

    private void parseFluchtungen(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.parseFluchtungen((Riss)enumeration.nextElement());
        }
    }

    private void parseFluchtungen(Riss riss) {
        Punkt punkt = null;
        Enumeration enumeration = riss.elements();
        while (enumeration.hasMoreElements()) {
            Messung messung = (Messung)enumeration.nextElement();
            switch (messung.getMessungsArt(false)) {
                case 210: {
                    punkt = messung.getFussPunkt();
                    break;
                }
                case 200: {
                    Punkt punkt2 = messung.getFussPunkt();
                    if (punkt == null || punkt2 == null || punkt2.getSymbolWinkel() != 0.0) break;
                    punkt2.setSymbolWinkel(new Linie(punkt, punkt2).getRichtung() + 1.5707963267948966);
                }
            }
        }
    }

    private void parseEinbindeMasze(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.parseEinbindeMasze((Riss)enumeration.nextElement());
        }
    }

    private void parseEinbindeMasze(Riss riss) {
        Vector<Messung> vector = new Vector<Messung>();
        OrthoLinie orthoLinie = new OrthoLinie();
        Object object = riss.elements();
        while (object.hasMoreElements()) {
            Messung messung = (Messung)object.nextElement();
            try {
                switch (messung.getMessungsArt(false)) {
                    case 210: {
                        orthoLinie.setAnfangsPunkt(messung.pz != null ? messung.pz : messung.ps);
                        orthoLinie.setEndPunkt(messung.getReferenz().pz != null ? messung.getReferenz().pz : messung.getReferenz().ps);
                    }
                    case 290: {
                        vector.addElement(messung);
                        break;
                    }
                    case 200: {
                        Messung messung2 = orthoLinie.getMessungOf(messung.pz != null ? messung.pz : messung.ps);
                        if (messung2.l1 < 0.0) {
                            messung.setBefore(true);
                        } else if (messung2.l1 > orthoLinie.getEndMass()) {
                            messung.setAfter(true);
                        }
                        if (messung.getFussPunkt() == null) break;
                        vector.addElement(messung);
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                this.addException(new Exception("Fehler in der Ortholinienlogik. Riss: " + riss.getName() + ", Messung: " + messung.getExceptionableName()));
            }
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Messung messung = (Messung)vector.elementAt(i);
            Punkt punkt = messung.getFussPunkt();
            block13: for (int j = i + 1; j < n; ++j) {
                Messung messung3 = (Messung)vector.elementAt(j);
                switch (messung3.getMessungsArt(false)) {
                    case 210: 
                    case 290: {
                        object = messung3.getFussPunkt();
                        if (punkt != object) continue block13;
                        messung.setEinbindeMass(true);
                        continue block13;
                    }
                    case 200: {
                        object = messung3.getFussPunkt();
                        if (punkt != object) continue block13;
                        messung.setEinbindeMass(true);
                        messung3.setEinbindeMass(true);
                    }
                }
            }
        }
    }

    private void parseTrafoSysteme(TrafoSystemTable trafoSystemTable) {
        Hashtable<Long, Punkt> hashtable = new Hashtable<Long, Punkt>();
        Hashtable<Long, Punkt> hashtable2 = new Hashtable<Long, Punkt>();
        Enumeration enumeration = trafoSystemTable.elements();
        while (enumeration.hasMoreElements()) {
            TrafoSystem trafoSystem = (TrafoSystem)enumeration.nextElement();
            Enumeration enumeration2 = trafoSystem.elements();
            while (enumeration2.hasMoreElements()) {
                TrafoPunkt trafoPunkt = (TrafoPunkt)enumeration2.nextElement();
                trafoPunkt.getPunkt().setTrafo(true);
                if (trafoPunkt.hasStatistik()) {
                    trafoSystem.updateStatistik(trafoPunkt.getStatistik());
                }
                DataBase.tvmax = Math.max(DataBase.tvmax, (double)trafoPunkt.getVs());
                DataBase.trmax = Math.max(DataBase.trmax, (double)trafoPunkt.getRs());
                Punkt punkt = null;
                switch (trafoSystem.getStatus()) {
                    case 8: {
                        punkt = hashtable.put(new Long(trafoPunkt.getPunkt().nr), trafoPunkt.getPunkt());
                        if (punkt == null) break;
                        punkt.setTrafoPP(true);
                        break;
                    }
                    case 9: {
                        punkt = hashtable2.put(new Long(trafoPunkt.getPunkt().nr), trafoPunkt.getPunkt());
                        if (punkt == null) break;
                        punkt.setDigitPP(true);
                    }
                }
            }
        }
    }

    public void parseNumbers() {
        block7: {
            MessungParser messungParser = this;
            if (messungParser.db.getNumSystem() == DataBase.NB.getNumSystem()) {
                int n = 0;
                while (true) {
                    if (n >= DataBase.UMNUM.size()) break block7;
                    Punkt punkt = (Punkt)DataBase.UMNUM.elementAt(n);
                    if (punkt.getUmnum() == -9L) {
                        try {
                            punkt.setUmnum(DataBase.NB.getNextNummer(punkt.createNb(), punkt.getKafPa()));
                        }
                        catch (NummerierungsBezirkException nummerierungsBezirkException) {
                            this.addException(new NummerierungsBezirkException("Punkt " + punkt.nr + " konnte nicht umnummeriert werden\n" + nummerierungsBezirkException.getMessage()));
                        }
                    }
                    ++n;
                }
            }
            int n = 0;
            while (true) {
                if (n >= DataBase.UMNUM.size()) break;
                Punkt punkt = (Punkt)DataBase.UMNUM.elementAt(n);
                if (!punkt.isFlagUM_PNR()) {
                    punkt.setUmnum(-9L);
                }
                ++n;
            }
        }
    }

    private void computePunktRefs() {
        PunktTable punktTable = new PunktTable();
        Enumeration enumeration = DataBase.UMNUM.elements();
        while (enumeration.hasMoreElements()) {
            punktTable.put((Punkt)enumeration.nextElement());
        }
        enumeration = DataBase.P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt;
            long l;
            Punkt punkt2 = (Punkt)enumeration.nextElement();
            if (punkt2.isSlavePoint()) {
                l = Long.parseLong(punkt2.getTag("REF").getValue());
                punkt = (Punkt)DataBase.P.get(l);
                if (punkt == null) {
                    this.addException(new Exception("Punkt " + punkt2.nr + " hat Referenz zu nicht vorhandenen Punkt " + l));
                } else {
                    punkt.setMasterPoint(true);
                }
                if (punktTable.contains(punkt2)) {
                    Object object;
                    boolean bl = false;
                    if (!punkt.isOn()) {
                        this.addException(new Exception("Zu Punkt " + punkt.nr + " besteht eine Referenz, hat aber keine eigene Bestimmung"));
                    } else if (punkt2.getPs() == 1 || punkt2.getPs() == 2) {
                        if (punkt2.x != punkt.x || punkt2.y != punkt.y) {
                            this.addException(new Exception("Punkt " + punkt2.nr + " hat Referenz zu Punkt " + punkt.nr + " bei ungleichen Koordinaten, Punktstatus auf 0 setzen!"));
                        } else {
                            punkt2.dx = punkt.dx;
                            punkt2.dy = punkt.dy;
                            bl = true;
                        }
                    } else {
                        if (punkt2.x != 0.0 && punkt2.y != 0.0) {
                            object = punkt2.getOriginal();
                            punkt2.dx = (float)(punkt.x - ((DPoint)object).x);
                            punkt2.dy = (float)(punkt.y - ((DPoint)object).y);
                        }
                        punkt2.x = punkt.x;
                        punkt2.y = punkt.y;
                        bl = true;
                    }
                    if (bl) {
                        punkt2.setOn(true);
                        punkt2.a = punkt.a;
                        punkt2.b = punkt.b;
                        punkt2.t = punkt.t;
                        punkt2.dl = punkt.dl;
                        punkt2.lsp = punkt.lsp;
                        punkt2.setInLinie(punkt.isInLinie());
                        object = punkt.getParameter();
                        PunktParameter punktParameter = punkt2.getParameter();
                        if (!punkt2.isUmnumFlag(16)) {
                            if (punktParameter.getKafLg() == 0 || punktParameter.getKafLg() >= ((PunktParameter)object).getKafLg()) {
                                punktParameter.setLg(((PunktParameter)object).getLg());
                            } else {
                                this.addException(new Exception("Punkt " + punkt2.nr + " besitzt h\u00f6here GST=" + punktParameter.getOutLg() + " als Referenzpunkt " + punkt.nr + " mit GST=" + ((PunktParameter)object).getOutLg() + ", GST explizit setzen!"));
                            }
                        }
                        if (!punkt2.isUmnumFlag(32)) {
                            if ((double)punktParameter.getKafLl() == 0.0 || punktParameter.getKafLl() >= ((PunktParameter)object).getKafLl()) {
                                punktParameter.setLl(((PunktParameter)object).getLl());
                            } else {
                                this.addException(new Exception("Punkt " + punkt2.nr + " besitzt h\u00f6heren GWT=" + punktParameter.getOutLl() + " als Referenzpunkt " + punkt.nr + " mit GWT=" + ((PunktParameter)object).getOutLl() + ", GWT explizit setzen!"));
                            }
                        }
                        if (!punkt2.isUmnumFlag(64)) {
                            if (punktParameter.getKafLz() == 0 || punktParameter.getKafLz() <= ((PunktParameter)object).getKafLz()) {
                                punktParameter.setLz(((PunktParameter)object).getLz());
                            } else {
                                this.addException(new Exception("Punkt " + punkt2.nr + " besitzt h\u00f6heren LZK=" + punktParameter.getOutLz() + " als Referenzpunkt " + punkt.nr + " mit LZK=" + ((PunktParameter)object).getOutLz() + ", LZK explizit setzen!"));
                            }
                        }
                        if (!punkt2.isUmnumFlag(8)) {
                            if (punktParameter.getKafLs() == 0 || punktParameter.getKafLs() >= ((PunktParameter)object).getKafLs()) {
                                punktParameter.setLs(((PunktParameter)object).getLs());
                            } else {
                                this.addException(new Exception("Punkt " + punkt2.nr + " besitzt h\u00f6heren KST=" + punktParameter.getOutLs() + " als Referenzpunkt " + punkt.nr + " mit KST=" + ((PunktParameter)object).getOutLs() + ", KST explizit setzen!"));
                            }
                        }
                        if (!punkt2.isUmnumFlag(32768)) {
                            if (punktParameter.getKafEa() == 0 || punktParameter.getKafEa() >= ((PunktParameter)object).getKafEa()) {
                                punktParameter.setEa(((PunktParameter)object).getEa());
                            } else {
                                this.addException(new Exception("Punkt " + punkt2.nr + " besitzt h\u00f6heren DES1=" + punktParameter.getOutEa() + " als Referenzpunkt " + punkt.nr + " mit DES1=" + ((PunktParameter)object).getOutEa() + ", DES1 explizit setzen!"));
                            }
                        }
                        if (!punkt2.isUmnumFlag(65536)) {
                            if (punktParameter.getKafEq() == 0 || punktParameter.getKafEq() >= ((PunktParameter)object).getKafEq()) {
                                punktParameter.setEq(((PunktParameter)object).getEq());
                            } else {
                                this.addException(new Exception("Punkt " + punkt2.nr + " besitzt h\u00f6heren DES2=" + punktParameter.getOutEq() + " als Referenzpunkt " + punkt.nr + " mit DES2=" + ((PunktParameter)object).getOutEq() + ", DES2 explizit setzen!"));
                            }
                        }
                        if (punktParameter.getPst() == 11 && (!punkt2.getOldParameter().equalsModel(punktParameter) || punkt2.isMoved())) {
                            punktParameter.setPst(12);
                        }
                        punkt2.updateParameter(punktParameter);
                    }
                }
            }
            if (!punkt2.hasTag("IND")) continue;
            l = Long.parseLong(punkt2.getTag("IND").getValue());
            punkt = (Punkt)DataBase.P.get(l);
            if (punkt == null) {
                this.addException(new Exception("Punkt " + punkt2.nr + " hat Referenz zu nicht vorhandenen Punkt " + l));
                continue;
            }
            punkt.setIndirektPoint(true);
            if (punkt2.getPa() != 29) {
                this.addException(new Exception("Punkt " + punkt2.nr + " ist indirekte Abmarkung, er muss Punktart GPU erhalten"));
            }
            if (punkt.getPa() != 20) {
                this.addException(new Exception("Punkt " + punkt.nr + " ist indirekt abgemarkt durch " + punkt2.nr + ", er muss Punktart GP erhalten"));
            }
            if (punkt2.isFortfuehrung() != punkt.isFortfuehrung()) {
                this.addException(new Exception("Punkte " + punkt2.nr + " und " + punkt.nr + " sind durch indirekte Abmarkung verbunden, sie m\u00fcssen beide fortgef\u00fchrt werden"));
            }
            if (punkt.getPst() != 13) continue;
            this.addException(new Exception("Punkt " + punkt.nr + " ist indirekt abgemarkt durch " + punkt2.nr + ", Referenz l\u00f6schen"));
        }
    }

    private void computePunktEinrechnung() {
        Object object;
        Object object2;
        Enumeration enumeration;
        OrthoLinie orthoLinie = null;
        Hashtable<Long, Punkt> hashtable = new Hashtable<Long, Punkt>();
        Hashtable<Long, Punkt> hashtable2 = new Hashtable<Long, Punkt>();
        Enumeration enumeration2 = DataBase.ME.elements();
        while (enumeration2.hasMoreElements()) {
            enumeration = (Riss)enumeration2.nextElement();
            object2 = ((DataContainer)((Object)enumeration)).elements();
            while (object2.hasMoreElements()) {
                object = (Messung)object2.nextElement();
                if (((Messung)object).getMessungsArt() != 200 || !((Messung)object).isOn() || ((Messung)object).ps.isInLinie()) continue;
                if (hashtable.containsKey(new Long(((Messung)object).ps.nr))) {
                    hashtable2.put(new Long(((Messung)object).ps.nr), ((Messung)object).ps);
                    continue;
                }
                hashtable.put(new Long(((Messung)object).ps.nr), ((Messung)object).ps);
            }
        }
        int n = 0;
        do {
            Cloneable cloneable;
            Object object3;
            int n2;
            Cloneable cloneable2;
            n = 0;
            enumeration = DataBase.ME.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (Riss)enumeration.nextElement();
                object = ((DataContainer)object2).elements();
                while (object.hasMoreElements()) {
                    cloneable2 = (Messung)object.nextElement();
                    switch (cloneable2.getMessungsArt()) {
                        case 210: {
                            orthoLinie = new OrthoLinie();
                        }
                        case 200: {
                            if (!cloneable2.isOn()) break;
                            orthoLinie.addElement(cloneable2.ps);
                            break;
                        }
                        case 290: {
                            orthoLinie.addElement(cloneable2.ps);
                            orthoLinie.setMaxEinrechenDistance(DataBase.maxEinrechenDistance);
                            if (hashtable.containsKey(new Long(orthoLinie.getAnfangsPunkt().nr)) || hashtable.containsKey(new Long(orthoLinie.getEndPunkt().nr))) break;
                            for (n2 = 1; n2 < orthoLinie.size() - 1; ++n2) {
                                try {
                                    object3 = orthoLinie.getPunktAt(n2);
                                    if (((Punkt)object3).isInLinie() || hashtable2.containsKey(new Long(((Punkt)object3).nr))) continue;
                                    hashtable.remove(new Long(((Punkt)object3).nr));
                                    ((Punkt)object3).setInLinie(true);
                                    if (((Punkt)object3).getPs() == 2 || ((Punkt)object3).getPs() == 1) {
                                        ((Punkt)object3).setPs(5);
                                        if (((Punkt)object3).isFortfuehrung() && ((Punkt)object3).getParameter().getPst() == 11) {
                                            cloneable = ((Punkt)object3).getParameter();
                                            ((PunktParameter)cloneable).setPst(12);
                                            ((Punkt)object3).updateParameter((PunktParameter)cloneable);
                                        }
                                        ((Punkt)object3).dy = 0.0f;
                                        ((Punkt)object3).dx = 0.0f;
                                    }
                                    ++n;
                                    orthoLinie.setPunktInLinieAt(n2);
                                    if (!Double.isNaN(((Punkt)object3).x) && !Double.isNaN(((Punkt)object3).y)) continue;
                                    this.addException(new Exception("Fehler beim Einrechnen von Punkt " + ((Punkt)object3).nr + " in Linie " + orthoLinie.getAnfangsPunkt().nr + "-" + orthoLinie.getEndPunkt().nr + ", ung\u00fcltiges Koordinatenergebnis"));
                                    continue;
                                }
                                catch (SurveyException surveyException) {
                                    this.addException(surveyException);
                                }
                            }
                            break;
                        }
                    }
                }
            }
            enumeration = hashtable2.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (Punkt)enumeration.nextElement();
                object = null;
                cloneable2 = null;
                n2 = 0;
                object3 = DataBase.ME.elements();
                while (object3.hasMoreElements()) {
                    cloneable = (Riss)object3.nextElement();
                    Enumeration enumeration3 = ((DataContainer)cloneable).elements();
                    while (enumeration3.hasMoreElements()) {
                        Messung messung = (Messung)enumeration3.nextElement();
                        switch (messung.getMessungsArt()) {
                            case 210: {
                                orthoLinie = new OrthoLinie();
                                orthoLinie.addElement(messung.ps);
                                break;
                            }
                            case 200: {
                                if (!((Punkt)object2).equals(messung.ps)) break;
                                n2 = 1;
                                break;
                            }
                            case 290: {
                                orthoLinie.addElement(messung.ps);
                                if (n2 != 0) {
                                    if (object == null) {
                                        object = new Linie(orthoLinie.getAnfangsPunkt(), orthoLinie.getEndPunkt());
                                    } else if (cloneable2 == null) {
                                        cloneable2 = new Linie(orthoLinie.getAnfangsPunkt(), orthoLinie.getEndPunkt());
                                        if (((Punkt)object2).isInLinie() || hashtable.containsKey(new Long(((Linie)object).pa.nr)) || hashtable.containsKey(new Long(((Linie)object).pe.nr)) || hashtable.containsKey(new Long(((Linie)cloneable2).pa.nr)) || hashtable.containsKey(new Long(((Linie)cloneable2).pe.nr))) break;
                                        GeradenSchnitt geradenSchnitt = new GeradenSchnitt((Linie)object, (Linie)cloneable2);
                                        geradenSchnitt.setMaxEinrechenDistance(DataBase.maxEinrechenDistance);
                                        try {
                                            hashtable2.remove(new Long(((Punkt)object2).nr));
                                            hashtable.remove(new Long(((Punkt)object2).nr));
                                            ++n;
                                            ((Punkt)object2).setInLinie(true);
                                            if (((Punkt)object2).getPs() == 2 || ((Punkt)object2).getPs() == 1) {
                                                ((Punkt)object2).setPs(5);
                                                if (((Punkt)object2).isFortfuehrung() && ((Punkt)object2).getParameter().getPst() == 11) {
                                                    PunktParameter punktParameter = ((Punkt)object2).getParameter();
                                                    punktParameter.setPst(12);
                                                    ((Punkt)object2).updateParameter(punktParameter);
                                                }
                                                ((Punkt)object2).dy = 0.0f;
                                                ((Punkt)object2).dx = 0.0f;
                                            }
                                            geradenSchnitt.setPunktInSchnitt((Punkt)object2);
                                            if (Double.isNaN(((Punkt)object2).x) || Double.isNaN(((Punkt)object2).y)) {
                                                this.addException(new Exception("Fehler beim Einrechnen von Punkt " + ((Punkt)object2).nr + " in Schnitt " + geradenSchnitt.getL1().pa.nr + "-" + geradenSchnitt.getL1().pe.nr + "," + geradenSchnitt.getL2().pa.nr + "-" + geradenSchnitt.getL2().pe.nr + ", ung\u00fcltiges Koordinatenergebnis"));
                                            }
                                        }
                                        catch (SurveyException surveyException) {
                                            this.addException(surveyException);
                                        }
                                    }
                                }
                                n2 = 0;
                            }
                        }
                    }
                }
            }
        } while (n != 0);
        enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Punkt)enumeration.nextElement();
            this.addException(new IFileInputException("Punkt " + ((Punkt)object2).nr + " konnte durch fehlende Bedingungen nicht eingerechnet werden!"));
        }
    }

    private void computePunktPST() {
        Enumeration enumeration = DataBase.P.elements();
        while (enumeration.hasMoreElements()) {
            int n;
            Punkt punkt = (Punkt)enumeration.nextElement();
            PunktParameter punktParameter = punkt.getParameter();
            if (punktParameter.getKafPa() < 0 || punktParameter.getPst() > -1 || (n = punkt.getInternalPs()) != 0 || !(punkt.getParameter() instanceof PunktParameterALK)) continue;
            punktParameter.setPst(0);
            punkt.updateParameter(punktParameter);
        }
    }

    private void computePunktENT() {
        Cloneable cloneable;
        Enumeration enumeration = DataBase.MK.elements();
        while (enumeration.hasMoreElements()) {
            this.testRissDate(((Riss)enumeration.nextElement()).getRissInfo());
        }
        enumeration = DataBase.T.elements();
        while (enumeration.hasMoreElements()) {
            cloneable = (TrafoSystem)enumeration.nextElement();
            if (!((TrafoSystem)cloneable).isKatasterNachweisElement()) continue;
            this.testRissDate(((ValueDataContainer)cloneable).getRissInfo());
        }
        if (KafkaIOProperties.isAutoEnt()) {
            enumeration = DataBase.P.elements();
            while (enumeration.hasMoreElements()) {
                RissInfo rissInfo;
                ValueDataContainer valueDataContainer;
                cloneable = (Punkt)enumeration.nextElement();
                if (!((Punkt)cloneable).isOn() || !((Punkt)cloneable).isKatasterNeuElement() || ((Punkt)cloneable).hasTag("edbs.ent")) continue;
                int n = Integer.MAX_VALUE;
                String string = null;
                Enumeration enumeration2 = DataBase.MK.elements();
                while (enumeration2.hasMoreElements()) {
                    valueDataContainer = (Riss)enumeration2.nextElement();
                    if (!valueDataContainer.contains((Punkt)cloneable)) continue;
                    rissInfo = ((Riss)valueDataContainer).getRissInfo();
                    try {
                        int n2 = IFormat.parseDateKey(rissInfo.getDate());
                        if (n2 >= n) continue;
                        n = n2;
                        string = rissInfo.getKeyString();
                    }
                    catch (Exception exception) {}
                }
                enumeration2 = DataBase.T.elements();
                while (enumeration2.hasMoreElements()) {
                    valueDataContainer = (TrafoSystem)enumeration2.nextElement();
                    if (!((TrafoSystem)valueDataContainer).isKatasterNachweisElement() || !((TrafoSystem)valueDataContainer).contains((Punkt)cloneable)) continue;
                    rissInfo = valueDataContainer.getRissInfo();
                    try {
                        int n3 = IFormat.parseDateKey(rissInfo.getDate());
                        if (n3 >= n) continue;
                        n = n3;
                        string = rissInfo.getKeyString();
                    }
                    catch (Exception exception) {}
                }
                if (string == null) continue;
                ((Punkt)cloneable).addTag(Tag.toString("edbs.ent", string));
            }
        }
    }

    private void computePunktAG() {
        Object object;
        DataBase.amax = 0.005;
        Enumeration enumeration = DataBase.P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            int n = punkt.getPs();
            if (n == 1) {
                punkt.setAG(1.0E-4f);
                punkt.setAZ(1.0E-4f);
                continue;
            }
            if (n != 2) continue;
            object = punkt.getStatistik();
            if (object != null) {
                punkt.setAG((float)((double)((Stat)object).getAG2() * 0.001));
                punkt.setAZ((float)((double)((Stat)object).getAZ2() * 0.001));
                continue;
            }
            punkt.setAG(punkt.g);
            punkt.setAZ(punkt.g);
        }
        int n = 0;
        int n2 = 0;
        do {
            n = 0;
            n += this.computePunktAGofMessungTable(DataBase.MG);
            n += this.computePunktAGofMessungTable(DataBase.MP);
            n += this.computePunktAGofMessungTable(DataBase.MM);
            n += this.computePunktAGofMessungTable(DataBase.MK);
            n += this.computePunktAGofMessungTable(DataBase.ME);
            n += this.computePunktAGofMessungTable(DataBase.MV);
            n += this.computePunktAGOfTrafoTable(DataBase.T);
            n += this.computePunktAGofBedingungTable(DataBase.BB);
            n += this.computePunktAGofBedingungTable(DataBase.BH);
            if (++n2 != 99) continue;
            this.addException(new Exception("Die Berechnung der Anschlussgenauigkeit hat die maximale Iterationsanzahl erreicht, Berechnung abgebrochen"));
            break;
        } while (n > 0);
        Enumeration enumeration2 = DataBase.P.elements();
        while (enumeration2.hasMoreElements()) {
            object = (Punkt)enumeration2.nextElement();
            DataBase.amax = Math.max(DataBase.amax, (double)((Punkt)object).getAG());
            DataBase.smax = Math.max(DataBase.smax, (double)((Punkt)object).getAZ());
        }
    }

    private int computePunktAGOfTrafoTable(TrafoSystemTable trafoSystemTable) {
        int n = 0;
        Enumeration enumeration = trafoSystemTable.elements();
        while (enumeration.hasMoreElements()) {
            n += this.computePunktAGOfTrafoSystem((TrafoSystem)enumeration.nextElement());
        }
        return n;
    }

    private int computePunktAGOfTrafoSystem(TrafoSystem trafoSystem) {
        Punkt punkt;
        TrafoPunkt trafoPunkt;
        int n = 0;
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MAX_VALUE;
        Punkt punkt2 = null;
        Punkt punkt3 = null;
        Enumeration enumeration = trafoSystem.elements();
        while (enumeration.hasMoreElements()) {
            trafoPunkt = (TrafoPunkt)enumeration.nextElement();
            punkt = trafoPunkt.getPunkt();
            if (punkt.ag > 0.0f) {
                d = Math.min(d, (double)punkt.ag);
            }
            if (punkt.ag > 0.0f && (double)punkt.ag > d) {
                d2 = Math.min(d2, (double)punkt.ag);
                punkt2 = punkt;
            }
            if (punkt.az > 0.0f) {
                d3 = Math.min(d3, (double)punkt.az);
            }
            if (!(punkt.az > 0.0f) || !((double)punkt.az > d3)) continue;
            d4 = Math.min(d4, (double)punkt.az);
            punkt3 = punkt;
        }
        if (d2 == Double.MAX_VALUE || d4 == Double.MAX_VALUE) {
            return 0;
        }
        enumeration = trafoSystem.elements();
        while (enumeration.hasMoreElements()) {
            try {
                double d5;
                trafoPunkt = (TrafoPunkt)enumeration.nextElement();
                punkt = trafoPunkt.getPunkt();
                Stat stat = trafoPunkt.getStatistik();
                if (stat == null) continue;
                double d6 = (double)stat.getAG2() * 0.001;
                float f = (float)(d2 + d6);
                if (punkt.ag == 0.0f || punkt.ag - f > 0.001f) {
                    punkt.setAG(f);
                    ++n;
                }
                if ((d5 = (double)stat.getAZ2() * 0.001) == 0.0) continue;
                float f2 = (float)(d4 + d5);
                if (punkt.az != 0.0f && !(punkt.az - f2 > 0.001f)) continue;
                punkt.setAZ(f2);
                ++n;
            }
            catch (Exception exception) {}
        }
        return n;
    }

    private int computePunktAGofBedingungTable(MessElementTable messElementTable) {
        int n = 0;
        Enumeration enumeration = messElementTable.elements();
        while (enumeration.hasMoreElements()) {
            n += this.computePunktAGofBedingungRiss((Riss)enumeration.nextElement());
        }
        return n;
    }

    private int computePunktAGofBedingungRiss(Riss riss) {
        int n = 0;
        Punkt punkt = null;
        for (int i = 0; i < riss.size(); ++i) {
            try {
                Punkt punkt2;
                Bedingung bedingung = (Bedingung)riss.elementAt(i);
                if (!bedingung.hasStatistik()) continue;
                Stat stat = bedingung.getStatistik();
                double d = (double)stat.getAG2() * 0.001;
                double d2 = (double)stat.getAZ2() * 0.001;
                if (bedingung.ba == 1) {
                    punkt2 = bedingung.p1.ag > bedingung.p3.ag ? bedingung.p1 : bedingung.p3;
                    n += this.setAG(punkt2, bedingung.p2, d);
                    if (!(d2 > 0.0)) continue;
                    n += this.setAZ(punkt2, bedingung.p2, d2);
                    continue;
                }
                if (bedingung.ba == 2) {
                    Punkt punkt3 = punkt2 = bedingung.p1.ag > bedingung.p2.ag ? bedingung.p1 : bedingung.p2;
                    if (bedingung.p3.ag < punkt2.ag) {
                        punkt2 = bedingung.p3;
                    }
                    n += this.setAG(punkt2, bedingung.p1, d);
                    n += this.setAG(punkt2, bedingung.p2, d);
                    n += this.setAG(punkt2, bedingung.p3, d);
                    if (!(d2 > 0.0)) continue;
                    n += this.setAZ(punkt2, bedingung.p1, d2);
                    n += this.setAZ(punkt2, bedingung.p2, d2);
                    n += this.setAZ(punkt2, bedingung.p3, d2);
                    continue;
                }
                if (bedingung.ba == 3) {
                    punkt = bedingung.p1.ag > bedingung.p2.ag ? bedingung.p1 : bedingung.p2;
                    continue;
                }
                if (bedingung.ba == 0 && punkt != null) {
                    punkt2 = bedingung.p1.ag > bedingung.p2.ag ? bedingung.p1 : bedingung.p2;
                    n += this.setAG(punkt2, punkt, d);
                    if (!(d2 > 0.0)) continue;
                    n += this.setAZ(punkt2, punkt, d2);
                    continue;
                }
                if (bedingung.ba == 4) {
                    punkt2 = bedingung.p1.ag > bedingung.p2.ag ? bedingung.p1 : bedingung.p2;
                    n += this.setAG(punkt2, bedingung.p3, d);
                    if (!(d2 > 0.0)) continue;
                    n += this.setAZ(punkt2, bedingung.p3, d2);
                    continue;
                }
                if (bedingung.ba != 5) continue;
                n += this.setAG(bedingung.p1, bedingung.p2, d);
                if (!(d2 > 0.0)) continue;
                n += this.setAZ(bedingung.p1, bedingung.p2, d2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    private int computePunktAGofMessungTable(MessElementTable messElementTable) {
        int n = 0;
        Enumeration enumeration = messElementTable.elements();
        while (enumeration.hasMoreElements()) {
            n += this.computePunktAGofMessungRiss((Riss)enumeration.nextElement());
        }
        return n;
    }

    private int computePunktAGofMessungRiss(Riss riss) {
        int n = 0;
        Punkt punkt = null;
        Punkt punkt2 = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < riss.size(); ++i) {
            try {
                double d5;
                double d6;
                Cloneable cloneable;
                Messung messung = (Messung)riss.elementAt(i);
                if (messung.isFehler()) continue;
                int n2 = messung.getMessungsArt();
                Punkt punkt3 = messung.ps;
                Punkt punkt4 = messung.pz;
                Stat stat = messung.getStatistik();
                if ((n2 == 270 || n2 == 230 || n2 == 280) && messung.hasReferenz()) {
                    punkt3 = messung.getReferenz().ps;
                }
                if (n2 == 210) {
                    punkt = punkt4 != null ? punkt4 : punkt3;
                    d = messung.l1;
                    d4 = stat == null ? 0.0 : Math.abs((double)stat.getV(1) * 1.0E-5);
                    cloneable = messung.getReferenz();
                    if (cloneable == null) continue;
                    punkt2 = ((Messung)cloneable).pz != null ? ((Messung)cloneable).pz : ((Messung)cloneable).ps;
                    d2 = ((Messung)cloneable).l1;
                    Stat stat2 = ((Messung)cloneable).getStatistik();
                    d6 = Math.abs(((Messung)cloneable).l1 - messung.l1);
                    if (stat2 != null && d6 != 0.0) {
                        MessungParser messungParser = this;
                        double d7 = (messungParser.db.getSteuerDaten().getMassMf(d6, ((Messung)cloneable).getGewichte().getG1()) + d6 * d4) * Math.max((double)stat.getNv(1) * 0.1, 1.0);
                        if (d7 != 0.0) {
                            n += this.setAG(punkt, punkt2, d7);
                            short s = stat2.getEv(1);
                            if (!Stat.isValue((int)s) || s == 0) {
                                s = 1;
                            }
                            d5 = d7 / Math.sqrt((double)s * 0.01);
                            n += this.setAZ(punkt, punkt2, d5);
                        }
                    }
                }
                if (stat == null) continue;
                if (n2 == 200 || n2 == 290 || n2 == 240) {
                    cloneable = punkt4 != null ? punkt4 : punkt3;
                    double d8 = messung.l1;
                    double d9 = messung.l1 - d;
                    double d10 = d2 - messung.l1;
                    d5 = d2 == 0.0 || d9 < d10 ? d9 : d10;
                    Punkt punkt5 = d2 == 0.0 || d9 < d10 ? punkt : punkt2;
                    MessungParser messungParser = this;
                    double d11 = (messungParser.db.getSteuerDaten().getMassMf(d5, messung.getGewichte().getG1()) + d5 * d4) * Math.max((double)stat.getNv(1) * 0.1, 1.0);
                    MessungParser messungParser2 = this;
                    double d12 = messungParser2.db.getSteuerDaten().getOrdMf(0.0, 1.0, messung.getGewichte().getG3()) * Math.max((double)stat.getNv(2) * 0.1, 1.0);
                    double d13 = Math.sqrt(d11 * d11 + d12 * d12);
                    if (d13 != 0.0) {
                        n += this.setAG(punkt5, (Punkt)cloneable, d13);
                        short s = stat.getEv(1);
                        if (!Stat.isValue((int)s) || s == 0) {
                            s = 1;
                        }
                        double d14 = d13 / Math.sqrt((double)s * 0.01);
                        n += this.setAZ(punkt5, (Punkt)cloneable, d14);
                    }
                }
                if (punkt3 == null || punkt4 == null) continue;
                double d15 = 0.0;
                d6 = 0.0;
                if (messung.l2 != 0.0 && (n2 == 210 || n2 == 200 || n2 == 290)) {
                    d15 = (double)stat.getAG4() * 0.001 + Math.abs(messung.l2) * d4;
                    short s = stat.getEv(3);
                    if (!Stat.isValue((int)s) || s == 0) {
                        s = 1;
                    }
                    d6 = d15 / Math.sqrt((double)s * 0.01);
                } else {
                    d15 = (double)stat.getAG2() * 0.001;
                    d6 = (double)stat.getAZ2() * 0.001;
                }
                if (d15 == 0.0) continue;
                n += this.setAG(punkt3, punkt4, d15);
                n += this.setAZ(punkt3, punkt4, d6);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    private int setAG(Punkt punkt, Punkt punkt2, double d) {
        float f;
        if (punkt.ag != 0.0f) {
            f = punkt.ag + (float)d;
            if (punkt2.ag == 0.0f || punkt2.ag - f > 0.001f) {
                punkt2.setAG(f);
                return 1;
            }
        }
        if (punkt2.ag != 0.0f) {
            f = punkt2.ag + (float)d;
            if (punkt.ag == 0.0f || punkt.ag - f > 0.001f) {
                punkt.setAG(f);
                return 1;
            }
        }
        return 0;
    }

    private int setAZ(Punkt punkt, Punkt punkt2, double d) {
        float f;
        if (punkt.az != 0.0f) {
            f = punkt.az + (float)d;
            if (punkt2.az == 0.0f || punkt2.az - f > 0.001f) {
                punkt2.setAZ(f);
                return 1;
            }
        }
        if (punkt2.az != 0.0f) {
            f = punkt2.az + (float)d;
            if (punkt.az == 0.0f || (double)(punkt.az - f) > 0.001) {
                punkt.setAZ(f);
                return 1;
            }
        }
        return 0;
    }

    private void computePunktLZ() {
        float f;
        Cloneable cloneable;
        if (!DataBase.hasStatistik) {
            return;
        }
        MessungParser messungParser = this;
        Enumeration enumeration = messungParser.db.messungen();
        while (enumeration.hasMoreElements()) {
            cloneable = (Messung)enumeration.nextElement();
            if (!((Messung)cloneable).hasStatistik()) continue;
            f = (float)((double)((Messung)cloneable).getStatistik().getMaxEgk() * 0.001);
            DataBase.zmax = Math.max(DataBase.zmax, (double)f);
            if (((Messung)cloneable).getP1() != null) {
                ((Messung)cloneable).getP1().zl = Math.max(((Messung)cloneable).getP1().zl, f);
            }
            if (((Messung)cloneable).getP2() == null) continue;
            ((Messung)cloneable).getP2().zl = Math.max(((Messung)cloneable).getP2().zl, f);
        }
        MessungParser messungParser2 = this;
        enumeration = messungParser2.db.allBedingungen();
        while (enumeration.hasMoreElements()) {
            cloneable = (Bedingung)enumeration.nextElement();
            if (!((Bedingung)cloneable).hasStatistik()) continue;
            f = (float)((double)((Bedingung)cloneable).getStatistik().getMaxEgk() * 0.001);
            DataBase.zmax = Math.max(DataBase.zmax, (double)f);
            if (((Bedingung)cloneable).getP1() != null) {
                ((Bedingung)cloneable).getP1().zl = Math.max(((Bedingung)cloneable).getP1().zl, f);
            }
            if (((Bedingung)cloneable).getP2() == null) continue;
            ((Bedingung)cloneable).getP2().zl = Math.max(((Bedingung)cloneable).getP2().zl, f);
        }
        MessungParser messungParser3 = this;
        enumeration = messungParser3.db.trafoPunkte();
        while (enumeration.hasMoreElements()) {
            cloneable = (TrafoPunkt)enumeration.nextElement();
            if (!((TrafoPunkt)cloneable).hasStatistik()) continue;
            f = (float)((double)((TrafoPunkt)cloneable).getStatistik().getMaxEgk() * 0.001);
            DataBase.zmax = Math.max(DataBase.zmax, (double)f);
            if (((TrafoPunkt)cloneable).getPunkt() == null) continue;
            ((TrafoPunkt)cloneable).getPunkt().zl = Math.max(((TrafoPunkt)cloneable).getPunkt().zl, f);
        }
    }

    private void testRissDate(RissInfo rissInfo) {
        if (rissInfo.hasDate()) {
            int n = 0;
            try {
                n = IFormat.parseDateKey(rissInfo.getDate());
                if (n == 0) {
                    this.addException(new Exception("Riss " + rissInfo.getName() + " hat ung\u00fcltiges Datum: " + rissInfo.getDate()));
                }
            }
            catch (Exception exception) {
                this.addException(new Exception("Riss " + rissInfo.getName() + " hat ung\u00fcltiges Datum: " + rissInfo.getDate() + ", " + exception.getMessage()));
            }
        } else if (KafkaIOProperties.isAutoEnt()) {
            this.addException(new Exception("Riss " + rissInfo.getName() + " fehlt die Datumsangabe D="));
        }
    }

    private void parseMessungen() {
        Messung messung;
        Object object;
        Hashtable<Object, Messung> hashtable = new Hashtable<Object, Messung>();
        Object object2 = DataBase.MG.objects();
        while (object2.hasMoreElements()) {
            object = (Messung)object2.nextElement();
            messung = hashtable.put(((Messung)object).pz, (Messung)object);
            if (messung == null) continue;
            ((Messung)object).mNr = messung.mNr + 1;
        }
        hashtable.clear();
        object2 = null;
        object = DataBase.MP.objects();
        while (object.hasMoreElements()) {
            Messung messung2;
            messung = (Messung)object.nextElement();
            if (messung.getMessungsArt() != 230) continue;
            if (messung.ps != null) {
                object2 = messung.ps;
            }
            if (messung.pz.isStandPunkt() || (messung2 = hashtable.put(messung.getPolarMessungHashKey((Punkt)object2), messung)) == null) continue;
            messung.mNr = messung2.mNr + 1;
        }
        hashtable = null;
    }

    public void computeInternPunkte() {
        this.computeInternPunkte(DataBase.MM);
        this.computeInternPunkte(DataBase.MK);
        this.computeInternPunkte(DataBase.ME);
        this.computeInternPunkte(DataBase.MV);
    }

    public void computeInternPunkte(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.computeInternPunkte((Riss)enumeration.nextElement());
        }
    }

    public void computeInternPunkte(Riss riss) {
        OrthoLinie orthoLinie = null;
        boolean bl = false;
        for (int i = 0; i < riss.size(); ++i) {
            try {
                Messung messung = (Messung)riss.elementAt(i);
                switch (messung.getMessungsArt(false)) {
                    case 210: {
                        orthoLinie = new OrthoLinie();
                        orthoLinie.setAnfangsPunkt(messung.pz == null || messung.pz.nr == 0L ? messung.ps : messung.pz);
                        orthoLinie.setAnfangsMasse(messung.l1, messung.pz == null || messung.pz.nr == 0L ? messung.l2 : 0.0);
                        orthoLinie.setEndPunkt(messung.getReferenz().pz == null || messung.getReferenz().pz.nr == 0L ? messung.getReferenz().ps : messung.getReferenz().pz);
                        orthoLinie.setEndOrdinate(messung.getReferenz().pz == null || messung.getReferenz().pz.nr == 0L ? messung.getReferenz().l2 : 0.0);
                    }
                    case 200: 
                    case 290: {
                        if (messung.pz != null && messung.pz.nr != 0L || messung.getWerteBelegung() != 3 || messung.l2 == 0.0) break;
                        Punkt punkt = orthoLinie.getLotfusspunktOf(messung.pz == null || messung.pz.nr == 0L ? messung.ps : messung.pz);
                        if (messung.pz == null) {
                            messung.pz = punkt;
                        } else {
                            messung.pz.x = punkt.x;
                            messung.pz.y = punkt.y;
                        }
                        Messung messung2 = orthoLinie.getMessungOf(messung.ps);
                        if (!(messung.l2 < 0.0 && messung2.l2 > 0.0) && (!(messung.l2 > 0.0) || !(messung2.l2 < 0.0))) break;
                        this.addException(new Exception("Fehler in OrthoMessung " + messung.toMessageString() + ", berechnete Ordinate ergibt falsches Vorzeichen"));
                    }
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void natureRadien() {
        this.natureRadien(DataBase.flurstueckLinien());
        this.natureRadien(DataBase.gebaeudeLinien());
        this.natureRadien(DataBase.nutzungLinien());
        this.natureRadien(DataBase.bodenLinien());
        this.natureRadien(DataBase.topLinien());
    }

    private void natureRadien(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            Linie linie = (Linie)enumeration.nextElement();
            if (!linie.isRadiusKoo()) continue;
            linie.setRadius(linie.getRadius() * DataBase.getStreckeMasstab((linie.pa.y + linie.pe.y) / 2.0));
            linie.setRadiusKoo(false);
        }
    }

    public void parseAlkLinien() {
        Object object;
        Object object2;
        Object object3;
        this.parseLinien(DataBase.FLST, true);
        this.parseLinien(DataBase.GEB, false);
        this.parseLinien(DataBase.TOP, false);
        HashClearStack hashClearStack = new HashClearStack();
        MessungParser messungParser = this;
        Object object4 = messungParser.db.flurstuecke();
        while (object4.hasMoreElements()) {
            object3 = (Flurstueck)object4.nextElement();
            object2 = ((DataContainer)object3).elements();
            while (object2.hasMoreElements()) {
                object = (Linie)object2.nextElement();
                if (((Linie)object).pe == null) continue;
                hashClearStack.put(((Linie)object).pa, object);
                hashClearStack.put(((Linie)object).pe, object);
            }
        }
        object4 = new Vector();
        object3 = hashClearStack.keys();
        while (object3.hasMoreElements()) {
            object2 = (Punkt)object3.nextElement();
            object = hashClearStack.elements(object2);
            while (object.hasMoreElements()) {
                ((Vector)object4).addElement(object.nextElement());
                if (((Vector)object4).size() <= 0) continue;
                ((Punkt)object2).setSymbolWinkel(0.0);
                try {
                    MessungParser.setSymbolWinkelOfPunkt((Punkt)object2, (Vector)object4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((Vector)object4).removeAllElements();
            }
        }
        MessungParser messungParser2 = this;
        object3 = messungParser2.db.gebaeude();
        block6: while (object3.hasMoreElements()) {
            object2 = (GObject)object3.nextElement();
            object = ((DataContainer)object2).elements();
            while (object.hasMoreElements()) {
                Linie linie = (Linie)object.nextElement();
                if (linie.getEb() != 42) continue;
                ((GObject)object2).setFortfuehrung(true);
                continue block6;
            }
        }
    }

    private void parseLinien(Vector vector, boolean bl) {
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.parseLinien((GObject)enumeration.nextElement(), hashtable, hashtable2, bl);
        }
    }

    private void parseLinien(GObject gObject, Hashtable hashtable, Hashtable hashtable2, boolean bl) {
        int n = gObject.size();
        boolean bl2 = false;
        block4: for (int i = 0; i < n; ++i) {
            Linie linie = (Linie)gObject.elementAt(i);
            if (linie.pa != null) {
                linie.pa.setUsedLine(true);
            }
            if (linie.pe != null) {
                linie.pe.setUsedLine(true);
            }
            if (linie.isBogen() && Math.abs(linie.getRadius()) < linie.getLaenge() / 2.0) {
                this.addException(new IException("Der Radius der Linie " + linie.toString() + " ist zu klein", "Radius wurde auf das Minimum gesetzt."));
                linie.l2 = linie.getLaenge() / 2.0 + 1.0E-4;
            }
            if (!bl) continue;
            Flurstueck flurstueck = (Flurstueck)gObject;
            switch (linie.getLs()) {
                case 1: {
                    if (bl2 && flurstueck.isFortfuehrung() && !flurstueck.defMultiArea()) {
                        this.addException(new IException("Flurst\u00fcck " + flurstueck.toMiniStringWithNutzung() + " besitzt mehrere Fl\u00e4chen", "Es kann nur eine Fl\u00e4che als Umring angegeben werden"));
                    }
                    bl2 = true;
                }
                case 0: 
                case 2: {
                    if (flurstueck.isNutzstueck()) {
                        if (!linie.isFlurstuecksLinie(true)) {
                            this.addException(new IException("Nutzungsart " + flurstueck.toMiniStringWithNutzung() + " enth\u00e4lt eine ung\u00fcltige Linie", "Linie '" + linie.toString() + "' ist keine g\u00fcltige Begrenzung einer Nutzungsart"));
                        }
                    } else if (!linie.isFlurstuecksLinie(false)) {
                        this.addException(new IException("Flurst\u00fcck " + flurstueck.toMiniStringWithNutzung() + " enth\u00e4lt eine ung\u00fcltige Linie", "Linie '" + linie.toString() + "' ist keine Flurst\u00fccksbegrenzungslinie"));
                    }
                    Linie linie2 = hashtable.put(linie, linie);
                    Flurstueck flurstueck2 = null;
                    if (flurstueck.hasBuchung()) {
                        flurstueck2 = hashtable2.put(linie, flurstueck);
                    }
                    if (linie2 == null) continue block4;
                    if (linie2.getEb() != linie.getEb()) {
                        this.addException(new IException("Linie " + linie.getObjectName() + " ist mit unterschiedlicher Ebene doppelt vorhanden", " " + linie.getEb() + " != " + linie2.getEb()));
                    }
                    if ((linie.isBogen() || linie2.isBogen()) && Math.abs(linie.getRadius()) != Math.abs(linie2.getRadius())) {
                        this.addException(new IException("Linie " + linie.getObjectName() + " ist mit unterschiedlichem Radius doppelt vorhanden", " " + Math.abs(linie.getRadius()) + " != " + Math.abs(linie2.getRadius())));
                    }
                    if (linie2.isNotGrundstuecksgrenze()) {
                        linie.setNotGrundstuecksgrenze(true);
                        continue block4;
                    }
                    if (linie2.isGrundstuecksgrenze()) {
                        linie.setGrundstuecksgrenze(true);
                        continue block4;
                    }
                    if (!flurstueck.hasBuchung() || flurstueck2 == null) continue block4;
                    if (flurstueck2.getBlaetterAsString().equals(flurstueck.getBlaetterAsString())) {
                        linie.setNotGrundstuecksgrenze(true);
                        linie2.setNotGrundstuecksgrenze(true);
                        continue block4;
                    }
                    linie.setGrundstuecksgrenze(true);
                    linie2.setGrundstuecksgrenze(true);
                    continue block4;
                }
            }
        }
    }

    public static void createSymbolWinkel(FlurstueckTable flurstueckTable) {
        Object object;
        Object object2;
        Object object3;
        HashClearStack hashClearStack = new HashClearStack();
        Object object4 = flurstueckTable.elements();
        while (object4.hasMoreElements()) {
            object3 = (Flurstueck)object4.nextElement();
            object2 = ((DataContainer)object3).elements();
            while (object2.hasMoreElements()) {
                object = (Linie)object2.nextElement();
                if (((Linie)object).pe == null) continue;
                hashClearStack.put(((Linie)object).pa, object);
                hashClearStack.put(((Linie)object).pe, object);
            }
        }
        object4 = new Vector();
        object3 = hashClearStack.keys();
        while (object3.hasMoreElements()) {
            object2 = (Punkt)object3.nextElement();
            object = hashClearStack.elements(object2);
            while (object.hasMoreElements()) {
                ((Vector)object4).addElement(object.nextElement());
                if (((Vector)object4).size() <= 0) continue;
                ((Punkt)object2).setSymbolWinkel(0.0);
                try {
                    MessungParser.setSymbolWinkelOfPunkt((Punkt)object2, (Vector)object4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((Vector)object4).removeAllElements();
            }
        }
    }

    public void createPunktOska() {
        Enumeration enumeration = DataBase.P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (!(punkt.getParameter() instanceof PunktParameterALK) || punkt.getOska() != 0) continue;
            PunktParameterALK punktParameterALK = (PunktParameterALK)punkt.getParameter();
            punktParameterALK.setOska(Oska.createOska(punktParameterALK.getKafPa(), punktParameterALK.getVa()));
            punkt.updateParameter(punktParameterALK);
        }
    }

    private void createLinieOska() {
        Object object;
        Object object2;
        Enumeration enumeration = DataBase.FLST.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Flurstueck)enumeration.nextElement();
            int n = 0;
            n = ((Flurstueck)object2).isGemarkung() ? 231 : (((Flurstueck)object2).isFlur() ? 232 : 233);
            object = ((DataContainer)object2).elements();
            while (object.hasMoreElements()) {
                LinieParameter linieParameter;
                Linie linie = (Linie)object.nextElement();
                if (linie.getLa() == 2 && linie.getOska() == 0) {
                    linieParameter = linie.getParameter();
                    linieParameter.setOska(n);
                    linie.setParameter(linieParameter);
                }
                if (linie.getEb() != 47 || linie.getOska() != 0) continue;
                linieParameter = linie.getParameter();
                linieParameter.setOska(241);
                linie.setParameter(linieParameter);
            }
        }
        enumeration = DataBase.GEB.elements();
        while (enumeration.hasMoreElements()) {
            object2 = ((DataContainer)enumeration.nextElement()).elements();
            while (object2.hasMoreElements()) {
                Linie linie = (Linie)object2.nextElement();
                if (linie.getOska() != 0) continue;
                switch (linie.getLa()) {
                    case 0: {
                        object = linie.getParameter();
                        ((LinieParameter)object).setOska(242);
                        linie.setParameter((LinieParameter)object);
                        break;
                    }
                    case 3: {
                        object = linie.getParameter();
                        ((LinieParameter)object).setOska(1013);
                        linie.setParameter((LinieParameter)object);
                        break;
                    }
                }
            }
        }
        enumeration = DataBase.TOP.elements();
        while (enumeration.hasMoreElements()) {
            object2 = ((DataContainer)enumeration.nextElement()).elements();
            while (object2.hasMoreElements()) {
                Linie linie = (Linie)object2.nextElement();
                if (linie.getOska() != 0) continue;
                switch (linie.getLa()) {
                    case 0: {
                        object = linie.getParameter();
                        ((LinieParameter)object).setOska(242);
                        linie.setParameter((LinieParameter)object);
                        break;
                    }
                }
            }
        }
    }

    private void computeFlstVereinigung() {
        Enumeration enumeration = DataBase.FLST.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            if (!flurstueck.isVereinigungStammstueck()) continue;
            Hashtable<Object, Linie> hashtable = new Hashtable<Object, Linie>();
            Vector vector = DataBase.FLST.getVereinigungTeilstueckeFrom(flurstueck);
            if (flurstueck.getBuchFlaeche() != 0.0) {
                this.addException(new IException("F\u00fcr das Flurst\u00fcck " + flurstueck.toMiniStringWithNutzung() + " wurde eine Fl\u00e4che vorgegeben", "Bei einem Vereinigungsst\u00fcck ist die Vorgabe der Fl\u00e4che ung\u00fcltig"));
            }
            flurstueck.setBuchFlaeche(0.0);
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                Flurstueck flurstueck2 = (Flurstueck)enumeration2.nextElement();
                flurstueck.setBuchFlaeche(flurstueck.getBuchFlaeche() + flurstueck2.getBuchFlaeche());
                Enumeration enumeration3 = flurstueck2.elements();
                while (enumeration3.hasMoreElements()) {
                    Linie linie = (Linie)enumeration3.nextElement();
                    Linie linie2 = hashtable.put(linie.getHashKey(), linie);
                    if (linie2 == null) continue;
                    linie2.setUntergang(true);
                }
            }
        }
    }

    private void computeFlstFlaeche() {
        Enumeration enumeration = DataBase.FLST.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            if (!flurstueck.hasLocation()) {
                DPoint dPoint = flurstueck.getMitte();
                flurstueck.x = dPoint.x;
                flurstueck.y = dPoint.y;
            }
            if (flurstueck.getBerechnungsArt() != 1 && flurstueck.getBerechnungsArt() < 10) {
                double d = Math.abs(flurstueck.getPolygonFlaeche()) * DataBase.getFlaecheMasstab(flurstueck.y);
                if (d == 0.0) continue;
                flurstueck.setAktFlaeche(d);
                if (flurstueck.getBerechnungsArt() == 2) continue;
                flurstueck.setBerechnungsArt(6);
                continue;
            }
            if (flurstueck.getBuchFlaeche() > 0.0) {
                flurstueck.setAktFlaeche(flurstueck.getBuchFlaeche());
                continue;
            }
            flurstueck.setAktFlaeche(Math.abs(flurstueck.getPolygonFlaeche()) * DataBase.getFlaecheMasstab(flurstueck.y));
        }
    }

    private void testFlstArt() {
        int n;
        Flurstueck flurstueck;
        Enumeration enumeration;
        Flurstueck flurstueck2 = new Flurstueck();
        Flurstueck flurstueck3 = new Flurstueck();
        Flurstueck flurstueck4 = new Flurstueck();
        Flurstueck flurstueck5 = new Flurstueck();
        Hashtable<CallSite, Flurstueck> hashtable = new Hashtable<CallSite, Flurstueck>();
        Flurstueck flurstueck6 = null;
        if (DataBase.model.getModel() == 2) {
            enumeration = DataBase.FLST.elements();
            while (enumeration.hasMoreElements()) {
                flurstueck = (Flurstueck)enumeration.nextElement();
                if (flurstueck.getNutzung() > -1) {
                    this.addException(new IException("Flurst\u00fcck " + flurstueck.toMiniString() + " hat einen Nutzungsartenschl\u00fcssel: " + IFormat.i03.format(flurstueck.getNutzung()) + " die Zuordnung von Nutzungsarten ist im ALKIS-Model ung\u00fcltig"));
                }
                if (flurstueck.getVorgabeNummer() != null) {
                    flurstueck6 = (Flurstueck)hashtable.get(flurstueck.getKennzeichen() + flurstueck.getVorgabeNummer().toLowerCase());
                    if (flurstueck6 != null) {
                        this.addException(new IException("Flurst\u00fccke " + flurstueck6.toMiniString() + " und " + flurstueck.toMiniString() + " haben die gleiche Vorgabenummer", "Vorgabenummer: " + flurstueck.getVorgabeNummerAsString()));
                    } else {
                        hashtable.put((CallSite)((Object)(flurstueck.getKennzeichen() + flurstueck.getVorgabeNummer().toLowerCase())), flurstueck);
                    }
                }
                if (flurstueck.isStammstueck()) {
                    flurstueck2 = flurstueck;
                    if (!flurstueck.isFortfuehrung()) continue;
                    if (flurstueck.getBuchFlaeche() == 0.0) {
                        this.addException(new IException("Flurst\u00fcck " + flurstueck.toMiniString() + " wird fortgef\u00fchrt", "Buchfl\u00e4che mu\u00df angegeben werden"));
                    }
                    if ((n = DataBase.FLST.countTeilstuecke(flurstueck)) == 0) {
                        if (flurstueck.getLage() != null) continue;
                        this.addException(new IException("Flurst\u00fcck " + flurstueck.toMiniString() + " wird ohne Teilst\u00fccke fortgef\u00fchrt", "Lagebezeichnung fehlt"));
                        continue;
                    }
                    if (n == 1) {
                        this.addException(new IException("Flurst\u00fcck " + flurstueck.toMiniString() + " wird geteilt", "Die Angabe nur einen Teilst\u00fccks ist ung\u00fcltig"));
                        continue;
                    }
                    if (flurstueck.getLage() != null) {
                        this.addException(new IException("Flurst\u00fcck " + flurstueck.toMiniString() + " wird geteilt", "Die Angabe der Lagebezeichnung ist ung\u00fcltig"));
                    }
                    if (flurstueck.hasStrasse()) {
                        this.addException(new IException("Flurst\u00fcck " + flurstueck.toMiniString() + " wird geteilt", "Der Angabe des Stra\u00dfenschl\u00fcssels ist ung\u00fcltig"));
                    }
                    if (flurstueck.getKlasse() == null) continue;
                    this.addException(new IException("Flurst\u00fcck " + flurstueck.toMiniString() + " wird geteilt", "Die Angabe der Klassifizierung ist ung\u00fcltig"));
                    continue;
                }
                if (flurstueck.isStammTeilstueck()) {
                    this.addException(new IException("Flurst\u00fcck " + flurstueck.toMiniString() + " besitzt fehlerhafte Flurst\u00fccksart"));
                    continue;
                }
                if (flurstueck.isTeilstueck()) {
                    flurstueck4 = flurstueck;
                    if (flurstueck4.getGemeinde() <= 0) {
                        flurstueck4.setGemeinde(flurstueck2.getGemeinde());
                    }
                    if (!flurstueck2.isStammstueckFrom(flurstueck)) {
                        this.addException(new IException("Fl\u00e4che " + flurstueck.toMiniString() + " ist Teilst\u00fcck", "Das zugeh\u00f6rige Stammst\u00fcck wurde nicht angegeben"));
                    }
                    if (flurstueck2.isFortfuehrung() && flurstueck.getLage() == null) {
                        this.addException(new IException("Fl\u00e4che " + flurstueck.toMiniString() + " ist Teilst\u00fcck", "Die Angabe der Lagebezeichnung fehlt"));
                    }
                    if (flurstueck.getBuchFlaeche() == 0.0) continue;
                    if (flurstueck.getBerechnungsArt() == 0) {
                        this.addException(new IException("Fl\u00e4che " + flurstueck.toMiniString() + " ist Teilst\u00fcck mit vorgegebener Fl\u00e4che", "Es mu\u00df eine Berechnungsart angegeben werden"));
                        continue;
                    }
                    if (flurstueck.getBerechnungsArt() != 2) continue;
                    this.addException(new IException("Fl\u00e4che " + flurstueck.toMiniString() + " ist Teilst\u00fcck mit vorgegebener Fl\u00e4che", "Bei einem Restst\u00fcck ist die Vorgabe der Fl\u00e4che ung\u00fcltig"));
                    continue;
                }
                if (!flurstueck.isNutzstueck()) continue;
                this.addException(new IException("Flurst\u00fcck " + flurstueck.toMiniString() + " besitzt fehlerhafte Flurst\u00fccksart"));
            }
        } else {
            enumeration = DataBase.FLST.elements();
            while (enumeration.hasMoreElements()) {
                NutzungsArt nutzungsArt;
                flurstueck = (Flurstueck)enumeration.nextElement();
                if (flurstueck.getOska() == 0) {
                    flurstueck.setOska(flurstueck.createOska());
                }
                if (flurstueck.getNutzung() > -1 && (nutzungsArt = NutzungsArt.getNutzungsArt(flurstueck.getNutzung())) == null) {
                    this.addException(new IException("Flurst\u00fcck " + flurstueck.toMiniString() + " hat einen ung\u00fcltigen Nutzungsartenschl\u00fcssel: " + IFormat.i03.format(flurstueck.getNutzung())));
                }
                if (flurstueck.getVorgabeNummer() != null) {
                    flurstueck6 = (Flurstueck)hashtable.get(flurstueck.getKennzeichen() + flurstueck.getVorgabeNummer().toLowerCase());
                    if (flurstueck6 != null) {
                        this.addException(new IException("Flurst\u00fccke " + flurstueck6.toMiniString() + " und " + flurstueck.toMiniString() + " haben die gleiche Vorgabenummer", "Vorgabenummer: " + flurstueck.getVorgabeNummerAsString()));
                    } else {
                        hashtable.put((CallSite)((Object)(flurstueck.getKennzeichen() + flurstueck.getVorgabeNummer().toLowerCase())), flurstueck);
                    }
                }
                if (flurstueck.isStammstueck()) {
                    int n2;
                    flurstueck2 = flurstueck;
                    if (!flurstueck.isFortfuehrung()) continue;
                    if (flurstueck.getBuchFlaeche() == 0.0) {
                        this.addException(new IException("Flurst\u00fcck " + flurstueck.toMiniString() + " wird fortgef\u00fchrt", "Buchfl\u00e4che mu\u00df angegeben werden"));
                    }
                    if ((n2 = DataBase.FLST.countTeilstuecke(flurstueck)) == 0) {
                        if (flurstueck.getLage() != null) continue;
                        this.addException(new IException("Flurst\u00fcck " + flurstueck.toMiniString() + " wird ohne Teilst\u00fccke fortgef\u00fchrt", "Lagebezeichnung fehlt"));
                        continue;
                    }
                    if (n2 == 1) {
                        this.addException(new IException("Flurst\u00fcck " + flurstueck.toMiniString() + " wird geteilt", "Die Angabe nur einen Teilst\u00fccks ist ung\u00fcltig"));
                        continue;
                    }
                    if (flurstueck.getLage() != null) {
                        this.addException(new IException("Flurst\u00fcck " + flurstueck.toMiniString() + " wird geteilt", "Die Angabe der Lagebezeichnung ist ung\u00fcltig"));
                    }
                    if (flurstueck.getNutzung() != -1) {
                        this.addException(new IException("Flurst\u00fcck " + flurstueck.toMiniString() + " wird geteilt", "Die Angabe der Nutzungsart ist ung\u00fcltig"));
                    }
                    if (flurstueck.hasStrasse()) {
                        this.addException(new IException("Flurst\u00fcck " + flurstueck.toMiniString() + " wird geteilt", "Der Angabe des Stra\u00dfenschl\u00fcssels ist ung\u00fcltig"));
                    }
                    if (flurstueck.getKlasse() == null) continue;
                    this.addException(new IException("Flurst\u00fcck " + flurstueck.toMiniString() + " wird geteilt", "Die Angabe der Klassifizierung ist ung\u00fcltig"));
                    continue;
                }
                if (flurstueck.isStammTeilstueck()) {
                    flurstueck3 = flurstueck;
                    if (!flurstueck2.isStammstueckFrom(flurstueck)) {
                        this.addException(new IException("Fl\u00e4che " + flurstueck.toMiniString() + " ist Teilst\u00fcck", "Das zugeh\u00f6rige Stammst\u00fcck wurde nicht angegeben"));
                    }
                    if (!flurstueck2.isFortfuehrung()) continue;
                    int n3 = DataBase.FLST.countNutzstuecke(flurstueck);
                    if (n3 == 0) {
                        this.addException(new IException("Fl\u00e4che " + flurstueck.toMiniString() + " ist Teilst\u00fcck", "Die Angabe der Nutzungsart fehlt"));
                    } else if (n3 == 1) {
                        this.addException(new IException("Fl\u00e4che " + flurstueck.toMiniString() + " ist Teilst\u00fcck mit Nutzungsarten", "Die Angabe nur einer Nutzungsart ist ung\u00fcltig"));
                    }
                    if (flurstueck.getLage() != null) continue;
                    this.addException(new IException("Fl\u00e4che " + flurstueck.toMiniString() + " ist Teilst\u00fcck mit Nutzungsarten", "Die Angabe der Lagebezeichnung fehlt"));
                    continue;
                }
                if (flurstueck.isTeilstueck()) {
                    if (flurstueck.equalsIgnoreNutzung(flurstueck4)) {
                        this.addException(new IException("Fl\u00e4che " + flurstueck.toMiniStringWithNutzung() + " ist Nutzungsartenfl\u00e4che", "Das zugeh\u00f6rige Teilst\u00fcck wurde nicht angegeben"));
                    }
                    flurstueck4 = flurstueck;
                    if (!flurstueck2.isStammstueckFrom(flurstueck)) {
                        this.addException(new IException("Fl\u00e4che " + flurstueck.toMiniString() + " ist Teilst\u00fcck", "Das zugeh\u00f6rige Stammst\u00fcck wurde nicht angegeben"));
                    }
                    if (flurstueck2.isFortfuehrung() && flurstueck.getLage() == null) {
                        this.addException(new IException("Fl\u00e4che " + flurstueck.toMiniString() + " ist Teilst\u00fcck", "Die Angabe der Lagebezeichnung fehlt"));
                    }
                    if (flurstueck.getBuchFlaeche() == 0.0) continue;
                    if (flurstueck.getBerechnungsArt() == 0) {
                        this.addException(new IException("Fl\u00e4che " + flurstueck.toMiniString() + " ist Teilst\u00fcck mit vorgegebener Fl\u00e4che", "Es mu\u00df eine Berechnungsart angegeben werden"));
                        continue;
                    }
                    if (flurstueck.getBerechnungsArt() != 2) continue;
                    this.addException(new IException("Fl\u00e4che " + flurstueck.toMiniString() + " ist Teilst\u00fcck mit vorgegebener Fl\u00e4che", "Bei einem Restst\u00fcck ist die Vorgabe der Fl\u00e4che ung\u00fcltig"));
                    continue;
                }
                if (!flurstueck.isNutzstueck()) continue;
                if (!flurstueck3.isStammTeilstueckFrom(flurstueck) && !flurstueck2.isStammTeilstueckFrom(flurstueck)) {
                    this.addException(new IException("Fl\u00e4che " + flurstueck.toMiniStringWithNutzung() + " ist Nutzungsartenfl\u00e4che", "Das zugeh\u00f6rige Teilst\u00fcck wurde nicht angegeben"));
                }
                if (flurstueck2.isFortfuehrung() || flurstueck3.isFortfuehrung()) {
                    if (flurstueck.getLage() != null) {
                        this.addException(new IException("Fl\u00e4che " + flurstueck.toMiniStringWithNutzung() + " ist Nutzungsartenfl\u00e4che", "Die Angabe der Lagebezeichnung ist ung\u00fcltig"));
                    }
                    if (flurstueck.hasStrasse()) {
                        this.addException(new IException("Fl\u00e4che " + flurstueck.toMiniStringWithNutzung() + " ist Nutzungsartenfl\u00e4che", "Die Angabe des Stra\u00dfenschl\u00fcssels ist ung\u00fcltig"));
                    }
                    if (flurstueck.getVorgabeNummer() != null) {
                        this.addException(new IException("Fl\u00e4che " + flurstueck.toMiniStringWithNutzung() + " ist Nutzungsartenfl\u00e4che", "Die Angabe einer Vorgabenummer ist ung\u00fcltig"));
                    }
                }
                if (flurstueck.getBuchFlaeche() == 0.0) continue;
                if (flurstueck.getBerechnungsArt() == 0) {
                    this.addException(new IException("Fl\u00e4che " + flurstueck.toMiniStringWithNutzung() + " ist Nutzungsart mit vorgegebener Fl\u00e4che", "Es mu\u00df eine Berechnungsart angegeben werden"));
                    continue;
                }
                if (flurstueck.getBerechnungsArt() != 2) continue;
                this.addException(new IException("Fl\u00e4che " + flurstueck.toMiniStringWithNutzung() + " ist Nutzungsart mit vorgegebener Fl\u00e4che", "Bei einem Restst\u00fcck ist die Vorgabe der Fl\u00e4che ung\u00fcltig"));
            }
        }
        enumeration = DataBase.FLST.elements();
        block2: while (enumeration.hasMoreElements()) {
            flurstueck = (Flurstueck)enumeration.nextElement();
            if (!flurstueck.isStammstueck()) continue;
            n = flurstueck.getVorgabeNummer() != null ? 1 : 0;
            Enumeration enumeration2 = DataBase.FLST.getTeilstueckeFrom(flurstueck).elements();
            while (enumeration2.hasMoreElements()) {
                Flurstueck flurstueck7 = (Flurstueck)enumeration2.nextElement();
                if (!flurstueck7.isStammTeilstueck() && !flurstueck7.isTeilstueck() || n == 0) continue;
                this.addException(new IException("Das Stammst\u00fcck " + flurstueck.toMiniString() + " hat Teilst\u00fccke", "Die Angabe der Vorgabenummer " + flurstueck.getVorgabeNummerAsString() + " ist ung\u00fcltig"));
                continue block2;
            }
        }
    }

    private void createFlstGeom() {
        for (int i = DataBase.FLST.size() - 1; i >= 0; --i) {
            Cloneable cloneable;
            Flurstueck flurstueck = (Flurstueck)DataBase.FLST.elementAt(i);
            if (flurstueck.size() > 0) continue;
            Vector vector = null;
            if (FlurstueckArt.isVereinigungstueck(flurstueck.getArt())) {
                vector = DataBase.FLST.getVereinigungTeilstueckeFrom(flurstueck);
            } else if (FlurstueckArt.isFlurstueck(flurstueck.getArt())) {
                vector = DataBase.FLST.getTeilstueckeFrom(flurstueck);
            } else if (FlurstueckArt.isTeilstueck(flurstueck.getArt())) {
                vector = DataBase.FLST.getNutzstueckeFrom(flurstueck);
            }
            if (vector == null || vector.size() <= 0) continue;
            Vector<Cloneable> vector2 = new Vector<Cloneable>();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Flurstueck flurstueck2 = (Flurstueck)enumeration.nextElement();
                for (int j = 0; j < flurstueck2.size(); ++j) {
                    Linie linie = (Linie)flurstueck2.elementAt(j);
                    if (linie.isEnde() || linie.getLa() != 2 && linie.getLa() != 0) continue;
                    int n = 0;
                    n = vector2.indexOf(linie);
                    if (n >= 0 && flurstueck2.indexOf(linie) == j) {
                        vector2.removeElementAt(n);
                        continue;
                    }
                    cloneable = (Linie)linie.clone();
                    ((Linie)cloneable).setLinie();
                    vector2.addElement(cloneable);
                }
            }
            boolean bl = false;
            if (vector2.size() > 2) {
                flurstueck.setAutoGeom(true);
                bl = this.createPoly(vector2, false);
                if (bl) {
                    bl = this.createPoly(vector2, true);
                }
            }
            if (bl) {
                for (int j = 0; j < vector2.size(); ++j) {
                    Linie linie = (Linie)vector2.elementAt(j);
                    if (j == 0) {
                        linie.setStart();
                    } else {
                        linie.setMitte();
                    }
                    flurstueck.addElement(linie);
                }
                flurstueck.addElement(new Linie(9, ((Linie)flurstueck.lastElement()).pe, null));
            } else if (progressiveGeomSearchMode) {
                for (int j = 0; j < vector2.size(); ++j) {
                    flurstueck.addElement((Linie)vector2.elementAt(j));
                }
                GObjectManipulator gObjectManipulator = new GObjectManipulator(flurstueck);
                try {
                    gObjectManipulator.repair();
                    bl = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!bl) {
                boolean bl2 = this.createOpenPoly(vector2);
                for (int j = 0; j < vector2.size(); ++j) {
                    flurstueck.addElement((Linie)vector2.elementAt(j));
                }
                if (!bl2) {
                    this.addException(new IException("Fehler bei der Umringserstellung des Flurst\u00fccks " + flurstueck.toMiniString(), "der Umring konnte nicht vollst\u00e4ndig verkn\u00fcpft werden"));
                }
            }
            if (flurstueck.getPolygonFlaeche() != 0.0) continue;
            double d = 0.0;
            boolean bl3 = true;
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                cloneable = (Flurstueck)enumeration2.nextElement();
                double d2 = ((GObject)cloneable).getPolygonFlaeche() * DataBase.getFlaecheMasstab(((Flurstueck)cloneable).y);
                if (d2 == 0.0) {
                    bl3 = false;
                    continue;
                }
                d += Math.abs(d2);
            }
            if (!bl3) continue;
            flurstueck.setGeoFlaeche(d);
        }
    }

    private boolean createOpenPoly(Vector vector) {
        Linie linie;
        int n;
        int n2;
        boolean bl;
        int n3;
        int n4 = -1;
        for (n3 = 0; n3 < vector.size(); ++n3) {
            Linie linie2 = (Linie)vector.elementAt(n3);
            bl = false;
            n2 = 0;
            boolean bl2 = false;
            for (n = 0; n < vector.size(); ++n) {
                if (n == n3) {
                    bl2 = true;
                    continue;
                }
                linie = (Linie)vector.elementAt(n);
                if (linie2.pa.equals(linie.pa) || linie2.pa.equals(linie.pe)) {
                    bl = true;
                }
                if (!linie2.pe.equals(linie.pa) && !linie2.pe.equals(linie.pe)) continue;
                n2 = 1;
            }
            if (bl2) continue;
            if (bl && n2 != 0) {
                linie2.setMitte();
                continue;
            }
            if (n2 != 0) {
                linie2.setStart();
                if (n4 != -1) continue;
                n4 = n3;
                continue;
            }
            if (bl) {
                linie2.setEnde();
                if (n4 != -1) continue;
                n4 = n3;
                continue;
            }
            linie2.setLinie();
        }
        if (n4 == -1) {
            for (n3 = 0; n3 < vector.size(); ++n3) {
                if (!((Linie)vector.elementAt(n3)).isMitte()) continue;
                return false;
            }
            return true;
        }
        Linie linie3 = this.changeLines(vector, 0, n4);
        if (linie3.isEnde()) {
            linie3.skip();
        }
        linie3.setStart();
        for (int i = 1; i < vector.size(); ++i) {
            bl = false;
            for (n2 = i; n2 < vector.size(); ++n2) {
                Linie linie4 = (Linie)vector.elementAt(n2);
                if (linie4.isLinie()) continue;
                if (linie3.pe.equals(linie4.pa)) {
                    linie3 = this.changeLines(vector, i, n2);
                    bl = true;
                    break;
                }
                if (!linie3.pe.equals(linie4.pe)) continue;
                linie3 = this.changeLines(vector, i, n2).skip();
                bl = true;
                break;
            }
            if (bl) {
                linie3.setMitte();
                continue;
            }
            linie3.setEnde();
            n2 = 0;
            boolean bl3 = false;
            for (n = i; n < vector.size(); ++n) {
                linie = (Linie)vector.elementAt(n);
                if (linie.isStart()) {
                    linie3 = this.changeLines(vector, i, n);
                    n2 = 1;
                    break;
                }
                if (linie.isEnde()) {
                    linie3 = this.changeLines(vector, i, n).skip();
                    linie3.setStart();
                    n2 = 1;
                    break;
                }
                if (!linie.isMitte()) continue;
                bl3 = true;
            }
            if (n2 != 0 || !bl3) continue;
            for (n = i; n < vector.size(); ++n) {
                ((Linie)vector.elementAt(n)).setLinie();
            }
            return false;
        }
        return true;
    }

    private boolean createPoly(Vector vector, boolean bl) {
        Linie linie = this.searchStartLinie(vector, bl);
        if (linie == null) {
            return false;
        }
        Linie linie2 = this.changeLines(vector, 0, vector.indexOf(linie));
        for (int i = 1; i < vector.size(); ++i) {
            Linie linie3 = null;
            int n = -1;
            for (int j = i; j < vector.size(); ++j) {
                Linie linie4 = (Linie)vector.elementAt(j);
                Linie linie5 = null;
                if (linie2.pe == linie4.pa) {
                    linie5 = linie4;
                } else if (linie2.pe == linie4.pe) {
                    linie5 = linie4.skip();
                }
                if (linie5 == null) continue;
                if (linie3 != null) {
                    PolarAufnahme polarAufnahme = new PolarAufnahme();
                    polarAufnahme.setStandPunkt(linie2.pe);
                    polarAufnahme.setAnschlussPunkt(linie2.pa);
                    if (!(polarAufnahme.getMessungOf((Punkt)linie3.pe).l1 < polarAufnahme.getMessungOf((Punkt)linie5.pe).l1)) continue;
                    linie3 = linie5;
                    n = j;
                    continue;
                }
                linie3 = linie5;
                n = j;
            }
            if (n < 0) {
                return false;
            }
            linie2 = this.changeLines(vector, i, n);
        }
        return true;
    }

    private Linie searchStartLinie(Vector vector, boolean bl) {
        Linie linie = null;
        for (int i = 0; i < vector.size(); ++i) {
            linie = (Linie)vector.elementAt(i);
            int n = 0;
            for (int j = 0; j < vector.size(); ++j) {
                Linie linie2 = (Linie)vector.elementAt(j);
                if (bl) {
                    if (!linie.pa.equals(linie2.pa) && !linie.pa.equals(linie2.pe)) continue;
                    ++n;
                    continue;
                }
                if (!linie.pe.equals(linie2.pa) && !linie.pe.equals(linie2.pe)) continue;
                ++n;
            }
            if (n != 2) continue;
            if (bl) {
                return linie.skip();
            }
            return linie;
        }
        return null;
    }

    private Linie changeLines(Vector vector, int n, int n2) {
        if (n == n2) {
            return (Linie)vector.elementAt(n2);
        }
        Linie linie = (Linie)vector.elementAt(n2);
        vector.setElementAt(vector.elementAt(n), n2);
        vector.setElementAt(linie, n);
        return linie;
    }

    private void computeRestFlaeche() {
        Enumeration enumeration = DataBase.FLST.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            if (!flurstueck.isFortfuehrung() || !flurstueck.isStammstueck()) continue;
            Punkt punkt = new Punkt();
            int n = 0;
            double d = 0.0;
            int n2 = 0;
            Flurstueck flurstueck2 = null;
            Vector vector = DataBase.FLST.getTeilstueckeFrom(flurstueck);
            Object object2 = vector.elements();
            while (object2.hasMoreElements()) {
                Flurstueck flurstueck3 = (Flurstueck)object2.nextElement();
                if (flurstueck3.isStammTeilstueck()) {
                    double d2 = 0.0;
                    object = new Punkt();
                    int n3 = 0;
                    Flurstueck flurstueck4 = null;
                    int n4 = 16;
                    Vector vector2 = DataBase.FLST.getNutzstueckeFrom(flurstueck3);
                    boolean bl = false;
                    Enumeration enumeration2 = vector2.elements();
                    while (enumeration2.hasMoreElements()) {
                        Flurstueck flurstueck5 = (Flurstueck)enumeration2.nextElement();
                        if (flurstueck5.getFlaeche() > 0.0) {
                            if (flurstueck5.isReststueck()) {
                                this.addException(new IException("Fl\u00e4che " + flurstueck5.toMiniStringWithNutzung() + " ist Restst\u00fcck", "Es wurde eine Fl\u00e4che berechnet und \u00fcbernommen"));
                            } else {
                                d2 += flurstueck5.getFlaeche();
                            }
                            if (flurstueck5.x != 0.0) {
                                ((Punkt)object).x += flurstueck5.x;
                                ((Punkt)object).y += flurstueck5.y;
                                ++n3;
                            }
                        } else if (flurstueck5.isReststueck()) {
                            if (flurstueck4 != null) {
                                this.addException(new IException("Fl\u00e4che " + flurstueck5.toMiniStringWithNutzung() + " ist Restst\u00fcck", "Es kann nur eine Fl\u00e4che als Restfl\u00e4che markiert werden"));
                            }
                            flurstueck4 = flurstueck5;
                        } else {
                            this.addException(new IException("Fl\u00e4che " + flurstueck5.toMiniStringWithNutzung(), "Es konnte keine Fl\u00e4che berechnet werden"));
                        }
                        if (flurstueck5.getBerechnungsArt() >= 10) {
                            bl = true;
                        }
                        if (flurstueck5.getBerechnungsArt() >= n4) continue;
                        n4 = flurstueck5.getBerechnungsArt();
                    }
                    if (flurstueck4 != null) {
                        if (flurstueck3.getFlaeche() > 0.0) {
                            flurstueck4.setAktFlaeche(flurstueck3.getFlaeche() - d2);
                            d2 += flurstueck4.getAktFlaeche();
                            flurstueck4 = null;
                        } else if (flurstueck3.isReststueck()) {
                            if (flurstueck2 != null) {
                                this.addException(new IException("Teilst\u00fcck " + flurstueck3.toMiniString() + " ist Restst\u00fcck", "Es kann nur eine Fl\u00e4che als Restfl\u00e4che markiert werden"));
                            }
                            flurstueck2 = flurstueck3;
                        } else {
                            this.addException(new IException("Teilst\u00fcck " + flurstueck3.toMiniString(), "Es konnte keine Fl\u00e4che berechnet werden"));
                        }
                    }
                    if (flurstueck3.getAktFlaeche() > 0.0) {
                        if (flurstueck3.getBerechnungsArt() < 10 && Math.abs(flurstueck3.getAktFlaeche() - d2) > 0.1 && !bl) {
                            this.addException(new IException("Teilst\u00fcck " + flurstueck3.toMiniString(), "Fl\u00e4chenberechnung und Summe der Nutzungen weichen um " + GeoNumberFormat.m01.format(flurstueck3.getAktFlaeche() - d2).toString() + "m\u02db ab"));
                        }
                    } else {
                        flurstueck3.setAktFlaeche(d2);
                    }
                    if (flurstueck4 == null) {
                        d += flurstueck3.getAktFlaeche();
                    }
                    if (flurstueck3.x == 0.0 && n3 > 1) {
                        flurstueck3.x = ((Punkt)object).x / (double)n3;
                        flurstueck3.y = ((Punkt)object).y / (double)n3;
                    }
                    if (flurstueck3.getBerechnungsArt() == 0) {
                        flurstueck3.setBerechnungsArt(n4);
                    }
                } else if (flurstueck3.isReststueck()) {
                    if (flurstueck2 != null) {
                        this.addException(new IException("Teilst\u00fcck " + flurstueck3.toMiniString(), "Es kann nur eine Teilst\u00fcck als Restfl\u00e4che markiert werden"));
                    }
                    flurstueck2 = flurstueck3;
                } else if (flurstueck3.getFlaeche() > 0.0) {
                    d += flurstueck3.getFlaeche();
                } else {
                    this.addException(new IException("Teilst\u00fcck " + flurstueck3.toMiniString(), "Es konnte keine Fl\u00e4che berechnet werden"));
                }
                if (flurstueck3.x > 0.0) {
                    punkt.x += flurstueck3.x;
                    punkt.y += flurstueck3.y;
                    ++n;
                }
                if (flurstueck3.getBerechnungsArt() >= n2 && n2 != 0) continue;
                n2 = flurstueck3.getBerechnungsArt();
            }
            if (flurstueck2 != null) {
                if (flurstueck.getBerechnungsArt() < 10) {
                    flurstueck.setBerechnungsArt(10);
                    flurstueck.setAktFlaeche(flurstueck.getBuchFlaeche());
                }
                flurstueck2.setAktFlaeche(flurstueck.getBuchFlaeche() - d);
                d += flurstueck2.getFlaeche();
                if (flurstueck2.isStammTeilstueck()) {
                    object2 = null;
                    double d3 = 0.0;
                    Vector vector3 = DataBase.FLST.getNutzstueckeFrom(flurstueck2);
                    object = vector3.elements();
                    while (object.hasMoreElements()) {
                        Flurstueck flurstueck6 = (Flurstueck)object.nextElement();
                        if (flurstueck6.isReststueck()) {
                            object2 = flurstueck6;
                            continue;
                        }
                        d3 += flurstueck6.getFlaeche();
                    }
                    if (object2 != null) {
                        ((Flurstueck)object2).setAktFlaeche(flurstueck2.getFlaeche() - d3);
                    }
                }
            }
            if (flurstueck.getAktFlaeche() > 0.0) {
                if (flurstueck.getBerechnungsArt() < 10 && d > 0.0 && Math.abs(flurstueck.getAktFlaeche() - d) > 0.1) {
                    this.addException(new IException("Flurst\u00fcck " + flurstueck.toMiniString(), "Fl\u00e4chenberechnung und Summe der Teilst\u00fccke weichen um " + IFormat.f_1.format(flurstueck.getAktFlaeche() - d) + "m\u02db ab"));
                }
            } else {
                flurstueck.setAktFlaeche(d);
            }
            if (flurstueck.x == 0.0 && n > 1) {
                flurstueck.x = punkt.x / (double)n;
                flurstueck.y = punkt.y / (double)n;
            }
            if (flurstueck.getBerechnungsArt() != 0 || n2 <= 2) continue;
            flurstueck.setBerechnungsArt(n2);
        }
    }

    private void computeRoundedFlaeche() {
        Enumeration enumeration = DataBase.FLST.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck;
            Flurstueck flurstueck2 = (Flurstueck)enumeration.nextElement();
            if (!flurstueck2.isFortfuehrung() || !flurstueck2.isStammstueck()) continue;
            Vector vector = DataBase.FLST.getTeilstueckeFrom(flurstueck2);
            if (DataBase.FLST.countTeilstuecke(flurstueck2) == 0) {
                flurstueck2.setRoundedFlaeche((int)Math.rint(flurstueck2.getFlaeche()));
            } else {
                int n = 0;
                flurstueck = null;
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    Flurstueck flurstueck3 = (Flurstueck)enumeration2.nextElement();
                    int n2 = (int)Math.rint(flurstueck3.getFlaeche());
                    flurstueck3.setRoundedFlaeche(n2);
                    n += n2;
                    if (!flurstueck3.isReststueck()) continue;
                    flurstueck = flurstueck3;
                }
                int n3 = n - (int)Math.rint(flurstueck2.getFlaeche());
                if (Math.abs(n3) > 1 && flurstueck2.getBerechnungsArt() < 10) {
                    this.addException(new IException("Fehler bei der Verteilung der Rundungsfehler des Flurst\u00fccks " + flurstueck2.toMiniString(), "Fl\u00e4chendifferenz > 1m\u02db (D=" + n3 + ")"));
                }
                if (n3 != 0) {
                    if (flurstueck2.getBerechnungsArt() >= 10) {
                        flurstueck2.setRoundedFlaeche((int)Math.rint(flurstueck2.getFlaeche()));
                        this.verteileFlaecheDiff(flurstueck2, vector, -n3);
                    } else if (flurstueck != null) {
                        flurstueck.setRoundedFlaeche(flurstueck.getRoundedFlaeche() - n3);
                        flurstueck2.setRoundedFlaeche((int)Math.rint(flurstueck2.getFlaeche()));
                    } else {
                        flurstueck2.setRoundedFlaeche(n);
                    }
                } else {
                    flurstueck2.setRoundedFlaeche((int)Math.rint(flurstueck2.getFlaeche()));
                }
            }
            if (DataBase.FLST.countNutzstuecke(flurstueck2) > 0) {
                this.trimNutzstuecke(flurstueck2, flurstueck2.getBerechnungsArt() >= 10);
            }
            Enumeration enumeration3 = vector.elements();
            while (enumeration3.hasMoreElements()) {
                flurstueck = (Flurstueck)enumeration3.nextElement();
                if (DataBase.FLST.countNutzstuecke(flurstueck) <= 0) continue;
                this.trimNutzstuecke(flurstueck, flurstueck2.getBerechnungsArt() >= 10);
            }
        }
    }

    private void trimNutzstuecke(Flurstueck flurstueck, boolean bl) {
        Vector vector = DataBase.FLST.getNutzstueckeFrom(flurstueck);
        int n = 0;
        Flurstueck flurstueck2 = null;
        Flurstueck flurstueck3 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck4 = (Flurstueck)enumeration.nextElement();
            int n2 = (int)Math.rint(flurstueck4.getFlaeche());
            flurstueck4.setRoundedFlaeche(n2);
            n += n2;
            if (flurstueck4.isReststueck()) {
                flurstueck2 = flurstueck4;
            }
            if (flurstueck3 == null) {
                flurstueck3 = flurstueck4;
                continue;
            }
            if (!(flurstueck3.getFlaeche() < flurstueck4.getFlaeche())) continue;
            flurstueck3 = flurstueck4;
        }
        int n3 = n - flurstueck.getRoundedFlaeche();
        if (Math.abs(n3) > 1 && flurstueck.getBerechnungsArt() < 10 && !bl) {
            this.addException(new IException("Fehler bei der Verteilung der Rundungsfehler der Teilfl\u00e4che " + flurstueck.toMiniString(), "Fl\u00e4chendifferenz > 1m\u02db (D=" + n3 + ")"));
        }
        if (n3 != 0) {
            if (flurstueck.getBerechnungsArt() >= 10 || bl) {
                this.verteileFlaecheDiff(flurstueck, vector, -n3);
            } else if (flurstueck2 != null) {
                flurstueck2.setRoundedFlaeche(flurstueck2.getRoundedFlaeche() - n3);
            } else if (flurstueck3 != null) {
                flurstueck3.setRoundedFlaeche(flurstueck3.getRoundedFlaeche() - n3);
            } else {
                this.addException(new IException("Fehler bei der Verteilung der Rundungsfehler der Teilfl\u00e4che " + flurstueck.toMiniString(), "keine Nutzungsartenfl\u00e4che gefunden"));
            }
        }
    }

    private void verteileFlaecheDiff(Flurstueck flurstueck, Vector vector, int n) {
        int n2;
        Object object;
        int n3 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (Flurstueck)enumeration.nextElement();
            if (((Flurstueck)object).getBerechnungsArt() >= 10) continue;
            if (((Flurstueck)object).getBerechnungsArt() == 2) {
                ((Flurstueck)object).setRoundedFlaeche(((Flurstueck)object).getRoundedFlaeche() + n);
                return;
            }
            n3 += ((Flurstueck)object).getRoundedFlaeche();
        }
        int n4 = 0;
        object = vector.elements();
        while (object.hasMoreElements()) {
            Flurstueck flurstueck2 = (Flurstueck)object.nextElement();
            if (flurstueck2.getBerechnungsArt() >= 10) continue;
            n2 = (int)Math.rint((double)flurstueck2.getRoundedFlaeche() * (double)n / (double)n3);
            flurstueck2.setRoundedFlaeche(flurstueck2.getRoundedFlaeche() + n2);
            n4 += n2;
        }
        if (n != n4) {
            int n5 = n - n4;
            int n6 = 0;
            n2 = -1;
            Hashtable<Integer, Flurstueck> hashtable = new Hashtable<Integer, Flurstueck>();
            for (int i = 0; i < Math.abs(n5); ++i) {
                n6 = 0;
                for (int j = 0; j < vector.size(); ++j) {
                    int n7;
                    Flurstueck flurstueck3 = (Flurstueck)vector.elementAt(j);
                    if (flurstueck3.getBerechnungsArt() >= 10 || (n7 = flurstueck3.getRoundedFlaeche()) <= n6 || hashtable.put(new Integer(j), flurstueck3) != null) continue;
                    n6 = n7;
                    n2 = j;
                }
                if (n2 < 0) continue;
                Flurstueck flurstueck4 = (Flurstueck)vector.elementAt(n2);
                flurstueck4.setRoundedFlaeche(flurstueck4.getRoundedFlaeche() + (n5 > 0 ? 1 : -1));
                n5 += n5 > 0 ? -1 : 1;
            }
            if (n5 != 0) {
                this.addException(new IException("Bei der Verteilung auf die Sollfl\u00e4che " + flurstueck.toMiniString() + " konnten die Rundungsfehler nicht verteilt werden", "Restfehler=" + n5));
            }
        }
    }

    public void computeFlstAreaExtends() {
        DataBase.maxAreaProportion = 0.001;
        DataBase.maxAreaDifference = 0.001;
        Enumeration enumeration = DataBase.FLST.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            double d = flurstueck.getBuchFlaeche();
            double d2 = flurstueck.getGeoFlaeche();
            if (Double.isNaN(d2)) {
                this.addException(new IException("Fehler im Fl\u00e4chenumring, Fl\u00e4chenberechnung nicht m\u00f6glich, Flurst\u00fcck " + flurstueck.getExceptionableName()));
                continue;
            }
            if (d == 0.0 || d2 == 0.0) continue;
            double d3 = d2 - d;
            double d4 = 100.0 * d3 / d;
            DataBase.maxAreaProportion = Math.max(DataBase.maxAreaProportion, Math.abs(d4));
            DataBase.maxAreaDifference = Math.max(DataBase.maxAreaDifference, Math.abs(d3));
        }
    }

    private final void testGebaeudeArt(DataContainerTable dataContainerTable) {
        Enumeration enumeration = dataContainerTable.elements();
        while (enumeration.hasMoreElements()) {
            Gebaeude gebaeude = (Gebaeude)enumeration.nextElement();
            if (!gebaeude.hasLeitzeichen()) continue;
            GebaeudeKennzeichen gebaeudeKennzeichen = gebaeude.getLeitzeichen();
            if (gebaeudeKennzeichen.getGemeinde() <= 0) {
                this.addException(new IException(gebaeude.getExceptionableName(), "ung\u00fcltiges Gemeindekennzeichen"));
            }
            if (gebaeudeKennzeichen.getStrasse() <= 0) {
                this.addException(new IException(gebaeude.getExceptionableName(), "ung\u00fcltiger Stra\u00dfenschl\u00fcssel"));
            }
            if (gebaeudeKennzeichen.getHausNummer() <= 0) {
                this.addException(new IException(gebaeude.getExceptionableName(), "ung\u00fcltige Hausnummer"));
            }
            if (gebaeudeKennzeichen.getLfdNummer() >= DataBase.model.getHauptHausLfdNummer()) continue;
            this.addException(new IException(gebaeude.getExceptionableName(), "ung\u00fcltige laufende Nummer"));
        }
    }

    public void computeAlkisLinien() {
        this.computeAlkisLinien(DataBase.FLST);
        this.computeAlkisLinien(DataBase.NUTZ);
        this.computeAlkisLinien(DataBase.BODEN);
        this.computeAlkisLinien(DataBase.GEB);
        this.computeAlkisLinien(DataBase.TOP);
    }

    private void computeAlkisLinien(Vector vector) {
        Hashtable<Linie, Linie> hashtable = new Hashtable<Linie, Linie>(50);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            GObject gObject = (GObject)enumeration.nextElement();
            hashtable.clear();
            Enumeration enumeration2 = gObject.elements();
            while (enumeration2.hasMoreElements()) {
                Linie linie = (Linie)enumeration2.nextElement();
                linie.setDefaultParameter(gObject.getLineDefaults());
                Linie linie2 = hashtable.put(linie, linie);
                if (linie2 != null) {
                    linie.setAnchorLine(true);
                    linie2.setAnchorLine(true);
                }
                if (linie.pa != null) {
                    linie.pa.setUsedLine(true);
                }
                if (linie.pe != null) {
                    linie.pe.setUsedLine(true);
                }
                if (!linie.isBogen() || !(Math.abs(linie.getRadius()) < linie.getLaenge() / 2.0)) continue;
                this.addException(new IException("Der Radius der Linie " + linie.toString() + " ist zu klein", "Radius wurde auf das Minimum gesetzt."));
                linie.l2 = linie.getLaenge() / 2.0 + 1.0E-4;
            }
        }
    }

    public static void computeAlkisFlurstuecke(FlurstueckTable flurstueckTable) {
        long l = System.currentTimeMillis();
        DRectangle dRectangle = DataBase.getBounds();
        double d = dRectangle.y;
        double d2 = dRectangle.x;
        double d3 = dRectangle.width / 2.0;
        double d4 = dRectangle.height / 2.0;
        MessungParser.computeAlkisFlurstuecke(flurstueckTable, new DRectangle(d, d2, d3, d4));
        MessungParser.computeAlkisFlurstuecke(flurstueckTable, new DRectangle(d, d2 + d4, d3, d4));
        MessungParser.computeAlkisFlurstuecke(flurstueckTable, new DRectangle(d + d3, d2, d3, d4));
        MessungParser.computeAlkisFlurstuecke(flurstueckTable, new DRectangle(d + d3, d2 + d4, d3, d4));
        if (KafPlot.debug()) {
            System.out.println("MessungsParser.computeAlkisFlurstuecke.time: " + (System.currentTimeMillis() - l));
        }
    }

    private static void computeAlkisFlurstuecke(FlurstueckTable flurstueckTable, DRectangle dRectangle) {
        Object object;
        Flurstueck flurstueck;
        long l = System.currentTimeMillis();
        KeyedHashtable keyedHashtable = new KeyedHashtable(flurstueckTable.size() * 8 / 4);
        PunktTable punktTable = new PunktTable();
        Enumeration enumeration = flurstueckTable.elements();
        while (enumeration.hasMoreElements()) {
            flurstueck = (Flurstueck)enumeration.nextElement();
            if (!flurstueck.intersectsRect(dRectangle)) continue;
            if (flurstueck.isTeilstueck()) {
                flurstueck.setFortfuehrung(true);
                continue;
            }
            boolean bl = flurstueck.isFortfuehrung();
            object = flurstueck.elements();
            while (object.hasMoreElements()) {
                Flurstueck flurstueck2;
                Linie linie = (Linie)object.nextElement();
                if (bl) {
                    punktTable.put(linie.pa);
                }
                if (linie.pe == null) continue;
                if (linie.pa.isFortfuehrung()) {
                    flurstueck.setFortfuehrung(true);
                }
                if (linie.pe.isFortfuehrung()) {
                    flurstueck.setFortfuehrung(true);
                }
                if ((flurstueck2 = (Flurstueck)keyedHashtable.put(linie, flurstueck)) == null) continue;
                Linie linie2 = (Linie)keyedHashtable.getKey(linie);
                LinieParameter linieParameter = linie.getParameter();
                int n = flurstueck.getGemeinde();
                int n2 = flurstueck2.getGemeinde();
                boolean bl2 = false;
                if (n != n2 && n >= 0 && n2 >= 0) {
                    if (n / 1000000 != n2 / 1000000) {
                        linieParameter.setSig2(1105);
                        bl2 = true;
                    } else if (n / 100000 != n2 / 100000) {
                        linieParameter.setSig2(1106);
                        bl2 = true;
                    } else if (n / 1000 != n2 / 1000) {
                        linieParameter.setSig2(1101);
                        bl2 = true;
                    } else {
                        linieParameter.setSig2(1107);
                        bl2 = true;
                    }
                } else if (flurstueck.getGemarkung() != flurstueck2.getGemarkung()) {
                    linieParameter.setSig2(1103);
                    bl2 = true;
                } else if (flurstueck.getFlur() != flurstueck2.getFlur()) {
                    linieParameter.setSig2(1102);
                    bl2 = true;
                }
                if (flurstueck.getTeil() > 0 || flurstueck2.getTeil() > 0) {
                    if (flurstueck.getTeil() <= 0 || flurstueck2.getTeil() <= 0) {
                        linieParameter.setEb(1);
                        bl2 = true;
                    } else if (flurstueck.getZaehler() != flurstueck2.getZaehler() || flurstueck.getNenner() != flurstueck2.getNenner()) {
                        linieParameter.setEb(1);
                        bl2 = true;
                    }
                }
                if (bl2) {
                    linie.setParameter(linieParameter);
                    linie2.setParameter(linieParameter);
                }
                if (flurstueck.equalsBlatt(flurstueck2)) {
                    linie.setNotGrundstuecksgrenze(true);
                    linie2.setNotGrundstuecksgrenze(true);
                } else {
                    linie.setGrundstuecksgrenze(true);
                    linie2.setGrundstuecksgrenze(true);
                }
                AbstractLage abstractLage = flurstueck.getLage();
                AbstractLage abstractLage2 = flurstueck2.getLage();
                if (abstractLage == null || abstractLage2 == null) continue;
                if (abstractLage.getStrasseKey() != abstractLage2.getStrasseKey()) {
                    linie.setLagegrenze(true);
                    linie2.setLagegrenze(true);
                    linie.setAdressegrenze(true);
                    linie2.setAdressegrenze(true);
                    continue;
                }
                if (abstractLage.getAdresseKey() == abstractLage2.getAdresseKey()) continue;
                linie.setAdressegrenze(true);
                linie2.setAdressegrenze(true);
            }
        }
        if (punktTable.size() > 0) {
            enumeration = flurstueckTable.elements();
            block2: while (enumeration.hasMoreElements()) {
                flurstueck = (Flurstueck)enumeration.nextElement();
                if (flurstueck.isFortfuehrung()) continue;
                Enumeration enumeration2 = flurstueck.elements();
                while (enumeration2.hasMoreElements()) {
                    object = (Linie)enumeration2.nextElement();
                    if (!punktTable.contains(((Linie)object).pa)) continue;
                    flurstueck.setFFNeighbor(true);
                    continue block2;
                }
            }
        }
    }

    public static void computeAlkisGebaeude(GebaeudeTable gebaeudeTable) {
        Enumeration enumeration = gebaeudeTable.elements();
        while (enumeration.hasMoreElements()) {
            Cloneable cloneable;
            Object object;
            Gebaeude gebaeude = (Gebaeude)enumeration.nextElement();
            boolean bl = true;
            boolean bl2 = true;
            Object object2 = gebaeude.elements();
            while (object2.hasMoreElements()) {
                object = (Linie)object2.nextElement();
                cloneable = ((Linie)object).getParameter();
                if (((Linie)object).pe == null) continue;
                if (((Linie)object).pa.isFortfuehrung()) {
                    gebaeude.setFortfuehrung(true);
                }
                if (((Linie)object).pe.isFortfuehrung()) {
                    gebaeude.setFortfuehrung(true);
                }
                int n = ((Linie)object).pa.getPst();
                int n2 = ((Linie)object).pe.getPst();
                if (n == 14 && n2 == 14) {
                    ((LinieParameter)cloneable).setEb(42);
                    ((Linie)object).setParameter((LinieParameter)cloneable);
                    bl = false;
                    continue;
                }
                if (n == 13 && n2 == 13) {
                    ((Linie)object).setUntergang(true);
                    bl2 = false;
                    continue;
                }
                bl = false;
                bl2 = false;
            }
            if (bl) {
                gebaeude.setUntergang(true);
            }
            if (bl2) {
                gebaeude.setFortfuehrung(true);
            }
            if ((object2 = gebaeude.getLeitzeichen()) != null && ((GebaeudeKennzeichen)object2).y == 0.0 && ((GebaeudeKennzeichen)object2).x == 0.0) {
                Object object3;
                double d;
                object = gebaeude.getMitte();
                if (object == null) continue;
                cloneable = null;
                Flurstueck flurstueck = null;
                Enumeration enumeration2 = DataBase.FLST.elements();
                while (enumeration2.hasMoreElements()) {
                    Flurstueck flurstueck2 = (Flurstueck)enumeration2.nextElement();
                    if (!flurstueck2.contains(((DPoint)object).y, ((DPoint)object).x)) continue;
                    flurstueck = flurstueck2;
                }
                if (flurstueck != null) {
                    int n = ((GebaeudeKennzeichen)object2).getStrasse();
                    boolean bl3 = false;
                    d = Double.MAX_VALUE;
                    object3 = null;
                    Object object4 = DataBase.FLST.elements();
                    while (object4.hasMoreElements()) {
                        double d2;
                        Lage lage;
                        Flurstueck flurstueck3 = (Flurstueck)object4.nextElement();
                        if (flurstueck3 == flurstueck || (lage = (Lage)flurstueck3.getLage()) == null || !lage.hasAdresse(n, 0, null)) continue;
                        boolean bl4 = false;
                        Object object5 = DataBase.NUTZ.elements();
                        while (object5.hasMoreElements()) {
                            Nutzung nutzung = (Nutzung)object5.nextElement();
                            if (nutzung.getArt() < 21000 || nutzung.getArt() >= 24000 || !nutzung.contains(flurstueck3.y, flurstueck3.x)) continue;
                            bl4 = true;
                            break;
                        }
                        if (!bl4) continue;
                        object5 = null;
                        if (flurstueck3.isNeighbor(flurstueck)) {
                            if (!bl3) {
                                d = Double.MAX_VALUE;
                            }
                            if ((object5 = flurstueck3.getNearestNeighborLine(flurstueck, (DPoint)object)) != null) {
                                bl3 = true;
                            }
                        } else if (!bl3) {
                            object5 = flurstueck3.getNearestDefLinie(new DPoint(gebaeude.y, gebaeude.x));
                        }
                        if (object5 == null || !((d2 = DLine.ptShortestDist(((Linie)object5).pa.y, ((Linie)object5).pa.x, ((Linie)object5).pe.y, ((Linie)object5).pe.x, flurstueck.y, flurstueck.x)) <= d)) continue;
                        d = d2;
                        object3 = object5;
                    }
                    if (object3 != null) {
                        object4 = new DPoint(((DPoint)object).y, ((DPoint)object).x);
                        DLine.moveIn(((Linie)object3).pa, ((Linie)object3).pe, (DPoint)object4);
                        cloneable = gebaeude.getNearestDefLinie((DPoint)object4);
                    }
                }
                if (cloneable == null) {
                    cloneable = gebaeude.getLongestLine();
                }
                if (cloneable != null) {
                    double d3 = DLine.getDistance(((Linie)cloneable).pa.y, ((Linie)cloneable).pa.x, ((Linie)cloneable).pe.y, ((Linie)cloneable).pe.x, ((DPoint)object).y, ((DPoint)object).x);
                    d = DLine.getDist(((Linie)cloneable).pa.y, ((Linie)cloneable).pa.x, ((Linie)cloneable).pe.y, ((Linie)cloneable).pe.x);
                    object3 = new DPoint();
                    DLine.setTo(((Linie)cloneable).pa, ((Linie)cloneable).pe, (DPoint)object3, d / 2.0, d3 > 0.0 ? 1.0 : -1.0);
                    ((GebaeudeKennzeichen)object2).y = ((DPoint)object3).y;
                    ((GebaeudeKennzeichen)object2).x = ((DPoint)object3).x;
                    gebaeude.y = ((DPoint)object3).y;
                    gebaeude.x = ((DPoint)object3).x;
                    double d4 = ((Linie)cloneable).getRichtung();
                    if (d4 < 0.0) {
                        d4 += Math.PI;
                    } else if (d4 > Math.PI) {
                        d4 -= Math.PI;
                    }
                    ((GebaeudeKennzeichen)object2).setAngle(d4);
                    continue;
                }
                ((GebaeudeKennzeichen)object2).y = ((DPoint)object).y;
                ((GebaeudeKennzeichen)object2).x = ((DPoint)object).x;
                continue;
            }
            object = gebaeude.getLongestLine();
            if (object == null) continue;
            gebaeude.setTextAngle(((Linie)object).getRichtung());
        }
    }

    public static void computeAlkisNutzungen(NutzungTable nutzungTable) {
        Enumeration enumeration = nutzungTable.elements();
        while (enumeration.hasMoreElements()) {
            Nutzung nutzung = (Nutzung)enumeration.nextElement();
            if (nutzung.getArt() < 10000000) {
                if (KafkaIOProperties.isNutzTrafo()) {
                    nutzung.setArt(Alkis.convertNutzung2019(nutzung.getArt()));
                    DataBase.nutzVersion = 2;
                } else {
                    DataBase.nutzVersion = 1;
                }
            } else {
                DataBase.nutzVersion = 2;
            }
            Enumeration enumeration2 = nutzung.elements();
            while (enumeration2.hasMoreElements()) {
                Linie linie = (Linie)enumeration2.nextElement();
                if (linie.pe == null) continue;
                if (linie.pa.isFortfuehrung()) {
                    nutzung.setFortfuehrung(true);
                }
                if (!linie.pe.isFortfuehrung()) continue;
                nutzung.setFortfuehrung(true);
            }
        }
    }

    public static void computeAlkisTopografie(TopObjectTable topObjectTable) {
        Hashtable<Linie, Linie> hashtable = new Hashtable<Linie, Linie>();
        Enumeration enumeration = topObjectTable.elements();
        while (enumeration.hasMoreElements()) {
            Linie linie;
            Object object;
            TopObject topObject = (TopObject)enumeration.nextElement();
            Object object2 = topObject.attributes();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                if (!((String)object).equals("bauwerksfunktion") && !((String)object).equals("archaeologischerTyp") && !((String)object).equals("art")) continue;
                topObject.setFunktion(Integer.parseInt(topObject.getAttribute((String)object).toString()));
                break;
            }
            object2 = topObject.getLineDefaults();
            object = topObject.elements();
            while (object.hasMoreElements()) {
                linie = (Linie)object.nextElement();
                if (linie.pe == null) continue;
                if (linie.pa.isFortfuehrung()) {
                    topObject.setFortfuehrung(true);
                }
                if (linie.pe.isFortfuehrung()) {
                    topObject.setFortfuehrung(true);
                }
                linie.setParameter((LinieParameter)object2);
            }
            if (topObject.getOska() != 61001) continue;
            object = topObject.elements();
            while (object.hasMoreElements()) {
                Linie linie2;
                linie = (Linie)object.nextElement();
                if (linie.isBOK() || linie.isBUK() || (linie2 = hashtable.put(linie, linie)) == null) continue;
                linie.setBTK(true);
                linie2.setBTK(true);
            }
            try {
                MessungParser.computeAlkisBoeschung(topObject);
            }
            catch (Exception exception) {}
        }
    }

    private static void computeAlkisBoeschung(TopObject topObject) throws Exception {
        double d;
        Linie linie;
        if (topObject.size() == 0) {
            return;
        }
        DPolygon dPolygon = new DPolygon();
        DPolygon dPolygon2 = new DPolygon();
        DPolygon dPolygon3 = new DPolygon();
        boolean bl = false;
        boolean bl2 = false;
        Linie linie2 = null;
        Linie linie3 = null;
        Enumeration enumeration = topObject.elements();
        while (enumeration.hasMoreElements()) {
            linie = (Linie)enumeration.nextElement();
            if (linie.isEnde()) continue;
            if (linie.isBOK()) {
                if (bl) {
                    dPolygon.addPoint(linie.pa);
                    linie2 = linie;
                }
            } else {
                bl = true;
            }
            if (linie.isBUK()) {
                if (!bl2) continue;
                dPolygon2.addPoint(linie.pa);
                linie3 = linie;
                continue;
            }
            bl2 = true;
        }
        enumeration = topObject.elements();
        while (enumeration.hasMoreElements()) {
            linie = (Linie)enumeration.nextElement();
            if (linie.isEnde()) continue;
            if (linie.isBOK() && bl) {
                dPolygon.addPoint(linie.pa);
                linie2 = linie;
            } else {
                bl = false;
            }
            if (linie.isBUK() && bl2) {
                dPolygon2.addPoint(linie.pa);
                linie3 = linie;
                continue;
            }
            bl2 = false;
        }
        if (linie2 != null) {
            dPolygon.addPoint(linie2.pe);
        }
        if (linie3 != null) {
            dPolygon2.addPoint(linie3.pe);
        }
        dPolygon2.reverse();
        dPolygon3.addPoint(DPoint.getMiddle(dPolygon.getPoint(0), dPolygon2.getPoint(0)));
        int n = 1;
        int n2 = 1;
        do {
            if (DPoint.ptDistSq(dPolygon.ypoints[n], dPolygon.xpoints[n], dPolygon2.ypoints[n2 - 1], dPolygon2.xpoints[n2 - 1]) < DPoint.ptDistSq(dPolygon.ypoints[n - 1], dPolygon.xpoints[n - 1], dPolygon2.ypoints[n2], dPolygon2.xpoints[n2])) {
                dPolygon3.addPoint(DPoint.getMiddle(dPolygon.getPoint(n), dPolygon2.getPoint(n2 - 1)));
                ++n;
                continue;
            }
            dPolygon3.addPoint(DPoint.getMiddle(dPolygon.getPoint(n - 1), dPolygon2.getPoint(n2)));
            ++n2;
        } while (n < dPolygon.npoints && n2 < dPolygon2.npoints);
        while (n < dPolygon.npoints) {
            dPolygon3.addPoint(DPoint.getMiddle(dPolygon.getPoint(n), dPolygon2.getPoint(n2 - 1)));
            ++n;
        }
        while (n2 < dPolygon2.npoints) {
            dPolygon3.addPoint(DPoint.getMiddle(dPolygon.getPoint(n - 1), dPolygon2.getPoint(n2)));
            ++n2;
        }
        double d2 = dPolygon3.getLength();
        double d3 = 0.0;
        double d4 = 2.0;
        int n3 = 1;
        n = 1;
        n2 = 1;
        boolean bl3 = true;
        for (double d5 = 2.0; d5 < d2; d5 += Math.max(d / 2.0, 2.0)) {
            while (d3 < d5) {
                double d6 = DPoint.ptDist(dPolygon3.ypoints[n3 - 1], dPolygon3.xpoints[n3 - 1], dPolygon3.ypoints[n3], dPolygon3.xpoints[n3]);
                d3 += d6;
                ++n3;
            }
            DPoint dPoint = new DPoint();
            DLine.setTo(dPolygon3.getPoint(n3 - 1), dPolygon3.getPoint(n3 - 2), dPoint, d3 - d5, 0.0);
            DPoint dPoint2 = new DPoint();
            DPoint dPoint3 = new DPoint();
            n = MessungParser.getShortestPoint(dPoint, dPolygon, n, dPoint2);
            n2 = MessungParser.getShortestPoint(dPoint, dPolygon2, n2, dPoint3);
            d = DPoint.ptDist(dPoint2.y, dPoint2.x, dPoint3.y, dPoint3.x);
            if (d < 0.5 || bl3 && d < 1.0) continue;
            ObjectLine objectLine = bl3 ? new ObjectLine(0, dPoint2.y, dPoint2.x, dPoint3.y, dPoint3.x) : new ObjectLine(0, dPoint2.y, dPoint2.x, (dPoint2.y + dPoint3.y) / 2.0, (dPoint2.x + dPoint3.x) / 2.0);
            objectLine.setAutoCreate(true);
            topObject.addDecor(objectLine);
            bl3 = !bl3;
        }
    }

    private static int getShortestPoint(DPoint dPoint, DPolygon dPolygon, int n, DPoint dPoint2) {
        double d = Double.MAX_VALUE;
        for (int i = n; i < dPolygon.npoints; ++i) {
            double d2 = Math.abs(DLine.getSegDistance(dPolygon.getPoint(i), dPolygon.getPoint(i - 1), dPoint));
            if (!(d2 < d)) continue;
            d = d2;
            dPoint2.y = dPoint.y;
            dPoint2.x = dPoint.x;
            DLine.moveInSeg(dPolygon.getPoint(i), dPolygon.getPoint(i - 1), dPoint2);
            n = i;
        }
        return n;
    }

    public static void computeAlkisBodenschaetzung(BodenSchaetzungTable bodenSchaetzungTable) {
        double d = 150.0;
        double d2 = 0.001;
        KeyedHashtable keyedHashtable = new KeyedHashtable();
        Enumeration enumeration = bodenSchaetzungTable.elements();
        while (enumeration.hasMoreElements()) {
            BodenSchaetzung bodenSchaetzung = (BodenSchaetzung)enumeration.nextElement();
            double d3 = bodenSchaetzung.getMixedValue();
            if (d3 != 0.0) {
                d = Math.min(d, d3);
                d2 = Math.max(d2, d3);
            }
            Enumeration enumeration2 = bodenSchaetzung.elements();
            while (enumeration2.hasMoreElements()) {
                BodenSchaetzung bodenSchaetzung2;
                Linie linie = (Linie)enumeration2.nextElement();
                if (linie.pe == null) continue;
                if (linie.pa.isFortfuehrung()) {
                    bodenSchaetzung.setFortfuehrung(true);
                }
                if (linie.pe.isFortfuehrung()) {
                    bodenSchaetzung.setFortfuehrung(true);
                }
                if ((bodenSchaetzung2 = (BodenSchaetzung)keyedHashtable.put(linie, bodenSchaetzung)) == null) continue;
                Linie linie2 = (Linie)keyedHashtable.getKey(linie);
                LinieParameter linieParameter = linie.getParameter();
                if (bodenSchaetzung.getKulturArt() == bodenSchaetzung2.getKulturArt() && bodenSchaetzung.getBodenArt() == bodenSchaetzung2.getBodenArt() && bodenSchaetzung.getStufe() == bodenSchaetzung2.getStufe() && bodenSchaetzung.getEntstehungsArt() == bodenSchaetzung2.getEntstehungsArt()) {
                    if (!bodenSchaetzung.getBodenZahl().equals(bodenSchaetzung2.getBodenZahl())) {
                        linieParameter.setSig1(3102);
                        linie.setParameter(linieParameter);
                        linie2.setParameter(linieParameter);
                    } else {
                        linieParameter.setSig1(3103);
                        linie.setParameter(linieParameter);
                        linie2.setParameter(linieParameter);
                    }
                }
                keyedHashtable.remove(linie);
            }
        }
        DataBase.minBodenschaetzZahl = d;
        DataBase.maxBodenschaetzZahl = d2;
    }

    public static void computeAlkisGebaeudeSignatur(GebaeudeTable gebaeudeTable) {
        Object object;
        Object object2;
        Object object3;
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Object object4 = gebaeudeTable.elements();
        while (object4.hasMoreElements()) {
            object3 = (Gebaeude)object4.nextElement();
            if (((DataContainer)object3).getOska() != 31002) continue;
            switch (((Gebaeude)object3).getFunktion()) {
                case 2300: 
                case 2400: 
                case 2510: 
                case 2610: 
                case 2620: {
                    object2 = ((DataContainer)object3).elements();
                    while (object2.hasMoreElements()) {
                        object = (Linie)object2.nextElement();
                        hashtable.put(((Linie)object).getHashKey(), object);
                    }
                    break;
                }
            }
        }
        object4 = new Hashtable();
        object3 = gebaeudeTable.elements();
        while (object3.hasMoreElements()) {
            object2 = (Gebaeude)object3.nextElement();
            if (((DataContainer)object2).getOska() != 31001) continue;
            object = ((DataContainer)object2).elements();
            while (object.hasMoreElements()) {
                LinieParameter linieParameter;
                Linie linie = (Linie)object.nextElement();
                Object object5 = linie.getHashKey();
                Linie linie2 = (Linie)hashtable.get(object5);
                Linie linie3 = (Linie)((Hashtable)object4).get(object5);
                if (linie3 != null) {
                    linieParameter = linie3.getParameter();
                    int n = linieParameter.getSig1();
                    if (n == 2004) {
                        n = 2001;
                    } else if (n == 2003) {
                        n = 2002;
                    }
                    linie3.setParameter(new LinieParameter(linieParameter.getLa(), linieParameter.getEb(), linieParameter.getOska(), n));
                    continue;
                }
                if (linie2 == null) continue;
                linieParameter = linie.getParameter();
                LinieParameter linieParameter2 = linie2.getParameter();
                int n = linieParameter.getSig1();
                int n2 = linieParameter2.getSig1();
                if (n == 2001) {
                    n = 2004;
                } else if (n == 2002) {
                    n = 2003;
                }
                if (n2 == 2011) {
                    n2 = 2014;
                } else if (n2 == 2012) {
                    n2 = 2013;
                }
                linie.setParameter(new LinieParameter(linieParameter.getLa(), linieParameter.getEb(), linieParameter.getOska(), n));
                linie2.setParameter(new LinieParameter(linieParameter2.getLa(), linieParameter2.getEb(), linieParameter2.getOska(), n2));
                ((Hashtable)object4).put(object5, linie);
            }
        }
    }

    public void testAlkisFlurstuecke(FlurstueckTable flurstueckTable) {
        Enumeration enumeration = flurstueckTable.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            Enumeration enumeration2 = flurstueck.elements();
            while (enumeration2.hasMoreElements()) {
                Linie linie = (Linie)enumeration2.nextElement();
                int n = linie.pa.getKafPa();
                if (n == -1 || n == 1) continue;
                this.addException(new Exception("Fehler im Umring " + String.valueOf(flurstueck) + ", Punkt " + linie.pa.nr + " ist kein Grenzpunkt"));
            }
        }
    }

    public void testAlkisGebaeude(GebaeudeTable gebaeudeTable) {
        Enumeration enumeration = gebaeudeTable.elements();
        while (enumeration.hasMoreElements()) {
            Gebaeude gebaeude = (Gebaeude)enumeration.nextElement();
            Enumeration enumeration2 = gebaeude.elements();
            while (enumeration2.hasMoreElements()) {
                Linie linie = (Linie)enumeration2.nextElement();
                int n = linie.pa.getKafPa();
                if (n == -1 || n == 2) continue;
                this.addException(new Exception("Fehler im Umring " + String.valueOf(gebaeude) + ", Punkt " + linie.pa.nr + " ist kein Gebaeudepunkt"));
            }
        }
    }
}

