/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.geom.DPoint;
import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.EntstehungsArt;
import de.geocalc.kafplot.KafPlotVersion;
import de.geocalc.kafplot.KatAmt;
import de.geocalc.kafplot.NummerierungsBezirkTable;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktArt;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.PunktParameterALKIS;
import de.geocalc.kafplot.PunktParameterALKISExt;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.io.IFileWriter;
import de.geocalc.kafplot.io.alkis.AlkisIOProperties;
import de.geocalc.kafplot.io.alkis.NasIOProperties;
import de.geocalc.kataster.model.AA_Lebenszeitintervall;
import de.geocalc.kataster.model.AA_Objekt;
import de.geocalc.kataster.model.Alkis;
import de.geocalc.text.IFormat;
import de.geocalc.xml.XMLElement;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;

public class NasFFWriter
extends IFileWriter {
    public static final String TITLE = "NasWriter";
    public static final String VERSION = "1.0";
    protected static long pnrAddition = 300000000000000L;
    protected static double yReduction = 3000000.0;
    private static final String GML_ID = "gml:id";
    private static final String CS_ADV = "http://www.adv-online.de/";
    private static final String URN_ADV_OID = "urn:adv:oid:";
    private static final String URN_ADV_CRS = "urn:adv:crs:";
    private static final String ETRS89_UTM33 = "ETRS89_UTM33";
    private static final String DEFAULT_SRS_NAME = "urn:adv:crs:ETRS89_UTM33";
    private static final Vector rootProps = new Vector();
    protected DataBase db;
    private int fid = 0;
    private PunktTable PI = null;
    private NummerierungsBezirkTable NB = null;
    XMLElement defaultKS;
    XMLElement defaultLZI;
    XMLElement defaultZst;
    XMLElement defaultModel;
    XMLElement defaultAnlass;
    private static final Hashtable xENTITIES = new Hashtable();
    private static final byte PKT = 80;
    private static final byte ORT = 79;
    private static final byte KOO = 75;
    private static final int BASE = 62;
    private static final long MAX_DECODE_NR = 3521614606207L;
    private static final String FIRST_GML_ID = "DE_GCKP_";
    private static final byte[] ALPHABET;

    public NasFFWriter(File file, DataBase dataBase, PunktTable punktTable, NummerierungsBezirkTable nummerierungsBezirkTable) {
        super(file);
        this.db = dataBase;
        this.PI = punktTable;
        this.NB = nummerierungsBezirkTable;
        this.setParameter();
    }

    private static void addRootProperties(XMLElement xMLElement) {
        xMLElement.addProperty("xmlns", "http://www.adv-online.de/namespaces/adv/gid/7.1");
        xMLElement.addProperty("xmlns:adv", "http://www.adv-online.de/namespaces/adv/gid/7.1");
        xMLElement.addProperty("xmlns:gco", "http://www.isotc211.org/2005/gco");
        xMLElement.addProperty("xmlns:gmd", "http://www.isotc211.org/2005/gmd");
        xMLElement.addProperty("xmlns:gml", "http://www.opengis.net/gml/3.2");
        xMLElement.addProperty("xmlns:ogc", "http://www.adv-online.de/namespaces/adv/gid/ogc");
        xMLElement.addProperty("xmlns:fes", "http://www.opengis.net/fes/2.0");
        xMLElement.addProperty("xmlns:ows", "http://www.opengis.net/ows/1.1");
        xMLElement.addProperty("xmlns:wfs", "http://www.opengis.net/wfs/2.0");
        xMLElement.addProperty("xmlns:wfsext", "http://www.adv-online.de/namespaces/adv/gid/wfsext/2.0");
        xMLElement.addProperty("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        xMLElement.addProperty("xmlns:xlink", "http://www.w3.org/1999/xlink");
        xMLElement.addProperty("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xMLElement.addProperty("xsi:schemaLocation", "http://www.adv-online.de/namespaces/adv/gid/7.1 NAS-Operationen.xsd");
    }

    protected void setParameter() {
        this.setEncoding("UTF8");
    }

    @Override
    public void write() throws IFileOutputException {
        Object object;
        Object object2;
        Object object3;
        int n = 0;
        int n2 = 0;
        XMLElement xMLElement = NasFFWriter.xs("AX_Bestandsdatenauszug");
        XMLElement xMLElement2 = NasFFWriter.xs("AX_Fortfuehrungsauftrag");
        XMLElement xMLElement3 = null;
        XMLElement xMLElement4 = null;
        NasFFWriter.addRootProperties(xMLElement);
        NasFFWriter.addRootProperties(xMLElement2);
        try {
            int n3;
            Object object4;
            Object object5;
            object3 = new GregorianCalendar();
            object2 = IFormat.toDateTimeISO(((Calendar)object3).getTimeInMillis());
            this.defaultKS = NasFFWriter.xs(null, "AA_Koordinatenreferenzsystemangaben");
            this.defaultKS.addChild(NasFFWriter.xp(null, "crs", "xlink:href", DEFAULT_SRS_NAME));
            this.defaultKS.addChild(NasFFWriter.xs(null, "anzahlDerNachkommastellen", "3"));
            this.defaultKS.addChild(NasFFWriter.xs(null, "standard", "true"));
            this.defaultLZI = NasFFWriter.xm(null, "lebenszeitintervall.AA_Lebenszeitintervall.beginnt", (String)object2);
            this.defaultModel = NasFFWriter.xm(null, "modellart.AA_Modellart.advStandardModell", "DLKM");
            this.defaultAnlass = NasFFWriter.xs(null, "anlass", "000000");
            int n4 = 0;
            if (DataBase.katasterAmt != null) {
                KatAmt katAmt = KatAmt.getKatAmt(DataBase.katasterAmt);
                if (katAmt != null) {
                    n4 = katAmt.getNummer();
                }
            }
            if (DataBase.antrag != null) {
                int n5 = DataBase.antrag.indexOf(95);
                if (n5 > 0) {
                    int n6 = 0;
                    try {
                        n6 = Integer.parseInt(DataBase.antrag.substring(0, n5));
                    }
                    catch (Exception exception) {
                        this.addException(new Exception("Amtkennung in der Antragsnummer ist nicht numerisch"));
                    }
                    if (n4 != 120000 + n6) {
                        this.addException(new Exception("Amtkennung " + n6 + " der Antragsnummer ist nicht identisch mit dem Amt der Auftragsdatei " + n4 + ", Amt " + n6 + " wird \u00fcbernommen"));
                        n4 = 120000 + n6;
                    }
                }
            }
            this.defaultZst = this.createZustaendigeStelle(n4);
            double d = Double.MAX_VALUE;
            double d2 = 0.0;
            double d3 = Double.MAX_VALUE;
            double d4 = 0.0;
            Object object6 = DataBase.P.elements();
            while (object6.hasMoreElements()) {
                object5 = (Punkt)object6.nextElement();
                if (!((Punkt)object5).isFortfuehrung() || !((Punkt)object5).isKatasterExportElement()) continue;
                switch (((Punkt)object5).getPst()) {
                    case 12: 
                    case 13: 
                    case 14: {
                        ++n2;
                        break;
                    }
                    case 11: {
                        d = Math.min(d, ((Punkt)object5).x);
                        d2 = Math.max(d2, ((Punkt)object5).x);
                        d3 = Math.min(d3, ((Punkt)object5).y);
                        d4 = Math.max(d4, ((Punkt)object5).y);
                        ++n;
                    }
                }
            }
            if (n > 0 || NasIOProperties.writeVoidBa()) {
                xMLElement.addChild(NasFFWriter.xs(null, "erfolgreich", "true"));
                xMLElement.addChild(NasFFWriter.xs(null, "antragsnummer", DataBase.antrag));
                xMLElement.addChild(NasFFWriter.xm(null, "allgemeineAngaben.AX_K_Benutzungsergebnis.empfaenger.AA_Empfaenger.direkt", "true"));
                xMLElement.addChild(NasFFWriter.xx(null, "koordinatenangaben", this.defaultKS));
                object6 = NasFFWriter.x(null, "enthaelt");
                xMLElement3 = NasFFWriter.x("wfs", "FeatureCollection");
                xMLElement3.addProperty("timeStamp", object2);
                xMLElement3.addProperty("numberMatched", Integer.toString(n * 2));
                xMLElement3.addProperty("numberReturned", Integer.toString(n * 2));
                object5 = NasFFWriter.x("wfs", "boundedBy");
                object4 = NasFFWriter.x("gml", "Envelope");
                ((XMLElement)object4).addChild(NasFFWriter.xps("gml", "pos", "srsName", DEFAULT_SRS_NAME, IFormat.f6_3.format(d3 - yReduction) + " " + IFormat.f7_3.format(d)));
                ((XMLElement)object4).addChild(NasFFWriter.xps("gml", "pos", "srsName", DEFAULT_SRS_NAME, IFormat.f6_3.format(d4 - yReduction) + " " + IFormat.f7_3.format(d2)));
                ((XMLElement)object5).addChild((XMLElement)object4);
                xMLElement3.addChild((XMLElement)object5);
                ((XMLElement)object6).addChild(xMLElement3);
                xMLElement.addChild((XMLElement)object6);
            }
            if (n2 > 0) {
                xMLElement2.addChild(NasFFWriter.xm(null, "empfaenger.AA_Empfaenger.direkt", "true"));
                xMLElement2.addChild(NasFFWriter.xs(null, "ausgabeform", "application/xml"));
                xMLElement2.addChild(NasFFWriter.xx(null, "koordinatenangaben", this.defaultKS));
                object6 = NasFFWriter.x(null, "geaenderteObjekte");
                xMLElement4 = NasFFWriter.x("wfs", "Transaction");
                xMLElement4.addProperty("version", "2.0.0");
                xMLElement4.addProperty("service", "WFS");
                ((XMLElement)object6).addChild(xMLElement4);
                xMLElement2.addChild((XMLElement)object6);
            }
            if ((n3 = ((String)(object6 = this.outFile.getAbsolutePath())).lastIndexOf(".")) > 0) {
                object6 = ((String)object6).substring(0, n3);
            }
            object4 = NasFFWriter.createFileWriter(new File((String)object6 + ".alkis"));
            NasFFWriter nasFFWriter = this;
            ((PrintWriter)object4).println("#NAS-Export " + nasFFWriter.db.getSourceName() + " am " + (String)object2 + " durch " + System.getProperty("user.name"));
            Enumeration enumeration = DataBase.P.elements();
            while (enumeration.hasMoreElements()) {
                Punkt punkt = (Punkt)enumeration.nextElement();
                if (!punkt.isFortfuehrung() || !punkt.isKatasterExportElement()) continue;
                if (NasFFWriter.idNr(punkt) > 3521614606207L) {
                    this.addException(new Exception("Punktnummer " + punkt.nr + " zu lang zur Bildung der gml:id"));
                }
                try {
                    XMLElement xMLElement5;
                    Object object7;
                    Object object8;
                    Object object9;
                    Object object10;
                    PunktParameterALKIS punktParameterALKIS = (PunktParameterALKIS)punkt.getParameter();
                    int n7 = punkt.getOldParameter().getModPa();
                    int n8 = punkt.getParameter().getModPa();
                    if (PunktArt.isKatasterElement(n7) && PunktArt.isKatasterElement(n8) && n7 != n8) {
                        this.addException(new Exception("Punkt " + punkt.nr + " hat unzul\u00e4ssig \u00c4nderung der Punktart, er wird ignoriert"));
                        continue;
                    }
                    int n9 = punktParameterALKIS.getPst();
                    long l = punkt.buildKatNr(14);
                    Punkt punkt2 = (Punkt)this.PI.get(l);
                    if (n9 == 13) {
                        if (punkt2 != null) {
                            object10 = (PunktParameterALKISExt)punkt2.getParameter();
                            xMLElement4.addChild(this.createDelete(((PunktParameterALKISExt)object10).getOrtArt(), ((PunktParameterALKISExt)object10).getOrtObjektAttributes().createFilterID()));
                            xMLElement4.addChild(this.createDelete(((PunktParameterALKISExt)object10).getPunktArt(), ((PunktParameterALKISExt)object10).getPunktObjektAttributes().createFilterID()));
                        } else {
                            this.addException(new Exception("Delete: Punkt " + l + " nicht in NAS-Daten gefunden!"));
                        }
                        ((PrintWriter)object4).println(punkt.toAlkisPunktLine(true, false, "Delete"));
                        continue;
                    }
                    if (n9 == 14) {
                        if (punkt2 == null) {
                            long l2;
                            object10 = NasFFWriter.x("wfs", "Insert");
                            int n10 = 0;
                            switch (punktParameterALKIS.getModPa()) {
                                case 20: 
                                case 29: {
                                    n10 = punkt.isZeigtAufPoint() ? 14003 : 14004;
                                    break;
                                }
                                case 30: {
                                    n10 = 14002;
                                    break;
                                }
                                case 40: {
                                    n10 = 14002;
                                    break;
                                }
                                default: {
                                    n10 = 14003;
                                }
                            }
                            object9 = NasFFWriter.xp(null, Alkis.getObjectName(n10), GML_ID, NasFFWriter.ortId(punkt));
                            ((XMLElement)object9).addChild(NasFFWriter.xi(NasFFWriter.ortId(punkt)));
                            ((XMLElement)object9).addChild(this.defaultLZI);
                            ((XMLElement)object9).addChild(this.defaultModel);
                            ((XMLElement)object9).addChild(NasFFWriter.xl(null, "istTeilVon", NasFFWriter.punktId(punkt)));
                            ((XMLElement)object9).addChild(NasFFWriter.xPoint(null, "position", punkt));
                            ((XMLElement)object9).addChild(NasFFWriter.xs(null, "kartendarstellung", Boolean.toString(true)));
                            ((XMLElement)object9).addChild(NasFFWriter.xs(null, "koordinatenstatus", punktParameterALKIS.getOutLs()));
                            ((XMLElement)object9).addChild(NasFFWriter.xDqp(null, "qualitaetsangaben", punktParameterALKIS));
                            ((XMLElement)object10).addChild((XMLElement)object9);
                            xMLElement4.addChild((XMLElement)object10);
                            object8 = NasFFWriter.x("wfs", "Insert");
                            XMLElement xMLElement6 = NasFFWriter.xp(null, Alkis.getObjectName(punkt.getOska()), GML_ID, NasFFWriter.punktId(punkt));
                            xMLElement6.addChild(NasFFWriter.xi(NasFFWriter.punktId(punkt)));
                            xMLElement6.addChild(this.defaultLZI);
                            xMLElement6.addChild(this.defaultModel);
                            xMLElement6.addChild(NasFFWriter.xs(null, "punktkennung", punkt.buildAlkisNr(true)));
                            if (NasFFWriter.isBG(punktParameterALKIS) && punktParameterALKIS.hasArt()) {
                                xMLElement6.addChild(NasFFWriter.xs(null, "art", Integer.toString(punktParameterALKIS.getArt())));
                            }
                            xMLElement6.addChild(NasFFWriter.xx(null, "zustaendigeStelle", this.defaultZst));
                            if (NasFFWriter.isGP(punktParameterALKIS)) {
                                if (punktParameterALKIS.hasVa()) {
                                    xMLElement6.addChild(NasFFWriter.xs(null, "abmarkung_Marke", Integer.toString(punktParameterALKIS.getModVa())));
                                }
                                if (punktParameterALKIS.hasVb()) {
                                    xMLElement6.addChild(NasFFWriter.xs(null, "bemerkungZurAbmarkung", Integer.toString(punktParameterALKIS.getModVb())));
                                }
                            }
                            if (punkt.isZeigtAufPoint() && (l2 = Long.parseLong(punkt.getTag("IND").getValue())) != 0L) {
                                object7 = (Punkt)DataBase.P.get(Long.parseLong(punkt.getTag("IND").getValue()));
                                if (object7 != null) {
                                    long l3 = ((Punkt)object7).buildKatNr(14);
                                    Punkt punkt3 = (Punkt)this.PI.get(l3);
                                    if (punkt3 != null) {
                                        PunktParameterALKISExt punktParameterALKISExt = (PunktParameterALKISExt)punkt3.getParameter();
                                        xMLElement6.addChild(NasFFWriter.xl(null, "zeigtAuf", punktParameterALKISExt.getPunktObjektAttributes().getIdentifikator()));
                                    } else {
                                        xMLElement6.addChild(NasFFWriter.xl(null, "zeigtAuf", NasFFWriter.punktId((Punkt)object7)));
                                    }
                                } else {
                                    this.addException(new Exception("Insert: Punkt " + l + " hat Referenz zu nicht vorhandenen Punkt " + l2 + ", Referenz wird ignoriert!"));
                                }
                            }
                            if (punktParameterALKIS.getKafPa() == 0) {
                                xMLElement6.addChild(NasFFWriter.xs(null, "sonstigeEigenschaft", PunktArt.toString(punktParameterALKIS.getPa())));
                            }
                            if (NasFFWriter.isBB(punktParameterALKIS) && punktParameterALKIS.hasArt()) {
                                xMLElement6.addChild(NasFFWriter.xs(null, "art", Integer.toString(punktParameterALKIS.getArt())));
                            }
                            if (NasFFWriter.isNP(punktParameterALKIS) && punktParameterALKIS.hasVa()) {
                                xMLElement6.addChild(NasFFWriter.xs(null, "vermarkung_Marke", Integer.toString(punktParameterALKIS.getModVa())));
                            }
                            ((XMLElement)object8).addChild(xMLElement6);
                            xMLElement4.addChild((XMLElement)object8);
                            ((PrintWriter)object4).println(punkt.toAlkisPunktLine(true, false, "Insert"));
                            continue;
                        }
                        ((PrintWriter)object4).println(punkt.toAlkisPunktLine(true, false, "Insert Fehler: Ausgabepunktnummer " + l + " bereits in Bestandsdaten enthalten"));
                        this.addException(new Exception("Insert: Ausgabepunktnummer " + l + " bereits in Bestandsdaten enthalten, Punkt " + l + " wird ignoriert!"));
                        continue;
                    }
                    if (n9 == 12) {
                        if (punkt2 != null) {
                            object10 = (PunktParameterALKISExt)punkt2.getParameter();
                            PunktParameterALKIS punktParameterALKIS2 = (PunktParameterALKIS)punkt.getParameter();
                            object9 = NasFFWriter.x("wfs", "Replace");
                            object8 = this.createObject(((PunktParameterALKISExt)object10).getOrtArt(), ((PunktParameterALKISExt)object10).getOrtObjektAttributes());
                            ((XMLElement)object8).addChild(NasFFWriter.xPoint(null, "position", punkt));
                            ((XMLElement)object8).addChild(NasFFWriter.xs(null, "kartendarstellung", Boolean.toString(((PunktParameterALKISExt)object10).getKds())));
                            ((XMLElement)object8).addChild(NasFFWriter.xs(null, "koordinatenstatus", punktParameterALKIS2.getOutLs()));
                            if (((PunktParameterALKISExt)object10).hasPru()) {
                                ((XMLElement)object8).addChild(NasFFWriter.xs(null, "ueberpruefungsdatum", ((PunktParameterALKISExt)object10).getPru()));
                            }
                            if (((PunktParameterALKISExt)object10).hasHin()) {
                                ((XMLElement)object8).addChild(NasFFWriter.xs(null, "hinweise", ((PunktParameterALKISExt)object10).getHin()));
                            }
                            ((XMLElement)object8).addChild(NasFFWriter.xDqp(null, "qualitaetsangaben", punktParameterALKIS2));
                            ((XMLElement)object9).addChild((XMLElement)object8);
                            ((XMLElement)object9).addChild(this.createFilter(((PunktParameterALKISExt)object10).getOrtObjektAttributes().createFilterID()));
                            xMLElement4.addChild((XMLElement)object9);
                            AA_Objekt aA_Objekt = ((PunktParameterALKISExt)object10).getPunktObjektAttributes();
                            XMLElement xMLElement7 = NasFFWriter.x("wfs", "Replace");
                            xMLElement5 = this.createObject(((PunktParameterALKISExt)object10).getPunktArt(), ((PunktParameterALKISExt)object10).getPunktObjektAttributes());
                            xMLElement5.addChild(NasFFWriter.xs(null, "punktkennung", punkt.buildAlkisNr(true)));
                            if (NasFFWriter.isBG(punktParameterALKIS2) && punktParameterALKIS2.hasArt()) {
                                xMLElement5.addChild(NasFFWriter.xs(null, "art", Integer.toString(punktParameterALKIS2.getArt())));
                            }
                            xMLElement5.addChild(NasFFWriter.xx(null, "zustaendigeStelle", this.createZustaendigeStelle(((PunktParameterALKISExt)object10).getZst())));
                            if (NasFFWriter.isGP(punktParameterALKIS2)) {
                                if (punktParameterALKIS2.hasVa()) {
                                    xMLElement5.addChild(NasFFWriter.xs(null, "abmarkung_Marke", Integer.toString(punktParameterALKIS2.getModVa())));
                                }
                                if (punktParameterALKIS2.hasVb()) {
                                    xMLElement5.addChild(NasFFWriter.xs(null, "bemerkungZurAbmarkung", Integer.toString(punktParameterALKIS2.getModVb())));
                                }
                            }
                            if (((PunktParameterALKISExt)object10).hasSoe()) {
                                NasFFWriter.addEnumS(xMLElement5, null, "sonstigeEigenschaft", ((PunktParameterALKISExt)object10).getSoeElements());
                            }
                            if (((PunktParameterALKISExt)object10).hasZde()) {
                                xMLElement5.addChild(NasFFWriter.xs(null, "zeitpunktDerEntstehung", ((PunktParameterALKISExt)object10).getZde()));
                            }
                            if (NasFFWriter.isBB(punktParameterALKIS2) && punktParameterALKIS2.hasArt()) {
                                xMLElement5.addChild(NasFFWriter.xs(null, "art", Integer.toString(punktParameterALKIS2.getArt())));
                            }
                            if (NasFFWriter.isNP(punktParameterALKIS2) && punktParameterALKIS2.hasVa()) {
                                xMLElement5.addChild(NasFFWriter.xs(null, "vermarkung_Marke", Integer.toString(punktParameterALKIS2.getModVa())));
                            }
                            if (((PunktParameterALKISExt)object10).hasVpArt()) {
                                xMLElement5.addChild(NasFFWriter.xl(null, "art", ((PunktParameterALKISExt)object10).getVpArt()));
                            }
                            if (((PunktParameterALKISExt)object10).hasZau()) {
                                xMLElement5.addChild(NasFFWriter.xl(null, "zeigtAuf", ((PunktParameterALKISExt)object10).getZau()));
                            }
                            if (((PunktParameterALKISExt)object10).hasHat()) {
                                NasFFWriter.addEnumL(xMLElement5, null, "hat", ((PunktParameterALKISExt)object10).getHatElements());
                            }
                            if (((PunktParameterALKISExt)object10).hasGzu()) {
                                xMLElement5.addChild(NasFFWriter.xl(null, "gehoertZu", ((PunktParameterALKISExt)object10).getGzu()));
                            }
                            if (((PunktParameterALKISExt)object10).hasBsa()) {
                                xMLElement5.addChild(NasFFWriter.xl(null, "beziehtSichAuf", ((PunktParameterALKISExt)object10).getBsa()));
                            }
                            if (((PunktParameterALKISExt)object10).hasMit()) {
                                NasFFWriter.addEnumL(xMLElement5, null, "gehoertZu", ((PunktParameterALKISExt)object10).getMitElements());
                            }
                            xMLElement7.addChild(xMLElement5);
                            xMLElement7.addChild(this.createFilter(((PunktParameterALKISExt)object10).getPunktObjektAttributes().createFilterID()));
                            xMLElement4.addChild(xMLElement7);
                            ((PrintWriter)object4).println(punkt2.toAlkisPunktLine(true, true, "Origin"));
                            ((PrintWriter)object4).println(punkt.toAlkisPunktLine(true, false, "Replace"));
                            continue;
                        }
                        ((PrintWriter)object4).println(punkt.toAlkisPunktLine(true, false, "Replace Fehler: Ausgabepunktnummer " + l + " nicht in Bestandsdaten enthalten"));
                        this.addException(new Exception("Replace: Ausgabepunktnummer " + l + " nicht in Bestandsdaten enthalten, Punkt " + l + " wird ignoriert!"));
                        continue;
                    }
                    if (n9 != 11) continue;
                    if (punkt2 != null) {
                        object10 = (PunktParameterALKISExt)punkt2.getParameter();
                        PunktParameterALKIS punktParameterALKIS3 = (PunktParameterALKIS)punkt.getParameter();
                        object9 = IFormat.f6_3.format(punkt2.y) + " " + IFormat.f7_3.format(punkt2.x);
                        if (!((String)object9).equals(object8 = IFormat.f6_3.format(punkt.y) + " " + IFormat.f7_3.format(punkt.x))) {
                            double d5 = DPoint.ptDistSq(punkt2.y, punkt2.x, punkt.y, punkt.x);
                            ((PrintWriter)object4).println(punkt.toAlkisPunktLine(true, false, "Confirm Fehler: Koorinatenabweichung " + IFormat.f_3.format(d5) + " zu Bestandsdaten"));
                            this.addException(new Exception("Confirm: Punkt " + punkt.nr + " hat Abweichung in den Koordinaten " + IFormat.f_3.format(d5)));
                            continue;
                        }
                        if (!((PunktParameter)object10).equalsModel(punktParameterALKIS3)) {
                            ((PrintWriter)object4).println(punkt.toAlkisPunktLine(true, false, "Confirm Fehler: Abweichung in den Attributen " + ((PunktParameter)object10).differencedModelAttributes(punktParameterALKIS3) + " zu Bestandsdaten"));
                            this.addException(new Exception("Confirm: Punkt " + punkt.nr + " hat Abweichung in den Attributen " + ((PunktParameter)object10).differencedModelAttributes(punktParameterALKIS3)));
                            continue;
                        }
                        XMLElement xMLElement8 = NasFFWriter.x("wfs", "member");
                        XMLElement xMLElement9 = this.createObject(((PunktParameterALKISExt)object10).getOrtArt(), ((PunktParameterALKISExt)object10).getOrtObjektAttributes());
                        xMLElement9.addChild(NasFFWriter.xPoint(null, "position", punkt2));
                        xMLElement9.addChild(NasFFWriter.xs(null, "kartendarstellung", Boolean.toString(((PunktParameterALKISExt)object10).getKds())));
                        xMLElement9.addChild(NasFFWriter.xs(null, "koordinatenstatus", ((PunktParameterALKIS)object10).getOutLs()));
                        if (((PunktParameterALKISExt)object10).hasPru()) {
                            xMLElement9.addChild(NasFFWriter.xs(null, "ueberpruefungsdatum", ((PunktParameterALKISExt)object10).getPru()));
                        }
                        if (((PunktParameterALKISExt)object10).hasHin()) {
                            xMLElement9.addChild(NasFFWriter.xs(null, "hinweise", ((PunktParameterALKISExt)object10).getHin()));
                        }
                        xMLElement9.addChild(NasFFWriter.xDqp(null, "qualitaetsangaben", (PunktParameterALKIS)object10));
                        xMLElement8.addChild(xMLElement9);
                        xMLElement3.addChild(xMLElement8);
                        xMLElement5 = NasFFWriter.x("wfs", "member");
                        object7 = this.createObject(((PunktParameterALKISExt)object10).getPunktArt(), ((PunktParameterALKISExt)object10).getPunktObjektAttributes());
                        ((XMLElement)object7).addChild(NasFFWriter.xs(null, "punktkennung", Long.toString(AlkisIOProperties.getExportPnrAddition() + punkt2.nr)));
                        if (NasFFWriter.isBG((PunktParameterALKIS)object10) && ((PunktParameterALKIS)object10).hasArt()) {
                            ((XMLElement)object7).addChild(NasFFWriter.xs(null, "art", Integer.toString(((PunktParameterALKIS)object10).getArt())));
                        }
                        ((XMLElement)object7).addChild(NasFFWriter.xx(null, "zustaendigeStelle", this.createZustaendigeStelle(((PunktParameterALKISExt)object10).getZst())));
                        if (NasFFWriter.isGP((PunktParameterALKIS)object10)) {
                            if (((PunktParameterALKIS)object10).hasVa()) {
                                ((XMLElement)object7).addChild(NasFFWriter.xs(null, "abmarkung_Marke", Integer.toString(((PunktParameterALKIS)object10).getModVa())));
                            }
                            if (((PunktParameterALKIS)object10).hasVb()) {
                                ((XMLElement)object7).addChild(NasFFWriter.xs(null, "bemerkungZurAbmarkung", Integer.toString(((PunktParameterALKIS)object10).getModVb())));
                            }
                        }
                        if (((PunktParameterALKISExt)object10).hasSoe()) {
                            NasFFWriter.addEnumS((XMLElement)object7, null, "sonstigeEigenschaft", ((PunktParameterALKISExt)object10).getSoeElements());
                        }
                        if (((PunktParameterALKISExt)object10).hasZde()) {
                            ((XMLElement)object7).addChild(NasFFWriter.xs(null, "zeitpunktDerEntstehung", ((PunktParameterALKISExt)object10).getZde()));
                        }
                        if (NasFFWriter.isBB((PunktParameterALKIS)object10) && ((PunktParameterALKIS)object10).hasArt()) {
                            ((XMLElement)object7).addChild(NasFFWriter.xs(null, "art", Integer.toString(((PunktParameterALKIS)object10).getArt())));
                        }
                        if (NasFFWriter.isNP((PunktParameterALKIS)object10) && ((PunktParameterALKIS)object10).hasVa()) {
                            ((XMLElement)object7).addChild(NasFFWriter.xs(null, "vermarkung_Marke", Integer.toString(((PunktParameterALKIS)object10).getModVa())));
                        }
                        if (((PunktParameterALKISExt)object10).hasVpArt()) {
                            ((XMLElement)object7).addChild(NasFFWriter.xl(null, "art", ((PunktParameterALKISExt)object10).getVpArt()));
                        }
                        if (((PunktParameterALKISExt)object10).hasZau()) {
                            ((XMLElement)object7).addChild(NasFFWriter.xl(null, "zeigtAuf", ((PunktParameterALKISExt)object10).getZau()));
                        }
                        if (((PunktParameterALKISExt)object10).hasHat()) {
                            NasFFWriter.addEnumL((XMLElement)object7, null, "hat", ((PunktParameterALKISExt)object10).getHatElements());
                        }
                        if (((PunktParameterALKISExt)object10).hasGzu()) {
                            ((XMLElement)object7).addChild(NasFFWriter.xl(null, "gehoertZu", ((PunktParameterALKISExt)object10).getGzu()));
                        }
                        if (((PunktParameterALKISExt)object10).hasBsa()) {
                            ((XMLElement)object7).addChild(NasFFWriter.xl(null, "beziehtSichAuf", ((PunktParameterALKISExt)object10).getBsa()));
                        }
                        if (((PunktParameterALKISExt)object10).hasMit()) {
                            NasFFWriter.addEnumL((XMLElement)object7, null, "gehoertZu", ((PunktParameterALKISExt)object10).getMitElements());
                        }
                        xMLElement5.addChild((XMLElement)object7);
                        xMLElement3.addChild(xMLElement5);
                        ((PrintWriter)object4).println(punkt.toAlkisPunktLine(true, false, "Confirm"));
                        continue;
                    }
                    ((PrintWriter)object4).println(punkt.toAlkisPunktLine(true, false, "Confirm Fehler: Ausgabepunktnummer " + l + " nicht in Bestandsdaten enthalten"));
                    this.addException(new Exception("Confirm: Ausgabepunktnummer " + l + " nicht in Bestandsdaten enthalten, Punkt " + l + " wird ignoriert!"));
                }
                catch (Exception exception) {
                    this.addException(exception);
                    exception.printStackTrace();
                }
            }
            ((PrintWriter)object4).close();
            if (n2 > 0) {
                xMLElement2.addChild(NasFFWriter.xs(null, "profilkennung", "GeoCalc-KafPlot"));
                xMLElement2.addChild(NasFFWriter.xs(null, "antragsnummer", DataBase.antrag));
                NasFFWriter nasFFWriter2 = this;
                xMLElement2.addChild(NasFFWriter.xs(null, "auftragsnummer", nasFFWriter2.db.getSourceName()));
                xMLElement2.addChild(NasFFWriter.xs(null, "geometriebehandlung", "false"));
                xMLElement2.addChild(NasFFWriter.xs(null, "mitTemporaeremArbeitsbereich", "false"));
                xMLElement2.addChild(NasFFWriter.xs(null, "mitObjektenImFortfuehrungsgebiet", "false"));
                xMLElement2.addChild(NasFFWriter.xs(null, "mitFortfuehrungsnachweis", "false"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object3 = null;
        object2 = null;
        String string = null;
        String string2 = null;
        try {
            object = this.getOutFile();
            String string3 = ((File)object).getAbsolutePath();
            int n11 = string3.lastIndexOf(File.separatorChar);
            string = n11 >= 0 ? string3.substring(0, n11) + File.separator : "";
            string2 = n11 >= 0 ? string3.substring(n11 + 1) : string3;
        }
        catch (Exception exception) {
            throw new IFileOutputException("Fehler beim Erzeugen der Dateinamen zu: " + this.outFile.getName());
        }
        if (n > 0 || NasIOProperties.writeVoidBa()) {
            object = string + "BA_" + string2;
            try {
                object3 = this.createWriter(new File((String)object));
                this.writeHeader((PrintWriter)object3);
                xMLElement.ident(0);
                xMLElement.write((Writer)object3);
                ((PrintWriter)object3).close();
                super.setProgress(90);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + (String)object);
            }
            finally {
                try {
                    ((PrintWriter)object3).close();
                }
                catch (Exception exception) {}
            }
        }
        if (n2 > 0) {
            object = string + "FF_" + string2;
            try {
                object2 = this.createWriter(new File((String)object));
                this.writeHeader((PrintWriter)object2);
                xMLElement2.ident(0);
                xMLElement2.write((Writer)object2);
                ((PrintWriter)object2).close();
                super.setProgress(100);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + (String)object);
            }
            finally {
                try {
                    ((PrintWriter)object2).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void writeHeader(PrintWriter printWriter) {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        String string = IFormat.i02.format(gregorianCalendar.get(5)) + "." + IFormat.i02.format(gregorianCalendar.get(2) + 1) + "." + IFormat.i04.format(gregorianCalendar.get(1)) + " " + IFormat.i02.format(gregorianCalendar.get(10)) + ":" + IFormat.i02.format(gregorianCalendar.get(12)) + ":" + IFormat.i02.format(gregorianCalendar.get(13));
        printWriter.println("<!--  Die NAS-Datei wurde mit " + KafPlotVersion.getTitle(1) + " Version 2.1.011 am " + string + " erstellt.  -->");
    }

    private String nextFid() {
        return "DEGEOC" + IFormat.i010.format(++this.fid);
    }

    private XMLElement createZustaendigeStelle(int n) {
        XMLElement xMLElement = NasFFWriter.x(null, "AX_Dienststelle_Schluessel");
        xMLElement.addChild(NasFFWriter.xs(null, "land", Integer.toString(n / 10000)));
        xMLElement.addChild(NasFFWriter.xs(null, "stelle", IFormat.i04.format(n % 10000)));
        return xMLElement;
    }

    private XMLElement createDelete(int n, String string) {
        String string2 = Alkis.getObjectName(n);
        XMLElement xMLElement = NasFFWriter.xp("wfs", "Delete", "typeName", string2);
        xMLElement.addChild(this.createFilter(string));
        return xMLElement;
    }

    private XMLElement createObject(int n, AA_Objekt aA_Objekt) {
        XMLElement xMLElement = NasFFWriter.xp(null, Alkis.getObjectName(n), GML_ID, aA_Objekt.getIdentifikator());
        xMLElement.addChild(NasFFWriter.xi(aA_Objekt.getIdentifikator()));
        xMLElement.addChild(NasFFWriter.xLzi(null, "lebenszeitintervall", aA_Objekt.getLebenszeitintervall()));
        xMLElement.addChild(this.defaultModel);
        Enumeration enumeration = aA_Objekt.getIstTeilVonElements();
        while (enumeration.hasMoreElements()) {
            xMLElement.addChild(NasFFWriter.xl(null, "istTeilVon", enumeration.nextElement().toString()));
        }
        return xMLElement;
    }

    private XMLElement createFilter(String string) {
        return NasFFWriter.xm("fes", "Filter.ResourceId", "rid", string);
    }

    private static final XMLElement xs(String string) {
        return NasFFWriter.xs(null, string, null);
    }

    private static final XMLElement xs(String string, String string2) {
        return NasFFWriter.xs(string, string2, null);
    }

    private static final XMLElement xs(String string, String string2, String string3) {
        XMLElement xMLElement = NasFFWriter.x(string, string2);
        xMLElement.setContent(string3);
        return xMLElement;
    }

    private static final XMLElement xm(String string, String string2) {
        XMLElement xMLElement;
        String[] stringArray = string2.split("[,\\.\\s]");
        XMLElement xMLElement2 = xMLElement = NasFFWriter.x(string, stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            XMLElement xMLElement3 = new XMLElement(xENTITIES, false, false, false, true);
            xMLElement3.setName(string, stringArray[i]);
            xMLElement2.addChild(xMLElement3);
            xMLElement2 = xMLElement3;
        }
        return xMLElement;
    }

    private static final XMLElement xm(String string, String string2, String string3) {
        XMLElement xMLElement;
        String[] stringArray = string2.split("[,\\.\\s]");
        XMLElement xMLElement2 = xMLElement = NasFFWriter.x(string, stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            XMLElement xMLElement3 = NasFFWriter.x(string, stringArray[i]);
            xMLElement2.addChild(xMLElement3);
            xMLElement2 = xMLElement3;
        }
        xMLElement2.setContent(string3);
        return xMLElement;
    }

    private static final XMLElement xm(String string, String string2, String string3, String string4) {
        XMLElement xMLElement;
        String[] stringArray = string2.split("[,\\.\\s]");
        XMLElement xMLElement2 = xMLElement = NasFFWriter.x(string, stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            XMLElement xMLElement3 = new XMLElement(xENTITIES, false, false, false, true);
            xMLElement3.setName(string, stringArray[i]);
            xMLElement2.addChild(xMLElement3);
            xMLElement2 = xMLElement3;
        }
        xMLElement2.addProperty(string3, string4);
        return xMLElement;
    }

    private static final XMLElement xps(String string, String string2, String string3, String string4, String string5) {
        XMLElement xMLElement = NasFFWriter.x(string, string2);
        xMLElement.addProperty(string3, string4);
        xMLElement.setContent(string5);
        return xMLElement;
    }

    private static final XMLElement xp(String string, String string2, String string3, String string4) {
        XMLElement xMLElement = NasFFWriter.x(string, string2);
        xMLElement.addProperty(string3, string4);
        return xMLElement;
    }

    private static final XMLElement xx(String string, String string2, XMLElement xMLElement) {
        XMLElement xMLElement2 = NasFFWriter.x(string, string2);
        xMLElement2.addChild(xMLElement);
        return xMLElement2;
    }

    private static final XMLElement xl(String string, String string2, String string3) {
        return NasFFWriter.xp(string, string2, "xlink:href", URN_ADV_OID + string3);
    }

    private static final XMLElement xi(String string) {
        return NasFFWriter.xps("gml", "identifier", "codeSpace", CS_ADV, URN_ADV_OID + string);
    }

    private static final XMLElement x(String string, String string2) {
        XMLElement xMLElement = new XMLElement(xENTITIES, false, false, false, true);
        xMLElement.setName(string, string2);
        return xMLElement;
    }

    private static final XMLElement xLzi(String string, String string2, AA_Lebenszeitintervall aA_Lebenszeitintervall) {
        XMLElement xMLElement = NasFFWriter.x(string, string2);
        XMLElement xMLElement2 = NasFFWriter.x(null, "AA_Lebenszeitintervall");
        if (aA_Lebenszeitintervall.hasBeginnt()) {
            xMLElement2.addChild(NasFFWriter.xs(null, "beginnt", IFormat.toDateTimeISO(aA_Lebenszeitintervall.getBeginnt())));
        }
        if (aA_Lebenszeitintervall.hasEndet()) {
            xMLElement2.addChild(NasFFWriter.xs(null, "endet", IFormat.toDateTimeISO(aA_Lebenszeitintervall.getEndet())));
        }
        xMLElement.addChild(xMLElement2);
        return xMLElement;
    }

    private static final XMLElement xPoint(String string, String string2, Punkt punkt) {
        XMLElement xMLElement = NasFFWriter.x(string, string2);
        XMLElement xMLElement2 = NasFFWriter.xs("gml", "Point");
        xMLElement2.addProperty("srsName", DEFAULT_SRS_NAME);
        xMLElement2.addProperty(GML_ID, NasFFWriter.kooId(punkt));
        xMLElement2.addChild(NasFFWriter.xs("gml", "pos", IFormat.f6_3.format(punkt.y - yReduction) + " " + IFormat.f7_3.format(punkt.x)));
        xMLElement.addChild(xMLElement2);
        return xMLElement;
    }

    private static final XMLElement xDqp(String string, String string2, PunktParameterALKIS punktParameterALKIS) {
        XMLElement xMLElement = NasFFWriter.x(string, string2);
        XMLElement xMLElement2 = NasFFWriter.x(null, "AX_DQPunktort");
        XMLElement xMLElement3 = NasFFWriter.x(null, "herkunft");
        XMLElement xMLElement4 = NasFFWriter.x("gmd", "LI_Lineage");
        XMLElement xMLElement5 = NasFFWriter.x("gmd", "processStep");
        XMLElement xMLElement6 = NasFFWriter.x("gmd", "LI_ProcessStep");
        XMLElement xMLElement7 = NasFFWriter.x("gmd", "description");
        xMLElement7.addChild(NasFFWriter.xs(null, "AX_LI_ProcessStep_Punktort_Description", EntstehungsArt.toOutString(punktParameterALKIS.getEa())));
        xMLElement6.addChild(xMLElement7);
        XMLElement xMLElement8 = NasFFWriter.x("gmd", "source");
        XMLElement xMLElement9 = NasFFWriter.x("gmd", "LI_Source");
        XMLElement xMLElement10 = NasFFWriter.x("gmd", "description");
        xMLElement10.addChild(NasFFWriter.xs(null, "AX_Datenerhebung_Punktort", punktParameterALKIS.getOutEq()));
        xMLElement9.addChild(xMLElement10);
        xMLElement8.addChild(xMLElement9);
        xMLElement6.addChild(xMLElement8);
        xMLElement5.addChild(xMLElement6);
        xMLElement4.addChild(xMLElement5);
        xMLElement3.addChild(xMLElement4);
        xMLElement2.addChild(xMLElement3);
        xMLElement2.addChild(NasFFWriter.xs(null, "genauigkeitsstufe", punktParameterALKIS.getOutLg()));
        if (punktParameterALKIS.getLz() > 0) {
            xMLElement2.addChild(NasFFWriter.xs(null, "lagezuverlaessigkeit", Boolean.toString(punktParameterALKIS.getLz() == 2)));
        }
        xMLElement.addChild(xMLElement2);
        return xMLElement;
    }

    private static final boolean isGP(PunktParameterALKIS punktParameterALKIS) {
        switch (punktParameterALKIS.getModPa()) {
            case 20: 
            case 29: {
                return true;
            }
        }
        return false;
    }

    private static final boolean isBG(PunktParameterALKIS punktParameterALKIS) {
        switch (punktParameterALKIS.getModPa()) {
            case 30: 
            case 39: 
            case 40: 
            case 49: {
                return true;
            }
        }
        return false;
    }

    private static final boolean isBB(PunktParameterALKIS punktParameterALKIS) {
        switch (punktParameterALKIS.getModPa()) {
            case 40: 
            case 49: {
                return true;
            }
        }
        return false;
    }

    private static final boolean isNP(PunktParameterALKIS punktParameterALKIS) {
        switch (punktParameterALKIS.getModPa()) {
            case 10: 
            case 11: 
            case 60: {
                return true;
            }
        }
        return false;
    }

    private static final void addEnumL(XMLElement xMLElement, String string, String string2, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            xMLElement.addChild(NasFFWriter.xl(string, string2, enumeration.nextElement().toString()));
        }
    }

    private static final void addEnumS(XMLElement xMLElement, String string, String string2, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            xMLElement.addChild(NasFFWriter.xs(string, string2, enumeration.nextElement().toString()));
        }
    }

    private static final long idNr(Punkt punkt) {
        return punkt.nr > 3521614606207L ? punkt.buildKatNr(12) : punkt.nr;
    }

    private static final String punktId(Punkt punkt) {
        return FIRST_GML_ID + NasFFWriter.encode(NasFFWriter.idNr(punkt), (byte)80);
    }

    private static final String ortId(Punkt punkt) {
        return FIRST_GML_ID + NasFFWriter.encode(NasFFWriter.idNr(punkt), (byte)79);
    }

    private static final String kooId(Punkt punkt) {
        return NasFFWriter.encode(NasFFWriter.idNr(punkt), (byte)75);
    }

    private static final String encode(long l, byte by) {
        byte[] byArray = new byte[8];
        for (int i = 7; i > 0; --i) {
            byArray[i] = ALPHABET[(int)(l % 62L)];
            l /= 62L;
        }
        byArray[0] = by;
        return new String(byArray);
    }

    private static final long decode(String string) {
        long l = 0L;
        for (int i = 1; i < 8; ++i) {
            l *= 62L;
            l += (long)NasFFWriter.b((byte)string.charAt(i));
        }
        return l;
    }

    private static final int b(byte by) {
        for (int i = 0; i < 62; ++i) {
            if (ALPHABET[i] != by) continue;
            return i;
        }
        return -1;
    }

    static {
        xENTITIES.put("amp", new char[]{'&'});
        xENTITIES.put("quot", new char[]{'\"'});
        xENTITIES.put("apos", new char[]{'\''});
        xENTITIES.put("lt", new char[]{'<'});
        xENTITIES.put("gt", new char[]{'>'});
        ALPHABET = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 45, 95};
    }
}

