/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.kafplot.KafPlot;
import de.geocalc.kafplot.io.IFileReader;
import de.geocalc.kataster.model.Alkis;
import de.geocalc.text.IFormat;
import de.geocalc.xml.readopt.XMLElement;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Hashtable;

public class NasInfo {
    private File inFile = null;
    private int operation;
    private String memberName = null;
    private Hashtable cooSystems = new Hashtable();
    private String antragsNummer = null;

    public NasInfo(File file) {
        this.inFile = file;
    }

    protected String getDefaultEncoding() {
        return "UTF-8";
    }

    public int getOperation() {
        return this.operation;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public Hashtable getCooSystems() {
        return this.cooSystems;
    }

    public String getAntragsNummer() {
        return this.antragsNummer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read() throws IOException {
        String string;
        long l = System.currentTimeMillis();
        LineNumberReader lineNumberReader = IFileReader.createFileReader(this.inFile, this.getDefaultEncoding());
        StringBuffer stringBuffer = new StringBuffer(8192);
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        while ((string = ((BufferedReader)lineNumberReader).readLine()) != null) {
            block20: {
                try {
                    stringBuffer.append(string.trim());
                    while (n2 >= 0) {
                        block21: {
                            Enumeration enumeration;
                            boolean bl4;
                            Object object;
                            block23: {
                                int n5;
                                block26: {
                                    Object object2;
                                    String string2;
                                    String string3;
                                    block25: {
                                        block24: {
                                            block22: {
                                                if ((n2 = stringBuffer.indexOf("<", n2)) < 0) {
                                                    stringBuffer.setLength(0);
                                                    n2 = 0;
                                                    break;
                                                }
                                                int n6 = this.nextIdent(stringBuffer, n2 + 1);
                                                if (n6 < 0) break block20;
                                                n5 = this.lastIdent(stringBuffer, n6 + 1);
                                                string3 = stringBuffer.substring(n6, n5);
                                                if (string3.equals("?xml")) {
                                                    this.skipTo(lineNumberReader, stringBuffer, n5, "?>");
                                                    continue;
                                                }
                                                if (string3.equals("!--")) {
                                                    this.skipTo(lineNumberReader, stringBuffer, n5, "-->");
                                                    continue;
                                                }
                                                if (string3.equals("<![CDATA[")) {
                                                    this.skipTo(lineNumberReader, stringBuffer, n5, "]]>");
                                                    continue;
                                                }
                                                int n7 = string3.indexOf(58);
                                                String string4 = string2 = n7 > 0 ? string3.substring(n7 + 1) : string3;
                                                if (n == 0 && (n = Alkis.getOperation(string2)) != 0) {
                                                    this.operation = n;
                                                    this.skipTo(lineNumberReader, stringBuffer, n5, ">");
                                                    if (n != 960999) continue;
                                                    bl2 = true;
                                                    continue;
                                                }
                                                if (!string2.equals("koordinatenangaben")) break block22;
                                                object = "";
                                                bl4 = false;
                                                object2 = this.getXml(lineNumberReader, stringBuffer, n2, "</" + string3 + ">");
                                                enumeration = ((XMLElement)object2).getChildrenAt(0).enumerateChildren();
                                                break block23;
                                            }
                                            if (!string2.equals("antragsnummer")) break block24;
                                            object = this.getXml(lineNumberReader, stringBuffer, n2, "</" + string3 + ">");
                                            this.antragsNummer = ((XMLElement)object).getContent();
                                            break block21;
                                        }
                                        if (!string2.equals("FeatureCollection")) break block25;
                                        bl2 = true;
                                        this.skipTo(lineNumberReader, stringBuffer, n5, ">");
                                        break block21;
                                    }
                                    if (string2.equals("Transaction")) {
                                        bl3 = true;
                                        break;
                                    }
                                    if (!bl2) break block26;
                                    if (string2.equals("boundedBy") && this.cooSystems.size() == 0) {
                                        object = this.getXml(lineNumberReader, stringBuffer, n2, "</" + string3 + ">");
                                        XMLElement xMLElement = ((XMLElement)object).getChildrenAt(0);
                                        if (xMLElement != null && (object2 = xMLElement.getStringAttribute("srsName")) != null) {
                                            this.cooSystems.put(object2, Boolean.TRUE);
                                            ++n3;
                                        }
                                        break block21;
                                    } else if (string2.equals("featureMember") || string2.equals("member")) {
                                        this.memberName = string3;
                                        this.skipTo(lineNumberReader, stringBuffer, n5, string2 + ">");
                                        ++n4;
                                        break block21;
                                    } else {
                                        this.skipTo(lineNumberReader, stringBuffer, n5, string2 + ">");
                                    }
                                    break block21;
                                }
                                this.skipTo(lineNumberReader, stringBuffer, n5, ">");
                                break block21;
                            }
                            while (enumeration.hasMoreElements()) {
                                XMLElement xMLElement = (XMLElement)enumeration.nextElement();
                                String string5 = xMLElement.getName();
                                if (string5.equals("crs") || string5.equals("adv:crs")) {
                                    object = xMLElement.getStringAttribute("xlink:href");
                                    continue;
                                }
                                if (!string5.equals("standard") && !string5.equals("adv:standard")) continue;
                                bl4 = IFormat.parseBoolean(xMLElement.getContent());
                            }
                            if (object != null) {
                                this.cooSystems.put(object, new Boolean(bl4));
                                ++n3;
                            }
                        }
                        if ((this.operation == 0 || n3 == 0 || this.memberName == null) && n4 <= 100) continue;
                        bl3 = true;
                        break;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (!bl3) continue;
        }
        lineNumberReader.close();
        if (this.operation == 0 && KafPlot.debug()) {
            System.out.println("NasReader:Operation: keine Operation gefunden");
        }
        if (KafPlot.debug()) {
            System.out.println("NasReader.infoTime: " + (System.currentTimeMillis() - l) + " Feats: " + n4);
        }
    }

    private void skipTo(BufferedReader bufferedReader, StringBuffer stringBuffer, int n, String string) throws IOException {
        String string2;
        int n2 = stringBuffer.indexOf(string, n);
        while (n2 < 0) {
            n = stringBuffer.length();
            string2 = bufferedReader.readLine();
            if (string2 == null) break;
            stringBuffer.append(string2.trim());
            n2 = stringBuffer.indexOf(string, n);
        }
        string2 = stringBuffer.substring(n2 + string.length());
        stringBuffer.setLength(0);
        stringBuffer.append(string2);
    }

    private int nextIdent(StringBuffer stringBuffer, int n) {
        int n2 = stringBuffer.length();
        for (int i = n; i < n2; ++i) {
            if (Character.isWhitespace(stringBuffer.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private int lastIdent(StringBuffer stringBuffer, int n) {
        int n2;
        int n3;
        int n4 = stringBuffer.length();
        for (n3 = n; n3 < n4 && !Character.isWhitespace((char)(n2 = stringBuffer.charAt(n3))); ++n3) {
            if (n2 == 47) {
                return n3 + 1;
            }
            if (n2 != 62 && n2 != 60) continue;
            return n3;
        }
        for (n2 = n3 + 1; n2 < n4; ++n2) {
            char c = stringBuffer.charAt(n2);
            if (Character.isWhitespace(c)) continue;
            if (c == '/') {
                return n2 + 1;
            }
            return n3;
        }
        return n3;
    }

    private XMLElement getXml(BufferedReader bufferedReader, StringBuffer stringBuffer, int n, String string) throws IOException {
        Object object;
        int n2 = n;
        int n3 = stringBuffer.indexOf(string, n2);
        while (n3 < 0) {
            n2 = stringBuffer.length();
            object = bufferedReader.readLine();
            if (object == null) break;
            stringBuffer.append(((String)object).trim());
            n3 = stringBuffer.indexOf(string, n2);
        }
        object = new XMLElement();
        ((XMLElement)object).parseString(stringBuffer.substring(n, n3 + string.length()));
        String string2 = stringBuffer.substring(n3 + string.length());
        stringBuffer.setLength(0);
        stringBuffer.append(string2);
        return object;
    }
}

