/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.kafplot.NummerierungsBezirkTable;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.io.NasReader;
import de.geocalc.kataster.model.Alkis;
import de.geocalc.xml.readopt.XMLElement;
import java.io.File;
import java.util.Hashtable;

public class NasPunktInfoReader
extends NasReader {
    private PunktTable PI = null;
    private Hashtable PL = null;
    private NummerierungsBezirkTable NB = null;

    public NasPunktInfoReader(File file, PunktTable punktTable, Hashtable hashtable, NummerierungsBezirkTable nummerierungsBezirkTable) {
        this(file, punktTable, hashtable, nummerierungsBezirkTable, null);
    }

    public NasPunktInfoReader(File file, PunktTable punktTable, Hashtable hashtable, NummerierungsBezirkTable nummerierungsBezirkTable, IProgressViewer iProgressViewer) {
        super(file, null, iProgressViewer);
        this.PI = punktTable;
        this.PL = hashtable;
        this.NB = nummerierungsBezirkTable;
    }

    @Override
    protected void registerNasFile(File file) {
    }

    @Override
    protected void computeParameterOfFile() {
        this.threadCount = 0;
    }

    @Override
    protected void computeProjectDefaults() {
    }

    @Override
    protected void setReadParameters() {
        this.readPunktExtends = true;
        this.readBGU = false;
        this.readBBU = false;
        this.updateDokuUnused = false;
        this.reportModelError = true;
    }

    @Override
    protected void computeData() {
        this.linkPoints(this.PI, this.PL, false);
    }

    @Override
    protected void parseFeature(String string) {
        try {
            int n = WFS_NORMAL;
            if (Character.isDigit(string.charAt(0))) {
                n = Integer.parseInt(string.substring(0, 1));
                string = string.substring(1);
            }
            XMLElement xMLElement = new XMLElement();
            xMLElement.parseString(string);
            String string2 = xMLElement.getName();
            String string3 = xMLElement.getStringAttribute("gml:id");
            if (n != WFS_NORMAL && string3 != null) {
                string3 = string3.substring(0, 16);
            }
            int n2 = Alkis.getOska(string2);
            switch (n2) {
                case 2350: {
                    break;
                }
                case 14002: 
                case 14003: 
                case 14004: {
                    this.pOrte.addElement(this.parsePunktort(n2, xMLElement));
                    break;
                }
                case 11003: 
                case 13001: 
                case 13002: 
                case 13003: 
                case 19001: 
                case 19002: 
                case 19003: 
                case 19004: 
                case 31005: 
                case 51011: 
                case 61009: {
                    this.punkte.put(string3, this.parsePunkt(xMLElement, n2));
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.addException(exception);
        }
    }
}

