/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IException;
import de.geocalc.awt.IProgressViewer;
import de.geocalc.geom.DArc;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPoint3D;
import de.geocalc.geom.GeomElement;
import de.geocalc.geom.GeomException;
import de.geocalc.geom.Koordinate2D;
import de.geocalc.geom.algorithm.GaussianElimination;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.AngleElement;
import de.geocalc.kafplot.BodenSchaetzung;
import de.geocalc.kafplot.BodenSchaetzungTable;
import de.geocalc.kafplot.Buchungsstelle;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.EntstehungsArt;
import de.geocalc.kafplot.ErrorObject;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.FlurstueckTable;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.GObjectManipulator;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.GebaeudeTable;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.GrundbuchTable;
import de.geocalc.kafplot.Grundbuchblatt;
import de.geocalc.kafplot.KafPlot;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KatAmt;
import de.geocalc.kafplot.Lage;
import de.geocalc.kafplot.LageEntry;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.Name;
import de.geocalc.kafplot.NummerierungsBezirk;
import de.geocalc.kafplot.Nutzung;
import de.geocalc.kafplot.NutzungTable;
import de.geocalc.kafplot.ObjectSymbol;
import de.geocalc.kafplot.ObjectText;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.PunktParameterALKIS;
import de.geocalc.kafplot.PunktParameterALKISExt;
import de.geocalc.kafplot.PunktStatus;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.Strasse;
import de.geocalc.kafplot.Symbol;
import de.geocalc.kafplot.TopObject;
import de.geocalc.kafplot.TopObjectTable;
import de.geocalc.kafplot.io.ErrorWriter;
import de.geocalc.kafplot.io.IDataReader;
import de.geocalc.kafplot.io.NasInfo;
import de.geocalc.kafplot.io.alkis.NasIOProperties;
import de.geocalc.kataster.model.AA_Fachdatenverbindung;
import de.geocalc.kataster.model.AA_Lebenszeitintervall;
import de.geocalc.kataster.model.AA_Modellart;
import de.geocalc.kataster.model.AA_Objekt;
import de.geocalc.kataster.model.AX_Punktort;
import de.geocalc.kataster.model.A_Anlass;
import de.geocalc.kataster.model.Alkis;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparable;
import de.geocalc.util.IntegerHashList;
import de.geocalc.util.IntegerHashObject;
import de.geocalc.util.LongComparator;
import de.geocalc.util.LongHashObject;
import de.geocalc.util.SortableVector;
import de.geocalc.util.sml.Tag;
import de.geocalc.xml.readopt.XMLElement;
import java.io.BufferedReader;
import java.io.File;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class NasReader
extends IDataReader {
    protected static final String DELIM = "|";
    protected static final int POSITION = 1001;
    protected static final int IST_TEIL_VON = 1002;
    protected static final int KOORDINATENSTATUS = 1003;
    protected static final int KARTENDARSTELLUNG = 1004;
    protected static final int QUALITAETSANGABEN = 1005;
    protected static final int HERKUNFT = 1006;
    protected static final int GENAUIGKEITSWERT = 1007;
    protected static final int GENAUIGKEITSSTUFE = 1008;
    protected static final int LAGEZUVERLAESSIGKEIT = 1009;
    protected static final int PUNKTKENNUNG = 1010;
    protected static final int ART = 1011;
    protected static final int ABMARKUNG_MARKE = 1012;
    protected static final int VERMARKUNG_MARKE = 1013;
    protected static final int BEMERKUNG_ZUR_ABMARKUNG = 1014;
    protected static final int SONSTIGE_EIGENSCHAFT = 1015;
    protected static final int PUNKTVERMARKUNG = 1016;
    protected static final int DIENT_ZUR_DARSTELLUNG_VON = 1017;
    protected static final int DREHWINKEL = 1018;
    protected static final int GEMARKUNG = 1020;
    protected static final int LAND = 1021;
    protected static final int GEMARKUNGSNUMMER = 1022;
    protected static final int FLURSTUECKSNUMMER = 1023;
    protected static final int ZAEHLER = 1024;
    protected static final int NENNER = 1025;
    protected static final int FLURNUMMER = 1026;
    protected static final int GEMEINDEZUGEHOERIGKEIT = 1027;
    protected static final int IST_GEBUCHT = 1028;
    protected static final int ZEIGT_AUF = 1029;
    protected static final int WEIST_AUF = 1030;
    protected static final int GEHOERT_ANTEILIG_ZU = 1031;
    protected static final int BEZIEHT_SICH_AUF_FLURSTUECK = 1032;
    protected static final int FLURSTUECKSFOLGE = 1033;
    protected static final int ABWEICHENDER_RECHTSZUSTAND = 1034;
    protected static final int ZWEIFELHAFTER_FLURSTUECKSNACHWEIS = 1035;
    protected static final int RECHTSBEHELFSVERFAHREN = 1036;
    protected static final int SONSTIGE_EIGENSCHAFTEN = 1037;
    protected static final int ZEITPUNKT_DER_ENTSTEHUNG = 1038;
    protected static final int ZUSTAENDIGE_STELLE = 1039;
    protected static final int AMTLICHE_FLAECHE = 1040;
    protected static final int GEBAEUDEFUNKTION = 1041;
    protected static final int OBJEKTHOEHE = 1042;
    protected static final int DACHFORM = 1043;
    protected static final int BAUWEISE = 1044;
    protected static final int ANZAHL_DER_OBERIRDISCHEN_GESCHOSSE = 1045;
    protected static final int ANZAHL_DER_UNTERIRDISCHEN_GESCHOSSE = 1046;
    protected static final int HOCHHAUS = 1047;
    protected static final int ZUSTAND = 1048;
    protected static final int GESCHOSSFLAECHE = 1049;
    protected static final int GRUNDFLAECHE = 1050;
    protected static final int UMBAUTER_RAUM = 1051;
    protected static final int BAUJAHR = 1052;
    protected static final int LAGE_ZUR_ERDOBERFLAECHE = 1053;
    protected static final int DACHART = 1054;
    protected static final int DACHGESCHOSSAUSBAU = 1055;
    protected static final int WEITERE_GEBAEUDEFUNKTION = 1056;
    protected static final int NAME = 1057;
    protected static final int NUTZUNG = 1058;
    protected static final int HAT = 1059;
    protected static final int DATUM_DER_LETZTEN_UEBERPRUEFUNG = 1060;
    protected static final int ART_DER_BEBAUUNG = 1061;
    protected static final int FUNKTION = 1062;
    protected static final int FOERDERGUT = 1063;
    protected static final int LAGERGUT = 1064;
    protected static final int PRIMAERENERGIE = 1065;
    protected static final int BEZEICHNUNG = 1066;
    protected static final int ABBAUGUT = 1067;
    protected static final int ZWEITNAME = 1068;
    protected static final int BAHNKATEGORIE = 1069;
    protected static final int NUMMER_DER_BAHNSTRECKE = 1070;
    protected static final int VEGETATIONSMERKMAL = 1071;
    protected static final int OBERFLAECHENMATERIAL = 1072;
    protected static final int GEWAESSERKENNZIFFER = 1073;
    protected static final int HYDROLOGISCHESMERKMAL = 1074;
    protected static final int TIDEMERKMAL = 1075;
    protected static final int KULTURART = 1076;
    protected static final int BODENART = 1077;
    protected static final int ZUSTANDSSTUFE_ODER_BODENSTUFE = 1078;
    protected static final int BODENZAHL_ODER_GRUENLANDGRUNDZAHL = 1079;
    protected static final int ACKERZAHL_ODER_GRUENLANDZAHL = 1080;
    protected static final int SONSTIGE_ANGABEN = 1081;
    protected static final int JAHRESZAHL = 1082;
    protected static final int ENTSTEHUNGSART_ODER_KLIMASTUFE_WASSERVERHAELTNISSE = 1083;
    protected static final int LAGEBEZEICHNUNG = 1084;
    protected static final int HAUSNUMMER = 1085;
    protected static final int PSEUDONUMMER = 1086;
    protected static final int LAUFENDE_NUMMER = 1087;
    protected static final int REGIERUNGSBEZIRK = 1088;
    protected static final int KREIS = 1089;
    protected static final int GEMEINDE = 1090;
    protected static final int LAGE = 1091;
    protected static final int BUCHUNGSBLATTKENNZEICHEN = 1092;
    protected static final int BESTEHT_AUS = 1093;
    protected static final int BUCHUNGSART = 1094;
    protected static final int ANTEIL = 1095;
    protected static final int NUMMER_IM_AUFTEILUNGSPLAN = 1096;
    protected static final int BESCHREIBUNG_DES_SONDEREIGENTUMS = 1097;
    protected static final int BUCHUNGSTEXT = 1098;
    protected static final int BESCHREIBUNG_DES_UMFANGS_DER_BUCHUNG = 1099;
    protected static final int IST_BESTANDTEIL_VON = 1100;
    protected static final int LAUFENDE_NUMMER_NACH_DIN1421 = 1101;
    protected static final int NUMMER = 1102;
    protected static final int ART_DER_RECHTSGEMEINSCHAFT = 1104;
    protected static final int BESCHRIEB_DER_RECHTSGEMEINSCHAFT = 1105;
    protected static final int EIGENTUEMERART = 1106;
    protected static final int STRICHBLATTNUMMER = 1107;
    protected static final int BENENNT = 1108;
    protected static final int BESTEHT_AUS_RECHTSVERHAELTNISSEN_ZU = 1109;
    protected static final int NACHNAME_ODER_FIRMA = 1110;
    protected static final int ANREDE = 1111;
    protected static final int VORNAME = 1112;
    protected static final int NAMENSBESTANDTEIL = 1113;
    protected static final int AKADEMISCHER_GRAD = 1114;
    protected static final int GEBURTSNAME = 1115;
    protected static final int GEBURTSDATUM = 1116;
    protected static final int WOHNORT_ODER_SITZ = 1117;
    protected static final int BERUF = 1118;
    protected static final int HAUSHALTSSTELLE_LANDESGRUNDBESITZ = 1119;
    protected static final int WIRD_VERTRETEN_VON = 1120;
    protected static final int BESITZT = 1121;
    protected static final int ORT_POST = 1122;
    protected static final int POSTLEITZAHL_POSTZUSTELLUNG = 1123;
    protected static final int POSTLEITZAHL_POSTFACH = 1124;
    protected static final int BESTIMMUNGSLAND = 1125;
    protected static final int ORTSTEIL = 1126;
    protected static final int STRASSE = 1127;
    protected static final int ORT_AMTLICHES_ORTSNAMENSVERZEICHNIS = 1128;
    protected static final int POSTFACH = 1129;
    protected static final int FAX = 1130;
    protected static final int TELEFON = 1131;
    protected static final int WEITERE_ADRESSEN = 1132;
    protected static final int AN = 1133;
    protected static final int BAUART = 1134;
    protected static final int DURCHFAHRTSHOEHE = 1135;
    protected static final int BAUWERKSFUNKTION = 1136;
    protected static final int SPEICHERINHALT = 1137;
    protected static final int PRODUKT = 1138;
    protected static final int SPANNUNGSEBENE = 1139;
    protected static final int SPORTART = 1140;
    protected static final int ARCHAEOLOGISCHER_TYP = 1141;
    protected static final int HYDROLOGISCHES_MERKMAL = 1142;
    protected static final int KILOMETERANGABE = 1143;
    protected static final int MARKIERUNG = 1144;
    protected static final int BAHNHOFSKATEGORIE = 1145;
    protected static final int BEWUCHS = 1146;
    protected static final int HOEHE_DES_WASSERSPIEGELS = 1147;
    protected static final int ART_DER_GELAENDEKANTE = 1148;
    protected static final int HINWEISE = 1149;
    protected static final int IDENTIFIER = 1150;
    protected static final int LEBENSZEITINTERVALL = 1151;
    protected static final int MODELLART = 1152;
    protected static final int ANLASS = 1153;
    protected static final int ZEIGT_AUF_EXTERNES = 1154;
    protected static final int GEHOERT_ZU = 1155;
    protected static final int BEZIEHT_SICH_AUF = 1156;
    protected static final int MIT = 1157;
    protected static final int UEBERPRUEFUNGSDATUM = 1158;
    protected static final int VERTRITT = 1159;
    protected static final int HAENGT_AN = 1160;
    protected static final int UEBT_AUS = 1161;
    protected static final int NUTZUNGSART = 1162;
    protected static final int ZUSTANDSSTUFE = 1163;
    protected static final int BODENSTUFE = 1164;
    protected static final int ENTSTEHUNGSART = 1165;
    protected static final int KLIMASTUFE = 1166;
    protected static final int WASSERVERHAELTNISSE = 1167;
    protected static final int SKALIERUNG = 1168;
    protected static final int HORIZONTALE_AUSRICHTUNG = 1169;
    protected static final int VERTIKALE_AUSRICHTUNG = 1170;
    protected static final int SIGNATURNUMMER = 1171;
    protected static final int SCHRIFTINHALT = 1172;
    protected static final int FONTSPERRUNG = 1173;
    private static final HashMap<String, Integer> attributes = new HashMap(200, 2.0f);
    protected static int WFS_NORMAL;
    protected static int WFS_INSERT;
    protected static int WFS_REPLACE;
    protected static int WFS_DELETE;
    protected static long NEW_NUMBER;
    protected static long pnrReduction;
    protected static double yAddition;
    protected boolean readBGU = false;
    protected boolean readBBU = false;
    protected boolean readPunktExtends = false;
    protected boolean reportModelError = false;
    protected boolean updateDokuUnused = false;
    protected boolean dataModelError = false;
    protected boolean infoUpdateUnused = false;
    protected boolean infoConfirmUnused = false;
    protected static final String LINK = "#";
    private String FEATURE_START = "<gml:featureMember>";
    private String FEATURE_END = "</gml:featureMember>";
    private static final String INSERT_START = "<wfs:Insert";
    private static final String REPLACE1_START = "<wfsext:Replace";
    private static final String REPLACE2_START = "<wfs:Replace";
    private static final String DELETE_START = "<wfs:Delete";
    private static final String INSERT_END = "</wfs:Insert>";
    private static final String REPLACE1_END = "</wfsext:Replace>";
    private static final String REPLACE2_END = "</wfs:Replace>";
    private static final String DELETE_END = "</wfs:Delete>";
    private static final String RESERVE_ERG_START = "<AX_Reservierungsergebnis";
    private static final String RESERVE_ERG_END = "</AX_Reservierungsergebnis>";
    private int FEATURE_START_LENGTH = this.FEATURE_START.length();
    private int FEATURE_END_LENGTH = this.FEATURE_END.length();
    private static final int INSERT_START_LENGTH;
    private static final int REPLACE1_START_LENGTH;
    private static final int REPLACE2_START_LENGTH;
    private static final int DELETE_START_LENGTH;
    private static final int INSERT_END_LENGTH;
    private static final int REPLACE1_END_LENGTH;
    private static final int REPLACE2_END_LENGTH;
    private static final int DELETE_END_LENGTH;
    private static final int RESERVE_ERG_START_LENGTH;
    private static final int RESERVE_ERG_END_LENGTH;
    private static final long THREAD_WAIT_TIME = 30L;
    protected int threadCount = 0;
    Parser[] parsers = null;
    private BufferedReader reader = null;
    private DataBase db;
    private double yAdd = 0.0;
    private long nrRed = 0L;
    private boolean updateMode = false;
    private Hashtable cooSystems = new Hashtable();
    private int amtFileKennung = 0;
    private int amtFeatureCount = 0;
    private int currentAmtKey = 0;
    protected Vector pOrte = new Vector(3000);
    protected Vector oOrte = new Vector(500);
    protected Vector oPrae = new Vector(100);
    protected Vector deletes = new Vector(10);
    protected Hashtable punkte = new Hashtable(3001, 3.0f);
    protected Hashtable koords = new Hashtable(5003, 3.0f);
    protected Hashtable objekte = new Hashtable(503, 3.0f);
    protected Hashtable namen = new Hashtable(101, 3.0f);
    protected Hashtable personen = new Hashtable(101, 3.0f);
    protected Hashtable stellen = new Hashtable(101, 3.0f);
    protected Hashtable anschriften = new Hashtable(101, 3.0f);
    protected Hashtable vertretungen = new Hashtable(11, 3.0f);
    protected IntegerHashList gemeinden = new IntegerHashList(3.0f);
    protected IntegerHashList gemarkungen = new IntegerHashList(3.0f);
    protected Vector strassen = new Vector();
    private int operation = 0;
    private int featStartLength = this.FEATURE_START_LENGTH;
    private int featEndLength = this.FEATURE_END_LENGTH;
    private String featEnd = this.FEATURE_END;
    private NasInfo info = null;
    private boolean isFortfuehrung = false;
    private ExceptionList initExceptions = new ExceptionList();
    private ExceptionList linkExceptions = new ExceptionList();
    private ExceptionList updateMessages = new ExceptionList();
    private int linkExceptionCount = 0;
    private int maxLinkExceptionCount = 50;
    private Runtime runTime = Runtime.getRuntime();
    private int kooSystem = 489;
    private boolean abort = false;
    private static final int ENT_O = 0;
    private static final int ENT_G = 1;
    private static final int ENT_R = 2;
    private int aktBufferId = 0;

    protected static final Integer getAttribute(String string) {
        Integer n = attributes.get(string);
        return n;
    }

    public static void setNewNumber(long l) {
        NEW_NUMBER = l;
    }

    public static long getNewNumber() {
        return NEW_NUMBER;
    }

    public static final void setPnrReduction(long l) {
        pnrReduction = l;
    }

    public static final long getPnrReduction() {
        return pnrReduction;
    }

    public static final void setYAddition(double d) {
        yAddition = d;
    }

    public static final double getYAddition() {
        return yAddition;
    }

    public final boolean hasModelErrors() {
        return this.dataModelError;
    }

    public NasReader(File file, DataBase dataBase) {
        this(file, dataBase, null);
    }

    public NasReader(File file, DataBase dataBase, IProgressViewer iProgressViewer) {
        super(file, iProgressViewer);
        this.db = dataBase;
        this.threadCount = KafPlotProperties.getMaxThreadCount();
        this.parsers = new Parser[this.threadCount];
        this.setParameterOfFileInfo();
        this.computeParameterOfFile();
    }

    @Override
    protected String getDefaultEncoding() {
        return "UTF-8";
    }

    @Override
    protected void setParameter() {
        super.setParameter();
        if (NEW_NUMBER > 0L) {
            super.setFreeStartNumber(NEW_NUMBER);
        }
        this.setMode(19);
        this.yAdd = NasReader.getYAddition();
        this.nrRed = NasReader.getPnrReduction();
    }

    private synchronized void setParameterOfFileInfo() {
        try {
            this.info = new NasInfo(this.inFile);
            this.info.read();
            this.operation = this.info.getOperation();
            this.isFortfuehrung = this.operation == 96001;
            this.cooSystems = this.info.getCooSystems();
            if (this.info.getMemberName() != null) {
                this.FEATURE_START = "<" + this.info.getMemberName() + ">";
                this.FEATURE_END = "</" + this.info.getMemberName() + ">";
                this.FEATURE_START_LENGTH = this.FEATURE_START.length();
                this.FEATURE_END_LENGTH = this.FEATURE_END.length();
                this.featStartLength = this.FEATURE_START_LENGTH;
                this.featEndLength = this.FEATURE_END_LENGTH;
                this.featEnd = this.FEATURE_END;
            }
            if (this.operation == 960121) {
                this.featStartLength = this.FEATURE_START_LENGTH;
            }
            Enumeration enumeration = this.cooSystems.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Boolean bl = (Boolean)this.cooSystems.get(string);
                if (KafPlot.debug()) {
                    System.out.println("NasReader.CS: " + string + (bl != false ? " STANDARD" : ""));
                }
                if (bl.booleanValue()) {
                    int n = string.lastIndexOf(58);
                    if (n >= 0) {
                        string = string.substring(n + 1);
                    }
                    if (string.startsWith("ETRS89_UTM")) {
                        int n2 = 0;
                        try {
                            n2 = Integer.parseInt(string.substring(10));
                            this.nrRed = (long)(n2 / 10) * 100000000000000L;
                            this.yAdd = (double)(n2 % 10) * 1000000.0;
                        }
                        catch (Exception exception) {
                            if (!KafPlot.debug()) continue;
                            exception.printStackTrace();
                        }
                        continue;
                    }
                    this.kooSystem = -1;
                    continue;
                }
                if (!this.isFortfuehrung) continue;
                this.addInitException(new Exception("Der Fortf\u00fchrungsauftrag enth\u00e4lt weiteres Koordinatensystem: " + string));
            }
        }
        catch (Exception exception) {
            this.addInitException(exception);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void computeParameterOfFile() {
        block17: {
            if (this.info == null || this.info.getAntragsNummer() == null) break block17;
            if (DataBase.antrag == null) ** GOTO lbl7
            if (DataBase.antrag.length() == 0) {
lbl7:
                // 2 sources

                DataBase.antrag = this.info.getAntragsNummer();
            } else if (!DataBase.antrag.equals(this.info.getAntragsNummer())) {
                this.addInitException(new Exception("Antragsnummer " + this.info.getAntragsNummer() + " nicht identisch mit Projektdaten " + DataBase.antrag));
            }
            if (DataBase.katasterAmt == null) {
                try {
                    var1_1 = this.info.getAntragsNummer();
                    if (var1_1.length() > 3 && var1_1.charAt(2) == '_') {
                        this.amtFileKennung = Integer.parseInt(var1_1.substring(0, 2));
                    }
                }
                catch (Exception var1_2) {
                    // empty catch block
                }
            }
        }
        if (KafPlot.debug()) {
            System.out.println("NasReader.OP: " + Alkis.getOperationName(this.operation));
        }
        if (this.operation == 960122) {
            NasIOProperties.readBGU(false);
            NasIOProperties.readBBU(false);
            NasIOProperties.readUnusedPoints(false);
            NasIOProperties.readPunktExtends(false);
        }
        if (DataBase.P.size() == 0) {
            NasIOProperties.markUpdatePoints(false);
            NasIOProperties.replaceUpdatePoints(false);
            NasIOProperties.infoInsert(false);
            NasIOProperties.infoConfirm(false);
            NasIOProperties.infoConfirmUnused(false);
            NasIOProperties.infoUpdate(false);
            NasIOProperties.infoUpdateUnused(false);
            NasIOProperties.infoObject(false);
        } else if (DataBase.UMNUM.size() > 0) {
            NasIOProperties.markUpdatePoints(false);
            NasIOProperties.replaceUpdatePoints(true);
            NasIOProperties.infoInsert(true);
            NasIOProperties.infoConfirm(true);
            NasIOProperties.infoConfirmUnused(false);
            NasIOProperties.infoUpdate(true);
            NasIOProperties.infoUpdateUnused(false);
            NasIOProperties.infoObject(true);
        } else if (this.inFile.getName().startsWith("Vermessungspunkte_")) {
            NasIOProperties.markUpdatePoints(false);
            NasIOProperties.replaceUpdatePoints(true);
            NasIOProperties.infoInsert(false);
            NasIOProperties.infoConfirm(false);
            NasIOProperties.infoConfirmUnused(false);
            NasIOProperties.infoUpdate(true);
            NasIOProperties.infoUpdateUnused(true);
            NasIOProperties.infoObject(true);
        } else if (this.operation == 96001 || this.inFile.getName().startsWith("BA_")) {
            NasIOProperties.markUpdatePoints(true);
            NasIOProperties.replaceUpdatePoints(false);
            NasIOProperties.infoInsert(true);
            NasIOProperties.infoConfirm(true);
            NasIOProperties.infoConfirmUnused(true);
            NasIOProperties.infoUpdate(true);
            NasIOProperties.infoUpdateUnused(true);
            NasIOProperties.infoObject(true);
        } else {
            NasIOProperties.markUpdatePoints(false);
            NasIOProperties.replaceUpdatePoints(true);
            NasIOProperties.infoInsert(true);
            NasIOProperties.infoConfirm(false);
            NasIOProperties.infoConfirmUnused(false);
            NasIOProperties.infoUpdate(true);
            NasIOProperties.infoUpdateUnused(true);
            NasIOProperties.infoObject(true);
        }
    }

    @Override
    public boolean isMengeReader() {
        return true;
    }

    @Override
    public boolean isUpdateReader() {
        return true;
    }

    @Override
    public boolean isMutableNumberReader() {
        return false;
    }

    public void setCooSystems(Hashtable hashtable) {
        this.cooSystems = hashtable;
    }

    protected boolean hasCooSystem(String string) {
        if (string == null) {
            return false;
        }
        Boolean bl = (Boolean)this.cooSystems.get(string);
        return bl != null;
    }

    protected boolean isStandardCooSystem(String string) {
        if (string == null) {
            return false;
        }
        Boolean bl = (Boolean)this.cooSystems.get(string);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    protected void setReadParameters() {
        this.readBGU = NasIOProperties.readBGU();
        this.readBBU = NasIOProperties.readBBU();
        this.readPunktExtends = NasIOProperties.readPunktExtends();
    }

    private void waitOfParsers() {
        this.waitOfParsers(1);
    }

    private void waitOfParsers(int n) {
        try {
            Thread.sleep((long)n * 30L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startThreads() {
        for (int i = 0; i < this.threadCount; ++i) {
            Parser parser = new Parser(i);
            parser.start();
            this.parsers[i] = parser;
        }
    }

    private boolean workThreads() {
        int n;
        for (n = 0; n < this.threadCount; ++n) {
            this.parsers[n].work();
        }
        do {
            this.waitOfParsers();
            n = 0;
            for (int i = 0; i < this.threadCount; ++i) {
                if (this.parsers[i].getParseState() != 1) continue;
                ++n;
            }
        } while (n != 0);
        return true;
    }

    private boolean closeThreads() {
        int n;
        int n2 = 0;
        int n3 = this.threadCount;
        int n4 = this.threadCount;
        for (n = 0; n < this.threadCount; ++n) {
            this.parsers[n].close();
        }
        do {
            this.waitOfParsers();
            n3 = 0;
            for (n = 0; n < this.threadCount; ++n) {
                if (this.parsers[n].getParseState() != 1) continue;
                ++n3;
            }
            if (n3 == 0) break;
            if (n3 == n4) {
                ++n2;
                continue;
            }
            n2 = 0;
            n4 = n3;
        } while (n2 <= 120);
        return n3 == 0;
    }

    private boolean killThreads() {
        int n;
        int n2 = 0;
        int n3 = this.threadCount;
        for (n = 0; n < this.threadCount; ++n) {
            this.parsers[n].kill();
        }
        do {
            this.waitOfParsers();
            n3 = 0;
            for (n = 0; n < this.threadCount; ++n) {
                if (this.parsers[n].getParseState() != 1) continue;
                ++n3;
            }
            if (!KafPlot.debug()) continue;
            System.out.print(".");
        } while (++n2 < 20);
        return n3 == 0;
    }

    @Override
    public void read() throws IFileInputException {
        this.prepareRead();
        this.fileRead();
        this.finishRead();
    }

    @Override
    public void prepareMultiReading() {
        this.prepareRead();
    }

    @Override
    public void readMulti(File file) throws IException {
        this.setFile(file);
        this.setParameterOfFileInfo();
        this.fileRead();
    }

    @Override
    public void finishMultiReading() {
        this.finishRead();
    }

    private void prepareRead() {
        this.addExceptions(this.initExceptions);
        this.initExceptions.clear();
        this.setReadParameters();
        this.startThreads();
    }

    private void fileRead() throws IFileInputException {
        if (this.abort) {
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = this.runTime.freeMemory();
        try {
            this.registerNasFile(this.getFile());
            if (this.operation == 96008) {
                this.readNasReserveFile(this.inFile);
            } else {
                Thread.currentThread().setPriority(10);
                this.readNasFile(this.inFile);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IFileInputException(exception.getMessage());
        }
        if (KafPlot.debug()) {
            System.out.println("NasReader.time: " + (System.currentTimeMillis() - l) + " FreeMemory: " + this.runTime.freeMemory() / 1024L / 1024L + "Mb");
        }
    }

    private void finishRead() {
        this.closeThreads();
        if (!this.abort) {
            if (this.operation != 96008) {
                this.computeData();
                this.computeProjectDefaults();
            }
            if (this.linkExceptionCount < this.maxLinkExceptionCount) {
                this.addExceptions(this.linkExceptions);
                this.linkExceptions.clear();
            } else {
                this.addException(new Exception("Es wurden " + this.linkExceptionCount + " Verlinkungen nicht aufgel\u00f6st, die Daten sind unvollst\u00e4ndig"));
            }
            String string = this.inFile.getName();
            int n = string.lastIndexOf(".");
            if (n >= 0) {
                string = string.substring(0, n);
            }
            if (this.getExceptionList() != null && this.getExceptionList().size() > 0 || this.updateMessages.size() > 0) {
                ExceptionList exceptionList = new ExceptionList();
                Object object = this.getExceptionList().elements();
                while (object.hasMoreElements()) {
                    exceptionList.addElement(object.nextElement());
                }
                object = this.updateMessages.elements();
                while (object.hasMoreElements()) {
                    exceptionList.addElement(object.nextElement());
                }
                object = new ErrorWriter(new File(string + ".Import.err"), exceptionList);
                ((ErrorWriter)object).setHeader("#NAS-Import am " + new Date().toString());
                try {
                    ((ErrorWriter)object).write();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.clearInternals();
    }

    @Override
    public int getKooSystem() {
        return this.kooSystem;
    }

    private void clearInternals() {
        this.cooSystems.clear();
        this.pOrte.clear();
        this.pOrte.trimToSize();
        this.oOrte.clear();
        this.pOrte.trimToSize();
        this.oPrae.clear();
        this.pOrte.trimToSize();
        this.deletes.clear();
        this.punkte.clear();
        this.koords.clear();
        this.objekte.clear();
        this.namen.clear();
        this.personen.clear();
        this.stellen.clear();
        this.vertretungen.clear();
        this.anschriften.clear();
        this.gemeinden.clear();
        this.gemarkungen.clear();
        this.strassen.clear();
    }

    protected void registerNasFile(File file) {
        DataBase.addNasFile(file.getAbsolutePath());
    }

    protected void computeProjectDefaults() {
        block14: {
            block13: {
                if (DataBase.gemarkung == null) break block13;
                if (DataBase.gemeinde != null) break block14;
            }
            double d = 0.0;
            double d2 = 0.0;
            Enumeration enumeration = DataBase.FLST.elements();
            while (enumeration.hasMoreElements()) {
                Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
                d += flurstueck.getX();
                d2 += flurstueck.getY();
            }
            d /= (double)DataBase.FLST.size();
            d2 /= (double)DataBase.FLST.size();
            double d3 = Double.MAX_VALUE;
            Flurstueck flurstueck = null;
            Object object = DataBase.FLST.elements();
            while (object.hasMoreElements()) {
                double d4;
                Flurstueck flurstueck2 = (Flurstueck)object.nextElement();
                double d5 = d - flurstueck2.getX();
                double d6 = d5 * d5 + (d4 = d2 - flurstueck2.getY()) * d4;
                if (!(d6 < d3)) continue;
                flurstueck = flurstueck2;
                d3 = d6;
            }
            if (flurstueck != null) {
                object = Gemarkung.getGemarkung(flurstueck.getGemarkung());
                if (object != null) {
                    if (DataBase.gemarkung == null) {
                        DataBase.gemarkung = ((Gemarkung)object).getName();
                        if (DataBase.flur == null) {
                            DataBase.flur = Integer.toString(flurstueck.getFlur());
                        }
                    }
                    if (DataBase.gemeinde == null && ((Gemarkung)object).getGemeinde() != null) {
                        DataBase.gemeinde = ((Gemarkung)object).getGemeinde().getName();
                    }
                }
                try {
                    if (DataBase.bearbeiter == null) {
                        DataBase.bearbeiter = System.getProperty("user.name");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private int indexOfFeatureStart(String string, int n) {
        if (this.operation == 960121 || this.operation == 960999) {
            return string.indexOf(this.FEATURE_START, n);
        }
        if (this.operation == 960122 || this.operation == 96001) {
            int n2 = string.indexOf(INSERT_START, n);
            if (n2 >= 0) {
                this.featStartLength = string.indexOf(62, n2 + INSERT_START_LENGTH) - n2 + 1;
                this.featEndLength = INSERT_END_LENGTH;
                this.featEnd = INSERT_END;
                return n2;
            }
            n2 = string.indexOf(REPLACE1_START, n);
            if (n2 >= 0) {
                this.featStartLength = string.indexOf(62, n2 + REPLACE1_START_LENGTH) - n2 + 1;
                this.featEndLength = REPLACE1_END_LENGTH;
                this.featEnd = REPLACE1_END;
                return n2;
            }
            n2 = string.indexOf(REPLACE2_START, n);
            if (n2 >= 0) {
                this.featStartLength = string.indexOf(62, n2 + REPLACE2_START_LENGTH) - n2 + 1;
                this.featEndLength = REPLACE2_END_LENGTH;
                this.featEnd = REPLACE2_END;
                return n2;
            }
            n2 = string.indexOf(DELETE_START, n);
            if (n2 >= 0) {
                this.featStartLength = string.indexOf(62, n2 + DELETE_START_LENGTH) - n2 + 1;
                this.featEndLength = DELETE_END_LENGTH;
                this.featEnd = DELETE_END;
                return n2;
            }
        } else if (this.operation == 96008) {
            return string.indexOf(RESERVE_ERG_START, n);
        }
        return -1;
    }

    private void readNasReserveFile(File file) throws IFileInputException {
        try {
            this.reader = this.createReader();
        }
        catch (Exception exception) {
            throw new IFileInputException(exception.getMessage());
        }
        try {
            long l = 0L;
            String string = null;
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer(65536);
            while ((string = this.reader.readLine()) != null) {
                l += (long)(string.length() + 1);
                string = string.trim();
                if (!bl) {
                    var7_8 = this.indexOfFeatureStart(string, 0);
                    if (var7_8 >= 0) {
                        var8_9 = string.indexOf(this.featEnd, var7_8);
                        if (var8_9 < 0) {
                            stringBuffer.append(string.substring(var7_8));
                            bl = true;
                        } else {
                            bl = this.processLine(string, false, var7_8, stringBuffer);
                        }
                    }
                } else {
                    var7_8 = string.indexOf(RESERVE_ERG_END);
                    if (var7_8 >= 0) {
                        stringBuffer.append(string.substring(0, var7_8 + RESERVE_ERG_END_LENGTH));
                        this.doParse(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        bl = false;
                        var8_9 = this.indexOfFeatureStart(string, var7_8);
                        if (var8_9 > var7_8) {
                            bl = this.processLine(string, false, var8_9, stringBuffer);
                        }
                    } else {
                        stringBuffer.append(" ");
                        stringBuffer.append(string);
                    }
                }
                super.setFileProgress(l);
            }
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception exception) {
            this.addException(new Exception("Lesefehler: " + exception.getMessage()));
            exception.printStackTrace();
            return;
        }
    }

    private void readNasFile(File file) throws IFileInputException {
        boolean bl = false;
        boolean bl2 = this.operation == 960122 || this.operation == 96001;
        try {
            this.reader = this.createReader();
        }
        catch (Exception exception) {
            throw new IFileInputException(exception.getMessage());
        }
        try {
            int n = 0;
            long l = 0L;
            String string = null;
            boolean bl3 = false;
            int n2 = WFS_NORMAL;
            StringBuffer stringBuffer = new StringBuffer(65536);
            while ((string = this.reader.readLine()) != null && !this.abort) {
                ++n;
                l += (long)(string.length() + 1);
                string = string.trim();
                if (!bl3) {
                    var11_14 = this.indexOfFeatureStart(string, 0);
                    if (var11_14 >= 0) {
                        n2 = WFS_NORMAL;
                        if (bl2) {
                            String string2 = string.substring(var11_14);
                            if (string2.startsWith(REPLACE1_START)) {
                                stringBuffer.append(WFS_REPLACE);
                            } else if (string2.startsWith(REPLACE2_START)) {
                                stringBuffer.append(WFS_REPLACE);
                            } else if (string2.startsWith(INSERT_START)) {
                                stringBuffer.append(WFS_INSERT);
                            } else if (string2.startsWith(DELETE_START)) {
                                stringBuffer.append(WFS_DELETE);
                            }
                        }
                        if ((var12_16 = string.indexOf(this.featEnd, var11_14 += this.featStartLength)) < 0) {
                            stringBuffer.append(string.substring(var11_14));
                            bl3 = true;
                        } else {
                            bl3 = this.processLine(string, false, var11_14 - this.featStartLength, stringBuffer);
                        }
                    }
                } else {
                    var11_14 = string.indexOf(this.featEnd);
                    if (var11_14 >= 0) {
                        stringBuffer.append(string.substring(0, var11_14));
                        this.doParse(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        bl3 = false;
                        var12_16 = this.indexOfFeatureStart(string, var11_14 + this.featEndLength);
                        if (var12_16 > var11_14) {
                            bl3 = this.processLine(string, false, var12_16, stringBuffer);
                        }
                    } else {
                        stringBuffer.append(string);
                    }
                }
                if (n % 100000 == 0) {
                    long l2 = this.runTime.maxMemory() / 1024L / 1024L;
                    long l3 = this.runTime.totalMemory() / 1024L / 1024L;
                    long l4 = this.runTime.freeMemory() / 1024L / 1024L;
                    double d = (int)((double)l4 / (double)l2 * 100.0);
                    if (l2 == l3 && d < 5.0) {
                        if (KafPlot.debug()) {
                            System.out.println("NasReader.freeMemory: " + l4 + "(" + d + "% max:" + l2 + " tot:" + l3);
                        }
                        this.setProgressState(2);
                        for (int i = 0; i < this.threadCount; ++i) {
                            this.parsers[i].setPriority(1);
                        }
                        if (l4 < 10L) {
                            bl = true;
                            this.kill();
                            break;
                        }
                    }
                }
                super.setFileProgress(l);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (KafPlot.debug()) {
                System.out.println("NasReader: OutOfMemory");
            }
            bl = true;
            this.kill();
        }
        catch (Exception exception) {
            this.addException(new Exception("Lesefehler: " + exception.getMessage()));
            exception.printStackTrace();
        }
        this.workThreads();
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl) {
            throw new IFileInputException("Abbruch wegen Speichermangel!\nErh\u00f6hen Sie den JavaVM-Startparameter -Xmx");
        }
    }

    private void kill() {
        block4: {
            this.abort = true;
            if (KafPlot.debug()) {
                System.out.println("NasReader.kill");
            }
            boolean bl = this.killThreads();
            this.clearInternals();
            this.linkExceptions.clear();
            this.updateMessages.clear();
            super.clearExceptionList();
            Alkis.killModelHash();
            PunktParameter.killHash();
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (Exception exception) {
                    if (!bl) break block4;
                    bl = false;
                }
            }
        }
        System.gc();
    }

    @Override
    public void userAbort() throws IFileInputException {
        this.abort = true;
        if (KafPlot.debug()) {
            System.out.println("NasReader: Abbruch auf Nutzeranforderung");
        }
        this.kill();
    }

    @Override
    public boolean isAborted() {
        return this.abort;
    }

    protected void computeData() {
        Object object;
        this.setProgress(25);
        if (!this.updateMode) {
            this.computeKatalog();
        }
        this.setProgress(30);
        this.computePunktOrte();
        this.setProgress(50);
        this.computeObjektOrte();
        this.setProgress(55);
        this.computeTextOrte();
        this.setProgress(60);
        this.computePersonen();
        this.setProgress(65);
        this.computeNamen();
        this.setProgress(70);
        this.computeBuchung();
        this.setProgress(80);
        if (this.updateMode) {
            object = new FlurstueckTable();
            GrundbuchTable grundbuchTable = new GrundbuchTable();
            this.computeObjekte((FlurstueckTable)object, null, null, null, null, grundbuchTable);
            this.setProgress(60);
            this.mergeFlurstuecke((FlurstueckTable)object, grundbuchTable);
            this.setProgress(70);
            this.addException(new Exception("Updatemodus: grafische Objekte und Sachdaten werden NICHT aktualisiert!"));
        } else {
            this.computeObjekte(DataBase.FLST, DataBase.GEB, DataBase.TOP, DataBase.NUTZ, DataBase.BODEN, DataBase.BUCH);
            this.setProgress(60);
            this.computeKatalog();
            this.setProgress(70);
        }
        if (DataBase.katasterAmt == null && this.amtFeatureCount == 1 && (object = KatAmt.getKatAmt(this.currentAmtKey)) != null) {
            DataBase.katasterAmt = ((KatAmt)object).getName();
        }
        this.setProgress(95);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processLine(String string, boolean bl, int n, StringBuffer stringBuffer) {
        if (!bl) {
            if ((n = string.indexOf(this.FEATURE_START, n)) >= 0) {
                int n2 = string.indexOf(this.FEATURE_END, n += this.FEATURE_START_LENGTH);
                if (n2 < 0) {
                    stringBuffer.append(string.substring(n));
                    return true;
                }
                this.doParse(string.substring(n, n2));
                n = n2 + this.FEATURE_END_LENGTH;
                this.processLine(string, false, n, stringBuffer);
            }
        } else {
            int n3 = string.indexOf(this.FEATURE_END, n);
            if (n3 >= 0) {
                stringBuffer.append(string.substring(0, n3));
                this.doParse(stringBuffer.toString());
                stringBuffer.setLength(0);
                n = string.indexOf(this.FEATURE_START, n3 + this.FEATURE_END_LENGTH);
                if (n >= 0) {
                    this.processLine(string, false, n, stringBuffer);
                }
            } else {
                stringBuffer.append(string);
            }
        }
        if (stringBuffer.length() == 0) return false;
        return true;
    }

    protected void parseFeature(String string) {
        try {
            int n = WFS_NORMAL;
            if (Character.isDigit(string.charAt(0))) {
                n = Integer.parseInt(string.substring(0, 1));
                string = string.substring(1);
            }
            XMLElement xMLElement = new XMLElement();
            xMLElement.parseString(string);
            String string2 = xMLElement.getUName();
            String string3 = xMLElement.getStringAttribute("gml:id");
            if (n != WFS_NORMAL && string3 != null) {
                string3 = string3.substring(0, 16);
            }
            int n2 = Alkis.getOska(string2);
            switch (n2) {
                case 2350: {
                    break;
                }
                case 2310: 
                case 2320: {
                    this.oPrae.addElement(new ObjektOrt(this, n2, xMLElement));
                    break;
                }
                case 2342: {
                    break;
                }
                case 2300: 
                case 2330: 
                case 2340: 
                case 2341: {
                    this.oOrte.addElement(new ObjektOrt(this, n2, xMLElement));
                    break;
                }
                case 14002: 
                case 14003: 
                case 14004: {
                    this.pOrte.addElement(this.parsePunktort(n2, xMLElement));
                    break;
                }
                case 14005: {
                    break;
                }
                case 15001: 
                case 15002: 
                case 15004: 
                case 15005: 
                case 16001: 
                case 16002: 
                case 16003: 
                case 16004: 
                case 17001: 
                case 17002: 
                case 17003: 
                case 17004: {
                    break;
                }
                case 11001: {
                    this.objekte.put(string3, this.parseFlurstueck(xMLElement));
                    break;
                }
                case 11002: {
                    break;
                }
                case 11003: {
                    this.punkte.put(string3, this.parsePunkt(xMLElement, n2));
                    break;
                }
                case 12006: {
                    break;
                }
                case 12001: 
                case 12002: 
                case 12003: 
                case 12004: 
                case 12005: {
                    this.objekte.put(string3, this.parseLagebezeichnung(xMLElement));
                    break;
                }
                case 12007: {
                    break;
                }
                case 13001: {
                    this.punkte.put(string3, this.parsePunkt(xMLElement, n2));
                    break;
                }
                case 13002: {
                    this.punkte.put(string3, this.parsePunkt(xMLElement, n2));
                    break;
                }
                case 13003: {
                    this.punkte.put(string3, this.parsePunkt(xMLElement, n2));
                    break;
                }
                case 13004: {
                    break;
                }
                case 21001: {
                    this.personen.put(string3, this.parsePerson(xMLElement));
                    break;
                }
                case 21002: {
                    break;
                }
                case 21003: {
                    this.anschriften.put(string3, this.parseAnschrift(xMLElement));
                    break;
                }
                case 21004: {
                    break;
                }
                case 21005: {
                    this.vertretungen.put(string3, this.parseVertretung(xMLElement));
                    break;
                }
                case 21006: {
                    this.namen.put(string3, this.parseNamensnummer(xMLElement));
                    break;
                }
                case 21007: {
                    this.objekte.put(string3, this.parseBuchungsblatt(xMLElement));
                    break;
                }
                case 21008: {
                    this.stellen.put(string3, this.parseBuchungsstelle(xMLElement));
                    break;
                }
                case 21009: {
                    break;
                }
                case 31001: {
                    this.objekte.put(string3, this.parseGebaeude(xMLElement));
                    break;
                }
                case 91001: {
                    break;
                }
                case 31002: {
                    this.objekte.put(string3, this.parseBauteil(xMLElement));
                    break;
                }
                case 31003: {
                    break;
                }
                case 31004: {
                    break;
                }
                case 31005: {
                    this.punkte.put(string3, this.parsePunkt(xMLElement, n2));
                    break;
                }
                case 41001: 
                case 41002: 
                case 41003: 
                case 41004: 
                case 41005: 
                case 41006: 
                case 41007: 
                case 41008: 
                case 41009: 
                case 42001: 
                case 42006: 
                case 42009: 
                case 42010: 
                case 42015: 
                case 42016: 
                case 43001: 
                case 43002: 
                case 43003: 
                case 43004: 
                case 43005: 
                case 43006: 
                case 43007: 
                case 44001: 
                case 44005: 
                case 44006: 
                case 44007: {
                    this.objekte.put(string3, this.parseNutzung(xMLElement, n2));
                    break;
                }
                case 51001: 
                case 51002: 
                case 51003: {
                    this.objekte.put(string3, this.parseTopografie(xMLElement, n2));
                    break;
                }
                case 51004: 
                case 51005: 
                case 51006: 
                case 51007: 
                case 51008: 
                case 51009: 
                case 51010: {
                    if (NasIOProperties.readTopo()) {
                        this.objekte.put(string3, this.parseTopografie(xMLElement, n2));
                    }
                    break;
                }
                case 51011: {
                    this.punkte.put(string3, this.parsePunkt(xMLElement, n2));
                    break;
                }
                case 53001: 
                case 53002: 
                case 53003: 
                case 53004: 
                case 53005: 
                case 53006: 
                case 53007: 
                case 53008: 
                case 53009: 
                case 54001: 
                case 55001: 
                case 55002: 
                case 57001: 
                case 57002: {
                    if (NasIOProperties.readTopo()) {
                        this.objekte.put(string3, this.parseTopografie(xMLElement, n2));
                    }
                    break;
                }
                case 61001: 
                case 61002: 
                case 61003: 
                case 61005: 
                case 61006: 
                case 61007: {
                    if (NasIOProperties.readTopo()) {
                        this.objekte.put(string3, this.parseRelief(xMLElement, n2));
                    }
                    break;
                }
                case 61008: {
                    break;
                }
                case 61009: {
                    this.punkte.put(string3, this.parsePunkt(xMLElement, n2));
                    break;
                }
                case 62001: 
                case 62004: 
                case 62010: 
                case 62020: 
                case 62030: {
                    break;
                }
                case 62040: {
                    if (NasIOProperties.readTopo()) {
                        this.objekte.put(string3, this.parseRelief(xMLElement, n2));
                    }
                    break;
                }
                case 62070: 
                case 62090: 
                case 71001: 
                case 71002: 
                case 71003: 
                case 71004: 
                case 71005: 
                case 71006: 
                case 71007: 
                case 71008: 
                case 71009: 
                case 71010: 
                case 71011: 
                case 71012: {
                    break;
                }
                case 72001: {
                    if (NasIOProperties.readBoden()) {
                        this.objekte.put(string3, this.parseBodenSchaetzung(xMLElement, n2));
                    }
                    break;
                }
                case 72002: 
                case 72003: 
                case 72004: 
                case 72005: 
                case 72006: 
                case 73002: 
                case 73003: 
                case 73004: {
                    break;
                }
                case 73005: {
                    this.gemeinden.put(this.parseGemeinde(xMLElement));
                    break;
                }
                case 73006: {
                    break;
                }
                case 73007: {
                    this.gemarkungen.put(this.parseGemarkung(xMLElement));
                    break;
                }
                case 73008: 
                case 73009: 
                case 73010: {
                    break;
                }
                case 73011: {
                    this.parseDienststelle(xMLElement);
                    break;
                }
                case 73012: {
                    break;
                }
                case 73013: {
                    this.strassen.addElement(this.parseLagebezeichnungKatalogeintrag(xMLElement));
                    break;
                }
                case 73014: 
                case 73015: 
                case 73016: 
                case 73017: 
                case 73018: 
                case 73019: 
                case 73020: 
                case 73021: 
                case 73022: 
                case 73023: 
                case 73024: 
                case 74001: 
                case 74002: 
                case 74005: 
                case 75001: 
                case 75002: 
                case 75003: 
                case 75010: 
                case 91002: {
                    break;
                }
                case 96008: {
                    this.parseReservierung(xMLElement);
                    break;
                }
                case 19001: 
                case 19002: 
                case 19003: 
                case 19004: {
                    this.punkte.put(string3, this.parsePunkt(xMLElement, n2));
                    break;
                }
                case 19005: {
                    break;
                }
                case 100000: {
                    this.parseFilterOp(xMLElement, n);
                    break;
                }
                default: {
                    this.addException(new Exception("Nicht abgefangenes Feature: " + string2));
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.addException(exception);
        }
    }

    private void parseFilterOp(XMLElement xMLElement, int n) {
        if (n == WFS_DELETE) {
            Enumeration enumeration = xMLElement.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                String string;
                XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
                String string2 = xMLElement2.getName();
                if (string2.equals("fes:ResourceId")) {
                    string = xMLElement2.getStringAttribute("rid");
                    if (string == null) continue;
                    this.deletes.addElement(string.substring(0, 16));
                    continue;
                }
                if (string2.equals("ogc:FeatureId")) {
                    string = xMLElement2.getStringAttribute("fid");
                    if (string == null) continue;
                    this.deletes.addElement(string.substring(0, 16));
                    continue;
                }
                this.addModelException();
            }
        }
    }

    private void parseDienststelle(XMLElement xMLElement) {
        int n = 0;
        int n2 = 0;
        Object object = xMLElement.enumerateChildren();
        while (object.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)object.nextElement();
            String string = xMLElement2.getUName();
            try {
                if (string.equals("stellenart")) {
                    n = Integer.parseInt(xMLElement2.getContent());
                    continue;
                }
                if (string.equals("schluesselGesamt")) {
                    n2 = Integer.parseInt(xMLElement2.getContent());
                    continue;
                }
                if (!string.equals("schluessel")) continue;
                n2 = this.parseDienststelleSchluessel(xMLElement2.getChildrenAt(0));
            }
            catch (Exception exception) {
                this.addException(new Exception("Dienststellenschl\u00fcssel " + xMLElement2.getContent() + " ist nicht numerisch"));
            }
        }
        if (n == 1100 && n2 > 0) {
            object = KatAmt.getKatAmt(n2);
            if (DataBase.katasterAmt == null && n2 % 100 == this.amtFileKennung && object != null) {
                DataBase.katasterAmt = ((KatAmt)object).getName();
            }
            this.currentAmtKey = n2;
            ++this.amtFeatureCount;
        }
    }

    private void parseReservierung(XMLElement xMLElement) {
        int n = 0;
        SortableVector sortableVector = new SortableVector();
        XMLElement xMLElement2 = xMLElement.getUChildren("art");
        if (xMLElement2 != null) {
            n = Integer.parseInt(xMLElement2.getContent());
        }
        if (n >= 3000) {
            return;
        }
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement3 = (XMLElement)enumeration.nextElement();
            String string = xMLElement3.getUName();
            try {
                if (!string.equals("reservierteNummern")) continue;
                sortableVector.addElement(new Long(xMLElement3.getContent()));
            }
            catch (NumberFormatException numberFormatException) {
                this.addException(new Exception("Reservierung " + xMLElement3.getContent() + " ist nicht numerisch"));
            }
        }
        if (sortableVector.size() == 0) {
            return;
        }
        sortableVector.sort(new LongComparator());
        long l = 0L;
        long l2 = 0L;
        Enumeration enumeration2 = sortableVector.elements();
        while (enumeration2.hasMoreElements()) {
            long l3 = (Long)enumeration2.nextElement() % 100000000000000L;
            if (l3 >= this.nrRed) {
                l3 -= this.nrRed;
            }
            if (l == 0L) {
                l = l3;
                l2 = l3;
                continue;
            }
            if (l3 == l2 + 1L) {
                l2 = l3;
                continue;
            }
            int n2 = (int)(l / 1000000L);
            try {
                DataBase.NB.addElement(new NummerierungsBezirk(n2, l % 1000000L, l2 % 1000000L));
                l = l3;
                l2 = l3;
            }
            catch (Exception exception) {
                this.addException(exception);
            }
        }
        if (l != 0L && l2 != 0L) {
            try {
                int n3 = (int)(l / 1000000L);
                DataBase.NB.addElement(new NummerierungsBezirk(n3, l % 1000000L, l2 % 1000000L));
            }
            catch (Exception exception) {
                this.addException(exception);
            }
        }
    }

    protected final Punkt parsePunkt(XMLElement xMLElement, int n) {
        Punkt punkt = new Punkt();
        PunktParameterALKIS punktParameterALKIS = this.readPunktExtends ? new PunktParameterALKISExt() : new PunktParameterALKIS();
        AA_Objekt aA_Objekt = null;
        if (this.readPunktExtends) {
            PunktParameterALKIS punktParameterALKIS2 = punktParameterALKIS;
            ((PunktParameterALKISExt)punktParameterALKIS2).setPunktArt(n);
            aA_Objekt = new AA_Objekt();
            ((PunktParameterALKISExt)punktParameterALKIS2).setPunktObjektAttributes(aA_Objekt);
        }
        boolean bl = true;
        switch (n) {
            case 11003: {
                punktParameterALKIS.setPa(20);
                break;
            }
            case 31005: {
                punktParameterALKIS.setPa(30);
                break;
            }
            case 51011: {
                punktParameterALKIS.setPa(40);
                break;
            }
            case 61009: {
                punktParameterALKIS.setPa(50);
                break;
            }
            case 13001: {
                punktParameterALKIS.setPa(10);
                break;
            }
            case 13002: {
                punktParameterALKIS.setPa(11);
                break;
            }
            case 13003: {
                punktParameterALKIS.setPa(60);
                break;
            }
            case 19001: {
                punktParameterALKIS.setPa(71);
                bl = false;
                break;
            }
            case 19002: {
                punktParameterALKIS.setPa(72);
                bl = false;
                break;
            }
            case 19003: {
                punktParameterALKIS.setPa(73);
                bl = false;
                break;
            }
            case 19004: {
                punktParameterALKIS.setPa(74);
                bl = false;
            }
        }
        String string = null;
        int n2 = 0;
        Enumeration enumeration = xMLElement.enumerateChildren();
        block38: while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            Integer n3 = attributes.get(xMLElement2.getUName());
            if (n3 == null) {
                this.addModelException();
                continue;
            }
            switch (n3) {
                case 1010: {
                    String string2;
                    try {
                        string2 = xMLElement2.getContent();
                        if (n == 61009) {
                            if (string2.startsWith("v") || string2.startsWith("V")) {
                                punktParameterALKIS.setPa(90);
                                string2 = string2.substring(1).trim();
                            } else if (string2.startsWith("9999999999")) {
                                punktParameterALKIS.setPa(90);
                                string2 = this.readPunktExtends ? string2.trim() : string2.substring(10).trim();
                            }
                        }
                        punkt.nr = Long.parseLong(string2);
                    }
                    catch (Exception exception) {
                        punkt.addTag(Tag.toString("PKN", xMLElement2.getContent()));
                        this.addModelException();
                    }
                    continue block38;
                }
                case 1011: {
                    if (n == 13003) {
                        if (!this.readPunktExtends) continue block38;
                        ((PunktParameterALKISExt)punktParameterALKIS).setVpArt(xMLElement2.getContent());
                        continue block38;
                    }
                    try {
                        punktParameterALKIS.setArt(Integer.parseInt(xMLElement2.getContent()));
                    }
                    catch (Exception exception) {
                        this.addModelException();
                    }
                    continue block38;
                }
                case 1012: 
                case 1013: 
                case 1016: {
                    punktParameterALKIS.setVa(Integer.parseInt(xMLElement2.getContent()));
                    continue block38;
                }
                case 1014: {
                    punktParameterALKIS.setVb(Integer.parseInt(xMLElement2.getContent()));
                    continue block38;
                }
                case 1015: {
                    String string2 = xMLElement2.getContent();
                    if (this.readPunktExtends) {
                        ((PunktParameterALKISExt)punktParameterALKIS).addSoe(string2);
                    }
                    if (string2.startsWith("ENT:") && n2 <= 0) {
                        string = string2.substring(4).trim();
                        n2 = 0;
                        continue block38;
                    }
                    if (string2.startsWith("ENT-G:") && n2 <= 1) {
                        string = string2.substring(6).trim();
                        n2 = 1;
                        continue block38;
                    }
                    if (!string2.startsWith("ENT-R:")) continue block38;
                    string = string2.substring(6).trim();
                    n2 = 2;
                    continue block38;
                }
                case 1029: {
                    if (this.readPunktExtends) {
                        ((PunktParameterALKISExt)punktParameterALKIS).setZau(this.parseLink(xMLElement2));
                    }
                    punkt.addTag(Tag.toString("IND", this.parseLink(xMLElement2)));
                    punkt.setZeigtAufPoint(true);
                    continue block38;
                }
                case 1150: {
                    if (!this.readPunktExtends) continue block38;
                    aA_Objekt.setIdentifikator(this.parseOId(xMLElement2.getContent()));
                    continue block38;
                }
                case 1151: {
                    if (!this.readPunktExtends) continue block38;
                    aA_Objekt.setLebenszeitintervall(this.parseLebenszeitintervall(xMLElement2.getChildrenAt(0)));
                    continue block38;
                }
                case 1152: {
                    if (!this.readPunktExtends) continue block38;
                    aA_Objekt.addModellart(this.parseModellart(xMLElement2.getChildrenAt(0)));
                    continue block38;
                }
                case 1153: {
                    if (!this.readPunktExtends) continue block38;
                    aA_Objekt.addAnlass(this.parseAnlass(xMLElement2));
                    continue block38;
                }
                case 1154: {
                    if (!this.readPunktExtends) continue block38;
                    aA_Objekt.addZeigtAufExternes(this.parseFachdatenverbindung(xMLElement2.getChildrenAt(0)));
                    continue block38;
                }
                case 1002: {
                    if (!this.readPunktExtends) continue block38;
                    aA_Objekt.addIstTeilVon(this.parseLink(xMLElement2));
                    continue block38;
                }
                case 1093: {
                    this.addModelException();
                    continue block38;
                }
                case 1039: {
                    if (!this.readPunktExtends) continue block38;
                    ((PunktParameterALKISExt)punktParameterALKIS).setZst(this.parseDienststelleSchluessel(xMLElement2.getChildrenAt(0)));
                    continue block38;
                }
                case 1038: {
                    if (!this.readPunktExtends) continue block38;
                    ((PunktParameterALKISExt)punktParameterALKIS).setZde(xMLElement2.getContent());
                    continue block38;
                }
                case 1059: {
                    if (!this.readPunktExtends) continue block38;
                    ((PunktParameterALKISExt)punktParameterALKIS).addHat(this.parseLink(xMLElement2));
                    continue block38;
                }
                case 1155: {
                    if (!this.readPunktExtends) continue block38;
                    ((PunktParameterALKISExt)punktParameterALKIS).setGzu(this.parseLink(xMLElement2));
                    continue block38;
                }
                case 1156: {
                    if (!this.readPunktExtends) continue block38;
                    ((PunktParameterALKISExt)punktParameterALKIS).setBsa(this.parseLink(xMLElement2));
                    continue block38;
                }
                case 1157: {
                    if (!this.readPunktExtends) continue block38;
                    ((PunktParameterALKISExt)punktParameterALKIS).addMit(this.parseLink(xMLElement2));
                    continue block38;
                }
            }
            this.addModelException();
        }
        if (string != null) {
            punkt.addTag(Tag.toString("ENT", this.reformatRiss(string, n2)));
        }
        punkt.initParameter(punktParameterALKIS);
        return punkt;
    }

    private String reformatRiss(String string, int n) {
        if (n == 2) {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
            int n2 = 0;
            boolean bl = false;
            while (stringTokenizer.hasMoreElements()) {
                String string5 = stringTokenizer.nextToken();
                switch (n2) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        string2 = string5;
                        break;
                    }
                    case 2: {
                        string3 = string5;
                        break;
                    }
                    case 3: {
                        string4 = string5;
                        break;
                    }
                    case 4: {
                        bl = true;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                ++n2;
            }
            if (bl) {
                return string2 + "-" + IFormat.trimLeft(string3, '0') + "-" + IFormat.trimLeft(string4, '0');
            }
        } else if (n == 1) {
            String string6 = null;
            String string7 = null;
            String string8 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
            int n3 = 0;
            boolean bl = false;
            while (stringTokenizer.hasMoreElements()) {
                String string9 = stringTokenizer.nextToken();
                switch (n3) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        string6 = string9;
                        break;
                    }
                    case 2: {
                        string7 = string9;
                        break;
                    }
                    case 3: {
                        string8 = string9;
                        bl = true;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                ++n3;
            }
            if (bl) {
                return string6 + "-" + IFormat.trimLeft(string7, '0') + "/" + IFormat.trimLeft(string8, '0');
            }
        }
        return IFormat.removeMultiSpaces(string);
    }

    private Flurstueck parseFlurstueck(XMLElement xMLElement) throws Exception {
        Flurstueck flurstueck = new Flurstueck();
        flurstueck.setArt(700);
        flurstueck.setOska(11001);
        flurstueck.setFlur(0);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Enumeration enumeration = xMLElement.enumerateChildren();
        block17: while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getUName();
            Integer n6 = attributes.get(string);
            if (n6 == null) continue;
            switch (n6) {
                case 1020: {
                    String string2;
                    XMLElement xMLElement3;
                    int n7 = 0;
                    int n8 = 0;
                    Enumeration enumeration2 = xMLElement2.getChildrenAt(0).enumerateChildren();
                    while (enumeration2.hasMoreElements()) {
                        xMLElement3 = (XMLElement)enumeration2.nextElement();
                        string2 = xMLElement3.getUName();
                        if (string2.equals("land")) {
                            n7 = Integer.parseInt(xMLElement3.getContent());
                            continue;
                        }
                        if (!string2.equals("gemarkungsnummer")) continue;
                        n8 = Integer.parseInt(xMLElement3.getContent());
                    }
                    flurstueck.setGemarkung(n7 * 10000 + n8);
                    break;
                }
                case 1023: {
                    String string2;
                    XMLElement xMLElement3;
                    flurstueck.setNenner(0);
                    Enumeration enumeration2 = xMLElement2.getChildrenAt(0).enumerateChildren();
                    while (enumeration2.hasMoreElements()) {
                        xMLElement3 = (XMLElement)enumeration2.nextElement();
                        string2 = xMLElement3.getUName();
                        if (string2.equals("zaehler")) {
                            flurstueck.setZaehler(Integer.parseInt(xMLElement3.getContent()));
                            continue;
                        }
                        if (!string2.equals("nenner")) continue;
                        flurstueck.setNenner(Integer.parseInt(xMLElement3.getContent()));
                    }
                    continue block17;
                }
                case 1026: {
                    flurstueck.setFlur(Integer.parseInt(xMLElement2.getContent()));
                    break;
                }
                case 1027: {
                    flurstueck.setGemeinde(this.parseGemeindeKennzeichen(xMLElement2.getChildrenAt(0)));
                    break;
                }
                case 1028: {
                    flurstueck.addAttribute(this.createLinkAtt(string), this.parseLink(xMLElement2));
                    break;
                }
                case 1029: {
                    flurstueck.addAttribute(this.createLinkAtt(string, n++), this.parseLink(xMLElement2));
                    break;
                }
                case 1030: {
                    flurstueck.addAttribute(this.createLinkAtt(string, n2++), this.parseLink(xMLElement2));
                    break;
                }
                case 1031: {
                    flurstueck.addAttribute(this.createLinkAtt(string, n3++), this.parseLink(xMLElement2));
                    break;
                }
                case 1032: {
                    flurstueck.addAttribute(this.createLinkAtt(string, n4++), this.parseLink(xMLElement2));
                    break;
                }
                case 1033: 
                case 1034: 
                case 1035: 
                case 1036: {
                    flurstueck.addAttribute(string, xMLElement2.getContent());
                    break;
                }
                case 1037: {
                    flurstueck.addAttribute(this.createAtt(string, n5++), xMLElement2.getContent());
                    break;
                }
                case 1038: {
                    flurstueck.addAttribute(string, IFormat.parseDateToDE(xMLElement2.getContent()));
                    break;
                }
                case 1039: {
                    flurstueck.addAttribute(string, Integer.toString(this.parseDienststelleSchluessel(xMLElement2.getChildrenAt(0))));
                    break;
                }
                case 1040: {
                    flurstueck.setBuchFlaeche(Double.parseDouble(xMLElement2.getContent()));
                    flurstueck.setFlaecheRead(true);
                    break;
                }
                case 1001: {
                    this.parseGeom(xMLElement2, flurstueck);
                }
            }
        }
        flurstueck.packMemory();
        return flurstueck;
    }

    private int parseDienststelleSchluessel(XMLElement xMLElement) throws NumberFormatException {
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getContent();
            String string2 = xMLElement2.getUName();
            if (string2.equals("land")) {
                n = Integer.parseInt(string);
                continue;
            }
            if (!string2.equals("stelle")) continue;
            try {
                n2 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                if ((string = IFormat.getNumbers(string)).length() <= 0) continue;
                n2 = Integer.parseInt(string);
            }
        }
        return n * 10000 + n2;
    }

    private Gebaeude parseGebaeude(XMLElement xMLElement) throws Exception {
        Gebaeude gebaeude = new Gebaeude();
        gebaeude.setOska(31001);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getUName();
            Integer n5 = attributes.get(string);
            if (n5 == null) continue;
            switch (n5) {
                case 1041: {
                    gebaeude.setFunktion(Integer.parseInt(xMLElement2.getContent()));
                    break;
                }
                case 1056: {
                    gebaeude.addAttribute(this.createAtt(string, n2++), xMLElement2.getContent());
                    break;
                }
                case 1057: {
                    gebaeude.addAttribute(this.createAtt(string, n3++), xMLElement2.getContent());
                    break;
                }
                case 1058: {
                    gebaeude.addAttribute(this.createAtt(string, n4++), xMLElement2.getContent());
                    break;
                }
                case 1059: {
                    gebaeude.addAttribute(this.createLinkAtt(string), this.parseLink(xMLElement2));
                    break;
                }
                case 1029: {
                    gebaeude.addAttribute(this.createLinkAtt(string, n++), this.parseLink(xMLElement2));
                    break;
                }
                case 1042: 
                case 1043: 
                case 1044: 
                case 1045: 
                case 1046: 
                case 1047: 
                case 1048: 
                case 1049: 
                case 1050: 
                case 1051: 
                case 1052: 
                case 1053: 
                case 1054: 
                case 1055: {
                    gebaeude.addAttribute(string, xMLElement2.getContent());
                    break;
                }
                case 1001: {
                    this.parseGeom(xMLElement2, gebaeude);
                }
            }
        }
        gebaeude.packMemory();
        return gebaeude;
    }

    private Gebaeude parseBauteil(XMLElement xMLElement) throws Exception {
        Gebaeude gebaeude = new Gebaeude();
        gebaeude.setOska(31002);
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getUName();
            Integer n = attributes.get(string);
            if (n == null) continue;
            switch (n) {
                case 1001: {
                    this.parseGeom(xMLElement2, gebaeude);
                    break;
                }
                case 1043: 
                case 1045: 
                case 1052: 
                case 1053: 
                case 1134: 
                case 1135: {
                    gebaeude.addAttribute(string, xMLElement2.getContent());
                }
            }
        }
        gebaeude.packMemory();
        return gebaeude;
    }

    private TopObject parseTopografie(XMLElement xMLElement, int n) throws Exception {
        TopObject topObject = new TopObject();
        topObject.setOska(n);
        int n2 = 0;
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getUName();
            Integer n3 = attributes.get(string);
            if (n3 == null) continue;
            switch (n3) {
                case 1001: {
                    this.parseGeom(xMLElement2, topObject);
                    break;
                }
                case 1029: {
                    topObject.addAttribute(this.createLinkAtt(string, n2++), this.parseLink(xMLElement2));
                    break;
                }
                case 1011: 
                case 1042: 
                case 1048: 
                case 1053: 
                case 1057: 
                case 1062: 
                case 1069: 
                case 1072: 
                case 1136: 
                case 1137: 
                case 1138: 
                case 1139: 
                case 1140: 
                case 1141: 
                case 1142: 
                case 1143: 
                case 1144: 
                case 1145: 
                case 1146: 
                case 1147: {
                    topObject.addAttribute(string, xMLElement2.getContent());
                }
            }
        }
        topObject.packMemory();
        return topObject;
    }

    private TopObject parseRelief(XMLElement xMLElement, int n) throws Exception {
        TopObject topObject = new TopObject();
        topObject.setOska(n);
        int n2 = 0;
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getUName();
            Integer n3 = attributes.get(string);
            if (n3 == null) continue;
            switch (n3) {
                case 1001: {
                    this.parseGeom(xMLElement2, topObject);
                    break;
                }
                case 1002: {
                    topObject.addAttribute(this.createLinkAtt(string, n2++), this.parseLink(xMLElement2));
                    break;
                }
                case 1011: 
                case 1048: 
                case 1057: 
                case 1062: 
                case 1136: 
                case 1148: {
                    topObject.addAttribute(string, xMLElement2.getContent());
                }
            }
        }
        topObject.packMemory();
        return topObject;
    }

    private Nutzung parseNutzung(XMLElement xMLElement, int n) throws Exception {
        Nutzung nutzung = new Nutzung();
        nutzung.setOska(n);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getUName();
            Integer n6 = attributes.get(string);
            if (n6 == null) continue;
            switch (n6) {
                case 1062: 
                case 1071: {
                    n2 = Integer.parseInt(xMLElement2.getContent());
                    nutzung.addAttribute(string, n2);
                    break;
                }
                case 1011: 
                case 1058: 
                case 1061: 
                case 1063: 
                case 1064: 
                case 1065: 
                case 1067: 
                case 1072: {
                    n3 = Integer.parseInt(xMLElement2.getContent());
                    nutzung.addAttribute(string, n3);
                    break;
                }
                case 1048: {
                    n4 = Integer.parseInt(xMLElement2.getContent());
                    nutzung.addAttribute(string, n4);
                    break;
                }
                case 1069: {
                    nutzung.addAttribute(this.createAtt(string, n5++), xMLElement2.getContent());
                    break;
                }
                case 1060: {
                    nutzung.addAttribute(string, IFormat.parseDateToDE(xMLElement2.getContent()));
                    break;
                }
                case 1057: 
                case 1066: 
                case 1068: 
                case 1070: 
                case 1073: 
                case 1074: 
                case 1075: {
                    nutzung.addAttribute(string, xMLElement2.getContent());
                    break;
                }
                case 1001: {
                    this.parseGeom(xMLElement2, nutzung);
                }
            }
        }
        nutzung.setArt(Alkis.createNutzungsart(n, n2, n3, n4));
        nutzung.packMemory();
        return nutzung;
    }

    private BodenSchaetzung parseBodenSchaetzung(XMLElement xMLElement, int n) throws Exception {
        BodenSchaetzung bodenSchaetzung = new BodenSchaetzung();
        bodenSchaetzung.setOska(n);
        int n2 = 0;
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getUName();
            Integer n3 = attributes.get(string);
            if (n3 == null) continue;
            switch (n3) {
                case 1076: {
                    bodenSchaetzung.setKulturArt(Integer.parseInt(xMLElement2.getContent()));
                    break;
                }
                case 1162: {
                    bodenSchaetzung.setKulturArt(Integer.parseInt(xMLElement2.getContent()));
                    break;
                }
                case 1077: {
                    bodenSchaetzung.setBodenArt(Integer.parseInt(xMLElement2.getContent()));
                    break;
                }
                case 1078: {
                    bodenSchaetzung.setStufe(Integer.parseInt(xMLElement2.getContent()));
                    break;
                }
                case 1163: {
                    bodenSchaetzung.setStufe(Integer.parseInt(xMLElement2.getContent()));
                    break;
                }
                case 1164: {
                    bodenSchaetzung.setStufe(Integer.parseInt(xMLElement2.getContent()));
                    break;
                }
                case 1079: {
                    bodenSchaetzung.setBodenZahl(xMLElement2.getContent());
                    break;
                }
                case 1080: {
                    bodenSchaetzung.setWertZahl(xMLElement2.getContent());
                    break;
                }
                case 1081: {
                    bodenSchaetzung.addAttribute(this.createAtt(string, n2++), xMLElement2.getContent());
                    break;
                }
                case 1082: {
                    bodenSchaetzung.addAttribute(string, xMLElement2.getContent());
                    break;
                }
                case 1083: {
                    int n4 = Integer.parseInt(xMLElement2.getContent());
                    if (n4 < 6000) {
                        bodenSchaetzung.setEntstehungsArt(n4);
                        break;
                    }
                    if (n4 < 7000) {
                        bodenSchaetzung.setKlimaStufe(n4);
                        break;
                    }
                    bodenSchaetzung.setWasserStufe(n4);
                    break;
                }
                case 1165: {
                    bodenSchaetzung.setEntstehungsArt(Integer.parseInt(xMLElement2.getContent()));
                    break;
                }
                case 1166: {
                    bodenSchaetzung.setKlimaStufe(Integer.parseInt(xMLElement2.getContent()));
                    break;
                }
                case 1167: {
                    bodenSchaetzung.setWasserStufe(Integer.parseInt(xMLElement2.getContent()));
                    break;
                }
                case 1001: {
                    this.parseGeom(xMLElement2, bodenSchaetzung);
                }
            }
        }
        bodenSchaetzung.packMemory();
        return bodenSchaetzung;
    }

    private Lage parseLagebezeichnung(XMLElement xMLElement) throws Exception {
        Lage lage = new Lage();
        LageEntry lageEntry = null;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        Object object = null;
        Enumeration enumeration = xMLElement.enumerateChildren();
        block10: while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getUName();
            Integer n3 = attributes.get(string);
            if (n3 == null) continue;
            switch (n3) {
                case 1084: {
                    XMLElement xMLElement3 = xMLElement2.getChildrenAt(0);
                    Object object2 = xMLElement3.enumerateChildren();
                    while (object2.hasMoreElements()) {
                        XMLElement xMLElement4 = (XMLElement)object2.nextElement();
                        String string2 = xMLElement4.getUName();
                        if (string2.equals("unverschluesselt")) {
                            lage.setBezeichnung(xMLElement4.getContent());
                            continue;
                        }
                        if (!string2.equals("verschluesselt")) continue;
                        lageEntry = this.parseVerschluesselteLagebezeichnung(xMLElement4.getChildrenAt(0));
                    }
                    continue block10;
                }
                case 1086: {
                    bl = true;
                }
                case 1085: {
                    Object object2;
                    try {
                        int n4;
                        object2 = xMLElement2.getContent();
                        if (((String)object2).startsWith("P")) {
                            object2 = ((String)object2).substring(1);
                            bl2 = true;
                        }
                        if ((n4 = IFormat.indexOfNotNumber((String)object2)) < 0) {
                            n = Integer.parseInt((String)object2);
                            break;
                        }
                        if (n4 == 0) {
                            object = ((String)object2).trim();
                            break;
                        }
                        n = Integer.parseInt(((String)object2).substring(0, n4).trim());
                        object = ((String)object2).substring(n4).trim();
                    }
                    catch (Exception exception) {
                        this.addException(new Exception("Kann Hausnummer: " + xMLElement2.getContent() + " nicht interpretieren"));
                    }
                    break;
                }
                case 1087: {
                    Object object2 = xMLElement2.getContent();
                    try {
                        if (((String)object2).startsWith("P")) {
                            object2 = ((String)object2).substring(1);
                            bl2 = true;
                        }
                        n2 = Integer.parseInt((String)object2);
                        break;
                    }
                    catch (Exception exception) {
                        object = object != null ? (String)object + ", " + (String)object2 : object2;
                    }
                }
            }
        }
        if (lageEntry != null) {
            lageEntry.setHausNummer(n);
            lageEntry.setLfdNummer(n2);
            lageEntry.setAdressenZusatz((String)object);
            lageEntry.setPseudoNummer(bl2);
            if (bl && n2 == 0) {
                lageEntry.setPseudoNummer(true);
            }
            lage.addEntry(lageEntry);
        }
        return lage;
    }

    private LageEntry parseVerschluesselteLagebezeichnung(XMLElement xMLElement) throws Exception {
        LageEntry lageEntry = new LageEntry();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getUName();
            String string2 = xMLElement2.getContent();
            Integer n5 = attributes.get(string);
            if (n5 == null) continue;
            switch (n5) {
                case 1021: {
                    n = Integer.parseInt(string2);
                    break;
                }
                case 1088: {
                    n2 = Integer.parseInt(string2);
                    break;
                }
                case 1089: {
                    n3 = Integer.parseInt(string2);
                    break;
                }
                case 1090: {
                    n4 = Integer.parseInt(string2);
                    break;
                }
                case 1091: {
                    lageEntry.setStrasse(n * 1000000 + n2 * 100000 + n3 * 1000 + n4, string2);
                }
            }
        }
        return lageEntry;
    }

    private Grundbuchblatt parseBuchungsblatt(XMLElement xMLElement) throws Exception {
        Grundbuchblatt grundbuchblatt = new Grundbuchblatt();
        int n = 0;
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getUName();
            if (string.equals("buchungsblattkennzeichen")) {
                grundbuchblatt.setKennzeichen(xMLElement2.getContent());
                continue;
            }
            if (string.equals("blattart")) {
                grundbuchblatt.setArt(Integer.parseInt(xMLElement2.getContent()));
                continue;
            }
            if (!string.equals("bestehtAus")) continue;
            grundbuchblatt.setAttribute(this.createAtt(string, n++), xMLElement2.getContent());
        }
        return grundbuchblatt;
    }

    private AX_Buchungsstelle parseBuchungsstelle(XMLElement xMLElement) throws Exception {
        AX_Buchungsstelle aX_Buchungsstelle = new AX_Buchungsstelle(this);
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getUName();
            Integer n = attributes.get(string);
            if (n == null) continue;
            switch (n) {
                case 1094: {
                    aX_Buchungsstelle.buchungsart = Integer.parseInt(xMLElement2.getContent());
                    break;
                }
                case 1087: {
                    aX_Buchungsstelle.laufendeNummer = xMLElement2.getContent();
                    break;
                }
                case 1095: {
                    aX_Buchungsstelle.anteil = xMLElement2.getChildren("AX_Anteil/zaehler").getContent() + "/" + xMLElement2.getChildren("AX_Anteil/nenner").getContent();
                    break;
                }
                case 1096: {
                    aX_Buchungsstelle.nummerImAufteilungsplan = xMLElement2.getContent();
                    break;
                }
                case 1097: {
                    aX_Buchungsstelle.beschreibungDesSondereigentums = xMLElement2.getContent();
                    break;
                }
                case 1098: {
                    aX_Buchungsstelle.buchungstext = xMLElement2.getContent();
                    break;
                }
                case 1099: {
                    aX_Buchungsstelle.beschreibungDesUmfangsDerBuchung = xMLElement2.getContent();
                    break;
                }
                case 1100: {
                    aX_Buchungsstelle.istBestandteilVon = this.parseLink(xMLElement2);
                    break;
                }
                case 1133: {
                    aX_Buchungsstelle.an = aX_Buchungsstelle.an + DELIM + this.parseLink(xMLElement2);
                }
            }
        }
        return aX_Buchungsstelle;
    }

    private AX_Vertretung parseVertretung(XMLElement xMLElement) throws Exception {
        AX_Vertretung aX_Vertretung = new AX_Vertretung(this);
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getUName();
            Integer n = attributes.get(string);
            if (n == null) continue;
            switch (n) {
                case 1159: {
                    aX_Vertretung.vertritt.addElement(this.parseLink(xMLElement2));
                    break;
                }
                case 1160: {
                    aX_Vertretung.haengtAn = this.parseLink(xMLElement2);
                }
            }
        }
        return aX_Vertretung;
    }

    private Name parseNamensnummer(XMLElement xMLElement) throws Exception {
        Name name = new Name();
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getUName();
            Integer n = attributes.get(string);
            if (n == null) continue;
            switch (n) {
                case 1101: {
                    name.setNummer(Long.parseLong(IFormat.getNumbers(xMLElement2.getContent())));
                    break;
                }
                case 1102: {
                    name.addAttribute(string, xMLElement2.getContent());
                    break;
                }
                case 1095: {
                    String string2 = "";
                    String string3 = "";
                    Enumeration enumeration2 = xMLElement2.getChildren("AX_Anteil").enumerateChildren();
                    while (enumeration2.hasMoreElements()) {
                        XMLElement xMLElement3 = (XMLElement)enumeration2.nextElement();
                        String string4 = xMLElement3.getUName();
                        if (string4.equals("zaehler")) {
                            string2 = xMLElement3.getContent();
                            continue;
                        }
                        if (!string4.equals("nenner")) continue;
                        string3 = xMLElement3.getContent();
                    }
                    name.setAnteil(IFormat.trimRight(string2, "0.") + "/" + IFormat.trimRight(string3, "0."));
                    break;
                }
                case 1106: {
                    name.setArt(Integer.parseInt(xMLElement2.getContent()));
                    break;
                }
                case 1104: {
                    name.setGemeinschaftsArt(Integer.parseInt(xMLElement2.getContent()));
                    break;
                }
                case 1105: 
                case 1107: {
                    name.addAttribute(string, xMLElement2.getContent());
                    break;
                }
                case 1100: 
                case 1108: 
                case 1109: {
                    name.addAttribute(this.createLinkAtt(string), this.parseLink(xMLElement2));
                }
            }
        }
        return name;
    }

    private Name parsePerson(XMLElement xMLElement) throws Exception {
        Name name = new Name();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Object object = xMLElement.enumerateChildren();
        while (object.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)object.nextElement();
            String string5 = xMLElement2.getUName();
            Integer n6 = attributes.get(string5);
            if (n6 == null) continue;
            switch (n6) {
                case 1110: {
                    string = xMLElement2.getContent();
                    break;
                }
                case 1112: {
                    string2 = xMLElement2.getContent();
                    break;
                }
                case 1113: {
                    string3 = xMLElement2.getContent();
                    break;
                }
                case 1114: {
                    string4 = xMLElement2.getContent();
                    break;
                }
                case 1115: {
                    name.setGeburtName(xMLElement2.getContent());
                    break;
                }
                case 1116: {
                    name.setGeburtDatum(IFormat.parseDateToDE(xMLElement2.getContent()));
                    break;
                }
                case 1037: 
                case 1111: 
                case 1117: 
                case 1118: 
                case 1119: {
                    name.addAttribute(string5, xMLElement2.getContent());
                    break;
                }
                case 1059: {
                    name.addAttribute(this.createLinkAtt(string5, n++), this.parseLink(xMLElement2));
                    break;
                }
                case 1120: {
                    name.addAttribute(this.createLinkAtt(string5, n2++), this.parseLink(xMLElement2));
                    break;
                }
                case 1161: {
                    name.addAttribute(this.createLinkAtt(string5, n3++), this.parseLink(xMLElement2));
                    break;
                }
                case 1029: {
                    name.addAttribute(this.createLinkAtt(string5), this.parseLink(xMLElement2));
                    break;
                }
                case 1108: {
                    name.addAttribute(this.createLinkAtt(string5, n4++), this.parseLink(xMLElement2));
                    break;
                }
                case 1121: {
                    name.addAttribute(this.createLinkAtt(string5, n5++), this.parseLink(xMLElement2));
                }
            }
        }
        object = new StringBuffer(100);
        ((StringBuffer)object).append(string);
        if (string2 != null) {
            ((StringBuffer)object).append(", ");
            ((StringBuffer)object).append(string2);
        }
        if (string4 != null) {
            ((StringBuffer)object).append("; ");
            ((StringBuffer)object).append(string4);
        }
        if (string3 != null) {
            ((StringBuffer)object).append("; ");
            ((StringBuffer)object).append(string3);
        }
        name.setName(((StringBuffer)object).toString());
        return name;
    }

    private String filterLocalName(String string) {
        int n;
        int n2 = string.indexOf("[");
        if (n2 > 0 && (n = string.indexOf("]")) > n2) {
            return string.substring(0, n2).trim();
        }
        return string;
    }

    private Name parseAnschrift(XMLElement xMLElement) throws Exception {
        Name name = new Name();
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        Object object = xMLElement.enumerateChildren();
        while (object.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)object.nextElement();
            String string4 = xMLElement2.getUName();
            String string5 = xMLElement2.getContent().trim();
            Integer n2 = attributes.get(string4);
            if (n2 == null) continue;
            switch (n2) {
                case 1122: {
                    name.setOrt(string5);
                    break;
                }
                case 1123: {
                    name.setPostleitzahl(string5);
                    break;
                }
                case 1124: {
                    name.setPlzPf(string5);
                    break;
                }
                case 1126: {
                    string3 = string5;
                    break;
                }
                case 1127: {
                    string = string5;
                    break;
                }
                case 1085: {
                    string2 = string5;
                    break;
                }
                case 1129: {
                    try {
                        name.setPostfach(Integer.parseInt(string5));
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                case 1125: 
                case 1128: 
                case 1130: 
                case 1131: {
                    name.addAttribute(string4, string5);
                    break;
                }
                case 1132: {
                    if (KafPlot.debug()) {
                        System.out.println("******** weitereAdresse");
                    }
                    name.addAttribute(this.createAtt(string4, n++), string5);
                }
            }
        }
        object = new StringBuffer(100);
        if (string != null) {
            ((StringBuffer)object).append(string);
        }
        if (string2 != null) {
            if (((StringBuffer)object).length() == 0) {
                ((StringBuffer)object).append("HsNr. ");
            } else {
                ((StringBuffer)object).append(" ");
            }
            ((StringBuffer)object).append(string2);
        }
        if (string3 != null) {
            ((StringBuffer)object).append(" OT ");
            ((StringBuffer)object).append(string3);
        }
        name.setAdresse(((StringBuffer)object).toString());
        return name;
    }

    private Strasse parseLagebezeichnungKatalogeintrag(XMLElement xMLElement) throws Exception {
        Strasse strasse = new Strasse();
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getUName();
            if (string.equals("schluessel")) {
                LageEntry lageEntry = this.parseVerschluesselteLagebezeichnung(xMLElement2.getChildrenAt(0));
                strasse.setGemeinde(new Gemeinde(lageEntry.getGemeinde(), null));
                strasse.setNummer(lageEntry.getStrasse());
                continue;
            }
            if (!string.equals("bezeichnung")) continue;
            strasse.setName(xMLElement2.getContent());
        }
        return strasse;
    }

    private Gemeinde parseGemeinde(XMLElement xMLElement) throws Exception {
        Gemeinde gemeinde = new Gemeinde();
        int n = 0;
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getUName();
            if (string.equals("schluesselGesamt")) {
                n = Integer.parseInt(xMLElement2.getContent());
                continue;
            }
            if (string.equals("gemeindekennzeichen") && n == 0) {
                n = this.parseGemeindeKennzeichen(xMLElement2.getChildrenAt(0));
                continue;
            }
            if (!string.equals("bezeichnung")) continue;
            gemeinde.setName(this.filterLocalName(xMLElement2.getContent()));
        }
        gemeinde.setNummer(n);
        return gemeinde;
    }

    private int parseGemeindeKennzeichen(XMLElement xMLElement) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getUName();
            String string2 = xMLElement2.getContent();
            Integer n5 = attributes.get(string);
            if (n5 == null) continue;
            switch (n5) {
                case 1021: {
                    n = Integer.parseInt(string2);
                    break;
                }
                case 1088: {
                    n2 = Integer.parseInt(string2);
                    break;
                }
                case 1089: {
                    n3 = Integer.parseInt(string2);
                    break;
                }
                case 1090: {
                    n4 = Integer.parseInt(string2);
                }
            }
        }
        return n * 1000000 + n2 * 100000 + n3 * 1000 + n4;
    }

    private Gemarkung parseGemarkung(XMLElement xMLElement) throws Exception {
        Gemarkung gemarkung = new Gemarkung();
        int n = 0;
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getUName();
            if (string.equals("schluesselGesamt")) {
                n = Integer.parseInt(xMLElement2.getContent());
                continue;
            }
            if (string.equals("schluessel") && n == 0) {
                int n2 = 0;
                int n3 = 0;
                Enumeration enumeration2 = xMLElement2.getChildrenAt(0).enumerateChildren();
                while (enumeration2.hasMoreElements()) {
                    XMLElement xMLElement3 = (XMLElement)enumeration2.nextElement();
                    String string2 = xMLElement3.getUName();
                    if (string2.equals("land")) {
                        n2 = Integer.parseInt(xMLElement3.getContent());
                        continue;
                    }
                    if (!string2.equals("gemarkungsnummer")) continue;
                    n3 = Integer.parseInt(xMLElement3.getContent());
                }
                n = n2 * 10000 + n3;
                continue;
            }
            if (!string.equals("bezeichnung")) continue;
            gemarkung.setName(this.filterLocalName(xMLElement2.getContent()));
        }
        gemarkung.setNummer(n);
        return gemarkung;
    }

    private AA_Lebenszeitintervall parseLebenszeitintervall(XMLElement xMLElement) {
        long l = 0L;
        long l2 = 0L;
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getUName();
            if (string.equals("beginnt")) {
                l = IFormat.parseDateTimeISO(xMLElement2.getContent());
                continue;
            }
            if (!string.equals("endet")) continue;
            l2 = IFormat.parseDateTimeISO(xMLElement2.getContent());
        }
        return AA_Lebenszeitintervall.create(l, l2);
    }

    private AA_Fachdatenverbindung parseFachdatenverbindung(XMLElement xMLElement) {
        String string = null;
        String string2 = null;
        String string3 = null;
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string4 = xMLElement2.getUName();
            if (string4.equals("art")) {
                string = xMLElement2.getContent();
                continue;
            }
            if (!string4.equals("fachdatenobject")) continue;
            Enumeration enumeration2 = xMLElement2.getChildrenAt(0).enumerateChildren();
            while (enumeration2.hasMoreElements()) {
                XMLElement xMLElement3 = (XMLElement)enumeration2.nextElement();
                String string5 = xMLElement3.getUName();
                if (string5.equals("uri")) {
                    string3 = xMLElement3.getContent();
                    continue;
                }
                if (!string5.equals("name")) continue;
                string2 = xMLElement3.getContent();
            }
        }
        return AA_Fachdatenverbindung.create(string, string2, string3);
    }

    private AA_Modellart parseModellart(XMLElement xMLElement) {
        String string = null;
        String string2 = null;
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string3 = xMLElement2.getUName();
            if (string3.equals("advStandardModell")) {
                string = xMLElement2.getContent();
                continue;
            }
            if (!string3.equals("sonstigesModell")) continue;
            string2 = xMLElement2.getContent();
        }
        return AA_Modellart.create(string, string2);
    }

    private A_Anlass parseAnlass(XMLElement xMLElement) {
        return A_Anlass.create(xMLElement.getStringAttribute("xlink:title"), xMLElement.getStringAttribute("xlink:href"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseGeom(XMLElement xMLElement, GObject gObject) throws Exception {
        int n = 0;
        XMLElement xMLElement2 = xMLElement.getChildrenAt(0);
        if (xMLElement2.getName().equals("gml:Surface")) {
            XMLElement xMLElement3 = xMLElement2.getChildrenAt(0);
            if (!xMLElement3.getName().equals("gml:patches") && !xMLElement3.getName().equals("gml:polygonPatches")) throw new Exception("ung\u00fcltige Geometrie in Surface: " + String.valueOf(xMLElement3));
            Enumeration enumeration = xMLElement3.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                n += this.parsePatch((XMLElement)enumeration.nextElement(), gObject);
            }
        } else if (xMLElement2.getName().equals("gml:CompositeCurve")) {
            this.parseCompositeCurve(xMLElement2, gObject);
        } else if (xMLElement2.getName().equals("gml:MultiSurface")) {
            Enumeration enumeration = xMLElement2.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                XMLElement xMLElement4 = (XMLElement)enumeration.nextElement();
                if (!xMLElement4.getName().equals("gml:surfaceMember") && !xMLElement4.getName().equals("gml:surfaceMembers")) throw new Exception("ung\u00fcltige Geometrie in MultiSurface: " + String.valueOf(xMLElement4));
                n += this.parseGeom(xMLElement4, gObject);
            }
        } else if (xMLElement2.getName().equals("gml:Curve")) {
            this.parseCurve(xMLElement2, gObject);
        } else if (xMLElement2.getName().equals("gml:Point")) {
            this.parsePoint(xMLElement2, gObject);
        } else {
            if (!xMLElement2.getName().equals("gml:CompositeSurface")) throw new Exception("unbekannte ObjektGeometrie: " + String.valueOf(xMLElement2));
            Enumeration enumeration = xMLElement2.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                XMLElement xMLElement5 = (XMLElement)enumeration.nextElement();
                if (!xMLElement5.getName().equals("gml:surfaceMember") && !xMLElement5.getName().equals("gml:surfaceMembers")) throw new Exception("ung\u00fcltige Geometrie in MultiSurface: " + String.valueOf(xMLElement5));
                n += this.parseGeom(xMLElement5, gObject);
            }
        }
        if (n <= true) return n;
        gObject.setTempFlag1(true);
        return n;
    }

    private int parsePatch(XMLElement xMLElement, GObject gObject) throws Exception {
        int n = 0;
        if (xMLElement.getName().equals("gml:PolygonPatch")) {
            Enumeration enumeration = xMLElement.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
                this.parseRing(xMLElement2.getChildrenAt(0), gObject);
                ++n;
            }
        } else {
            throw new Exception("unbekannte Geometrie in Patch: " + String.valueOf(xMLElement));
        }
        return n;
    }

    private void parseRing(XMLElement xMLElement, GObject gObject) throws Exception {
        Object object;
        int n = gObject.size();
        Object object2 = xMLElement.enumerateChildren();
        while (object2.hasMoreElements()) {
            object = (XMLElement)object2.nextElement();
            XMLElement xMLElement2 = ((XMLElement)object).getChildren("gml:Curve/gml:segments");
            this.parseSegments(xMLElement2, gObject);
        }
        object2 = (Linie)gObject.elementAt(n);
        object = (Linie)gObject.lastElement();
        ((Linie)object2).setStart();
        if (((Linie)object2).pa.x == ((Linie)object).pe.x && ((Linie)object2).pa.y == ((Linie)object).pe.y) {
            gObject.addElement(new Linie(9, ((Linie)object).pe, null));
        } else {
            gObject.addElement(new Linie(0, ((Linie)object).pe, ((Linie)object2).pa));
            gObject.addElement(new Linie(9, ((Linie)object2).pa, null));
        }
    }

    private void parseCircle(XMLElement xMLElement, GObject gObject) throws Exception {
        int n = gObject.size();
        this.parseSegment(xMLElement, gObject);
        int n2 = gObject.size();
        if (gObject.size() - n < 2) {
            throw new Exception("ung\u00fcltige Geometrie in Circle: " + String.valueOf(xMLElement));
        }
        Linie linie = (Linie)gObject.elementAt(n);
        Linie linie2 = (Linie)gObject.elementAt(n + 1);
        double d = 0.0;
        try {
            double[][] dArrayArray = new double[][]{{1.0, -2.0 * linie.pa.y, -2.0 * linie.pa.x}, {1.0, -2.0 * linie.pe.y, -2.0 * linie.pe.x}, {1.0, -2.0 * linie2.pe.y, -2.0 * linie2.pe.x}};
            double[] dArray = new double[]{-(linie.pa.x * linie.pa.x + linie.pa.y * linie.pa.y), -(linie.pe.x * linie.pe.x + linie.pe.y * linie.pe.y), -(linie2.pe.x * linie2.pe.x + linie2.pe.y * linie2.pe.y)};
            double[] dArray2 = GaussianElimination.solve(dArrayArray, dArray);
            d = Math.sqrt(dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2] - dArray2[0]);
            linie.setRadius(-d);
            linie2.setRadius(-d);
        }
        catch (Exception exception) {
            this.addException(new GeomException(linie.pa, new DLine(linie.pa, linie.pe), "ung\u00fcltige Geometrie in Circle: Koordinaten erzeugen keinen Kreis"));
        }
        gObject.addElement(new Linie(0, linie2.pe, linie.pa, -d));
    }

    private void parseCompositeCurve(XMLElement xMLElement, GObject gObject) throws Exception {
        Object object;
        int n = gObject.size();
        Object object2 = xMLElement.enumerateChildren();
        while (object2.hasMoreElements()) {
            object = (XMLElement)object2.nextElement();
            XMLElement xMLElement2 = ((XMLElement)object).getChildren("gml:Curve/gml:segments");
            this.parseSegments(xMLElement2, gObject);
        }
        object2 = (Linie)gObject.elementAt(n);
        if (gObject.size() == 1) {
            ((Linie)object2).setLinie();
        } else {
            object = (Linie)gObject.lastElement();
            ((Linie)object2).setStart();
            ((Linie)object).setEnde();
        }
    }

    private void parseCurve(XMLElement xMLElement, GObject gObject) throws Exception {
        int n = gObject.size();
        Object object = xMLElement.enumerateChildren();
        while (object.hasMoreElements()) {
            this.parseSegments((XMLElement)object.nextElement(), gObject);
        }
        object = (Linie)gObject.elementAt(n);
        if (gObject.size() == 1) {
            ((Linie)object).setLinie();
        } else {
            Linie linie = (Linie)gObject.lastElement();
            ((Linie)object).setStart();
            linie.setEnde();
        }
    }

    private void parseSegments(XMLElement xMLElement, GObject gObject) throws Exception {
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getName();
            Object var6_6 = null;
            if (string.equals("gml:LineStringSegment")) {
                this.parseSegment(xMLElement2, gObject);
                continue;
            }
            if (string.equals("gml:Arc")) {
                this.parseArc(xMLElement2, gObject);
                continue;
            }
            if (string.equals("gml:Circle")) {
                this.parseCircle(xMLElement2, gObject);
                continue;
            }
            throw new Exception("unbekannte Geometrie in Segments: " + String.valueOf(xMLElement));
        }
    }

    private void parseSegment(XMLElement xMLElement, GObject gObject) throws Exception {
        Punkt punkt = null;
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            Object object;
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getName();
            if (string.equals("gml:posList")) {
                object = new StringTokenizer(xMLElement2.getContent(), " ");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    Linie linie = new Linie();
                    linie.pa = punkt != null ? punkt : this.getPunkt(this.yAdd + Double.parseDouble(((StringTokenizer)object).nextToken()), Double.parseDouble(((StringTokenizer)object).nextToken()), 0.0f);
                    punkt = linie.pe = this.getPunkt(this.yAdd + Double.parseDouble(((StringTokenizer)object).nextToken()), Double.parseDouble(((StringTokenizer)object).nextToken()), 0.0f);
                    linie.setMitte();
                    gObject.addElement(linie);
                }
                continue;
            }
            if (string.equals("gml:pos")) {
                object = xMLElement2.getContent();
                int n = ((String)object).indexOf(" ");
                Punkt punkt2 = this.getPunkt(this.yAdd + Double.parseDouble(((String)object).substring(0, n)), Double.parseDouble(((String)object).substring(n + 1)), 0.0f);
                if (punkt != null) {
                    gObject.addElement(new Linie(0, punkt, punkt2));
                }
                punkt = punkt2;
                continue;
            }
            throw new Exception("unbekannte Geometrie in Segment: " + String.valueOf(xMLElement));
        }
    }

    private void parseArc(XMLElement xMLElement, GObject gObject) throws Exception {
        Cloneable cloneable;
        DPoint dPoint = null;
        Punkt punkt = null;
        Cloneable cloneable2 = null;
        int n = 0;
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            Object object;
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string = xMLElement2.getName();
            if (string.equals("gml:posList")) {
                object = new StringTokenizer(xMLElement2.getContent(), " ");
                dPoint = this.getPunkt(this.yAdd + Double.parseDouble(((StringTokenizer)object).nextToken()), Double.parseDouble(((StringTokenizer)object).nextToken()), 0.0f);
                punkt = this.getPunkt(this.yAdd + Double.parseDouble(((StringTokenizer)object).nextToken()), Double.parseDouble(((StringTokenizer)object).nextToken()), 0.0f);
                cloneable2 = this.getPunkt(this.yAdd + Double.parseDouble(((StringTokenizer)object).nextToken()), Double.parseDouble(((StringTokenizer)object).nextToken()), 0.0f);
                continue;
            }
            if (string.equals("gml:pos")) {
                object = xMLElement2.getContent();
                int n2 = ((String)object).indexOf(" ");
                cloneable = this.getPunkt(this.yAdd + Double.parseDouble(((String)object).substring(0, n2)), Double.parseDouble(((String)object).substring(n2 + 1)), 0.0f);
                if (n == 0) {
                    dPoint = cloneable;
                } else if (n == 1) {
                    punkt = cloneable;
                } else if (n == 2) {
                    cloneable2 = cloneable;
                }
                ++n;
                continue;
            }
            throw new Exception("unbekannte Geometrie in Arc: " + String.valueOf(xMLElement));
        }
        if (dPoint != null && punkt != null && cloneable2 != null) {
            double d = DArc.getRadiusFrom3Points(dPoint, punkt, cloneable2);
            double d2 = dPoint.getDistance((DPoint)((Object)cloneable2));
            if (2.0 * Math.abs(d) - 0.001 < d2) {
                Linie linie = new Linie(0, (Punkt)dPoint, punkt, -d);
                cloneable = new Linie(0, punkt, (Punkt)cloneable2, -d);
                linie.setRadiusKoo(true);
                ((Linie)cloneable).setRadiusKoo(true);
                gObject.addElement(linie);
                gObject.addElement(cloneable);
            } else {
                Linie linie = new Linie(0, (Punkt)dPoint, (Punkt)cloneable2, -d);
                linie.setRadiusKoo(true);
                gObject.addElement(linie);
            }
        } else {
            throw new Exception("gml:Arc hat ungleich 3 Punktwerte" + String.valueOf(xMLElement));
        }
    }

    private void parsePoint(XMLElement xMLElement, GObject gObject) throws Exception {
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            if (xMLElement2.getName().equals("gml:pos")) {
                String string = xMLElement2.getContent();
                int n = string.indexOf(" ");
                Punkt punkt = this.getPunkt(this.yAdd + Double.parseDouble(string.substring(0, n)), Double.parseDouble(string.substring(n + 1)), 0.0f);
                gObject.addDecor(new ObjectSymbol(Symbol.TOP, 0, punkt.y, punkt.x, 0.0f));
                continue;
            }
            throw new Exception("unbekannte Geometrie in Point: " + String.valueOf(xMLElement));
        }
    }

    private Punkt getPunkt(double d, double d2, float f) {
        ArtPoint artPoint = new ArtPoint(this, d, d2, f, 0);
        Punkt punkt = (Punkt)this.koords.get(artPoint);
        if (punkt == null) {
            punkt = new Punkt(d, d2);
            punkt.h = f;
            this.koords.put(artPoint, punkt);
        }
        return punkt;
    }

    private String parseOId(String string) {
        int n = string.lastIndexOf(":");
        return n >= 0 ? string.substring(n + 1) : string;
    }

    private String parseLink(XMLElement xMLElement) {
        String string = xMLElement.getStringAttribute("xlink:href");
        return string.substring(string.lastIndexOf(":") + 1);
    }

    private String createLinkAtt(String string) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(LINK);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private String createLinkAtt(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(LINK);
        stringBuffer.append(string);
        stringBuffer.append("{");
        stringBuffer.append(n);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private String createAtt(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(string);
        stringBuffer.append("{");
        stringBuffer.append(n);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private int getListAttributeIndex(String string) {
        return Integer.parseInt(string.substring(string.indexOf("{") + 1, string.indexOf("}")));
    }

    private void computePunktOrte() {
        Object object;
        boolean bl;
        boolean bl2 = bl = DataBase.P.size() > 0;
        if (bl) {
            object = new PunktTable();
            this.linkPoints((PunktTable)object, DataBase.NAS_OBJECTS, bl);
            this.mergePoints((PunktTable)object);
        } else {
            this.linkPoints(DataBase.P, DataBase.NAS_OBJECTS, bl);
        }
        object = new ArtPoint(this, 0.0, 0.0, 0.0, 20);
        Enumeration enumeration = this.koords.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            int n = punkt.getPa();
            if (n != 30 && n != 40) continue;
            ((ArtPoint)object).y = punkt.y;
            ((ArtPoint)object).x = punkt.x;
            Punkt punkt2 = (Punkt)this.koords.get(object);
            if (punkt2 == null) continue;
            punkt.addTag(Tag.toString("REF", Long.toString(punkt2.nr)));
            punkt2.setMasterPoint(true);
            punkt.setSlavePoint(true);
        }
    }

    protected boolean toSavePunkt(Punkt punkt) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void linkPoints(PunktTable punktTable, Hashtable hashtable, boolean bl) {
        Enumeration enumeration = this.pOrte.elements();
        while (true) {
            Cloneable cloneable;
            int n;
            Punkt punkt;
            String string;
            block26: {
                AX_Punktort aX_Punktort;
                block25: {
                    if (!enumeration.hasMoreElements()) {
                        this.pOrte.clear();
                        return;
                    }
                    aX_Punktort = (AX_Punktort)enumeration.nextElement();
                    string = aX_Punktort.link;
                    if (string == null) {
                        string = "null";
                    }
                    punkt = (Punkt)this.punkte.get(string);
                    n = 0;
                    if (punkt == null) break block25;
                    if (aX_Punktort.y != 0.0 && aX_Punktort.x != 0.0) {
                        if (!aX_Punktort.cooIsStandard) {
                            if (this.readPunktExtends && aX_Punktort.kartendarstellung) {
                                this.addException(new GeomException(punkt, punkt, "Punkt " + punkt.nr + " hat unzul\u00e4ssigen weiteren Punktort mit kartendarstellung=true im Koordinatensystem: " + aX_Punktort.hinweise));
                                continue;
                            }
                            if (!KafPlot.debug()) continue;
                            System.out.println("weiterer Punktort " + aX_Punktort.y + ", " + aX_Punktort.x + " im Koordinatensystem: " + aX_Punktort.hinweise);
                            continue;
                        }
                        cloneable = (PunktParameterALKIS)punkt.getParameter();
                        if ((punkt.x != 0.0 || punkt.y != 0.0) && ((PunktParameterALKIS)cloneable).getLs() <= 1000) {
                            if (aX_Punktort.koordinatenstatus != 1000 || aX_Punktort.x == punkt.x && aX_Punktort.y == punkt.y) continue;
                            this.addException(new GeomException(punkt, punkt, "Punkt " + punkt.nr + " hat mehrere Punktorte mit KST=1000"));
                            continue;
                        }
                        punkt.y = aX_Punktort.y;
                        punkt.x = aX_Punktort.x;
                        n = ((PunktParameterALKIS)cloneable).getPa();
                        if (n == 20 && aX_Punktort.oart != 14004) {
                            ((PunktParameterALKIS)cloneable).setPa(29);
                        } else if (n == 30 && aX_Punktort.oart != 14002) {
                            if (!this.readBGU) continue;
                            ((PunktParameterALKIS)cloneable).setPa(39);
                        } else if (n == 40 && aX_Punktort.oart != 14002) {
                            if (!this.readBBU) continue;
                            ((PunktParameterALKIS)cloneable).setPa(49);
                        }
                        ((PunktParameterALKIS)cloneable).setOrtParameters(aX_Punktort);
                        punkt.initParameter((PunktParameter)cloneable);
                        punkt.setPs(PunktStatus.getDefaultStatus((PunktParameter)cloneable));
                        punkt.setGl(PunktStatus.getDefaultGenauigkeit((PunktParameter)cloneable));
                        if (punkt.isZeigtAufPoint()) {
                            String string2 = punkt.getTag("IND").getValue();
                            Punkt punkt2 = (Punkt)this.punkte.get(string2);
                            if (punkt2 == null) {
                                punkt2 = DataBase.NAS_OBJECTS.get(string2);
                            }
                            if (punkt2 != null) {
                                long l = punkt2.nr >= this.nrRed ? punkt2.nr - this.nrRed : punkt2.nr;
                                Object object = punkt.getBemerkung();
                                object = Tag.removeTag((String)object, "IND");
                                object = Tag.toString("IND", Long.toString(l)) + (String)object;
                                punkt.setBemerkung((String)object);
                                punkt2.setIndirektPoint(true);
                            } else {
                                this.addException(new GeomException(punkt, punkt, "Punkt " + (punkt.nr >= this.nrRed ? punkt.nr - this.nrRed : punkt.nr) + " zeigt auf id:" + string2 + ", referenzierter Punkt nicht vorhanden"));
                                String string3 = punkt.getBemerkung();
                                string3 = Tag.removeTag(string3, "IND");
                                punkt.setBemerkung(string3);
                                punkt.setZeigtAufPoint(false);
                            }
                        }
                        if (aX_Punktort.hinweise != null && !punkt.hasTag("ENT")) {
                            punkt.addTag(Tag.toString("ENT", this.reformatRiss(aX_Punktort.hinweise, 0)));
                        }
                        break block26;
                    } else {
                        if (aX_Punktort.z == 0.0) continue;
                        punkt.h = (float)aX_Punktort.z;
                        continue;
                    }
                }
                if (!NasIOProperties.readUnusedPoints()) continue;
                punkt = new Punkt(aX_Punktort.y, aX_Punktort.x);
                this.addException(new GeomException(punkt, punkt, "PunktOrt " + String.valueOf(aX_Punktort) + " ohne Punkt mit id:" + string));
            }
            if (punkt.nr <= 0L) {
                punkt.nr = this.getFreeNumber(punktTable);
                if (bl) {
                    punkt.nr = this.getFreeNumber(DataBase.P);
                    punkt.setTempFlag1(true);
                }
            } else if (punkt.nr >= this.nrRed) {
                punkt.nr -= this.nrRed;
                if (punkt.createNb(punkt.nr) != punkt.createNb()) {
                    punkt.addTag(Tag.toString("NBZ", punkt.createNb(punkt.nr)));
                }
            }
            if (!this.toSavePunkt(punkt)) continue;
            cloneable = (Punkt)punktTable.put(punkt);
            hashtable.put(string, punkt);
            if (cloneable != null) {
                this.addException(new GeomException(punkt, new DLine(punkt, (DPoint)((Object)cloneable)), "Punktkennzeichen " + punkt.nr + " ist mehrfach enthalten"));
            }
            if (n != 20 && n != 30) {
                n = 0;
            }
            this.koords.put(new ArtPoint(this, punkt.y, punkt.x, punkt.h, n), punkt);
        }
    }

    private void mergePoints(PunktTable punktTable) {
        Cloneable cloneable;
        Object object;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Hashtable<Long, Object> hashtable = new Hashtable<Long, Object>();
        Hashtable<ArtPoint, Object> hashtable2 = new Hashtable<ArtPoint, Object>();
        Enumeration enumeration = DataBase.P.elements();
        while (enumeration.hasMoreElements()) {
            object = (Punkt)enumeration.nextElement();
            if (((Punkt)object).getOldParameter().getKafPa() <= -1) continue;
            if (((Punkt)object).nr >= 100000L) {
                long l = ((Punkt)object).buildKatNr(14, ((Punkt)object).nr);
                hashtable.put(new Long(l), object);
                continue;
            }
            hashtable2.put(new ArtPoint(this, ((Punkt)object).y, ((Punkt)object).x, ((Punkt)object).h, ((Punkt)object).getPa()), object);
        }
        enumeration = punktTable.elements();
        while (enumeration.hasMoreElements()) {
            object = (Punkt)enumeration.nextElement();
            Punkt punkt = null;
            if (((Punkt)object).isTempFlag1()) {
                ((Punkt)object).setTempFlag1(false);
                punkt = (Punkt)hashtable2.get(new ArtPoint(this, ((Punkt)object).y, ((Punkt)object).x, ((Punkt)object).h, ((Punkt)object).getPa()));
            } else {
                if (((Punkt)object).nr >= this.nrRed) {
                    ((Punkt)object).nr -= this.nrRed;
                }
                punkt = (Punkt)hashtable.get(new Long(((Punkt)object).nr));
            }
            if (punkt != null) {
                if (this.mergePoint(punkt, (Punkt)object)) {
                    ++n3;
                    if (!this.isMode(32768)) continue;
                    DataBase.MENGE.put(punkt);
                    continue;
                }
                ++n2;
                if (!this.isMode(16384)) continue;
                DataBase.MENGE.put(punkt);
                continue;
            }
            if (NasIOProperties.markUpdatePoints()) {
                ((Punkt)object).setFortfuehrung(true);
                cloneable = ((Punkt)object).getParameter();
                ((PunktParameter)cloneable).setPst(14);
                if (((PunktParameter)cloneable).getModEb() == 1) {
                    ((PunktParameter)cloneable).setEb(48);
                } else if (((PunktParameter)cloneable).getModEb() == 2) {
                    ((PunktParameter)cloneable).setEb(42);
                } else if (((PunktParameter)cloneable).getModEb() == 19) {
                    ((PunktParameter)cloneable).setEb(59);
                }
                ((Punkt)object).updateParameter((PunktParameter)cloneable);
            }
            DataBase.P.put((LongHashObject)object);
            ++n;
            this.addUpdateMsg(new GeomException(4, (DPoint)object, (GeomElement)object, "eingef\u00fcgt"), (byte)12);
            if (!this.isMode(8192)) continue;
            DataBase.MENGE.put((LongHashObject)object);
        }
        enumeration = this.deletes.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            Punkt punkt = DataBase.NAS_OBJECTS.get(object);
            if (punkt == null || !(punkt instanceof Punkt)) continue;
            cloneable = punkt;
            if (NasIOProperties.markUpdatePoints()) {
                ((Punkt)cloneable).setFortfuehrung(true);
                PunktParameter punktParameter = ((Punkt)cloneable).getParameter();
                punktParameter.setPst(13);
                ((Punkt)cloneable).updateParameter(punktParameter);
            }
            this.addUpdateMsg(new GeomException(3, (DPoint)((Object)cloneable), (GeomElement)((Object)cloneable), "untergegangen"), (byte)13);
            ++n4;
        }
        if (n2 > 0 || n3 > 0 || n4 > 0) {
            this.updateMode = true;
            this.addException(new Exception("UpdateModus: " + Alkis.getOperationName(this.operation)));
            this.addException(new Exception("UpdateModus: " + n2 + " best\u00e4tigt"));
            this.addException(new Exception("UpdateModus: " + n3 + " ge\u00e4ndert"));
            this.addException(new Exception("UpdateModus: " + n + " hinzugef\u00fcgt"));
            this.addException(new Exception("UpdateModus: " + n4 + " untergegangen"));
        }
    }

    private boolean mergePoint(Punkt punkt, Punkt punkt2) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(0);
        boolean bl = false;
        DPoint dPoint = punkt.getOriginal();
        double d = dPoint.getDistance(punkt2);
        if (d > 5.0E-4) {
            this.appendMsg(stringBuffer, "KOO (" + IFormat.f_3.format(d) + ")");
            if (NasIOProperties.replaceUpdatePoints()) {
                punkt.dy = 0.0f;
                punkt.dx = 0.0f;
            } else {
                punkt.dy = (float)(punkt2.y - punkt.y);
                punkt.dx = (float)(punkt2.x - punkt.x);
                punkt.setKooDiff(true);
            }
            punkt.y = punkt2.y;
            punkt.x = punkt2.x;
            bl = true;
        }
        if (punkt.h != punkt2.h) {
            this.appendMsg(stringBuffer, "H (" + IFormat.f_4.format(punkt2.h - punkt.h) + ")");
            punkt.h = punkt2.h;
            punkt.dh = 0.0f;
            bl = true;
        }
        PunktParameter punktParameter = punkt.getOldParameter();
        PunktParameter punktParameter2 = punkt2.getOldParameter();
        boolean bl2 = false;
        boolean bl3 = false;
        if (punktParameter.getModLg() != punktParameter2.getModLg()) {
            this.appendMsg(stringBuffer, "GST");
            bl2 = true;
            bl3 = true;
        }
        if (punktParameter.getModLl() != punktParameter2.getModLl()) {
            this.appendMsg(stringBuffer, "GWT");
            bl2 = true;
            bl3 = true;
        }
        if (punktParameter.getModLz() != punktParameter2.getModLz()) {
            this.appendMsg(stringBuffer, "LZK");
            bl2 = true;
        }
        if (punktParameter.getModEa() != punktParameter2.getModEa()) {
            this.appendMsg(stringBuffer, "DES1");
            bl2 = true;
        }
        if (punktParameter.getModEq() != punktParameter2.getModEq()) {
            this.appendMsg(stringBuffer, "DES2");
            bl2 = true;
        }
        if (punktParameter.getModLs() != punktParameter2.getModLs()) {
            this.appendMsg(stringBuffer, "KST");
            bl2 = true;
        }
        if (punktParameter.getModVa() != punktParameter2.getModVa()) {
            this.appendMsg(stringBuffer, punktParameter.getModPa() == 10 || punktParameter.getModPa() == 11 || punktParameter.getModPa() == 60 ? "VMA" : "ABM");
            bl2 = true;
        }
        if (punktParameter.getModVb() != punktParameter2.getModVb()) {
            this.appendMsg(stringBuffer, "BZA");
            bl2 = true;
        }
        if (punktParameter.getModArt() != punktParameter2.getModArt()) {
            this.appendMsg(stringBuffer, "ART");
            bl2 = true;
        }
        if (bl2) {
            if (bl3) {
                n = PunktStatus.getDefaultStatus(punktParameter2);
                float f = PunktStatus.getDefaultGenauigkeit(punktParameter2);
                if (punkt.getPs() != n) {
                    punkt.setPs(n);
                    this.appendMsg(stringBuffer, "PunktStatus");
                }
                if (punkt.getGl() != f) {
                    punkt.setGl(f);
                    this.appendMsg(stringBuffer, "Genauigkeit");
                }
            }
            bl = true;
        }
        if (punkt2.hasTag("ENT")) {
            n = 0;
            Tag tag = punkt.getTag("ENT");
            Tag tag2 = punkt2.getTag("ENT");
            if (tag == null) {
                punkt.addTag(tag2.toString());
                n = 1;
            } else if (!tag.getValue().equals(tag2.getValue())) {
                Object object = punkt.getBemerkung();
                object = Tag.removeTag((String)object, "ENT");
                object = (String)object + tag2.toString();
                punkt.setBemerkung((String)object);
                n = 1;
            }
            if (n != 0) {
                this.appendMsg(stringBuffer, "ENT");
                bl = true;
            }
        }
        if (bl) {
            stringBuffer.append(" ge\u00e4ndert");
            this.addUpdateMsg(new GeomException(3, punkt, punkt, stringBuffer.toString()), (byte)11);
        } else {
            stringBuffer.append("best\u00e4tigt");
            this.addUpdateMsg(new GeomException(3, punkt, punkt, stringBuffer.toString()), (byte)10);
        }
        if (NasIOProperties.replaceUpdatePoints()) {
            if (bl2) {
                punkt.initParameter(punktParameter2);
            }
        } else {
            punktParameter2.setPst(bl ? 12 : 11);
            punkt.updateParameter(punktParameter2);
        }
        if (NasIOProperties.markUpdatePoints()) {
            punkt.setFortfuehrung(true);
        }
        return bl;
    }

    private void appendMsg(StringBuffer stringBuffer, String string) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append(", ");
        }
        stringBuffer.append(string);
    }

    private void computeObjektOrte() {
        Enumeration enumeration = this.oOrte.elements();
        block6: while (enumeration.hasMoreElements()) {
            ObjektOrt objektOrt = (ObjektOrt)enumeration.nextElement();
            Object v = this.objekte.get(objektOrt.id);
            if (objektOrt.id == null) continue;
            switch (objektOrt.art) {
                case 3: 
                case 5: 
                case 19: 
                case 20: {
                    if (!(v instanceof Koordinate2D)) continue block6;
                    Koordinate2D koordinate2D = (Koordinate2D)v;
                    koordinate2D.setY(objektOrt.y);
                    koordinate2D.setX(objektOrt.x);
                    if (!(v instanceof AngleElement)) continue block6;
                    ((AngleElement)v).setAngle(this.rad(objektOrt.angle));
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    Koordinate2D koordinate2D;
                    if (v instanceof Lage) {
                        koordinate2D = (Lage)v;
                        TopObject topObject = new TopObject();
                        topObject.addDecor(new ObjectText(objektOrt.text != null ? objektOrt.text : ((Lage)koordinate2D).getBezeichnungAsString(), objektOrt.sign, objektOrt.y, objektOrt.x, this.rad(objektOrt.angle), objektOrt.cnt, objektOrt.scale, objektOrt.width));
                        topObject.initGeom();
                        DataBase.TOP.put(topObject);
                        break;
                    }
                    if (!(v instanceof Nutzung)) continue block6;
                    break;
                }
                case 7: {
                    System.out.println("::" + objektOrt.text + ":" + objektOrt.id);
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 9: 
                case 17: 
                case 18: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: {
                    break;
                }
                default: {
                    System.out.println("*" + objektOrt.art + " > " + (v == null ? "null" : v.getClass().getName()));
                }
            }
        }
    }

    private float rad(double d) {
        double d2 = -d + 1.5707963267948966;
        if (d2 < 0.0) {
            d2 += Math.PI;
        }
        if (d2 < 0.0) {
            d2 += Math.PI;
        } else if (d2 > Math.PI) {
            d2 -= Math.PI;
        }
        return (float)d2;
    }

    private void computeTextOrte() {
        Enumeration enumeration = this.oPrae.elements();
        while (enumeration.hasMoreElements()) {
            Object v;
            ObjektOrt objektOrt = (ObjektOrt)enumeration.nextElement();
            String string = objektOrt.id;
            if (string == null || !((v = this.objekte.get(string)) instanceof GObject)) continue;
            GObject gObject = (GObject)v;
            gObject.setYT(gObject.getY());
            gObject.setXT(gObject.getX());
            gObject.setY(objektOrt.y);
            gObject.setX(objektOrt.x);
        }
    }

    private void computePersonen() {
        Enumeration enumeration = this.personen.elements();
        while (enumeration.hasMoreElements()) {
            try {
                Name name = (Name)enumeration.nextElement();
                int n = 0;
                Enumeration enumeration2 = name.attributes();
                while (enumeration2.hasMoreElements()) {
                    String string = (String)enumeration2.nextElement();
                    if (!string.startsWith("#hat")) continue;
                    Name name2 = (Name)this.anschriften.get(name.getAttribute(string));
                    if (name2 != null) {
                        if (n == 0) {
                            name.copyAdresseFrom(name2, true);
                        } else {
                            name.setAttribute("weitereAdresse{" + (n - 1) + "}", name2.toAdresseString());
                        }
                        ++n;
                        continue;
                    }
                    this.addLinkException(new Exception("Adresse: " + string + "=" + String.valueOf(name.getAttribute(string)) + " wurde nicht verlinkt"));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.addException(exception);
            }
        }
    }

    private void computeNamen() {
        Enumeration enumeration = this.namen.keys();
        while (enumeration.hasMoreElements()) {
            boolean bl = false;
            try {
                String string;
                String string2 = (String)enumeration.nextElement();
                Name name = (Name)this.namen.get(string2);
                String string3 = (String)name.getAttribute("#istBestandteilVon");
                if (string3 == null) {
                    this.addException(new Exception("Namensnummer " + string2 + " ohne Buchungsblatt"));
                    continue;
                }
                Grundbuchblatt grundbuchblatt = (Grundbuchblatt)this.objekte.get(string3);
                if (grundbuchblatt != null) {
                    grundbuchblatt.addElement(name);
                    name.setGrundbuchblatt(grundbuchblatt.getKennzeichen());
                    grundbuchblatt.setAttribute("weiterePersonenInfo", name.hasAttributes() ? "Ja" : "Nein");
                } else {
                    this.addLinkException(new Exception("Namensnummer: istBestandteilVon = " + String.valueOf(name.getAttribute("#istBestandteilVon")) + " wurde nicht verlinkt"));
                }
                if ((string = (String)name.getAttribute("#benennt")) == null) continue;
                Name name2 = (Name)this.personen.get(string);
                if (name2 != null) {
                    name.copyNameFrom(name2);
                    name.copyAdresseFrom(name2, true);
                    Enumeration enumeration2 = name2.attributes();
                    while (enumeration2.hasMoreElements()) {
                        Object object;
                        AX_Vertretung aX_Vertretung;
                        boolean bl2;
                        String string4 = (String)enumeration2.nextElement();
                        if (string4.startsWith("#wirdVertretenVon")) {
                            bl2 = false;
                            aX_Vertretung = (AX_Vertretung)this.vertretungen.get(name2.getAttribute(string4));
                            if (aX_Vertretung.haengtAn != null && (object = (Name)this.personen.get(aX_Vertretung.haengtAn)) != null) {
                                name.addVertretung("vertreten von " + ((Name)object).getNameAsString());
                                if (grundbuchblatt != null) {
                                    ((Name)object).addVertretung("vertritt " + name.getNameAsString());
                                    ((Name)object).setNummer(name.getNummer());
                                    grundbuchblatt.addElement((Name)object);
                                    ((Name)object).setGrundbuchblatt(grundbuchblatt.getKennzeichen());
                                }
                                bl2 = true;
                            }
                            if (bl2) continue;
                            this.addException(new Exception("Vertretung " + String.valueOf(name2.getAttribute(string4)) + " wurde nicht aufgel\u00f6st"));
                            continue;
                        }
                        if (!string4.startsWith("#uebtAus")) continue;
                        bl2 = false;
                        aX_Vertretung = (AX_Vertretung)this.vertretungen.get(name2.getAttribute(string4));
                        if (aX_Vertretung.vertritt.size() > 0) {
                            bl2 = true;
                            name2.addVertretung("vertritt");
                            object = aX_Vertretung.vertritt.elements();
                            while (object.hasMoreElements()) {
                                Name name3 = (Name)this.personen.get(object.nextElement());
                                if (name3 != null) {
                                    name2.addVertretung(" " + name3.getNameAsString());
                                    continue;
                                }
                                bl2 = false;
                            }
                        }
                        if (bl2) continue;
                        this.addException(new Exception("Vertretung " + String.valueOf(name2.getAttribute(string4)) + " wurde nicht vollst\u00e4ndig aufgel\u00f6st"));
                    }
                } else {
                    this.addLinkException(new Exception("Namensnummer: benennt = " + String.valueOf(name.getAttribute("#benennt")) + " wurde nicht verlinkt"));
                }
                if (!name.hasGemeinschaftsArt()) continue;
                System.out.println(name);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.addException(exception);
            }
        }
    }

    private void computeBuchung() {
        Enumeration enumeration = this.stellen.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            AX_Buchungsstelle aX_Buchungsstelle = (AX_Buchungsstelle)this.stellen.get(k);
            if (aX_Buchungsstelle.an.length() <= 0) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(aX_Buchungsstelle.an, DELIM);
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                AX_Buchungsstelle aX_Buchungsstelle2 = (AX_Buchungsstelle)this.stellen.get(string);
                if (aX_Buchungsstelle2 != null) {
                    aX_Buchungsstelle2.weitereStelle = aX_Buchungsstelle2.weitereStelle + DELIM + String.valueOf(k);
                    continue;
                }
                this.addLinkException(new Exception("Buchungsstelle: an = " + string + " wurde nicht verlinkt"));
            }
        }
    }

    private void computeObjekte(FlurstueckTable flurstueckTable, GebaeudeTable gebaeudeTable, TopObjectTable topObjectTable, NutzungTable nutzungTable, BodenSchaetzungTable bodenSchaetzungTable, GrundbuchTable grundbuchTable) {
        Hashtable<Object, TopObject> hashtable = new Hashtable<Object, TopObject>(10);
        Enumeration enumeration = this.objekte.elements();
        while (enumeration.hasMoreElements()) {
            GObject gObject;
            Object v = enumeration.nextElement();
            if (v instanceof GObject) {
                gObject = (GObject)v;
                this.mergeGeometry(gObject);
                if (gObject.isTempFlag1()) {
                    try {
                        new GObjectManipulator(gObject).repair();
                    }
                    catch (Exception exception) {
                        this.addException(new GeomException(gObject.getHashPoint(), gObject.getPolygon(), "Fehler in der Geometrie des Objekts: " + gObject.getExceptionableName()));
                    }
                    gObject.setTempFlag1(false);
                }
            }
            try {
                if (v instanceof Flurstueck && flurstueckTable != null) {
                    gObject = (Flurstueck)v;
                    Lage lage = new Lage();
                    var12_18 = gObject.attributes();
                    while (var12_18.hasMoreElements()) {
                        String string = (String)var12_18.nextElement();
                        if (!string.startsWith(LINK)) continue;
                        var14_23 = (String)gObject.getAttribute(string);
                        if (string.startsWith("#zeigtAuf") || string.startsWith("#weistAuf")) {
                            var15_24 = (Lage)this.objekte.get(var14_23);
                            if (var15_24 != null) {
                                if (((Lage)var15_24).hasBezeichnung()) {
                                    lage.setBezeichnung(((Lage)var15_24).getBezeichnung());
                                }
                                if (((Lage)var15_24).getEntry() != null) {
                                    lage.addEntry(((Lage)var15_24).getEntry());
                                }
                            } else {
                                this.addLinkException(new Exception("Lage: " + string + "=" + String.valueOf(gObject.getAttribute(string)) + " wurde nicht verlinkt"));
                            }
                        } else if (string.startsWith("#gehoertAnteiligZu") || string.startsWith("#beziehtSichAufFlurstueck")) {
                            var15_24 = (Flurstueck)this.objekte.get(var14_23);
                            if (var15_24 != null) {
                                gObject.setAttribute(string.substring(1), ((Flurstueck)var15_24).getLongKennzeichen());
                            } else {
                                this.addLinkException(new Exception("Flurst\u00fcck: " + string + "=" + String.valueOf(gObject.getAttribute(string)) + " wurde nicht verlinkt"));
                            }
                        } else if (string.startsWith("#istGebucht")) {
                            var15_24 = (AX_Buchungsstelle)this.stellen.get(var14_23);
                            if (var15_24 != null) {
                                var16_25 = (Grundbuchblatt)this.objekte.get(((AX_Buchungsstelle)var15_24).istBestandteilVon);
                                if (var16_25 != null) {
                                    ((Flurstueck)gObject).addBuchung(new Buchungsstelle(((Grundbuchblatt)var16_25).getName(), ((AX_Buchungsstelle)var15_24).laufendeNummer, ((AX_Buchungsstelle)var15_24).buchungsart));
                                } else {
                                    this.addLinkException(new Exception("Buchungsblatt: istBestandteilVon = " + ((AX_Buchungsstelle)var15_24).istBestandteilVon + " wurde nicht verlinkt"));
                                }
                                if (((AX_Buchungsstelle)var15_24).weitereStelle.length() > 0) {
                                    var17_26 = new StringTokenizer(((AX_Buchungsstelle)var15_24).weitereStelle, DELIM);
                                    while (((StringTokenizer)var17_26).hasMoreTokens()) {
                                        var18_27 = ((StringTokenizer)var17_26).nextToken();
                                        AX_Buchungsstelle aX_Buchungsstelle = (AX_Buchungsstelle)this.stellen.get(var18_27);
                                        if (aX_Buchungsstelle != null) {
                                            Grundbuchblatt grundbuchblatt = (Grundbuchblatt)this.objekte.get(aX_Buchungsstelle.istBestandteilVon);
                                            if (grundbuchblatt != null) {
                                                ((Flurstueck)gObject).addBuchung(new Buchungsstelle(grundbuchblatt.getName(), aX_Buchungsstelle.laufendeNummer, aX_Buchungsstelle.buchungsart));
                                                continue;
                                            }
                                            this.addLinkException(new Exception("Buchungsblatt: istBestandteilVon = " + aX_Buchungsstelle.istBestandteilVon + " wurde nicht verlinkt"));
                                            continue;
                                        }
                                        this.addLinkException(new Exception("Buchungsstelle: an = " + (String)var18_27 + " wurde nicht verlinkt"));
                                    }
                                }
                            } else {
                                this.addLinkException(new Exception("Buchungsstelle: " + string + "=" + String.valueOf(gObject.getAttribute(string)) + " wurde nicht verlinkt"));
                            }
                        }
                        gObject.removeAttribute(string);
                    }
                    if (lage.getBezeichnung() != null || lage.getEntry() != null) {
                        ((Flurstueck)gObject).setLage(lage);
                    }
                    gObject.initGeom();
                    flurstueckTable.addElement(gObject);
                } else if (v instanceof Gebaeude && gebaeudeTable != null) {
                    gObject = (Gebaeude)v;
                    Enumeration enumeration2 = gObject.attributes();
                    while (enumeration2.hasMoreElements()) {
                        var12_18 = (String)enumeration2.nextElement();
                        if (!((String)var12_18).startsWith(LINK)) continue;
                        if (((String)var12_18).startsWith("#hat")) {
                            var13_20 = (Lage)this.objekte.get(gObject.getAttribute((String)var12_18));
                            if (var13_20 != null) {
                                ((Gebaeude)gObject).setLeitzeichen(var13_20.toGebaeudeKennzeichen());
                            }
                        } else if (((String)var12_18).startsWith("#zeigtAuf")) {
                            var13_20 = (Lage)this.objekte.get(gObject.getAttribute((String)var12_18));
                            if (var13_20 != null) {
                                if (this.getListAttributeIndex((String)var12_18) == 0) {
                                    ((Gebaeude)gObject).setLeitzeichen(var13_20.toGebaeudeKennzeichen());
                                } else {
                                    ((Gebaeude)gObject).addKennzeichen(var13_20.toGebaeudeKennzeichen());
                                }
                            } else {
                                this.addLinkException(new Exception("Lage: " + (String)var12_18 + "=" + String.valueOf(gObject.getAttribute((String)var12_18)) + " wurde nicht verlinkt"));
                            }
                        }
                        gObject.removeAttribute((String)var12_18);
                    }
                    ((Gebaeude)gObject).initGeom();
                    try {
                        gebaeudeTable.addElement(gObject);
                    }
                    catch (Exception exception) {
                        this.addException(new GeomException(gObject.getHashPoint(), gObject.getPolygon(), exception.getMessage()));
                    }
                } else if (v instanceof TopObject && topObjectTable != null) {
                    gObject = (TopObject)v;
                    if (gObject.getOska() == 62040) {
                        boolean bl = false;
                        var12_18 = null;
                        int n = 0;
                        var14_23 = gObject.attributes();
                        while (var14_23.hasMoreElements()) {
                            var15_24 = (String)var14_23.nextElement();
                            if (!((String)var15_24).equals("artDerGelaendekante")) continue;
                            n = Integer.parseInt(gObject.getAttribute((String)var15_24).toString());
                        }
                        var14_23 = gObject.attributes();
                        while (var14_23.hasMoreElements()) {
                            var15_24 = (String)var14_23.nextElement();
                            if (!((String)var15_24).startsWith("#istTeilVon") || (var16_25 = (TopObject)this.objekte.get(var12_18 = gObject.getAttribute((String)var15_24))) == null) continue;
                            bl = true;
                            var17_26 = gObject.elements();
                            while (var17_26.hasMoreElements()) {
                                var18_27 = (Linie)var17_26.nextElement();
                                if (n == 1220) {
                                    ((Linie)var18_27).setBOK(true);
                                } else {
                                    if (n != 1230) continue;
                                    ((Linie)var18_27).setBUK(true);
                                }
                                var16_25.addElement(var18_27);
                            }
                        }
                        if (bl) {
                            continue;
                        }
                    } else if (gObject.getOska() == 61002) {
                        TopObject topObject;
                        boolean bl = false;
                        var12_18 = gObject.getAttribute("#istTeilVon{0}");
                        if (var12_18 != null && (topObject = (TopObject)this.objekte.get(var12_18)) != null) {
                            bl = true;
                            var14_23 = gObject.elements();
                            while (var14_23.hasMoreElements()) {
                                var15_24 = (Linie)var14_23.nextElement();
                                topObject.addElement(var15_24);
                            }
                            hashtable.put(var12_18, topObject);
                        }
                        if (bl) continue;
                    }
                    gObject.initGeom();
                    if (!gObject.isArea()) {
                        gObject.removeLocation();
                        gObject.initGeom();
                    }
                    topObjectTable.addElement(gObject);
                } else if (v instanceof Nutzung && nutzungTable != null) {
                    gObject = (Nutzung)v;
                    gObject.initGeom();
                    nutzungTable.addElement(gObject);
                } else if (v instanceof BodenSchaetzung && bodenSchaetzungTable != null) {
                    gObject = (BodenSchaetzung)v;
                    gObject.initGeom();
                    bodenSchaetzungTable.addElement(gObject);
                } else if (v instanceof Grundbuchblatt && grundbuchTable != null) {
                    grundbuchTable.put((Grundbuchblatt)v);
                }
                super.setProgress(100);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            this.computeBoeschung((TopObject)enumeration.nextElement());
        }
        if (flurstueckTable != null) {
            flurstueckTable.sort();
        }
        if (gebaeudeTable != null) {
            gebaeudeTable.sort();
        }
        if (nutzungTable != null) {
            nutzungTable.sort();
        }
        if (bodenSchaetzungTable != null) {
            bodenSchaetzungTable.sort();
        }
    }

    private void computeBoeschung(TopObject topObject) {
        Linie linie;
        Hashtable<Linie, Linie> hashtable = new Hashtable<Linie, Linie>();
        Vector<Linie> vector = new Vector<Linie>();
        Enumeration enumeration = topObject.elements();
        while (enumeration.hasMoreElements()) {
            linie = (Linie)enumeration.nextElement();
            if (linie.isBOK() || linie.isBUK()) {
                hashtable.put(linie, linie);
                continue;
            }
            vector.addElement(linie);
        }
        topObject.removeAllElements();
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            linie = (Linie)enumeration.nextElement();
            Linie linie2 = (Linie)hashtable.get(linie);
            if (linie2 != null) {
                linie.setBOK(linie2.isBOK());
                linie.setBUK(linie2.isBUK());
            }
            topObject.addElement(linie);
        }
        topObject.initGeom();
    }

    private void computeKatalog() {
        IntegerHashObject integerHashObject;
        Comparable comparable;
        if (this.gemarkungen.size() > 0) {
            Gemeinde.clear();
            Gemarkung.clear();
        }
        Enumeration enumeration = DataBase.FLST.elements();
        while (enumeration.hasMoreElements()) {
            Gemeinde gemeinde;
            comparable = (Flurstueck)enumeration.nextElement();
            if (((Flurstueck)comparable).getGemeinde() <= 0 || (integerHashObject = (Gemarkung)this.gemarkungen.get(((Flurstueck)comparable).getGemarkung())) == null || ((Gemarkung)integerHashObject).getGemeinde() != null || (gemeinde = (Gemeinde)this.gemeinden.get(((Flurstueck)comparable).getGemeinde())) == null) continue;
            ((Gemarkung)integerHashObject).setGemeinde(gemeinde);
            gemeinde.addGemarkung((Gemarkung)integerHashObject);
        }
        enumeration = this.strassen.elements();
        while (enumeration.hasMoreElements()) {
            comparable = (Strasse)enumeration.nextElement();
            integerHashObject = (Gemeinde)this.gemeinden.get(((Strasse)comparable).getGemeinde().intHashKey());
            if (integerHashObject == null) continue;
            ((Strasse)comparable).setGemeinde((Gemeinde)integerHashObject);
            ((Gemeinde)integerHashObject).addStrasse((Strasse)comparable);
        }
        enumeration = this.gemeinden.elements();
        while (enumeration.hasMoreElements()) {
            comparable = (Gemeinde)enumeration.nextElement();
            Gemeinde.putGemeinde((Gemeinde)comparable);
        }
        enumeration = this.gemarkungen.elements();
        while (enumeration.hasMoreElements()) {
            comparable = (Gemarkung)enumeration.nextElement();
            if (((Gemarkung)comparable).getGemeinde() == null) continue;
            Gemarkung.putGemarkung((Gemarkung)comparable);
        }
    }

    private void mergeFlurstuecke(FlurstueckTable flurstueckTable, GrundbuchTable grundbuchTable) {
        int n = 0;
        Enumeration enumeration = DataBase.FLST.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            if (!flurstueck.isStammstueck()) continue;
            Enumeration enumeration2 = flurstueckTable.elements();
            while (enumeration2.hasMoreElements()) {
                Flurstueck flurstueck2 = (Flurstueck)enumeration2.nextElement();
                if (!flurstueck.equalsIgnoreTeil(flurstueck2)) continue;
                StringBuffer stringBuffer = new StringBuffer();
                if (flurstueck.getBuchFlaeche() != flurstueck2.getBuchFlaeche()) {
                    stringBuffer.append("\nBuchfl\u00e4che ver\u00e4ndert: " + flurstueck2.getBuchFlaecheAsString());
                }
                if (!flurstueck.getStrasseAsString().equals(flurstueck2.getStrasseAsString())) {
                    stringBuffer.append("\nLage ver\u00e4ndert: " + flurstueck2.getStrasseAsString());
                }
                if (flurstueck.hasBuchung() && flurstueck2.hasBuchung()) {
                    Grundbuchblatt grundbuchblatt;
                    IntegerHashObject integerHashObject;
                    Object object;
                    if (!flurstueck.getBuchungenAsString().equals(flurstueck2.getBuchungenAsString())) {
                        stringBuffer.append("\nGrundbuchblatt ver\u00e4ndert: " + flurstueck2.getBuchungenAsString());
                    }
                    StringBuffer stringBuffer2 = new StringBuffer();
                    Object object2 = flurstueck.buchungen();
                    while (object2.hasMoreElements()) {
                        object = (Buchungsstelle)object2.nextElement();
                        integerHashObject = (Grundbuchblatt)DataBase.BUCH.get(((Buchungsstelle)object).getGrundbuchblattName());
                        if (integerHashObject == null) continue;
                        stringBuffer2.append(((Grundbuchblatt)integerHashObject).toDatLine());
                    }
                    object2 = new StringBuffer();
                    object = flurstueck2.buchungen();
                    while (object.hasMoreElements()) {
                        integerHashObject = (Buchungsstelle)object.nextElement();
                        grundbuchblatt = (Grundbuchblatt)grundbuchTable.get(((Buchungsstelle)integerHashObject).getGrundbuchblattName());
                        if (grundbuchblatt == null) continue;
                        ((StringBuffer)object2).append(grundbuchblatt.toDatLine());
                    }
                    if (!stringBuffer2.toString().equals(((StringBuffer)object2).toString())) {
                        stringBuffer.append("\nEigent\u00fcmerdaten ver\u00e4ndert:\n");
                        object = flurstueck2.buchungen();
                        while (object.hasMoreElements()) {
                            integerHashObject = (Buchungsstelle)object.nextElement();
                            grundbuchblatt = (Grundbuchblatt)grundbuchTable.get(((Buchungsstelle)integerHashObject).getGrundbuchblattName());
                            if (grundbuchblatt == null) continue;
                            stringBuffer.append(grundbuchblatt.toHumanString("\n"));
                        }
                    }
                }
                if (stringBuffer.length() <= 0) continue;
                this.addUpdateMsg(new GeomException(3, flurstueck.getPoint(), flurstueck.getPolygon(), "Flurst\u00fcck: " + flurstueck.getName() + stringBuffer.toString()), (byte)20);
                ++n;
            }
        }
        if (n > 0) {
            this.addException(new Exception("UpdateModus: " + n + " \u00c4nderungsvermerke zu Flurst\u00fccken"));
        }
    }

    protected void addUpdateMsg(GeomException geomException, byte by) {
        if (by != 10) {
            this.updateMessages.addElement(geomException);
        }
        boolean bl = geomException.getObject() instanceof Punkt ? ((Punkt)geomException.getObject()).isOn() : true;
        boolean bl2 = true;
        if (by == 12) {
            bl2 = NasIOProperties.infoInsert();
        } else if (by == 10) {
            bl2 = bl ? NasIOProperties.infoConfirm() : NasIOProperties.infoConfirmUnused();
        } else if (by == 11 || by == 13) {
            bl2 = bl ? NasIOProperties.infoUpdate() : NasIOProperties.infoUpdateUnused();
        } else if (by == 20) {
            bl2 = NasIOProperties.infoObject();
        }
        if (bl2) {
            DataBase.ERR.addElement(new ErrorObject(geomException.getLocation(), geomException.getObject(), null, geomException.getMessage(), by));
        }
    }

    private void mergeGeometry(GObject gObject) {
        int n = gObject.getOska();
        int n2 = 0;
        if (n == 11001) {
            n2 = 20;
        } else if (n == 11002) {
            n2 = 20;
        } else if (n == 31001) {
            n2 = 30;
        } else if (n == 31002) {
            n2 = 30;
        } else if (n == 31003) {
            n2 = 30;
        } else if (n == 31004) {
            n2 = 30;
        }
        LinieParameter linieParameter = gObject.getLineDefaults();
        Linie linie = null;
        Enumeration enumeration = gObject.elements();
        while (enumeration.hasMoreElements()) {
            Linie linie2 = (Linie)enumeration.nextElement();
            linie2.setDefaultParameter(linieParameter);
            if (linie2.pa != null) {
                linie2.pa = this.mergeGeometryPoint(linie2.pa.y, linie2.pa.x, n2);
            }
            if (linie2.pe != null) {
                linie2.pe = this.mergeGeometryPoint(linie2.pe.y, linie2.pe.x, n2);
            }
            linie = linie2;
        }
    }

    private Punkt mergeGeometryPoint(double d, double d2, int n) {
        ArtPoint artPoint = new ArtPoint(this, d, d2, 0.0, n);
        Punkt punkt = null;
        if (n == 0 || n == 20) {
            artPoint.pa = 20;
            punkt = (Punkt)this.koords.get(artPoint);
            if (punkt == null) {
                artPoint.pa = 30;
                punkt = (Punkt)this.koords.get(artPoint);
                if (punkt == null) {
                    artPoint.pa = 0;
                    punkt = (Punkt)this.koords.get(artPoint);
                }
            }
        } else if (n == 30 && (punkt = (Punkt)this.koords.get(artPoint)) == null) {
            artPoint.pa = 20;
            punkt = (Punkt)this.koords.get(artPoint);
            if (punkt == null) {
                artPoint.pa = 0;
                punkt = (Punkt)this.koords.get(artPoint);
            }
        }
        if (punkt.nr == 0L) {
            punkt.nr = this.getFreeNumber(DataBase.P);
            DataBase.P.put(punkt);
        }
        return punkt;
    }

    protected AX_Punktort parsePunktort(int n, XMLElement xMLElement) {
        AX_Punktort aX_Punktort = new AX_Punktort(n);
        AA_Objekt aA_Objekt = null;
        if (this.readPunktExtends) {
            aA_Objekt = new AA_Objekt();
            aX_Punktort.setObjektAttributes(aA_Objekt);
        }
        int n2 = 0;
        Enumeration enumeration = xMLElement.enumerateChildren();
        block22: while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            Integer n3 = NasReader.getAttribute(xMLElement2.getUName());
            if (n3 == null) continue;
            switch (n3) {
                case 1150: {
                    if (!this.readPunktExtends) continue block22;
                    aA_Objekt.setIdentifikator(this.parseOId(xMLElement2.getContent()));
                    break;
                }
                case 1151: {
                    if (!this.readPunktExtends) continue block22;
                    aA_Objekt.setLebenszeitintervall(this.parseLebenszeitintervall(xMLElement2.getChildrenAt(0)));
                    break;
                }
                case 1152: {
                    if (!this.readPunktExtends) continue block22;
                    aA_Objekt.addModellart(this.parseModellart(xMLElement2.getChildrenAt(0)));
                    break;
                }
                case 1153: {
                    if (!this.readPunktExtends) continue block22;
                    aA_Objekt.addAnlass(this.parseAnlass(xMLElement2));
                    break;
                }
                case 1154: {
                    if (!this.readPunktExtends) continue block22;
                    aA_Objekt.addZeigtAufExternes(this.parseFachdatenverbindung(xMLElement2.getChildrenAt(0)));
                    break;
                }
                case 1002: {
                    String string = this.parseLink(xMLElement2);
                    if (this.readPunktExtends) {
                        aA_Objekt.addIstTeilVon(string);
                    }
                    aX_Punktort.link = string;
                    break;
                }
                case 1004: {
                    aX_Punktort.kartendarstellung = Boolean.parseBoolean(xMLElement2.getContent());
                    break;
                }
                case 1003: {
                    aX_Punktort.koordinatenstatus = Short.parseShort(xMLElement2.getContent());
                    break;
                }
                case 1158: {
                    aX_Punktort.ueberpruefungsdatum = xMLElement2.getContent();
                    break;
                }
                case 1149: {
                    aX_Punktort.hinweise = xMLElement2.getContent();
                    break;
                }
                case 1005: {
                    Object object;
                    Object object2;
                    Object object3;
                    xMLElement2 = xMLElement2.getChildrenAt(0);
                    Object object4 = xMLElement2.enumerateChildren();
                    block23: while (object4.hasMoreElements()) {
                        object3 = (XMLElement)object4.nextElement();
                        n3 = NasReader.getAttribute(((XMLElement)object3).getName());
                        if (n3 == null) continue;
                        switch (n3) {
                            case 1006: {
                                if (n2 > 1) {
                                    this.addModelException();
                                }
                                ++n2;
                                object2 = ((XMLElement)object3).getChildrenAt(0);
                                object = ((XMLElement)object2).enumerateChildren();
                                while (object.hasMoreElements()) {
                                    XMLElement xMLElement3 = (XMLElement)object.nextElement();
                                    if (!xMLElement3.getName().equals("gmd:processStep")) continue;
                                    XMLElement xMLElement4 = xMLElement3.getChildrenAt(0);
                                    Enumeration enumeration2 = xMLElement4.enumerateChildren();
                                    while (enumeration2.hasMoreElements()) {
                                        XMLElement xMLElement5;
                                        XMLElement xMLElement6 = (XMLElement)enumeration2.nextElement();
                                        if (xMLElement6.countChildren() == 0) continue;
                                        String string = xMLElement6.getName();
                                        if (string.equals("gmd:description")) {
                                            xMLElement5 = xMLElement6.getChildrenAt(0);
                                            aX_Punktort.entstehungsart = (short)EntstehungsArt.parseChar(xMLElement5.getContent().charAt(0));
                                            continue;
                                        }
                                        if (string.equals("gmd:source")) {
                                            xMLElement5 = xMLElement6.getChildrenAt(0);
                                            Enumeration enumeration3 = xMLElement5.enumerateChildren();
                                            while (enumeration3.hasMoreElements()) {
                                                XMLElement xMLElement7 = (XMLElement)enumeration3.nextElement();
                                                if (!xMLElement7.getName().equals("gmd:description") || xMLElement7.countChildren() == 0) continue;
                                                XMLElement xMLElement8 = xMLElement7.getChildrenAt(0);
                                                aX_Punktort.entstehungsqual = (short)Integer.parseInt(xMLElement8.getContent());
                                            }
                                            continue;
                                        }
                                        if (!string.equals("gmd:stepDateTime")) continue;
                                        this.addModelException();
                                    }
                                }
                                continue block23;
                            }
                            case 1007: {
                                object2 = ((XMLElement)object3).getContent();
                                if (((String)object2).length() > 0) {
                                    aX_Punktort.genauigkeitswert = Float.parseFloat((String)object2);
                                    break;
                                }
                                object = ((XMLElement)object3).getChildren("gmd:DQ_RelativeInternalPositionalAccuracy/gmd:result/gmd:DQ_QuantitativeResult/gmd:value/gco:Record");
                                if (object != null) {
                                    object2 = ((XMLElement)object).getContent();
                                }
                                if (((String)object2).length() <= 0) continue block23;
                                aX_Punktort.genauigkeitswert = Float.parseFloat((String)object2);
                                break;
                            }
                            case 1008: {
                                aX_Punktort.genauigkeitsstufe = (short)Integer.parseInt(((XMLElement)object3).getContent());
                                break;
                            }
                            case 1009: {
                                aX_Punktort.lagezuverlaessigkeit = (short)(IFormat.parseBoolean(((XMLElement)object3).getContent()) ? 2 : 1);
                                break;
                            }
                            default: {
                                this.addModelException();
                            }
                        }
                    }
                    continue block22;
                }
                case 1001: {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    try {
                        int n4;
                        object4 = xMLElement2.getChildrenAt(0);
                        object3 = ((XMLElement)object4).getStringAttribute("srsName");
                        object2 = ((XMLElement)object4).getChildrenAt(0);
                        if (object3 == null) {
                            object3 = ((XMLElement)object2).getStringAttribute("srsName");
                        }
                        if (object3 != null) {
                            aX_Punktort.cooIsStandard = this.isStandardCooSystem((String)object3);
                            if (!aX_Punktort.cooIsStandard) {
                                aX_Punktort.hinweise = object3;
                            }
                        }
                        if ((n4 = ((String)(object = ((XMLElement)object2).getContent())).indexOf(" ")) < 0) {
                            aX_Punktort.z = Double.parseDouble((String)object);
                            break;
                        }
                        aX_Punktort.y = this.yAdd + Double.parseDouble(((String)object).substring(0, n4));
                        aX_Punktort.x = Double.parseDouble(((String)object).substring(n4 + 1));
                    }
                    catch (Exception exception) {
                        if (!KafPlot.debug()) continue block22;
                        exception.printStackTrace();
                    }
                    break;
                }
                default: {
                    this.addModelException();
                }
            }
        }
        return aX_Punktort;
    }

    public void addModelException() {
        this.addModelException(null);
    }

    public void addModelException(String string) {
        if (this.reportModelError) {
            this.dataModelError = true;
            Exception exception = new Exception("Unerwarteter Objektinhalt, GeoCalc-Support melden!");
            this.addException(exception);
        }
        if (string != null) {
            System.out.println("ModelException: " + string);
        }
    }

    public void addLinkException(Exception exception) {
        if (this.linkExceptionCount < this.maxLinkExceptionCount) {
            this.linkExceptions.addElement(exception);
        }
        ++this.linkExceptionCount;
    }

    public void addInitException(Exception exception) {
        this.initExceptions.addElement(exception);
    }

    private void doParse(String string) {
        if (this.threadCount == 0) {
            this.parseFeature(string);
        } else {
            if (this.parsers[this.aktBufferId].isFull()) {
                this.parsers[this.aktBufferId].work();
                while (true) {
                    this.aktBufferId = -1;
                    for (int i = 0; i < this.threadCount; ++i) {
                        if (this.parsers[i].getParseState() == 1) continue;
                        this.aktBufferId = i;
                        break;
                    }
                    if (this.aktBufferId >= 0) break;
                    this.waitOfParsers();
                }
            }
            this.parsers[this.aktBufferId].addString(string);
        }
    }

    static {
        attributes.put("position", 1001);
        attributes.put("istTeilVon", 1002);
        attributes.put("koordinatenstatus", 1003);
        attributes.put("kartendarstellung", 1004);
        attributes.put("qualitaetsangaben", 1005);
        attributes.put("herkunft", 1006);
        attributes.put("genauigkeitswert", 1007);
        attributes.put("genauigkeitsstufe", 1008);
        attributes.put("lagezuverlaessigkeit", 1009);
        attributes.put("punktkennung", 1010);
        attributes.put("art", 1011);
        attributes.put("abmarkung_Marke", 1012);
        attributes.put("vermarkung_Marke", 1013);
        attributes.put("bemerkungZurAbmarkung", 1014);
        attributes.put("sonstigeEigenschaft", 1015);
        attributes.put("punktvermarkung", 1016);
        attributes.put("dientZurDarstellungVon", 1017);
        attributes.put("drehwinkel", 1018);
        attributes.put("gemarkung", 1020);
        attributes.put("land", 1021);
        attributes.put("gemarkungsnummer", 1022);
        attributes.put("flurstuecksnummer", 1023);
        attributes.put("zaehler", 1024);
        attributes.put("nenner", 1025);
        attributes.put("flurnummer", 1026);
        attributes.put("gemeindezugehoerigkeit", 1027);
        attributes.put("istGebucht", 1028);
        attributes.put("zeigtAuf", 1029);
        attributes.put("weistAuf", 1030);
        attributes.put("gehoertAnteiligZu", 1031);
        attributes.put("beziehtSichAufFlurstueck", 1032);
        attributes.put("flurstuecksfolge", 1033);
        attributes.put("abweichenderRechtszustand", 1034);
        attributes.put("zweifelhafterFlurstuecksnachweis", 1035);
        attributes.put("rechtsbehelfsverfahren", 1036);
        attributes.put("sonstigeEigenschaften", 1037);
        attributes.put("zeitpunktDerEntstehung", 1038);
        attributes.put("zustaendigeStelle", 1039);
        attributes.put("amtlicheFlaeche", 1040);
        attributes.put("gebaeudefunktion", 1041);
        attributes.put("objekthoehe", 1042);
        attributes.put("dachform", 1043);
        attributes.put("bauweise", 1044);
        attributes.put("anzahlDerOberirdischenGeschosse", 1045);
        attributes.put("anzahlDerUnterirdischenGeschosse", 1046);
        attributes.put("hochhaus", 1047);
        attributes.put("zustand", 1048);
        attributes.put("geschossflaeche", 1049);
        attributes.put("grundflaeche", 1050);
        attributes.put("umbauterRaum", 1051);
        attributes.put("baujahr", 1052);
        attributes.put("lageZurErdoberflaeche", 1053);
        attributes.put("dachart", 1054);
        attributes.put("dachgeschossausbau", 1055);
        attributes.put("weitereGebaeudefunktion", 1056);
        attributes.put("name", 1057);
        attributes.put("nutzung", 1058);
        attributes.put("hat", 1059);
        attributes.put("datumDerLetztenUeberpruefung", 1060);
        attributes.put("artDerBebauung", 1061);
        attributes.put("name", 1057);
        attributes.put("zustand", 1048);
        attributes.put("funktion", 1062);
        attributes.put("foerdergut", 1063);
        attributes.put("lagergut", 1064);
        attributes.put("primaerenergie", 1065);
        attributes.put("bezeichnung", 1066);
        attributes.put("abbaugut", 1067);
        attributes.put("zweitname", 1068);
        attributes.put("bahnkategorie", 1069);
        attributes.put("nummerDerBahnstrecke", 1070);
        attributes.put("art", 1011);
        attributes.put("nutzung", 1058);
        attributes.put("vegetationsmerkmal", 1071);
        attributes.put("oberflaechenmaterial", 1072);
        attributes.put("gewaesserkennziffer", 1073);
        attributes.put("hydrologischesMerkmal", 1074);
        attributes.put("tidemerkmal", 1075);
        attributes.put("kulturart", 1076);
        attributes.put("nutzungsart", 1162);
        attributes.put("bodenart", 1077);
        attributes.put("zustandsstufe", 1163);
        attributes.put("bodenstufe", 1164);
        attributes.put("entstehungsart", 1165);
        attributes.put("klimastufe", 1166);
        attributes.put("wasserverhaeltnisse", 1167);
        attributes.put("zustandsstufeOderBodenstufe", 1078);
        attributes.put("bodenzahlOderGruenlandgrundzahl", 1079);
        attributes.put("ackerzahlOderGruenlandzahl", 1080);
        attributes.put("sonstigeAngaben", 1081);
        attributes.put("jahreszahl", 1082);
        attributes.put("entstehungsartOderKlimastufeWasserverhaeltnisse", 1083);
        attributes.put("lagebezeichnung", 1084);
        attributes.put("hausnummer", 1085);
        attributes.put("pseudonummer", 1086);
        attributes.put("laufendeNummer", 1087);
        attributes.put("land", 1021);
        attributes.put("regierungsbezirk", 1088);
        attributes.put("kreis", 1089);
        attributes.put("gemeinde", 1090);
        attributes.put("lage", 1091);
        attributes.put("buchungsblattkennzeichen", 1092);
        attributes.put("bestehtAus", 1093);
        attributes.put("buchungsart", 1094);
        attributes.put("anteil", 1095);
        attributes.put("nummerImAufteilungsplan", 1096);
        attributes.put("beschreibungDesSondereigentums", 1097);
        attributes.put("buchungstext", 1098);
        attributes.put("beschreibungDesUmfangsDerBuchung", 1099);
        attributes.put("istBestandteilVon", 1100);
        attributes.put("laufendeNummerNachDIN1421", 1101);
        attributes.put("nummer", 1102);
        attributes.put("artDerRechtsgemeinschaft", 1104);
        attributes.put("beschriebDerRechtsgemeinschaft", 1105);
        attributes.put("eigentuemerart", 1106);
        attributes.put("strichblattnummer", 1107);
        attributes.put("benennt", 1108);
        attributes.put("bestehtAusRechtsverhaeltnissenZu", 1109);
        attributes.put("nachnameOderFirma", 1110);
        attributes.put("anrede", 1111);
        attributes.put("vorname", 1112);
        attributes.put("namensbestandteil", 1113);
        attributes.put("akademischerGrad", 1114);
        attributes.put("geburtsname", 1115);
        attributes.put("geburtsdatum", 1116);
        attributes.put("wohnortOderSitz", 1117);
        attributes.put("beruf", 1118);
        attributes.put("haushaltsstelleLandesgrundbesitz", 1119);
        attributes.put("wirdVertretenVon", 1120);
        attributes.put("besitzt", 1121);
        attributes.put("ort_Post", 1122);
        attributes.put("postleitzahlPostzustellung", 1123);
        attributes.put("postleitzahlPostfach", 1124);
        attributes.put("bestimmungsland", 1125);
        attributes.put("ortsteil", 1126);
        attributes.put("strasse", 1127);
        attributes.put("ort_AmtlichesOrtsnamensverzeichnis", 1128);
        attributes.put("postfach", 1129);
        attributes.put("fax", 1130);
        attributes.put("telefon", 1131);
        attributes.put("weitereAdressen", 1132);
        attributes.put("an", 1133);
        attributes.put("bauart", 1134);
        attributes.put("durchfahrtshoehe", 1135);
        attributes.put("bauwerksfunktion", 1136);
        attributes.put("speicherinhalt", 1137);
        attributes.put("produkt", 1138);
        attributes.put("spannungsebene", 1139);
        attributes.put("sportart", 1140);
        attributes.put("archaeologischerTyp", 1141);
        attributes.put("hydrologischesMerkmal", 1142);
        attributes.put("kilometerangabe", 1143);
        attributes.put("markierung", 1144);
        attributes.put("bahnhofskategorie", 1145);
        attributes.put("bewuchs", 1146);
        attributes.put("hoeheDesWasserspiegels", 1147);
        attributes.put("artDerGelaendekante", 1148);
        attributes.put("hinweise", 1149);
        attributes.put("identifier", 1150);
        attributes.put("lebenszeitintervall", 1151);
        attributes.put("modellart", 1152);
        attributes.put("anlass", 1153);
        attributes.put("zeigtAufExternes", 1154);
        attributes.put("gehoertZu", 1155);
        attributes.put("beziehtSichAuf", 1156);
        attributes.put("mit", 1157);
        attributes.put("ueberpruefungsdatum", 1158);
        attributes.put("vertritt", 1159);
        attributes.put("haengtAn", 1160);
        attributes.put("uebtAus", 1161);
        attributes.put("skalierung", 1168);
        attributes.put("horizontaleAusrichtung", 1169);
        attributes.put("vertikaleAusrichtung", 1170);
        attributes.put("signaturnummer", 1171);
        attributes.put("schriftinhalt", 1172);
        attributes.put("fontSperrung", 1173);
        WFS_NORMAL = 0;
        WFS_INSERT = 1;
        WFS_REPLACE = 2;
        WFS_DELETE = 3;
        NEW_NUMBER = 0L;
        pnrReduction = 300000000000000L;
        yAddition = 3000000.0;
        INSERT_START_LENGTH = INSERT_START.length();
        REPLACE1_START_LENGTH = REPLACE1_START.length();
        REPLACE2_START_LENGTH = REPLACE2_START.length();
        DELETE_START_LENGTH = DELETE_START.length();
        INSERT_END_LENGTH = INSERT_END.length();
        REPLACE1_END_LENGTH = REPLACE1_END.length();
        REPLACE2_END_LENGTH = REPLACE2_END.length();
        DELETE_END_LENGTH = DELETE_END.length();
        RESERVE_ERG_START_LENGTH = RESERVE_ERG_START.length();
        RESERVE_ERG_END_LENGTH = RESERVE_ERG_END.length();
    }

    private class Parser
    extends Thread {
        public static final int WAIT = 0;
        public static final int WORK = 1;
        public static final int ENDS = 2;
        public static final int KILL = 9;
        private final int MAX_BUFFER_SIZE = 500;
        private final int WAIT_PRIORITY = 1;
        private final int PARSE_PRIORITY = 3;
        private Vector buffer;
        private boolean doWork = false;
        private boolean doStop = false;
        private boolean doKill = false;
        private int state = 0;
        private int id = 0;

        Parser(int n) {
            this.id = n;
            this.buffer = new Vector(500);
            this.setPriority(1);
        }

        public int getParseState() {
            return this.state;
        }

        public int bufferSize() {
            return this.buffer.size();
        }

        public boolean isFull() {
            return this.buffer.size() >= 500;
        }

        @Override
        public final void run() {
            try {
                while (true) {
                    if (this.doKill) {
                        this.state = this.buffer.size() > 0 ? 9 : 2;
                        this.buffer.clear();
                        return;
                    }
                    if (this.doWork || this.doStop) {
                        this.state = 1;
                        for (int i = 0; i < this.buffer.size(); ++i) {
                            NasReader.this.parseFeature((String)this.buffer.elementAt(i));
                        }
                        this.buffer.removeAllElements();
                        if (this.doStop) {
                            this.state = 2;
                            return;
                        }
                        this.state = 0;
                        this.setPriority(1);
                        this.doWork = false;
                        continue;
                    }
                    try {
                        Thread.sleep(30L);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.kill();
                return;
            }
        }

        public final void addString(String string) {
            this.buffer.addElement(string);
        }

        public final void work() {
            this.doWork = true;
            this.setPriority(3);
        }

        public final void close() {
            this.doStop = true;
        }

        public final void kill() {
            this.doKill = true;
        }
    }

    private class ObjektOrt
    extends DPoint {
        String id;
        String text;
        String hat;
        float angle;
        float scale;
        float width;
        short sign;
        byte art;
        byte cnt = 0;

        public ObjektOrt(NasReader nasReader, int n, XMLElement xMLElement) throws Exception {
            Enumeration enumeration = xMLElement.enumerateChildren();
            block24: while (enumeration.hasMoreElements()) {
                XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
                Integer n2 = attributes.get(xMLElement2.getUName());
                if (n2 == null) continue;
                switch (n2) {
                    case 1150: 
                    case 1151: 
                    case 1152: 
                    case 1153: 
                    case 1154: {
                        break;
                    }
                    case 1017: {
                        this.id = nasReader.parseLink(xMLElement2);
                        break;
                    }
                    case 1018: {
                        try {
                            this.angle = Float.parseFloat(xMLElement2.getContent());
                            break;
                        }
                        catch (Exception exception) {
                            throw new Exception("Unlesbares Zahlenformat: " + xMLElement2.getContent());
                        }
                    }
                    case 1001: {
                        XMLElement xMLElement3 = null;
                        switch (n) {
                            case 2300: 
                            case 2330: 
                            case 2340: 
                            case 2341: {
                                xMLElement3 = xMLElement2.getChildren("gml:Point/gml:pos");
                                break;
                            }
                            case 2310: {
                                xMLElement3 = xMLElement2.getChildren("gml:MultiPoint/gml:pointMember/gml:Point/gml:pos");
                                break;
                            }
                            case 2320: {
                                xMLElement3 = xMLElement2.getChildren("gml:MultiCurve/gml:curveMember/gml:Curve/gml:segments/gml:LineStringSegment/gml:posList");
                                break;
                            }
                            case 2342: {
                                xMLElement3 = xMLElement2.getChildren("gml:Curve/gml:segments/gml:LineStringSegment/gml:posList");
                            }
                        }
                        if (xMLElement3 != null) {
                            StringTokenizer stringTokenizer = new StringTokenizer(xMLElement3.getContent(), " ");
                            int n3 = stringTokenizer.countTokens();
                            if (n3 > 1) {
                                try {
                                    this.y = nasReader.yAdd + Double.parseDouble(stringTokenizer.nextToken());
                                    this.x = Double.parseDouble(stringTokenizer.nextToken());
                                    break;
                                }
                                catch (Exception exception) {
                                    throw new Exception("Objektort " + xMLElement.getStringAttribute("gml:id") + " unlesbares Koordinatenformat: " + xMLElement3.getContent());
                                }
                            }
                            throw new Exception("Objektort " + xMLElement.getStringAttribute("gml:id") + " Position ohne Koordinaten");
                        }
                        throw new Exception("Objektort " + xMLElement.getStringAttribute("gml:id") + " ohne Point: " + xMLElement.getStringAttribute("gml:id"));
                    }
                    case 1011: {
                        this.art = Alkis.getOrtArt(xMLElement2.getContent());
                        break;
                    }
                    case 1059: {
                        this.hat = nasReader.parseLink(xMLElement2);
                        break;
                    }
                    case 1168: {
                        this.scale = Float.parseFloat(xMLElement2.getContent());
                        break;
                    }
                    case 1169: {
                        if (xMLElement2.getContent().equals("zentrisch")) {
                            this.cnt = (byte)(this.cnt + 1);
                            break;
                        }
                        if (!xMLElement2.getContent().equals("rechtsb\u00fcndig")) continue block24;
                        this.cnt = (byte)(this.cnt + 2);
                        break;
                    }
                    case 1170: {
                        if (xMLElement2.getContent().equals("Mitte")) {
                            this.cnt = (byte)(this.cnt + 3);
                            break;
                        }
                        if (!xMLElement2.getContent().equals("oben")) continue block24;
                        this.cnt = (byte)(this.cnt + 6);
                        break;
                    }
                    case 1171: {
                        this.sign = Short.parseShort(xMLElement2.getContent());
                        break;
                    }
                    case 1172: {
                        this.text = xMLElement2.getContent();
                        break;
                    }
                    case 1173: {
                        this.width = Float.parseFloat(xMLElement2.getContent());
                        break;
                    }
                    default: {
                        System.out.println(xMLElement2.getName());
                    }
                }
            }
        }
    }

    private class AX_Vertretung {
        private String haengtAn;
        private Vector<String> vertritt;

        private AX_Vertretung(NasReader nasReader) {
        }
    }

    private class AX_Buchungsstelle {
        int buchungsart;
        String laufendeNummer;
        String anteil;
        String nummerImAufteilungsplan;
        String beschreibungDesSondereigentums;
        String buchungstext;
        String beschreibungDesUmfangsDerBuchung;
        String istBestandteilVon;
        String an = "";
        String weitereStelle = "";
        String bestehtAus = "";

        private AX_Buchungsstelle(NasReader nasReader) {
        }
    }

    private class ArtPoint
    extends DPoint3D {
        int pa = 0;

        public ArtPoint(NasReader nasReader, double d, double d2, double d3, int n) {
            super(d, d2, d3);
            this.pa = n;
        }

        @Override
        public int hashCode() {
            return (int)((this.y + this.x + this.z) * 100.0 + (double)this.pa);
        }

        @Override
        public boolean equals(Object object) {
            ArtPoint artPoint = (ArtPoint)object;
            return super.equals(artPoint) && this.pa == artPoint.pa;
        }

        @Override
        public String toString() {
            return this.y + " " + this.x + " " + this.z + " " + this.pa;
        }
    }

    private class Reader
    extends Thread {
        File file;
        public boolean is = false;

        Reader(File file) {
            this.file = file;
        }

        @Override
        public final void run() {
            try {
                NasReader.this.readNasFile(this.file);
                this.is = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

