/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.io.IPolarReader;
import de.geocalc.kafplot.io.PolarMessung;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class NikonReader
extends IPolarReader {
    int anzZpk = 0;
    private PolarMessung s = new PolarMessung();

    public NikonReader(File file, Vector vector) {
        this(file, vector, null);
    }

    public NikonReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
    }

    @Override
    protected PolarMessung lineToPolarMessung(String string) throws IFileInputException, IOException {
        if (string.startsWith("*")) {
            return null;
        }
        if (string.startsWith("CO")) {
            if (string.indexOf("<JOB>") >= 0) {
                return new PolarMessung(string.substring(3));
            }
            return null;
        }
        if (string.startsWith("UP")) {
            return null;
        }
        if (string.startsWith("MP")) {
            return null;
        }
        if (string.startsWith("MC")) {
            return null;
        }
        if (string.startsWith("CC")) {
            return null;
        }
        if (string.startsWith("RE")) {
            return null;
        }
        if (string.startsWith("ST")) {
            this.s = this.readStandpunkt(string);
            if (this.s.pnz != 0L) {
                this.anzZpk = 1;
                return this.s;
            }
        } else {
            if (string.startsWith("CP")) {
                PolarMessung polarMessung = this.readKontrollpunkt(string);
                polarMessung.pns = this.anzZpk == 0 ? this.s.pns : 0L;
                ++this.anzZpk;
                return polarMessung;
            }
            if (string.startsWith("SS") || string.startsWith("F1")) {
                PolarMessung polarMessung = this.readZielpunkt(string);
                polarMessung.pns = this.anzZpk == 0 ? this.s.pns : 0L;
                ++this.anzZpk;
                return polarMessung;
            }
            if (string.startsWith("F2")) {
                throw new IFileInputException("F2-Datens\u00e4tze werden noch nicht unterst\u00fctzt");
            }
            throw new IFileInputException("unbekannte ZeilenKennung");
        }
        this.anzZpk = 0;
        return null;
    }

    private PolarMessung readStandpunkt(String string) throws IFileInputException {
        PolarMessung polarMessung = new PolarMessung();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
        int n = 0;
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(",")) {
                if (bl) {
                    ++n;
                }
                bl = true;
                continue;
            }
            bl = false;
            switch (n++) {
                case 0: {
                    break;
                }
                case 1: {
                    try {
                        polarMessung.pns = Long.parseLong(string2);
                        break;
                    }
                    catch (Exception exception) {
                        throw new IFileInputException("Element Standpunktnummer");
                    }
                }
                case 2: {
                    break;
                }
                case 3: {
                    try {
                        polarMessung.pnz = Long.parseLong(string2);
                    }
                    catch (Exception exception) {
                        polarMessung.pnz = 0L;
                    }
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    try {
                        polarMessung.r = new Double(string2);
                    }
                    catch (Exception exception) {
                        polarMessung.r = 0.0;
                    }
                    break;
                }
            }
        }
        return polarMessung;
    }

    private PolarMessung readZielpunkt(String string) throws IFileInputException {
        PolarMessung polarMessung = new PolarMessung();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
        int n = 0;
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(",")) {
                if (bl) {
                    ++n;
                }
                bl = true;
                continue;
            }
            bl = false;
            switch (n++) {
                case 0: {
                    break;
                }
                case 1: {
                    try {
                        polarMessung.pnz = Long.parseLong(string2);
                        break;
                    }
                    catch (Exception exception) {
                        throw new IFileInputException("Element Punktnummer");
                    }
                }
                case 2: {
                    break;
                }
                case 3: {
                    try {
                        polarMessung.s = new Double(string2);
                        break;
                    }
                    catch (Exception exception) {
                        throw new IFileInputException("Element Strecke");
                    }
                }
                case 4: {
                    try {
                        polarMessung.r = new Double(string2);
                        break;
                    }
                    catch (Exception exception) {
                        throw new IFileInputException("Element Richtung");
                    }
                }
                case 5: {
                    try {
                        polarMessung.z = new Double(string2);
                        break;
                    }
                    catch (Exception exception) {
                        throw new IFileInputException("Element Zenit");
                    }
                }
            }
        }
        return polarMessung;
    }

    private PolarMessung readKontrollpunkt(String string) throws IFileInputException {
        PolarMessung polarMessung = new PolarMessung();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
        int n = 0;
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(",")) {
                if (bl) {
                    ++n;
                }
                bl = true;
                continue;
            }
            bl = false;
            switch (n++) {
                case 0: {
                    break;
                }
                case 1: {
                    try {
                        polarMessung.pnz = Long.parseLong(string2);
                        break;
                    }
                    catch (Exception exception) {
                        throw new IFileInputException("Element Punktnummer");
                    }
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    try {
                        polarMessung.s = new Double(string2);
                        break;
                    }
                    catch (Exception exception) {
                        throw new IFileInputException("Element Strecke");
                    }
                }
                case 5: {
                    try {
                        polarMessung.r = new Double(string2);
                        break;
                    }
                    catch (Exception exception) {
                        throw new IFileInputException("Element Richtung");
                    }
                }
                case 6: {
                    try {
                        polarMessung.z = new Double(string2);
                        break;
                    }
                    catch (Exception exception) {
                        throw new IFileInputException("Element Zenit");
                    }
                }
            }
        }
        return polarMessung;
    }
}

