/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.kafplot.io.IMessung;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.text.IFormat;

public class NivMessung
extends IMessung {
    public long pns;
    public long pnz;
    public double dh;
    public double s;
    public double ph;
    public double ps;
    String kommentar;

    public NivMessung(long l, long l2, double d, double d2, double d3, double d4) {
        this.pns = l;
        this.pnz = l2;
        this.dh = d;
        this.s = d2;
        this.ph = d3;
        this.ps = d4;
    }

    public NivMessung(String string) {
        this.kommentar = string;
    }

    public String toDatLine() {
        return null;
    }

    public String toDatHoeheLine() {
        StringBuffer stringBuffer = new StringBuffer();
        if (KafkaIOProperties.datVersion < 2) {
            return "C H\u00f6hen werden erst ab DAT_VERSION 1.4 unterst\u00fctzt";
        }
        if (this.pns == 0L && this.pnz == 0L) {
            stringBuffer.append("C ");
            stringBuffer.append(this.kommentar != null ? this.kommentar : "");
        } else {
            stringBuffer.append("1");
            stringBuffer.append(" ");
            stringBuffer.append(" ");
            if (this.pns != 0L) {
                stringBuffer.append(IFormat.i14.format(this.pns));
            } else {
                stringBuffer.append("              ");
            }
            stringBuffer.append(" ");
            if (this.pnz != 0L) {
                stringBuffer.append(IFormat.i14.format(this.pnz));
            } else {
                stringBuffer.append("              ");
            }
            stringBuffer.append(IFormat.f3_6.format(this.dh));
            stringBuffer.append(" ");
            stringBuffer.append(IFormat.f3_6.format(this.s / 1000.0));
            stringBuffer.append("   ");
            stringBuffer.append(IFormat.f_4.format(this.ph));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(IFormat.i.format(this.pns).toString());
        stringBuffer.append("-");
        stringBuffer.append(IFormat.i.format(this.pnz).toString());
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f_3.format(this.dh).toString());
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f_3.format(this.s).toString());
        return stringBuffer.toString();
    }
}

