/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DatContainer;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainerTable;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.FlurstueckArt;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.GebaeudeKennzeichen;
import de.geocalc.kafplot.Lage;
import de.geocalc.kafplot.TopObject;
import de.geocalc.kafplot.io.IFileWriter;
import de.geocalc.text.IFormat;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class ObjectListWriter
extends IFileWriter {
    protected DataBase db;
    private boolean isCorrectSaved = true;
    public static boolean writeFlst = true;
    public static boolean writeGeb = true;
    public static boolean writeTop = false;

    public ObjectListWriter(File file, DataBase dataBase) {
        super(file);
        this.db = dataBase;
    }

    @Override
    public void write() throws IFileOutputException {
        PrintWriter printWriter = null;
        try {
            GObject gObject;
            Enumeration enumeration;
            int n = 0;
            if (writeFlst) {
                n += DataBase.FLST.size();
            }
            if (writeGeb) {
                n += DataBase.GEB.size();
            }
            if (writeTop) {
                n += DataBase.TOP.size();
            }
            int n2 = n / 20;
            this.setBorderValues(0L, n);
            this.showProgress(false);
            printWriter = this.createWriter();
            int n3 = 0;
            printWriter.println("#KafPlot ObjectListe");
            if (writeFlst) {
                printWriter.println("[Flurst\u00fccke]");
                printWriter.println(IFormat.getLeftString("#Flurst\u00fcckskennzeichen", 30) + "         Y          X   OSKA  Buchfl\u00e4che   Istfl\u00e4che    %  Fortf\u00fchrung");
                enumeration = DataBase.FLST.elements();
                while (enumeration.hasMoreElements()) {
                    gObject = (Flurstueck)enumeration.nextElement();
                    if (((Flurstueck)gObject).isFlurstueck() || ((Flurstueck)gObject).isTeilstueck()) {
                        printWriter.print(IFormat.getLeftString(((Flurstueck)gObject).toLongKennzeichen(), 30));
                        printWriter.print("  ");
                        printWriter.print(IFormat.f7_1.format(((Flurstueck)gObject).y));
                        printWriter.print("  ");
                        printWriter.print(IFormat.f7_1.format(((Flurstueck)gObject).x));
                        printWriter.print("  ");
                        printWriter.print(IFormat.i04.format(gObject.getOska()));
                        printWriter.print("  ");
                        double d = ((Flurstueck)gObject).getBuchFlaeche();
                        if (d != 0.0) {
                            printWriter.print(IFormat.f7_2.format(d));
                        } else {
                            printWriter.print("          ");
                        }
                        printWriter.print("  ");
                        double d2 = ((Flurstueck)gObject).getGeoFlaeche();
                        if (d2 != 0.0) {
                            printWriter.print(IFormat.f7_2.format(d2));
                        } else {
                            printWriter.print("          ");
                        }
                        printWriter.print("  ");
                        if (d != 0.0 && d2 != 0.0) {
                            printWriter.print(IFormat.i3.format(Math.rint(d2 / d * 100.0)));
                        } else {
                            printWriter.print("   ");
                        }
                        printWriter.print("  ");
                        Flurstueck flurstueck = DataBase.ALB.getFlurstueck((Flurstueck)gObject);
                        if (flurstueck != null && FlurstueckArt.isFlurstueck(((Flurstueck)gObject).getArt()) && FlurstueckArt.isFortfuehrung(((Flurstueck)gObject).getArt())) {
                            if (FlurstueckArt.getTeil(((Flurstueck)gObject).getArt()) == 8) {
                                printWriter.print("TEIL");
                            } else {
                                printWriter.print("    ");
                                Lage lage = (Lage)((Flurstueck)gObject).getLage();
                                Lage lage2 = (Lage)flurstueck.getLage();
                                if (!(lage == null || lage2 == null || lage.toDatString().equals(lage2.toDatString()) && lage.getBezeichnung().equals(lage2.getBezeichnung()))) {
                                    printWriter.print(" LAGE");
                                } else {
                                    printWriter.print("     ");
                                }
                                boolean bl = false;
                                if (FlurstueckArt.getTeil(((Flurstueck)gObject).getArt()) == 9) {
                                    Vector vector = DataBase.FLST.getNutzstueckeFrom((Flurstueck)gObject);
                                    Vector vector2 = DataBase.ALB.getNutzstueckeFrom((Flurstueck)gObject);
                                    if (vector.size() != vector2.size()) {
                                        bl = true;
                                    } else {
                                        for (int i = 0; i < vector.size(); ++i) {
                                            Flurstueck flurstueck2 = (Flurstueck)vector.elementAt(i);
                                            Flurstueck flurstueck3 = (Flurstueck)vector2.elementAt(i);
                                            if (flurstueck2.getNutzung() == flurstueck3.getNutzung()) continue;
                                            bl = true;
                                            break;
                                        }
                                    }
                                } else {
                                    boolean bl2 = bl = ((Flurstueck)gObject).getNutzung() != flurstueck.getNutzung();
                                }
                                if (bl) {
                                    printWriter.print(" NUTZ");
                                } else {
                                    printWriter.print("     ");
                                }
                            }
                        }
                        printWriter.println("");
                    }
                    if (++n3 % n2 != 0) continue;
                    this.showProgress(n3);
                }
            }
            if (writeGeb) {
                printWriter.println("[Geb\u00e4ude]");
                enumeration = DataBase.GEB.elements();
                while (enumeration.hasMoreElements()) {
                    gObject = (Gebaeude)enumeration.nextElement();
                    GebaeudeKennzeichen gebaeudeKennzeichen = ((Gebaeude)gObject).getLeitzeichen();
                    if (gebaeudeKennzeichen != null) {
                        printWriter.print(IFormat.getLeftString(gebaeudeKennzeichen != null ? gebaeudeKennzeichen.getObjectName() : "ohne Kennzeichen", 30));
                        printWriter.print("  ");
                        printWriter.print(IFormat.f7_1.format(((Gebaeude)gObject).y));
                        printWriter.print("  ");
                        printWriter.print(IFormat.f7_1.format(((Gebaeude)gObject).x));
                        printWriter.print("  ");
                        printWriter.print(IFormat.i04.format(gObject.getOska()));
                        printWriter.println("");
                    }
                    if (++n3 % n2 != 0) continue;
                    this.showProgress(n3);
                }
            }
            if (writeTop) {
                printWriter.println("[Topographie]");
                enumeration = DataBase.TOP.elements();
                while (enumeration.hasMoreElements()) {
                    gObject = (TopObject)enumeration.nextElement();
                    printWriter.println(((TopObject)gObject).getObjectName());
                    if (++n3 % n2 != 0) continue;
                    this.showProgress(n3);
                }
            }
            this.setProgress(100);
        }
        catch (IOException iOException) {
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
        finally {
            try {
                printWriter.close();
                this.isCorrectSaved = true;
            }
            catch (Exception exception) {}
        }
    }

    public boolean isCorrectSaved() {
        return this.isCorrectSaved;
    }

    private void writeDatContainer(PrintWriter printWriter, DataContainerTable dataContainerTable) throws IOException {
        Enumeration enumeration = dataContainerTable.elements();
        while (enumeration.hasMoreElements()) {
            ((DatContainer)enumeration.nextElement()).writeDatContainer(printWriter);
        }
    }
}

