/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.io.IPolarReader;
import de.geocalc.kafplot.io.PolarMessung;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class P_SoftReader
extends IPolarReader {
    int anzZpk = 0;
    private PolarMessung s = new PolarMessung();

    public P_SoftReader(File file, Vector vector) {
        super(file, vector, null);
    }

    public P_SoftReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
    }

    @Override
    protected PolarMessung lineToPolarMessung(String string) throws IOException, IFileInputException {
        if (string.length() < 1) {
            return null;
        }
        PolarMessung polarMessung = new PolarMessung();
        if (string.charAt(0) != ' ') {
            int n = 0;
            try {
                Integer n2 = new Integer(string.substring(0, string.length() == 1 ? 1 : 2).trim());
                n = n2;
            }
            catch (Exception exception) {
                return new PolarMessung(string);
            }
            switch (n) {
                case 1: {
                    this.s = this.readStandpunkt(this.s, string);
                    this.anzZpk = 0;
                    return null;
                }
                case 2: 
                case 3: {
                    polarMessung.rh = Double.MIN_VALUE;
                    polarMessung = this.readMessung(polarMessung, string);
                    polarMessung.pns = this.anzZpk == 0 ? this.s.pns : 0L;
                    if (polarMessung.rh != Double.MIN_VALUE && IPolarReader.ignoreR0()) {
                        if (polarMessung.rh != 0.0) {
                            polarMessung.rh = this.s.rh == 0.0 ? 1.0E-5 : this.s.rh;
                        }
                    } else {
                        polarMessung.rh = this.s.rh;
                    }
                    polarMessung.ih = this.s.ih;
                    if (polarMessung.r == 0.0 && this.anzZpk > 0) {
                        throw new IFileInputException("Null-Richtung im Richtungssatz");
                    }
                    if (polarMessung.pns == 0L && this.anzZpk == 0) {
                        throw new IFileInputException("Fehlender Standpunkt");
                    }
                    ++this.anzZpk;
                    break;
                }
                case 4: 
                case 5: {
                    polarMessung.pns = 0L;
                    return null;
                }
                case 9: {
                    return new PolarMessung(string.substring(1, string.length()).trim());
                }
                case 10: 
                case 11: {
                    return null;
                }
                case 12: {
                    return new PolarMessung(string.substring(2, string.length()).trim());
                }
                case 13: 
                case 14: {
                    return null;
                }
            }
        } else {
            try {
                switch (string.charAt(53)) {
                    case '1': {
                        this.anzZpk = 0;
                        this.s.pns = Long.parseLong(string.substring(0, 15).trim());
                        this.s.ih = new Double(string.substring(19, 26).trim());
                        this.s.rh = new Double(string.substring(29, 36).trim());
                        return null;
                    }
                    case '2': 
                    case '3': {
                        polarMessung.pnz = Long.parseLong(string.substring(0, 15).trim());
                        polarMessung.s = new Double(string.substring(19, 26).trim());
                        polarMessung.r = new Double(string.substring(27, 36).trim());
                        polarMessung.z = new Double(string.substring(36, 45).trim());
                        polarMessung.rh = Double.MIN_VALUE;
                        this.readRH(polarMessung, string, 54);
                        long l = polarMessung.pns = this.anzZpk == 0 ? this.s.pns : 0L;
                        if (polarMessung.rh != Double.MIN_VALUE) {
                            if (!P_SoftReader.isIgnoreR(polarMessung.rh)) {
                                polarMessung.rh = this.s.rh == 0.0 ? 1.0E-5 : this.s.rh;
                            }
                        } else {
                            polarMessung.rh = this.s.rh;
                        }
                        polarMessung.ih = this.s.ih;
                        if (polarMessung.r == 0.0 && this.anzZpk > 0) {
                            throw new IFileInputException("Null-Richtung im Richtungssatz");
                        }
                        if (polarMessung.pns == 0L && this.anzZpk == 0) {
                            throw new IFileInputException("Fehlender Standpunkt");
                        }
                        ++this.anzZpk;
                    }
                }
            }
            catch (Exception exception) {
                return new PolarMessung(string);
            }
        }
        return polarMessung;
    }

    private PolarMessung readStandpunkt(PolarMessung polarMessung, String string) throws IFileInputException {
        try {
            Long l = new Long(string.substring(3, 17).trim());
            polarMessung.pns = l;
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Punktnummer");
        }
        Double d = new Double(string.substring(22, 29).trim());
        polarMessung.ih = d;
        d = new Double(string.substring(33, string.length()).trim());
        polarMessung.rh = d;
        return polarMessung;
    }

    private PolarMessung readMessung(PolarMessung polarMessung, String string) throws IFileInputException {
        Double d;
        try {
            Long l = new Long(string.substring(3, 17).trim());
            polarMessung.pnz = l;
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Punktnummer");
        }
        try {
            d = new Double(string.substring(20, 29).trim());
            polarMessung.s = d;
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Strecke");
        }
        try {
            d = new Double(string.substring(30, 39).trim());
            polarMessung.r = d;
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Richtung");
        }
        try {
            d = new Double(string.substring(40, 48).trim());
            polarMessung.z = d;
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Zenit");
        }
        this.readRH(polarMessung, string, 50);
        return polarMessung;
    }

    private void readRH(PolarMessung polarMessung, String string, int n) throws IFileInputException {
        String string2 = string.substring(n, string.indexOf("*")).trim();
        if (string2.length() > 0) {
            boolean bl = false;
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < string2.length(); ++i) {
                switch (string2.charAt(i)) {
                    case 'R': 
                    case 'r': {
                        n2 = i + 1;
                        break;
                    }
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (n2 <= 0) break;
                        n3 = i + 1;
                        break;
                    }
                    default: {
                        if (n2 <= 0) break;
                        bl = true;
                    }
                }
                if (bl) break;
            }
            if (n2 > 0 && n3 > 0) {
                try {
                    polarMessung.rh = new Double(string2.substring(n2, n3));
                }
                catch (Exception exception) {
                    throw new IFileInputException("Element Reflektorh\u00f6he");
                }
            }
        }
    }
}

