/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.kafplot.EntstehungsArt;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktArt;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.PunktParameterALK;
import de.geocalc.kafplot.PunktParameterALKIS;
import de.geocalc.kafplot.io.IKatPunktReader;
import de.geocalc.kataster.KatasterStatus;
import de.geocalc.text.IFormat;
import de.geocalc.util.LongHashList;
import java.io.File;
import java.util.Vector;

public class PdkReader
extends IKatPunktReader {
    private static int datVersion = 0;
    private static int model = 0;

    public PdkReader(File file, LongHashList longHashList) {
        super(file, longHashList, null);
        datVersion = 0;
    }

    public PdkReader(File file, LongHashList longHashList, IProgressViewer iProgressViewer) {
        super(file, longHashList, iProgressViewer);
        datVersion = 0;
    }

    public PdkReader(File file, Vector vector) {
        super(file, vector, null);
        datVersion = 0;
    }

    public PdkReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
        datVersion = 0;
    }

    @Override
    protected Punkt lineToPunkt(String string) {
        Punkt punkt;
        if (datVersion == 0) {
            if (string.charAt(25) == '.') {
                datVersion = 2;
            } else if (string.charAt(24) == '.') {
                datVersion = 1;
            } else {
                throw new NumberFormatException("Ung\u00fcltige Zeilenformat");
            }
        }
        if ((punkt = PdkReader.stringToPunkt(string)) != null) {
            punkt.nr = punkt.buildKatNr(this.getPnrModus());
        }
        return punkt;
    }

    public static Punkt stringToPunkt(String string) {
        if (datVersion == 0) {
            datVersion = 2;
        }
        Punkt punkt = new Punkt();
        PunktParameter punktParameter = null;
        int n = string.length();
        if (datVersion == 1) {
            try {
                punkt.setPs(Integer.parseInt(string.substring(0, 1)));
            }
            catch (NumberFormatException numberFormatException) {
                punkt.setPs(-9);
            }
            punkt.nr = Long.parseLong(string.substring(2, 15).trim());
            punkt.y = new Double(string.substring(17, 28).trim());
            punkt.x = new Double(string.substring(30, 41).trim());
            try {
                punkt.h = (float)new Double(string.substring(48, 57).trim()).doubleValue();
            }
            catch (Exception exception) {
                punkt.h = 0.0f;
            }
            try {
                double d = new Double(string.substring(42, 47).trim());
                if (d > 0.0) {
                    punkt.b = punkt.a = (int)((short)Math.max((int)(d / 0.001414213562), 1));
                }
            }
            catch (Exception exception) {
                punkt.a = 0;
                punkt.b = 0;
            }
            punktParameter = new PunktParameterALK();
            try {
                punktParameter.setPa(Integer.parseInt(string.substring(58, 59).trim()));
            }
            catch (Exception exception) {
                punktParameter.setPa(-1);
            }
            try {
                punktParameter.setVa(Integer.parseInt(string.substring(61, 64).trim()));
            }
            catch (Exception exception) {
                punktParameter.setVa(0);
            }
            try {
                punktParameter.setLs(Integer.parseInt(string.substring(66, 69).trim()));
            }
            catch (Exception exception) {
                punktParameter.setLs(0);
            }
            try {
                punktParameter.setLg(string.charAt(71));
            }
            catch (Exception exception) {
                punktParameter.setLg(0);
            }
            try {
                punktParameter.setHs(Integer.parseInt(string.substring(74, 77).trim()));
            }
            catch (Exception exception) {
                punktParameter.setHs(0);
            }
            try {
                punktParameter.setHg(Integer.parseInt(string.substring(79, 80)));
            }
            catch (Exception exception) {
                punktParameter.setHg(0);
            }
            try {
                punktParameter.setEb(Integer.parseInt(string.substring(82, 84).trim()));
            }
            catch (Exception exception) {
                punktParameter.setEb(0);
            }
            try {
                punktParameter.setVvt(Integer.parseInt(string.substring(86, 88).trim()));
            }
            catch (Exception exception) {
                punktParameter.setVvt(0);
            }
            try {
                punktParameter.setVva(Integer.parseInt(string.substring(90, 93).trim()));
            }
            catch (Exception exception) {
                punktParameter.setVva(0);
            }
            try {
                punktParameter.setLz(Integer.parseInt(string.substring(95, 96)));
            }
            catch (Exception exception) {
                punktParameter.setLz(0);
            }
            try {
                punktParameter.setOska(Integer.parseInt(string.substring(98, 102)));
            }
            catch (Exception exception) {
                punktParameter.setOska(0);
            }
        } else if (datVersion == 2) {
            try {
                punkt.setPs(Integer.parseInt(string.substring(0, 1)));
            }
            catch (NumberFormatException numberFormatException) {
                punkt.setPs(-9);
            }
            punkt.nr = Long.parseLong(string.substring(3, 17).trim());
            punkt.y = Double.valueOf(string.substring(17, 30).trim());
            punkt.x = Double.valueOf(string.substring(30, 43).trim());
            try {
                punkt.g = Float.valueOf(string.substring(43, Math.min(49, string.length())).trim()).floatValue();
            }
            catch (Exception exception) {
                punkt.g = 0.025f;
            }
            try {
                punkt.h = Float.valueOf(string.substring(50, Math.min(59, string.length())).trim()).floatValue();
            }
            catch (Exception exception) {
                punkt.h = 0.0f;
            }
            if (model == 0 && n > 60) {
                char c = string.charAt(60);
                if (Character.isDigit(c)) {
                    model = 1;
                } else if (Character.isLetter(c)) {
                    model = 2;
                } else if (n > 64 && Character.isDigit(string.charAt(64))) {
                    model = 1;
                } else if (n > 69 && Character.isDigit(string.charAt(69))) {
                    model = 2;
                } else if (n > 70 && Character.isDigit(string.charAt(70))) {
                    model = 1;
                } else if (n > 80 && Character.isLetter(string.charAt(80))) {
                    model = 2;
                } else if (n > 91 && Character.isDigit(string.charAt(91))) {
                    model = 1;
                } else if (n > 95 && Character.isDigit(string.charAt(95))) {
                    model = 2;
                } else if (n > 98 && Character.isDigit(string.charAt(98))) {
                    model = 2;
                }
            }
            if (model == 2) {
                if (n > 60) {
                    try {
                        punktParameter = new PunktParameterALKIS();
                        String string2 = string.substring(60, Math.min(n, 65));
                        punktParameter.setPa(PunktArt.parseString(string2));
                        punktParameter.setPst(KatasterStatus.parseString(string2));
                        punktParameter.setLg(IFormat.parseInt(string, 66, 70, 0));
                        punktParameter.setLl(IFormat.parseFloat(string, 71, 77, 1.0, 0.0f));
                        punktParameter.setLz(IFormat.parseInt(string, 78, 80, 0));
                        punktParameter.setEa(EntstehungsArt.parseChar(string.charAt(80)));
                        punktParameter.setEq(IFormat.parseInt(string, 82, 86, 0));
                        punktParameter.setArt(IFormat.parseInt(string, 87, 91, 0));
                        punktParameter.setVa(IFormat.parseInt(string, 92, 96, 0));
                        punktParameter.setVb(IFormat.parseInt(string, 97, 101, 0));
                        punktParameter.setVvt(IFormat.parseInt(string, 102, 105, 0));
                        punktParameter.setLs(IFormat.parseInt(string, 106, 110, 0));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (n > 115) {
                        punkt.setBemerkung(string.substring(115).trim());
                    }
                }
            } else if (model == 1) {
                punktParameter = new PunktParameterALK();
                try {
                    punktParameter.setPa(Integer.parseInt(string.substring(60, 61).trim()));
                }
                catch (Exception exception) {
                    punktParameter.setPa(-1);
                }
                try {
                    punktParameter.setVa(Integer.parseInt(string.substring(62, 65).trim()));
                }
                catch (Exception exception) {
                    punktParameter.setVa(0);
                }
                try {
                    punktParameter.setLs(Integer.parseInt(string.substring(66, 69).trim()));
                }
                catch (Exception exception) {
                    punktParameter.setLs(0);
                }
                try {
                    punktParameter.setLg(string.charAt(70));
                }
                catch (Exception exception) {
                    punktParameter.setLg(0);
                }
                try {
                    punktParameter.setHs(Integer.parseInt(string.substring(72, 75).trim()));
                }
                catch (Exception exception) {
                    punktParameter.setHs(0);
                }
                try {
                    punktParameter.setHg(Integer.parseInt(string.substring(76, 77)));
                }
                catch (Exception exception) {
                    punktParameter.setHg(0);
                }
                try {
                    punktParameter.setEb(Integer.parseInt(string.substring(78, 80).trim()));
                }
                catch (Exception exception) {
                    punktParameter.setEb(0);
                }
                try {
                    punktParameter.setVvt(Integer.parseInt(string.substring(81, 84).trim()));
                }
                catch (Exception exception) {
                    punktParameter.setVvt(0);
                }
                try {
                    punktParameter.setVva(Integer.parseInt(string.substring(85, 88).trim()));
                }
                catch (Exception exception) {
                    punktParameter.setVva(0);
                }
                try {
                    punktParameter.setLz(Integer.parseInt(string.substring(89, 90)));
                }
                catch (Exception exception) {
                    punktParameter.setLz(0);
                }
                try {
                    punktParameter.setOska(Integer.parseInt(string.substring(91, 95)));
                }
                catch (Exception exception) {
                    punktParameter.setOska(0);
                }
            }
        } else {
            return null;
        }
        if (punktParameter != null) {
            punkt.initParameter(punktParameter);
        }
        return punkt;
    }
}

