/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.MessungGewicht;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.io.IPolarReader;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;

public class PolarMessung {
    public static final int GELOESCHT = -1;
    public static final int UNGUELTIG = 0;
    public static final int MESSUNG = 1;
    public static final int ONLY_ZENIT = 3;
    public static final int KOMMENTAR = 5;
    public static final int RUECKBLICK1 = 1;
    public static final int VORBLICK1 = 2;
    public static final int ZWISCHEN = 3;
    public static final int ABSTECKUNG = 4;
    public static final int RUECKBLICK2 = 5;
    public static final int VORBLICK2 = 6;
    private static double D_NULL = 1.0E-4;
    public String kommentar;
    public int ma;
    public int nivCode = 0;
    public long pns;
    public long pnz;
    public double s;
    public double ss;
    public double r;
    public double z = 100.0;
    public double dq = 0.0;
    public double dl = 0.0;
    public double ih;
    public double rh;
    public double ppm = 0.0;
    public double pK = 0.0;
    public double dh = 0.0;
    public double pR;
    public double pS;
    public double pZ;
    public double pZS;

    public PolarMessung() {
        this(1, 0L, 0L, 0.0, 0.0, 100.0);
    }

    public PolarMessung(int n, long l, long l2, double d, double d2) {
        this(n, l, l2, d, d2, 100.0);
    }

    public PolarMessung(int n, long l, long l2, double d, double d2, double d3) {
        this.ma = n;
        this.pns = l;
        this.pnz = l2;
        this.s = d;
        this.r = d2;
        this.z = d3;
        this.pR = 1.0;
        this.pS = 1.0;
        this.pZ = 0.002;
        this.pZS = 0.01;
    }

    public PolarMessung(String string) {
        this.ma = 5;
        this.kommentar = new String(string);
    }

    private Messung toMessung() {
        Messung messung = new Messung(0, new Punkt(this.pns), new Punkt(this.pnz), this.r, this.s);
        messung.setArt(230, 3);
        return messung;
    }

    public double getRichtungDiff(PolarMessung polarMessung) {
        double d = this.r - polarMessung.r;
        if (d < -200.0) {
            return d + 400.0;
        }
        if (d > 200.0) {
            return d - 400.0;
        }
        return d;
    }

    public void setRichtungMittel(PolarMessung polarMessung) {
        this.setRichtung(this.r - this.getRichtungDiff(polarMessung) / (this.pR + polarMessung.pR));
        this.pR += polarMessung.pR;
    }

    public void setRichtung(double d) {
        this.r = d < 0.0 ? d + 400.0 : (d > 400.0 ? d - 400.0 : d);
    }

    public double getRichtung() {
        return this.r;
    }

    public double getStreckeDiff(PolarMessung polarMessung) {
        if (this.s < D_NULL) {
            return 0.0;
        }
        if (polarMessung.s < D_NULL) {
            return 0.0;
        }
        return this.s - polarMessung.s;
    }

    public void setStreckeMittel(PolarMessung polarMessung) {
        if (this.s < D_NULL) {
            this.setStrecke(polarMessung.s);
            this.pS = polarMessung.pS;
            return;
        }
        if (polarMessung.s < D_NULL) {
            return;
        }
        this.setStrecke(this.s - this.getStreckeDiff(polarMessung) / (this.pS + polarMessung.pS));
        this.pS += polarMessung.pS;
    }

    public void setStrecke(double d) {
        this.s = d;
    }

    public double getStrecke() {
        return this.s;
    }

    public double getZenitDiff(PolarMessung polarMessung) {
        if (this.z < D_NULL || polarMessung.z < D_NULL) {
            return 0.0;
        }
        return this.z - polarMessung.z;
    }

    public void setZenitMittel(PolarMessung polarMessung) {
        if (this.z < D_NULL) {
            this.z = polarMessung.z;
        } else {
            if (polarMessung.z < D_NULL) {
                return;
            }
            this.z = (this.z + polarMessung.z) / 2.0;
        }
    }

    public void setZenit(double d) {
        this.z = d;
    }

    public double getZenit() {
        return this.z;
    }

    public String toDatLine() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.ma) {
            case 5: {
                return new String("C " + this.kommentar);
            }
            case 0: {
                stringBuffer.append("C");
                break;
            }
            case 1: {
                stringBuffer.append("3");
                break;
            }
            default: {
                return null;
            }
        }
        stringBuffer.append(" ");
        if (KafkaIOProperties.datVersion >= 2) {
            stringBuffer.append(" ");
            if (this.pns != 0L) {
                stringBuffer.append(IFormat.i14.format(this.pns));
            } else {
                stringBuffer.append("              ");
            }
            stringBuffer.append(" ");
            if (this.pnz != 0L) {
                stringBuffer.append(IFormat.i14.format(this.pnz));
            } else {
                stringBuffer.append("              ");
            }
            stringBuffer.append(IFormat.f6_4.format(this.r));
            stringBuffer.append(IFormat.f6_3.format(this.s));
            stringBuffer.append(" ");
            stringBuffer.append(new MessungGewicht((float)this.pR, (float)this.pS, 0.0f, 0.0f).toDatString());
        } else {
            if (this.pns != 0L) {
                stringBuffer.append(GeoNumberFormat.nr13.format(this.pns).toString());
            } else {
                stringBuffer.append("             ");
            }
            stringBuffer.append(" ");
            if (this.pnz != 0L) {
                stringBuffer.append(GeoNumberFormat.nr13.format(this.pnz).toString());
            } else {
                stringBuffer.append("             ");
            }
            stringBuffer.append("   ");
            stringBuffer.append(GeoNumberFormat.m34.format(this.r).toString());
            stringBuffer.append("  ");
            stringBuffer.append(GeoNumberFormat.m43.format(this.s).toString());
            stringBuffer.append("  ");
            stringBuffer.append(GeoNumberFormat.m21.format(this.pR).toString());
            stringBuffer.append("  ");
            stringBuffer.append(GeoNumberFormat.m21.format(this.pS).toString());
        }
        return stringBuffer.toString();
    }

    public String toDatHoeheLine() {
        StringBuffer stringBuffer = new StringBuffer();
        if (KafkaIOProperties.datVersion < 2) {
            return "C H\u00f6hen werden erst ab DAT_VERSION 1.4 unterst\u00fctzt";
        }
        if (IPolarReader.isIgnoreR(this.rh)) {
            return null;
        }
        switch (this.ma) {
            case 5: {
                return new String("C " + this.kommentar);
            }
            case -1: {
                return null;
            }
            case 0: {
                stringBuffer.append("C");
                break;
            }
            case 1: {
                stringBuffer.append("3");
                break;
            }
            default: {
                return null;
            }
        }
        stringBuffer.append(" ");
        stringBuffer.append(" ");
        if (this.pns != 0L) {
            stringBuffer.append(IFormat.i14.format(this.pns));
        } else {
            stringBuffer.append("              ");
        }
        stringBuffer.append(" ");
        if (this.pnz != 0L) {
            stringBuffer.append(IFormat.i14.format(this.pnz));
        } else {
            stringBuffer.append("              ");
        }
        stringBuffer.append(IFormat.f6_4.format(this.z));
        if (IPolarReader.isTrigDist() && this.ss != 0.0) {
            stringBuffer.append(IFormat.f6_3.format(this.ss));
        } else {
            stringBuffer.append("          ");
        }
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f3_4.format(this.pZ));
        if (IPolarReader.isTrigDist() && this.ss != 0.0) {
            stringBuffer.append(IFormat.f3_3.format(this.pZS));
        } else {
            stringBuffer.append("       ");
        }
        stringBuffer.append(" ");
        stringBuffer.append(IFormat.f3_3.format(this.ih - this.rh));
        return stringBuffer.toString();
    }

    public String toString() {
        return new String(this.ma + " v:" + this.pns + " n:" + this.pnz + " s=" + this.s + " , r=" + this.r + " , z=" + this.z);
    }
}

