/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.io.IPolarReader;
import de.geocalc.kafplot.io.PolarMessung;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class RecReader
extends IPolarReader {
    int anzZpk = 0;
    private PolarMessung s = new PolarMessung();

    public RecReader(File file, Vector vector) {
        super(file, vector, null);
    }

    public RecReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
    }

    @Override
    protected PolarMessung lineToPolarMessung(String string) throws IFileInputException, IOException {
        PolarMessung polarMessung = new PolarMessung();
        int n = 0;
        try {
            Integer n2 = new Integer(string.substring(8, 10).trim());
            n = n2;
        }
        catch (Exception exception) {
            return null;
        }
        switch (n) {
            case 10: {
                this.s = this.readStandpunkt(this.s, string);
                this.anzZpk = 0;
                return null;
            }
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                polarMessung = this.readMessung(polarMessung, string, n);
                polarMessung.pns = this.anzZpk == 0 ? this.s.pns : 0L;
                if (polarMessung.r == 0.0 && this.anzZpk > 0) {
                    throw new IFileInputException("Null-Richtung im Richtungssatz");
                }
                if (polarMessung.pns == 0L && this.anzZpk == 0) {
                    throw new IFileInputException("Fehlender Standpunkt");
                }
                ++this.anzZpk;
                break;
            }
            default: {
                return null;
            }
        }
        return polarMessung;
    }

    private PolarMessung readStandpunkt(PolarMessung polarMessung, String string) throws IFileInputException {
        try {
            Long l = new Long(string.substring(14, 22).trim());
            polarMessung.pns = l;
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Punktnummer");
        }
        return polarMessung;
    }

    private PolarMessung readMessung(PolarMessung polarMessung, String string, int n) throws IFileInputException {
        Double d;
        boolean bl = false;
        try {
            Long l = new Long(string.substring(14, 22).trim());
            polarMessung.pnz = l;
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Punktnummer");
        }
        if (string.charAt(36) == 'D') {
            try {
                d = new Double(string.substring(38, 50).trim());
                polarMessung.s = d;
            }
            catch (Exception exception) {
                throw new IFileInputException("Element Strecke");
            }
        }
        if (string.charAt(36) == 'E') {
            try {
                d = new Double(string.substring(41, 50).trim());
                polarMessung.s = d;
            }
            catch (Exception exception) {
                throw new IFileInputException("Element Strecke");
            }
            bl = true;
        } else {
            polarMessung.s = 0.0;
        }
        if (string.substring(51, 53).equals("Hz")) {
            try {
                d = new Double(string.substring(53, 66).trim());
                polarMessung.r = d;
            }
            catch (Exception exception) {
                throw new IFileInputException("Element Richtung");
            }
        } else {
            polarMessung.r = 0.0;
        }
        if (string.charAt(67) == 'V') {
            try {
                d = new Double(string.substring(69, 78).trim());
                polarMessung.z = d;
            }
            catch (Exception exception) {
                throw new IFileInputException("Element Zenit");
            }
        }
        if (bl) {
            polarMessung.z = 100.0;
        }
        double d2 = 0.0;
        try {
            if (n / 10 == 2 && n % 10 != 0) {
                d = new Double(string.substring(10, 14).trim());
                d2 = d / 100.0;
            } else if (n / 10 == 3 && n % 10 != 0) {
                d = new Double(string.substring(22, 27).trim());
                d2 = d / 100.0;
            }
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Exzentrum");
        }
        double d3 = 63.66197723675813;
        switch (n) {
            case 21: 
            case 31: {
                polarMessung.s += d2;
                break;
            }
            case 22: 
            case 32: {
                polarMessung.r += d3 * Math.atan2(d2, polarMessung.s);
                break;
            }
            case 23: 
            case 33: {
                polarMessung.s -= d2;
                break;
            }
            case 24: 
            case 34: {
                polarMessung.r -= d3 * Math.atan2(d2, polarMessung.s);
            }
        }
        return polarMessung;
    }
}

