/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.geom.DPolygon;
import de.geocalc.geom.DRectangle;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.GeoImage;
import de.geocalc.kafplot.GeoImageLocation;
import de.geocalc.kafplot.io.IDataReader;
import de.geocalc.kafplot.io.img.ImgIOProperties;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;

public class RidReader
extends IDataReader {
    private DataBase db;
    private LineNumberReader in = null;
    private long fileLength = 0L;

    public RidReader(File file, DataBase dataBase) throws IFileInputException {
        this(file, dataBase, null);
    }

    public RidReader(File file, DataBase dataBase, IProgressViewer iProgressViewer) throws IFileInputException {
        super(file, iProgressViewer);
        this.db = dataBase;
        try {
            this.in = this.createReader();
        }
        catch (IOException iOException) {
            throw new IFileInputException("Datei " + file.getName() + " nicht gefunden");
        }
        if (file != null) {
            this.fileLength = file.length();
        }
    }

    @Override
    public void userAbort() throws IFileInputException {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (Exception exception) {
            throw new IFileInputException(this.getErrorKey() + "Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
        }
    }

    public RidReader(URL uRL, DataBase dataBase, IProgressViewer iProgressViewer) throws IFileInputException {
        super(null, iProgressViewer);
        this.db = dataBase;
        try {
            this.in = this.createReader(uRL);
            this.setFileLength(uRL.openConnection().getContentLength());
        }
        catch (IOException iOException) {
            throw new IFileInputException("Datei " + uRL.getFile() + " nicht gefunden");
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            this.fileLength = uRLConnection.getContentLength();
            if (this.fileLength < 0L) {
                this.fileLength = 0L;
            }
        }
        catch (IOException iOException) {
            throw new IFileInputException("Datei " + uRL.getFile() + " konnte nicht ge\u00f6ffnet werden");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read() throws IFileInputException {
        String string = null;
        if (this.in == null) {
            throw new IFileInputException("Datei nicht gefunden: " + this.getFile().getName());
        }
        try {
            long l = 0L;
            GeoImage geoImage = null;
            GeoImageLocation geoImageLocation = null;
            int n = 0;
            String string2 = null;
            String string3 = null;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            int n2 = 0;
            int n3 = 0;
            while ((string = this.in.readLine()) != null) {
                if (string.length() == 0) continue;
                if (string.startsWith(" -----")) {
                    geoImage = new GeoImage();
                    geoImageLocation = new GeoImageLocation(geoImage);
                    n = 0;
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    if (n == 0) {
                        stringTokenizer.nextToken();
                        string2 = stringTokenizer.nextToken();
                    } else if (n != 1) {
                        if (n == 2) {
                            stringTokenizer.nextToken();
                            n3 = Integer.parseInt(stringTokenizer.nextToken());
                        } else if (n == 3) {
                            n2 = Integer.parseInt(stringTokenizer.nextToken());
                        } else if (n == 4) {
                            d = new Double(stringTokenizer.nextToken()) / 1000.0 + 3000000.0;
                            d2 = new Double(stringTokenizer.nextToken()) / 1000.0 + 5000000.0;
                        } else if (n == 5) {
                            d3 = new Double(stringTokenizer.nextToken()) / 1000.0 + 3000000.0;
                            d4 = new Double(stringTokenizer.nextToken()) / 1000.0 + 5000000.0;
                        } else if (n != 6 && n != 7) {
                            if (n == 8) {
                                string3 = string.trim();
                                geoImage.setName(string2);
                                geoImage.setPathName(string3);
                                geoImage.setSize(n2, n3);
                                geoImageLocation.setLocation(d, d4);
                                geoImageLocation.setScale((d4 - d2) / (double)n3);
                                geoImage.setImageLocation(geoImageLocation);
                                if (ImgIOProperties.readOnlyDataArea()) {
                                    boolean bl = false;
                                    DPolygon dPolygon = geoImageLocation.getImagePolygon();
                                    RidReader ridReader = this;
                                    DRectangle dRectangle = ridReader.db.getBounds();
                                    for (int i = 0; i < dPolygon.npoints; ++i) {
                                        if (!dRectangle.contains(dPolygon.ypoints[i], dPolygon.xpoints[i])) continue;
                                        bl = true;
                                        break;
                                    }
                                    if (bl) {
                                        DataBase.IMG.addElement(geoImage);
                                    }
                                }
                            } else {
                                throw new IFileInputException("unbekannter Inhalt: " + string.trim());
                            }
                        }
                    }
                    ++n;
                }
                super.setFileProgress(l += (long)(string.length() + 1));
            }
        }
        catch (IFileInputException iFileInputException) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.in.getLineNumber(), iFileInputException.getMessage()));
            iFileInputException.printStackTrace();
        }
        catch (IOException iOException) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.in.getLineNumber(), iOException.getMessage()));
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            this.addException(new IFileInputException("Lesefehler in Zeile: " + this.in.getLineNumber(), exception.getMessage()));
            exception.printStackTrace();
        }
        finally {
            try {
                this.in.close();
                super.setProgress(100);
            }
            catch (Exception exception) {}
        }
    }
}

