/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.io.IFileWriter;
import java.io.File;
import java.io.PrintWriter;
import java.util.GregorianCalendar;

public abstract class RtfWriter
extends IFileWriter {
    protected DataBase db;
    protected static final String LAST_PAGE_ID = "LETZTE_SEITE";
    protected static final String NOBREAK_SPACE = "\\~";

    public RtfWriter(File file, DataBase dataBase) {
        super(file);
        this.db = dataBase;
    }

    private void addDatVarException(String string) {
        this.addException(new IException(string + " wurde nicht angegeben, der Tabellenkopf kann nicht vollst\u00e4ndig ausgef\u00fcllt werden"));
    }

    protected boolean checkDatVars() {
        if (DataBase.gemeinde == null) {
            this.addDatVarException("Gemeinde");
        } else if (DataBase.gemarkung == null) {
            this.addDatVarException("Gemarkung");
        } else if (DataBase.vermStelle == null) {
            this.addDatVarException("Vermessungsstelle");
        } else if (DataBase.katasterAmt == null) {
            this.addDatVarException("Katasteramt");
        } else if (DataBase.flur == null) {
            this.addDatVarException("Flur");
        } else if (DataBase.flurstueck == null) {
            this.addDatVarException("Flurst\u00fcck");
        } else {
            return true;
        }
        return false;
    }

    protected void writeDocInfo(PrintWriter printWriter, String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        printWriter.println("{\\*\\DokumentInfo}");
        printWriter.println("{\\info");
        printWriter.println("{\\creatim\\yr" + gregorianCalendar.get(1) + "\\mo" + (gregorianCalendar.get(2) + 1) + "\\dy" + gregorianCalendar.get(5) + "\\hr" + gregorianCalendar.get(10) + "\\min" + gregorianCalendar.get(12) + "}");
        printWriter.println("{\\author " + (DataBase.vermStelle != null ? RtfWriter.getRtfString(DataBase.vermStelle) : "") + "}");
        printWriter.println("{\\operator " + (DataBase.bearbeiter != null ? RtfWriter.getRtfString(DataBase.bearbeiter) : System.getProperty("user.name", "USER")) + "}");
        printWriter.println("{\\title " + string + " " + (DataBase.projekt != null ? DataBase.projekt : "") + "}");
        printWriter.println("{\\subject Liegenschaftsvermessung}");
        printWriter.println("}");
    }

    protected static String getRtfString(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        block9: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\u00c4': {
                    stringBuffer.append("\\'c4");
                    continue block9;
                }
                case '\u00e4': {
                    stringBuffer.append("\\'e4");
                    continue block9;
                }
                case '\u00d6': {
                    stringBuffer.append("\\'d6");
                    continue block9;
                }
                case '\u00f6': {
                    stringBuffer.append("\\'f6");
                    continue block9;
                }
                case '\u00dc': {
                    stringBuffer.append("\\'dc");
                    continue block9;
                }
                case '\u00fc': {
                    stringBuffer.append("\\'fc");
                    continue block9;
                }
                case '\u00df': {
                    stringBuffer.append("\\'df");
                    continue block9;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

