/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.io.IPolarReader;
import de.geocalc.kafplot.io.PolarMessung;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class SdrReader
extends IPolarReader {
    int anzZpk = 0;
    private PolarMessung s = new PolarMessung();

    public SdrReader(File file, Vector vector) {
        super(file, vector, null);
    }

    public SdrReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
    }

    @Override
    protected PolarMessung lineToPolarMessung(String string) throws IFileInputException, IOException {
        PolarMessung polarMessung = new PolarMessung();
        int n = 0;
        try {
            n = new Integer(string.substring(0, 2).trim());
        }
        catch (Exception exception) {
            return null;
        }
        switch (n) {
            case 10: {
                this.s = this.readStandpunkt(this.s, string);
                this.anzZpk = 0;
                return null;
            }
            case 30: {
                polarMessung = this.readMessung(polarMessung, string);
                polarMessung.pns = this.anzZpk == 0 ? this.s.pns : 0L;
                if (polarMessung.r == 0.0 && this.anzZpk > 0) {
                    throw new IFileInputException("Null-Richtung im Richtungssatz");
                }
                if (polarMessung.pns == 0L && this.anzZpk == 0) {
                    throw new IFileInputException("Fehlender Standpunkt");
                }
                ++this.anzZpk;
                break;
            }
            default: {
                return null;
            }
        }
        return polarMessung;
    }

    private PolarMessung readStandpunkt(PolarMessung polarMessung, String string) throws IFileInputException {
        try {
            polarMessung.pns = new Long(string.substring(3, 19).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Punktnummer");
        }
        return polarMessung;
    }

    private PolarMessung readMessung(PolarMessung polarMessung, String string) throws IFileInputException {
        try {
            polarMessung.pnz = new Long(string.substring(3, 19).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Punktnummer");
        }
        try {
            polarMessung.s = new Double(string.substring(26, 35).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Strecke");
        }
        try {
            polarMessung.r = new Double(string.substring(38, 47).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Richtung");
        }
        try {
            polarMessung.z = new Double(string.substring(49, 58).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Zenit");
        }
        return polarMessung;
    }
}

