/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.io.IPolarReader;
import de.geocalc.kafplot.io.PolarMessung;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class SdrXXReader
extends IPolarReader {
    int anzZpk = 0;
    int ver = 0;
    private PolarMessung s = new PolarMessung();

    public SdrXXReader(File file, Vector vector) {
        super(file, vector, null);
    }

    public SdrXXReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
    }

    @Override
    protected PolarMessung lineToPolarMessung(String string) throws IFileInputException, IOException {
        PolarMessung polarMessung = new PolarMessung();
        if (string.length() == 0) {
            return null;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string.substring(0, 2));
        }
        catch (Exception exception) {
            throw new IFileInputException("Zeilenkennung");
        }
        switch (n) {
            case 0: {
                if (string.substring(2, 4).equals("NM")) {
                    try {
                        this.ver = Integer.parseInt(string.substring(7, 9)) / 10;
                    }
                    catch (Exception exception) {
                        throw new IFileInputException("Element SDR-Version");
                    }
                    if (this.ver != 2 && this.ver != 3) {
                        throw new IFileInputException("ung\u00fcltige SDR-Version");
                    }
                }
                return null;
            }
            case 2: {
                this.s = this.readStandpunkt(this.s, string);
                this.anzZpk = 0;
                return null;
            }
            case 7: {
                polarMessung = this.readAnschluss(polarMessung, string);
                if (this.anzZpk != 0) {
                    polarMessung.pns = 0L;
                }
                ++this.anzZpk;
                break;
            }
            case 9: {
                polarMessung = this.readMessung(polarMessung, string);
                if (this.anzZpk != 0) {
                    polarMessung.pns = 0L;
                }
                ++this.anzZpk;
                break;
            }
            case 13: {
                if (string.indexOf("<JOB>") >= 0) {
                    return new PolarMessung(string.substring(4));
                }
                return null;
            }
            default: {
                return null;
            }
        }
        return polarMessung;
    }

    private PolarMessung readStandpunkt(PolarMessung polarMessung, String string) throws IFileInputException {
        try {
            if (this.ver == 2) {
                polarMessung.pns = new Long(string.substring(4, 8).trim());
            } else if (this.ver == 3) {
                polarMessung.pns = new Long(string.substring(4, 20).trim());
            }
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Punktnummer");
        }
        return polarMessung;
    }

    private PolarMessung readAnschluss(PolarMessung polarMessung, String string) throws IFileInputException {
        try {
            if (this.ver == 2) {
                polarMessung.pns = new Long(string.substring(4, 8).trim());
            } else if (this.ver == 3) {
                this.s.pns = new Long(string.substring(4, 20).trim());
            }
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Punktnummer");
        }
        try {
            if (this.ver == 2) {
                polarMessung.pnz = new Long(string.substring(8, 12).trim());
            } else if (this.ver == 3) {
                polarMessung.pnz = new Long(string.substring(20, 36).trim());
            }
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Punktnummer");
        }
        try {
            if (this.ver == 2) {
                polarMessung.r = new Double(string.substring(22, 32).trim());
            } else if (this.ver == 3) {
                polarMessung.r = new Double(string.substring(52, 68).trim());
            }
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Richtung");
        }
        return polarMessung;
    }

    private PolarMessung readMessung(PolarMessung polarMessung, String string) throws IFileInputException {
        try {
            if (this.ver == 2) {
                polarMessung.pns = new Long(string.substring(4, 8).trim());
            } else if (this.ver == 3) {
                this.s.pns = new Long(string.substring(4, 20).trim());
            }
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Punktnummer");
        }
        try {
            if (this.ver == 2) {
                polarMessung.pnz = new Long(string.substring(8, 12).trim());
            } else if (this.ver == 3) {
                polarMessung.pnz = new Long(string.substring(20, 36).trim());
            }
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Punktnummer");
        }
        try {
            if (this.ver == 2) {
                polarMessung.s = new Double(string.substring(12, 22).trim());
            } else if (this.ver == 3) {
                polarMessung.s = new Double(string.substring(36, 52).trim());
            }
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Strecke");
        }
        try {
            if (this.ver == 2) {
                polarMessung.z = new Double(string.substring(22, 32).trim());
            } else if (this.ver == 3) {
                polarMessung.z = new Double(string.substring(52, 68).trim());
            }
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Zenit");
        }
        try {
            if (this.ver == 2) {
                polarMessung.r = new Double(string.substring(32, 42).trim());
            } else if (this.ver == 3) {
                polarMessung.r = new Double(string.substring(68, 84).trim());
            }
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Richtung");
        }
        return polarMessung;
    }
}

