/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.io.IPolarReader;
import de.geocalc.kafplot.io.PolarMessung;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class SokReader
extends IPolarReader {
    int anzZpk = 0;
    private PolarMessung s = new PolarMessung();

    public SokReader(File file, Vector vector) {
        super(file, vector, null);
    }

    public SokReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
    }

    @Override
    protected PolarMessung lineToPolarMessung(String string) throws IFileInputException, IOException {
        PolarMessung polarMessung = new PolarMessung();
        int n = 0;
        try {
            if (string.startsWith("S")) {
                n = 10;
            } else if (string.startsWith("O")) {
                n = 30;
            } else if (string.startsWith("N")) {
                n = 30;
            }
        }
        catch (Exception exception) {
            return null;
        }
        switch (n) {
            case 10: {
                this.s = this.readStandpunkt(this.s, string);
                this.anzZpk = 0;
                return null;
            }
            case 30: {
                polarMessung = this.readMessung(polarMessung, string);
                polarMessung.pns = this.anzZpk == 0 ? this.s.pns : 0L;
                if (polarMessung.pns == 0L && this.anzZpk == 0) {
                    throw new IFileInputException("Fehlender Standpunkt");
                }
                ++this.anzZpk;
                break;
            }
            default: {
                return null;
            }
        }
        return polarMessung;
    }

    @Override
    protected void syncronisierePolarMessungen() {
        int n = 0;
        for (int i = 0; i < this.M.size(); ++i) {
            PolarMessung polarMessung = (PolarMessung)this.M.elementAt(i);
            if (polarMessung.pns != 0L) {
                n = i;
                continue;
            }
            for (int j = i - 1; j >= n; --j) {
                PolarMessung polarMessung2 = (PolarMessung)this.M.elementAt(j);
                if (polarMessung.pnz != polarMessung2.pnz || !(Math.abs(polarMessung2.getRichtungDiff(polarMessung)) > 199.0)) continue;
                polarMessung.setRichtung(polarMessung.getRichtung() - 200.0);
            }
        }
    }

    private PolarMessung readStandpunkt(PolarMessung polarMessung, String string) throws IFileInputException {
        try {
            polarMessung.pns = new Long(string.substring(3, 8).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Punktnummer");
        }
        return polarMessung;
    }

    private PolarMessung readMessung(PolarMessung polarMessung, String string) throws IFileInputException {
        try {
            polarMessung.pnz = new Long(string.substring(3, 8).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Punktnummer");
        }
        try {
            polarMessung.s = new Double(string.substring(26, Math.min(35, string.length())).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Strecke");
        }
        try {
            polarMessung.r = new Double(string.substring(10, 18).trim());
        }
        catch (Exception exception) {
            polarMessung.r = 0.0;
        }
        try {
            polarMessung.z = new Double(string.substring(18, 26).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Zenit");
        }
        return polarMessung;
    }
}

