/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IException;
import de.geocalc.io.IFileOutputException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainerTable;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.Stat;
import de.geocalc.kafplot.StatElement;
import de.geocalc.kafplot.ValueDataContainer;
import de.geocalc.kafplot.io.RtfWriter;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class StatistikbelegWriter
extends RtfWriter {
    public static boolean mg = true;
    public static boolean mp = true;
    public static boolean mm = true;
    public static boolean mk = true;
    public static boolean me = true;
    public static boolean mv = true;
    public static boolean tt = true;
    public static boolean bh = true;
    public static boolean bb = true;
    protected String gemarkung;
    private static final String MID = "\\'d8";
    private static final String EOL = "\n";
    private static final String DOC_HEADER = "{\\rtf1\\ansi\\deff0\\adeflang1025\n{\\fonttbl{\\f0\\froman\\fprq2\\fcharset0 Times New Roman;}{\\f1\\froman\\fprq2\\fcharset0 Times New Roman;}{\\f2\\fswiss\\fprq2\\fcharset0 Arial;}{\\f3\\froman\\fprq2\\fcharset0 Times New Roman;}{\\f4\\fnil\\fprq2\\fcharset0 Arial Unicode MS;}{\\f5\\fswiss\\fprq2\\fcharset0 Arial Unicode MS;}{\\f6\\fnil\\fprq2\\fcharset0 Tahoma;}{\\f7\\fnil\\fprq0\\fcharset0 Tahoma;}}\n{\\colortbl;\\red0\\green0\\blue0;\\red128\\green128\\blue128;}\n{\\stylesheet{\\s1\\rtlch\\afs24\\ltrch\\dbch\\fs24\\fs24\\snext1 Normal;}\n{\\*\\cs55\\rtlch\\afs24\\ltrch\\dbch\\fs24\\fs24 Default Paragraph Font;}}\n{\\info{\\creatim\\yr0\\mo0\\dy0\\hr0\\min0}{\\revtim\\yr0\\mo0\\dy0\\hr0\\min0}{\\printim\\yr0\\mo0\\dy0\\hr0\\min0}{\\comment KafPlot}{\\vern6800}}";
    private static final String EOF = "\\par }";

    public StatistikbelegWriter(File file, DataBase dataBase) {
        super(file, dataBase);
    }

    @Override
    public void write() throws IFileOutputException {
        PrintWriter printWriter = null;
        try {
            printWriter = this.createWriter();
            boolean bl = false;
            super.setProgressBreak();
            super.setValue(0L);
            super.showProgress();
            this.checkDatVars();
            StringBuffer stringBuffer = new StringBuffer();
            if (DataBase.gemarkung != null) {
                Gemarkung gemarkung = Gemarkung.getGemarkung(DataBase.gemeinde, DataBase.gemarkung);
                if (gemarkung != null) {
                    stringBuffer.append(gemarkung.getName());
                    stringBuffer.append(" (");
                    stringBuffer.append(GeoNumberFormat.nr06n.format(gemarkung.getNummer()).toString());
                    stringBuffer.append(")");
                } else {
                    stringBuffer.append(DataBase.gemarkung);
                    this.addException(new IException("Keine Gemarkungsnummer f\u00fcr die Gemarkung: " + DataBase.gemarkung + " gefunden.", "\u00dcberpr\u00fcfen Sie die Einstellungen in der Konfigurationsdatei \"gemarkungen.properties\""));
                }
                this.gemarkung = stringBuffer.toString();
            }
            printWriter.println(DOC_HEADER);
            this.writePage1Header(printWriter);
            this.writePage1Table(printWriter);
            this.writePage2Header(printWriter);
            if (mg) {
                this.writeListStatistik(printWriter, DataBase.MG, "GPS-Messungen");
            }
            this.setProgress(10);
            if (mg) {
                this.writeListStatistik(printWriter, DataBase.MP, "Polare Aufnahme");
            }
            this.setProgress(20);
            if (mg) {
                this.writeListStatistik(printWriter, DataBase.MM, "Messbandmessungen");
            }
            this.setProgress(30);
            if (mg) {
                this.writeListStatistik(printWriter, DataBase.MK, "Katasternachweis");
            }
            this.setProgress(50);
            if (mg) {
                this.writeListStatistik(printWriter, DataBase.ME, "Einrechnung");
            }
            this.setProgress(60);
            if (mg) {
                this.writeListStatistik(printWriter, DataBase.MV, "Vorgaben");
            }
            this.setProgress(70);
            if (tt) {
                this.writeListStatistik(printWriter, DataBase.T, "Transformationen");
            }
            this.setProgress(80);
            if (bh) {
                this.writeListStatistik(printWriter, DataBase.BH, "Homogenisierung");
            }
            this.setProgress(90);
            if (bb) {
                this.writeListStatistik(printWriter, DataBase.BB, "Bedingungen");
            }
            this.setProgress(100);
            this.writePage2TableLine(printWriter, "");
            printWriter.println(EOF);
            printWriter.close();
        }
        catch (IOException iOException) {
            if (printWriter != null) {
                printWriter.close();
            }
            throw new IFileOutputException("Schreibfehler beim Erzeugen der Datei: " + this.outFile.getName());
        }
    }

    private void writeListStatistik(PrintWriter printWriter, DataContainerTable dataContainerTable, String string) {
        if (dataContainerTable.size() > 0) {
            this.writePage2TableLine(printWriter, StatistikbelegWriter.getRtfString(string));
        }
        Enumeration enumeration = dataContainerTable.elements();
        while (enumeration.hasMoreElements()) {
            this.writeRissStatistik(printWriter, (ValueDataContainer)enumeration.nextElement());
        }
    }

    private void writeRissStatistik(PrintWriter printWriter, ValueDataContainer valueDataContainer) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int n24 = 0;
        int n25 = 0;
        Enumeration enumeration = valueDataContainer.elements();
        while (enumeration.hasMoreElements()) {
            StatElement statElement = (StatElement)enumeration.nextElement();
            if (!statElement.hasStatistik()) continue;
            Stat stat = statElement.getStatistik();
            n7 = stat.getMidSaV();
            n6 = stat.getMidSaN();
            if (n7 > 0 && n6 > 0) {
                n8 += n7;
                n9 += n6;
                ++n24;
            }
            n16 = Math.max(n16, stat.getMaxSaV());
            n17 = Math.max(n17, stat.getMaxSaN());
            n10 += stat.getMidEv();
            n18 = stat.getMaxEv();
            n5 = stat.getMaxEp();
            n11 += n5;
            n19 = Math.max(n19, n5);
            n4 = stat.getMaxNv();
            n12 += n4;
            n20 = Math.max(n20, n4);
            n3 = stat.getMaxGf();
            n13 += n3;
            n21 = Math.max(n21, n3);
            int n26 = stat.getMaxGrzw();
            n14 += n26;
            n22 = Math.max(n22, n26);
            int n27 = stat.getMaxEgk();
            n15 += n27;
            n23 = Math.max(n23, n27);
            ++n25;
        }
        int n28 = (int)((float)n8 / (float)n24);
        int n29 = (int)((float)n9 / (float)n24);
        int n30 = (int)((float)n10 / (float)n25);
        n7 = (int)((float)n11 / (float)n25);
        n6 = (int)((float)n12 / (float)n25);
        n5 = (int)((float)n13 / (float)n25);
        n4 = (int)((float)n14 / (float)n25);
        n3 = (int)((float)n15 / (float)n25);
        this.writePage2TableLine(printWriter, StatistikbelegWriter.getRtfString(valueDataContainer.getKeyString()), StatistikbelegWriter.getRtfString(valueDataContainer.getDate()), "M", IFormat.f_3.format((double)n28 * 0.001), IFormat.f_3.format((double)n29 * 0.001), IFormat.i2.format(n30), IFormat.f_3.format((double)n7 * 0.001), IFormat.f_3.format((double)n6 * 0.1), IFormat.f_3.format((double)n5 * 0.001), IFormat.f_3.format((double)n4 * 0.001), IFormat.f_3.format((double)n3 * 0.001));
        this.writePage2TableLine(printWriter, "", "", "X", IFormat.f_3.format((double)n16 * 0.001), IFormat.f_3.format((double)n17 * 0.001), IFormat.i2.format(n18), IFormat.f_3.format((double)n19 * 0.001), IFormat.f_3.format((double)n20 * 0.1), IFormat.f_3.format((double)n21 * 0.001), IFormat.f_3.format((double)n22 * 0.001), IFormat.f_3.format((double)n23 * 0.001));
        n8 = 0;
        n9 = 0;
        n10 = 0;
        n11 = 0;
        n12 = 0;
        n13 = 0;
        n14 = 0;
        n15 = 0;
        Enumeration enumeration2 = valueDataContainer.elements();
        while (enumeration2.hasMoreElements()) {
            StatElement statElement = (StatElement)enumeration2.nextElement();
            if (!statElement.hasStatistik()) continue;
            Stat stat = statElement.getStatistik();
            n2 = stat.getMidSaV();
            n = stat.getMidSaN();
            if (n2 > 0 && n > 0) {
                n8 += this.pow(n2 - n28);
                n9 += this.pow(n - n29);
            }
            n10 += this.pow(stat.getMidEv() - n30);
            n11 += this.pow(stat.getMaxEp() - n7);
            n12 += this.pow(stat.getMaxNv() - n6);
            n13 += this.pow(stat.getMaxGf() - n5);
            n14 += this.pow(stat.getMaxGrzw() - n4);
            n15 += this.pow(stat.getMaxEgk() - n3);
        }
        int n31 = (int)Math.sqrt((float)n8 / (float)(n24 - 1));
        int n32 = (int)Math.sqrt((float)n9 / (float)(n24 - 1));
        int n33 = (int)Math.sqrt((float)n10 / (float)(n25 - 1));
        n2 = (int)Math.sqrt((float)n11 / (float)(n25 - 1));
        n = (int)Math.sqrt((float)n12 / (float)(n25 - 1));
        int n34 = (int)Math.sqrt((float)n13 / (float)(n25 - 1));
        int n35 = (int)Math.sqrt((float)n14 / (float)(n25 - 1));
        int n36 = (int)Math.sqrt((float)n15 / (float)(n25 - 1));
        this.writePage2TableLine(printWriter, "", "", "S", IFormat.f_3.format((double)n31 * 0.001), IFormat.f_3.format((double)n32 * 0.001), IFormat.i2.format(n33), IFormat.f_3.format((double)n2 * 0.001), IFormat.f_3.format((double)n * 0.1), IFormat.f_3.format((double)n34 * 0.001), IFormat.f_3.format((double)n35 * 0.001), IFormat.f_3.format((double)n36 * 0.001));
        String string = "";
        if (n6 + n > 25) {
            string = "Gewichtung absenken";
        } else if (n6 + n < 15) {
            string = "Gewichtung erh\u00f6hen";
        }
        this.writePage2TableLine(printWriter, "", "", "", string);
    }

    private int pow(int n) {
        return n * n;
    }

    private void writePage1Header(PrintWriter printWriter) {
        printWriter.println("\\deftab708\\paperh16838\\paperw11906\\margl1588\\margr567\\margt850\\margb1020\\sectd\\sbknone\\pgwsxn11906\\pghsxn16838\\marglsxn1588\\margrsxn567\\margtsxn3690\\margbsxn1020\\headery850{\\header \\pard\\plain \\s1\\rtlch\\afs28\\ab\\ltrch\\dbch\\fs28\\b\\fs28\\b {\\rtlch \\ltrch\\f0\\fs28\\i0\\b Statistik - Liste ({\\field{\\*\\fldinst {\\b\\fs28\\insrsid5916726\\charrsid5916726  PAGE }}{\\fldrslt 2}}/ {\\field{\\*\\fldinst {\\b\\fs28\\insrsid5916726\\charrsid5916726  NUMPAGES }}{\\fldrslt 2}})}");
        printWriter.println("\\par");
        printWriter.println("\\trowd\\trql\\trleft-70\\trkeep\\trrh400\\trpaddft3\\trpaddt70\\trpaddfl3\\trpaddl70\\trpaddfb3\\trpaddb70\\trpaddfr3\\trpaddr70\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\cellx1112\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx3341\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx5849\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx7661\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\cellx9751");
        printWriter.println("\\pard\\intbl\\pard\\plain \\intbl\\s1\\rtlch\\afs16\\ltrch\\dbch\\fs16\\fs16 {\\rtlch \\ltrch\\f0\\fs16\\i0\\b0 Gemeinde }");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\keepn\\rtlch\\afs20\\ab\\ltrch\\dbch\\fs20\\b\\fs20\\b {\\rtlch \\ltrch\\f0\\fs20\\i0\\b " + (DataBase.gemeinde != null ? StatistikbelegWriter.getRtfString(DataBase.gemeinde) : "") + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\rtlch\\afs16\\ltrch\\dbch\\fs16\\fs16 {\\rtlch \\ltrch\\f0\\fs16\\i0\\b0 Vermessungsstelle}");
        printWriter.println("\\par \\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b {\\rtlch \\ltrch\\f0\\fs16\\i0\\b " + (DataBase.vermStelle != null ? StatistikbelegWriter.getRtfString(DataBase.vermStelle) : "") + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\rtlch\\afs16\\ltrch\\dbch\\fs16\\fs16 {\\rtlch \\ltrch\\f0\\fs16\\i0\\b0 Katasteramt}");
        printWriter.println("\\par \\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20 {\\rtlch \\ltrch\\f0\\fs20\\i0\\b0 " + (DataBase.katasterAmt != null ? StatistikbelegWriter.getRtfString(DataBase.katasterAmt) : "") + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\rtlch\\afs16\\ltrch\\dbch\\fs16\\fs16 {\\rtlch \\ltrch\\f0\\fs16\\i0\\b0 Archivblatt*:}");
        printWriter.println("\\cell\\row\\pard");
        printWriter.println("\\trowd\\trql\\trleft-70\\trkeep\\trrh400\\trpaddft3\\trpaddt70\\trpaddfl3\\trpaddl70\\trpaddfb3\\trpaddb70\\trpaddfr3\\trpaddr70\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\cellx1112\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx3341\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx5849\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx7661\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\cellx9751");
        printWriter.println("\\pard\\intbl\\pard\\plain \\intbl\\s1\\rtlch\\afs16\\ltrch\\dbch\\fs16\\fs16 {\\rtlch \\ltrch\\f0\\fs16\\i0\\b0 Gemarkung}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\keepn\\rtlch\\afs20\\ab\\ltrch\\dbch\\fs20\\b\\fs20\\b {\\rtlch \\ltrch\\f0\\fs20\\i0\\b " + (this.gemarkung != null ? StatistikbelegWriter.getRtfString(this.gemarkung) : "") + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\rtlch\\afs16\\ltrch\\dbch\\fs16\\fs16 {\\rtlch \\ltrch\\f0\\fs16\\i0\\b0 Antrags-Nr.*:}");
        printWriter.println("\\cell\\row\\pard");
        printWriter.println("\\trowd\\trql\\trleft-70\\trrh400\\trpaddft3\\trpaddt70\\trpaddfl3\\trpaddl70\\trpaddfb3\\trpaddb70\\trpaddfr3\\trpaddr70\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx1112\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx3341\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\cellx5849\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clpadfb3\\clpadb0\\cellx7661\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clpadfb3\\clpadb0\\cellx9751");
        printWriter.println("\\pard\\intbl\\pard\\plain \\intbl\\s1\\rtlch\\afs24\\ltrch\\dbch\\fs24\\fs24{\\rtlch \\ltrch\\f0\\fs24\\i0\\b0{\\rtlch\\ltrch\\fs16\\fs16 Flur }}{\\rtlch \\ltrch\\f0\\fs24\\i0\\b0{\\rtlch\\ltrch\\fs20\\fs20\\b " + (DataBase.flur != null ? StatistikbelegWriter.getRtfString(DataBase.flur) : "") + "}}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\rtlch\\afs16\\ltrch\\dbch\\fs16\\fs16 {\\rtlch \\ltrch\\f0\\fs16\\i0\\b0 Flurst\\'fcck }{\\rtlch \\ltrch\\f0\\fs24\\i0\\b0{\\rtlch\\ltrch\\fs20\\fs20\\b " + (DataBase.flurstueck != null ? StatistikbelegWriter.getRtfString(DataBase.flurstueck) : "") + "}}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\rtlch\\afs12\\ltrch\\dbch\\fs12\\fs12 {\\rtlch \\ltrch\\f0\\fs12\\i0\\b0 * wird vom Katasteramt ausgef\\'fcllt}");
        printWriter.println("\\cell\\row\\pard \\pard\\plain \\s1\\rtlch\\afs24\\ltrch\\dbch\\fs24\\fs24");
        printWriter.println(EOF);
        printWriter.println("\\ftnbj\\ftnstart1\\ftnrstcont\\ftnnar\\aenddoc\\aftnrstcont\\aftnstart1\\aftnnrlc");
        printWriter.println("\\pard\\plain \\ltrpar\\s3\\sa120\\ql\\rtlch\\afs24\\ltrch\\dbch\\fs24\\fs24");
    }

    private void writePage1Table(PrintWriter printWriter) {
        printWriter.println("\\par");
        this.writePage1TableLine(printWriter, "SA V.A.", StatistikbelegWriter.getRtfString("Standardabweichung der Beobachtungen vor der Ausgleichung"));
        this.writePage1TableLine(printWriter, "SA N.A.", StatistikbelegWriter.getRtfString("Standardabweichung der Beobachtungen nach der Ausgleichung"));
        this.writePage1TableLine(printWriter, "EV", StatistikbelegWriter.getRtfString("Kontrollierbarkeit der Beobachtungen"));
        this.writePage1TableLine(printWriter, "EP", StatistikbelegWriter.getRtfString("Einfluss der Beobachtungen auf die relative Punktlage"));
        this.writePage1TableLine(printWriter, "NV", StatistikbelegWriter.getRtfString("Normierte Verbesserungen der Beobachtungen"));
        this.writePage1TableLine(printWriter, "GF", StatistikbelegWriter.getRtfString("Grobe Fehler der Beobachtungen"));
        this.writePage1TableLine(printWriter, "GRZW", StatistikbelegWriter.getRtfString("Grenzwerte der nicht erkennbaren groben Fehler der Beobachtungen"));
        this.writePage1TableLine(printWriter, "EGK", StatistikbelegWriter.getRtfString("Einfluss der nicht erkennbaren groben Fehler auf die relative Punktlage"));
        this.writePage1TableLine(printWriter, "", "");
        this.writePage1TableLine(printWriter, "M", StatistikbelegWriter.getRtfString("Mittel \u00fcber alle Beobachtungen"));
        this.writePage1TableLine(printWriter, "X", StatistikbelegWriter.getRtfString("Maxima \u00fcber alle Beobachtungen"));
        this.writePage1TableLine(printWriter, "S", StatistikbelegWriter.getRtfString("Streuung des Mittelwertes"));
        printWriter.println("\\pard\\plain \\ltrpar\\s1\\sb400\\ql\\rtlch\\afs24\\ltrch\\dbch\\fs24\\fs24");
    }

    private void writePage1TableLine(PrintWriter printWriter, String string, String string2) {
        printWriter.println("\\trowd\\trql\\trleft1552\\trpaddft3\\trpaddt55\\trpaddfl3\\trpaddl55\\trpaddfb3\\trpaddb55\\trpaddfr3\\trpaddr55\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\cellx3025\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx7898");
        printWriter.println("\\pard\\intbl\\pard\\plain \\intbl\\ltrpar\\s40\\ql\\rtlch\\afs24\\ltrch\\dbch\\fs24\\fs24 {\\rtlch \\ltrch\\f0\\fs24\\i0\\b0 " + string + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\ltrpar\\s40\\ql\\rtlch\\afs24\\ltrch\\dbch\\fs24\\fs24 {\\rtlch \\ltrch\\f0\\fs24\\i0\\b0 " + string2 + "}");
        printWriter.println("\\cell\\row\\pard");
    }

    private void writePage2Header(PrintWriter printWriter) {
        printWriter.println("\\par \\sect\\sectd\\pgwsxn11907\\pghsxn16840\\marglsxn1588\\margrsxn567\\margtsxn4378\\margbsxn1021\\headery709{\\header \\pard\\plain \\s1\\rtlch\\afs28\\ab\\ltrch\\dbch\\fs28\\b\\fs28\\b {\\rtlch \\ltrch\\f0\\fs28\\i0\\b Statistik - Liste ({\\field{\\*\\fldinst {\\b\\fs28\\insrsid5916726\\charrsid5916726  PAGE }}{\\fldrslt 2}}/ {\\field{\\*\\fldinst {\\b\\fs28\\insrsid5916726\\charrsid5916726  NUMPAGES }}{\\fldrslt 2}})}");
        printWriter.println("\\par");
        printWriter.println("\\trowd\\trql\\trleft-70\\trkeep\\trrh400\\trpaddft3\\trpaddt70\\trpaddfl3\\trpaddl70\\trpaddfb3\\trpaddb70\\trpaddfr3\\trpaddr70\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\cellx1113\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx3342\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx5850\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx7662\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\cellx9752");
        printWriter.println("\\pard\\intbl\\pard\\plain \\intbl\\s1\\rtlch\\afs16\\ltrch\\dbch\\fs16\\fs16 {\\rtlch \\ltrch\\f0\\fs16\\i0\\b0 Gemeinde }");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\keepn\\rtlch\\afs20\\ab\\ltrch\\dbch\\fs20\\b\\fs20\\b {\\rtlch \\ltrch\\f0\\fs20\\i0\\b " + (DataBase.gemeinde != null ? StatistikbelegWriter.getRtfString(DataBase.gemeinde) : "") + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\rtlch\\afs16\\ltrch\\dbch\\fs16\\fs16 {\\rtlch \\ltrch\\f0\\fs16\\i0\\b0 Vermessungsstelle}");
        printWriter.println("\\par \\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b {\\rtlch \\ltrch\\f0\\fs16\\i0\\b " + (DataBase.vermStelle != null ? StatistikbelegWriter.getRtfString(DataBase.vermStelle) : "") + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\rtlch\\afs16\\ltrch\\dbch\\fs16\\fs16 {\\rtlch \\ltrch\\f0\\fs16\\i0\\b0 Katasteramt}");
        printWriter.println("\\par \\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20 {\\rtlch \\ltrch\\f0\\fs20\\i0\\b0 " + (DataBase.katasterAmt != null ? StatistikbelegWriter.getRtfString(DataBase.katasterAmt) : "") + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\rtlch\\afs16\\ltrch\\dbch\\fs16\\fs16 {\\rtlch \\ltrch\\f0\\fs16\\i0\\b0 Archivblatt*:}");
        printWriter.println("\\cell\\row\\pard");
        printWriter.println("\\trowd\\trql\\trleft-70\\trkeep\\trrh400\\trpaddft3\\trpaddt70\\trpaddfl3\\trpaddl70\\trpaddfb3\\trpaddb70\\trpaddfr3\\trpaddr70\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\cellx1113\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx3342\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx5850\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx7662\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\cellx9752");
        printWriter.println("\\pard\\intbl\\pard\\plain \\intbl\\s1\\rtlch\\afs16\\ltrch\\dbch\\fs16\\fs16 {\\rtlch \\ltrch\\f0\\fs16\\i0\\b0 Gemarkung}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\keepn\\rtlch\\afs20\\ab\\ltrch\\dbch\\fs20\\b\\fs20\\b {\\rtlch \\ltrch\\f0\\fs20\\i0\\b " + (this.gemarkung != null ? StatistikbelegWriter.getRtfString(this.gemarkung) : "") + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\rtlch\\afs16\\ltrch\\dbch\\fs16\\fs16 {\\rtlch \\ltrch\\f0\\fs16\\i0\\b0 Antrags-Nr.*:}");
        printWriter.println("\\cell\\row\\pard");
        printWriter.println("\\trowd\\trql\\trleft-70\\trrh400\\trpaddft3\\trpaddt70\\trpaddfl3\\trpaddl70\\trpaddfb3\\trpaddb70\\trpaddfr3\\trpaddr70\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx1113\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx3342\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\cellx5850\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clpadfb3\\clpadb0\\cellx7662\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clpadfb3\\clpadb0\\cellx9752");
        printWriter.println("\\pard\\intbl\\pard\\plain \\intbl\\s1\\rtlch\\afs24\\ltrch\\dbch\\fs24\\fs24{\\rtlch \\ltrch\\f0\\fs24\\i0\\b0{\\rtlch\\ltrch\\fs16\\fs16 Flur}}{\\rtlch \\ltrch\\f0\\fs24\\i0\\b0{\\rtlch\\ltrch\\fs20\\fs20\\b " + (DataBase.flur != null ? StatistikbelegWriter.getRtfString(DataBase.flur) : "") + "}}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\rtlch\\afs16\\ltrch\\dbch\\fs16\\fs16 {\\rtlch \\ltrch\\f0\\fs16\\i0\\b0 Flurst\\'fcck }{\\rtlch \\ltrch\\f0\\fs24\\i0\\b0{\\rtlch\\ltrch\\fs20\\fs20\\b " + (DataBase.flurstueck != null ? StatistikbelegWriter.getRtfString(DataBase.flurstueck) : "") + "}}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\rtlch\\afs12\\ltrch\\dbch\\fs12\\fs12 {\\rtlch \\ltrch\\f0\\fs12\\i0\\b0 * wird vom Katasteramt ausgef\\'fcllt}");
        printWriter.println("\\cell\\row\\pard \\pard\\plain \\s1\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20");
        printWriter.println("\\par \\pard\\plain \\s1\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20");
        printWriter.println("\\par");
        printWriter.println("\\trowd\\trql\\trleft-70\\trkeep\\trrh300\\trpaddft3\\trpaddt70\\trpaddfl3\\trpaddl70\\trpaddfb3\\trpaddb70\\trpaddfr3\\trpaddr70\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx1392\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx2507\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx2785\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx3656\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx4526\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx5397\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx6268\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx7139\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx8010\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx8881\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx9752");
        printWriter.println("\\pard\\intbl\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b {\\rtlch \\ltrch\\f0\\fs16\\i0\\b Name}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b {\\rtlch \\ltrch\\f0\\fs16\\i0\\b Datum}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b {\\rtlch \\ltrch\\f0\\fs16\\i0\\b SA V.A.}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b {\\rtlch \\ltrch\\f0\\fs16\\i0\\b SA N.A}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b {\\rtlch \\ltrch\\f0\\fs16\\i0\\b EV}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b {\\rtlch \\ltrch\\f0\\fs16\\i0\\b EP}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b {\\rtlch \\ltrch\\f0\\fs16\\i0\\b NV}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b {\\rtlch \\ltrch\\f0\\fs16\\i0\\b GF}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b {\\rtlch \\ltrch\\f0\\fs16\\i0\\b GRZW}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b {\\rtlch \\ltrch\\f0\\fs16\\i0\\b EGK}");
        printWriter.println("\\cell\\row\\pard");
        printWriter.println("\\trowd\\trql\\trleft-70\\trkeep\\trrh300\\trpaddft3\\trpaddt70\\trpaddfl3\\trpaddl70\\trpaddfb3\\trpaddb70\\trpaddfr3\\trpaddr70\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx1392\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx2507\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx2785\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx3656\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx4526\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx5397\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx6268\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx7139\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx8010\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx8881\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clpadfl3\\clpadl0\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clpadfb3\\clpadb0\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\clvertalc\\cellx9752");
        printWriter.println("\\pard\\intbl\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b {\\rtlch \\ltrch\\f0\\fs16\\i0\\b [m]}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b {\\rtlch \\ltrch\\f0\\fs16\\i0\\b [m]}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b {\\rtlch \\ltrch\\f0\\fs16\\i0\\b [%]}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b {\\rtlch \\ltrch\\f0\\fs16\\i0\\b [m]}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b {\\rtlch \\ltrch\\f0\\fs16\\i0\\b [m]}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b {\\rtlch \\ltrch\\f0\\fs16\\i0\\b [m]}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs16\\ab\\ltrch\\dbch\\fs16\\b\\fs16\\b {\\rtlch \\ltrch\\f0\\fs16\\i0\\b [m]}");
        printWriter.println("\\cell\\row\\pard");
        printWriter.println("\\trowd\\trql\\trleft-70\\trkeep\\trpaddft3\\trpaddt0\\trpaddfl3\\trpaddl70\\trpaddfb3\\trpaddb0\\trpaddfr3\\trpaddr70\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx1392\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx2507\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx2785\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx3656\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx4526\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx5397\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx6268\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx7139\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx8010\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx8881\\clbrdrt\\brdrs\\brdrw1\\brdrcf1\\clbrdrl\\brdrs\\brdrw1\\brdrcf1\\clbrdrb\\brdrs\\brdrw1\\brdrcf1\\clbrdrr\\brdrs\\brdrw1\\brdrcf1\\cellx9752");
        printWriter.println("\\pard\\intbl\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs12\\ltrch\\dbch\\fs12\\fs12 {\\rtlch \\ltrch\\f0\\fs12\\i0\\b0 1}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs12\\ltrch\\dbch\\fs12\\fs12 {\\rtlch \\ltrch\\f0\\fs12\\i0\\b0 2}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs12\\ltrch\\dbch\\fs12\\fs12 {\\rtlch \\ltrch\\f0\\fs12\\i0\\b0 3}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs12\\ltrch\\dbch\\fs12\\fs12 {\\rtlch \\ltrch\\f0\\fs12\\i0\\b0 4}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs12\\ltrch\\dbch\\fs12\\fs12 {\\rtlch \\ltrch\\f0\\fs12\\i0\\b0 5}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs12\\ltrch\\dbch\\fs12\\fs12 {\\rtlch \\ltrch\\f0\\fs12\\i0\\b0 6}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs12\\ltrch\\dbch\\fs12\\fs12 {\\rtlch \\ltrch\\f0\\fs12\\i0\\b0 7}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs12\\ltrch\\dbch\\fs12\\fs12 {\\rtlch \\ltrch\\f0\\fs12\\i0\\b0 8}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs12\\ltrch\\dbch\\fs12\\fs12 {\\rtlch \\ltrch\\f0\\fs12\\i0\\b0 9}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs12\\ltrch\\dbch\\fs12\\fs12 {\\rtlch \\ltrch\\f0\\fs12\\i0\\b0 10}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\s1\\qc\\rtlch\\afs12\\ltrch\\dbch\\fs12\\fs12 {\\rtlch \\ltrch\\f0\\fs12\\i0\\b0 11}");
        printWriter.println("\\cell\\row\\pard \\pard\\plain \\s28\\tqc\\tx4536\\tqr\\tx9072\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20");
        printWriter.println("\\par \\pard\\plain \\s1\\rtlch\\afs24\\ltrch\\dbch\\fs24\\fs24");
        printWriter.println(EOF);
    }

    private void writePage2TableLine(PrintWriter printWriter, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        printWriter.println("\\trowd\\trql\\trleft-70\\trkeep\\trpaddft3\\trpaddt0\\trpaddfl3\\trpaddl70\\trpaddfb3\\trpaddb0\\trpaddfr3\\trpaddr70\\cellx1392\\cellx2507\\cellx2785\\cellx3656\\cellx4526\\cellx5397\\cellx6268\\cellx7139\\cellx8010\\cellx8881\\cellx9752");
        printWriter.println("\\pard\\intbl\\pard\\plain \\intbl\\ltrpar\\s1\\keepn\\ql\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20 {\\rtlch \\ltrch\\f0\\fs20\\i0\\b0 " + string + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\ltrpar\\s1\\keepn\\ql\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20 {\\rtlch \\ltrch\\f0\\fs20\\i0\\b0 " + string2 + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\ltrpar\\s1\\qc\\keepn\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20 {\\rtlch \\ltrch\\f0\\fs20\\i0\\b0 " + string3 + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\ltrpar\\s1\\qc\\keepn\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20 {\\rtlch \\ltrch\\f0\\fs20\\i0\\b0 " + string4 + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\ltrpar\\s1\\qc\\keepn\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20 {\\rtlch \\ltrch\\f0\\fs20\\i0\\b0 " + string5 + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\ltrpar\\s1\\qc\\keepn\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20 {\\rtlch \\ltrch\\f0\\fs20\\i0\\b0 " + string6 + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\ltrpar\\s1\\qc\\keepn\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20 {\\rtlch \\ltrch\\f0\\fs20\\i0\\b0 " + string7 + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\ltrpar\\s1\\qc\\keepn\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20 {\\rtlch \\ltrch\\f0\\fs20\\i0\\b0 " + string8 + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\ltrpar\\s1\\qc\\keepn\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20 {\\rtlch \\ltrch\\f0\\fs20\\i0\\b0 " + string9 + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\ltrpar\\s1\\qc\\keepn\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20 {\\rtlch \\ltrch\\f0\\fs20\\i0\\b0 " + string10 + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\ltrpar\\s1\\qc\\keepn\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20 {\\rtlch \\ltrch\\f0\\fs20\\i0\\b0 " + string11 + "}");
        printWriter.println("\\cell\\row\\pard");
    }

    private void writePage2TableLine(PrintWriter printWriter, String string, String string2, String string3, String string4) {
        printWriter.println("\\trowd\\trql\\trleft-70\\trkeep\\trpaddft3\\trpaddt0\\trpaddfl3\\trpaddl70\\trpaddfb3\\trpaddb0\\trpaddfr3\\trpaddr70\\cellx1392\\cellx2507\\cellx2785\\cellx9752");
        printWriter.println("\\pard\\intbl\\pard\\plain \\intbl\\ltrpar\\s1\\keepn\\ql\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20 {\\rtlch \\ltrch\\f0\\fs20\\i0\\b0 " + string + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\ltrpar\\s1\\keepn\\ql\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20 {\\rtlch \\ltrch\\f0\\fs20\\i0\\b0 " + string2 + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\ltrpar\\s1\\qc\\keepn\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20 {\\rtlch \\ltrch\\f0\\fs20\\i0\\b0 " + string3 + "}");
        printWriter.println("\\cell\\pard\\plain \\intbl\\ltrpar\\s1\\keepn\\ql\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20 {\\rtlch \\ltrch\\f0\\fs20\\i0\\b0 " + string4 + "}");
        printWriter.println("\\cell\\row\\pard");
    }

    private void writePage2TableLine(PrintWriter printWriter, String string) {
        printWriter.println("\\trowd\\trql\\trleft-70\\trkeep\\trpaddft3\\trpaddt0\\trpaddfl3\\trpaddl70\\trpaddfb3\\trpaddb0\\trpaddfr3\\trpaddr70\\cellx9752");
        printWriter.println("\\pard\\intbl\\pard\\plain \\intbl\\ltrpar\\s1\\keepn\\ql\\rtlch\\afs20\\ltrch\\dbch\\fs20\\fs20 {\\rtlch \\ltrch\\f0\\fs20\\i0\\b0\\b  " + string + "}");
        printWriter.println("\\cell\\row\\pard \\pard\\plain \\ltrpar\\s1\\ql\\rtlch\\afs24\\ltrch\\dbch\\fs24\\fs24");
    }
}

