/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot.io;

import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.IFileInputException;
import de.geocalc.kafplot.io.IPolarReader;
import de.geocalc.kafplot.io.PolarMessung;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class StmReader
extends IPolarReader {
    private static final double RO = 63.66197723675813;
    int anzZpk = 0;
    private PolarMessung st = new PolarMessung();

    public StmReader(File file, Vector vector) {
        super(file, vector, null);
    }

    public StmReader(File file, Vector vector, IProgressViewer iProgressViewer) {
        super(file, vector, iProgressViewer);
    }

    @Override
    protected PolarMessung lineToPolarMessung(String string) throws IOException, IFileInputException {
        PolarMessung polarMessung = new PolarMessung();
        int n = 0;
        try {
            n = Integer.parseInt(string.substring(0, 2));
        }
        catch (Exception exception) {
            return null;
        }
        switch (n) {
            case 40: 
            case 42: 
            case 43: {
                this.st = this.readStandpunkt(this.st, string);
                this.anzZpk = 0;
                return null;
            }
            case 30: 
            case 32: 
            case 34: 
            case 41: 
            case 44: 
            case 45: 
            case 47: {
                polarMessung = this.readMessung(polarMessung, string);
                polarMessung.pns = this.anzZpk == 0 ? this.st.pns : 0L;
                if (polarMessung.r == 0.0 && this.anzZpk > 0) {
                    throw new IFileInputException("Null-Richtung im Richtungssatz");
                }
                if (polarMessung.pns == 0L && this.anzZpk == 0) {
                    throw new IFileInputException("Fehlender Standpunkt");
                }
                ++this.anzZpk;
                return polarMessung;
            }
        }
        return null;
    }

    private PolarMessung readStandpunkt(PolarMessung polarMessung, String string) throws IFileInputException {
        try {
            polarMessung.pns = Long.parseLong(string.substring(2, 19).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Punktnummer");
        }
        return polarMessung;
    }

    private PolarMessung readMessung(PolarMessung polarMessung, String string) throws IFileInputException {
        try {
            polarMessung.pnz = Long.parseLong(string.substring(2, 19).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Punktnummer");
        }
        try {
            polarMessung.s = new Double(string.substring(30, 38).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Strecke");
        }
        try {
            polarMessung.r = new Double(string.substring(38, 46).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Richtung");
        }
        try {
            polarMessung.z = new Double(string.substring(46, 54).trim());
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Zenit");
        }
        try {
            polarMessung.s += new Double(string.substring(61, 68).trim()).doubleValue();
            polarMessung.r += 63.66197723675813 * Math.atan2(new Double(string.substring(68, 75).trim()), polarMessung.s);
        }
        catch (Exception exception) {
            throw new IFileInputException("Element Exzentrum");
        }
        return polarMessung;
    }
}

